/*---------------------------------------------------------------------------*
  Project:  DP WiFi Library
  File:     dpw_tr.h

  Copyright 2003-2006 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $NoKeywords: $
 *---------------------------------------------------------------------------*/

/*! @file
	@brief	DP WiFi Trade Cu
	
	@author	kitayama(kitayama_shigetoshi@nintendo.co.jp)
	@author	Yamaguchi Ryo(yamaguchi_ryo@nintendo.co.jp)
	
*/

#ifndef DPW_TR_H_
#define DPW_TR_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _NITRO
#include <dwc.h>
#else
#include <nitro.h>
#include <dwc.h>
#endif

#include "include/libdpw/dpw_common.h"
/*-----------------------------------------------------------------------*
					^E萔錾
 *-----------------------------------------------------------------------*/

//! ÕTCY
#define DPW_TR_NAME_SIZE 8

//! Dpw_Tr_DownloadMatchDataAsync() Ŏ擾\ȃf[^̍ől
#define DPW_TR_DOWNLOADMATCHDATA_MAX	7

//! Dpw_Tr_Callback ̌ʂG[ƂȂꍇ̎
typedef enum {
	DPW_TR_ERROR_SERVER_FULL = -1,		//!< T[o[eʃI[o[
	DPW_TR_ERROR_SERVER_TIMEOUT = -2,	//!< T[o[̉Ȃ
	DPW_TR_ERROR_NO_DATA = -3,			//!< T[oɃf[^݂ȂBf[^𕜌ĂB
	DPW_TR_ERROR_DATA_TIMEOUT = -4,		//!< af[^̃^CAEgB^}S߂ĂB
	DPW_TR_ERROR_ILLIGAL_REQUEST = -5,	//!< T[oւ̕sȗvBɗaĂ̂ɗa悤ƂƂȂǁB
	DPW_TR_ERROR_ILLEGAL_DATA = -6,		//!< Abv[hꂽf[^ĂB
	DPW_TR_ERROR_CHEAT_DATA = -7,		//!< Abv[hꂽf[^s
	DPW_TR_ERROR_NG_POKEMON_NAME = -8,	//!< Abv[hꂽ|P̖ONG[h܂ł
	DPW_TR_ERROR_NG_PARENT_NAME = -9,	//!< Abv[hꂽ|P̐e̖ONG[h܂ł
	DPW_TR_ERROR_NG_MAIL_NAME = -10,	//!< Abv[hꂽ[̖ONG[h܂ł
	DPW_TR_ERROR_NG_OWNER_NAME = -11,	//!< Abv[hꂽlNG[h܂ł
	DPW_TR_ERROR_CANCEL	= -12,			//!<  Dpw_Tr_CancelAsync() ɂăLZꂽB
	DPW_TR_ERROR_FATAL = -13,			//!< ʐMvIG[Bd̍ēKvł
	DPW_TR_ERROR_DISCONNECTED = -14,	//!< ʐMs\G[BCȕKvłB
	DPW_TR_ERROR_FAILURE = -15			//!< ʐMsG[BgCĂ
} DpwTrError;

//! T[o[Xe[^X
typedef enum {
	DPW_TR_STATUS_SERVER_OK,				//!< 
	DPW_TR_STATUS_SERVER_STOP_SERVICE,		//!< T[rXꎞ~
	DPW_TR_STATUS_SERVER_FULL				//!< T[o[eʃI[o[
} DpwTrServerStatus;

//! \
typedef struct {
	u16 year;	//!< N
	u8 month;	//!< 
	u8 day;		//!< 
	u8 hour;	//!< 
	u8 minutes;	//!< 
	u8 sec;		//!< b
	u8 padding;	// pfBO
} Dpw_Tr_Date;

//! |P̐
typedef enum {
	DPW_TR_GENDER_MALE = 1,		//!< IX
	DPW_TR_GENDER_FEMALE = 2,	//!< X
	DPW_TR_GENDER_NONE = 3		//!< ʂȂBɐʂȂ悤ɂ邽߂ɂ́A̒lw肵ĂB
} Dpw_Tr_PokemonGender;

//! |Pf[^̃T[o[p\
typedef struct {
	s16 characterNo;	//!< LN^ԍ
	s8 gender;			//!< ʁB Dpw_Tr_PokemonGender ̒lɂȂB
	s8 level;			//!< xB
} Dpw_Tr_PokemonDataSimple;

//! |Pf[^̃T[o[\
typedef struct {
	s16 characterNo;	//!< LN^ԍ
	s8 gender;			//!< ʁB Dpw_Tr_PokemonGender ̒lɂȂB
	s8 level_min;		//!< x̉B0͎wȂA1`100͂̃xȏ̃|PƂӖɂȂB
	s8 level_max;		//!< x̏B0͎wȂA1`100͂̃xȉ̃|PƂӖɂȂB
	s8 padding;			// pfBO
} Dpw_Tr_PokemonSearchData;

//! |P̃f[^Bf[^̓e͌mȂ
typedef struct {
	u8 data[236];		//!< |P̃f[^
} Dpw_Tr_PokemonData;

//! Dpw_TrCuŃT[o[Ƃ肳郁Cf[^\
typedef struct {
	Dpw_Tr_PokemonData postData;			//!< uav|P̏ڍ׃f[^
	Dpw_Tr_PokemonDataSimple postSimple;	//!< uav|P̊ȗf[^iT[o[pj
	Dpw_Tr_PokemonSearchData wantSimple;	//!< uقv|P̊ȗf[^iT[o[pj
	u8 gender;								//!< l̐
	u8 padding;								// pfBO
	Dpw_Tr_Date postDate;					//!< aiT[o[ɂăZbgj
	Dpw_Tr_Date tradeDate;					//!< iT[o[ɂăZbgj
	s32 id;									//!< ̃f[^IDiT[o[ɂăZbgj
	u16 name[DPW_TR_NAME_SIZE];				//!< l
	u16 trainerID;							//!< g[i[ID
	u8 countryCode;							//!< Zł鍑R[h
	u8 localCode;							//!< ZłnR[h
	u8 trainerType;							//!< g[i[^Cv
	s8 isTrade;								//!< ς݃tOiT[o[ɂăZbgj
	u8 versionCode;							//!< o[WR[h
	u8 langCode;							//!< R[h
} Dpw_Tr_Data;


/*-----------------------------------------------------------------------*
					O[oϐ`
 *-----------------------------------------------------------------------*/



/*-----------------------------------------------------------------------*
					֐O錾
 *-----------------------------------------------------------------------*/

extern void Dpw_Tr_Init(s32 pid, u64 friend_key);
extern void Dpw_Tr_Main(void);
extern void Dpw_Tr_End(void);
extern BOOL Dpw_Tr_IsAsyncEnd(void);
extern s32 Dpw_Tr_GetAsyncResult(void);
extern void Dpw_Tr_UploadAsync(const Dpw_Tr_Data* data);
extern void Dpw_Tr_UploadFinishAsync(void);
extern void Dpw_Tr_DownloadAsync(Dpw_Tr_Data* data);
extern void Dpw_Tr_GetUploadResultAsync(Dpw_Tr_Data* data);
extern void Dpw_Tr_DeleteAsync(void);
extern void Dpw_Tr_ReturnAsync(void);
extern void Dpw_Tr_CancelAsync(void);
extern void Dpw_Tr_DownloadMatchDataAsync(const Dpw_Tr_PokemonSearchData* searchData, s32 maxNum, Dpw_Tr_Data* downloadData);
extern void Dpw_Tr_TradeAsync(s32 id, const Dpw_Tr_Data* uploadData, Dpw_Tr_Data* downloadData);
extern void Dpw_Tr_TradeFinishAsync(void);
extern void Dpw_Tr_GetServerStateAsync(void);
extern void Dpw_Tr_SetProfileAsync(const Dpw_Common_Profile* data, Dpw_Common_ProfileResult* result);

BOOL Dpw_Tr_Db_InitServer(void);
BOOL Dpw_Tr_Db_UpdateServer(void);
BOOL Dpw_Tr_Db_ShuffleServerData(void);


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // DPW_TR_H_