/*---------------------------------------------------------------------------*
  Project:  DP WiFi Library
  File:     dpwi_session.h

  Copyright 2003-2006 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $NoKeywords: $
 *---------------------------------------------------------------------------*/

/*! @file
	@brief	session manager
	
	@author	Yuki Hayashi(hayashi_yuki@nintendo.co.jp)
	
	@version
		@li
*/

#ifndef _DPWI_COMMON_SESSION_H_
#define _DPWI_COMMON_SESSION_H_

#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------------------------------------------------*
					^E萔錾
 *-----------------------------------------------------------------------*/

//!< ZbVXe[^X
typedef enum{
	DPWI_COMMON_SESSION_STATE_CANCELED,			//!< LZ
	DPWI_COMMON_SESSION_STATE_ERROR,			//!< G[<
	DPWI_COMMON_SESSION_STATE_INITIAL,			//!< 
	DPWI_COMMON_SESSION_STATE_REQUEST,			//!< NGXgs
	DPWI_COMMON_SESSION_STATE_GETTING_TOKEN,	//!< g[N擾
	DPWI_COMMON_SESSION_STATE_GOT_TOKEN,		//!< g[N擾
	DPWI_COMMON_SESSION_STATE_SENDING_DATA,		//!< f[^M
	DPWI_COMMON_SESSION_STATE_COMPLETED			//!< 
}DpwiSessionState;

//!< ֐Ԃl
typedef enum{

	DPWI_COMMON_SESSION_SUCCESS,				//!< I
	DPWI_COMMON_SESSION_ERROR_NOTINITIALIZED,	//!< 
	DPWI_COMMON_SESSION_ERROR_NOMEMORY			//!< [s

}DpwiSessionResult;

typedef enum{

	DPWI_COMMON_SESSION_ERROR_IN_ERROR,				//!<  0: G[ 
	DPWI_COMMON_SESSION_ERROR_INVALID_POST,			//!<  1: ȑM 
	DPWI_COMMON_SESSION_ERROR_INSUFFICIENT_MEMORY,	//!<  2: s 
	DPWI_COMMON_SESSION_ERROR_INVALID_FILE_NAME,	//!<  3: ȃt@C 
	DPWI_COMMON_SESSION_ERROR_INVALID_BUFFER_SIZE,	//!<  4: ȃobt@TCY 
	DPWI_COMMON_SESSION_ERROR_INVALID_URL,			//!<  5: URL
	DPWI_COMMON_SESSION_ERROR_UNSPECIFIED_ERROR,	//!<  6: ̑̃G[

	DPWI_COMMON_SESSION_ERROR_SUCCESS,				//!<  7: t@C擾 
	DPWI_COMMON_SESSION_ERROR_OUT_OF_MEMORY,		//!<  8: 蓖Ďs 
	DPWI_COMMON_SESSION_ERROR_BUFFER_OVERFLOW,		//!<  9: ꂽobt@邽߁At@C̎擾s 
	DPWI_COMMON_SESSION_ERROR_PARSE_URL_FAILED,		//!< 10: URL̓G[ 
	DPWI_COMMON_SESSION_ERROR_HOST_LOOKUP_FAILED,	//!< 11: zXgs 
	DPWI_COMMON_SESSION_ERROR_SOCKET_FAILED,		//!< 12: \Pbg̍쐬AAǂݏoAݎs 
	DPWI_COMMON_SESSION_ERROR_CONNECT_FAILED,		//!< 13: HTTPT[oւ̐ڑs 
	DPWI_COMMON_SESSION_ERROR_BAD_RESPONSE,			//!< 14: HTTPT[õX|X̉̓G[ 
	DPWI_COMMON_SESSION_ERROR_REQUEST_REJECTED,		//!< 15: HTTPT[õNGXg 
	DPWI_COMMON_SESSION_ERROR_UNAUTHORIZED,			//!< 16: t@C擾 
	DPWI_COMMON_SESSION_ERROR_FORBIDDEN,			//!< 17: HTTPT[õt@CM 
	DPWI_COMMON_SESSION_ERROR_FILE_NOT_FOUND,		//!< 18: HTTPT[õt@Cs 
	DPWI_COMMON_SESSION_ERROR_SERVER_ERROR,			//!< 19: HTTPT[oG[ 
	DPWI_COMMON_SESSION_ERROR_FILE_WRITE_FAILED,	//!< 20: [Jt@Cւ̏݃G[ 
	DPWI_COMMON_SESSION_ERROR_FILE_READ_FAILED,		//!< 21: [Jt@C̓ǂݏoG[ 
	DPWI_COMMON_SESSION_ERROR_FILE_INCOMPLETE,		//!< 22: _E[h̒f 
	DPWI_COMMON_SESSION_ERROR_FILE_TOO_BIG,			//!< 23: t@C傫邽߃_E[hs\ 
	DPWI_COMMON_SESSION_ERROR_ENCRYPTION_ERROR,		//!< 24: ÍG[ 
	DPWI_COMMON_SESSION_ERROR_MEMORY_ERROR,			//!< 25: 蓖Ďs 

	DPWI_COMMON_SESSION_ERROR_CHECKSUM,				//!< 26: COMMONw: `FbNT̕sv
	DPWI_COMMON_SESSION_ERROR_PID,					//!< 27: COMMONw: PID̕sv
	DPWI_COMMON_SESSION_ERROR_DATA_LENGTH, 			//!< 28: COMMONw: f[^̒s
	DPWI_COMMON_SESSION_ERROR_TOKEN_NOT_FOUND,		//!< 29: COMMONw: g[NȂ
	DPWI_COMMON_SESSION_ERROR_TOKEN_EXPIRED,		//!< 30: COMMONw: g[N̗L؂
	DPWI_COMMON_SESSION_ERROR_INCORRECT_HASH,		//!< 31: COMMONw: nbVȂ
	DPWI_COMMON_SESSION_ERROR_BUFFER_OVER			//!< 32: COMMONw: Mobt@I[o[

}DpwiHttpError;

/*-----------------------------------------------------------------------*
					֐vg^Cv錾
 *-----------------------------------------------------------------------*/

void DpwiSessionInitialize( void );
void DpwiSessionShutdown( void );
void DpwiSessionCancel( void );
DpwiSessionState DpwiSessionThink( void );
DpwiSessionResult DpwiSessionRequest(	const u8* url,
										int pid,
										const void* data,
										int len,
										u8* resbuf,
										int buflen );
DpwiHttpError DpwiGetLastError( void );
int DpwiGetResponseSize( void );


#ifdef __cplusplus
}
#endif

#endif
