/*---------------------------------------------------------------------------*
  Project:  simple particle library
  File:     spl_field.h

  tB[hi^nւ̉eyڂ́j

  ̂SPLField̔z񂩉stB[h̎ޖ
  ߂Ă̂ł͌ȂƂƂŁA
  ֐|C^ƃLXgŏs`ɁAAA

  Revision 1.3  2005/11/09 09:53:26  matsuda
  SPLCuXVꂽ̂ōXV

  Revision 1.7  2005/03/17 08:27:13  okane_shinji
  (none)

  Revision 1.6.2.1  2005/03/04 05:55:36  okane_shinji
  (none)

  Revision 1.6  2004/11/26 06:07:31  okane_shinji
  @\ǉ

  Revision 1.5  2004/07/02 06:24:03  okane_shinji
  (none)

  Revision 1.4  2004/07/02 06:21:37  okane_shinji
  Wǉ

  Revision 1.3  2004/07/02 01:11:24  okane_shinji
  ֐EϐOύX

  Revision 1.2  2004/07/02 00:07:45  okane_shinji
  VvRWtB[hƈʒuZ}OlbgtB[hǉ

  Revision 1.1  2004/04/08 00:23:26  konoh
  (none)

 *---------------------------------------------------------------------------*/

#ifndef __SPL_FIELD_H__
#define __SPL_FIELD_H__

#include "spl_particle.h"

struct SPLEmitter ;

/* \ ------------------------------------------------------------------ */

// tB[h\
typedef struct SPLField
{
    void (*p_exec)(const void*, SPLParticle*, VecFx32*, struct SPLEmitter* p_emtr );
    const void* p_obj;
} SPLField;

// d̓tB[h
typedef struct SPLGravity
{
    VecFx16 mag;
    u16 reserved0;
} SPLGravity;

// _tB[h
typedef struct SPLRandom
{
    VecFx16 mag;
    u16 intvl;
} SPLRandom;

// }OlbgtB[h
typedef struct SPLMagnet
{
    VecFx32 pos;
    fx16    mag;
    u16     reserved0;
} SPLMagnet;

// XstB[h
typedef struct SPLSpin
{
    u16 radian;
    u16 axis_type;
} SPLSpin;

// VvRWtB[h
typedef struct SPLSimpleCollisionField
{
    fx32 y ; // CxgNyʂ̒l
    fx16 coeff_bounce ;
    
    struct
    {
        u16 eventtype:2 ;
        u16 global:1 ;
        u16 reserved:13 ;
    } etc ;
} SPLSimpleCollisionField ;

// ʒuɉZtB[hi}Olbg̈j
typedef struct SPLConvergence
{
    VecFx32 pos  ; // z񂹂ꏊ
    fx16    ratio; // z񂹂鋭
    u16     reserved0;
} SPLConvergence ;



/* ------------------------------------------------------------------------- */


/* `Ȃ ---------------------------------------------------------------- */

#define SPL_FLD_TYPE_NUM  6 // tB[h̎ TODO:6

#define SPL_FLD_SPIN_AXIS_TYPE_X   0
#define SPL_FLD_SPIN_AXIS_TYPE_Y   1
#define SPL_FLD_SPIN_AXIS_TYPE_Z   2


// VvRWtB[h̃Cxg^Cv
#define SPL_FLD_SCF_EVENTTYPE_CESSER     0
#define SPL_FLD_SCF_EVENTTYPE_REFLECTION 1



/* ------------------------------------------------------------------------- */


/* etB[h ------------------------------------------------------ */

extern void spl_calc_gravity(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
extern void spl_calc_random(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
extern void spl_calc_magnet(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
extern void spl_calc_spin(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
extern void spl_calc_scfield(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );
extern void spl_calc_convergence(const void* p_obj, SPLParticle* p_ptcl, VecFx32* p_acc, struct SPLEmitter* p_emtr );


/* ------------------------------------------------------------------------- */

#endif
