//==============================================================================
/**
 *
 *@file		boxdata.h
 *@brief	|P{bNXf[^Ǘ
 *@author	taya
 *@data		2005.09.8
 *
 */
//==============================================================================
#ifndef __BOXDATA_H__
#define __BOXDATA_H__

#include  "system\savedata_def.h"
#include  "gflib\strbuf.h"
#include  "poketool\poke_tool.h"	// POKEMON_PASO_PARAM QƂ̂

//------------------------------------------------------------
/**
 * @brief	{bNXf[^QƗpsS^|C^
 *
 *   ̃|C^oRŏs
 */
//------------------------------------------------------------
typedef struct _BOX_DATA	BOX_DATA;

//------------------------------------------------------------
/**
 *   萔
 */
//------------------------------------------------------------
#define BOX_MAX_RAW				(5)
#define BOX_MAX_COLUMN			(6)
#define BOX_MAX_TRAY			(18)
#define BOX_TRAYNAME_MAXLEN		(8)
#define BOX_TRAYNAME_BUFSIZE	(20)	// {W{EOMBCOŗp̗]TĂ̒xB
#define BOX_MAX_POS				(BOX_MAX_RAW*BOX_MAX_COLUMN)


#define BOX_NORMAL_WALLPAPER_MAX	(16)
#define BOX_EX_WALLPAPER_MAX		(8)
#define BOX_TOTAL_WALLPAPER_MAX		(BOX_NORMAL_WALLPAPER_MAX+BOX_EX_WALLPAPER_MAX)

#define BOXDAT_TRAYNUM_CURRENT		(0xffffffff)	///< gCio[Ɏ֐Ŏw肷ƁAJgw肵ƂɂȂB
#define BOXDAT_TRAYNUM_ERROR		(BOX_MAX_TRAY)	///< 󂫂̂gCT[`ŁAȂȂǂ̖߂l


extern BOX_DATA * SaveData_GetBoxData(SAVEDATA * sv);

//------------------------------------------------------------------
/**
 * {bNXf[^̈쐬iZ[uf[^ǂݍݎɂP񂾂j
 *
 * @param   heapID		쐬q[vhc
 *
 * @retval  BOX_DATA*	쐬ꂽ{bNXf[^̃|C^
 */
//------------------------------------------------------------------
extern BOX_DATA* BOXDAT_Create( u32 heapID );


//------------------------------------------------------------------
/**
 * {bNXf[^̓e
 *
 * @param   boxdat		{bNXf[^̃|C^
 */
//------------------------------------------------------------------
extern void BOXDAT_Init( BOX_DATA* boxdat );

//------------------------------------------------------------------
/**
 * {bNXf[^̈̑TCYԂiZ[uf[^Ǘpj
 *
 * @retval  u32		{bNXf[^TCY
 */
//------------------------------------------------------------------
extern u32 BOXDAT_GetTotalSize( void );


//------------------------------------------------------------------
/**
 * {bNXŜ炩󂫗̈Tă|Pf[^i[
 *
 * @param   box			{bNXf[^|C^
 * @param   poke		|Pf[^
 *
 * @retval  BOOL		TRUE=i[ꂽ^FALSE=󂫂
 */
//------------------------------------------------------------------
extern BOOL BOXDAT_PutPokemon( BOX_DATA* box, POKEMON_PASO_PARAM* poke );

//------------------------------------------------------------------
/**
 * {bNXw肵ă|Pf[^i[
 *
 * @param   box			{bNXf[^|C^
 * @param   boxNum		Ԗڂ̃{bNXɊi[邩
 * @param   poke		|Pf[^
 *
 * @retval  BOOL		TRUE=i[ꂽ^FALSE=󂫂
 */
//------------------------------------------------------------------
extern BOOL BOXDAT_PutPokemonBox( BOX_DATA* box, u32 boxNum, POKEMON_PASO_PARAM* poke );

//------------------------------------------------------------------
/**
 * {bNXAʒuw肵ă|Pf[^i[
 *
 * @param   box			{bNXf[^|C^
 * @param   boxNum		Ԗڂ̃{bNXɊi[邩
 * @param   x			{bNẌʒuw
 * @param   y			{bNẌʒux
 * @param   poke		|Pf[^
 *
 * @retval  BOOL		TRUE=i[ꂽ^FALSE=󂫂
 */
//------------------------------------------------------------------
extern BOOL BOXDAT_PutPokemonPos( BOX_DATA* box, u32 boxNum, u32 pos, POKEMON_PASO_PARAM* poke );


//------------------------------------------------------------------
/**
 * Pł󂫂̂gCio[ԂiJg猟Jnj
 *
 * @param   box		{bNXf[^|C^
 *
 * @retval  u32		󂫂̂gCio[^Ȃ BOXDAT_TRAYNUM_ERROR Ԃ
 */
//------------------------------------------------------------------
extern u32 BOXDAT_GetEmptyTrayNumber( const BOX_DATA* box );


//------------------------------------------------------------------
/**
 * ʒuw肵ăJg{bNX̃|Pf[^NA
 *
 * @param   box			{bNXf[^|C^
 * @param   trayNumber	Ԗڂ̃{bNX
 * @param   pos			{bNẌʒu
 *
 */
//------------------------------------------------------------------
extern void BOXDAT_ClearPokemon( BOX_DATA* box, u32 trayNum, u32 pos );

//------------------------------------------------------------------
/**
 * {bNXŜɊ܂܂|PԂ
 *
 * @param   box		{bNXf[^|C^
 *
 * @retval  u32		
 */
//------------------------------------------------------------------
extern u32 BOXDAT_GetPokeExistCountTotal( const BOX_DATA* box );
extern u32 BOXDAT_GetPokeExistCount2Total( const BOX_DATA* box );

extern u32 BOXDAT_GetEmptySpaceTotal( const BOX_DATA* box );
extern u32 BOXDAT_GetEmptySpaceTray( const BOX_DATA* box, u32 trayNum );

extern u32 BOXDAT_GetCureentTrayNumber( const BOX_DATA* box );
extern void BOXDAT_SetCureentTrayNumber( BOX_DATA* box, u32 num );
extern u32 BOXDAT_GetWallPaperNumber( const BOX_DATA* box, u32 trayNumber );
extern void BOXDAT_SetWallPaperNumber( BOX_DATA* box, u32 trayNum, u32 wallPaperNumber );
extern void BOXDAT_GetBoxName( const BOX_DATA* box, u32 trayNumber, STRBUF* buf );
extern void BOXDAT_SetBoxName( BOX_DATA* box, u32 trayNumber, const STRBUF* src );
extern u32 BOXDAT_GetPokeExistCount( const BOX_DATA* box, u32 trayNumber );
extern u32 BOXDAT_GetPokeExistCount2( const BOX_DATA* box, u32 trayNumber );
extern POKEMON_PASO_PARAM* BOXDAT_GetPokeDataAddress( const BOX_DATA* box, u32 boxNum, u32 pos );
extern BOOL BOXDAT_GetEmptyTrayNumberAndPos( const BOX_DATA* box, int* trayNum, int* pos );
extern u32 BOXDAT_PokeParaGet( const BOX_DATA* box, u32 trayNum, u32 pos, int param, void* buf );
extern void BOXDAT_PokeParaPut( BOX_DATA* box, u32 trayNum, u32 pos, int param, void* buf );


//==============================================================================================
// Nuǎ
//==============================================================================================
extern void BOXDAT_SetDaisukiKabegamiFlag( BOX_DATA* box, u32 number );
extern BOOL BOXDAT_GetDaisukiKabegamiFlag( const BOX_DATA* box, u32 number );
extern u32  BOXDAT_GetDaiukiKabegamiCount( const BOX_DATA* box );

#endif
