//============================================================================================
/**
 * @file	poke_regulation.h
 * @brief	M[VpvO
 * @author	k.ohno
 * @date	2006.5.25
 */
//============================================================================================
#ifndef __POKE_REGULATION_H__
#define __POKE_REGULATION_H__

#include "poketool/poke_tool.h"
#include "savedata/regulation.h"
#include "application/zukanlist/zkn_height_gram.h"

// PokeRegulationMatchPartialPokePartyPokeRegulationMatchFullPokeParty ̖߂l
enum{
    POKE_REG_OK,               // 
    POKE_REG_TOTAL_LV_FAILED,  // g[^LVI[o[Ă
    POKE_REG_BOTH_POKE,        // |P
    POKE_REG_BOTH_ITEM,        // ACe
//--------------------------------------------------------
    POKE_REG_NUM_FAILED,       // Kvȃ|P̐lĂȂ
    POKE_REG_ILLEGAL_POKE,     // ɍȂ|P
};

extern ZKN_HEIGHT_GRAM_PTR PokeRegulationInit(int heap_id );
// |PM[VɓKĂ邩ǂׂA}ӂj
extern void PokeRegulationEnd(ZKN_HEIGHT_GRAM_PTR pZKN);
// |PM[VɓKĂ邩ǂׂ  
extern BOOL PokeRegulationCheckPokePara(const REGULATION* pReg, POKEMON_PARAM* pp, ZKN_HEIGHT_GRAM_PTR pZKN);
// |Pp[eBM[VɊSKĂ邩ǂׂ ogŏI`FbNp
extern int PokeRegulationMatchFullPokeParty(const REGULATION* pReg, POKEPARTY * party,
                                            const ZKN_HEIGHT_GRAM_PTR pZKN, u8* sel);
// |Pp[eBɃM[VɓKĂ
//  p[eB[g߂邩ǂׂ KÕ|PĂv  󂯕tp
extern int PokeRegulationMatchPartialPokeParty(const REGULATION* pReg, POKEPARTY * party,ZKN_HEIGHT_GRAM_PTR pZKN);

#endif// __POKE_REGULATION_H__
