//============================================================================================
/**
 * @file	pokeicon.h
 * @bfief	|PACR֘A
 * @author	Hiroyuki Nakamura
 * @date	05.09.16
 */
//============================================================================================
#ifndef POKEICON_H
#define POKEICON_H

#include "poketool\poke_tool.h"

#undef GLOBAL
#ifdef POKEICON_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
// fILVXp`
enum {
	PICON_DEOKISISU_N = 0,		// m[}tH
	PICON_DEOKISISU_A,			// A^bNtH
	PICON_DEOKISISU_D,			// fBtFXtH
	PICON_DEOKISISU_S			// Xs[htH
};

// Am[p`
enum {
	PICON_ANNOON_A = 0,			// A
	PICON_ANNOON_B,				// B
	PICON_ANNOON_C,				// C
	PICON_ANNOON_D,				// D
	PICON_ANNOON_E,				// E
	PICON_ANNOON_F,				// F
	PICON_ANNOON_G,				// G
	PICON_ANNOON_H,				// H
	PICON_ANNOON_I,				// I
	PICON_ANNOON_J,				// J
	PICON_ANNOON_K,				// K
	PICON_ANNOON_L,				// L
	PICON_ANNOON_M,				// M
	PICON_ANNOON_N,				// N
	PICON_ANNOON_O,				// O
	PICON_ANNOON_P,				// P
	PICON_ANNOON_Q,				// Q
	PICON_ANNOON_R,				// R
	PICON_ANNOON_S,				// S
	PICON_ANNOON_T,				// T
	PICON_ANNOON_U,				// U
	PICON_ANNOON_V,				// V
	PICON_ANNOON_W,				// W
	PICON_ANNOON_X,				// X
	PICON_ANNOON_Y,				// Y
	PICON_ANNOON_Z,				// Z
	PICON_ANNOON_EXQ,			// !
	PICON_ANNOON_QUE,			// ?
};

// AjEFCg擾p[^
enum {
	POKEICON_HP_MAX = 0,
	POKEICON_HP_GREEN,
	POKEICON_HP_YERROW,
	POKEICON_HP_RED,
	POKEICON_HP_NULL
};

// Aj
enum {
	POKEICON_ANM_DEATH = 0,		// m
	POKEICON_ANM_HPMAX,			// HP MAX
	POKEICON_ANM_HPGREEN,		// HP 
	POKEICON_ANM_HPYERROW,		// HP 
	POKEICON_ANM_HPRED,			// HP 
	POKEICON_ANM_STCHG,			// Ԉُ
};

#define	POKEICON_PAL_MAX	( 3 )	// ACRŎgppbg

#define POKEICON_SIZE_X		(32)	// ACR̉TCY
#define POKEICON_SIZE_Y		(32)	// ACȐcTCY

//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * L̃A[JCuCfbNX擾 ( POKEMON_PASO_PARAM  )
 *
 * @param	ppp			POKEMON_PASO_PARAM
 *
 * @return	A[JCuCfbNX
 *
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconCgxArcIndexGet( const POKEMON_PASO_PARAM* ppp );

//--------------------------------------------------------------------------------------------
/**
 * L̃A[JCuCfbNX擾 ( POKEMON_PARAM  )
 *
 * @param	pp			POKEMON_PARAM
 *
 * @return	A[JCuCfbNX
 *
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconCgxArcIndexGetByPP( POKEMON_PARAM * pp );

//--------------------------------------------------------------------------------------------
/**
 * L̃A[JCuCfbNX擾
 *
 * @param	mons		|Pԍ
 * @param	egg			^}StO
 * @param	pat			gp^[
 *
 * @return	A[JCuCfbNX
 *
 *	pat̓fILVXAm[Ɏgp
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconCgxArcIndexGetByMonsNumber( u32 mons, u32 egg, u32 pat );

//--------------------------------------------------------------------------------------------
/**
 * L̊gp^[io[擾i擾io[PokeIconCgxArcIndexGetByMonsNöƂĎgj
 *
 * @param   ppp		
 *
 * @retval  u16		gp^[io[
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 PokeIconCgxPatternGet( const POKEMON_PASO_PARAM* ppp );

//--------------------------------------------------------------------------------------------
/**
 * pbgԍ擾
 *
 * @param	mons		|Pԍ
 * @param	form		tHԍ
 * @param	egg			^}StO
 *
 * @return	pbgԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL const u8 PokeIconPalNumGet( u32 mons, u32 form, u32 egg );

//--------------------------------------------------------------------------------------------
/**
 * pbgԍ擾iPOKEMON_PASO_PARAMŁj
 *
 * @param	ppp		POKEMON_PASO_PARAM
 *
 * @return	pbgԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL const u8 PokeIconPalNumGetByPPP( const POKEMON_PASO_PARAM * ppp );

//--------------------------------------------------------------------------------------------
/**
 * pbgԍ擾iPOKEMON_PARAMŁj
 *
 * @param	pp		POKEMON_PARAM
 *
 * @return	pbgԍ
 */
//--------------------------------------------------------------------------------------------
GLOBAL const u8 PokeIconPalNumGetByPP( POKEMON_PARAM * pp );

//--------------------------------------------------------------------------------------------
/**
 * pbg̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconPalArcIndexGet(void);

//--------------------------------------------------------------------------------------------
/**
 * Z̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconCellArcIndexGet(void);

//--------------------------------------------------------------------------------------------
/**
 * Z̃A[JCuCfbNX擾iAjj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconAnmCellArcIndexGet(void);

//--------------------------------------------------------------------------------------------
/**
 * Z̃A[JCuCfbNX擾i64k,Ajj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIcon64kCellArcIndexGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ZAj̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconCellAnmArcIndexGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ZAj̃A[JCuCfbNX擾iAjj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIconAnmCellAnmArcIndexGet(void);

//--------------------------------------------------------------------------------------------
/**
 * ZAj̃A[JCuCfbNX擾i64k,Ajj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PokeIcon64kCellAnmArcIndexGet(void);


#undef GLOBAL
#endif	// POKEICON_H
