/**
 *	@file	b_tower.h
 *	@brief	og^[֘A@Z[uf[^
 *	@author	Miyuki Iwasawa
 *	@date	06.04.14
 */

#ifndef __H_B_TOWER_H__
#define __H_B_TOWER_H__

#include "b_tower_def.h"

/**
 * @brief	og^[@vCf[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _BTLTOWER_PLAYWORK	BTLTOWER_PLAYWORK;

/**
 * @brief	og^[@XRAf[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _BTLTOWER_SCOREWORK	BTLTOWER_SCOREWORK;

/**
 * @brief	og^[@vC[bZ[Wf[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _BTLTOWER_PLAYER_MSG	BTLTOWER_PLAYER_MSG;

/**
 * @brief	og^[@WIFI|Pf[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
//typedef struct _BTLTOWER_POKE	BTLTOWER_POKE;
/**
 * @brief	og^[@WIFIvC[f[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _BTLTOWER_WIFI_PLAYER	BTLTOWER_WIFI_PLAYER;
/**
 * @brief	og^[@WIFI[_[f[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
//typedef struct _BTLTOWER_WIFI_LEADER	BTLTOWER_WIFI_LEADER;


/**
 * @brief	og^[@WIFIf[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _BTLTOWER_WIFI_DATA	BTLTOWER_WIFI_DATA;


/**
 *	@brief	og^[@ubNf[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _BTLTOWER_SAVEWORK	BTLTOWER_SAVEWORK;

/**
 * ^[|Pf[^^
 * @battle/b_tower_data.hKvȉӏȊOł
 *	includeȂōςނ悤ɒ`Ă
 */
typedef struct _B_TOWER_POKEMON	B_TOWER_POKEMON;

/**
 * ^[p[gi[f[^^
 * @battle/b_tower_data.hKvȉӏȊOł
 *	includeȂōςނ悤ɒ`Ă
 */
typedef struct _B_TOWER_PARTNER_DATA	B_TOWER_PARTNER_DATA;

/**
 * @brief	og^[@WIFI[_[f[^\̂ւ̕sS^|C^
 *  battle/b_tower_data.hKvȉӏȊOł
 *	includeȂōςނ悤ɒ`Ă
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _B_TOWER_LEADER_DATA	B_TOWER_LEADER_DATA;

/**
 *	@biref	^[AI}`yA̕ۑKvȃ|Pp[^
 *	
 *  battle/b_tower_data.hKvȉӏȊOł
 *	includeȂōςނ悤ɒ`Ă
 */
typedef struct _B_TOWER_PAREPOKE_PARAM B_TOWER_PAREPOKE_PARAM;


/**
 *	@brief	og^[ WIFICu\̂ւ̕sS|C^
 *	WifiCuwb_OɔJɂĂ߂ɒ`
 */
typedef struct Dpw_Bt_PokemonData	DPW_BT_POKEMON_DATA;
typedef struct Dpw_Bt_Player	DPW_BT_PLAYER;
typedef struct Dpw_Bt_Leader	DPW_BT_LEADER;
typedef struct Dpw_Bt_Room		DPW_BT_ROOM;

/**
 *	@biref	og^[ WIFI[f[^ID(rankroomno)
 *
 *	Nƃ[io[擾Ƃ悤̌J\̃f[^^
 */
typedef struct{
	u8	rank;	//[N(1-10)
	u8	no;		//[No(1-200)
}BTOWER_ROOMID;

//========================================================
//Z[uf[^ANZX
//========================================================

#ifdef GLOBAL
#undef GLOBAL
#endif

#ifdef _B_TOWER_H_GLOBAL
#define GLOBAL	/***/
#else
#define GLOBAL	extern
#endif

///[NTCY擾NA
//////////////////////////////////
/**
 *	@brief	^[@vCf[^TCY
 */
GLOBAL int TowerPlayData_GetWorkSize(void);

/**
 *	@brief	^[@vC[XRAf[^TCY
 */
GLOBAL int	TowerSocreData_GetWorkSize(void);

/**
 *	@brief	^[@|Pf[^TCY
 */
GLOBAL int TowerWifiPoke_GetWorkSize(void);

/**
 *	@brief	^[@Wifif[^TCY
 */
GLOBAL int	TowerWifiData_GetWorkSize(void);
/**
 *	@brief@^[ Wifi/g[i[[hvC[f[^\̃f[^TCY
 */
GLOBAL int TowerDpwBtPlayer_GetWorkSize(void);

/**
 *	@brief	^[@vCf[^NA
 */
GLOBAL void TowerPlayData_Clear(BTLTOWER_PLAYWORK* dat);

/**
 *	@brief	^[	XRAf[^NA
 */
GLOBAL void TowerScoreData_Clear(BTLTOWER_SCOREWORK* dat);

/**
 *	@brief	^[@vC[bZ[Wf[^NA
 */
GLOBAL void TowerPlayerMsg_Clear(BTLTOWER_PLAYER_MSG* dat);

/**
 *	@brief	^[@Wifif[^NA
 */
GLOBAL void TowerWifiData_Clear(BTLTOWER_WIFI_DATA* dat);

///ubNf[^ANZXn
/////////////////////////////////
/**
 *	@brief	^[@Z[uf[^ubNTCY擾
 */
GLOBAL int TowerData_GetWorkSize(void);

/**
 *	@brief	^[@Z[uf[^ubN
 */
GLOBAL void TowerData_Init(BTLTOWER_SAVEWORK* save);

/**
 *	@brief	^[@vCf[^ւ̃|C^擾
 */
GLOBAL BTLTOWER_PLAYWORK* SaveData_GetTowerPlayData(SAVEDATA* sv);

/**
 *	@brief	^[@XRAf[^ւ̃|C^擾
 */
GLOBAL BTLTOWER_SCOREWORK* SaveData_GetTowerScoreData(SAVEDATA* sv);

/**
 *	@brief	^[ Wifif[^ւ̃|C^擾	
 */
GLOBAL BTLTOWER_WIFI_DATA*	SaveData_GetTowerWifiData(SAVEDATA* sv);

////////////////////////////////////////////////////////////
//vCf[^擾n
////////////////////////////////////////////////////////////
/**
 *	@brief	vCf[^@擾
 *
 *	@param	dat	BTLTOWRE_PLAYWORK*
 *	@param	id	擾f[^ID BTOWER_PSD_ID^
 *	@param	buf	void*:f[^擾|C^
 */
GLOBAL u32	TowerPlayData_Get(BTLTOWER_PLAYWORK* dat,BTWR_PSD_ID id,void* buf);

/**
 *	@brief	vCf[^@Zbg
 *	
 *	@param	dat	BTLTOWRE_PLAYWORK*
 *	@param	id	擾f[^ID BTOWER_PSD_ID^
 *	@param	buf	void*:f[^i[obt@ւ̃|C^
 */
GLOBAL void TowerPlayData_Put(BTLTOWER_PLAYWORK* dat,BTWR_PSD_ID id,const void* buf);

/**
 *	@brief vCf[^@WifiR[hf[^Add	
 *
 *	@param	down	|ꂽ|Pǉ
 *	@param	turn	^[ǉ
 *	@param	damage	󂯂_[Wǉl
 */
GLOBAL void TowerPlayData_WifiRecordAdd(BTLTOWER_PLAYWORK* dat,u8 down,u16 turn,u16 damage);

/**
 *	@brief	vCf[^@Z[uς݂ǂH
 *
 *	@retval	TRUE	Z[uĂ
 *	@retval FALSE	Z[uĂȂ
 */
GLOBAL BOOL TowerPlayData_GetSaveFlag(BTLTOWER_PLAYWORK* dat);
/**
 *	@brief	vCf[^@Z[uԃtOZbg
 */
GLOBAL void TowerPlayData_SetSaveFlag(BTLTOWER_PLAYWORK* dat,BOOL flag);


///XRAf[^擾n
/////////////////////////////////////////////////

/**
 *	@brief	XRAf[^ og|CgZbg
 *
 *	LR}h set/get/add/sub
 */
GLOBAL u16 TowerScoreData_SetBattlePoint(BTLTOWER_SCOREWORK* dat,u16 num,BTWR_DATA_SETID mode);

/**
 *	@brief	SAVEDATAog|CgGet
 */
static inline u16 BattlePoint_Get(SAVEDATA* sv)
{
	return TowerScoreData_SetBattlePoint(SaveData_GetTowerScoreData(sv),0,BTWR_DATA_get);
}
/**
 *	@brief	SAVEDATAog|CgSet
 */
static inline u16 BattlePoint_Set(SAVEDATA* sv,u16 num)
{
	return TowerScoreData_SetBattlePoint(SaveData_GetTowerScoreData(sv),num,BTWR_DATA_set);
}
/**
 *	@brief	SAVEDATAog|CgAdd
 */
static inline u16	BattlePoint_Add(SAVEDATA* sv,u16 num)
{
	return TowerScoreData_SetBattlePoint(SaveData_GetTowerScoreData(sv),num,BTWR_DATA_add);
}
/**
 *	@brief	SAVEDATAog|CgSub
 */
static inline u16	BattlePoint_Sub(SAVEDATA* sv,u16 num)
{
	return TowerScoreData_SetBattlePoint(SaveData_GetTowerScoreData(sv),num,BTWR_DATA_sub);
}

/**
 *	@brief	XRAf[^@WifiAsJEg
 *
 *	LR}h get/reset/inc
 *
 *	@return	̃JEg
 */
GLOBAL u8 TowerScoreData_SetWifiLoseCount(BTLTOWER_SCOREWORK* dat,BTWR_DATA_SETID mode);

/**
 *	@brief	XRAf[^@WifiN
 *
 *	LR}h get/reset/inc/dec
 */
GLOBAL u8	TowerScoreData_SetWifiRank(BTLTOWER_SCOREWORK* dat,BTWR_DATA_SETID mode);

/**
 *	@brief	gp|Pf[^ۑ
 */
GLOBAL void TowerScoreData_SetUsePokeData(BTLTOWER_SCOREWORK* dat,
				BTWR_SCORE_POKE_DATA mode,B_TOWER_POKEMON* poke);
/**
 *	@brief	gp|Pf[^obt@ɃRs[Ď擾(WiFi\̃f[^^)
 */
GLOBAL void TowerScoreData_GetUsePokeDataDpw(BTLTOWER_SCOREWORK* dat,
			BTWR_SCORE_POKE_DATA mode,DPW_BT_POKEMON_DATA* poke);

/**
 *	@brief	gp|Pf[^obt@ɃRs[Ď擾
 */
GLOBAL void TowerScoreData_GetUsePokeData(BTLTOWER_SCOREWORK* dat,
			BTWR_SCORE_POKE_DATA mode,B_TOWER_POKEMON* poke);


/**
 *	@brief	XRAf[^@񐔑
 */
GLOBAL u16 TowerScoreData_SetStage(BTLTOWER_SCOREWORK* dat,u16 id,BTWR_DATA_SETID mode);

#ifdef PM_DEBUG
/**
 *	@brief	fobO@݂̃Xe[Wl𒼐ڃZbg
 */
GLOBAL u16 TowerScoreData_DebugSetStageValue(BTLTOWER_SCOREWORK* dat,u16 id,u16 value);
#endif	//PM_DEBUG
/**
 *	@brief	XRAf[^ Wifiё
 */
GLOBAL u16	TowerScoreData_SetWifiScore(BTLTOWER_SCOREWORK* dat,BTLTOWER_PLAYWORK *playdata);

/**
 *	@brief	XRAf[^@Wifi0NA
 */
GLOBAL void TowerScoreData_ClearWifiScore(BTLTOWER_SCOREWORK* dat);

/**
 *	@brief	XRAf[^@Wifiю擾
 */
GLOBAL u16	TowerScoreData_GetWifiScore(BTLTOWER_SCOREWORK* dat);

/**
 *	@brief	XRAf[^珟擾
 */
GLOBAL u8	TowerScoreData_GetWifiWinNum(BTLTOWER_SCOREWORK* dat);

/**
 *	@brief	XRAf[^ tOGAZbg
 *
 *	LR}hFreset/set/get
 */
GLOBAL BOOL TowerScoreData_SetFlags(BTLTOWER_SCOREWORK* dat,u16 id,BTWR_DATA_SETID mode);

/**
 *	@brief	^[ptω_V[hۑ
 */
GLOBAL void TowerScoreData_SetDayRndSeed(BTLTOWER_SCOREWORK* dat,u32 rnd_seed);

/**
 *	@brief	^[ptω_V[h擾
 */
GLOBAL u32 TowerScoreData_GetDayRndSeed(BTLTOWER_SCOREWORK* dat);


//=======================================================
//@^[@vC[bZ[Wf[^ANZXn
//=======================================================
/**
 *	@brief	ȈՉbf[^Zbg
 */
GLOBAL void TowerPlayerMsg_Set(SAVEDATA* sv,BTWR_PLAYER_MSG_ID id,PMS_DATA* src);

/**
 *	@brief	ȈՉbf[^擾
 */
GLOBAL PMS_DATA* TowerPlayerMsg_Get(SAVEDATA* sv,BTWR_PLAYER_MSG_ID id);

//=======================================================
//@^[@Wifif[^ANZXn
//=======================================================
/**
 *	@brief	w肵[f[^̎擾tO𗧂Ă
 *
 *	@param	rank	1IWȂ̂Œ
 *	@param	roomno	1IWȂ̂Œ
 */
GLOBAL void TowerWifiData_SetRoomDataFlag(BTLTOWER_WIFI_DATA* dat,
		u8 rank,u8 roomno,RTCDate *day);

/**
 *	@brief	[f[^擾tONA
 */
GLOBAL void TowerWifiData_ClearRoomDataFlag(BTLTOWER_WIFI_DATA* dat);

/**
 *	@brief	w肵[DLtOĂ邩`FbN
 *
 *	@param	rank	1IWȂ̂Œ
 *	@param	roomno	1IWȂ̂Œ
 */
GLOBAL BOOL TowerWifiData_CheckRoomDataFlag(BTLTOWER_WIFI_DATA* dat,u8 rank,u8 roomno,RTCDate* day);


/**
 *	@brief	vC[f[^݂邩`FbN
 */
GLOBAL BOOL TowerWifiData_IsPlayerDataEnable(BTLTOWER_WIFI_DATA* dat);

/**
 *	@brief	[_[f[^邩ǂ`FbN
 */
GLOBAL BOOL TowerWifiData_IsLeaderDataEnable(BTLTOWER_WIFI_DATA* dat);

/**
 *	@brief	vC[f[^Z[u
 *	
 *	@param	rank	1IWȂ̂Œ
 *	@param	roomno	1IWȂ̂Œ
 */
GLOBAL void TowerWifiData_SetPlayerData(BTLTOWER_WIFI_DATA* dat,DPW_BT_PLAYER* src,u8 rank,u8 roomno);

/**
 *	@brief	vC[f[^NA
 */
GLOBAL void TowerWifiData_ClearPlayerData(BTLTOWER_WIFI_DATA* dat);

/**
 *	@brief	vC[f[^RoomID(NroomNo)擾
 *
 *	@param	roomid	BTOWER_ROOMID^(b_tower.hŌJ)
 */
GLOBAL void TowerWifiData_GetPlayerDataRoomID(BTLTOWER_WIFI_DATA* dat,BTOWER_ROOMID *roomid);

/**
 *	@brief	vC[f[^^[퓬pɉ
 */
GLOBAL void TowerWifiData_GetBtlPlayerData(BTLTOWER_WIFI_DATA* dat,
		B_TOWER_PARTNER_DATA* player,const u8 round);

/**
 *	@brief	[_[f[^Z[u
 *	
 *	@param	rank	1IWȂ̂Œ
 *	@param	roomno	1IWȂ̂Œ
 */
GLOBAL void TowerWifiData_SetLeaderData(BTLTOWER_WIFI_DATA* dat,DPW_BT_LEADER* src,u8 rank,u8 roomno);

/**
 *	@brief	[_[f[^NA
 */
GLOBAL void TowerWifiData_ClearLeaderData(BTLTOWER_WIFI_DATA* dat);

/**
 *	@brief	[_[f[^RoomID(NroomNo)擾
 *
 *	@param	roomid	BTOWER_ROOMID^(b_tower.hŌJ)
 */
GLOBAL void TowerWifiData_GetLeaderDataRoomID(BTLTOWER_WIFI_DATA* dat,BTOWER_ROOMID *roomid);

/**
 *	@brief	[_[f[^AllocɃRs[Ď擾
 *
 *	Alloc̈Ԃ̂ŁAĂяoIɉ邱ƁI
 */
GLOBAL B_TOWER_LEADER_DATA* TowerWifiData_GetLeaderDataAlloc(BTLTOWER_WIFI_DATA* dat,int heapID) ;




#endif	//__H_B_TOWER_H__
