//============================================================================================
/**
 * @file	config.h
 * @brief	ݒf[^ANZXpwb_
 * @author	tamada GAME FREAK inc.
 * @date	2006.01.26
 */
//============================================================================================
#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ݒf[^^`
 */
//----------------------------------------------------------
typedef struct _CONFIG CONFIG;

//---------------------------------------------------------------------------
/**
 * @brief	ݒf[^\̒`
 *
 * ̍\̂̃o[ɓȂǁA₷邽߂ɌJB
 * Aւ̃ANZX͕KANZX֐oR݂̂ɂ邱ƁB
 */
//---------------------------------------------------------------------------
struct _CONFIG {
	u16 msg_speed:4;			///<MSGSPEED		lrf̑x
	u16 sound_mode:2;			///<SOUNDMODE		TEho
	u16 battle_rule:1;			///<BATTLERULE		퓬[
	u16 wazaeff_mode:1;			///<WAZAEFF_MODE	킴GtFNg
	u16 input_mode:2;			///<INPUTMODE		̓[h
	u16 window_type:5;			///<WINTYPE			EBhE^Cv
	u16 dummy:1;
};

//----------------------------------------------------------
/**
 */
//----------------------------------------------------------
typedef enum {
	MSGSPEED_SLOW = 0,		///<bZ[W\uv
	MSGSPEED_NORMAL,		///<bZ[W\uӂv
	MSGSPEED_FAST,			///<bZ[W\u͂₢v
	MSGSPEED_MAX,			///<
}MSGSPEED;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	WAZAEFF_MODE_ON = 0,		///<퓬Aju݂v
	WAZAEFF_MODE_OFF,			///<퓬Aju݂Ȃv
	WAZAEFF_MODE_MAX,			///<
}WAZAEFF_MODE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	BATTLERULE_IREKAE = 0,
	BATTLERULE_KACHINUKI,
	BATTLERULE_MAX,
}BATTLERULE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	SOUNDMODE_STEREO = 0,	///<TEho=uXeIv
	SOUNDMODE_MONO,			///<TEho=umv
//	SOUNDMODE_HEADPHONE,	///<TEho=uwbhzv06.02.14p~ iwasawa
	SOUNDMODE_MAX,			///<
}SOUNDMODE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum {
	INPUTMODE_NORMAL = 0,	///<{^ݒ聁um[}v
	INPUTMODE_START_X,		///<{^ݒ聁uSTART=Xv
//	INPUTMODE_X_Y,			///<{^ݒ聁uXYv06.05.30p~
	INPUTMODE_L_A,			///<{^ݒ聁uL=Av06.07.12p~ 07.19
	INPUTMODE_MAX,			///<
}INPUTMODE;

//----------------------------------------------------------
//----------------------------------------------------------
typedef enum{
	WINTYPE_01,
	WINTYPE_02,
	WINTYPE_03,
	WINTYPE_04,
	WINTYPE_05,
	WINTYPE_06,
	WINTYPE_07,
	WINTYPE_08,
	WINTYPE_09,
	WINTYPE_10,
	WINTYPE_11,
	WINTYPE_12,
	WINTYPE_13,
	WINTYPE_14,
	WINTYPE_15,
	WINTYPE_16,
	WINTYPE_17,
	WINTYPE_18,
	WINTYPE_19,
	WINTYPE_20,
	WINTYPE_MAX,
}WINTYPE;

//============================================================================================
//============================================================================================
//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
extern int CONFIG_GetWorkSize(void);
extern CONFIG * CONFIG_AllocWork(u32 heapID);
extern void CONFIG_Copy(const CONFIG * from, CONFIG * to);

//----------------------------------------------------------
//	CONFIĜ߂̊֐
//----------------------------------------------------------
extern void CONFIG_Init(CONFIG * cfg);

/**
 *	@brief	L[RtBOQ[ɔf
 */
extern void config_SetKeyConfig(SAVEDATA* sv,INPUTMODE mode);
static inline void CONFIG_SetKeyConfigFormSave(SAVEDATA* sv)
{
	config_SetKeyConfig(sv,0);
}
static inline void CONFIG_SetKeyConfig(INPUTMODE mode)
{
	config_SetKeyConfig(NULL,mode);
}

//	͂Ȃ̂͂₳
extern MSGSPEED CONFIG_GetMsgSpeed(const CONFIG * cfg);
extern void CONFIG_SetMsgSpeed(CONFIG * cfg, MSGSPEED speed);
extern u8 CONFIG_GetMsgPrintSpeed( const CONFIG * cfg );

//	Ƃ@Aj
extern WAZAEFF_MODE CONFIG_GetWazaEffectMode(const CONFIG * cfg);
extern void CONFIG_SetWazaEffectMode(CONFIG * cfg, WAZAEFF_MODE mode);

//	́@[
extern BATTLERULE CONFIG_GetBattleRule(const CONFIG * cfg);
extern void CONFIG_SetBattleRule(CONFIG * cfg, BATTLERULE rule);

//	TEh
extern SOUNDMODE CONFIG_GetSoundMode(const CONFIG * cfg);
extern void CONFIG_SetSoundMode(CONFIG * cfg, SOUNDMODE snd_mode);

//	{^[h
extern INPUTMODE CONFIG_GetInputMode(const CONFIG * cfg);
extern void CONFIG_SetInputMode(CONFIG * cfg, INPUTMODE mode);

//	EBhE^Cv
extern WINTYPE CONFIG_GetWindowType(const CONFIG * cfg);
extern void CONFIG_SetWindowType(CONFIG * cfg, WINTYPE type);

//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern CONFIG * SaveData_GetConfig(SAVEDATA * sv);

//----------------------------------------------------------
//	fobOpf[^̂߂̊֐
//----------------------------------------------------------
//extern void Debug_Config_Make(CONFIG * cfg, const STRCODE * name, int sex);

#endif //__CONFIG_H__
