
#ifndef	__CUSTOM_BALL_H__
#define	__CUSTOM_BALL_H__

#include "system/savedata_def.h"


// Ƃ肠AZ[üfix̂ߕKvȂ̂`
#define CB_DEF_SEAL_MAX				(8)			///< \閇
#define CB_DEF_CORE_MAX				(12)		///< JX^{[̐
#define CB_DEF_ITEM_DATA_NUM_MAX	(80)		///< V[̎
#define CB_DEF_ITEM_DATA_NUM		(80 + 1)	//(80)		///< V[̎
#define CB_DEF_SEAL_STOCK_MAX		(99)		///< V[ő吔

#define CB_DEF_INDEX_ORIGIN			(1)			///< index ̊Jn (0 =  ň̂ 1 )


enum {
	CB_ENUM_SEAL_ID_000 = 0,	///< ĂȂ
	CB_ENUM_SEAL_ID_001,
};
#define CB_DEF_SEAL_NONE	(CB_ENUM_SEAL_ID_000)		///< V[ĂȂ


///< custom
typedef struct _CUSTOM_BALL_SEAL		CB_SEAL;		///< V[̃f[^
typedef struct _CUSTOM_BALL_CORE		CB_CORE;		///< JX^{[̃f[^

///< item
typedef struct _CUSTOM_BALL_ITEM_DATA	CB_ITEM_DATA;	///< ACef[^

///< save
typedef struct _CUSTOM_BALL_SAVE_DATA	CB_SAVE_DATA;	///< Z[uf[^ custom/core ܂


// -----------------------------------------
//
//	 V[̃f[^
//
// -----------------------------------------
struct _CUSTOM_BALL_SEAL {
	
	u8	seal_id;		///< V[ԍ
	u8	x;				///< x W
	u8	y;				///< y W
	
};


// -----------------------------------------
//
//	 JX^{[̃f[^(|P̎莝ێ)
//
// -----------------------------------------
struct _CUSTOM_BALL_CORE {

	CB_SEAL	cb_seal[ CB_DEF_SEAL_MAX ];

};

#if 0
///< item
struct _CUSTOM_BALL_ITEM_DATA {
	
	u8	seal[ CB_DEF_ITEM_DATA_NUM ];
	
};


///< save
struct _CUSTOM_BALL_SAVE_DATA {
	
	CB_CORE			cb_core[ CB_DEF_CORE_MAX ];

	CB_ITEM_DATA	cb_item;
	
};
#endif

// =============================================================================
//
//
//	֐
//
//
// =============================================================================
extern int				CustomBall_GetWorkSize(void);								///< Z[ü̃TCY擾
extern CB_SAVE_DATA*	CustomBall_AllocSaveData(u32 heap_id);						///< Z[üm
extern void				CustomBall_Init(CB_SAVE_DATA* csd);							///< 


///< ANZX֐ --- custom
extern CB_SAVE_DATA*	CB_SaveData_AllDataGet(SAVEDATA* sv);						///< Z[uf[^擾

extern CB_CORE*			CB_SaveData_CoreDataGet(CB_SAVE_DATA* save, int no);
extern void				CB_SaveData_CoreDataSet(CB_SAVE_DATA* save, CB_CORE* core, int no);

extern CB_SEAL*			CB_SaveData_SealDataGet(CB_CORE* core, int no);
extern void				CB_SaveData_SealDataSet(CB_CORE* core, CB_SEAL* seal, int no);

extern u8				CB_SaveData_SealIDGet(const CB_SEAL* seal);						///< w肳ꂽV[ID擾
extern void				CB_SaveData_SealIDSet(CB_SEAL* seal, u8 id);					///< w肳ꂽV[IDݒ

extern u8				CB_SaveData_SealPXGet(const CB_SEAL* seal);						///< w肳ꂽV[X擾
extern void				CB_SaveData_SealPXSet(CB_SEAL* seal, u8 id);					///< w肳ꂽV[Xݒ

extern u8				CB_SaveData_SealPYGet(const CB_SEAL* seal);						///< w肳ꂽV[Y擾
extern void				CB_SaveData_SealPYSet(CB_SEAL* seal, u8 id);					///< w肳ꂽV[Yݒ


///< ANZX֐ --- item
extern CB_ITEM_DATA*	CB_SaveData_ItemDataGet(CB_SAVE_DATA* save);					///< ACef[^S

extern u8				CB_SaveData_ItemTypeGet(const CB_ITEM_DATA* save, int no);		///< ACe^Cv擾
extern void				CB_SaveData_ItemTypeSet(CB_ITEM_DATA* save, int no, int type);	///< ACe^Cvݒ

extern u8				CB_SaveData_ItemNumGet(const CB_ITEM_DATA* save, int no);		///< ACe擾
extern u8				CB_SaveData_ItemNumGet_CBO(const CB_ITEM_DATA* item, int no);	///< ACe擾
extern void				CB_SaveData_ItemNumSet(CB_ITEM_DATA* save, int no, int stock);	///< ACeݒ
extern void				CB_SaveData_ItemNumAdd(CB_ITEM_DATA* save, int no, s16 stock);	///< ACe

extern BOOL				CB_SaveData_ItemNumAddCheck(CB_SAVE_DATA* save, int no, s16 stock);	///< ACe
extern BOOL				CB_SaveData_ItemNumAddCheck_CBO(CB_SAVE_DATA* save, int no, s16 stock);
extern BOOL				CB_SaveData_IsAddIt(CB_SAVE_DATA* save, int no, s16 stock);			///< ACe`FbN̂


///< c[n
extern void CB_Tool_SaveData_Copy(const CB_SAVE_DATA* from, CB_SAVE_DATA* to);
extern void CB_Tool_CoreData_Copy(const CB_CORE* from, CB_CORE* to);
extern void CB_Tool_SealData_Copy(const CB_SEAL* from, CB_SEAL* to);

extern BOOL CB_Tool_IsSeal(const CB_SAVE_DATA* save, int id);
extern BOOL CB_Tool_IsSealCore(const CB_CORE* cb_core, int id);
extern int CB_Tool_IsSealTotalNum(const CB_SAVE_DATA* save, int id);
extern int CB_Tool_SealCllectionGet(const CB_SAVE_DATA* save);
extern int CB_Tool_SealTotalNumGet(const CB_SAVE_DATA* save, int id);

#ifdef PM_DEBUG

#include "include/poketool/poke_tool.h"

///< fobO֐
enum {
	DEBUG_CB_MODE_CLEAR,			///< 
	DEBUG_CB_MODE_ITEM_FULL = 1,	///< ACeő
	DEBUG_CB_MODE_ITEM_RANDOM,		///< KȃV[p
};

extern void Debug_CB_Set(POKEMON_PARAM* pp);
extern void Debug_CB_SaveData_Sample(CB_SAVE_DATA* save, int mode);
extern void Debug_CB_SaveData_Poke_Sample(SAVEDATA * save, int mode);
#endif

#endif

