//============================================================================================
/**
 * @file	fnote_mem.h
 * @brief	`m[g@f[^Ǘ
 * @author	Hiroyuki Nakamura
 * @date	2006.03.06
 */
//============================================================================================
#ifndef F_NOTE_MEM_H
#define F_NOTE_MEM_H
#undef GLOBAL
#ifdef F_NOTE_MEM_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
// 
#define	FNOTE_TYPE_START		( 0 )	// Jn
#define	FNOTE_TYPE_ACTION		( 1 )	// s
#define	FNOTE_TYPE_POKEMON		( 2 )	// |P
#define	FNOTE_TYPE_TRAINER		( 3 )	// g[i[
#define	FNOTE_TYPE_SIO			( 4 )	// ʐM

// f[^ID
#define	FNOTE_ID_MYHOUSE		( 1 )		// sF
#define	FNOTE_ID_LABO			( 2 )		// sF
#define	FNOTE_ID_POKECENTER		( 3 )		// sF|PZ^[
#define	FNOTE_ID_FDSHOP_BUY		( 4 )		// sFVbvE
#define	FNOTE_ID_FDSHOP_BUY2	( 5 )		// sFVbvEij
#define	FNOTE_ID_FDSHOP_SALE	( 6 )		// sFVbvE
#define	FNOTE_ID_FDSHOP_SALE2	( 7 )		// sFVbvEij
#define	FNOTE_ID_FDSHOP_TRADE	( 8 )		// sFVbvE
#define	FNOTE_ID_GYMBEFORE		( 9 )		// sFWi[_[|Oj
#define	FNOTE_ID_GYMAFTER		( 10 )		// sFWi[_[|j
#define	FNOTE_ID_SITENNOU		( 11 )		// sFlV
#define	FNOTE_ID_CHAMPION		( 12 )		// sF`sI
#define	FNOTE_ID_CITY			( 13 )		// sFX
#define	FNOTE_ID_DUNGEON		( 14 )		// sF_W
#define	FNOTE_ID_BUILD			( 15 )		// sF
#define	FNOTE_ID_GAMECORNER		( 16 )		// sFQ[R[i[
#define	FNOTE_ID_SAFARIZONE		( 17 )		// sFTt@][
#define	FNOTE_ID_ITEMGET		( 18 )		// sFACe擾
/** |PXgƓтɂ邱ƁI **/
#define	FNOTE_ID_IAIGIRI		( 19 )		// sFZE
#define	FNOTE_ID_SORAWOTOBU		( 20 )		// sFZEƂ
#define	FNOTE_ID_NAMINORI		( 21 )		// sFZEȂ݂̂
#define	FNOTE_ID_KAIRIKI		( 22 )		// sFZE肫
#define	FNOTE_ID_KIRIBARAI		( 23 )		// sFZE΂炢
#define	FNOTE_ID_IWAKUDAKI		( 24 )		// sFZE킭
#define	FNOTE_ID_TAKINOBORI		( 25 )		// sFZÊڂ
#define	FNOTE_ID_ROCKCLIMB		( 26 )		// sFZEbNNC
#define	FNOTE_ID_FLASH			( 27 )		// sFZEtbV
#define	FNOTE_ID_TELEPORT		( 28 )		// sFZEe|[g
#define	FNOTE_ID_ANAWOHORU		( 29 )		// sFZEȂق
#define	FNOTE_ID_AMAIKAORI		( 30 )		// sFZE܂
#define	FNOTE_ID_OSYABERI		( 31 )		// sFZEׂi_~[j
#define	FNOTE_ID_MIRUKUNOMI		( 32 )		// sFZE~N̂
#define	FNOTE_ID_TAMAGOUMI		( 33 )		// sFZE^}S

#define	FNOTE_ID_UG_FOSSIL		( 34 )		// sFnEΌ@
#define	FNOTE_ID_UG_BASE		( 35 )		// sFnE閧n

#define	FNOTE_ID_POKEGET		( 1 )		// |PFߊl
#define	FNOTE_ID_POKEDOWN		( 2 )		// |PF|

#define	FNOTE_ID_SB_SINGLE		( 1 )		// ʐMFʐMΐEVO
#define	FNOTE_ID_SB_DOUBLE		( 2 )		// ʐMFʐMΐE_u
#define	FNOTE_ID_SB_MULTI		( 3 )		// ʐMFʐMΐE}`
#define	FNOTE_ID_SB_MIX1		( 4 )		// ʐMFʐMΐE~bNX1vs1
#define	FNOTE_ID_SB_MIX2		( 5 )		// ʐMFʐMΐE~bNX2vs2
#define	FNOTE_ID_U_GREETING		( 6 )		// ʐMFjI[EA
#define	FNOTE_ID_U_POKECHG		( 7 )		// ʐMFjI[E
#define	FNOTE_ID_U_PICTURE		( 8 )		// ʐMFjI[EG
#define	FNOTE_ID_U_MLTCHG		( 9 )		// ʐMFjI[El
#define	FNOTE_ID_U_TRANSCEIVER	( 10 )		// ʐMFjI[EgV[o[
#define	FNOTE_ID_U_BATTLE		( 11 )		// ʐMFjI[Eΐ
#define	FNOTE_ID_RECORD			( 12 )		// ʐMFR[hR[i[
#define	FNOTE_ID_CONTEST		( 13 )		// ʐMFReXg
#define	FNOTE_ID_PORUTO			( 14 )		// ʐMF|g쐬
#define	FNOTE_ID_GTC			( 15 )		// ʐMFGTC
#define	FNOTE_ID_BTLTOWER		( 16 )		// ʐMFog^[

// s
#define	FNOTE_RESULT_WIN		( 0 )	// 
#define	FNOTE_RESULT_LOSE		( 1 )	// 
#define	FNOTE_RESULT_DRAW		( 2 )	// 

// ZCfbNX
#define	FNOTE_IAIGIRI			( FNOTE_ID_IAIGIRI-FNOTE_ID_IAIGIRI )		// 
#define	FNOTE_SORAWOTOBU		( FNOTE_ID_SORAWOTOBU-FNOTE_ID_IAIGIRI )	// Ƃ
#define	FNOTE_NAMINORI			( FNOTE_ID_NAMINORI-FNOTE_ID_IAIGIRI )		// Ȃ݂̂
#define	FNOTE_KAIRIKI			( FNOTE_ID_KAIRIKI-FNOTE_ID_IAIGIRI )		// 肫
#define	FNOTE_KIRIBARAI			( FNOTE_ID_KIRIBARAI-FNOTE_ID_IAIGIRI )		// ΂炢
#define	FNOTE_IWAKUDAKI			( FNOTE_ID_IWAKUDAKI-FNOTE_ID_IAIGIRI )		// 킭
#define	FNOTE_TAKINOBORI		( FNOTE_ID_TAKINOBORI-FNOTE_ID_IAIGIRI )	// ̂ڂ
#define	FNOTE_ROCKCLIMB			( FNOTE_ID_ROCKCLIMB-FNOTE_ID_IAIGIRI )		// bNNC
#define	FNOTE_FLASH				( FNOTE_ID_FLASH-FNOTE_ID_IAIGIRI )			// tbV
#define	FNOTE_TELEPORT			( FNOTE_ID_TELEPORT-FNOTE_ID_IAIGIRI )		// e|[g
#define	FNOTE_ANAWOHORU			( FNOTE_ID_ANAWOHORU-FNOTE_ID_IAIGIRI )		// Ȃق
#define	FNOTE_AMAIKAORI			( FNOTE_ID_AMAIKAORI-FNOTE_ID_IAIGIRI )		// ܂
#define	FNOTE_OSYABERI			( FNOTE_ID_OSYABERI-FNOTE_ID_IAIGIRI )		// ׂi_~[j
#define	FNOTE_MIRUKUNOMI		( FNOTE_ID_MIRUKUNOMI-FNOTE_ID_IAIGIRI )	// ~N̂
#define	FNOTE_TAMAGOUMI			( FNOTE_ID_TAMAGOUMI-FNOTE_ID_IAIGIRI )		// ^}S


#ifndef	__ASM_NO_DEF_	// ȍ~́AAZuł͖
#include "system/savedata_def.h"
#include "system/buflen.h"
#include "savedata/mystatus.h"
#include "savedata/playtime.h"


typedef struct _FNOTE_DATA FNOTE_DATA;

// Jnf[^
typedef struct {
	u32	year:7;		// N
	u32	month:4;	// 
	u32	week:3;		// j
	u32	day:5;		// 
	u32	start:13;	// Jnʒu
}FNOTE_WK_START;

// s[N
typedef struct {
	u8	id;			// zID
	u16	map;		// }bvID
	u16	trainer;	// g[i[ID
	u16	item;		// ACeID
}FNOTE_WK_ACTION;

// |P[N
typedef struct {
	u8	id;			// zID
	u8	type:2;		// \^Cv
	u8	time:4;		// 
	u8	sex:2;		// 
	u16	mons;		// |PID
}FNOTE_WK_POKE;

// g[i[[N
typedef struct {
	u16	id:1;		// zID
	u16	trid:15;	// g[i[ID
	u16	map;		// }bvID
}FNOTE_WK_TRAINER;

// ʐM[N
typedef struct {
	u8	id;									// zID
	u8	result:4;							// s
	u8	sex1:1;								// ʐMP̐
	u8	sex2:1;								// ʐMQ̐
	u8	poke_sex:2;							// |P̐
	u16	name1[BUFLEN_PERSON_NAME];			// ʐMP̖O
	u16	name2[BUFLEN_PERSON_NAME];			// ʐMQ̖O
	u16	nickname[BUFLEN_POKEMON_NAME];		// |P̃jbNl[
}FNOTE_WK_SIO;


#define	FNOTE_PAGE_MAX		( 10 )		///< `m[gy[WMAX
#define	FNOTE_ACTION_MAX	( 4 )		///< `m[gs[N
#define	FNOTE_SIO_MAX		( 2 )		///< `m[gʐM[N



//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * `m[gp[ÑTCY擾
 *
 * @param	none
 *
 * @return	[NTCY
 */
//--------------------------------------------------------------------------------------------
GLOBAL int FNOTE_GetWorkSize(void);

//--------------------------------------------------------------------------------------------
/**
 * `m[gp[NiŚj
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FNOTE_InitAll( FNOTE_DATA * dat );

//--------------------------------------------------------------------------------------------
/**
 * Z[uf[^`m[g̃|C^擾
 *
 * @param	sv		Z[uf[^
 *
 * @return	`m[gf[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL FNOTE_DATA * SaveData_GetFNote( SAVEDATA * sv );

//--------------------------------------------------------------------------------------------
/**
 * Z[uy[W擾
 *
 * @param	dat		Z[uf[^
 * @param	flg		Z[utO ( TRUE =  )
 *
 * @retval	"flg = TRUE : Z[uy[W"
 * @retval	"flg = FALSE : NULL"
 */
//--------------------------------------------------------------------------------------------
GLOBAL FNOTE_DATA * FNOTE_SavePageGet( FNOTE_DATA * dat, BOOL flg );

//--------------------------------------------------------------------------------------------
/**
 * Q[Jn̖`m[g\`FbN
 *
 * @param	dat		Z[uf[^
 * @param	flg		Z[utO ( TRUE =  )
 *
 * @retval	"TRUE = \"
 * @retval	"FALSE = \Ȃ"
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FNOTE_GameStartOpenCheck( FNOTE_DATA * dat, BOOL flg );

//--------------------------------------------------------------------------------------------
/**
 * zZ[u
 *
 * @param	dat		Z[uf[^
 * @param	wk		Z[uf[^
 * @param	type	L^^Cv
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FNOTE_DataSave( FNOTE_DATA * dat, void * wk, u8 type );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ tEJnꏊ ]
 *
 * @param	start	Jnꏊ
 * @param	heap	q[vID
 *
 * @return	쐬[N
 *
 * @li	tRTC擾
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_StartDataMake( u16 start, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sF ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionHouseDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sF ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionLaboDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sF|PZ^[ ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_PokemonCenterDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFVbvE ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionShopBuyDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFVbvEij ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionShopBuy2DataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFVbvE ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionShopSaleDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFVbvEij ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionShopSale2DataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFVbvE ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionShopTradeDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFWi[_[|Oj ]
 *
 * @param	map		}bvID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionGymBeforeDataMake( u16 map, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFWi[_[|j ]
 *
 * @param	map		}bvID
 * @param	trainer	g[i[ID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionGymAfterDataMake( u16 map, u16 trainer, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFlV ]
 *
 * @param	trainer	g[i[ID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionSitenouDataMake( u16 trainer, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sF`sI ]
 *
 * @param	trainer	g[i[ID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionChampionDataMake( u16 trainer, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFX ]
 *
 * @param	map		}bvID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionCityDataMake( u16 map, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sF_W ]
 *
 * @param	map		}bvID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionDungeonDataMake( u16 map, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sF ]
 *
 * @param	map		}bvID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionBuildDataMake( u16 map, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFQ[R[i[ ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionGameCornerDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFTt@][ ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionSafariDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFACe擾 ]
 *
 * @param	item	ACeID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionItemDataMake( u16 item, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFZ ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionSkillDataMake( u8 waza, u16 map, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFnEΌ@ ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionUGFossilDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ sFnE閧n ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_ActionUGBaseDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ |PFߊl ]
 *
 * @param	ptime	vC
 * @param	mons	|PID
 * @param	sex		
 * @param	time	ԑ
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_PokemonGetDataMake(
					const PLAYTIME * ptime, u16 mons, u8 sex, u8 time, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ |PF| ]
 *
 * @param	ptyme	vC
 * @param	mons	|PID
 * @param	sex		
 * @param	time	ԑ
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_PokemonDownDataMake(
					const PLAYTIME * ptime, u16 mons, u8 sex, u8 time, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ g[i[ ]
 *
 * @param	map		}bvID
 * @param	trainer	g[i[ID
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_TrainerDataMake( u16 map, u16 trainer, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFʐMΐEVO ]
 *
 * @param	name	ΐ푊̖O
 * @param	sex		ΐ푊̐
 * @param	result	s
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioSingleBtlDataMake( STRCODE * name, u8 sex, u8 result, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFʐMΐE_u ]
 *
 * @param	name	ΐ푊̖O
 * @param	sex		ΐ푊̐
 * @param	result	s
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioDoubleBtlDataMake( STRCODE * name, u8 sex, u8 result, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFʐMΐE}` ]
 *
 * @param	name1	ΐ푊P̖O
 * @param	name2	ΐ푊Q̖O
 * @param	sex1	ΐ푊P̐
 * @param	sex2	ΐ푊Q̐
 * @param	result	s
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioMultiBtlDataMake(
				 STRCODE * name1, STRCODE * name2, u8 sex1, u8 sex2, u8 result, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFʐMΐE~bNX1vs1 ]
 *
 * @param	name	ΐ푊̖O
 * @param	sex		ΐ푊̐
 * @param	result	s
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioMixBtl1DataMake( STRCODE * name, u8 sex, u8 result, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFʐMΐE~bNX2vs2 ]
 *
 * @param	name1	ΐ푊P̖O
 * @param	name2	ΐ푊Q̖O
 * @param	sex1	ΐ푊P̐
 * @param	sex2	ΐ푊Q̐
 * @param	result	s
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioMixBtl2DataMake(
				 STRCODE * name1, STRCODE * name2, u8 sex1, u8 sex2, u8 result, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFjI[EA ]
 *
 * @param	name	̖O
 * @param	sex		̐
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioUnionGreetDataMake( STRCODE * name, u8 sex, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFjI[E ]
 *
 * @param	name		̖O
 * @param	sex			̐
 * @param	nickname	ł|P̃jbNl[
 * @param	poke_sex	ł|P̐
 * @param	heap		q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioUnionChangeDataMake(
				STRCODE * name, u8 sex, STRCODE * nickname, u8 poke_sex, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFjI[EG ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioUnionPictureDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFjI[El ]
 *
 * @param	nickname	ł|P̃jbNl[
 * @param	poke_sex	ł|P̐
 * @param	heap		q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioUnionMltChgDataMake( STRCODE * nickname, u8 poke_sex, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFjI[EgV[o[ ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioUnionTransceiverDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFjI[Eΐ ]
 *
 * @param	name	ΐ푊̖O
 * @param	sex		ΐ푊̐
 * @param	result	s
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioUnionBattleDataMake( STRCODE * name, u8 sex, u8 result, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFR[hR[i[ ]
 *
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioRecordDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFReXg ]
 *
 * @param	result	
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioContestDataMake( u8 result, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMF|g쐬 ]
 *
 * @param	name	̖O
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioPorutoDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFGTC ]
 *
 * @param	name		̖O
 * @param	sex			̐
 * @param	nickname	ł|P̃jbNl[
 * @param	poke_sex	ł|P̐
 * @param	heap		q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioGTCDataMake(
				STRCODE * name, u8 sex, STRCODE * nickname, u8 poke_sex, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬 [ ʐMFog^[ ]
 *
 * @param	name	̖O
 * @param	heap	q[vID
 *
 * @return	쐬[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FNOTE_SioBattleTowerDataMake( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * zf[^擾
 *
 * @param	dat		Z[uf[^
 * @param	wk		擾ꏊ
 * @param	type	L^^Cv
 * @param	page	擾y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FNOTE_DataGet( FNOTE_DATA * dat, void * wk, u8 type, u8 page );


//--------------------------------------------------------------------------------------------
/**
 * f[^쐬/Z[u [ sFAAA_Wo ]
 *
 * @param	my		v[[f[^
 * @param	dat		`m[g̃Z[uf[^
 * @param	now		݂̃}bv
 * @param	before	Oɂ}bv
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FNOTE_DataMakeSaveMapChg(
				MYSTATUS * my, FNOTE_DATA * dat, u32 now, u32 before, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * Ȍ̕\^Cv擾
 *
 * @param	name	OID
 *
 * @return	\^Cv
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 FNOTE_ExBuildPutTypeGet( u32 name );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬/Z[u [ sFXɓ ]
 *
 * @param	dat		Z[uf[^
 * @param	map		݂̃}bv
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FNOTE_DataMakeSaveCity( FNOTE_DATA * dat, u32 map, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * f[^쐬/Z[u [ sFW[_[A`sIAlV & g[i[Fg[i[ ]
 *
 * @param	dat			`m[g̃Z[uf[^
 * @param	map			][ID
 * @param	trainer		g[i[ID
 * @param	heap		q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FNOTE_DataMakeSaveTrainer( FNOTE_DATA * dat, u16 map, u16 trainer, u32 heap );


#endif	__ASM_NO_DEF_

#undef GLOBAL
#endif	/* F_NOTE_MEM_H */
