//============================================================================================
/**
 * @file	friendlist.h
 * @brief	肠O[vf[^`iWiFIp͕ʁBcrʐMł̒m荇j
 * @author	mori GAME FREAK inc.
 * @date	2006.02.10
 */
//============================================================================================
#ifndef __FRIENDLIST_H__
#define __FRIENDLIST_H__

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "gflib/msg_print.h"		//STRCODEQƂ̂
#include "gflib/strbuf.h"			//STRBUFQƂ̂


#define FRIENDLIST_MAX			( 16 )
#define FRIENDLIST_FRIEND_MAX	( 16 )	// m荇XguFB̗FBv̐


#define DIRECT_FRIEND			(  1 )	// ڂ̒m荇
#define INDIRECT_FRIEND			(  2 )	// m荇̒m荇

#define FRIEND_LIST_SIZE		( 136 )

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	肠O[vf[^^`
 */
//----------------------------------------------------------
typedef struct _FRIEND_LIST FRIEND_LIST;

//============================================================================================
//============================================================================================
//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
extern int           FriendList_GetWorkSize(void);
extern FRIEND_LIST  *FriendList_AllocWork(u32 heapID);
extern void          FriendList_Copy(const FRIEND_LIST * from, FRIEND_LIST * to);

//----------------------------------------------------------
//	FRIEND_LIST̂߂̊֐
//----------------------------------------------------------
extern void  FriendList_Init(FRIEND_LIST * flist);

//O
extern void  FriendList_SetName(FRIEND_LIST * flist, int no, const STRCODE * name);
extern const STRCODE * FriendList_GetName(const FRIEND_LIST * flist, int no);
//ID
extern void FriendList_SetID(FRIEND_LIST * flist, int no, u32 id);
extern u32  FriendList_GetID(const FRIEND_LIST * flist, int no);

// 
extern void FriendList_SetSex(FRIEND_LIST * flist, int no, u32 sex);
extern u32 FriendList_GetSex(const FRIEND_LIST * flist, int no);

// ROMR[hi0:_C 1:p[j
extern void FriendList_SetRomCode( FRIEND_LIST * flist , int no, u8 rom);
extern u8   FriendList_GetRomCode( const FRIEND_LIST * flist ,int no );


// O[vXgID
extern void FriendList_SetGroupListId( FRIEND_LIST * flist , int no, u32 id );
extern u8   FriendList_GetGroupListId( const FRIEND_LIST * flist , int no );

// O[vXgROMR[h
extern void FriendList_SetGroupListRomCode( FRIEND_LIST * flist , int no, u8 rom );
extern u8   FriendList_GetGroupListRomCode( const FRIEND_LIST * flist , int no );

// O[vXgR[h
extern void FriendList_SetGroupListRegion( FRIEND_LIST * flist , int no, u8 code );
extern u8   FriendList_GetGroupListRegion( const FRIEND_LIST * flist , int no );

// O[v[_[
u8    FriendList_GetGroupListSex( const FRIEND_LIST * flist , int no );
void  FriendList_SetGroupListSex( FRIEND_LIST * flist , int no, u8 code );

// O[v`FbN
int   FriendList_Check( FRIEND_LIST * list, u32 id, STRCODE *name);


//--------------------------------------------------------------------------------
// wID͒m荇(dj
//
// Ԃl0ƒm荇
// DIRECT_FRIENDƎ̂肠
// INDIRECT_FRIENDƗFB̂肠iINDIRECT_FRIEND + FB̔z̓YԂj
//--------------------------------------------------------------------------------
extern int FriendList_IdFullCheck( FRIEND_LIST *mylist, u32 id );

// 肠O[vf[^lnƎ̂肠O[vXV
extern void FriendList_Update( FRIEND_LIST *mylist, FRIEND_LIST *friends, int num, int heapID);
//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern FRIEND_LIST * SaveData_GetFriendList(SAVEDATA * sv);


//	flistStatusm̂ǂ𒲂ׂ
BOOL FriendList_Compare(const FRIEND_LIST * flist, const FRIEND_LIST * target);

//----------------------------------------------------------
//	fobOpf[^̂߂̊֐
//----------------------------------------------------------
extern void Debug_FriendList_Make(FRIEND_LIST * fliststatus, const STRCODE * name, int id);
extern void Debug_FriendListAllPrint( FRIEND_LIST * flist );


#endif //__FRIEND_LIST_H__
