//============================================================================================
/**
 * @file	fushigi_data.h
 * @date	2006.04.28
 * @author	tamada / mitsuhara
 * @brief	ӂʐMpZ[uf[^pwb_
 */
//============================================================================================

#ifndef	__FUSHIGI_DATA_H__
#define	__FUSHIGI_DATA_H__

#include "common.h"
#include "savedata/savedata_def.h"
#include "savedata/regulation.h"
#include "poketool/poke_tool.h"

//============================================================================================
//
//			`
//
//============================================================================================
//------------------------------------------------------------------
///		蕨f[^̑傫
//------------------------------------------------------------------
#define	GIFT_DATA_SIZE	256		// zBP̃TCY

//------------------------------------------------------------------
///		蕨f[^̌
//------------------------------------------------------------------
#define GIFT_DELIVERY_MAX	8	// zBW
#define GIFT_CARD_MAX		3	// J[hf[^R
#define	GIFT_DATA_MAX		8	//J[hȂ5{J[h38

//------------------------------------------------------------------
///		J[h֌W̃TCY`
//------------------------------------------------------------------
#define GIFT_DATA_CARD_TITLE_MAX	36
#define GIFT_DATA_CARD_TEXT_MAX		250
#define GIFT_DATA_SCRIPT_MAX		(256+1024)


//------------------------------------------------------------------
///		蕨f[^\
//------------------------------------------------------------------
#define MYSTERYGIFT_TYPE_NONE		0	// 
#define MYSTERYGIFT_TYPE_POKEMON	1	// |P
#define MYSTERYGIFT_TYPE_POKEEGG	2	// ^}S
#define MYSTERYGIFT_TYPE_ITEM		3	// ǂ
#define MYSTERYGIFT_TYPE_RULE		4	// [
#define MYSTERYGIFT_TYPE_GOODS		5	// ObY
#define MYSTERYGIFT_TYPE_ACCESSORY	6	// ANZT
#define MYSTERYGIFT_TYPE_RANGEREGG	7	// }itB[̃^}S
#define MYSTERYGIFT_TYPE_MEMBERSCARD	8	// o[YJ[h
#define MYSTERYGIFT_TYPE_LETTER		9	// I[LĥĂ
#define MYSTERYGIFT_TYPE_WHISTLE	10	// Ă񂩂̂ӂ
#define MYSTERYGIFT_TYPE_POKETCH	11	// |Pb`
#define MYSTERYGIFT_TYPE_CLEAR		255	// ӂ̈̋NA

#define MYSTERYGIFT_ACCTYPE_SEAL   1  // ANZT[̃V[
#define MYSTERYGIFT_ACCTYPE_CLIP   2  // ANZT[̃Nbv
#define MYSTERYGIFT_ACCTYPE_BG   3  // ANZT[̔wi

#define MYSTERYPOKE_PARENTNAME_THROW  0  // e̖Ô܂
#define MYSTERYPOKE_PARENTNAME_MY   1  // e̖Oɕς


//------------------------------------------------------------------
///		m肵ĂCxgԍ
//------------------------------------------------------------------
#define MYSTERYGIFT_MANAFIEGG		1	// }itB̂܂



// TCYŒp\
typedef struct {
  u8 data[256];
} GIFT_PRESENT_ALL;

// |P
typedef struct {
  u32 parentType;
  u8 data[236];		// sizeof(POKEMON_PARAM)	#####
  u8 ribbon[10];	// ribbon data
  u8 dummy[6];
} GIFT_PRESENT_POKEMON;

// ^}S
typedef struct {
  u32 parentType;
  u8 data[236];		// sizeof(POKEMON_PARAM)	#####
  u8 ribbon[10];	// ribbon data
  u8 dummy[6];
} GIFT_PRESENT_POKEEGG;

// ǂ
typedef struct {
  int itemNo;
} GIFT_PRESENT_ITEM;

// ObY
typedef struct {
  int goodsNo;
} GIFT_PRESENT_GOODS;

// [(M[V)
typedef struct {
  REGULATION regulation;
} GIFT_PRESENT_RULE;

// ANZT
typedef struct {
  int accType;
  int accNo;
} GIFT_PRESENT_ACCESSORY;

// }itB[̃^}S
typedef struct {
  int dummy;
} GIFT_PRESENT_RANGEREGG;

// o[YJ[h
typedef struct {
  int itemNo;
} GIFT_PRESENT_MEMBERSCARD;

// I[LĥĂ
typedef struct {
  int itemNo;
} GIFT_PRESENT_LETTER;

// Ă񂩂̂ӂ
typedef struct {
  int itemNo;
} GIFT_PRESENT_WHISTLE;

// |Pb`
typedef struct {
  int id;
} GIFT_PRESENT_POKETCH;

// ӂȂ̋NA
typedef struct {
  int dummy;
} GIFT_PRESENT_REMOVE;

typedef union {
  GIFT_PRESENT_ALL 		all;
  GIFT_PRESENT_POKEMON		pokemon;
  GIFT_PRESENT_POKEEGG		egg;
  GIFT_PRESENT_ITEM		item;
  GIFT_PRESENT_GOODS		goods;
  GIFT_PRESENT_RULE		rule;
  GIFT_PRESENT_ACCESSORY	accessory;
  GIFT_PRESENT_RANGEREGG	rangeregg;
  GIFT_PRESENT_MEMBERSCARD	memberscard;
  GIFT_PRESENT_LETTER		letter;
  GIFT_PRESENT_WHISTLE		whistle;
  GIFT_PRESENT_POKETCH		poketch;
  GIFT_PRESENT_REMOVE		remove;
} GIFT_PRESENT;



#define MYSTERYGIFT_DELIVERY	0
#define MYSTERYGIFT_CARD	1

#define MYSTERYGIFT_POKEICON	3

// ӂȂ́@r[Rf[^
typedef struct {
  STRCODE event_name[GIFT_DATA_CARD_TITLE_MAX];	// Cxg^Cg
  u32 version;					// Ώۃo[W(Ȍꍇ͐Ŕzz)
  u16 event_id;					// Cxghc(ő2048܂)
  u8 only_one_flag: 1;				// PxMtO(0..xłM\ 1..P̂)
  u8 access_point: 1;				// ANZX|Cg(ĕKvȂȂH)
  u8 have_card: 1;				// J[h܂ł邩(0..܂łȂ  1..܂ł)
  u8 delivery_flag: 1;				// zB󂯎̂܂ł邩
  u8 re_deal_flag: 1;				// zz鎖\H(0..oȂ 1..o)
  u8 groundchild_flag: 1;			// zztO(0..Ⴄ 1..zz)
  u8 dummy: 2;
} GIFT_BEACON;

// zB(őW)
typedef struct {
  u16 gift_type;
  u16 link : 2;					// J[hւ̃N(0: N@1 .. 3:N)
  u16 dummy : 14;
  GIFT_PRESENT data;
} GIFT_DELIVERY;


// J[h(őR)
typedef struct {
  u16 gift_type;
  u16 dummy;					// zBւ̃N
  GIFT_PRESENT data;

  GIFT_BEACON beacon;				// r[RƓ̏

  STRCODE event_text[GIFT_DATA_CARD_TEXT_MAX];	// eLXg
  u8 re_deal_count;				// Ĕzz̉(0`254A255͖)
  u16 pokemon_icon[MYSTERYGIFT_POKEICON];	// |PACRR

  // zẑ͂܂
  // ̉̓tbVɃZ[u鎞̂ݕKvȃf[^
  
  u8 re_dealed_count;				// zz
  s32 recv_date;				// M
  
} GIFT_CARD;


typedef union {
  GIFT_DELIVERY deli;
  GIFT_CARD card;
} GIFT_DATA;


// ʐMۂ̃pbP[W`
// beacon.have_card == TRUE Ȃ data = card;
//                     FALSE Ȃ data = deli;
typedef struct {
  GIFT_BEACON beacon;
  GIFT_DATA data;
} GIFT_COMM_PACK;


//------------------------------------------------------------------
/**
 * @brief	ӂZ[uf[^ւ̕sS^`
 */
//------------------------------------------------------------------
typedef struct FUSHIGI_DATA FUSHIGI_DATA;


//============================================================================================
//
//			OQ
//
//============================================================================================
//------------------------------------------------------------------
//f[^TCY擾
//------------------------------------------------------------------
extern int FUSHIGIDATA_GetWorkSize(void);

//------------------------------------------------------------------
//
//------------------------------------------------------------------
extern void FUSHIGIDATA_Init(FUSHIGI_DATA * fd);

//------------------------------------------------------------------
/**
 * @brief	ӂf[^ւ̃|C^擾
 */
//------------------------------------------------------------------
extern FUSHIGI_DATA * SaveData_GetFushigiData(SAVEDATA * sv);

//------------------------------------------------------------------
/// zBf[^̎擾
//------------------------------------------------------------------
extern GIFT_DELIVERY * FUSHIGIDATA_GetDeliData(FUSHIGI_DATA * fd, int index);
//------------------------------------------------------------------
/// zBf[^Z[uf[^o^
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_SetDeliData(FUSHIGI_DATA *fd, const void *p, int link);
//------------------------------------------------------------------
/// zBf[^𖕏
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_RemoveDeliData(FUSHIGI_DATA *fd, int index);
//------------------------------------------------------------------
/// zBf[^Z[uł邩`FbN
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_CheckDeliDataSpace(FUSHIGI_DATA *fd);
//------------------------------------------------------------------
/// zBf[^̑݃`FbN
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_IsExistsDelivery(const FUSHIGI_DATA * fd, int index);


//------------------------------------------------------------------
/// J[hf[^̎擾
//------------------------------------------------------------------
extern GIFT_CARD *FUSHIGIDATA_GetCardData(FUSHIGI_DATA *fd, int index);
//------------------------------------------------------------------
/// J[hf[^Z[uf[^o^
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_SetCardData(FUSHIGI_DATA *fd, const void *p);
//------------------------------------------------------------------
/// J[hf[^𖕏
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_RemoveCardData(FUSHIGI_DATA *fd, int index);
//------------------------------------------------------------------
/// J[hf[^Z[uł邩`FbN
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_CheckCardDataSpace(FUSHIGI_DATA *fd);
//------------------------------------------------------------------
/// J[hf[^݂邩Ԃ
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_IsExistsCard(const FUSHIGI_DATA * fd, int index);
//------------------------------------------------------------------
/// Z[uf[^ɃJ[hf[^݂邩Ԃ
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_IsExistsCardAll(const FUSHIGI_DATA *fd);

//------------------------------------------------------------------
///	w̃J[hɃNĂzB݂邩
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_GetCardLinkDeli(const FUSHIGI_DATA *fd, int index);

//------------------------------------------------------------------
///	wJ[hɃNĂzB폜
//------------------------------------------------------------------
extern void FUSHIGIDATA_RemoveCardLinkDeli(const FUSHIGI_DATA *fd, int index);

//------------------------------------------------------------------
/// w̃Cxg͂łɂԂ
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_IsEventRecvFlag(FUSHIGI_DATA * fd, int num);
//------------------------------------------------------------------
/// w̃CxgtO𗧂Ă
//------------------------------------------------------------------
extern void FUSHIGIDATA_SetEventRecvFlag(FUSHIGI_DATA * fd, int num);
//------------------------------------------------------------------
///	ӂȂ̂\o邩H
//------------------------------------------------------------------
extern BOOL FUSHIGIDATA_IsFushigiMenu(FUSHIGI_DATA *fd);
//------------------------------------------------------------------
///	ӂȂ̂̕\tOONɂ
//------------------------------------------------------------------
extern void FUSHIGIDATA_SetFushigiMenu(FUSHIGI_DATA *fd);


//------------------------------------------------------------------
/// ȉ̊֐g߂ɕKvȏ
//------------------------------------------------------------------
extern void FUSHIGIDATA_InitSlot(SAVEDATA * sv, int heap_id);
//------------------------------------------------------------------
/// ȉ̊֐gǏn
//------------------------------------------------------------------
extern void FUSHIGIDATA_FinishSlot(SAVEDATA * sv, int flag);
//------------------------------------------------------------------
/// XbgɃf[^邩Ԃ֐
//------------------------------------------------------------------
extern int FUSHIGIDATA_CheckSlotData(void);
//------------------------------------------------------------------
/// ԎႢf[^͉Ȃ̂Ԃ
//------------------------------------------------------------------
extern int FUSHIGIDATA_GetSlotType(int index);
//------------------------------------------------------------------
/// ԎႢf[^̍\̂ւ̃|C^Ԃ
//------------------------------------------------------------------
extern GIFT_PRESENT *FUSHIGIDATA_GetSlotPtr(int index);
//------------------------------------------------------------------
/// w̃Xbg
//------------------------------------------------------------------
extern void FUSHIGIDATA_RemoveSlot(int index);

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2008/09/03
// ͂񂪌ȂoȌC@\ǉ
//------------------------------------------------------------------
///	ӂȂ̂̕\tOONɂ
//------------------------------------------------------------------
extern void FUSHIGIDATA_ToggleOneGetFlg(int flgIndex);
extern BOOL FUSHIGIDATA_IsOneGetFlg(int flgIndex);
// ----------------------------------------------------------------------------

//------------------------------------------------------------------
/// fobOpɃ|Pf[^Zbg֐
//------------------------------------------------------------------
extern void FUSHIGIDATA_DebugSetPokemon(void);

#endif	/* __FUSHIGI_DATA_H__ */
