/**
 *	@brief	MlXz[@Z[uf[^ANZX
 */

#ifndef __H_GUINNESS_H__
#define __H_GUINNESS_H__

#define GNS_RECORD_NUM	(13)	//R[h̃f[^
#define GNS_BLOCK_NUM	(GNS_RECORD_NUM*2)	//ubN
#define GNS_DATA_NUM	(6)		//1ubÑf[^

///MlXf[^^CvID
typedef enum{
 GNSTYPE_BTL,		///<og
 GNSTYPE_POKE,		///<|P
 GNSTYPE_CONTEST,	///<ReXg
}GNSTYPE;

///MlXubNf[^ID
typedef enum{
 GNSID_GLB_SINGLE,		///<O[o@^[VOőA
 GNSID_GLB_DOUBLE,		///<O[o@^[_uőA
 GNSID_GLB_MULTI,		///<O[o@^[AI}`őA
 GNSID_GLB_CMULTI,		///<O[o@^[ʐM}`őA
 GNSID_GLB_WIFI,		///<O[o@^[WifiőA
 GNSID_GLB_WIN,			///<O[o@^[Ϗ
 GNSID_GLP_KILL,		///<O[o@||P
 GNSID_GLP_CAPUTURE,	///<O[o@߂܂|P
 GNSID_GLP_HATCHING,	///<O[o@z|P
 GNSID_GLP_FISHING,		///<O[o@ނグ|P
 GNSID_GLC_GPX,			///<O[o@ReXgD
 GNSID_GLC_GPXPER,		///<O[o@ReXgD
 GNSID_GLC_RIBBON,		///<O[o@ReXg{l
 
 GNSID_GRB_SINGLE,		///<O[v@^[VOőA
 GNSID_GRB_DOUBLE,		///<O[v@^[_uőA
 GNSID_GRB_MULTI,		///<O[v@^[AI}`őA
 GNSID_GRB_CMULTI,		///<O[v@^[ʐM}`őA
 GNSID_GRB_WIFI,		///<O[v@^[WifiőA
 GNSID_GRB_WIN,			///<O[v@^[Ϗ
 GNSID_GRP_KILL,		///<O[v@||P
 GNSID_GRP_CAPUTURE,	///<O[v@߂܂|P
 GNSID_GRP_HATCHING,	///<O[v@z|P
 GNSID_GRP_FISHING,		///<O[v@ނグ|P
 GNSID_GRC_GPX,			///<O[v@ReXgD
 GNSID_GRC_GPXPER,		///<O[v@ReXgD
 GNSID_GRC_RIBBON,		///<O[v@ReXg{l
}GNSID;

/**
 *	@brief	MlXLOf[^Jf[^^
 *
 *	MlX̃LOf[^擾ƂǍ^ŌX̃f[^
 */
typedef struct _GNS_RECORD{
	u32	groupID;
	u32	record;
	STRBUF	*name;
}GNS_RECORD;

typedef struct _GNS_RANKING{
	int				num;	//Lf[^
	GNS_RECORD	rank[GNS_DATA_NUM];	//X̃f[^
}GNS_RANKING;

/**
 * @brief	MlXz[Z[uf[^\̂ւ̕sS^|C^
 *
 * g͌܂񂪃|C^oRŎQƂł܂
 */
typedef struct _GUINNESS_DATA	GUINNESS_DATA;
typedef struct _GUINNESS_BLOCK	GUINNESS_BLOCK;
typedef struct _GUINNESS_RECORD	GUINNESS_RECORD;
typedef struct _GUINNESS	GUINNESS;

#undef GLOBAL
#ifdef __GUINNESS_H_GLOBAL
#define GLOBAL	/***/
#else
#define GLOBAL	extern
#endif

//===================================================================
///MlXf[^֘A
//===================================================================
/**
 *	@brief	MlXf[^@NA
 */
GLOBAL void GNS_DataClear(GUINNESS_DATA* dat);
/**
 *	@brief	MlXf[^LǂH
 *
 *	ONULLȂ
 */
GLOBAL BOOL GNS_IsEnable(GUINNESS_DATA* dat);

/**
 *	@brief	MlXf[^@Rs[
 */
GLOBAL void GNS_DataCopy(const GUINNESS_DATA* src,GUINNESS_DATA* dest);

//===================================================================
///MlXz[f[^֘A
//===================================================================
/**
 *	@brief	MlXz[@f[^TCY
 */
GLOBAL int	GuinnessData_GetWorkSize(void);

/**
 *	@brief	MlXz[@f[^
 */
GLOBAL void GuinnessData_Init(GUINNESS* dat);

/**
 *	@brief	MlXz[@f[^ubNւ̃|C^擾
 */
GLOBAL GUINNESS* SaveData_GetGuinnessData(SAVEDATA* sv);

/**
 *	@brief	MlX@w肵f[^
 */
GLOBAL void GuinnessData_DelRecord(GUINNESS* dat,GNSID id,u8 idx);

//===================================================================
///MlX@R[hf[^֘A
//===================================================================
/**
 *	@brief	MlX@R[hMf[^TCY擾
 */
GLOBAL int GuinnessRecord_GetWorkSize(void);

/**
 *	@brief	MlX@R[hMf[^쐬
 */
GLOBAL void* GuinnessRecord_SendDataAlloc(SAVEDATA* sv,int heapID);

/**
 *	@brief	MlX@R[hMix
 */
GLOBAL void GuinnessRecord_RecvDataMix(SAVEDATA* sv,
		int myid,u8 datanum,const void** array,int heapID);

//===================================================================
///MlXLOf[^֘A
//===================================================================
///^Cvʂ̃ubNԂ
GLOBAL u8 GNSRank_GetTypeBlockNum(GNSTYPE type);
///^CvʂGNSIDItZbgԂ
GLOBAL u8 GNSRank_GetTypeGNSIDOfs(GNSTYPE type);

/**
 *	@brief	MlXLOf[^@̃R[h擾
 *
 *	@return	GNS_RANKING*
 *
 *	GNS_RANKINGf[^^mۂAf[^i[ĕԂ
 *	
 *	@GNSRank_FreeRankingData()֐Kp
 *	@Ăяoƃ邱ƁI
 *	  sys_FreeMemoryŉ_	
 */
GNS_RANKING* GNSRank_AllocMyData(SAVEDATA* sv,GNSTYPE type,int heapID);

/**
 *	@brief	MlXLOf[^擾
 *
 *	@return	
 *	GNS_RANKINGf[^^mۂf[^Rs[ĕԂ
 *
 *	@GNSRank_FreeRankingData()֐Kp
 *	@Ăяoƃ邱ƁI
 *	  sys_FreeMemoryŉ_	
 */
GLOBAL GNS_RANKING* GNSRank_AllocRankingData(GUINNESS* gns,GNSID id,int heapID);

/**
 *	@brief	MlXLOf[^
 *
 *	GNSRank_GetRankingData()֐pĎ擾
 *	@̈J
 */
GLOBAL void GNSRank_FreeRankingData(GNS_RANKING* dat);

/**
 *	@brief	MlXLOf[^Zbg
 *
 *	LO\[gς݃f[^GNS_RANKING^Ɋi[
 *	nAZ[uf[^ɃZbg
 */
GLOBAL void GNSRank_SetRankingData(GUINNESS* gns,GNSID id,GNS_RANKING* dat);


#ifdef PM_DEBUG
/**
 *	@brief	fobOp@MlXLOf[^@_~[
 */
GLOBAL void DebugGNSRank_MakeDmyRankingData(GUINNESS* gns);

#endif	//PM_DEBUG





#endif	//__H_GUINNESS_H__
