/**
 *	@file	poruto_util.h
 *	@brief	|gf[^@ANZXn֐`t@C
 *	@author	Miyuki Iwasawa
 *	@date	06.02.28
 *
 *	f[^QƂsv̏ꏊł́Ãwb_ɒ`ꂽ
 *	@ANZX֐ʂăf[^
 */

#ifndef __H_PORUTO_UTIL_H__
#define __H_PORUTO_UTIL_H__

#include "savedata/savedata_def.h"
#include "savedata/poruto_def.h"

//------------------------------------------------------------
/**
 * @brief	|gZ[uf[^ubNǗ\ւ̕sS^|C^
 *
 * g͌Ȃǃ|C^oRŎQƂ͂ł
 */
//------------------------------------------------------------
typedef struct _PORUTO_BLOCK PORUTO_BLOCK;

//------------------------------------------------------------
/**
 * @brief	|gf[^Ǘ\ւ̕sS^|C^
 *
 * g͌Ȃǃ|C^oRŎQƂ͂ł
 */
//------------------------------------------------------------
typedef struct _PORUTO_DATA PORUTO_DATA;


/**
 *	@brief	Z[uf[^ubNւ̃|C^擾
 */
extern PORUTO_BLOCK* SaveData_GetPorutoBlock(SAVEDATA* sv);

/**
 *	@brief	|gZ[uf[^TCY擾
 */
extern int PORUTO_GetSaveWorkSize(void);

/**
 *	@brief	|gf[^z񏉊
 */
extern void PORUTO_Init(PORUTO_BLOCK* dat);

/**
 *	@brief	|gZ[uf[^̋󂫗̈T
 *
 *	@retval	PORUTO_DATA_NULL	󂫗̈悪Ȃ
 *	@retval "̑"			󂫗̈IndexNo
 */
extern u16 PORUTO_SearchNullData(PORUTO_BLOCK* block);

/**
 *	@brief	|gf[^Z[uf[^󂫗̈ɒǉ
 *
 *	@retval	PORUTO_DATA_NULL	󂫗̈悪ȂĒǉłȂ
 *	@retval "̑"			ǉ̈index
 */
extern u16 PORUTO_AddData(PORUTO_BLOCK* block,PORUTO_DATA* dat);

/**
 *	@brief	|gf[^Z[uf[^폜(indexw)
 *
 */
extern BOOL PORUTO_DelData(PORUTO_BLOCK* block,u16 idx);

/**
 *	@brief	|gZ[uf[^𐮗
 *
 *	f[^ž󂫂l߂
 */
extern void PORUTO_DataAdjust(PORUTO_BLOCK* block);

/**
 *	@brief	Z[uf[^̈ɂLȃ|gf[^Ԃ
 */
extern u16	PORUTO_GetDataNum(PORUTO_BLOCK* block);

/**
 *	@brief	|gf[^Z[uf[^擾(indexw)
 *
 *	nꂽPORUTO_DATA\̌^̈ցAZ[uf[^Rs[ĕԂ
 */
extern void PORUTO_GetData(PORUTO_BLOCK* block,u16 idx,PORUTO_DATA* dest);

/**
 *	@brief	|gf[^Z[uf[^擾(indexw/m۔)
 *
 *	PORUTO_DATA\̌^̈mۂAZ[uf[^Rs[ĕԂ
 *	@ĂяoIɉ邱ƁI
 */
extern PORUTO_DATA* PORUTO_GetDataAlloc(PORUTO_BLOCK* block,u16 idx,int heapID);

//============================================================
/**
 *	|gf[^ANZXn֐
 */
//============================================================
/**
 *	@brief	|gf[^TCY擾
 */
extern int PorutoData_GetWorkSize(void);

/**
 *	@brief	̃|gf[^LǂԂ
 */
extern BOOL PorutoData_IsEnable(PORUTO_DATA* dat);

/**
 *	@brief	|gf[^[N쐬
 */
extern PORUTO_DATA* PorutoData_AllocWork(int heapID);

/**
 *	@brief	|gf[^NA
 */
extern void PorutoData_Clear(PORUTO_DATA* dat);

/**
 *	@brief	|gf[^Rs[
 */
extern void PorutoData_Copy(PORUTO_DATA* src,PORUTO_DATA* dest);

/**
 *	@brief	|g̃p[^擾
 *
 *	@param	dat
 *	@param	id	enum PORUTO_PARAID^(poruto_def.hQ)
 *
 *	@return	u8:擾p[^
 */
extern u8 PorutoData_GetParam(PORUTO_DATA* dat,PORUTO_PARAID id);

/**
 *	@brief	|g̃p[^Zbg
 *
 *	@param	dat
 *	@param	value	Zbgf[^
 *	@param	id	enum PORUTO_PARAID^(poruto_def.hQ)
 *
 */
extern void PorutoData_SetParam(PORUTO_DATA* dat,u8 valid,PORUTO_PARAID id);

/**
 *	@brief	Ǝ||g̎ނ肵Ap[^ZbgĕԂ
 *
 *	@param	dat	PORUTO_DATA*:p[^Zbg|gf[^^\
 *	@param	prm	u8[5]:5ނ̖li[
 *	@param	taste	|li[
 *	@param	mazui	Iɕs|gɂȂ邩ǂH TRUEȂ܂|g
 *
 *	@return	PORUTO_FLAVORID	쐬ꂽ|g̃to[ID
 */
extern PORUTO_FLAVORID PorutoData_CalcParam(PORUTO_DATA* dat,u8 *prm,u8 taste,BOOL mazui);

/**
 *	@brief	|gp[^擾(z)
 *
 *	ĂяoŃf[^̎擾ꏊpӂo[W
 *	@u8[PORUTO_PARAID_NUM] ̃GAKv
 */
extern void PorutoData_GetParamArray(PORUTO_DATA* dat,u8* array);

/**
 *	@brief	|gp[^擾(z,m۔)
 *
 *	֐ŕKvȃobt@擾ĕԂo[W
 *	@ĂяoŖIȃKv
 */
extern u8* PorutoData_GetParamArrayMem(PORUTO_DATA* dat,int heapID);

/**
 *	@brief	|g̃x擾
 */
extern u8 PorutoData_GetLevel(PORUTO_DATA* dat);




//fobOp
#ifdef PM_DEBUG
/**
 *	@brief	|gfobO@f[^S
 */
extern void PorutoDebug_AllDataDelete(PORUTO_BLOCK* block);
/**
 *	@brief	|gfobO@eLg[ȃ|gw肵ǉ
 */
extern u16 PorutoDebug_AddRndData(PORUTO_BLOCK* block,u16 num);
#endif	//PM_DEBUG

#endif	//__H_PORUTO_UTIL_H__

