//============================================================================================
/**
 * @file	record.h
 * @brief
 * @date	2006.03.28
 * @author	tamada/iwasawa
 */
//============================================================================================

#ifndef	__RECORD_H__
#define	__RECORD_H__

#ifndef	__ASM_NO_DEF_

#include "savedata/savedata_def.h"
#include "score_def.h"
#include "savedata/zukanwork.h"

//============================================================================================
//
//	RECORD𑀍삷̂ɕKvȒ`
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	RECORDւ̕sS^`
 */
//----------------------------------------------------------
typedef struct RECORD RECORD;

//----------------------------------------------------------
//----------------------------------------------------------
//R[hf[^̎擾
extern RECORD * SaveData_GetRecord(SAVEDATA * sv);

extern void RECORD_Init(RECORD * rec);
extern int RECORD_GetWorkSize(void);

//----------------------------------------------------------
//----------------------------------------------------------
//lZbg
extern u32 RECORD_Set(RECORD * rec, int id, u32 value);
//݂̒lƔrA傫ΒlZbg
extern u32 RECORD_SetIfLarge(RECORD * rec, int id, u32 value);
//lCNg
extern u32 RECORD_Inc(RECORD * rec, int id);
//l擾
extern u32 RECORD_Get(const RECORD * rec, int id);
//l𑫂
extern u32 RECORD_Add(RECORD * rec, int id, u32 add_value);

#ifdef PM_DEBUG
//XRÃZbg
extern void RECORD_Score_DebugSet(RECORD * rec, const u32 inScore);
#endif

//----------------------------------------------------------
//----------------------------------------------------------
//XRẢZ
extern void RECORD_Score_Add(RECORD * rec, int id);
//XRA擾
extern u32 RECORD_Score_Get(const RECORD * rec);
//}ӃXRAZ
extern void RECORD_Score_AddZukanScore(RECORD * rec, const ZUKAN_WORK * zw, u16 const inMonsno);

#endif	//__ASM_NO_DEF_


//============================================================================================
//
//	RECORDeڂ̒`
//
//============================================================================================
//----------------------------------------------------------
//----------------------------------------------------------
#define	REC_FIRST		0

/**
 *	@brief	XRA擾wID(4byte)
 *
 *	l̉Zɂ͕KRECORD_Score_Add()֐
 *	l̎QƂɂ͕KRECORD_Score_Get()֐gp邱
 *
 *	RECORD_Add()/RECORD_Get()ɒڎw肵ĒlXV/QƂ邱Ƃ͋֎~ł
*/
#define RECID_SCORE						(REC_FIRST+0)	///<XRA

#define	LARGE_REC_START		1

//ȉ́A4oCg̃JE^
#define RECID_REPORT_COUNT				(LARGE_REC_START+0)	///<|[g
#define RECID_CLEAR_TIME				(LARGE_REC_START+1)	///<NA^C
#define RECID_NUTS_PLANT				(LARGE_REC_START+2)	///<؂̎A
#define RECID_RIDE_CYCLE				(LARGE_REC_START+3)	///<]Ԃɏ
#define RECID_WALK_COUNT				(LARGE_REC_START+4)	///<
#define RECID_BATTLE_COUNT				(LARGE_REC_START+5)	///<S퓬
#define RECID_BTL_ENCOUNT				(LARGE_REC_START+6)	///<GJEg퓬
#define RECID_BTL_TRAINER				(LARGE_REC_START+7)	///<g[i[퓬

#define	RECID_CAPTURE_POKE				(LARGE_REC_START+8)	///<08:ߊl|P̐
#define RECID_FISHING_SUCCESS			(LARGE_REC_START+9)	///<ނ肠|P̉
#define	RECID_TAMAGO_HATCHING			(LARGE_REC_START+10)	///<12:^}Sz
#define	RECID_POKE_EVOLUTION			(LARGE_REC_START+11)	///<i|P̈
#define RECID_RECOVERY_PC				(LARGE_REC_START+12)	///<|PZŋx񂾉
#define RECID_SLOT_FEAVER				(LARGE_REC_START+13)	///<Xbgő哖肳
#define RECID_BTOWER_CHALLENGE			(LARGE_REC_START+14)	///<og^[ɒ񂾉
#define RECID_ENTER_MARSHLAND			(LARGE_REC_START+15)	///<ɓ
#define RECID_WAZA_IAIGIRI				(LARGE_REC_START+16)	///<؂g
#define RECID_WAZA_IWAKUDAKI			(LARGE_REC_START+17)	///<킭g

#define RECID_COMM_TRADE				(LARGE_REC_START+18)	///<CXʐM
#define RECID_COMM_BATTLE				(LARGE_REC_START+19)	///<CXʐMΐ
#define RECID_COMM_BTL_WIN				(LARGE_REC_START+20)	///<CXʐMΐ̏
#define RECID_COMM_BTL_LOSE				(LARGE_REC_START+21)	///<CXʐMΐ̔sk
#define RECID_COMM_BTL_DRAW				(LARGE_REC_START+22)	///<CXʐMΐ̈

#define RECID_WIFI_TRADE				(LARGE_REC_START+23)	///<WiFiʐM
#define RECID_WIFI_BATTLE				(LARGE_REC_START+24)	///<WiFiʐMΐ
#define RECID_WIFI_BTL_WIN				(LARGE_REC_START+25)	///<WiFiʐMΐ̏
#define RECID_WIFI_BTL_LOSE				(LARGE_REC_START+26)	///<WiFiʐMΐ̔sk
#define RECID_WIFI_BTL_DRAW				(LARGE_REC_START+27)	///<WiFiʐMΐ̈

#define RECID_BTOWER_WIN				(LARGE_REC_START+28)	///<og^[ł̑(gC[hȊOS)
#define RECID_NMIXER_PLAY				(LARGE_REC_START+29)	///<܂܂s
#define RECID_NMUSU_PLAY				(LARGE_REC_START+30)	///<ނނs
#define RECID_PORUTO_COMM				(LARGE_REC_START+31)	///<|gCXʐMō
#define RECID_PORUTO_EAT				(LARGE_REC_START+32)	///<|PɐHׂ|ǧ

#define RECID_SHOPPING_CNT				(LARGE_REC_START+33)	///<
#define RECID_SHOPPING_MONEY			(LARGE_REC_START+34)	///<vz
#define RECID_POKETCH_CHANGE			(LARGE_REC_START+35)	///<|Pb`̋@\؂ւ
#define RECID_ZUKAN_OPEN				(LARGE_REC_START+36)	///<|P}ӂJ
#define RECID_WATCH_TV					(LARGE_REC_START+37)	///<er
#define RECID_DANSA_JUMP				(LARGE_REC_START+38)	///<iэ~肽
#define RECID_SODATEYA_CNT				(LARGE_REC_START+39)	///<ĉɃ|Pa

#define	RECID_KILL_POKE					(LARGE_REC_START+40)	///<07:||P̐
#define	RECID_DAYMAX_EXP				(LARGE_REC_START+41)	///<24:1ɉ҂ol
#define	RECID_DAYCNT_EXP				(LARGE_REC_START+42)	///<24:1ɉ҂ol


#define	LARGE_REC_NUM	(43+LARGE_REC_START)
#define	LARGE_REC_MAX	(LARGE_REC_NUM)	

//ȉ́A2oCgJE^Ȃ
#define	SMALL_REC_START		LARGE_REC_MAX

#define RECID_MAKE_TRAND_CNT			(SMALL_REC_START+0)	///<s
#define RECID_INTERVIEW_CNT				(SMALL_REC_START+1)	///<C^r[ɓ
#define RECID_DENDOU_CNT				(SMALL_REC_START+2)	///<a肵
#define RECID_RECOVERY_HOME				(SMALL_REC_START+3)	///<̉Ƃŋx񂾉
#define RECID_MOVE_MYBASE				(SMALL_REC_START+4)	///<閧nړ

#define RECID_WAZA_HANERU				(SMALL_REC_START+5)	///<u͂˂vg
#define RECID_WAZA_WARUAGAKI			(SMALL_REC_START+6)	///<u邠vg
#define RECID_WAZA_ZIBAKU				(SMALL_REC_START+7)	///<u΂vg
#define RECID_WAZA_DAIBAKUHATU			(SMALL_REC_START+8)	///<u΂͂vg

#define	RECID_RENSHOU_SINGLE			(SMALL_REC_START+9)	///<^[:VOogA
#define	RECID_RENSHOU_SINGLE_CNT		(SMALL_REC_START+10)///<^[:VOogA
#define	RECID_RENSHOU_DOUBLE			(SMALL_REC_START+11)	///<^[:_uogA
#define	RECID_RENSHOU_DOUBLE_CNT		(SMALL_REC_START+12)	///<^[:_uogA
#define	RECID_RENSHOU_MULTI				(SMALL_REC_START+13)	///<^[:}`ogA
#define	RECID_RENSHOU_MULTI_CNT			(SMALL_REC_START+14)	///<^[:}`ogA
#define	RECID_RENSHOU_COMM_MULTI		(SMALL_REC_START+15)	///<^[:}`ogiʐMjA
#define	RECID_RENSHOU_COMM_MULTI_CNT	(SMALL_REC_START+16)	///<^[:}`ogiʐMjA
#define	RECID_RENSHOU_WIFI				(SMALL_REC_START+17)	///<^[:Wi-FiogA
#define	RECID_RENSHOU_WIFI_CNT			(SMALL_REC_START+18)	///<^[:Wi-FiogA

#define RECID_CONTEST_ENTRY				(SMALL_REC_START+19)	///<ReXgɎQ
#define RECID_CONTEST_COMM_ENTRY		(SMALL_REC_START+20)	///<ReXg(ʐM)ɎQ
#define RECID_CONTEST_GPX				(SMALL_REC_START+21)	///<ReXgŗD
#define RECID_CONTEST_COMM_GPX			(SMALL_REC_START+22)	///<ReXg(ʐM)ŗD
#define RECID_CONTEST_RIBBON_GET		(SMALL_REC_START+23)	///<{̌(ReXg)

#define	RECID_WAZA_MUKOU				(SMALL_REC_START+24)	///<14:ʂ킴o
#define	RECID_TEMOTI_KIZETU				(SMALL_REC_START+25)	///<15:C₳莝̈
#define	RECID_TEMOTI_MAKIZOE			(SMALL_REC_START+26)	///<16:Ƀ_[W^
#define	RECID_NIGERU_SIPPAI				(SMALL_REC_START+27)	///<17:Ȃ
#define	RECID_NIGERARETA				(SMALL_REC_START+28)	///<18Fꂽ|P̐
#define	RECID_FISHING_FAILURE			(SMALL_REC_START+29)	///<22:葹Ȃ
#define	RECID_DAYMAX_PORUTO				(SMALL_REC_START+30)	///<23:1Ƀ|gHׂ
#define	RECID_DAYCNT_PORUTO				(SMALL_REC_START+31)	///<23:1Ƀ|gHׂ
#define	RECID_DAYMAX_KILL				(SMALL_REC_START+32)	///<25:1ɓ||P̐
#define	RECID_DAYCNT_KILL				(SMALL_REC_START+33)	///<25:1ɓ||P̐
#define	RECID_DAYMAX_CAPTURE			(SMALL_REC_START+34)	///<26:1ɕߊl|P̐
#define	RECID_DAYCNT_CAPTURE			(SMALL_REC_START+35)	///<26:1ɕߊl|P̐
#define	RECID_DAYMAX_TRAINER_BATTLE		(SMALL_REC_START+36)	///<27:1Ƀg[i[킵
#define	RECID_DAYCNT_TRAINER_BATTLE		(SMALL_REC_START+37)	///<27:1Ƀg[i[킵
#define	RECID_DAYMAX_EVOLUTION			(SMALL_REC_START+38)	///<28:1Ƀ|Pi
#define	RECID_DAYCNT_EVOLUTION			(SMALL_REC_START+39)	///<28:1Ƀ|Pi

#define RECID_COMM_SURETIGAI			(SMALL_REC_START+40)	///<ႢʐM
#define RECID_NMIXER_TEAMWORK			(SMALL_REC_START+41)	///<܂܂`[[Nō_


#define	SMALL_REC_NUM	(42+35)	//35ӏ]
#define	SMALL_REC_MAX	(SMALL_REC_NUM+LARGE_REC_MAX)


#endif	/* __RECORD_H__ */

