//============================================================================================
/**
 * @file	regulation.h
 * @brief	ogM[Vf[^ANZXpwb_
 * @author	k.ohno
 * @date	2006.1.20
 */
//============================================================================================
#ifndef __REGULATION_H__
#define __REGULATION_H__

#include "system/savedata_def.h"	//SAVEDATAQƂ̂
#include "system/gamedata.h"        //EOM_SIZEQƂ̂
#include "gflib/msg_print.h"		//STRCODEQƂ̂
#include "gflib/strbuf.h"			//STRBUFQƂ̂

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ogM[Vf[^^`
 */
//----------------------------------------------------------
typedef struct _REGULATION_DATA REGULATION_DATA;


#define REGULATION_NAME_SIZE   (11)      // [̒ 1122oCg +EOM2byte
#define REGULATION_MAX_NUM   (1)   // P{ۑ\

typedef enum  {
  REGULATION_NAME,          //[
  REGULATION_POKE_NUM,      //|P
  REGULATION_LEVEL,         //|P̃x
  REGULATION_TOTAL_LEVEL,   //|P̃xv
  REGULATION_EVOLUTION,     //i|Pǂ
  REGULATION_HEIGHT,        //g   0.2 - 9.9m 
  REGULATION_HEIGHT_LIMIT,  //g  -1,0,1
  REGULATION_WEIGHT,       //̏d    1-99  kg
  REGULATION_WEIGHT_LIMIT,   //̏d  -1,0,1
  REGULATION_BOTH_ITEM,    //njH
  REGULATION_BOTH_MONSTER, //|PnjH
  REGULATION_LEGEND,       // `nL
  REGULATION_FIXDAMAGE,    // Œ_[WZKs
} REGULATION_PARAM_TYPE;

//----------------------------------------------------------
/**
 * @brief	ogM[Vf[^^`  fushigi_data.hQƂ̈׊OJ
 */
//----------------------------------------------------------
typedef struct {
	STRCODE cupName[REGULATION_NAME_SIZE + EOM_SIZE];
	u16 totalLevel;
	u8 num;
	u8 level;
    s8 height;
    s8 weight;
    u8 evolution:1;    //  
    u8 bLegend:1;
    u8 bBothMonster:1;
    u8 bBothItem:1;
    u8 bFixDamage:1;
}  REGULATION;

//============================================================================================
//============================================================================================
//----------------------------------------------------------
//	Z[uf[^VXeʐMŎgp֐
//----------------------------------------------------------
extern int Regulation_GetWorkSize(void);
extern int RegulationData_GetWorkSize(void);
extern REGULATION * Regulation_AllocWork(u32 heapID);
extern void Regulation_Copy(const REGULATION * from, REGULATION * to);
extern int Regulation_Cmp(const REGULATION* pCmp1,const REGULATION* pCmp2);

//----------------------------------------------------------
//	REGULATION̂߂̊֐
//----------------------------------------------------------
extern void Regulation_Init(REGULATION * my);
extern void RegulationData_Init(REGULATION_DATA * my);

//O
extern void Regulation_SetCupName(REGULATION * pReg, const STRBUF* pCupName);
extern void Regulation_GetCupName(const REGULATION* pReg,STRBUF* pReturnCupName);
extern STRBUF* Regulation_CreateCupName(const REGULATION* pReg, int heapID);

extern int Regulation_GetParam(const REGULATION* pReg, REGULATION_PARAM_TYPE type);
extern BOOL Regulation_SetParam(REGULATION * pReg, REGULATION_PARAM_TYPE type, int param);

//----------------------------------------------------------
//	Z[uf[^擾̂߂̊֐
//----------------------------------------------------------
extern REGULATION* SaveData_GetRegulation(SAVEDATA* pSave,int regNo);
extern void SaveData_SetRegulation(SAVEDATA* pSave, const REGULATION* pReg);


#endif //__REGULATION_H__
