//=============================================================================
/**
 * @file	savedata.h
 * @brief	Z[uf[^pwb_
 * @author	tamada	GAME FREAK Inc.
 * @date	2005.10.12
 *
 * ̃wb_̓Z[uf[^̐ȂǁAڃZ[uf[^ɂ镔ɂ̂ݕKvB
 * ȊỎӏłsavedata_def.hSAVEDATA^oRŃANZXł΂悢B
 * ̂߁Ãwb_CN[hӏ͌肳͂
 */
//=============================================================================
#ifndef	__SAVEDATA_H__
#define	__SAVEDATA_H__

#include "savedata/savedata_def.h"

//---------------------------------------------------------------------------
///	Z[uɎgpĂZN^
//---------------------------------------------------------------------------
#define	SAVE_PAGE_MAX		(32)

#define	SAVE_SECTOR_SIZE	(0x1000)

//ȉ̓fobOc[p̃Z[üł by soga
#define	POKE_ANM_SAVE		(60*SAVE_SECTOR_SIZE)		//|PAjc[pZ[ü
#define	DEBUG_FIGHT_SAVE	(63*SAVE_SECTOR_SIZE)		//fobOt@CgpZ[ü

//---------------------------------------------------------------------------
///	Z[uubN̒`
//---------------------------------------------------------------------------
typedef enum {
	SVBLK_ID_NORMAL = 0,	///<ʏQ[isf[^
	SVBLK_ID_BOX,			///<|P{bNX

	SVBLK_ID_MAX,
}SVBLK_ID;

//---------------------------------------------------------------------------
///	Z[uڂ̒`
//---------------------------------------------------------------------------
typedef enum {
	//m[}f[^O[v
	GMDATA_ID_SYSTEM_DATA,
	GMDATA_ID_PLAYER_DATA,
	GMDATA_ID_TEMOTI_POKE,
	GMDATA_ID_TEMOTI_ITEM,
	GMDATA_ID_EVENT_WORK,
	GMDATA_ID_POKETCH_DATA,
	GMDATA_ID_SITUATION,
	GMDATA_ID_ZUKANWORK,
	GMDATA_ID_SODATEYA,
	GMDATA_ID_FRIEND,
	GMDATA_ID_MISC,
	GMDATA_ID_FIELDOBJSV,
	GMDATA_ID_UNDERGROUNDDATA,
    GMDATA_ID_REGULATION,
	GMDATA_ID_IMAGECLIPDATA,
	GMDATA_ID_MAILDATA,
	GMDATA_ID_PORUTODATA,
	GMDATA_ID_RANDOMGROUP,
	GMDATA_ID_FNOTE,
	GMDATA_ID_TRCARD,
	GMDATA_ID_RECORD,
	GMDATA_ID_CUSTOM_BALL,
	GMDATA_ID_PERAPVOICE,
	GMDATA_ID_BTLTOWER,
	GMDATA_ID_SP_RIBBON,
	GMDATA_ID_ENCOUNT,
	GMDATA_ID_WORLDTRADEDATA,
	GMDATA_ID_TVWORK,
	GMDATA_ID_GUINNESS,
	GMDATA_ID_WIFILIST,
	GMDATA_ID_WIFIHISTORY,
	GMDATA_ID_FUSHIGIDATA,
	GMDATA_ID_POKEPARKDATA,
	GMDATA_ID_CONTEST,
	GMDATA_ID_PMS,

	//{bNXf[^O[v
	GMDATA_ID_BOXDATA,

	GMDATA_ID_MAX,
}GMDATA_ID;

//---------------------------------------------------------------------------
/**
 * @brief	OZ[uf[^ID`
 */
//---------------------------------------------------------------------------
typedef enum {
	EXDATA_ID_DENDOU,			///<af[^
	EXDATA_ID_FUSHIGIDATA,		///<ӂȂ̃f[^
	EXDATA_ID_MAX,
}EXDATA_ID;


//============================================================================================
//============================================================================================
//---------------------------------------------------------------------------
//	tbVANZXp֐
//	fobOprȊOłSaveData_`ĂԂ͂Ȃ̂ŁAʏ͒ڎgȂB
//---------------------------------------------------------------------------
extern BOOL PMSVLD_Init(void);
extern BOOL PMSVLD_Save(u32 src, void * dst, u32 len);
extern BOOL PMSVLD_Load(u32 src, void * dst, u32 len);


//---------------------------------------------------------------------------
//	Z[uf[^֐
//---------------------------------------------------------------------------
//Z[u[hVXe
extern SAVEDATA * SaveData_System_Init(void);

//tbV݃`FbN
extern BOOL SaveData_GetFlashExistsFlag(const SAVEDATA * sv);

//[h
extern BOOL SaveData_Load(SAVEDATA * sv);
//Z[u
extern SAVE_RESULT SaveData_Save(SAVEDATA * sv);
//
extern BOOL SaveData_Erase(SAVEDATA * sv);
//Z[u
extern SAVE_RESULT SaveData_SaveParts(SAVEDATA * sv, SVBLK_ID id);
//Z[uf[^i܂Ȃj
extern void SaveData_ClearData(SAVEDATA * sv);

//ŏ̓ǂݍݎ̃Z[uf[^Ԏ擾
extern LOAD_RESULT SaveData_GetLoadResult(const SAVEDATA * sv);

//f[^ւ̐VKf[^㏑`FbN
extern BOOL SaveData_IsOverwritingOtherData(const SAVEDATA * sv);
//VKf[^ǂ̔ʃtO擾
extern BOOL SaveData_GetNewDataFlag(const SAVEDATA * sv);
//f[^݂邩ǂ̔ʃtO擾
extern BOOL SaveData_GetExistFlag(const SAVEDATA * sv);

//S̃Z[uKvǂ̔ʃtO擾
extern BOOL SaveData_GetTotalSaveFlag(const SAVEDATA * sv);

//S̃Z[uNGXgtOZbg
extern void SaveData_RequestTotalSave(void);

//Z[uF
extern void SaveData_DivSave_Init(SAVEDATA * sv, int BlockID);
//Z[uFC
extern SAVE_RESULT SaveData_DivSave_Main(SAVEDATA * sv);
//Z[uFLZ
extern void SaveData_DivSave_Cancel(SAVEDATA * sv);


//---------------------------------------------------------------------------
//	Z[uf[^ANZXp֐
//---------------------------------------------------------------------------
extern void * SaveData_Get(SAVEDATA * sv, GMDATA_ID gmdataID);
extern const void * SaveData_GetReadOnlyData(const SAVEDATA * sv, GMDATA_ID gmdataID);


//---------------------------------------------------------------------------
//	fobOp֐
//	ȂgĂ͂܂B
//---------------------------------------------------------------------------
extern SAVEDATA * SaveData_GetPointer(void);

// CfbNX鎞̂ݗL
// ʏOFFȂ̂ONɂȂĂ̂疳OFFŗǂ
//#define CREATE_INDEX

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


#endif	/* __SAVEDATA_H__ */
