//============================================================================================
/**
 * @file	seedbed.h
 * @author	tamada
 * @date	2005.02.01
 * @brief	݂̂̏ԃf[^`
 */
//============================================================================================
#ifndef	__SEEDBED_H__
#define	__SEEDBED_H__

#include "savedata/savedata_def.h"

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	̂ݏԃf[^̕sS^`
 */
//----------------------------------------------------------
typedef struct _SEEDBED SEEDBED;

//----------------------------------------------------------
/**
 * @brief	݂̂̏Ԓ`
 */
//----------------------------------------------------------
typedef enum {
	SEEDSTAT_NOTHING = 0,	///<݂̂AĂȂ
	SEEDSTAT_UNDERGROUND,	///<݂̂A
	SEEDSTAT_HUTABA,		///<肪oĂ
	SEEDSTAT_MIKI,			///<
	SEEDSTAT_FLOWER,		///<Ԃ炢Ă
	SEEDSTAT_FRUIT,			///<ȂĂ

	SEEDSTAT_CHANGE = 0xff,	///<ԕω
}SEEDSTAT;

//----------------------------------------------------------
/**
 * @brief	C̏
 */
//----------------------------------------------------------
typedef enum {
	SEEDGROUND_DRY = 0,	///<ăqrłĂ
	SEEDGROUND_WET,		///<
	SEEDGROUND_FULL,		///<\
}SEEDGROUND;

//----------------------------------------------------------
/**
 * @brief	엿̎
 */
//----------------------------------------------------------
typedef enum {
	SEEDCOMPOST_NOTHING = 0,
	SEEDCOMPOST_SUKUSUKU,
	SEEDCOMPOST_YURURI,
	SEEDCOMPOST_MINAARU,
	SEEDCOMPOST_NEBARI,
}SEEDCOMPOST;

//----------------------------------------------------------
/**
 * @brief	݂̂̐ɕKvȃp[^
 */
//----------------------------------------------------------
typedef struct {
	u8 grow_speed;		///<xiԒPʁj
	u8 root_power;		///<z
	u8 nuts_rate;		///<̐鐔̔{
}SEED_TABLE;

//============================================================================================
//============================================================================================
//----------------------------------------------------------
//----------------------------------------------------------
extern int SEEDBED_GetWorkSize(void);
extern SEEDBED * SEEDBED_AllocWork(u32 heapID);
extern void SEEDBED_Init(SEEDBED * sbed);

//pe[u
extern SEED_TABLE * SEEDBED_CreateParamTable(int heapID);

//ԃZbg
extern void SEEDBED_SetDefaultData(SEEDBED * sbed, int heapID, const u16 * init_data, int max);
//----------------------------------------------------------
//----------------------------------------------------------
//Ԏ擾
extern SEEDSTAT SEEDBED_GetSeedStatus(const SEEDBED * sbed, int id);

//݂̂̎ނ擾
extern int SEEDBED_GetSeedType(const SEEDBED * sbed, int id);

//̏Ԃ擾
extern SEEDGROUND SEEDBED_GetGroundStatus(const SEEDBED * sbed, int id);

//݂̂HP擾
extern int SEEDBED_GetSeedHP(const SEEDBED * sbed, int id);

//݂̂A
extern void SEEDBED_SetNuts(SEEDBED * sbed, int id, const SEED_TABLE * param, int type);
//
extern void SEEDBED_SetSeedWater(SEEDBED * sbed, int id);
//RV܂
//RV̎ނ擾
extern void SEEDBED_SetCompost(SEEDBED * sbed, int id, SEEDCOMPOST compost);

//tO̐ݒ
extern BOOL SEEDBED_GetGrowthFlag(const SEEDBED * sbed, int id);
//tO̎擾
extern void SEEDBED_SetGrowthFlag(SEEDBED * sbed, int id, BOOL flag);

//݂̂̐擾
extern int SEEDBED_GetSeedCount(const SEEDBED * sbed, int id);

extern SEEDCOMPOST SEEDBED_GetCompost(const SEEDBED * sbed, int id);
//----------------------------------------------------------
//----------------------------------------------------------
//݂̂n
extern int SEEDBED_GetHarvest(SEEDBED * sbed, int id);

//݂̂𐬒
extern void SEEDBED_Growth(SEEDBED * sbed, const SEED_TABLE * param, int minute);

//----------------------------------------------------------
//----------------------------------------------------------
extern SEEDBED * SaveData_GetSeedBed(SAVEDATA * sv);

#endif /* __SEEDBED_H__ */
