//============================================================================================
/**
 * @file	wifihistory.h
 * @brief
 * @date	2006.03.25
 */
//============================================================================================

#ifndef	__WIFIHISTORY_H__
#define	__WIFIHISTORY_H__

#include "savedata/savedata_def.h"

//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	WiFiʐMf[^̕sS^錾
 */
//----------------------------------------------------------
typedef struct _WIFI_HISTORY WIFI_HISTORY;

///WiFiʐMc̐
#define	WIFI_NATION_MAX		(256)

///WiFiʐMĉꂼ̒nR[h̍ő吔
#define	WIFI_AREA_MAX		(64)


///{̒nV`({country103Ȃ񂾂QƂłȂ̂Łj
#define WIFI_NATION_JAPAN	( 103 ) 


// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/25
// ؍łł͂łƂ\Eɋo^
#if PM_LANG == LANG_KOREA
#define WIFI_NATION_KOREA	( 110 ) 
#endif
// ----------------------------------------------------------------------------


//----------------------------------------------------------
/**
 * @brief	WiFiʐMf[^̏Ԓ`
 */
//----------------------------------------------------------
typedef enum {
	WIFIHIST_STAT_NODATA = 0,	///<܂ʐMƂȂ
	WIFIHIST_STAT_NEW = 1,		///<{߂ĒʐM
	WIFIHIST_STAT_EXIST = 2,	///<ʐMƂ
	WIFIHIST_STAT_MINE = 3,		///<̏ꏊ

	WIFIHIST_STAT_MAX,
}WIFIHIST_STAT;

//----------------------------------------------------------
//----------------------------------------------------------
//[NTCY擾iZ[uVXeĂ΂j
extern int WIFIHISTORY_GetWorkSize(void);
//iZ[uVXeĂ΂j
extern void WIFIHISTORY_Init(WIFI_HISTORY * hist);
//Z[uf[^擾igӏŌĂԁj
extern WIFI_HISTORY * SaveData_GetWifiHistory(SAVEDATA * sv);

//mFĂ܂B
extern void WIFIHISTORY_SetMyNationArea(WIFI_HISTORY * wh, int nation, int area);
extern int WIFIHISTORY_GetMyNation(const WIFI_HISTORY * wh);
extern int WIFIHISTORY_GetMyArea(const WIFI_HISTORY * wh);
extern void WIFIHISTORY_SetStat(WIFI_HISTORY * wh, int nation, int area, WIFIHIST_STAT stat);
extern WIFIHIST_STAT WIFIHISTORY_GetStat(const WIFI_HISTORY * wh, int nation, int area);

extern BOOL WIFIHISTORY_GetWorldFlag(const WIFI_HISTORY * wh);
extern void WIFIHISTORY_SetWorldFlag(WIFI_HISTORY * wh, BOOL flag);

//tɂXV
extern void WIFIHISTORY_Update(WIFI_HISTORY * wh);

#endif	/* __WIFIHISTORY_H__ */

