#ifndef __FONTPROC_H__
#define __FONTPROC_H__

#include "gflib\fontdata_loadtype.h"
#include "gflib\msg_print.h"
#include "gflib\strbuf.h"

//--------------------------------------------------------------
/**
 *		tHg^Cv
 */
//--------------------------------------------------------------
typedef enum {
	FONT_SYSTEM = 0,
	FONT_TALK,
	FONT_BUTTON,
	FONT_UNKNOWN,

	FONT_MAX,

	// ------ ȉ make ʂ߂Ɏc -----
	// ------ SĒuĂ炢 ---

	POKE_8x16 = FONT_SYSTEM,
	POKE_9x12 = FONT_SYSTEM,
	POKE_11x16 = FONT_TALK,
	POKE_SYS = FONT_SYSTEM,
	POKE_SYSTEM = FONT_SYSTEM,
	POKE_FNTEND = FONT_MAX,

}FONT_TYPE;


//--------------------------------------------------------------
/**
 * 퓬Q[WOBJp̃tHg`
 *		font_header_data̔zf[^ɂ͕KvȂ̂ŕʂɒ`B
 *		l͔Ȃ悤ɂKv
 */
//--------------------------------------------------------------
#define POKE_8x12BATTLE		(POKE_FNTEND)

enum {
	FONT_HEADER_SIZE_X = 0,		// tHgXTCYw
	FONT_HEADER_SIZE_Y,			// tHgYTCYw
	FONT_HEADER_SPACE_X,		// ԊuX(ݒ)
	FONT_HEADER_SPACE_Y,		// ԊuY(ݒ)
	FONT_HEADER_STYLE,			// tHgX^C(ݒ)
	FONT_HEADER_F_COLOR,		// Fio[
	FONT_HEADER_B_COLOR,		// wiFio[
	FONT_HEADER_S_COLOR			// eF@io[
};

#define	FONT_CURSOR_SIZE_X		( 0 )
#define	FONT_CURSOR_SIZE_Y		( 1 )


//------------------------------------------------------------------
/**
 * tHgVXeiCłPxĂԂj
 *
 * @param   none		
 */
//------------------------------------------------------------------
extern void FontProcInit( void );


//------------------------------------------------------------------
/**
 * tHgf[^RAMɃ[h
 *
 * @param   font		tHghc
 * @param   heapID		[hq[v̂hc
 *
 */
//------------------------------------------------------------------
extern void FontProc_LoadFont( FONT_TYPE font, u32 heapID );

//------------------------------------------------------------------
/**
 * RAMɃ[hĂtHgf[^A[h
 *
 * @param   font		tHg^Cv
 */
//------------------------------------------------------------------
extern void FontProc_UnloadFont( FONT_TYPE font );






//------------------------------------------------------------------
/**
 * tHg̃rbgf[^ɏ풓Aǂݍݏ
 *
 * @param   font			tHgID
 * @param   heapID			rbgf[^풓pq[vID
 *
 */
//------------------------------------------------------------------
extern void FontProc_LoadBitData( FONT_TYPE font, u32 heapID );

//------------------------------------------------------------------
/**
 * FontProc_LoadBitData ŏ풓rbgf[^jA
 * t@Cǂݍݕɖ߂
 *
 * @param   font			tHgID
 *
 */
//------------------------------------------------------------------
extern void FontProc_UnloadBitData( FONT_TYPE font );




//------------------------------------------------------------------
/**
 * tHgBMPf[^P[Nɓǂݍ݁ÃAhXn
 *
 * @param   font		tHg^Cv
 * @param   code		R[h
 *
 * @retval  const MSG_FONT_DATA*		ǂݍݐAhX
 */
//------------------------------------------------------------------
extern const MSG_FONT_DATA* FontDataGet( FONT_TYPE font, STRCODE code );


//--------------------------------------------------------------------------------------------
/**
 * tHgwb_f[^擾
 *
 * @param	fnt_index	tHgCfbNX
 * @param	param		擾p[^
 *
 * @return	w肳ꂽp[^
 */
//--------------------------------------------------------------------------------------------
extern u8 FontHeaderGet( u8 fnt_index, u8 param );

//--------------------------------------------------------------------------------------------
/**
 * VXetHgpbgǂݍ
 *
 * @param	type	pbg]^Cv
 * @param	offs	ǂݍ݃ItZbgioCgPʁj
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
extern void SystemFontPaletteLoad( u32 type, u32 offs, u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * btHgpbgǂݍ
 *
 * @param	type	pbg]^Cv
 * @param	offs	ǂݍ݃ItZbgioCgPʁj
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
extern void TalkFontPaletteLoad( u32 type, u32 offs, u32 heap );



//------------------------------------------------------------------
/**
 * tHgf[^EBhEL[N̈ɕ`
 *
 * @param   font		tHg^Cv
 * @param   ini			BGLVXe[N
 * @param   mdh		
 *
 */
//------------------------------------------------------------------
extern PRINT_RESULT FontDataPrint( FONT_TYPE font, MSG_DATA_HEADER * mdh_p );


//------------------------------------------------------------------
/**
 * rbg}bv̉擾
 *
 * @param   font		tHg^Cv
 * @param   str			
 * @param   margin		ԁihbgj
 *
 * @retval  u32			ihbgj
 */
//------------------------------------------------------------------
extern u32 FontProc_GetStrWidth( FONT_TYPE font, const STRCODE* str, u32 margin );
extern u32 FontProc_GetPrintStrWidth( FONT_TYPE font, const STRBUF* str, u32 margin );

//--------------------------------------------------------------------------------------------
/**
 * J[\TCY擾
 *
 * @param	fnt_index	tHgCfbNX
 * @param	param		擾p[^
 *
 * @return	w肳ꂽp[^
 */
//--------------------------------------------------------------------------------------------
extern u8 FontCursorSizeGet( u8 fnt_index, u8 param );

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/05
// sɂ킽镶́AŒs̃rbg}bvԂ֐
u32 FontProc_GetMaxLineWidth( FONT_TYPE font, const STRCODE* str, u32 margin );
u32 FontProc_GetPrintMaxLineWidth( FONT_TYPE font, const STRBUF* str, u32 margin );
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/14
// 1s̕Z^OʒuԂ֐
u32 FontProc_GetCenteredPositionX( FONT_TYPE font, const STRCODE* str, u32 margin, u32 width );
u32 FontProc_GetPrintCenteredPositionX( FONT_TYPE font, const STRBUF* str, u32 margin, u32 width );
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/20
// ̍sJEgĕԂ֐
u32 FontProc_GetLineNum(const STRCODE* str);
u32 FontProc_GetPrintLineNum(const STRBUF* str);
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/14
// XNvgEBhEJۂɁAeڂ̒擾邽߂̊֐
u32 FontProc_GetEvWinItemWidth( FONT_TYPE font, const STRBUF* str );
// ----------------------------------------------------------------------------
#endif
