//============================================================================================
/**
 * @file	numfont.h
 * @brief	tHg
 * @author	taya
 * @date	2005.09.30
 */
//============================================================================================
#ifndef __NUMFONT_H__
#define __NUMFONT_H__

#include  "system\pm_str.h"

//------------------------------------------------------
/**
 *	tHg̍\̂̌^錾ie͔Jj
 */
//------------------------------------------------------
typedef   struct _NUMFONT    NUMFONT;

//------------------------------------------------------
/**
 *	l`惂[h
 */
//------------------------------------------------------
typedef enum {
	NUMFONT_MODE_LEFT = NUM_MODE_LEFT,		///< l
	NUMFONT_MODE_SPACE = NUM_MODE_SPACE,	///< ElAȂ̓Xy[X
	NUMFONT_MODE_ZERO = NUM_MODE_ZERO,		///< ElAȂ̓[
}NUMFONT_DRAW_MODE;

//------------------------------------------------------
/**
 *	L
 */
//------------------------------------------------------
typedef enum {
	NUMFONT_MARK_SLASH,
	NUMFONT_MARK_LV,
	NUMFONT_MARK_NO,
	NUMFONT_MARK_ID,
	NUMFONT_MARK_MALE_LV,		// LLV̍i퓬Q[Wpj
	NUMFONT_MARK_FEMALE_LV,		// LLV̍i퓬Q[Wpj
	NUMFONT_MARK_BATTLE_LV,		// ŌɃhbgȂLVi퓬Q[Wpj
}NUMFONT_MARK;

//------------------------------------------------------
/**
 *	Ei萔j
 */
//------------------------------------------------------
enum {
	NUMFONT_NUM_WIDTH = 8,		///< P̕
	NUMFONT_MARK_WIDTH = 16,	///< LP̕
	NUMFONT_HEIGHT = 8,			///< 
};

//------------------------------------------------------------------
/**
 * tHg쐬
 *
 * @param   colLetter	Fԍ
 * @param   colShadow	eFԍ
 * @param   colBack		wiFԍ
 * @param   heapID		q[vhc
 *
 * @retval  NUMFONT*	tHĝւ̃|C^ie͔Jj
 */
//------------------------------------------------------------------
extern NUMFONT*  NUMFONT_Create( u32 colLetter, u32 colShadow, u32 colBack, u32 heapID );


//------------------------------------------------------------------
/**
 * tHgj
 *
 * @param   numfont		tHg|C^
 *
 */
//------------------------------------------------------------------
extern void NUMFONT_Delete( NUMFONT* numfont );

//------------------------------------------------------------------
/**
 * L`
 *
 * @param   numfont		tHg|C^
 * @param   mark		L
 * @param   win			`EBhE
 * @param   x			`wWihbgj
 * @param   y			`xWihbgj
 *
 */
//------------------------------------------------------------------
extern void NUMFONT_WriteMark( NUMFONT* numfont, NUMFONT_MARK mark, GF_BGL_BMPWIN* win, u32 x, u32 y );

//------------------------------------------------------------------
/**
 * l`
 *
 * @param   numfont		tHg|C^
 * @param   num			l
 * @param   keta		ő包
 * @param   mode		l`惂[h
 * @param   win			`EBhE
 * @param   x			`wWihbgj
 * @param   y			`xWihbgj
 *
 */
//------------------------------------------------------------------
extern void NUMFONT_WriteNumber( NUMFONT* numfont, s32 num, u32 keta, NUMFONT_DRAW_MODE mode, GF_BGL_BMPWIN* win, u32 x, u32 y );

//------------------------------------------------------------------
/**
 * LElׂĕ`
 *
 * @param   numfont		tHg|C^
 * @param   mark		L
 * @param   num			l
 * @param   keta		ő包
 * @param   mode		l`惂[h
 * @param   win			`EBhE
 * @param   x			`wWihbgj
 * @param   y			`xWihbgj
 *
 */
//------------------------------------------------------------------
extern void NUMFONT_WriteSet( NUMFONT* numfont, NUMFONT_MARK mark, s32 num, u32 keta, NUMFONT_DRAW_MODE mode, GF_BGL_BMPWIN* win, u32 x, u32 y );

//------------------------------------------------------------------
/**
 * l`(wobt@ɑ΂ăLN^f[^̂ݏ)
 *
 * @param   numfont		tHg|C^
 * @param   num			l
 * @param   keta		ő包
 * @param   mode		`
 * @param   buf			`obt@
 *
 */
//------------------------------------------------------------------
extern void NUMFONT_WriteNumberCGXOnly( NUMFONT* numfont, s32 num, u32 keta, 
	NUMFONT_DRAW_MODE mode, void *buf);

//--------------------------------------------------------------
/**
 * @brief   L`(wobt@ɑ΂ăLN^f[^̂ݏ)
 *
 * @param   numfont		tHg|C^
 * @param   mark		L^Cv
 * @param   buf			WJobt@ւ̃|C^
 *
 * @retval  
 *
 * buf u(NUMFONT_MARK_WIDTH / 8) * (NUMFONT_HEIGHT / 8) * 32v ̃TCYKvłB
 */
//--------------------------------------------------------------
extern void NUMFONT_WriteMarkCGXOnly( NUMFONT* numfont, NUMFONT_MARK mark, void *buf);

#endif
