//============================================================================================
/**
 * @file	pm_str.h
 * @brief	֘A
 * @author	Hiroyuki Nakamura
 * @date	2004.11.02
 */
//============================================================================================
#ifndef PM_STR_H
#define PM_STR_H

#include "gflib\msg_print.h"	// STRCODE `̂

#undef GLOBAL
#ifdef PM_STR_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	V{`
//============================================================================================
enum {
	NUM_MODE_LEFT = 0,		// l
	NUM_MODE_SPACE,			// ElAȂ͋
	NUM_MODE_ZERO			// ElAȂ͐̃[
};


//============================================================================================
//	O[oϐ
//============================================================================================
#ifndef PM_STR_H_GLOBAL
GLOBAL STRCODE	MsgExpandBuffer[];
#endif


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Rs[
 *
 * @param	to_str		Rs[obt@
 * @param	from_str	f[^
 *
 * @return	obt@ɃRs[f[^ŌEOM_ւ̃|C^
 *
 *	f[^Ȃ(f[^擪EOM_)ꍇA
 *	EOM_obt@擪ɏ݁Aւ̃|C^Ԃ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 * PM_strcpy( u16 * to_str, const u16 * from_str );

//--------------------------------------------------------------------------------------------
/**
 * Rs[iwj
 *
 * @param	to_str		Rs[obt@
 * @param	from_str	f[^
 * @param	len			Rs[镶
 *
 * @return	uRs[obt@ + Rs[镶vւ̃|C^
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE * PM_strncpy( STRCODE* to_str, const STRCODE* from_str, u32 len );

//--------------------------------------------------------------------------------------------
/**
 * A
 *
 * @param	to_str		Af[^iramɂ邱ƁIIj
 * @param	from_str	Af[^
 *
 * @return	Ãobt@̃f[^EOM_ւ̃|C^
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_strcat( STRCODE* to_str, const STRCODE* from_str );

//--------------------------------------------------------------------------------------------
/**
 * Aiwj
 *
 * @param	to_str		Af[^iramɂ邱ƁIIj
 * @param	from_str	Af[^
 * @param	len			A镶
 *
 * @return	Ãobt@̃f[^ւ̃|C^Ԃ
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_strncat( STRCODE* to_str, const STRCODE* from_str, u32 len );

//--------------------------------------------------------------------------------------------
/**
 * 񒷎擾
 *
 * @param	str		Ώەւ̃|C^
 *
 * @return	Ώە̒iEOM_܂ł̕jԂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 PM_strlen( const STRCODE* str );

//--------------------------------------------------------------------------------------------
/**
 * r
 *
 * @param	s		Ώەւ̃|C^
 * @param	t		Ώەւ̃|C^
 *
 * @retval	"0 = v"
 * @retval	"1 = sv"
 *
 * @li	bW֐ƈႢ̔r͂ĂȂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL PM_strcmp( const STRCODE* s, const STRCODE* t );

//--------------------------------------------------------------------------------------------
/**
 * riwj
 *
 * @param	s		Ώەւ̃|C^
 * @param	t		Ώەւ̃|C^
 * @param	n		r镶
 *
 * @retval	"0 = v"
 * @retval	"1 = sv"
 *
 * @li	bW֐ƈႢ̔r͂ĂȂ
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL PM_strncmp( const STRCODE* s, const STRCODE* t, u32 n );

//--------------------------------------------------------------------------------------------
/**	
 * ̓`FbN
 *
 * @param	str		Ώەւ̃|C^
 * @param	n		`FbN镶
 *
 * 
 * @retval	"1 = ͂"
 * @retval	"0 = ͂Ȃ"
 *
 * @li	w肳ꂽobt@ɋ󔒂EOMȊÕR[h܂܂Ă邩`FbN
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL PM_strnchk( STRCODE* str, u32 n );

//--------------------------------------------------------------------------------------------
/**
 * obt@w蕶R[hŃNA
 *
 * @param	str		obt@
 * @param	code	R[h
 * @param	len		NA镶
 *
 * @return	EOM_ AhX
*/
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_strclear( STRCODE * str, STRCODE code, u32 len );

//--------------------------------------------------------------------------------------------
/**
 * obt@EOM_R[hŃNA
 *
 * @param	str		obt@
 * @param	len		NA镶
 *
 * @return	NAI[EOM_ AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE * PM_strclearEOM_( STRCODE * str, u32 len );

//--------------------------------------------------------------------------------------------
/**
 * Rs[Aw蕶ɖȂAw蕶R[hŃNA
 *
 * @param	to		Rs[敶obt@
 * @param	from	Rs[
 * @param	code	NAR[h
 * @param	len		Ŝ̕
 *
 * @return	EOM_ AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_strcpy_clear( STRCODE* to, const STRCODE* from, STRCODE code, u32 len );

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPOij
 *
 * @param	buf		WJꏊ
 * @param	num		l
 * @param	type	ϊ
 * @param	keta	
 *
 * @return	ľɏEOM_ւ̃|C^
 *
 * @li	type = NUM_MODE_LEFT	l
 * @li	type = NUM_MODE_SPACE	ElAȂ͋
 * @li	type = NUM_MODE_ZERO	ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_NumMsgSet( STRCODE* buf, s32 num, u32 type, u32 keta );

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPOiA}CiX͂Ȃj
 *
 * @param	buf		WJꏊ
 * @param	num		l
 * @param	type	ϊ
 * @param	keta	
 *
 * @return	ľɏEOM_ւ̃|C^
 *
 * @li	type = NUM_MODE_LEFT	l
 * @li	type = NUM_MODE_SPACE	ElAȂ͋
 * @li	type = NUM_MODE_ZERO	ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_NumMsgSetUnsigned( STRCODE* buf, u32 num, u32 type, u32 keta );

//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊiPUij
 *
 * @param	buf		WJꏊ
 * @param	num		l
 * @param	type	ϊ
 * @param	keta	
 *
 * @return	ľɏEOM_ւ̃|C^
 *
 * @li	type = NUM_MODE_LEFT	l
 * @li	type = NUM_MODE_SPACE	ElAȂ͋
 * @li	type = NUM_MODE_ZERO	ElAȂ͐̃[
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_HexNumMsgSet( STRCODE* buf, s32 num, u32 type, u32 keta );

//--------------------------------------------------------------------------------------------
/**
 * bZ[WWJiS_MSG_݁j
 *
 * @param	buf		WJ
 * @param	data	bZ[W
 *
 * @return	EOM_̃AhX
 */
//--------------------------------------------------------------------------------------------
GLOBAL STRCODE* PM_MsgExpand( STRCODE* buf, const STRCODE* data );

//--------------------------------------------------------------------------------------------
/**
 * S_MSG_
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void MsgExp_Init(void);

//--------------------------------------------------------------------------------------------
/**
 * S_MSG_ݒ菈
 *
 * @param	id		ID
 * @param	str		Zbg镶
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void MsgExp_AdrsSet( u32 id, const STRCODE* str );


//--------------------------------------------------------------------------------------------
/**
 * l𕶎ɕϊ ( str )
 *
 * @param	str		i[ꏊ
 * @param	num		ϊ鐔l
 * @param	keta	
 *
 * @return	none
 *
 * @li	t@C̍쐬ȂǂɎgp֐B
 * @li	keta = 0  : l
 * @li	keta != 0 : 0Ŗ߂
 */
//--------------------------------------------------------------------------------------------
GLOBAL void StrNumSet( char* str, u32 num, u32 keta );



#undef GLOBAL
#endif	/* PM_STR_H */
