/**
 *	@file	poruto_name.c
 *	@brief	|g̎ޖ擾c[Q
 *	@author	Miyuki Iwasawa
 *	@date	06.02.28
 */

#ifndef __H_PORUTO_NAME_H__
#define __H_PORUTO_NAME_H__

#include "gflib/msg_print.h"
#include "gflib/bg_system.h"
#include "system/msgdata.h"
#include "savedata/poruto_def.h"

///|g擾}l[W[^
typedef struct _PORUTO_NAME_MAN{
	MSGDATA_MANAGER* pMsgMan;
	STRBUF	*name[PORUTO_FLAVOR_MAX];	
}PORUTO_NAME_MAN;

/**
 *	@brief	|g擾}l[W쐬
 *
 *	pIK PorutoName_ReleaseManager()Ăяo
 *	@̈JĂ
 */
extern PORUTO_NAME_MAN* PorutoName_CreateManager(int heapID);

/**
 *	@brief	|g擾}l[W
 */
extern void PorutoName_ReleaseManager(PORUTO_NAME_MAN* man);

/**
 *	@brief	|gto[ID疼O擾(}l[Ww)
 *
 *	PORUTO_NAME_STRLEN (10)+EOM_TCỸobt@mۂKvL
 *	@BUFLEN_PORUTO_NAMEgpĂǂ
 */
extern void PorutoName_GetNameStrByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id,STRBUF* buf);

/**
 *	@brief	|gto[ID疼O擾(}l[WSTRBUF*擾)
 *
 *	}l[W[NɊmۂĂSTRBUF̈ւ̃|C^Ԃ
 *	@QƂ͉ҏW͕sI
 */
extern const STRBUF* PorutoName_GetNameAdrByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id);

/**
 *	@brief@|gto[ID疼O擾(ĝ)
 */
extern void PorutoName_GetNameStrInst(PORUTO_FLAVORID id,STRBUF* buf,int heapID);

/**
 *
 *	@brief@|gto[ID疼O擾(ĝ/擾)
 *	
 *	STRBUFɃ擾ĕԂ̂ŁA͎ōsƁI
 */
extern STRBUF* PorutoName_AllocNameStrInst(PORUTO_FLAVORID id,int heapID);

/**
 *	@brief	|gto[ID疼O擾(}l[Ww/擾)
 *
 *	STRBUFɃmۂĕԂ̂ŁA͎ł邱ƁI
 */
extern STRBUF* PorutoName_AllocNameStrByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id,int heapID);

/**
 *	@brief	|gto[IDw肵ĖO`(}l[Ww)
 *
 * @param	win			BMPEBhEf[^
 * @param	fnt_index	gpwb_INDEX(msg_print.h Q)
 * @param	x			EChE\JnXItZbg
 * @param	y			EChE\JnYItZbg
 * @param	wait		`EFCg
 * @param	call_back	`悲Ƃ̃R[obN֐
 *
 * @return	bZ[WCfbNX
 *
 * call_back ݒɊւāÅ֐̈ 
 *   MSG_PRINT_HEADER \(msg_print.h Q)|C^
 * ƂȂ
 *
 * wait ݒ
 *   MSG_NOTRANS	fBXvC]Ȃ
 *@ MSG_ALL		fBXvCꊇ]
 *   1 `			PƂ̓]EFCgl
 * Ŏw(msg_print.h `)
 */
extern void PorutoName_WriteByMan(PORUTO_NAME_MAN* man,PORUTO_FLAVORID id,
	GF_BGL_BMPWIN *win,u8 font,u8 ofsx,u8 ofsy,u8 wait,GF_PRINTCOLOR col,void* call_back );

/**
 *	@brief	|gto[IDw肵ĖO`(ĝ)
 *
 * @param	win			BMPEBhEf[^
 * @param	fnt_index	gpwb_INDEX(msg_print.h Q)
 * @param	x			EChE\JnXItZbg
 * @param	y			EChE\JnYItZbg
 * @param	wait		`EFCg
 * @param	call_back	`悲Ƃ̃R[obN֐
 *
 * @return	bZ[WCfbNX
 *
 * call_back ݒɊւāÅ֐̈ 
 *   MSG_PRINT_HEADER \(msg_print.h Q)|C^
 * ƂȂ
 *
 * wait ݒ
 *   MSG_NOTRANS	fBXvC]Ȃ
 *@ MSG_ALL		fBXvCꊇ]
 *   1 `			PƂ̓]EFCgl
 * Ŏw(msg_print.h `)
 */
extern void PorutoName_WriteInst(PORUTO_FLAVORID id,int heapID,GF_BGL_BMPWIN *win,
		u8 font,u8 ofsx,u8 ofsy,u8 wait,GF_PRINTCOLOR col,void* call_back );






#endif	//__H_PORUTO_NAME_H__
