//=============================================================================
/**
 * @file	vZXǗwb_
 * @brief
 * @date	2005.07.25
 */
//=============================================================================

#ifndef	__PROCSYS_H__
#define	__PROCSYS_H__

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	vZX֐̌
 */
//------------------------------------------------------------------
typedef enum {
	PROC_RES_CONTINUE = 0,		///<p
	PROC_RES_FINISH,			///<I
}PROC_RESULT;

//------------------------------------------------------------------
/**
 * @brief	vZX\̂ւ̕sS^
 *
 * \̂̎ۂ̒`procsys.cɕĂ
 */
//------------------------------------------------------------------
typedef struct _PROC PROC;

//------------------------------------------------------------------
/**
 * @brief	vZX֐̌^`
 *
 * tB[hA퓬Aj[Ȃǂ̓֐͉Ľ`ō쐬
 */
//------------------------------------------------------------------
typedef PROC_RESULT (*PROC_FUNC)(PROC *, int *);

//------------------------------------------------------------------
/**
 * @brief	vZX`f[^
 *
 * vZX̏ECEI֐o^f[^
 * I[o[CIDŵ͍Ƃ_~[
 */
//------------------------------------------------------------------
#define	NO_OVERLAY_ID	(0xffffffff)

typedef struct {
	PROC_FUNC init_func;
	PROC_FUNC main_func;
	PROC_FUNC end_func;
	const FSOverlayID overlay_id;
}PROC_DATA;

//===========================================================================
//===========================================================================
extern PROC * PROC_Create(const PROC_DATA * data, void * parent_work, const int heap_id);
extern PROC * PROC_CreateChild(	PROC * proc,
								const PROC_DATA * data,
								void * parent_work,
								const int heap_id);

extern void PROC_Delete(PROC * proc);

//------------------------------------------------------------------
//------------------------------------------------------------------
extern BOOL ProcMain(PROC * proc);

//------------------------------------------------------------------
//------------------------------------------------------------------
extern void * PROC_AllocWork(PROC * proc, int size, int heap_id);
extern void * PROC_GetWork(PROC * proc);
extern void PROC_FreeWork(PROC * proc);
extern void * PROC_GetParentWork(PROC * proc);
extern void PROC_SetPause(PROC * proc, BOOL pause_flag);



#endif /* __PROCSYS_H__ */
