//==============================================================================================
/**
 * @file	snd_play.h
 * @brief	TEhĐ֐
 * @author	Satoshi Nohara
 * @date	2005.06.09
 *
 * ֘At@C snd_tool.h
 */
//==============================================================================================

//==============================================================================================
//
//	extern錾
//
//==============================================================================================

//==============================================================================================
//
//	BGM֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BANK_BASICō쐬BGMĐ(Să[hς݃f[^Đ)
 *
 * @param	no		BGMio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * f[^̃[h܂Bʏ͎gp܂B
 */
//--------------------------------------------------------------
extern BOOL Snd_BgmPlayBasicData( u16 no );

//--------------------------------------------------------------
/**
 * @brief	BGMĐ(SȄɐς񂾃f[^JāABGMf[^̃[hs)
 *
 * @param	no		BGMio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern BOOL Snd_BgmPlay( u16 no );

//--------------------------------------------------------------
/**
 * @brief	oBGMĐ(CoAT|[gAĂ)
 *
 * @param	scene	V[()io[
 * @param	no		BGMio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * ABGMȂǂŎgpI
 */
//--------------------------------------------------------------
extern BOOL Snd_PlayerFieldDemoBgmPlay( u8 scene, u16 no );

//--------------------------------------------------------------
/**
 * @brief	BGM~
 *
 * @param	no		BGMio[
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_BgmStop( u16 no, int frame );

//--------------------------------------------------------------
/**
 * @brief	V[PXtF[hC(BGM̂)(V[`snd_tool.hQ)
 *
 * @param	vol		tF[hC̃{[(0-127)
 * @param	frame	t[
 * @param	flag	"BGM_FADEIN_START_VOL_NOW = ݂̉ʂFADEIN"
 * @param	(flag)	"BGM_FADEIN_START_VOL_MIN = 0FADEIN"
 *
 * @retval	none
 *
 * tF[hJE^[ZbgĂ܂
 */
//--------------------------------------------------------------
extern void Snd_BgmFadeIn( int vol, int frame, int flag );

//--------------------------------------------------------------
/**
 * @brief	V[PXtF[hAEg(BGM̂)(V[`snd_tool.hQ)
 *
 * @param	vol		tF[hAEg̃{[(0-127)
 * @param	frame	t[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_BgmFadeOut( int vol, int frame );

//--------------------------------------------------------------
/**
 * @brief	tF[hI҂
 *
 * @param	none
 *
 * @retval	"0=IA0ȊO̓tF[hJE^[̒l"
 */
//--------------------------------------------------------------
extern int Snd_FadeCheck();

//--------------------------------------------------------------
/**
 * @brief	BGMI҂
 *
 * @param	no		BGMio[
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 */
//--------------------------------------------------------------
extern int Snd_BgmPlayCheck( u16 no );

//--------------------------------------------------------------
/**
 * @brief	SĂ̍Đ̃V[PX~
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_Stop(void);

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMȊȎSĂ̍Đ̃V[PX~
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_StopEx(void);


//==============================================================================================
//
//	SE֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	SEĐ + p
 *
 * @param	no		SEio[
 * @param	pan		-128 ` 127
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern BOOL Snd_SePlayPan( u16 no, int pan );

//--------------------------------------------------------------
/**
 * @brief	SEĐ
 *
 * @param	no		SEio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern BOOL Snd_SePlay( u16 no );

//--------------------------------------------------------------
/**
 * @brief	SE~(V[PXio[w)
 *
 * @param	no		SEԍ
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_SeStopBySeqNo( u16 no, int frame );

//--------------------------------------------------------------
/**
 * @brief	SE~(TEhnhw)
 *
 * @param	type	TEhnh^Cv
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 */
//--------------------------------------------------------------
extern void Snd_SeStop( int type, int frame );

//--------------------------------------------------------------
/**
 * @brief	SEI҂
 *
 * @param	no		SEio[
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 *
 * w肵SEIĂ邩`FbNł͂ȂA
 * w肵SE̎gpvC[ɁA
 * Đ̃V[PX邩̃`FbNłB
 */
//--------------------------------------------------------------
extern int Snd_SePlayCheck(u16 no);

//--------------------------------------------------------------
/**
 * @brief	SĂSEI҂
 *
 * @param	none
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 */
//--------------------------------------------------------------
extern int Snd_SePlayCheckAll();

//--------------------------------------------------------------
/**
 * @brief	SEPAN()ύX
 *
 * @param	no		SEio[
 * @param	bitmask	gbNrbg}XN
 * @param	pan		-128 ` 127
 *
 * @retval	none
 *
 * trackBitMaskŁAݒ肷gbNw肵܂B
 * ʃrbg珇ɁAgbN0AgbN1AgbN2AAA\A
 * rbgĂgbNSĂɑ΂āApύX܂B
 *
 * Ⴆ΁AgbN2ƃgbN5̃pύXꍇ́A 
 * (1 << 2) | (1 << 5) Ȃ킿A0x0024 Ƃ܂B 
 */
//--------------------------------------------------------------
extern void Snd_SePanSet( u16 no, u16 bitmask, int pan );

//--------------------------------------------------------------
/**
 * @brief	SĂSEPAN()ύX
 *
 * @param	pan		-128 ` 127
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_SePanSetAll( int pan );


//==============================================================================================
//
//	|P֘A
//
//==============================================================================================
 
//--------------------------------------------------------------
/**
 * @brief	|PĐ(ōĐOɒ~Ă΂܂)
 *
 * @param	no		|Pio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * OƂāAR[Xgp鎞́A~͌Ă΂܂B
 *
 * |Pio[ƁAV[PXf[^̕тmFI
 * (S}Ӄio[ɑΉĂ炵B050722V)
 *
 * <>
 * V[PXA[JCuƁAvC[q[vgȂI
 * V[PXƁAvC[q[vgI
 */
//--------------------------------------------------------------
extern BOOL Snd_PMVoicePlay( u16 no );
 
//--------------------------------------------------------------
/**
 * @brief	|P~(TEhnhw)
 *
 * @param	p		TEhnh̃AhX
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 *
 * R[X(p)TEhnh~Ă܂B
 */
//--------------------------------------------------------------
extern void Snd_PMVoiceStop( int frame );

//--------------------------------------------------------------
/**
 * @brief	|PI҂
 *
 * @param	none
 *
 * @retval	"Đ=1ȏAĐI=0"
 */
//--------------------------------------------------------------
extern int Snd_PMVoicePlayCheck(void);

//--------------------------------------------------------------
/**
 * @brief	|Pp^[Zbg
 *
 * @param	ptn		p^[(snd_tool.hQ)
 * @param	no		|Pio[
 * @param	pan		-128 ` 127
 * @param	vol		{[(0-127)
 * @param	heap_id	q[vID
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * gpĂȂɂ́A"PV_PTN_PARAM_NONE"nĂĉ
 */
//--------------------------------------------------------------
extern BOOL Snd_PMVoicePlayEx( int ptn, u16 no, int pan, int vol, int heap_id );

//--------------------------------------------------------------
/**
 * @brief	}ӃR[XĐ
 *
 * @param	no			|Pio[
 * @param	chorus_vol	R[X`l{[(0-127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_PMVoicePlayPtn_ZukanChorus( u16 no, int chorus_vol );


//==============================================================================================
//
//	ME֘A
//	BGM̔g`̂݊Jđv(ȂƗeʑȂmF)
//
//	gp1(MEIAʃEFCgZbgBGMĊJ)
//	Snd_MePlay(bgm,&wk)
//	if( Snd_MePlayCheckBgmPlay(&wk) == FALSE ){
//
//	gp2(MEIABGMĊJ)
//	Snd_MePlay(bgm,&wk)
//	wk = 0;
//	if( Snd_MePlayCheckBgmPlay(&wk) == FALSE ){
//
//	gp3(MEIAEFCgw肵BGMĊJ)
//	Snd_MePlay(bgm,&wk)
//	wk = 120;
//	if( Snd_MePlayCheckBgmPlay(&wk) == FALSE ){
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BGM|[Y  MEĐ
 *
 * @param	no			MEio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * EFCg[NMEʃEFCglZbg܂
 */
//--------------------------------------------------------------
extern BOOL Snd_MePlay( u16 no );

//--------------------------------------------------------------
/**
 * @brief	MEI҂
 *
 * @param	none
 *
 * @retval	"Đ=TRUEAĐI=FALSE"
 */
//--------------------------------------------------------------
extern int Snd_MePlayCheck(void);

//--------------------------------------------------------------
/**
 * @brief	ME~
 *
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 */
//--------------------------------------------------------------
//extern void Snd_MeStop( int frame );

//--------------------------------------------------------------
/**
 * @brief	MEI҂  IAEFCgĂBGM𕜋A
 *
 * @param	none
 *
 * @retval	"MEĐ=TRUEAEFCg=TRUEABGMĊJ=FALSE"
 */
//--------------------------------------------------------------
extern int Snd_MePlayCheckBgmPlay(void);


//==============================================================================================
//
//	gȂBBB
//
//==============================================================================================
#if 0
//--------------------------------------------------------------
/**
 * @brief	BGMf[^[h
 *
 * @param	no		BGMio[
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * gp(1)	}bvf[^擾BGMf[^[h
 * Snd_HeapLoadState( SE[h̊Kwio[ );	//BGMJ
 * Snd_LoadBgm( map->bgm );							//BGM[h
 *
 * gp(2)	w肵BGMf[^[h
 * Snd_HeapLoadState( SE[h̊Kwio[ );	//BGMJ
 * Snd_LoadBgm( SEQ_DOORO_X3 );						//BGM[h
 *
 * HA̋ڂł́ABGMf[^̂݃[h邱ƂɂȂ̂ŁA
 * SEABGM̏Ƀf[^[h悤ɂāABGMJA[hƂɂ
 */
//--------------------------------------------------------------
extern int Snd_LoadBgm( u16 no );

//--------------------------------------------------------------
/**
 * @brief	莝|P[h
 *
 * @param	none
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * Kwۑ͂ĂȂI
 */
//--------------------------------------------------------------
extern int Snd_LoadTemotiPMVoice();

//--------------------------------------------------------------
/**
 * @brief	w肵|P[h
 *
 * @param	no		|Pio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * Kwۑ͂ĂȂI
 */
//--------------------------------------------------------------
extern int Snd_LoadPMVoice( u16 no );

//--------------------------------------------------------------
/**
 * @brief	tF[hI҂
 *
 * @param	none
 *
 * @retval	"ĐI=0A0ȊO̓tF[hJE^[̒l"
 *
 * tF[hJE^[炷Ă܂
 */
//--------------------------------------------------------------
extern int Snd_BgmFadeCheck(void);

//--------------------------------------------------------------
/**
 * @brief	|P~(V[PXio[w)
 *
 * @param	no		BGMԍ
 * @param	frame	w肵t[ďXɉʂ𗎂ƂĂ
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_PMVoiceStopBySeqNo( u16 no, int frame );

#endif



