//==============================================================================================
/**
 * @file	snd_tool.h
 * @brief	TEhc[֐
 * @author	Satoshi Nohara
 * @date	2005.06.09
 */
//==============================================================================================
#ifndef __SND_TOOL_H__
#define __SND_TOOL_H__

#include "system/snd_def.h"
#include "system/snd_play.h"

//TEhf[^̎wԍł͂ȂATEhfUCi[`xōs悤ɂȂ
//C:\NitroSystem\build\demos\snd\data
//#include "C:\NitroSystem\tools\nitro\SoundPlayer\data\sound_data.sadl"
#include "data/sound/sound_data.sadl"		//TEhxt@C


//==============================================================================================
//
//	`
//
//==============================================================================================
//sound_data.sarc̕ύX́AӂI
#define SND_PLAYER_EXTRA_CH		(13)		//\̃`l(ʐMog{CX`bgŎgp)

//TEhVXeԒ`
enum{
	//SND_STATUS_INIT = 0,
	//SND_STATUS_PLAYSTART,
	//SND_STATUS_FADENEXT,
	//SND_STATUS_FADENEXTFADE,
	SND_STATUS_STOP = 0,					//~
	SND_STATUS_PLAY,						//Đ
	SND_STATUS_PLAING,						//Đ
	SND_STATUS_FADEIN,						//tF[hC
	SND_STATUS_FADEOUT,						//tF[hAEg
	SND_STATUS_FADEOUT_NEXT_PLAY,			//tF[hAEg  ǉg`ǂݍ  BGMĐ
	SND_STATUS_FADEOUT_NEXT_FADEIN,			//tF[hAEg  ǉg`ǂݍ  BGMtF[hC
	SND_STATUS_TRACKFADE,					//gbNtF[h
};

//Đx`
enum{
	WAVEOUT_PLAY_SPDx05		=	(32768 / 2),				//21{
	WAVEOUT_PLAY_SPDx1		=	(32768),					//1{
	WAVEOUT_PLAY_SPDx2		=	(32768 * 2),				//2{
	WAVEOUT_PLAY_SPDx3		=	(32768 * 3),				//3{
};

//tF[ht[`
enum{
	BGM_FADE_ZUKAN_TIME		=	(15),						//}ӉBGM
	BGM_FADE_ZUKAN_NAKIGOE_TIME	 =	(3),					//}ӖBGM
	BGM_FADE_TR_CASE_TIME	= 	(15),						//g[i[P[XBGM
	BGM_FADE_ROOM_TIME		=	(30),						//؂ւ
	BGM_FADE_FIELD_TIME		= 	(60),						//tB[h(][)؂ւ
	BGM_FADE_CAVE_TIME		=	(60),						//Ȁo
	BGM_FADE_TANKOU_TIME	= 	(60),						//YzBGM؂ւ
	BGM_FADE_CLIP_TIME		= 	(30),						//C[WNbv؂ւ
	BGM_FADE_VCHAT_TIME		= 	(30),						//{CX`bg؂ւ
	BGM_FADE_OTHERS_TIME	= 	(60),						//̑
	BGM_FADE_UG_TIME		= 	(30),						//nւ̍s
	BGM_FADE_MAPJUMP_TIME	= 	(40),						//map_jump.c
};

//tF[h[h`(fld_bgm.c)
enum{
	BGM_FADE_ROOM_MODE		=	(0),						//̏o
	BGM_FADE_FIELD_MODE,									//tB[h̐؂ւ
	BGM_FADE_CAVE_MODE,										//Ȁo
	BGM_FADE_OTHERS_MODE,									//̑
};

//V[()`
enum{
	SND_SCENE_DUMMY = 0,				//_~[(NAR[h)

	//C
	SND_SCENE_MAIN = 1,					//X^[gio[
	SND_SCENE_TITLE = SND_SCENE_MAIN,	//^Cg
	SND_SCENE_OPENING,					//I[vjO
	SND_SCENE_TRADE,					//f
	SND_SCENE_FIELD,					//tB[h
	SND_SCENE_BATTLE,					//og
	SND_SCENE_CONTEST,					//ReXg
	SND_SCENE_CON_IMAGE,				//C[WNbv(ReXg)(06.04.18)
	SND_SCENE_DENDOU,					//af
	SND_SCENE_AGB,						//AGB̃|PĂ
	SND_SCENE_HUSIGI,					//ӂȂ̉
	SND_SCENE_P2P,						//P2P(p[h)
	SND_SCENE_NUTMIXER,					//
	//SND_SCENE_WORLDTRADE,				//E(GTC)
	SND_SCENE_EGG,						//^}Sz
	SND_SCENE_ENDING,					//GfBO

	//Tu(CʂĂ΂)
	SND_SCENE_SUB = 51,					//X^[gio[
	SND_SCENE_SUB_BAG = SND_SCENE_SUB,	//obO
	SND_SCENE_SUB_NAMEIN,				//O
	SND_SCENE_SUB_IMAGE,				//C[WNbv
	SND_SCENE_SUB_ZUKAN,				//}
	SND_SCENE_SUB_TOWNMAP,				//^E}bv
	SND_SCENE_SUB_TRCARD,				//g[i[J[h
	SND_SCENE_SUB_POKELIST,				//|PXg
	SND_SCENE_SUB_DIG,					//Ό@
	SND_SCENE_SUB_CUSTOM,				//JX^{[
	SND_SCENE_SUB_FIRSTPOKE,			//ŏ̃|PI
	SND_SCENE_SUB_PST,					//|PXe[^X
	SND_SCENE_SUB_PMS,					//ȈՉb
	SND_SCENE_SUB_CLIMAX,				//NC}bNX(eKR)ʐ؂ւł͂ȂI
	SND_SCENE_SUB_SHIP,					//D(f)ʐ؂ւł͂ȂI
	SND_SCENE_SUB_TRAIN,				//bR(f)ʐ؂ւł͂ȂI
	SND_SCENE_SUB_SLOT,					//Xbg
	SND_SCENE_SUB_FNOTE,				//`m[g

	//V[֘A
	//Snd_DataSetByScene( u8 scene, u16 no, int flag );	
	//Snd_LoadSeByScene( u8 scene );
};

//TEhnh`
enum{
	SND_HANDLE_FIELD = 0,									//tB[hBGMTEhnh
	SND_HANDLE_PMVOICE,										//|PTEhnh
	SND_HANDLE_ME,											//METEhnh
	SND_HANDLE_SE_1,										//SETEhnh
	SND_HANDLE_SE_2,										//SETEhnh
	SND_HANDLE_SE_3,										//SETEhnh
	SND_HANDLE_SE_4,										//SETEhnh
	SND_HANDLE_BGM,											//tB[hȊOBGMnh
	SND_HANDLE_CHORUS,										//R[X(p)nh

	SND_HANDLE_MAX,											//ő吔
};

//TvO[gႢƁALv`@\gɁA
//HĂȂĂAȂ̂ŒӁI
#define REVERB_SAMPLING_RATE	(16000)						//TvO[g(o[u)
#define SAMPLING_RATE		(8000)							//TvO[g
//#define SAMPLING_RATE		(32000)//(8000)					//TvO[g
//#define SAMPLING_TIME		(2)								//TvO鎞
//#define WAVE_SAMPLE		(SAMPLING_RATE * SAMPLING_TIME)	//TvOɕKvȃf[^

#define WAVEOUT_CH_NORMAL	(14)							//g`Ŏgp`lNO
#define WAVEOUT_CH_CHORUS	(15)							//g`Ŏgp`lNO(R[X)

//tF[hC鎞̊Jnʒ`
#define BGM_FADEIN_START_VOL_MIN	(0)						//tF[hC鎞̊Jn=0
#define BGM_FADEIN_START_VOL_NOW	(1)						//tF[hC鎞̊Jn=̂܂

//BGM炷܂ł̃EFCg
#define BGM_NEXT_WAIT_CAVE_TIME	(15)						//Ȁo

//tF[hCt[
#define BGM_FADEIN_CYCLE_TIME	(30)					//]ԂɏĂ鎞̃tF[hC
#define BGM_FADEIN_RESTART_TIME	(30)					//Q[I[o[ɍĊJ鎞̃tF[hC

#define FILTER_SIZE				(8)							//tB^[TCY

#define SEQ_DP_TRADE			(SEQ_KOUKAN)				//BGMio[

//TEhTCB̒`
enum{
	SND_TCB_PMVOICE_LENGTH = 0,				//Đ

	SND_TCB_MAX,							//ő吔
};

//}Ӗ
//#define SND_ZUKAN_PITCH_MIN		(-(64*12) * 1)		//sb`̍Œᐔ
#define SND_ZUKAN_PITCH_MIN		(-(64*12) * 2)			//sb`̍Œᐔ
#define SND_ZUKAN_PITCH_CHORUS	(20)					//R[X̂sb`

//Snd_PMVoicePlayEẍɎw
#define PV_PTN_PARAM_NONE		(0x1ff)					//p[^Ȃ

#define SND_BANK_CONTINUE		(0)						//oN̂܂܌p
#define SND_BANK_CHANGE			(1)						//oN؂ւ

#define SND_HALF_PITCH			(64)					//̒l

#define SND_VCHAT_VOL_LV		(5)						//{CX`bgɉʂ郌x


//==============================================================================================
//
//	\̐錾
//
//==============================================================================================
//g`f[^ĐɕKvȃf[^\
typedef struct{
	NNSSndWaveOutHandle*	handle;					//g`Đnh
	NNSSndWaveFormat		format;					//g`f[^tH[}bg
	const void*				dataaddr;				//g`f[^̐擪AhX
	BOOL					loopFlag;				//[vtO
	int						loopStartSample;		//[vJnTvʒu
	int						samples;				//g`f[^̃Tv
	int						sampleRate;				//g`f[^̃TvO[g
	int						volume;					//
	int						speed;					//ĐXs[h
	int						pan;					//p(0-127)
}WAVEOUT_WORK;

typedef s16 smp_t;

//Lv`GtFNg̃R[obN\
typedef struct EffectCallbackInfo{
    smp_t sample[ FILTER_SIZE-1 ][2];
} EffectCallbackInfo;


//==============================================================================================
//
//	extern錾
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[PXA[JCuԍݒ
 *
 * @param	p		TEhnh̃AhX
 * @param	arc_no	V[PXA[JCuԍ
 * @param	index	CfbNX
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetSeqArcNo( NNSSndHandle *p, int arc_no, int index );

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMŒtOZbg(Z[u͂Ȃ)
 *
 * @param	flag	1=BGM؂ւȂA0E=BGM؂ւ(ʏ)
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_CtrlBgmFlagSet( u8 flag );

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMŒtO`FbN(Z[u͂Ȃ)
 *
 * @param	none
 *
 * @retval	"1=BGM؂ւȂA0E=BGM؂ւ(ʏ)"
 */
//--------------------------------------------------------------
extern u8 Snd_CtrlBgmFlagCheck( void );

//--------------------------------------------------------------
/**
 * @brief	BGMio[XV
 *
 * @param	no		XVBGMio[
 *
 * @retval	none
 *
 * BGMio[(next_bgm_no)NAĂI
 */
//--------------------------------------------------------------
extern void Snd_NowBgmNoSet( u16 no );

//--------------------------------------------------------------
/**
 * @brief	BGMio[擾
 *
 * @param	none
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
extern u16 Snd_NowBgmNoGet();

//--------------------------------------------------------------
/**
 * @brief	BGMio[XV
 *
 * @param	no		XVBGMio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_NextBgmNoSet( u16 no );

//--------------------------------------------------------------
/**
 * @brief	BGMio[擾
 *
 * @param	none
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
extern u16 Snd_NextBgmNoGet();

//--------------------------------------------------------------
/**
 * @brief	][BGMio[Zbg
 *
 * @param	bgm		BGMio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_ZoneBgmSet( u16 bgm );


//==============================================================================================
//
//	V[PX֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[PXĐ(vC[ԍw)(ʏgpȂI)
 *
 * @param	handle_no	TEhnhio[
 * @param	player_no	vC[io[
 * @param	no			BGMio[
 *
 * @retval	"Đ=TRUEAs=FALSE"
 *
 * ĐɐƁATEhnhɃV[PXт܂B 
 *
 * V[PXf[^vC[q[vŃ[h鎞́A
 * eʂȂƍĐsI
 */
//--------------------------------------------------------------
extern BOOL Snd_ArcPlayerStartSeqEx( int handle_no, int player_no, u16 no );


//==============================================================================================
//
//	vC[֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Đ̃V[PX̐Ԃ
 *
 * @param	player_no	vC[ԍ
 *
 * @retval	"Đ̃V[PX̐"
 */
//--------------------------------------------------------------
extern int Snd_PlayerCountPlayingSeq( int player_no );

//--------------------------------------------------------------
/**
 * @brief	wvC[̃V[PXő哯Đݒ(dĐɎgpI)
 *
 * @param	player_no	vC[ԍ
 * @param	no			V[PXő哯Đ
 *
 * @retval	"ύXÕV[PXő哯Đ"
 *
 * PLAYER_FIELD	: tB[hBGM
 * PLAYER_ME 	: ME
 * PLAYER_SE_1 	: ʉ
 * PLAYER_SE_2 	: ʉ
 * PLAYER_SE_3 	: ʉ
 * PLAYER_SE_4 	: ʉ
 * PLAYER_PV	: |P
 * PLAYER_VOICE	: 
 * PLAYER_BGM	: tB[hȊOBGM
 *
 * gṕAK̐ݒɖ߂悤ɂĉI
 */
//--------------------------------------------------------------
//extern u8 Snd_PlayerSetPlayableSeqCount( int player_no, int no );

//--------------------------------------------------------------
/**
 * @brief	V[PXio[vC[io[擾
 *
 * @param	no		V[PXio[
 *
 * @retval	"vC[io["
 */
//--------------------------------------------------------------
extern u8 Snd_GetPlayerNo( u16 no );

//--------------------------------------------------------------
/**
 * @brief	TEhnhV[PXio[擾
 *
 * @param	p			TEhnh̃AhX
 *
 * @retval	"V[PXio["
 */
//--------------------------------------------------------------
extern int Snd_GetSeqNo( NNSSndHandle *p );


//==============================================================================================
//
//	oN֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	oN\̂̃AhX擾
 *
 * @param	no		V[PXio[
 *
 * @retval	"oN\̂̃AhX"
 */
//--------------------------------------------------------------
extern const NNSSndArcBankInfo* Snd_GetBankInfo( int no );

//--------------------------------------------------------------
/**
 * @brief	V[PXio[oNio[擾
 *
 * @param	no		V[PXio[
 *
 * @retval	"0=G[A0ȊO=oNio["
 */
//--------------------------------------------------------------
extern u16 Snd_GetBankNo( int no );


//==============================================================================================
//
//	TEhf[^̃[h֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[Zbg
 *
 * @param	scene	V[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_SceneSet( u8 scene );

//--------------------------------------------------------------
/**
 * @brief	V[L[ɂāASEf[^[h(V[`snd_tool.hQ)
 *
 * @param	scene		V[
 *
 * @retval	"=TRUEAs=FALSE"
 */
//--------------------------------------------------------------
extern int Snd_LoadSeByScene( u8 scene );

//--------------------------------------------------------------
/**
 * @brief	V[L[ɂāATEhf[^Zbg
 *
 * @param	scene	V[
 * @param	no		V[PXio[
 * @param	flag	"gp"
 *
 * @retval	"0=ȂA1=f[^[h"
 */
//--------------------------------------------------------------
extern BOOL Snd_DataSetByScene( u8 scene, u16 no, int flag );

//--------------------------------------------------------------
/**
 * @brief	tB[hf[^Zbg̋ʏ(snd_tool.c,snd_play.c)
 *
 * @param	no			V[PXio[
 * @param	old_bank_no	tB[h̃oNio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_FieldDataSetSub( u16 no, u16 old_bank_no );

//--------------------------------------------------------------
/**
 * @brief	Ȃɐ؂ւ鎞̃TEhf[^Zbg
 *
 * @param	no		V[PXio[
 *
 * @retval	none
 *
 * FIELDĂ΂邱ƂOƂĂI
 */
//--------------------------------------------------------------
extern void Snd_EyeBgmSet( u16 no );

//--------------------------------------------------------------
/**
 * @brief	[hĂȂԂɂ(TEheXĝ݂Ŏg)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_HeapStateClear(void);


//==============================================================================================
//
//	q[v֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	BGM̌̃f[^
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_DeleteHeapAfterBgm( void );

//--------------------------------------------------------------
/**
 * @brief	Kwx擾
 *
 * @param	wk		SND_WORK^̃AhX
 * @param	type	Kwx(snd_tool.hQ)
 *
 * @retval	"Kwx"
 */
//--------------------------------------------------------------
extern int Snd_GetHeapSaveLv( int type );


//==============================================================================================
//
//	V[PX֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	V[PXꎞ~܂͍ĊJ܂B 
 *
 * @param	player	vC[io[(sound_data.sadlQ)
 * @param	flag	TRUE=ꎞ~AFALSE=ĊJ
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 * ԂςȂꍇAႦ΁AłɈꎞ~Ԃ̎Ɉꎞ~sĂA܂B 
 *
 * 
 * ꎞ~sƁẢ͋Iɒ~܂B
 * ĊJsĂẢĐ邱Ƃ͂܂̂ŒӂĂB
 * ĊJ́Ãm[gI特n߂܂B 
 */
//--------------------------------------------------------------
extern void Snd_PlayerPause( u8 player, BOOL flag );

//--------------------------------------------------------------
/**
 * @brief	SẴ|[YĂ邩tÕNA
 *
 * @param	none
 *
 * @retval	none
 *
 * 퓬ŃQ[I[o[ɂȂāA|PZɖ߂ƂȂǂɁA
 * FieldDataSetĂԑOɁA|[YtONAȂƂȂI
 */
//--------------------------------------------------------------
extern void Snd_PauseClearAll();	//Snd_GameOverSetĂԂ悤ɕύX

//--------------------------------------------------------------
/**
 * @brief	V[PX̃{[XɕύX
 *
 * @param	handle_no	TEhnhio[
 * @param	vol			{[
 * @param	frame		t[
 *
 * @retval	none
 *
 * frames0̎AɌ݂̃{[lXV܂B
 * Ƃ΁Ã݂{[lƂ͖֌WɁA
 * {[lAʂ̒lɎԕωꍇ́A
 * ܂Aframes0ƂĂ̊֐ĂтāÃ݂{[lXVA
 * Ăѓ֐ŁAڕWƂ{[lw肵܂B 
 *
 * V[PXX^[g̃{[l0ŁA NNS_SndMain֐ŁA127 ɕω܂B
 * ̂߁AV[PXX^[gɂ̊֐ĂтƁA
 * {[0珙XɎw̃{[֕ω悤ȁAtF[hCʂ܂B 
 *
 * ̃{[ĺA NNS_SndPlayerSetVolume֐̒lƂ́AƗČʂ𔭊A
 * ݂ɏdˍ킳܂BAtF[hAEǵAŐݒ肵l͖܂B 
 */
//--------------------------------------------------------------
extern void Snd_PlayerMoveVolume( int handle_no, int vol, int frame );

//--------------------------------------------------------------
/**
 * @brief	SẴV[PX̃{[ύX
 *
 * @param	p		TEhnh̃AhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_AllPlayerMoveVolume( int vol, int frame );

//--------------------------------------------------------------
/**
 * @brief	V[PX̏{[ݒ
 *
 * @param	handle_no	TEhnhio[
 * @param	vol			{[(0-127)
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 *
 * {[̃ftHgĺAő127łB
 * ̒l̉e̓V[PXŜɂ܂B
 *
 * ̊֐́ANNS_SndArcPlayerStartSeq*֐ NNS_SndArcPlayerStartSeqArc*֐
 * ĂтĂ܂BēxÅ֐ĂтƁAݒ肵l㏑܂B
 * ㏑Ȃꍇ́A NNS_SndPlayerSetVolume֐ȂǂgĂB
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetInitialVolume( int handle_no, int vol );

//--------------------------------------------------------------
/**
 * @brief	{CX`bg̉ʑ
 *
 * @param	seq_no		V[PXio[
 * @param	handle_no	nhio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_VChatVolSet( int seq_no, int handle_no );

//--------------------------------------------------------------
/**
 * @brief	V[PX̏{[ݒ(V[PXio[w)
 *
 * @param	no		V[PXio[
 * @param	vol		{[(0-127)
 *
 * @retval	none
 *
 * TEhnh̏ꍇ́A܂B 
 *
 * {[̃ftHgĺAő127łB
 * ̒l̉e̓V[PXŜɂ܂B
 *
 * ̊֐́ANNS_SndArcPlayerStartSeq*֐ NNS_SndArcPlayerStartSeqArc*֐
 * ĂтĂ܂BēxÅ֐ĂтƁAݒ肵l㏑܂B
 * ㏑Ȃꍇ́A NNS_SndPlayerSetVolume֐ȂǂgĂB
 *
 * 
 * Snd_PMVoicePlay( no );
 * Snd_PlayerSetInitialVolume( handle_no. 30 );
 * {[30ōĐ
 *
 * ̂ƁA
 * Snd_PMVoicePlay( no );
 * ftHg̒l127ōĐ(ɖ߂Ă)
 *
 * tɂƁAɃ{[30ɂA
 * Snd_PlayerSetInitialVolume( handle_no. 30 );
 * 𖈉Zbg
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetInitialVolumeBySeqNo( u16 no, int vol );

//--------------------------------------------------------------
/**
 * @brief	gbNύX
 *
 * @param	handle_no	TEhnhio[
 * @param	bitmask		gbNrbg}XN
 * @param	pitch		ω̒l(-32768`32767)
 *
 * @retval	none
 *
 * pitch͐̒lōցA̒lŒႢ֕ω܂B 
 * }64ł傤ǔω܂BiĂԂтɌʂݐς킯ł͂܂)
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetTrackPitch( int handle_no, u16 bitmask, int pitch );

//--------------------------------------------------------------
/**
 * @brief	gbNύX(V[PXio[w)
 *
 * @param	no			V[PXio[
 * @param	bitmask		gbNrbg}XN
 * @param	pitch		ω̒l(-32768`32767)
 *
 * @retval	none
 *
 * pitch͐̒lōցA̒lŒႢ֕ω܂B 
 * }64ł傤ǔω܂BiĂԂтɌʂݐς킯ł͂܂)
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetTrackPitchBySeqNo( u16 no, u16 bitmask, int pitch );

//--------------------------------------------------------------
/**
 * @brief	gbNpύX
 *
 * @param	handle_no	TEhnhio[
 * @param	bitmask		gbNrbg}XN
 * @param	pan			pω̒l(-128`127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetTrackPan( int handle_no, u16 bitmask, int pan );


//==============================================================================================
//
//	}CN֘A
//
//==============================================================================================
  
//--------------------------------------------------------------
/**
 * @brief	^Jn
 *
 * @param	p		MICAutoParam^̃|C^
 *
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
extern MICResult Snd_MicStartAutoSampling( MICAutoParam* p );

//--------------------------------------------------------------
/**
 * @brief	^~
 *
 * @param	none
 *
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
extern MICResult Snd_MicStopAutoSampling(void);


//--------------------------------------------------------------
/**
 * @brief	蓮^
 * @param	type      TvO[g̃^Cv
 * @param	heap      L^̈
 * @param	callback  L^ۂ̃R[obN
 * @param	arg       R[obNɓn|C^
 * @retval	"MIC_RESULT_SUCCESS		Ɋ"
 * @retval	"ȊO				炩̌Ŏs"
 */
//--------------------------------------------------------------
extern MICResult Snd_MicManualSampling(MICSamplingType type ,void* heap,MICCallback callback,void* arg);

//==============================================================================================
//
//	g`Đ֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	g`nh̃AhX擾
 *
 * @param	no		gp`lio[
 *
 * @retval	"g`nh̃AhX"
 *
 * BGM		NNSSndHandle
 * g`		NNSSndWaveOutHandle
 * nh̃^CvႤ̂ŒӁI
 */
//--------------------------------------------------------------
extern NNSSndWaveOutHandle * Snd_WaveOutHandleGet( u32 no );

//--------------------------------------------------------------
/**
 * @brief	g`ĐpɃ`lmۂ
 *
 * @param	no		gp`lio[
 *
 * @retval	BOOL	TRUE=AFALSE=s
 */
//--------------------------------------------------------------
extern BOOL Snd_WaveOutAllocChannel( u32 no );
 
//--------------------------------------------------------------
/**
 * @brief	g`Đp̃`l
 *
 * @param	no		gp`lio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_WaveOutFreeChannel( u32 no );

//--------------------------------------------------------------
/**
 * @brief	g`Đ
 *
 * @param	p		WAVEOUT_WORK^̃|C^
 * @param	ch		gp`lio[(ʏ́AWAVEOUT_CH_NORMAL)
 *
 * @retval	BOOL	TRUE=AFALSE=s
 */
//--------------------------------------------------------------
BOOL Snd_WaveOutStart( WAVEOUT_WORK *p, u32 ch );

//--------------------------------------------------------------
/**
 * @brief	g`~
 *
 * @param	no		gp`lio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_WaveOutStop( u32 no );

//--------------------------------------------------------------
/**
 * @brief	g`Đ`FbN
 *
 * @param	no		gp`lio[
 *
 * @retval	BOOL	TRUE=ĐAFALSE=ĐłȂ
 */
//--------------------------------------------------------------
extern BOOL Snd_WaveOutIsPlaying( u32 no );

//--------------------------------------------------------------
/**
 * @brief	g`ĐPANݒ
 *
 * @param	no		gp`lio[
 * @param	pan		p̒l(0-127A64center)
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_WaveOutSetPan( u32 no, u8 pan );

//--------------------------------------------------------------
/**
 * @brief	g`Đ̍ĐXs[hݒ
 *
 * @param	no		gp`lio[
 * @param	spd		ĐXs[h
 *
 * @retval	none
 *
 * 21{	(32768 / 2)
 * 1{		(32768)
 * 2{		(32768 * 2)
 * 3{		(32768 * 3)
 */
//--------------------------------------------------------------
extern void Snd_WaveOutSetSpeed( u32 no, u32 spd );
 
//--------------------------------------------------------------
/**
 * @brief	g`Đ̃{[ύX
 *
 * @param	no		gp`lio[
 * @param	vol		{[l(0-127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_WaveOutSetVolume( u32 no, int vol );
 

//==============================================================================================
//
//	g`tĐ֘A(|P̖p)
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	tĐ̃|PĐ
 *
 * @param	no		|Pio[
 * @param	vol		{[(0-127)
 * @param	pan		p(0-127)
 * @param	ch		gp`lio[(ʏ́AWAVEOUT_CH_NORMAL)
 * @param	heap_id	q[vID
 *
 * @retval	BOOL	TRUE=AFALSE=s
 *
 * ŋtĐp̃obt@mۂĂ܂B
 *
 * Snd_WaveOutStopReverse(...)ĂŁA
 * obt@JĂB
 *
 * |Pio[Ɩ̔g`A[JCuio[ɂȂ悤ɂI
 */
//--------------------------------------------------------------
extern BOOL Snd_WaveOutStartReverse( u16 no, int vol, int pan, u32 ch, int heap_id );

//--------------------------------------------------------------
/**
 * @brief	tĐ̃|P~ăobt@J
 *
 * @param	no		gp`lio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_WaveOutStopReverse( u32 no );


//==============================================================================================
//
//	Lv`֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Lv`[XbhN(Ƃ肠Dx͌Œ)
 *
 * @param	none
 *
 * @retval	none
 *
 * Lv`[XbhNĂƁA
 * Lv`[IRQnhł͂ȂA
 * Lv`[Xbhŏ悤ɂȂ܂B 
 *
 * Xbh̗DxthreadPrióA
 * ʏAXg[Xbhݒ肵܂B
 * xƁAȍĐsȂȂ܂̂ŁAӂĂB 
 */
//--------------------------------------------------------------
extern void Snd_CaptureCreateThread(void);
  
//--------------------------------------------------------------
/**
 * @brief	Lv`s擾
 *
 * @param	none
 *
 * @retval	"TRUE=sAFALSE=sĂȂ"
 */
//--------------------------------------------------------------
extern BOOL Snd_CaptureIsActive(void);

//--------------------------------------------------------------
/**
 * @brief	s̃Lv`^Cv擾
 *
 * @param	none
 *
 * @retval	"NNS_SND_CAPTURE_TYPE_REVERB = o[u"
 * @retval	"NNS_SND_CAPTURE_TYPE_EFFECT = GtFNg"
 * @retval	"NNS_SND_CAPTURE_TYPE_SAMPLING = TvO"
 *
 * Lv`[s̎̂݌ĂтƂł܂B
 * Lv`[sǂ𒲂ׂ邽߂ɂ́A NNS_SndCaptureIsActive֐Ăт܂B 
 */
//--------------------------------------------------------------
extern NNSSndCaptureType Snd_CaptureGetCaptureType(void);
 
//--------------------------------------------------------------
/**
 * @brief	o̓GtFNgύX
 *
 * @param	none
 *
 * @retval	none
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL		܂(ʏ̃XeI[h)
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_MONO		m[h 
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_SURROUND	TEh[h 
 * DSXs[J[o͂ƂɁA
 * Xs[J[ʒuLĉ悤ɂGtFNg܂B
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_HEADPHONE	wbhtH[h 
 * wbhtHgpɁA̕SyGtFNg܂B
 */
//--------------------------------------------------------------
extern void Snd_CaptureChangeOutputEffect( NNSSndCaptureOutputEffectType type );


//==============================================================================================
//
//	Lv`@o[u
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	o̓GtFNgJn
 *
 * @param	none
 *
 * @retval	none
 *
 * Lv`[@\gă~LT[o͂Lv`A
 * R[obN֐ŃGtFNgsAŏIƂďo͂܂B
 * GtFNg쒆́A16`l2`li`l1yу`l3j܂B
 * `l1܂̓`l3AV[PXɂĎgp̏ꍇA
 * ̉͋Iɒ~܂B 
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL		܂(ʏ̃XeI[h)
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_MONO		m[h 
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_SURROUND	TEh[h 
 * DSXs[J[o͂ƂɁA
 * Xs[J[ʒuLĉ悤ɂGtFNg܂B
 *
 * NNS_SND_CAPTURE_OUTPUT_EFFECT_HEADPHONE	wbhtH[h 
 * wbhtHgpɁA̕SyGtFNg܂B
 */
//--------------------------------------------------------------
extern void Snd_CaptureStartOutputEffect( NNSSndCaptureOutputEffectType type );

//--------------------------------------------------------------
/**
 * @brief	o[u@Jn
 *
 * @param	vol		o[ũ{[(0-63)
 *
 * @retval	BOOL	TRUE=AFALSE=s
 *
 * ĐȂ炱̊֐ĂтƁAĐ鉹r؂܂B 
 *
 * `l1,3gp̂ŒӁI
 */
//--------------------------------------------------------------
extern BOOL Snd_CaptureStartReverb( int vol );

//--------------------------------------------------------------
/**
 * @brief	o[u@I
 *
 * @param	frame	t[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_CaptureStopReverb( int frame );

//--------------------------------------------------------------
/**
 * @brief	o[u@{[ύX
 *
 * @param	vol		o[ũ{[(0-63)
 * @param	frame	t[
 *
 * @retval	none
 *
 * frameŎw肵t[ŁAXɌ݂̃{[lA
 * volŎw肵{[l֕ω܂B  
 *
 * o[u삵ĂȂꍇ́A܂B 
 */
//--------------------------------------------------------------
extern void Snd_CaptureReverbVol( int vol, int frame );

//--------------------------------------------------------------
/**
 * @brief	GtFNgJn
 *
 * @param	none
 *
 * @retval	BOOL	TRUE=AFALSE=s
 *
 * `l1,3gp̂ŒӁI
 */
//--------------------------------------------------------------
extern BOOL Snd_CaptureStartEffect(void);

//--------------------------------------------------------------
/**
 * @brief	GtFNg~
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_CaptureStopEffect(void);

//--------------------------------------------------------------
/**
 * @brief	GtFNgx̑
 *
 * @param	level	x(0-8)
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_CaptureEffectLevel( int level );


//==============================================================================================
//
//	gbN
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	gbN~[g
 *
 * @param	handle_no	TEhnhio[
 * @param	bitmask		gbNrbg}XN
 * @param	flag		TRUE=~[gAFALSE=
 *
 * @retval	none
 *
 * trackBitMaskŁAݒ肷gbNw肵܂B
 * ʃrbg珇ɁAgbN0AgbN1AgbN2AAA\A
 * rbgĂgbNSĂɑ΂āA~[g̐ݒύX܂B
 * Ⴆ΁AgbN2ƃgbN5̃~[gݒύXꍇ́A 
 * (1 << 2) | (1 << 5) Ȃ킿A0x0024 Ƃ܂B 
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetTrackMute( int handle_no, u16 bitmask, BOOL flag );

//--------------------------------------------------------------
/**
 * @brief	gbN{[ύX
 *
 * @param	p			TEhnh̃AhX
 * @param	bitmask		gbNrbg}XN
 * @param	vol			{[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetTrackVolume( NNSSndHandle *p, u16 bitmask, int vol );

//--------------------------------------------------------------
/**
 * @brief	e|ύX
 *
 * @param	handle_no	TEhnhio[
 * @param	tempo		{(256=1{)
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetTempoRatio( int no, int tempo );


//==============================================================================================
//
//	̑֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	mtOύX
 *
 * @param	flag	TRUE=mAFALSE=XeI
 *
 * @retval	none
 *
 * ftHǵAFALSEłB 
 * mtOLɂƁAp̐ݒl𖳎āA
 * SĂ̔̒ʂōs܂B 
 */
//--------------------------------------------------------------
extern void Snd_SetMonoFlag( BOOL flag );

//--------------------------------------------------------------
/**
 * @brief	tF[hJE^[Zbg(fade_countɒlZbg)
 *
 * @param	frame		t[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_FadeCountSet( int frame );

//--------------------------------------------------------------
/**
 * @brief	BGM炷܂ł̃EFCgZbg
 *
 * @param	frame		t[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_NextWaitSet( int frame );

//--------------------------------------------------------------
/**
 * @brief	BGM炷܂ł̃EFCg`FbN(JE^[炵Ă܂)
 *
 * @param	none
 *
 * @retval	"0=IA0ȊO=JE^[l"
 */
//--------------------------------------------------------------
extern int Snd_NextWaitCheck();

//--------------------------------------------------------------
/**
 * @brief	}X^[{[ݒ(ftHg127)
 *
 * @param	vol		{[(0-127)
 *
 * @retval	none
 */
//--------------------------------------------------------------
//extern void Snd_SetMasterVolume( int vol );

//--------------------------------------------------------------
/**
 * @brief	g`i[obt@̃AhX擾
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void* Snd_GetWaveBufAdrs(void);

//--------------------------------------------------------------
/**
 * @brief	vC[q[v쐬(snd_test.cł̂ݎgp)
 *
 * @param	player_no	vC[io[
 * @param	size		vC[q[vTCY
 *
 * @retval	"TRUE=AFALSE=s"
 */
//--------------------------------------------------------------
extern BOOL Snd_PlayerHeapCreate( int player_no, u32 size );


//==============================================================================================
//
//	tB[h؂ւ鎞ɌĂԕKv폜֐
//
//	Pj퓬ɓ
//	Qjɓ
//	RjŃQ[I[o[
//	Sj]Ԃɏ
//	Tjg肵
//	ɂ͉邩HH
//
//==============================================================================================


//==============================================================================================
//
//	fld_bgmŎgp֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	oN؂ւ邩tOZbg
 *
 * @param	no		SND_BANK_CONTINUE,SND_BANK_CHANGE
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_BankFlagSet( int no );

//--------------------------------------------------------------
/**
 * @brief	oN؂ւ邩tO擾
 *
 * @param	none
 *
 * @retval	"SND_BANK_CONTINUE,SND_BANK_CHANGE"
 */
//--------------------------------------------------------------
extern u8 Snd_BankFlagGet();

//--------------------------------------------------------------
/**
 * @brief	tF[hAEg  BGMĐ
 *
 * @param	scene		V[()io[
 * @param	no			V[PXio[
 * @param	frame		t[
 * @param	next_wait	BGM炷܂ł̃EFCg
 * @param	flag		0=A1=
 * @param	adrs		tF[hf[^̃AhX
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tF[hJE^[ZbgĂ܂
 */
//--------------------------------------------------------------
extern BOOL Snd_FadeOutNextPlaySet(u8 scene, u16 no,int frame,int next_wait,u8 flag, void* adrs);

//--------------------------------------------------------------
/**
 * @brief	tF[hAEg  BGMtF[hC(V[`snd_tool.hQ)
 *
 * @param	scene		V[()io[
 * @param	no			V[PXio[
 * @param	frame		t[
 * @param	next_wait	BGM炷܂ł̃EFCg
 * @param	next_frame	BGM̃tF[hCt[
 * @param	flag		0=A1=A0xff=(Ȃ)
 * @param	adrs		tF[hf[^̃AhX
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tF[hJE^[ZbgĂ܂
 */
//--------------------------------------------------------------
extern BOOL Snd_FadeOutNextFadeInSet( u8 scene, u16 no, int frame, int next_wait, int next_frame, u8 flag, void* adrs );

//--------------------------------------------------------------
/**
 * @brief	gbNtF[hZbg
 *
 * @param	no		V[PXio[
 * @param	flag	0=A1=
 * @param	adrs	tF[hf[^̃AhX
 *
 * @retval	"0=ȂA1=Jn"
 */
//--------------------------------------------------------------
extern BOOL Snd_TrackFadeSet( u16 no, u8 flag, void* adrs );

//--------------------------------------------------------------
/**
 * @brief	gbNtF[h"f[^"Zbg
 *
 * @param	adrs	tF[hf[^̃AhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_TrackFadeDataSet( void* adrs );


//==============================================================================================
//
//	d_noharaŎgp֐(fobNp)
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	g`Đp̃`l(fobN)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_DebugNormalChannelFree();


//==============================================================================================
//
//	snd_testŎgp֐(fobNp)
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	oN[h
 *
 * @param	no		oNio[
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_DebugLoadBank( u16 no );


//==============================================================================================
//
//	}ӊ֘A
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	g`f[^̃AhXTvf[^̃AhX擾
 *
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"Tvf[^̃AhXANULL=s"
 */
//--------------------------------------------------------------
extern const u8* Snd_WaveDataSampleAdrsGet( const SNDWaveData* p_data );

//--------------------------------------------------------------
/**
 * @brief	g`f[^̃AhXTvf[^̔z̑傫擾
 *
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"Tvf[^̔z̑傫A0=s"
 */
//--------------------------------------------------------------
extern const u32 Snd_WaveDataSampleSizeGet( const SNDWaveData* p_data );

//--------------------------------------------------------------
/**
 * @brief	g`f[^̃AhX擾(}Ӑp)
 *
 * @param	wave_arc_no	g`A[JCuԍ(|Pio[)
 *
 * @retval	"g`f[^\̂̃AhXANULL=s"
 *
 * 1)BGM̌J
 * 2)g`A[JCu[h
 * ̏Ă̂ŒӁI
 */
//--------------------------------------------------------------
extern const SNDWaveData* Snd_ZukanWaveDataSet( int wave_arc_no );

//--------------------------------------------------------------
/**
 * @brief	g`f[^̍ĐĂTvf[^vfԂ
 *
 * @param	handle_no	nhio[
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"vf"
 */
//--------------------------------------------------------------
extern u32 Snd_PlayerGetSampleTick( int handle_no, const SNDWaveData* p_data );

//--------------------------------------------------------------
/**
 * @brief	g`f[^̍ĐĂTvf[^vfԂ(}ӗp)
 *
 * @param	handle_no	nhio[
 * @param	p_data		g`f[^̃AhX
 * @param	pitch		ݒ肵Ăsb`
 *
 * @retval	"vf"
 */
//--------------------------------------------------------------
extern u32 Snd_ZukanPlayerGetSampleTick( int handle_no, const SNDWaveData* p_data, int pitch );

//--------------------------------------------------------------
/**
 * @brief	eBbN擾
 *
 * @param	p_data		g`f[^̃AhX
 *
 * @retval	"eBbN"
 */
//--------------------------------------------------------------
extern u32 Snd_PlayerGetTick( int handle_no );

//--------------------------------------------------------------
/**
 * @brief	g`xZbg
 *
 * @param	p_data		g`f[^̃AhX
 * @param	buf			i[obt@̃|C^
 * @param	max			i[obt@̍ő吔
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_ZukanWaveLevelSet( const SNDWaveData* p_data, u8* buf, int max );

//--------------------------------------------------------------
/**
 * @brief	g`xZbg(}ӗp)
 *
 * @param	p_data		g`f[^̃AhX
 * @param	buf			i[obt@̃|C^
 * @param	max			i[obt@̍ő吔
 * @param	pitch		ݒ肵Ăsb`
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_ZukanWaveLevelSet_New( const SNDWaveData* p_data, u8* buf, int max, int pitch );











//--------------------------------------------------------------
/**
 * @brief	"fobN"@g`f[^\
 *
 * @param	start		\f[^̊Jnʒu
 * @param	end			\f[^̏Iʒu
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_DebugWaveDataPut( const SNDWaveData* p_data, u32 start, u32 end );

//--------------------------------------------------------------
/**
 * @brief	"fobN"@g`x\
 *
 * @param	tick		݂̃eBbN
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_DebugWaveLevelGet( u32 tick );

//--------------------------------------------------------------
/**
 * @brief	V[PX[J[NύX
 *
 * @param	num		V[PX[J[N"0"ɃZbgl
 *
 * @retval	"=TRUEAs=FALSE"
 *
 * FXoA͎gp肵ĂI
 */
//--------------------------------------------------------------
extern BOOL Snd_PlayerWriteVariable( s16 num );

//--------------------------------------------------------------
/**
 * @brief	gp\`lAo[uݒ
 *
 * @param	flag	1=ZbgA0=NA
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_BgmChannelSetAndReverbSet( int flag );

//--------------------------------------------------------------
/**
 * @brief	vC[̉ʑ(ftHg127ݒ肳Ă)
 *
 * @param	player_no	vC[io[
 * @param	volume		{[
 *
 * @retval	none
 *
 * gṕAK127ɖ߂ĂI
 */
//--------------------------------------------------------------
extern void Snd_PlayerSetPlayerVolume( int player_no, int volume );


#endif


