#ifndef __DWC_RAP_H__
#define  __DWC_RAP_H__

#include <dwc.h>

#include "savedata/savedata.h"
#include "savedata/wifilist.h"

// MR[obN^BWHReceiverFuncƓ`
typedef void (*MYDWCReceiverFunc) (u16 aid, u16 *data, u16 size);

#define ERRORCODE_0 (-1)
#define ERRORCODE_HEAP (-2)

//==============================================================================
/**
 * {CX`bg̃R[fbNw肵܂B
 * RlNVmOɃR[fbNw肵ĂƁA
 * RlNVmɎIɃ{CX`bgJn܂B
 * mydwc_startConnectĂяoɁAĂяoĂB
 * @param R[fbÑ^Cv
 * @retval none
 */
//==============================================================================
extern void mydwc_setVchat(int codec);
// {CX`bgȂ
#define VCHAT_NONE 0
#define VCHAT_8BIT_RAW 1
#define VCHAT_G711_ULAW 2
#define VCHAT_2BIT_ADPCM 3
#define VCHAT_3BIT_ADPCM 4
#define VCHAT_4BIT_ADPCM 5

//==============================================================================
/**
 * C^[lbg֐ڑJn   2006.04.07 k.ohno
 * @param   SAVEDATA* pSaveData ̃OCf[^ thXgZ[uf[^
 * @param   heapID q[vID
 * @retval  MYDWC_STARTCONNECT_OK c OK
 * @retval  MYDWC_STARTCONNECT_FIRST c ߂ĐڑꍇBibZ[W\̕KvL
 * @retval  MYDWC_STARTCONNECT_OK c قȂcrŐڑ悤ĂꍇBivxj
 */
//==============================================================================
extern int mydwc_startConnect(SAVEDATA* pSaveData, int heapid);
#define MYDWC_STARTCONNECT_OK 0
#define MYDWC_STARTCONNECT_FIRST 1
#define MYDWC_STARTCONNECT_DIFFERENTDS 2

//==============================================================================
/**
 * C^[lbgڑɖt[Ăяo֐
 * @param   userdata ̃OCf[^ւ̃|C^
 * @param   list thXg̐擪|C^
 * @retval  cڑBOcڑBcG[iG[R[hԂj
 */
//==============================================================================
extern int mydwc_connect();

//==============================================================================
/**
 * DWCG[ԍɑΉ郁bZ[WIDԂ܂B
 * @param code - G[R[hi̒lĂ
 * @retval bZ[W^Cv
 */
//==============================================================================
extern int mydwc_errorType(int code);

//==============================================================================
/**
 * G[NĂȂ`FbNAG[ɉĒʐM鏈B
 *  EAEog^[ŌĂяo߂ɑ k.ohno 06.06.08
 * @retval  OcG[ȂBcG[
 * iG[R[hԂBG[R[hȌꍇERRORCODE_0j
 */
//==============================================================================
extern int mydwc_HandleError(void);

//==============================================================================
/**
 * _}b`s֐BfobOp
 * @target   cŃQ[JÁBOȏcڑɍśAthXg̈ʒu
 * @retval  cBOcsB
 */
//==============================================================================
extern int mydwc_startmatch( );

//==============================================================================
/**
 * Q[WEQs֐B
 * @target   cŃQ[JÁBOȏcڑɍśAthXg̈ʒu
 * @retval  cBOcsB
 */
//==============================================================================
int mydwc_startgame( int target );

#define STEPMATCH_CONTINUE 0
#define STEPMATCH_SUCCESS 1
#define STEPMATCH_CANCEL 2
// 2006.7.4 yoshiharaǉ
#define STEPMATCH_FAIL 3
//==============================================================================
/**
 * ΐ}b`Oɖt[Ă΂֐B
 * @retval  
 	STEPMATCH_CONTINUEc}b`O
 	STEPMATCH_SUCCESSc
 	STEPMATCH_CANCELcLZ
 	STEPMATCH_FAIL  c肪e߂߁Aڑ𒆒f
 	cG[
 */
//==============================================================================
extern int mydwc_stepmatch( int isCancel );

//==============================================================================
/**
 * MƂ̃R[obNݒ肷֐
 * @param client c NCAgƂẴR[obN֐
 * @param server c T[oƂẴR[obN֐
 * @retval  none
 */
//==============================================================================
extern void mydwc_setReceiver( MYDWCReceiverFunc server, MYDWCReceiverFunc client );

//==============================================================================
/**
 * T[oɃf[^Ms֐
 * @param   data - Mf[^ւ̃|C^Bsize - Mf[^̃TCY
 * @retval  1 - @ 0 - siMobt@l܂Ă铙j
 */
//==============================================================================
extern int mydwc_sendToServer(void *data, int size);

//==============================================================================
/**
 * e@q@Ƀf[^Ms֐
 * @param   data - Mf[^ւ̃|C^Bsize - Mf[^̃TCY
 * @retval  1 - @ 0 - siMobt@l܂Ă铙j
 */
//==============================================================================
extern int mydwc_sendToClient(void *data, int size);

//==============================================================================
/**
 * DWCʐMXVs
 * @param none
 * @retval 0c, cG[ 1c^CAEg 2c肩ؒfꂽ
 */
//==============================================================================
extern int mydwc_step();

//==============================================================================
/**
 * DWCʐMXVs
 * @param none
 * @retval 0c, cG[
 */
//==============================================================================
extern void mydwc_startvchat();

//==============================================================================
/**
 * aidԂ܂Bڑ܂ł-1Ԃ܂B
 * @retval  aidBڑO-1
 */
//==============================================================================
extern int mydwc_getaid();

extern BOOL mydwc_canSendToServer();
extern BOOL mydwc_canSendToClient();

//==============================================================================
/**
 * dwc_rap.cmۂ̈JB
 * @param   none
 * @retval  none
 */
//==============================================================================
extern void mydwc_free();

//==============================================================================
/**
 * ʐMؒf܂B
 * @param sync c 0 = ؒfɂB1 = 肪ؒf̂҂B
 * @retval @@@ 1 = ڑB0 = ؒfB
 */
//==============================================================================
extern int mydwc_disconnect( int sync );

//==============================================================================
/**
 * ʐMؒfÅ֐ĂԂƂœԂOC̏Ԃɂ܂B
 * @param 	nonte
 * @retval  1 = B0 = sB
 */
//==============================================================================
extern int mydwc_returnLobby();

//==============================================================================
/**
 * tF[^G[ɌĂ΂֐ÃR[obN̒ŏƂ߂ĉB
 * @param 	nonte
 * @retval  1 = B0 = sB
 */
//==============================================================================
extern void mydwc_setFetalErrorCallback( void (*func)(int) );

//-----2006.04.11 k.ohno
//==============================================================================
/**
 * OAEg
 * @param 	none
 * @retval  none
 */
//==============================================================================
extern void mydwc_Logout(void);



//==============================================================================
/**
 * IC̗FBT[oɃAbvĂ߂zw肵܂B
 * ̔zmydwc_step, mydwc_stepmatchĂяoۂɍXV\܂B
 * @param 	array - f[^߂z̐擪
 * @param 	size  - l̃f[^TCY
 * @retval  none
 */
//==============================================================================
extern void mydwc_setFriendStateBuffer( void *array, int size );

//==============================================================================
/**
 * ̏T[oɃAbv܂B
 * @param 	data - f[^ւ̃|C^
 * @param 	size  - f[^TCY
 * @retval  ̉
 */
//==============================================================================
extern BOOL mydwc_setMyInfo( const void *data, int size );

//==============================================================================
/**
 * FBT[oɃAbvĂ擾܂i[JɃLbVĂ̂\܂jB
 * @param 	index thXg̔ԍ
 * @retval  f[^ւ̃|C^Bg͏ȂŉB
 */
//==============================================================================
extern void *mydwc_getFriendInfo( int index );

//==============================================================================
/**
 * FBT[oɃAbvĂ擾܂i[JɃLbVĂ̂\܂jB
 * @param 	index thXg̔ԍ
 * @retval  FB̏ԁBDWC_GetFriendStatusData̕ԂlƓ
 */
//==============================================================================
extern u8 mydwc_getFriendStatus( int index );

extern int mydwc_init(int heapID);
extern void mydwc_createUserData( WIFI_LIST *pWifiList );
extern void mydwc_callUtility( int heapID );

//==============================================================================
/**
 * ݂̃thXg\܂BifobOpj
 * @param 	none
 * @retval  none
 */
//==============================================================================
extern void mydwc_showFriendInfo();

//==============================================================================
/**
 * ̃mCYJbgx𒲐܂iOANZX̂ŁAɁj
 * @param   d c 臒l邩Aグ邩iقǏE₷Ȃj
 * @retval  none
 */
//==============================================================================
extern void mydwc_changeVADLevel(int d);

//==============================================================================
/**
 * ڑĂFB̃thXg̈ʒuԂ܂B
 * ܂AڑĂȂĂFBԍԂƂ܂̂ŁAڑ
 * ̔ɂ͎gȂłB
 * @retval  OȏcFBԍB|Pc܂ڑĂȂB
 */
//==============================================================================
extern int mydwc_getFriendIndex();

//==============================================================================
/**
 * GSID擾
 * @param   WIFI_LIST  
 * @retval  OƁ|P͎s   ̒l͐
 */
//==============================================================================

extern int mydwc_getMyGSID(WIFI_LIST *pWifiList);

//==============================================================================
/**
 * GSID̂
 * @param   SAVEDATA*  
 * @retval  TRUE
 */
//==============================================================================

extern BOOL mydwc_checkMyGSID(SAVEDATA *pSV);



extern BOOL mydwc_IsSendVoiceAndInc(void);

//==============================================================================
/**
 * {CX`bgԂǂԂ܂   k.ohno 06.05.23
 * @retval  TRUEc{CX`bg   FALSEc{CX`bgł͂Ȃ 
 */
//==============================================================================
extern BOOL mydwc_IsVChat(void);


//==============================================================================
/**
 * ڑĂǂԂ܂    k.ohno 06.05.24
 * @retval  thCfbNX  =-1
 */
//==============================================================================
extern int mydwc_IsNewPlayer(void);
extern void mydwc_ResetNewPlayer(void);

//==============================================================================
/**
 * {CX`bgONOFFݒ    k.ohno 06.05.24
 * @retval  ON = TRUE
 */
//==============================================================================
extern void mydwc_setVChat(BOOL bVChat);
//==============================================================================
/**
 * x@\̂ONOFFł    k.ohno 06.05.30
 * @retval  ON = TRUE
 */
//==============================================================================
extern BOOL mydwc_toggleDelay(void);

//==============================================================================
/**
 * {CX`bgʐMɃIIt֐    yoshihara 06.6.15
 * ́AʐMmɌĂяoĉB
 */
//==============================================================================
extern void mydwc_VChatPause();
extern void mydwc_VChatRestart();


#include "dwc_overlay.h"

#endif
