#ifndef __DWC_RAP_FRIEND_H__
#define  __DWC_RAP_FRIEND_H__

#include <dwc.h>

#include "savedata/savedata.h"
#include "savedata/wifilist.h"

// łɁAf[^XgɂB̏ꍇ͉KvȂB
#define DWCFRIEND_INLIST 0
// łɁAf[^Xgɂ邪A㏑邱Ƃ]܂ꍇB
#define DWCFRIEND_OVERWRITE 1
// f[^̓XgɂȂB
#define DWCFRIEND_NODATA 2
// f[^ȂB
#define DWCFRIEND_INVALID 3

//==============================================================================
/**
 * łɓlo^ĂȂB
 * @param   pSaveData th֌W͂ĂZ[uf[^
 * @param   index f[^Ƃ́ȀꏊB
 * @param         Ȃꍇ͋󂢂ĂƂԂ
 * @param         ǂ󂢂ĂȂꍇ́A-1 
 * @retval  DWCFRIEND_INLIST c łɁAf[^XgɂB̏ꍇ͉KvȂB
 * @retval  DWCFRIEND_OVERWRITE c łɁAf[^Xgɂ邪A㏑邱Ƃ]܂ꍇB
 * @retval  DWCFRIEND_NODATA c f[^̓XgɂȂB
 * @retval  DWCFRIEND_INVALID c 󂯎DWCFriendDataُB
 */
//==============================================================================
extern int dwc_checkfriendByToken(SAVEDATA* pSaveData, DWCFriendData *data, int *index);

//==============================================================================
/**
 * łɓlo^ĂȂB
 * @param   pSaveData th֌W͂ĂZ[uf[^
 * @param   index f[^Ƃ́ȀꏊB
 * @param         Ȃꍇ͋󂢂ĂƂԂ
 * @param         ǂ󂢂ĂȂꍇ́A-1 
 * @retval  DWCFRIEND_INLIST c łɁAf[^XgɂB
 * @retval  DWCFRIEND_NODATA c f[^̓XgɂȂB
 * @retval  DWCFRIEND_INVALID c 󂯎friend_keyaȂB
 */
//==============================================================================
extern int dwc_checkFriendCodeByToken(SAVEDATA* pSaveData, u64 friend_key, int *index);


extern BOOL dwc_friendAutoInputCheck( SAVEDATA* pSaveData, int* netIDList,
                                      int heapID);

extern void dwc_friendWrite(SAVEDATA* pSaveData, int netID, int addListIndex,
                            int heapID, int overWrite);


#endif
