//============================================================================================
/**
 * @file	bag.c
 * @brief	obOʏ OQƏ
 * @author	Hiroyuki Nakamura
 * @date	05.07.14
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/clact_tool.h"
#include "system/wordset.h"
#include "system/numfont.h"
#include "savedata/config.h"
#include "savedata/coin.h"
#include "savedata/custom_ball.h"
#include "savedata/b_tower.h"
#include "savedata/imageclip_data.h"
#include "itemtool/itemsym.h"
#include "field/itemuse.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_bag.h"
#include "msgdata/msg_common_scr.h"

#define	BAG_H_GLOBAL
#include "application/bag.h"
#include "bag_main.h"


//============================================================================================
//	萔`
//============================================================================================


//============================================================================================
//	vg^Cv錾
//============================================================================================
static u32 BAG_CoinValGet( SAVEDATA * sv );
static u32 BAG_SealValGet( SAVEDATA * sv );
static u32 BAG_AccessoryValGet( SAVEDATA * sv );
static u32 BAG_WallpaperValGet( SAVEDATA * sv );
static u32 BAG_BattlePointGet( SAVEDATA * sv );


//============================================================================================
//	O[oϐ
//============================================================================================


//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃f[^̈m
 *
 * @param	mode	擾[h
 *
 * @return	mۂ̈̃AhX
 */
//--------------------------------------------------------------------------------------------
BAG_DATA * BagSystemDataAlloc( u8 mode )
{
	BAG_DATA * wk = (BAG_DATA *)sys_AllocMemory( mode, sizeof(BAG_DATA) );
	memset( wk, 0, sizeof(BAG_DATA) );
	return wk;
}

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃f[^TCY擾
 *
 * @param	none
 *
 * @return	f[^TCY
 */
//--------------------------------------------------------------------------------------------
u32 BagSystemDataSizeGet(void)
{
	return sizeof(BAG_DATA);
}


//--------------------------------------------------------------------------------------------
/**
 * obOʂ̏y[Wݒ
 *
 * @param	dat		f[^ݒꏊ
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BAG_InitPageSet( BAG_DATA * dat, u8 page )
{
	dat->p_now = page;
}

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̃[hݒ
 *
 * @param	dat		f[^ݒꏊ
 * @param	mode	obOʂ̖
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BAG_ModeSet( BAG_DATA * dat, u8 mode )
{
	dat->mode  = mode;
}

//--------------------------------------------------------------------------------------------
/**
 * obOʂ̏f[^쐬
 *
 * @param	dat		f[^ݒꏊ
 * @param	sv		Z[uf[^
 * @param	mode	obOʂ̖
 * @param	cur		J[\Lꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BAG_SysDataSet( BAG_DATA * dat, SAVEDATA * sv, u8 mode, void * cur )
{
	BAG_ModeSet( dat, mode );
	dat->sv = sv;
	dat->bag_cursor = cur;
	dat->ret_item = 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pbgf[^쐬
 *
 * @param	dat		obOʂ̃f[^
 * @param	item	QƂACef[^
 * @param	type	|Pbg^Cv
 * @param	poke	|Pbgԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagPocketDataMake( BAG_DATA * dat, MINEITEM * item, u8 type, u8 poke )
{
	dat->p_data[poke].item = item;		// QƂACef[^
	dat->p_data[poke].type = type;		// |Pbg^Cv
}

//--------------------------------------------------------------------------------------------
/**
 * ]ԃtOZbg
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagCycleFlagSet( BAG_DATA * dat )
{
	dat->cycle_flg = 1;
}

//--------------------------------------------------------------------------------------------
/**
 * ACegp`FbN[NZbg
 *
 * @param	dat		obOʂ̃f[^
 * @param	icwk	ACegp`FbN[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Bag_ItemUseCheckSet( BAG_DATA * dat, void * icwk )
{
	dat->icwk = icwk;
}

//--------------------------------------------------------------------------------------------
/**
 * ACegp|Pʒuݒ
 *
 * @param	dat			obOʂ̃f[^
 * @param	use_poke	gp|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Bag_UsePokeSet( BAG_DATA * dat, u8 use_poke )
{
	dat->use_poke = use_poke;
}

//--------------------------------------------------------------------------------------------
/**
 * }bv[hݒ
 *
 * @param	dat			obOʂ̃f[^
 * @param	map_mode	}bv[h
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BAG_SysMapModeSet( BAG_DATA * dat, u16 map_mode )
{
	dat->map_mode = map_mode;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾F݂̃|Pbgԍ
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	݂̃|Pbgԍ
 */
//--------------------------------------------------------------------------------------------
u8 BagSysNowPocketNumGet( BAG_DATA * dat )
{
	return dat->p_now;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOʂ̖
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOʂ̖
 */
//--------------------------------------------------------------------------------------------
u8 BagSysModeGet( BAG_DATA * dat )
{
	return dat->mode;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobOŎ擾ACe
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obOŎ擾ACe
 */
//--------------------------------------------------------------------------------------------
u16 BagSysReturnItemGet( BAG_DATA * dat )
{
	return dat->ret_item;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FobO̖߂l
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	obO̖߂l
 */
//--------------------------------------------------------------------------------------------
u16 BagSysReturnModeGet( BAG_DATA * dat )
{
	return dat->ret_mode;
}

//--------------------------------------------------------------------------------------------
/**
 * OACegp|Pʒu擾
 *
 * @param	dat			obOʂ̃f[^
 *
 * @return	ACegp|Pʒu
 */
//--------------------------------------------------------------------------------------------
u8 Bag_UsePokeGet( BAG_DATA * dat )
{
	return dat->use_poke;
}


//--------------------------------------------------------------------------------------------
/**
 * f[^擾FJ[\ʒuAXN[JE^
 *
 * @param	dat		obOʂ̃f[^
 * @param	poke	|Pbgԍ
 * @param	cur		J[\ʒu
 * @param	scr		XN[JE^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BagCursorPosGet( BAG_DATA * dat, u8 poke, u16 * cur, u16 * scr )
{
	if( cur != NULL ){
		*cur = dat->p_data[poke].cur;
	}
	if( scr != NULL ){
		*scr = dat->p_data[poke].scr;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FJE^i`m[gpj
 *
 * @param	dat		obOʂ̃f[^
 *
 * @return	݂̃|Pbgԍ
 */
//--------------------------------------------------------------------------------------------
u8 BagSysSaleCntGet( BAG_DATA * dat )
{
	return dat->fnote_sale_cnt;
}



//--------------------------------------------------------------------------------------------
/**
 * Z[uf[^RC擾
 *
 * @param	sv		Z[uf[^
 *
 * @return	RC
 */
//--------------------------------------------------------------------------------------------
static u32 BAG_CoinValGet( SAVEDATA * sv )
{
	return COIN_GetValue( SaveData_GetMyCoin(sv) );
}

//--------------------------------------------------------------------------------------------
/**
 * Z[uf[^V[擾
 *
 * @param	sv		Z[uf[^
 *
 * @return	V[
 */
//--------------------------------------------------------------------------------------------
static u32 BAG_SealValGet( SAVEDATA * sv )
{
	CB_SAVE_DATA * csd;
	u32	i, max;

	csd = CB_SaveData_AllDataGet( sv );
	max = 0;

	for( i=1; i<=CB_DEF_ITEM_DATA_NUM_MAX; i++ ){
		max += CB_Tool_SealTotalNumGet( csd, i );
	}
	return max;
}

//--------------------------------------------------------------------------------------------
/**
 * Z[uf[^ANZT[擾
 *
 * @param	sv		Z[uf[^
 *
 * @return	ANZT[
 */
//--------------------------------------------------------------------------------------------
static u32 BAG_AccessoryValGet( SAVEDATA * sv )
{
	IMC_ITEM_SAVEDATA * imci = ImcSaveData_GetItemSaveData( SaveData_GetImcSaveData(sv) );

	return ImcSaveData_GetAcceAllNum( imci );
}

//--------------------------------------------------------------------------------------------
/**
 * Z[uf[^ǎ擾
 *
 * @param	sv		Z[uf[^
 *
 * @return	ǎ
 */
//--------------------------------------------------------------------------------------------
static u32 BAG_WallpaperValGet( SAVEDATA * sv )
{
	IMC_ITEM_SAVEDATA * imci = ImcSaveData_GetItemSaveData( SaveData_GetImcSaveData(sv) );

	return ImcSaveData_GetBGAllNum( imci );
}

//--------------------------------------------------------------------------------------------
/**
 * Z[uf[^og|Cg擾
 *
 * @param	sv		Z[uf[^
 *
 * @return	og|Cg
 */
//--------------------------------------------------------------------------------------------
static u32 BAG_BattlePointGet( SAVEDATA * sv )
{
	return (u32)BattlePoint_Get( sv );
}

//--------------------------------------------------------------------------------------------
/**
 * obOŎgpACẽbZ[WZbg
 *
 * @param	sv		Z[uf[^
 * @param	buf		bZ[WWJꏊ
 * @param	item	ACeԍ
 * @param	heap	q[vID
 *
 * @return	"TRUE = obOŎgpACe"
 * @return	"FALSE = ȊO"
 */
//--------------------------------------------------------------------------------------------
BOOL BAG_ItemUseMsgSet( SAVEDATA * sv, STRBUF * buf, u16 item, u32 heap )
{
	MSGDATA_MANAGER * mman;
	WORDSET * wset;
	STRBUF * str;

	mman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_bag_dat, heap );
	wset = WORDSET_Create( heap );

	if( item == ITEM_DUMMY_DATA ){
		str = MSGMAN_AllocString( mman, mes_bag_108 );
	}else if( item == ITEM_POINTOKAADO ){
		str = MSGMAN_AllocString( mman, mes_bag_106 );
		WORDSET_RegisterNumber(
			wset, 0, BAG_BattlePointGet(sv), 4, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	}else if( item == ITEM_SIIRUIRE ){
		str = MSGMAN_AllocString( mman, mes_bag_101 );
		WORDSET_RegisterNumber(
			wset, 0, BAG_SealValGet(sv), 4, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	}else if( item == ITEM_AKUSESARIIIRE ){
		str = MSGMAN_AllocString( mman, mes_bag_102 );
		WORDSET_RegisterNumber(
			wset, 0, BAG_AccessoryValGet(sv), 3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_RegisterNumber(
			wset, 1, BAG_WallpaperValGet(sv), 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	}else if( item == ITEM_KOINKEESU ){
		str = MSGMAN_AllocString( mman, msg_bag_062 );
		WORDSET_RegisterNumber(
			wset, 0, BAG_CoinValGet(sv), 5, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	}else{
		WORDSET_Delete( wset );
		MSGMAN_Delete( mman );
		return FALSE;
	}

	WORDSET_ExpandStr( wset, buf, str );
	STRBUF_Delete( str );
	WORDSET_Delete( wset );
	MSGMAN_Delete( mman );

	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * ACegpG[bZ[WZbg
 *
 * @param	myst	v[[f[^
 * @param	buf		bZ[WWJꏊ
 * @param	item	ACeԍ
 * @param	err		G[ID
 * @param	heap	q[vID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BAG_ItemUseErrorMsgSet( void * myst, STRBUF * buf, u16 item, u32 err, u32 heap )
{
	MSGDATA_MANAGER * mman;
	WORDSET * wset;
	STRBUF * str;

//	wset = WORDSET_Create( heap );

	switch( err ){
	case ITEMCHECK_ERR_CYCLE_OFF:		// ]Ԃ~Ȃ
		mman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_bag_dat, heap );
		MSGMAN_GetString( mman, msg_bag_058, buf );
		MSGMAN_Delete( mman );
		break;

	case ITEMCHECK_ERR_COMPANION:		// gpsEA
		mman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_bag_dat, heap );
		MSGMAN_GetString( mman, msg_bag_err_01, buf );
		MSGMAN_Delete( mman );
		break;

	default:							// gpsEm̌t
		mman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_common_scr_dat, heap );
		wset = WORDSET_Create( heap );
		str  = MSGMAN_AllocString( mman, msg_item_ng_01 );
		WORDSET_RegisterPlayerName( wset, 0, myst );
		WORDSET_ExpandStr( wset, buf, str );
		STRBUF_Delete( str );
		WORDSET_Delete( wset );
		MSGMAN_Delete( mman );
	}

/*
	WORDSET_ExpandStr( wset, buf, str );
	STRBUF_Delete( str );
	WORDSET_Delete( wset );
	MSGMAN_Delete( mman );
*/

}
