//============================================================================================
/**
 * @file	bag_bmp.h
 * @brief	obOBMP
 * @author	Hiroyuki Nakamura
 * @date	05.11.28
 */
//============================================================================================
#ifndef BAG_BMP_H
#define BAG_BMP_H
#undef GLOBAL
#ifdef BAG_BMP_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
// pbg`
#define	SYS_FONT_PAL	( 3 )		// VXetHg
#define	WINDOW_PAL		( 14 )		// EBhEg
#define	ICON_PAL		( 13 )		// ACRpbg
#define	TALKWIN_PAL		( 12 )		// bEBhEg
#define	TALK_FONT_PAL	( 11 )		// btHg

// ʂ̃{^f[^
#define	BUTTON_CGX_START	( 30 )		// JnLʒu
#define	BUTTON_CGX_WIDE		( 30 )		// OtBbNf[^̉iLPʁj
#define	BUTTON_CGX_XNEXT	( 15 )		// ̃{^̊JnXʒu
#define	BUTTON_CGX_YNEXT	( 30 * 5 )	// ̃{^̊JnYʒu
#define	BUTTON_CGX_SIZE		( 5 )		// {^̈ӂ̃TCY
#define	BUTTON_PAL_NUM		( 2 )		// pbg

// BMPf[^
// ACeXg
#define	BMP_LIST_PX		( 14 )
#define	BMP_LIST_PY		( 0 )
#define	BMP_LIST_SX		( 17 )
#define	BMP_LIST_SY		( 18 )
#define	BMP_LIST_PAL	( SYS_FONT_PAL )
#define	BMP_LIST_CGX	( 1 )
#define	BMP_LIST_FRM	( GF_BGL_FRAME2_M )
// 
//306
#define	BMP_INFO_PX		( 0 )
#define	BMP_INFO_PY		( 18 )
#define	BMP_INFO_SX		( 32 )
#define	BMP_INFO_SY		( 6 )
#define	BMP_INFO_PAL	( SYS_FONT_PAL )
#define	BMP_INFO_CGX	( BMP_LIST_CGX + BMP_LIST_SX * BMP_LIST_SY )
#define	BMP_INFO_FRM	( GF_BGL_FRAME0_M )
// |Pbg
//168
#define	BMP_POCKET_PX	( 0 )
#define	BMP_POCKET_PY	( 13 )
#define	BMP_POCKET_SX	( 12 * 3 )
#define	BMP_POCKET_SY	( 3 )
#define	BMP_POCKET_PAL	( SYS_FONT_PAL )
#define	BMP_POCKET_CGX	( BMP_INFO_CGX + BMP_INFO_SX * BMP_INFO_SY )
#define	BMP_POCKET_FRM	( GF_BGL_FRAME2_M )
// j[
#define	BMP_MENU_INFO_PX	( 6 )
#define	BMP_MENU_INFO_PY	( 19 )
#define	BMP_MENU_INFO_SX	( 14 )
#define	BMP_MENU_INFO_SY	( 4 )
#define	BMP_MENU_INFO_PAL	( TALK_FONT_PAL )
#define	BMP_MENU_INFO_CGX	( BMP_POCKET_CGX + BMP_POCKET_SX * BMP_POCKET_SY )
#define	BMP_MENU_INFO_FRM	( GF_BGL_FRAME0_M )
// j[Qi؂̎|Pbgpj
#define	BMP_MENU_INFO2_PX	( 6 )
#define	BMP_MENU_INFO2_PY	( 19 )
#define	BMP_MENU_INFO2_SX	( 13 )
#define	BMP_MENU_INFO2_SY	( 4 )
#define	BMP_MENU_INFO2_PAL	( TALK_FONT_PAL )
#define	BMP_MENU_INFO2_CGX	( BMP_MENU_INFO_CGX )
#define	BMP_MENU_INFO2_FRM	( GF_BGL_FRAME0_M )
// |PbgACR
//68
#define	BMP_P_ICON_PX	( 0 )
#define	BMP_P_ICON_PY	( 11 )
#define	BMP_P_ICON_SX	( 12 )
#define	BMP_P_ICON_SY	( 2 )
#define	BMP_P_ICON_PAL	( ICON_PAL )
#define	BMP_P_ICON_CGX	( BMP_MENU_INFO_CGX + BMP_MENU_INFO_SX * BMP_MENU_INFO_SY )
#define	BMP_P_ICON_FRM	( GF_BGL_FRAME0_M )
// bEBhE
#define	BMP_TALK_PX		( 2 )
#define	BMP_TALK_PY		( 19 )
#define	BMP_TALK_SX		( 27 )
#define	BMP_TALK_SY		( 4 )
#define	BMP_TALK_PAL	( TALK_FONT_PAL )
#define	BMP_TALK_CGX	( BMP_P_ICON_CGX + BMP_P_ICON_SX * BMP_P_ICON_SY )
#define	BMP_TALK_FRM	( GF_BGL_FRAME0_M )

// ǉBMP̃LJnʒu
#define	ADD_CGX_NUM		( BMP_TALK_CGX + BMP_TALK_SX * BMP_TALK_SY )

// ͂E
#define	BMP_YESNO_PX	( 23 )
#define	BMP_YESNO_PY	( 13 )
#define	BMP_YESNO_SX	( 7 )
#define	BMP_YESNO_SY	( 4 )
#define	BMP_YESNO_PAL	( SYS_FONT_PAL )
#define	BMP_YESNO_CGX	( ADD_CGX_NUM )
#define	BMP_YESNO_FRM	( GF_BGL_FRAME0_M )
// Tڃj[iőj
#define	BMP_MENU1_PX	( 23 )
#define	BMP_MENU1_PY	( 23 )
#define	BMP_MENU1_SX	( 8 )
#define	BMP_MENU1_SY	( 10 )
#define	BMP_MENU1_PAL	( SYS_FONT_PAL )
#define	BMP_MENU1_CGX	( BMP_YESNO_CGX + BMP_YESNO_SX * BMP_YESNO_SY )
#define	BMP_MENU1_FRM	( GF_BGL_FRAME0_M )
// ̂ĂI
#define	BMP_DEL_PX		( 24 )
#define	BMP_DEL_PY		( 19 )
#define	BMP_DEL_SX		( 7 )
#define	BMP_DEL_SY		( 4 )
#define	BMP_DEL_PAL		( SYS_FONT_PAL )
#define	BMP_DEL_CGX		( BMP_MENU1_CGX + BMP_MENU1_SX * BMP_MENU1_SY )
#define	BMP_DEL_FRM		( GF_BGL_FRAME0_M )
// Iij
#define	BMP_SALE_NUM_PX		( 19 )
#define	BMP_SALE_NUM_PY		( 13 )
#define	BMP_SALE_NUM_SX		( 12 )
#define	BMP_SALE_NUM_SY		( 4 )
#define	BMP_SALE_NUM_PAL	( SYS_FONT_PAL )
#define	BMP_SALE_NUM_CGX	( BMP_MENU1_CGX )
#define	BMP_SALE_NUM_FRM	( GF_BGL_FRAME0_M )
// 
#define	BMP_GOLD_PX		( 1 )
#define	BMP_GOLD_PY		( 1 )
#define	BMP_GOLD_SX		( 10 )
#define	BMP_GOLD_SY		( 4 )
#define	BMP_GOLD_PAL	( SYS_FONT_PAL )
#define	BMP_GOLD_CGX	( BMP_SALE_NUM_CGX + BMP_SALE_NUM_SX * BMP_SALE_NUM_SY )
#define	BMP_GOLD_FRM	( GF_BGL_FRAME0_M )
// |g̐
#define	BMP_PORUTO_PX	( 1 )
#define	BMP_PORUTO_PY	( 12 )
#define	BMP_PORUTO_SX	( 11 )
#define	BMP_PORUTO_SY	( 4 )
#define	BMP_PORUTO_PAL	( SYS_FONT_PAL )
#define	BMP_PORUTO_CGX	( BMP_MENU1_CGX + BMP_MENU1_SX * BMP_MENU1_SY )
#define	BMP_PORUTO_FRM	( GF_BGL_FRAME0_M )

#define	MENU_WIN_CGX_NUM	( 1024 - MENU_WIN_CGX_SIZ )		// j[EBhEgCGX
#define	MENU_WIN_PAL		( WINDOW_PAL )					// j[EBhẼpbg
#define	TALK_WIN_CGX_NUM	( MENU_WIN_CGX_NUM - TALK_WIN_CGX_SIZ )	// bEBhEgCGX

#define	BAGCOL_GREY_F	( 8 )	// ւ̃tHgJ[
#define	BAGCOL_GREY_S	( 9 )	// ւ̃tHgeJ[

#define	BAGCOL_N_BLACK	( GF_PRINTCOLOR_MAKE( 1, 2, 0 ) )		// tHgJ[F
#define	BAGCOL_N_WHITE	( GF_PRINTCOLOR_MAKE( 15, 14, 0 ) )		// tHgJ[F
#define	BAGCOL_N_GREY	( GF_PRINTCOLOR_MAKE( 8, 9, 0 ) )		// tHgJ[FD
//#define	BAGCOL_N_RED	( GF_PRINTCOLOR_MAKE( 5, 6, 0 ) )		// tHgJ[F




//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * BMPEBhEݒ
 *
 * @param	index	CfbNXi[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmpWinSet( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * BMPEBhEj
 *
 * @param	index	CfbNXi[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmpWinExit( GF_BGL_BMPWIN * win );

//--------------------------------------------------------------------------------------------
/**
 * |Pbg擾
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_PocketNameMake( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * |Pbg
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_PocketNameRelease( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * |PbgXN[ɔf
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 *
 *	ʏBMPł͂Ȃ߁AwGÂ݂XN[ɔf
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_PocketNameScreenPut( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * |Pbg\
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_PocketNamePut( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * |PbgACR\
 *
 * @param	wk		obOʂ̃[N
 * @param	pos		\ʒu
 * @param	flg		ItO	( 1 = IĂ )
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_PocketIconPut( BAG_WORK * wk, u8 pos, u8 flg );

//--------------------------------------------------------------------------------------------
/**
 * S|PbgACR\
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_PocketIconPutAll( BAG_WORK * wk );



//--------------------------------------------------------------------------------------------
/**
 * ACe\
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_ItemInfoPut( BAG_WORK * wk, u16 item );

//--------------------------------------------------------------------------------------------
/**
 * \擾
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_NumStrGet( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * \
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_NumStrRelease( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ACeXg\
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_ItemListNumPut( BAG_WORK * wk, u16 num, u16 y, u32 col );

//--------------------------------------------------------------------------------------------
/**
 * Z}VNo\
 *
 * @param	wk		obOʃ[N
 * @param	item	ACef[^
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmp_WazaMachineNoPut( BAG_WORK * wk, MINEITEM * item, u32 py );

//--------------------------------------------------------------------------------------------
/**
 * ؂̎No\
 *
 * @param	wk		obOʃ[N
 * @param	item	ACef[^
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmp_NutsNoPut( BAG_WORK * wk, MINEITEM * item, u32 py );

//--------------------------------------------------------------------------------------------
/**
 * Z}Vy[ẂuƂv\
 *
 * @param	wk		obOʃ[N
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmp_WazaPageToziruPut( BAG_WORK * wk, u32 py );

//--------------------------------------------------------------------------------------------
/**
 * Z}V̏\
 *
 * @param	wk		obOʃ[N
 * @param	item	ACeԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmp_WazaMashineInfoPut( BAG_WORK * wk, u16 item );

//--------------------------------------------------------------------------------------------
/**
 * ֗{^ACR\
 *
 * @param	wk		obOʃ[N
 * @param	py		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmp_CnvButtonIconPut( BAG_WORK * wk, u32 py );


//--------------------------------------------------------------------------------------------
/**
 * j[ڎ擾
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_MenuStrGet( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * j[ډ
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_MenuStrRelease( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * j[쐬
 *
 * @param	wk		obOʂ̃[N
 * @param	tbl		j[e[u
 * @param	max		j[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_ItemMenuSet( BAG_WORK * wk, u8 * tbl, u8 max );

//--------------------------------------------------------------------------------------------
/**
 * j[jiʏj
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_ItemMenuExit( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * j[jiuĂv̏ꍇj
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
//GLOBAL void Bag_ItemMenuExitSub( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ւbZ[W\iǂɂ܂Hj
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_ItemChgInfoMsgSet( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ̂ĂIEBhE쐬
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_DelNumSelWinSet( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ̂Ă֘AEBhEj
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_DelNumSelWinExit( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ̂Ă\
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_SubNumPut( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * uĂĂłHv\
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */	
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_SubTalkWinSet( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * bijbZ[W\
 *
 * @param	wk		obOʃ[N
 *
 * @return	bZ[WID
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 Bag_TalkMsgPrint( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ͂EZbg
 *
 * @param	wk		obOʃ[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_YesNoSelInit( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * pIEBhE\
 *
 * @param	wk		obOʃ[N
 * @param	flg		0 = EBhEgݕ\, 0 != BMP̂ݕ\
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_SaleNumWinPut( BAG_WORK * wk, u8 flg );

//--------------------------------------------------------------------------------------------
/**
 * EBhE\
 *
 * @param	wk		obOʃ[N
 * @param	flg		0 = EBhEgݕ\, 0 != BMP̂ݕ\
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_GoldWinPut( BAG_WORK * wk, u8 flg );


//--------------------------------------------------------------------------------------------
/**
 * u|tB̂v\
 *
 * @param	wk		obOʃ[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagBmp_PorutoWinPut( BAG_WORK * wk );


#undef GLOBAL
#endif	/* BAG_BMP_H */
