//============================================================================================
/**
 * @file	bag_obj.h
 * @brief	obOOBJ
 * @author	Hiroyuki Nakamura
 * @date	05.10.31
 */
//============================================================================================
#ifndef BAG_OBJ_H
#define BAG_OBJ_H
#undef GLOBAL
#ifdef BAG_OBJ_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
#define	CURSOR_ACT_PX	( 177 )		// ACeIJ[\\XW
#define	CURSOR_ACT_PY	( 24 )		// ACeIJ[\\YW

enum {
	ACT_OFF = 0,	// AN^[\
	ACT_ON			// AN^[\
};


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagCellActorInit( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAGOBJ_ClactFree( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ACeACRύX
 *
 * @param	wk		obOʂ̃[N
 * @param	item	ACeԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagItemIconChange( BAG_WORK * wk, u16 item );

//--------------------------------------------------------------------------------------------
/**
 * ACeIJ[\̃pbgύX
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagObj_CursorPalChg( BAG_WORK * wk, u8 num );

//--------------------------------------------------------------------------------------------
/**
 * Aj
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_ObjAnmMain( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * |PbgJ[\`FbN
 *
 * @param	wk		obOʂ̃[N
 *
 * @retval	"TRUE = ~"
 * @retval	"FALSE = 쒆"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BagPocketCursorMoveCheck( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * |PbgJ[\쏉
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagPocketCursorMoveInit( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * |PbgJ[\상C
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagPocketCursorMoveMain( BAG_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * IZbg
 *
 * @param	wk		obOʂ̃[N
 * @param	mode	gp[h
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_NumArrowSet( BAG_WORK * wk, u8 mode );

//--------------------------------------------------------------------------------------------
/**
 * I\ؑ
 *
 * @param	wk		obOʂ̃[N
 * @param	flg		\tO
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void Bag_NumArrowPut( BAG_WORK * wk, u8 flg );

//--------------------------------------------------------------------------------------------
/**
 * Z}ṼACRZbg
 *
 * @param	wk		obOʂ̃[N
 * @param	item	ACeԍ
 * @param	flg		\tO
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagObj_WazaIconPut( BAG_WORK * wk, u16 item, u8 flg );

//--------------------------------------------------------------------------------------------
/**
 * Tu{^GtFNg
 *
 * @param	wk		obOʂ̃[N
 * @param	x		\XW
 * @param	y		\YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagObj_SubButtonEffInit( BAG_WORK * wk, s16 x, s16 y );

//--------------------------------------------------------------------------------------------
/**
 * Tu{^GtFNgC
 *
 * @param	wk		obOʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BagObj_SubButtonEffMain( BAG_WORK * wk );



#undef GLOBAL
#endif	/* BAG_OBJ_H */
