//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_acce_hand.c
 *	@brief		C[WNbv ANZTnh VXe
 *				ANZT샂[h̃nhVXeł
 *	@author		tomoya takahashi
 *	@data		2005.09.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "calctool.h"
#include "tcb.h"
#include "include/system/lib_pack.h"
#include "include/system/heapdefine.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/application/imageClip/imc_obj_list_func.h"
#include "include/application/imageClip/imc_snd_def.h"
#include <string.h>

#define __IMC_ACCE_HAND_H_GLOBAL
#include "include/application/imageClip/imc_acce_hand.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define	IMC_ACCE_HAND_PRI		(0)	// 񂾃ANZT̗D揇


//-------------------------------------
//	
//	{bNXԋp^XNp
//	
//=====================================
#define IMC_ACCE_HAND_LBOX_RET_SYNC	(4)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	ANZTnh@\
//	
//=====================================
typedef struct {
	IMC_DRAW_DATA* drawData;	// `f[^\
	IMC_RIGHT_BOX*	rbox;		// E{bNX\
	IMC_LEFT_BOX*	lbox;		// {bNX\
	IMC_SUBWIN*		subwin;		// TuEBhE\

	IMC_OBJLIST* obj;			// ĂIuWFNgf[^
	int offset_x;				// ォ̃ItZbgW
	int offset_y;				// ォ̃ItZbgW
	s16 from_x;					// Ƃ̍W
	s16 from_y;
	u8	from;					// ꏊ	
	u8	from_list;				// ꏊ̃Xgio[

	// |Pg
	int last_x;
	int last_y;
	BOOL poketouch;		// |PɐU邱Ƃo邩ǂ

	u32 push_flg;

} IMC_ACCE_HAND;

//-------------------------------------
//	
//	{bNXԋpGtFNg^XN
//	
//=====================================
typedef struct {
	IMC_LEFT_BOX*	lbox;	// {bNX\
	IMC_OBJLIST* obj;		// ĂIuWFNgf[^
	int one_x;		// 1syncɓl
	int one_y;		// 1syncɓl
	int targ_x;		// ^[QbgW
	int targ_y;		// ^[QbgW
	int lbox_mode;	// o^捶{bNXANZT[h
	int list_no;	// o^捶{bNXANZTXgNo
	int count;		// ㉽񓮂
	int* p_left_state;	// {bNXXe[^X
	u32* p_new_push_flg;// ANZT߂蒆ɐVvbV
} IMC_ACCE_HAND_EFE_LBOX_RET;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void imcAcceHandPushFunc( IMC_HAND* hand );
static void imcAcceHandPopFunc( IMC_HAND* hand );
static void imcAcceHandPushIngFunc( IMC_HAND* hand );

static void setAcceHandAcce( IMC_ACCE_HAND* hand, IMC_OBJLIST* obj, int from, int offset_x, int offset_y, int pri );
static void cleanAcceHandAcce( IMC_ACCE_HAND* hand );

static void imcSubWinMsgPrint( IMC_ACCE_HAND* hand );


// |Pp
static void imcAcceHandPopForPokeFunc( IMC_HAND* hand );
static void imcAcceHandPushIngForPokeFunc( IMC_HAND* hand );

static void imcAcceHandGetObjRect( IMC_HAND* hand, int* top, int* bottom, int* left, int* right );
static void imcAcceHandGetObjRectSubInSize( IMC_HAND* hand, int* top, int* bottom, int* left, int* right );
static void imcAcceHandSetPokeMatrix( IMC_HAND* hand, int x, int y );


static void imcAcceHandBgDummyPop( IMC_HAND* hand );
static void imcAcceHandBgDummy( IMC_HAND* hand );
static void imcBGHandRefFunc( IMC_HAND* hand );


//-------------------------------------
//	
//	^XNn
//	
//=====================================
// {bNXɖ߂
static void imcAcceHandIconLboxRetStart( IMC_ACCE_HAND* acce_hand, int sync, int targ_x, int targ_y, int acce_mode, int list_no );
static void imcAcceHandIconLboxRetTsk( TCB_PTR tcb, void* work );


static void imcAcceHandSameThingHave( IMC_ACCE_HAND* acce_hand );
static void imcAcceHandTakaOff( IMC_ACCE_HAND* acce_hand );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTnh쐬
 *
 *	@param	hand		nh\
 *	@param	rbox		E{bNX\
 *	@param	lbox		{bNX\
 *	@param	drawData	`f[^\
 *	@param	subwin		TuEBhE\
 *	@param	poketouch	|Pɂӂ邩ǂ
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_HAND_Init( IMC_HAND* hand, IMC_RIGHT_BOX* rbox, IMC_LEFT_BOX* lbox, IMC_DRAW_DATA* drawData, IMC_SUBWIN* subwin, BOOL poketouch )
{
	IMC_ACCE_HAND* acce_hand;
	
	// nh\̏
	IMC_HAND_Init( hand );

	// [N쐬
	hand->hand_w = sys_AllocMemory( HEAPID_IMAGECLIP_DATA, sizeof( IMC_ACCE_HAND ) );
	memset( hand->hand_w, 0, sizeof( IMC_ACCE_HAND ) );
	acce_hand = hand->hand_w;

	acce_hand->rbox = rbox;
	acce_hand->lbox = lbox;
	acce_hand->drawData = drawData;
	acce_hand->subwin	= subwin;
	acce_hand->poketouch = poketouch;

	// ֐ݒ
	hand->push		= imcAcceHandPushFunc;
	hand->pop		= imcAcceHandPopFunc;
	hand->push_ing	= imcAcceHandPushIngFunc;
	hand->dest		= IMC_ACCE_HAND_Delete;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTnhj
 *
 *	@param	hand	nh\
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_HAND_Delete( IMC_HAND* hand )
{
	// [Nj
	sys_FreeMemoryEz( hand->hand_w );

	// 
	IMC_HAND_Init( hand );
}




//-----------------------------------------------------------------------------
/**
*		vCx[g֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	Ƃ̓
 *
 *	@param	hand	nh\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandPushFunc( IMC_HAND* hand )
{
	IMC_ACCE_HAND* acce_hand		= hand->hand_w;
	IMC_OBJLIST* obj;			// IuWFNgf[^
	BOOL ret;
	int offset_x, offset_y;		// ォ̃ItZbgl
	int set_list;				// ANZTݒ肷郊XgNo
	int draw_pri;
	
	// E{bNXɓĂ邩`FbN
	ret = IMC_RBOX_TPHit( acce_hand->rbox );
	if( ret ){

		// ANZTGĂ邩`FbN
		obj = IMC_RBOX_TPHitObjEx( acce_hand->rbox, &offset_x, &offset_y, acce_hand->drawData->SWSP_UPchar );

		if( obj ){
			// 擾̂|P̂Ƃ
			// poketoucho݂
			// ֎~ȂGȂƂɂ
			if( obj->flag == IMC_OBJLIST_POKE ){
				if( acce_hand->poketouch == FALSE ){
					obj = NULL;
				}
			}
		}

		if( (obj != NULL) ){
			
			if( obj->flag == IMC_OBJLIST_ACCE ){
				// ANZT؂藣
				IMC_RBOX_DeleteAccessorieMove( acce_hand->rbox, obj );
				draw_pri = IMC_ACCE_HAND_PRI;

			}else{

				// |POFFȂ|P𓮂Ƃ͂Ȃ
				// |P؂藣
				IMC_RBOX_MoveDeletePoke( obj );
				draw_pri = IMC_POKE_DrawPriorityGet( obj->obj_data );	// \D揇ʂ܂̒ʂ
				// W擾
				IMC_OBJLIST_ACCEPOKE_MatGet( obj, &acce_hand->last_x, &acce_hand->last_y );
			}
			
			// \D揇ʂ̍Đݒ
			IMC_RBOX_SetObjPriority( acce_hand->rbox );
			
			// o^
			setAcceHandAcce( acce_hand, obj, IMC_ACCE_HAND_FROM_RBOX,
					offset_x, offset_y,  draw_pri );

			// BGD揇ʂ̐ݒ
			IMC_DRAW_WndMaskObjMoveSet();
		}
	}else{

		// {bNXɓĂ邩`FbN
		ret = IMC_LBOX_TPHit( acce_hand->lbox );
		if( ret ){

			// ANZTGĂ邩`FbN
			obj = IMC_LBOX_TPHitAccessorieEx( acce_hand->lbox, &offset_x, &offset_y, acce_hand->drawData->SWSP_UPchar );
			if( obj != NULL ){
				
				// ANZT؂藣
				IMC_LBOX_DeleteAccessorieMove( obj );
				
				// \D揇ʂ̍Đݒ
				IMC_LBOX_SetAccessoriePriority( acce_hand->lbox );
			
				setAcceHandAcce( acce_hand, obj, IMC_ACCE_HAND_FROM_LBOX, 
						offset_x, offset_y, IMC_ACCE_HAND_PRI );	

				// BGD揇ʂ̐ݒ
				IMC_DRAW_WndMaskObjMoveSet();
			}
		}
	}

	if( acce_hand->obj ){
		int se = IMC_SE_HAVE_SAMETHING;
		// Ƃ̓֐ݒ
		// ςȂ֐ݒ
		switch( acce_hand->obj->flag ){
		case IMC_OBJLIST_ACCE:
			hand->pop		= imcAcceHandPopFunc; 
			hand->push_ing	= imcAcceHandPushIngFunc; 
			break;
		case IMC_OBJLIST_BG:
			hand->pop		= imcAcceHandBgDummyPop; 
			hand->push_ing	= imcAcceHandBgDummy;
			imcBGHandRefFunc( hand );	// BGf
			se = IMC_SE_BG_CHANGE;
			break;
		case IMC_OBJLIST_POKE:
			hand->pop		= imcAcceHandPopForPokeFunc; 
			hand->push_ing	= imcAcceHandPushIngForPokeFunc; 
			break;
		default:
			break;
		}
	
		// 񂾉
		Snd_SePlay( se );
		
		// Ƃ̃GtFNg
//		imcAcceHandSameThingHave( acce_hand );
		
		imcSubWinMsgPrint( acce_hand );
	}
}

// wip_~[
static void imcAcceHandBgDummy( IMC_HAND* hand )
{
}

//----------------------------------------------------------------------------
/**
 *	@brief	wipPOP֐
 */
//-----------------------------------------------------------------------------
static void imcAcceHandBgDummyPop( IMC_HAND* hand )
{
	IMC_ACCE_HAND* bg_hand = hand->hand_w;
	

	// ^b`IuWFȂ
	// ̃io[BGEpbgɔf
	if( bg_hand->obj ){

		// IuWF̃^CvBGł邱Ƃ`FbN
		GF_ASSERT( bg_hand->obj->flag == IMC_OBJLIST_BG );
	
		// {bNXԋp^XN
		imcAcceHandIconLboxRetStart( bg_hand, IMC_ACCE_HAND_LBOX_RET_SYNC, bg_hand->from_x, bg_hand->from_y, bg_hand->obj->flag, bg_hand->from_list );

		// 󂯌p
		cleanAcceHandAcce( bg_hand );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	̓
 *
 *	@param	hand	nh\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandPopFunc( IMC_HAND* hand )
{
	IMC_ACCE_HAND* acce_hand		= hand->hand_w;
	int	acce_list_no;				// ANZTXgio[
	int ret;
	int top, bottom, left, right;	// eW
	int size_x, size_y;				// TCY
	int x,y;						// W
	BOOL check;						// ǉ`FbN

	// IuWFNgƂ
	if( acce_hand->obj ){
		// `f[^擾
		imcAcceHandGetObjRectSubInSize( hand, &top, &bottom, &left, &right );
		
		// E{bNXɓĂ邩`FbN
		// ǂoĂ炾
		ret = IMC_RBOX_TPHitSelf( acce_hand->rbox, left, top );
		ret += IMC_RBOX_TPHitSelf( acce_hand->rbox, right, top );
		ret += IMC_RBOX_TPHitSelf( acce_hand->rbox, left, bottom );
		ret += IMC_RBOX_TPHitSelf( acce_hand->rbox, right, bottom );

		if( ret >= 4 ){

			// ̍WŉE{bNXɂ
			check = IMC_RBOX_AddAccessorieMove( acce_hand->rbox, acce_hand->obj, acce_hand->drawData->SWSP_UPchar );
			if( check == FALSE ){		// o^sȂ獶ɖ߂
				x = acce_hand->from_x;
				y = acce_hand->from_y;
				
				// {bNXɕԋpGtFNg̉
				Snd_SePlay( IMC_SE_RET_LBOX );

				// Rg\
				IMC_SUBWIN_SetBmpWin( acce_hand->subwin, ARC_MSG, NARC_msg_imageclip_dat, imgclip_ng0002 );
			
				// {bNXԋp^XN
				imcAcceHandIconLboxRetStart( acce_hand, IMC_ACCE_HAND_LBOX_RET_SYNC, x, y, acce_hand->obj->flag, acce_hand->from_list );

			}else{
				
				// \D揇ʂ̍Đݒ
				IMC_RBOX_SetObjPriority( acce_hand->rbox );
				// BGD揇ʂ̐ݒ
				IMC_DRAW_WndMaskNormalSet();
				acce_hand->push_flg = FALSE;

				// E{bNXɂ
				Snd_SePlay( IMC_SE_ON_RBOX );
			}

		}else{
			// pbg
			IMC_ACCESSORIE_OBJ* acce_obj = acce_hand->obj->obj_data;	// ɂ̓ANZTuȂ

			// Hł悢TCYlȂ
			imcAcceHandGetObjRect( hand, &top, &bottom, &left, &right );

			// {bNXɓĂ邩`FbN
			ret = IMC_LBOX_TPHitSelf( acce_hand->lbox, left, top );
			ret += IMC_LBOX_TPHitSelf( acce_hand->lbox, right, bottom );
			if( ret < 2 ){
				
				// frompbgȂ
				// pbgɂƂ̍W
				if( acce_hand->from == IMC_ACCE_HAND_FROM_RBOX ){
					IMC_OBJLIST_ACCEPOKE_SizeGet( acce_hand->obj, &size_x, &size_y );

					// {bNXKȈʒuɖ߂
					x = (IMC_LBOX_AREA_X_MOVEOK) + (gf_mtRand() % (IMC_LBOX_AREA_WIDTH_MOVEOK - size_x) );
					y = (IMC_LBOX_AREA_Y_MOVEOK) + (gf_mtRand() % (IMC_LBOX_AREA_HEIGHT_MOVEOK - size_y) );
				}else{

					x = acce_hand->from_x;
					y = acce_hand->from_y;
				}

				// {bNXɕԋpGtFNg̉
				Snd_SePlay( IMC_SE_RET_LBOX );
			}else{
				
				// ̍W擾
				IMC_OBJLIST_ACCEPOKE_MatGet( acce_hand->obj, &x, &y );

				// 
				Snd_SePlay( IMC_SE_TAKE_OFF );
			}

			// E痈ANZT̎̓Xgio[擾
			if( acce_hand->from == IMC_ACCE_HAND_FROM_RBOX){
				acce_hand->from_list = IMC_LBOX_GetListNo( acce_hand->obj->flag, acce_obj->accessorie_no, acce_hand->lbox->boxData.p_item_buff );
			}

			// {bNXԋp^XN
			imcAcceHandIconLboxRetStart( acce_hand, IMC_ACCE_HAND_LBOX_RET_SYNC, x, y, acce_hand->obj->flag, acce_hand->from_list );

		}

		// Ƃ̃GtFNg
//		imcAcceHandTakaOff( acce_hand );

		// 󂯌p
		cleanAcceHandAcce( acce_hand );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brieof	ςȂ̓
 *
 *	@param	hand		nh\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandPushIngFunc( IMC_HAND* hand )
{
	IMC_ACCE_HAND* acce_hand		= hand->hand_w;
	int x, y;

	// ANZTĂƂ́A^b`pl̈ʒu
	// ANZT𓮂
	if( acce_hand->obj != NULL ){

		// W̐`FbN
		if( (sys.tp_x != 0xffff) &&
			(sys.tp_x != 0xffff) ){
		
			x = sys.tp_x - acce_hand->offset_x;
			y = sys.tp_y - acce_hand->offset_y;

			IMC_OBJLIST_ACCEPOKE_Mat( acce_hand->obj, x, y );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Ƃ̓	|PĂƂ悤
 *
 *	@param	hand		nh\ 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandPopForPokeFunc( IMC_HAND* hand )
{
	IMC_ACCE_HAND* acce_hand		= hand->hand_w;
	BOOL ret1, ret2;
	int size_x,size_y;			// IuWFNgTCYXY

	// IuWFNgƂ
	if( acce_hand->obj ){

		// ̍WŉE{bNXɂ
		IMC_RBOX_MoveAddPoke( acce_hand->rbox, acce_hand->obj );

		// \D揇ʂ̍Đݒ
		IMC_RBOX_SetObjPriority( acce_hand->rbox );


		// BGD揇ʂ̐ݒ
		IMC_DRAW_WndMaskNormalSet();
		acce_hand->push_flg = FALSE;

		// Ƃ̃GtFNg
//		imcAcceHandTakaOff( acce_hand );

		// 
		Snd_SePlay( IMC_SE_TAKE_OFF );

		cleanAcceHandAcce( acce_hand );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brieof	ςȂ̓	|PĂƂ悤
 *
 *	@param	hand	nhf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandPushIngForPokeFunc( IMC_HAND* hand )
{
	IMC_ACCE_HAND* acce_hand		= hand->hand_w;
	int size_x, size_y;
	int x,y;
	int area_x, area_y;
	int in_s_x, in_s_y;	// HłĂ悢TCY

	// ANZTĂƂ́A^b`pl̈ʒu
	// ANZT𓮂
	if( acce_hand->obj != NULL ){

		// W̐`FbN
		if( (sys.tp_x != 0xffff) &&
			(sys.tp_x != 0xffff) ){
			
			// Hł悢TCY擾
			IMC_OBJLIST_ACCEPOKE_InSizeGet( acce_hand->obj, &in_s_x, &in_s_y );

			// TCY擾
			IMC_OBJLIST_ACCEPOKE_SizeGet( acce_hand->obj, &size_x, &size_y );
			// VWvZ
			x = sys.tp_x - acce_hand->offset_x;
			y = sys.tp_y - acce_hand->offset_y;

			// 蔻GA쐬
			area_x = x + in_s_x;
			area_y = y + in_s_y;
			size_x -= in_s_x;
			size_y -= in_s_y;

			// WE{bNXɂȂ悤ɂ
			if( area_x <= IMC_RBOX_AREA_X_MOVEOK){
				x = IMC_RBOX_AREA_X_MOVEOK - in_s_x;
			}else{
				if( x + size_x >= (IMC_RBOX_AREA_X_MOVEOK + IMC_RBOX_AREA_WIDTH_MOVEOK) ){
					x = (IMC_RBOX_AREA_X_MOVEOK + IMC_RBOX_AREA_WIDTH_MOVEOK) - size_x;
				}
			}
			if( area_y <= IMC_RBOX_AREA_Y_MOVEOK){
				y = IMC_RBOX_AREA_Y_MOVEOK - in_s_y;
			}else{
				if( y + size_y >= (IMC_RBOX_AREA_Y_MOVEOK + IMC_RBOX_AREA_HEIGHT_MOVEOK) ){
					y = (IMC_RBOX_AREA_Y_MOVEOK + IMC_RBOX_AREA_HEIGHT_MOVEOK) - size_y;
				}
			}
			
			// Wݒ
			imcAcceHandSetPokeMatrix( hand, x, y );

			// ̈ʒuŃANZTH܂Ȃ`FbN
			IMC_RBOX_GetPokeUpListEncSize( acce_hand->rbox,
					&in_s_x, &in_s_y );

			// ̐HłTCYčĐݒ
			x += in_s_x;
			y += in_s_y;
			imcAcceHandSetPokeMatrix( hand, x, y );
		}
	}
}

#if 0
//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGύXnh֐	Ƃ
 *
 *	@param	hand	nh\
 *
 *	@return	none
 *
 * 
 *
 */
//-----------------------------------------------------------------------------
static void imcBGHandPopFunc( IMC_HAND* hand )
{
	IMC_ACCE_HAND* bg_hand = hand->hand_w;
	IMC_ACCESSORIE_OBJ* acce;	// ANZT[IuWF
	int acce_list_no;
	
	// ^b`IuWFȂ
	// ̃io[BGEpbgɔf
	if( bg_hand->obj ){
		
		// IuWF̃^CvBGł邱Ƃ`FbN
		GF_ASSERT( bg_hand->obj->flag == IMC_OBJLIST_BG );
		
		// ANZTf[^
		acce = bg_hand->obj->obj_data;

		// EpbgɂBG𔽉f
		if( IMC_RBOX_TPHitSelf( bg_hand->rbox, hand->old_x, hand->old_y ) ){

			// ANZTio[BGEpbgɐݒ
			IMC_RBOX_BGClean( bg_hand->rbox );
			IMC_RBOX_BGSet( bg_hand->rbox, acce->accessorie_no, HEAPID_IMAGECLIP_DRAW );

			// BGύX
			Snd_SePlay( IMC_SE_BG_CHANGE );
		}else{

			// {bNXɖ߂
			Snd_SePlay( IMC_SE_RET_LBOX );
		}
		
		// {bNXԋp^XN
		imcAcceHandIconLboxRetStart( bg_hand, IMC_ACCE_HAND_LBOX_RET_SYNC, bg_hand->from_x, bg_hand->from_y, bg_hand->obj->flag, bg_hand->from_list );
		
		// Ƃ̃GtFNg
//		imcAcceHandTakaOff( bg_hand );
		
		// 󂯌p
		cleanAcceHandAcce( bg_hand );
	}
}
#endif

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGύXnh֐	Ƃ
 *
 *	@param	hand	nh\
 *
 *	@return	none
 *
 * 
 *
 */
//-----------------------------------------------------------------------------
static void imcBGHandRefFunc( IMC_HAND* hand )
{
	IMC_ACCE_HAND* bg_hand = hand->hand_w;
	IMC_ACCESSORIE_OBJ* acce;	// ANZT[IuWF
	int acce_list_no;
	
	// ^b`IuWFȂ
	// ̃io[BGEpbgɔf
	if( bg_hand->obj ){
		
		// IuWF̃^CvBGł邱Ƃ`FbN
		GF_ASSERT( bg_hand->obj->flag == IMC_OBJLIST_BG );
		
		// ANZTf[^
		acce = bg_hand->obj->obj_data;


		// ANZTio[BGEpbgɐݒ
		IMC_RBOX_BGClean( bg_hand->rbox );
		IMC_RBOX_BGSet( bg_hand->rbox, acce->accessorie_no, HEAPID_IMAGECLIP_DRAW );

		// Ƃ̃GtFNg
//		imcAcceHandTakaOff( bg_hand );
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNg̓o^
 *
 *	@param	hand		nhf[^
 *	@param	obj			o^IuWFNg
 *	@param	from		ꏊ
 *	@param	offset_x	ォ̃ItZbgW
 *	@param	offset_y	ォ̃ItZbgW
 *	@param	pri			\D揇
 *
 *	@return	none
 *
 *	form
 *		enum{
 *			IMC_ACCE_HAND_FROM_LBOX,		// {bNX
 * 			IMC_ACCE_HAND_FROM_RBOX,		// E{bNX
 *		};
 *
 */
//-----------------------------------------------------------------------------
static void setAcceHandAcce( IMC_ACCE_HAND* hand, IMC_OBJLIST* obj, int from, int offset_x, int offset_y, int pri )
{
	int pos_x, pos_y;
	IMC_OBJLIST_ACCEPOKE_MatGet( obj, &pos_x, &pos_y );
	
	hand->obj		= obj;
	hand->from_x	= pos_x;
	hand->from_y	= pos_y;
	hand->from		= from;
	hand->offset_x	= offset_x;
	hand->offset_y	= offset_y;

	if( from == IMC_ACCE_HAND_FROM_LBOX ){
		// {bNX炫̂Ȃ
		// ̃[hݒ
		hand->from_list	= IMC_LBOX_GetCurrentNo( hand->lbox, hand->obj->flag );	// JgXgNo
	}else{
		// E痈̂̓ftHgł
		hand->from_list	= 0;
	}

	// nhvbVnm
	hand->push_flg = TRUE;

	// D揇ʂŏɂ
	IMC_OBJLIST_ACCEPOKE_Pri( obj, pri );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTnh̃ANZTf[^̂ݏ
 *
 *	@param	hand	ANZTnh\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanAcceHandAcce( IMC_ACCE_HAND* hand )
{
	hand->obj		= NULL;
	hand->from_x	= 0;
	hand->from_y	= 0;
	hand->from		= 0;
	hand->from_list	= 0;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	nh\^Cɓo^ĂIuWFNg̋`TCY擾
 *	
 *	@param	hand		nh\
 *	@param	top			W
 *	@param	bottom		W
 *	@param	left		W
 *	@param	right		EW	
 *
 *	@return	none
 *	
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandGetObjRect( IMC_HAND* hand, int* top, int* bottom, int* left, int* right )
{
	IMC_ACCE_HAND* acce_hand		= hand->hand_w;
	int size_x,size_y;			// IuWFNgTCYXY
	int mat_x, mat_y;			// IuWFNgW

	IMC_OBJLIST_ACCEPOKE_SizeGet( acce_hand->obj, &size_x, &size_y );
	IMC_OBJLIST_ACCEPOKE_MatGet( acce_hand->obj, &mat_x, &mat_y );
	
	*top	= mat_y;
	*bottom	= mat_y + size_y;
	*left	= mat_x;
	*right	= mat_x + size_x;
}


//----------------------------------------------------------------------------
/**
 * Hł悢TCY炷		Epbgp
 *
 *	@brief	nh\^Cɓo^ĂIuWFNg̋`TCY擾
 *	
 *	@param	hand		nh\
 *	@param	top			W
 *	@param	bottom		W
 *	@param	left		W
 *	@param	right		EW	
 *
 *	@return	none
 *	
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandGetObjRectSubInSize( IMC_HAND* hand, int* top, int* bottom, int* left, int* right )
{
	IMC_ACCE_HAND* acce_hand		= hand->hand_w;
	IMC_OBJLIST_GetObjRectSubInSize( acce_hand->obj, top, bottom, left, right );
}


//-------------------------------------
//	
//	^XNn
//	
//=====================================
//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXւ̃ANZTԋpGtFNg^XNJn֐
 *	
 *	@param	acce_hand		ANZTnh\
 *	@param	sync			VNœ
 *	@param	targ_x			ԋpW
 *	@param	targ_y			ԋpW
 *	@param	acce_mode		ANZT[h
 *	@param	list_no			ANZTXgԍ
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandIconLboxRetStart( IMC_ACCE_HAND* acce_hand, int sync, int targ_x, int targ_y, int acce_mode, int list_no )
{
	TCB_PTR tcb;
	IMC_ACCE_HAND_EFE_LBOX_RET* work;
	int x, y;

	tcb = PMDS_taskAdd( imcAcceHandIconLboxRetTsk, sizeof(IMC_ACCE_HAND_EFE_LBOX_RET), 0, HEAPID_IMAGECLIP_DATA );

	work = TCB_GetWork( tcb );

	work->lbox		= acce_hand->lbox;
	work->obj		= acce_hand->obj;
	work->count		= sync;
	work->targ_x	= targ_x;
	work->targ_y	= targ_y;
	work->lbox_mode	= acce_mode;
	work->list_no	= list_no;
	work->p_left_state = &acce_hand->lbox->boxData.state;
	work->p_new_push_flg = &acce_hand->push_flg;
	
	// PVNɓl擾
	IMC_OBJLIST_ACCEPOKE_MatGet( acce_hand->obj, &x, &y );
	
	work->one_x		= (work->targ_x - x) / sync;
	work->one_y		= (work->targ_y - y) / sync;

	// ANZT͂Ȃ
	acce_hand->push_flg = FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXւ̃ANZTԋpGtFNg^XN
 *
 *	@param	tcb		tcb|C^
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandIconLboxRetTsk( TCB_PTR tcb, void* work )
{
	IMC_ACCE_HAND_EFE_LBOX_RET* tsk_w = work;
	int x, y;			// W

	// {bNXtF[h͂Ƃ߂
	if( *tsk_w->p_left_state == IMC_LBOX_STATE_FADE ){
		return ;
	}
	
	IMC_OBJLIST_ACCEPOKE_MatGet( tsk_w->obj, &x, &y );

	x += tsk_w->one_x;
	y += tsk_w->one_y;

	tsk_w->count--;

	// I`FbN
	if(tsk_w->count < 0){
		IMC_OBJLIST_ACCEPOKE_Mat( tsk_w->obj, tsk_w->targ_x, tsk_w->targ_y );

		// ̍Wō{bNXɂ
		IMC_LBOX_AddAccessorieMove(
				tsk_w->lbox,
				tsk_w->lbox_mode,
				tsk_w->list_no,
				tsk_w->obj	);
		
		
		// \D揇ʂ̍Đݒ
		IMC_LBOX_SetAccessoriePriority( tsk_w->lbox );

		// BGD揇ʂ̐ݒ
		// pbgɖ߂ĂԂ
		// V̂肪ł
		// }XN`FWsȂ
		if( *(tsk_w->p_new_push_flg) == FALSE ){
			IMC_DRAW_WndMaskNormalSet();
		}
		
		// I
		PMDS_taskDel( tcb );
	}else{

		// Wݒ
		IMC_OBJLIST_ACCEPOKE_Mat( tsk_w->obj, x, y );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Ƃ̊֐
 *
 *	@param	acce_hand	nh\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandSameThingHave( IMC_ACCE_HAND* acce_hand )
{
	if( acce_hand->obj->flag < IMC_OBJLIST_POKE ){
		
		IMC_ACCE_ObjScaleSet( acce_hand->obj->obj_data, 
				FX32_ONE + 0x200,
				FX32_ONE + 0x200);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	GtFNg̊֐
 *
 *	@param	acce_hand	ꂩnh\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcAcceHandTakaOff( IMC_ACCE_HAND* acce_hand )
{
	if( acce_hand->obj->flag < IMC_OBJLIST_POKE ){
		
		IMC_ACCE_ObjScaleSet( acce_hand->obj->obj_data, 
				FX32_ONE,
				FX32_ONE);
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief		TuEBhEɍێĂ镨̃bZ[Wo
 *
 *	@param	hand ANZTnh\
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imcSubWinMsgPrint( IMC_ACCE_HAND* hand )
{
	// ANZT
	if( hand->obj->flag == IMC_OBJLIST_ACCE ){
		IMC_ACCESSORIE_OBJ* acce = hand->obj->obj_data;
		
		IMC_SUBWIN_SetBmpWin( hand->subwin, ARC_MSG, NARC_msg_imageclip_acce_dat, acce->accessorie_no );
		
	// BG
	}else if( hand->obj->flag == IMC_OBJLIST_BG ){
		IMC_ACCESSORIE_OBJ* acce = hand->obj->obj_data;
		
		IMC_SUBWIN_SetBmpWin( hand->subwin, ARC_MSG, NARC_msg_imageclip_bg_dat, acce->accessorie_no );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PWݒ肷
 *
 *	@param	hand	ANZTnh
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void imcAcceHandSetPokeMatrix( IMC_HAND* hand, int x, int y )
{
	IMC_ACCE_HAND* acce_hand = hand->hand_w;
	IMC_OBJLIST_ACCEPOKE_Mat( acce_hand->obj, x, y );

	// ړ
	// E{bNX̃|P̏̃ANZT
	IMC_RBOX_PokeUpListMove( acce_hand->rbox, 
			x - acce_hand->last_x, y - acce_hand->last_y );

	acce_hand->last_x = x;
	acce_hand->last_y = y;
}
