//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_accessorie.c
 *	@brief		ANZTǗVXe
 *	@author		tomoya takahashi
 *	@data		2005.09.20
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <string.h>
#include "system.h"
#include "assert.h"
#include "include/application/imageClip/imc_drawsys.h"

#include "include/application/imageClip/imc_drawdata_define.h"
#define	__IMC_ACCESSORIE_H_GLOBAL
#include "include/application/imageClip/imc_accessorie.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
// eOtBbNTCỶʊOɂ߂荞ł悢TCY
#define IMC_ACCE_HIT_16_SIZE_X	(0)
#define IMC_ACCE_HIT_16_SIZE_Y	(0)
#define IMC_ACCE_HIT_32_SIZE_X	(10)
#define IMC_ACCE_HIT_32_SIZE_Y	(10)
#define IMC_ACCE_HIT_64_SIZE_X	(20)
#define IMC_ACCE_HIT_64_SIZE_Y	(20)

#define IMC_ACCE_SIZE_16	(16)
#define IMC_ACCE_SIZE_32	(32)
#define IMC_ACCE_SIZE_64	(64)


// 蔻`̔TCY
#define IMC_ACCE_HIT_AREA_HALF	(4)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static IMC_ACCESSORIE_OBJ* cleanObjDataGet( IMC_ACCESSORIE_OBJ_TBL* objTbl );
static SWSP_OBJ_PTR SWSP_add( IMC_ACCE_ADD* data );

static void setHitTbl( IMC_ACCESSORIE_OBJ* obj, TP_HIT_TBL* tp_hit );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWFNge[u쐬
 *
 *	@param	obj_num		ANZT
 *	@param	heap		q[v
 *
 *	@return	IMC_ACCESSORIE_OBJ_TBL*	IuWFNge[u
 *
 *
 */
//-----------------------------------------------------------------------------
IMC_ACCESSORIE_OBJ_TBL* IMC_ACCE_ObjTblInit( int obj_num, int heap )
{
	IMC_ACCESSORIE_OBJ_TBL* objTbl;
	
	// m
	objTbl = sys_AllocMemory( heap, sizeof(IMC_ACCESSORIE_OBJ_TBL) );

	// ANZTe[u쐬
	objTbl->obj_tbl = sys_AllocMemory( heap, sizeof(IMC_ACCESSORIE_OBJ)*obj_num );
	memset( objTbl->obj_tbl, 0, sizeof(IMC_ACCESSORIE_OBJ)*obj_num );
	objTbl->obj_num = obj_num;

	return objTbl;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWFNge[u쐬
 *
 *	@param	obj_num		ANZT
 *	@param	heap		q[v
 *
 *	@return	IMC_ACCESSORIE_OBJ_TBL*	IuWFNge[u
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjTblDelete( IMC_ACCESSORIE_OBJ_TBL* obj_tbl )
{
	sys_FreeMemoryEz( obj_tbl->obj_tbl );
	sys_FreeMemoryEz( obj_tbl );

	obj_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT쐬
 *
 *	@param	data	IuWFNgo^f[^
 *
 *	@return	IMC_ACCESSORIE_OBJ*	ANZTIuWF
 *
 *
 */
//-----------------------------------------------------------------------------
IMC_ACCESSORIE_OBJ* IMC_ACCE_ObjAdd( IMC_ACCE_ADD* data )
{
	IMC_ACCESSORIE_OBJ* obj_data;
	
	// 󂢂Ăe[u擾
	obj_data = cleanObjDataGet( data->objTbl );
	GF_ASSERT( obj_data );
	
	// ANZTf[^ݒ
	obj_data->accessorie_no = data->accessorie_no;
	
	// `f[^쐬
	obj_data->drawObj = SWSP_add( data );

	return obj_data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNgf[^j
 *
 *	@param	obj		jIuWFNg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjDelete( IMC_ACCESSORIE_OBJ* obj )
{
	// `f[^̔j
	SWSP_Delete( obj->drawObj );

	// f[^clean
	memset( obj, 0, sizeof( IMC_ACCESSORIE_OBJ ) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWFNge[ũANZTj
 *
 *	@param	obj_tbl		IuWFNge[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjDeleteAll( IMC_ACCESSORIE_OBJ_TBL* obj_tbl )
{
	int i;

	for(i=0; i<obj_tbl->obj_num; i++){
		if( obj_tbl->obj_tbl[ i ].drawObj != NULL ){
			IMC_ACCE_ObjDelete( obj_tbl->obj_tbl + i );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plƂ̓蔻s
 *
 *	@param	obj		IuWFNgf[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_ACCE_ObjTpHit( IMC_ACCESSORIE_OBJ* obj )
{
	TP_HIT_TBL	tp_hit;
	
	// 蔻f[^쐬
	setHitTbl( obj, &tp_hit );	
	
	return GF_TP_SingleHitCont( &tp_hit );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plƂ̓蔻ׂs
 *
 *	@param	obj			IuWFNgf[^
 *	@param	offs_x		ォ̃ItZbgW
 *	@param	offs_y		ォ̃ItZbgW
 *	@param	drawData	LN^f[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ	iItZbgWsj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_ACCE_ObjTpHitEx( IMC_ACCESSORIE_OBJ* obj, int* offs_x, int* offs_y, NNSG2dCharacterData* drawData )
{
	BOOL check;		// `FbNp
	int x, y;		// ݂̍W
	int i, j;		// [vp

	// ܂蔻𕁒ʂɍs
	check = IMC_ACCE_ObjTpHit( obj );
	if( check == FALSE ){
		return FALSE;
	}

	// W擾
	IMC_ACCE_ObjGetMat( obj, &x, &y );

	// ItZbgl擾
	*offs_x = sys.tp_x - x;
	*offs_y = sys.tp_y - y;

	// ̈ʒũLN^f[^`FbN
	// FłȂ`FbN
/*	// J[io[OoȂTRUEԂ
	check = IMC_DRAW_CharCheck( drawData, *offs_x, *offs_y, 0 );
	if(check == IMC_DRAW_CHAR_CHECK_FALSE){
		return TRUE;
	}
//*/
	for( i = (*offs_y - IMC_ACCE_HIT_AREA_HALF); i < (*offs_y + IMC_ACCE_HIT_AREA_HALF); i++ ){
	
		if( i >= 0 ){
			
			for( j = (*offs_x - IMC_ACCE_HIT_AREA_HALF); j < (*offs_x + IMC_ACCE_HIT_AREA_HALF); j++ ){
				
				if( j >= 0 ){
					// J[io[OoȂTRUEԂ
					check = IMC_DRAW_CharCheck( drawData, j, i, 0 );
					if(check == IMC_DRAW_CHAR_CHECK_FALSE){
						return TRUE;
					}
				}
			}
		}
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plƂ̓蔻s
 *
 *	@param	obj		IuWFNgf[^
 *	@param	x		肘W
 *	@param	y		肙W
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_ACCE_ObjTpHitSelf( IMC_ACCESSORIE_OBJ* obj, int x, int y )
{
	TP_HIT_TBL	tp_hit;
	
	// 蔻f[^쐬
	setHitTbl( obj, &tp_hit );	

	return GF_TP_SingleHitSelf( &tp_hit, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Wݒ	iɃXvCgړj
 *
 *	@param	obj	ANZTIuWF
 *	@param	x	xW
 *	@param	y	yW
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjSetMat( IMC_ACCESSORIE_OBJ* obj, s16 x, s16 y )
{
	// XvCgɐݒ
	SWSP_SetSpritePos( obj->drawObj, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	W擾
 *
 *	@param	obj		ANZTIuWFNg
 *	@param	x		W擾
 *	@param	y		W擾
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjGetMat( IMC_ACCESSORIE_OBJ* obj, int* x, int* y )
{
	NNSG2dSVec2 mat;
	mat = SWSP_GetSpritePos( obj->drawObj );
	*x = mat.x;	
	*y = mat.y;	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	XvCgTCY擾
 *
 *	@param	obj		ANZTIuWFNg
 *	@param	x		TCY擾
 *	@param	y		TCY擾
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjGetSize( IMC_ACCESSORIE_OBJ* obj, int* x, int* y )
{
	NNSG2dSVec2 size;
	size = SWSP_GetSpriteSize( obj->drawObj );
	*x = size.x;	
	*y = size.y;	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTXg̃ANZT̕`ON@OFF@ݒ
 *
 *	@param	obj		ANZTIuWFNgf[^
 *	@param	flag	ON@OFF@tO
 *			
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjListDrawSet( IMC_ACCESSORIE_OBJ* obj, BOOL flag )
{
	SWSP_SetSpriteDraw( obj->drawObj, flag );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTXg̕\D揇ʂݒ
 *
 *	@param	obj			ANZTIuWF
 *	@param	priority	\D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjDrawPrioritySet( IMC_ACCESSORIE_OBJ* obj, int priority )
{
	SWSP_SetSpritePriority( obj->drawObj, priority );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTXg̕\D揇ʂ擾
 *
 *	@param	obj			ANZTIuWF
 *
 *	@return	priority
 *
 *
 */
//-----------------------------------------------------------------------------
int IMC_ACCE_ObjDrawPriorityGet( IMC_ACCESSORIE_OBJ* obj )
{
	return SWSP_GetSpritePriority( obj->drawObj );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	HŗǂTCY擾
 *
 *	@param	obj		IuWFNgf[^
 *	@param	ins_x	HŗǂTCYX
 *	@param	ins_y	HŗǂTCYY
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjInSizeGet( IMC_ACCESSORIE_OBJ* obj, int* ins_x, int* ins_y )
{
	int size_x, size_y;		// TCY擾p

	// ANZTIuWFNĝƂ
	IMC_ACCE_ObjGetSize( obj, &size_x, &size_y );
	
	// OtBbNTCY擾
	switch(size_x){
	case IMC_ACCE_SIZE_16:
		*ins_x = IMC_ACCE_HIT_16_SIZE_X;
		break;
	case IMC_ACCE_SIZE_32:
		*ins_x = IMC_ACCE_HIT_32_SIZE_X;
		break;
	case IMC_ACCE_SIZE_64:
		*ins_x = IMC_ACCE_HIT_64_SIZE_X;
		break;
	}

	switch(size_y){
	case IMC_ACCE_SIZE_16:
		*ins_y = IMC_ACCE_HIT_16_SIZE_Y;
		break;
	case IMC_ACCE_SIZE_32:
		*ins_y = IMC_ACCE_HIT_32_SIZE_Y;
		break;
	case IMC_ACCE_SIZE_64:
		*ins_y = IMC_ACCE_HIT_64_SIZE_Y;
		break;
	}

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	gklݒ肷
 *
 *	@param	obj			ANZTIuWF
 *	@param	scale_x		gkl
 *	@param	scale_y		gkl
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_ACCE_ObjScaleSet( IMC_ACCESSORIE_OBJ* obj, int scale_x, int scale_y )
{
	GF_ASSERT( obj );
	
	SWSP_SetSpriteScale( obj->drawObj, scale_x, scale_y );
}


//-----------------------------------------------------------------------------
/**
*		vCx[g֐S
*/
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *
 *	@brief	̃e[u擾
 *
 *	@param	objTbl	IuWFNge[u
 *
 *	@return	IMC_ACCESSORIE_OBJ*	̃e[u
 *
 *
 */
//-----------------------------------------------------------------------------
static IMC_ACCESSORIE_OBJ* cleanObjDataGet( IMC_ACCESSORIE_OBJ_TBL* objTbl )
{
	int i;		// [vp

	for(i=0; i<objTbl->obj_num; i++){
		if( objTbl->obj_tbl[ i ].drawObj == NULL ){
			return objTbl->obj_tbl + i;
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\tgEFAXvCg̓o^
 *
 *	@param	data	o^f[^	
 *
 *	@return	SWSP_OBJ_PTR	쐬XvCgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static SWSP_OBJ_PTR SWSP_add( IMC_ACCE_ADD* data )
{
	SWSP_ADDDATA add;


	add.s_sys = data->SWSPsys;
	add.p_char = data->SWSPchar;
	add.p_pltt = data->SWSPpltt;
	add.m_x		= data->m_x;
	add.m_y		= data->m_y;
	add.rota	= 0;
	add.alpha	= 31;
	add.pri		= 0;
	add.pltt_offs = data->pltt_offs;

	return SWSP_Add( &add );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWF̓蔻f[^쐬
 *
 *	@param	obj		IuWFNg
 *	@param	tp_hit	^b`pl蔻f[^
 *
 *	@return
 *
 *	OɃXvCg쐬sĂKv܂B
 *
 */
//-----------------------------------------------------------------------------
static void setHitTbl( IMC_ACCESSORIE_OBJ* obj, TP_HIT_TBL* tp_hit )
{
	NNSG2dSVec2	pos	= SWSP_GetSpritePos( obj->drawObj );
	NNSG2dSVec2 size = SWSP_GetSpriteSize( obj->drawObj );
	
	// XvCgTCY瓖蔻GA쐬
	tp_hit->rect.top		= pos.y;
	tp_hit->rect.bottom		= pos.y + size.y;
	tp_hit->rect.left		= pos.x;
	tp_hit->rect.right		= pos.x + size.x;
}
