//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_item_buff.c
 *	@brief		ACeێobt@
 *	@author		tomoya takahashi
 *	@data		2006.03.24
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "assert.h"

#define __IMC_ITEM_BUFF_H_GLOBAL
#include "include/application/imageClip/imc_item_buff.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *	@brief	Z[uf[^ACeێf[^쐬
 *
 *	@param	cp_imc_item		ACeZ[uf[^
 *	@param	p_buff			f[^i[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_ITEM_BUFF_Make( const IMC_ITEM_SAVEDATA* cp_imc_item, IMC_ITEM_BUFF* p_buff )
{
	int i;
	u32 idx;
	
	// ANZTێf[^擾
	for( i=0; i<IMC_ACCE_MAX; i++ ){
		p_buff->Acce[ i ] = ImcSaveData_GetAcceFlag( cp_imc_item, i );
	}

	// obOێf[^擾
	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){
		p_buff->Bg[ i ] = IMC_BG_RIGHT_MAX;
	}
	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){
		idx = ImcSaveData_GetBGFlag( cp_imc_item, i );
		
		if( idx != IMC_BG_RIGHT_MAX ){	
			p_buff->Bg[ idx ] = i;
		}
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	ANZTێւ炷
 *
 *	@param	p_buff	obt@f[^
 *	@param	acce_no	ANZTio[
 *	@param	num		炷l
 *
 *	@retval	TRUE	OȏɂȂ
 *	@retval	FALSE	OȉɂȂ
 */
//-----------------------------------------------------------------------------
BOOL IMC_ITEM_BUFF_AcceDec( IMC_ITEM_BUFF* p_buff, u32 acce_no, int num )
{
	GF_ASSERT( acce_no < IMC_ACCE_MAX );

	if( p_buff->Acce[ acce_no ] == IMC_ACCE_MAX ){
		return FALSE;
	}

	if( (p_buff->Acce[ acce_no ] - num) >= 0 ){
		p_buff->Acce[ acce_no ] -= num;
		return TRUE;
	}

	p_buff->Acce[ acce_no ] = 0;
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZT擾@Ԃ
 *
 *	@param	p_buff		obt@
 *	@param	acce_no		ANZTio[
 *
 *	@return	ANZT擾
 */
//-----------------------------------------------------------------------------
u32 IMC_ITEM_BUFF_AcceGetNum( const IMC_ITEM_BUFF* p_buff, u32 acce_no )
{
	GF_ASSERT( acce_no < IMC_ACCE_MAX );

	return p_buff->Acce[ acce_no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ԂΉBGNo擾
 *
 *	@param	p_buff	obt@
 *	@param	turn	
 *
 *	@return	BGio[
 */
//-----------------------------------------------------------------------------
u32 IMC_ITEM_BUFF_TurnBgNoGet( const IMC_ITEM_BUFF* p_buff, u32 turn )
{
	return p_buff->Bg[ turn ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGNO擾Ԃ߂
 *
 *	@param	p_buff		obt@
 *	@param	bgno		BGNo
 *
 *	@return			IMC_BG_RIGHT_MAX ̂Ƃ݂ĂȂ
 */
//-----------------------------------------------------------------------------
u32 IMC_ITEM_BUFF_BgNoTurnGet( const IMC_ITEM_BUFF* p_buff, u32 bgno )
{
	int i;

	for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){
		if( p_buff->Bg[ i ] == bgno ){
			return i;
		}
	}

	return i;
}

