//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_left_box.c
 *	@brief		{bNXVXe
 *	@author		tomoya takahashi
 *	@data		2005.09.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]



#include <string.h>
#include "system.h"
#include "assert.h"
#include "calctool.h"
#include "tcb.h"
#include "include/system/lib_pack.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/system/heapdefine.h"
#include "include/application/imageClip/imc_obj_list_func.h"

#define __IMC_LEFT_BOX_H_GLOBAL
#include "include/application/imageClip/imc_left_box.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	TlCf[^zuW萔
//	
//=====================================
#define IMC_LBOX_THUMB_SIZE_X	(24)		// TlCTCY
#define IMC_LBOX_THUMB_SIZE_Y	(32)		// TlCTCY
#define IMC_LBOX_MAT_SPACE_X	(8)			// zuƂ̃Xy[X
#define IMC_LBOX_MAT_SPACE_Y	(8)			// zuƂ̃Xy[X

#define IMC_LBOX_MAT_LINE_NUM	(3)			// PCɉTlC


//-----------------------------------------------------------------------------
/**
*		pbgύX@f[^
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	V[PX
//	
//=====================================
enum{
	IMC_LBOX_PLTT_CHG_INIT,		// 
	IMC_LBOX_PLTT_CHG_OUT_ACCE_S,// ANZTޏJn
	IMC_LBOX_PLTT_CHG_IN_ACCE_S,	// ANZTJn
	IMC_LBOX_PLTT_CHG_WAIT,		// eANZTtF[hI҂
	IMC_LBOX_PLTT_CHG_END,		// I
};

#define IMC_LBOX_PLTT_CHG_MOVE_Y	(132)		// ړl
#define IMC_LBOX_PLTT_CHG_COUNT	(3)			// ړ
#define IMC_LBOX_PLTT_CHG_ADD	(IMC_LBOX_PLTT_CHG_MOVE_Y / IMC_LBOX_PLTT_CHG_COUNT)		// P̈ړ
#define IMC_LBOX_PLTT_CHG_OBJ_S_NUM	(2)		// tF[hCIuWFNg̐邩
#define IMC_LBOX_PLTT_CHG_OBJ_E_NUM	(1)		// tF[hAEgIuWFNg̐邩
#define IMC_LBOX_PLTT_BG_SYNC	(5)		// BGVNœ


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	pbgtF[hX̃IuWFNgړ
//	\
//	
//=====================================
typedef struct {
	IMC_OBJLIST* obj;
	
	int count;
	int add_y;
} IMC_LBOX_PLTT_OBJ_MOVE;

//-------------------------------------
//	
//	pbgtF[h^XN
//	
//=====================================
typedef struct {
	IMC_LEFT_BOX* lbox;	// {bNX

	int out_mode;		// tF[hAEg郊Xgmode
	int out_list;		// tF[hAEg郊Xgno
	int in_mode;		// tF[hC郊Xgmode
	int in_list;		// tF[hC郊Xgno
	BOOL bg_fade;		// BGtF[hI`FbN
	int count;			// ėpJE^

	int seq;			// V[PX	
	int out_count;		// JE^
	int in_count;		// JE^

	IMC_LBOX_PLTT_OBJ_MOVE* move_obj;	// IuWFړf[^
	// e[uout_obj_count + in_obj_count
	int move_obj_num;		// e[u
} IMC_LBOX_PLTT_TASK;



//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void makeAcceList( IMC_LEFT_BOX* lbox, IMC_LEFT_BOX_INIT* init );
static void drawSetList( IMC_OBJLIST* dummy, int flag );
static void listDataMake( IMC_LEFT_LIST_DATA* list, int dummy_num );
static void listDataDest( IMC_LEFT_LIST_DATA* list );
static IMC_OBJLIST* getCurrentDummy( IMC_LEFT_BOX* lbox );
static IMC_OBJLIST* getDummyTbl( IMC_LEFT_BOX* lbox, int mode, int tbl_no );
static int getListSetDataNum( IMC_LEFT_BOX* lbox, int mode, int tbl_no );
static IMC_OBJLIST* getNoListObjData( IMC_LEFT_BOX* lbox, int mode, int tbl_no, int no );
static void drawFlgCurrentDummy( IMC_LEFT_BOX* lbox, int flag );
static void drawFlgSetCheck( IMC_LEFT_BOX* lbox, IMC_ACCESSORIE_OBJ* acce_obj, int mode, int list_num );
static void getBgSndThumbMat( int no, int* x, int* y );

static void plttChgTaskStart( IMC_LEFT_BOX* lbox, int out_mode, int out_list, int in_mode, int in_list );
static void plttChgTask( TCB_PTR tcb, void* work );
static void startPlttChgObj( IMC_OBJLIST* obj, IMC_LBOX_PLTT_OBJ_MOVE* data, int num );
static IMC_LBOX_PLTT_OBJ_MOVE* getCleanPlttChgObj( IMC_LBOX_PLTT_OBJ_MOVE* data, int num );
static void movePlttChgObj( IMC_LBOX_PLTT_OBJ_MOVE* data, int num );
static void movePlttChgObjCore( IMC_LBOX_PLTT_OBJ_MOVE* data );

static int movePlttChgGetObjAddNum( int obj_num, int div );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXp̈쐬
 *
 *	@param	lbox		{bNXpf[^
 *	@param	init		{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_InitSys( IMC_LEFT_BOX* lbox, IMC_LEFT_BOX_INIT* init )
{
	// `f[^ݒ
	lbox->boxDraw.SWSP_drawSys		= init->SWSP_drawSys;
	lbox->boxDraw.SWSP_charData		= init->SWSP_charData;
	lbox->boxDraw.SWSP_plttData		= init->SWSP_plttData;
	lbox->boxDraw.accePlttOfsTbl	= init->accePlttOfsTbl;
	lbox->boxDraw.BG_Ini			= init->BG_Ini;
	lbox->boxDraw.acce		= init->acce;
	
	// IuWFNgXge[u
	lbox->boxData.objListTbl = init->objListTbl;
	lbox->boxData.p_item_buff = init->p_item_buff;

	// wiio
	IMC_LBOX_BGSet( lbox, 0 );
	
	// ANZTXg쐬
	makeAcceList( lbox, init );

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNp̈j
 *
 *	@param	lbox		j鍶{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_DeleteSys( IMC_LEFT_BOX* lbox )
{
	int i;
	
	IMC_LBOX_DeleteAccessorieAll( lbox );

	for( i=0; i<IMC_LBOX_LIST_NUM; i++ ){
		listDataDest( &lbox->boxData.acce_list[ i ] );
	}
	
	memset( lbox, 0, sizeof( IMC_LEFT_BOX ) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT[io[烊Xgio[擾
 *
 *	@param	mode			[h
 *	@param	accessorie_no	ANZTio[
 *
 *	@return	int		ANZT[Xgio[
 *
 *
 */
//-----------------------------------------------------------------------------
int IMC_LBOX_GetListNo( int mode, int accessorie_no, IMC_ITEM_BUFF* p_item_buff )
{
	int list_no;
	
	switch(mode){
	case IMC_OBJLIST_ACCE:
		if( accessorie_no <= IMC_LBOX_ACCE_LIST00_END ){
			list_no = 0;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST01_END ){
			list_no = 1;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST02_END ){
			list_no = 2;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST03_END ){
			list_no = 3;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST04_END ){
			list_no = 4;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST05_END ){
			list_no = 5;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST06_END ){
			list_no = 6;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST07_END ){
			list_no = 7;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST08_END ){
			list_no = 8;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST09_END ){
			list_no = 9;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST10_END ){
			list_no = 10;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST11_END ){
			list_no = 11;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST12_END ){
			list_no = 12;
		}else if( accessorie_no <= IMC_LBOX_ACCE_LIST13_END ){
			list_no = 13;
		}
		break;

	case IMC_OBJLIST_BG:
		accessorie_no = IMC_ITEM_BUFF_BgNoTurnGet( p_item_buff, accessorie_no );
		list_no = accessorie_no / IMC_LBOX_BG_ONE_LIST_NUM;
		break;

	case IMC_OBJLIST_SND:
		accessorie_no = IMC_ITEM_BUFF_BgNoTurnGet( p_item_buff, accessorie_no );
		list_no = accessorie_no / IMC_LBOX_SND_ONE_LIST_NUM;
		break;
	}
	
	return list_no;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	[hƃANZTio[o^ĂׂW擾
 *
 *	@param	mode			[h
 *	@param	accessorie_no	ANZTio[
 *	@param	x				Wi[
 *	@param	y				Wi[
 *	@param	size_x			TCY
 *	@param	size_y			TCY
 *
 *	@return	none
 *	
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_GetMat( int mode, int accessorie_no, int* x, int* y, int size_x, int size_y, IMC_ITEM_BUFF* p_item_buff )
{
	switch(mode){
	case IMC_OBJLIST_ACCE:
		// ANZTW͗
		*x = IMC_LBOX_AREA_X_MOVEOK;
		*y = IMC_LBOX_AREA_Y_MOVEOK;
		*x += ( gf_mtRand() % (IMC_LBOX_AREA_WIDTH_MOVEOK - size_x) );
		*y += ( gf_mtRand() % (IMC_LBOX_AREA_HEIGHT_MOVEOK - size_y) );
		break;

	case IMC_OBJLIST_BG:
	case IMC_OBJLIST_SND:
		accessorie_no = IMC_ITEM_BUFF_BgNoTurnGet( p_item_buff, accessorie_no );
		getBgSndThumbMat( accessorie_no, x, y );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̐VKǉ
 *
 *	@param	lbox				{bNXpf[^
 *	@param	list_num			ǉANZTXg
 *	@param	mode				ANZT[h
 *	@param	accessorie_no		ǉANZTio[
 *
 *	@return	none
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZTύX[h
	IMC_OBJLIST_BG,			// BGύX[h
	IMC_OBJLIST_SND,		// TEhύX[h
	IMC_OBJLIST_ACCE_MAX	// [hő吔
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_AddAccessorie( IMC_LEFT_BOX* lbox, int mode, int accessorie_no )
{
	IMC_ACCE_ADD acce_add;
	IMC_ACCESSORIE_OBJ* acce_obj;
	IMC_OBJLIST* objList;
	int list_num;
	int char_no, pltt_no;
	int set_x, set_y;
	int size_x, size_y;
	
	// ANZTo^AXgɓo^
	// ANZTo^f[^쐬
	acce_add.objTbl = lbox->boxDraw.acce;
	acce_add.accessorie_no = accessorie_no;
	acce_add.SWSPsys	= lbox->boxDraw.SWSP_drawSys;
	acce_add.m_x	= 0;
	acce_add.m_y	= 0;

	// mode	ɂ킹ēo^
	switch( mode ){
	case IMC_OBJLIST_ACCE:
		char_no = IMC_ACCE_CHAR_CONT_ID( accessorie_no );
		pltt_no = IMC_ACCE_PLTT_CONT_ID( accessorie_no );
		acce_add.pltt_offs	= lbox->boxDraw.accePlttOfsTbl[ accessorie_no ];
		break;
	case IMC_OBJLIST_BG:
		char_no = IMC_BG_THUMB_CHAR_CONT_ID( accessorie_no );
		pltt_no = IMC_BG_THUMB_PLTT_CONT_ID( accessorie_no );
		acce_add.pltt_offs = 0;
		break;
	case IMC_OBJLIST_SND:
		char_no = IMC_SND_THUMB_CHAR_CONT_ID( accessorie_no );
		pltt_no = IMC_SND_THUMB_PLTT_CONT_ID( accessorie_no );
		acce_add.pltt_offs = 0;
		break;
	default:
		GF_ASSERT_MSG( 0, "modesȒlł" );
		break;
	}
	acce_add.SWSPchar	= lbox->boxDraw.SWSP_charData[ char_no ];
	acce_add.SWSPpltt	= lbox->boxDraw.SWSP_plttData[ pltt_no ];
	GF_ASSERT( acce_add.SWSPchar );
	GF_ASSERT_MSG( acce_add.SWSPpltt, "pltt_no %d", pltt_no );

	// Xgio[擾
	list_num = IMC_LBOX_GetListNo( mode, accessorie_no, lbox->boxData.p_item_buff );


	// o^
	acce_obj = IMC_ACCE_ObjAdd( &acce_add );

	// IuWFXg̍쐬
	objList = IMC_OBJLIST_MakeObjList( lbox->boxData.objListTbl, acce_obj, mode );
	
	// Xǧɓo^
	IMC_OBJLIST_Set( objList,
					lbox->boxData.acce_list[ mode ].dummyTbl[ list_num ].prev );

	// Wݒ
	IMC_OBJLIST_ACCEPOKE_SizeGet( objList, &size_x, &size_y );
	IMC_LBOX_GetMat( mode, accessorie_no, &set_x, &set_y, size_x, size_y, lbox->boxData.p_item_buff );
	IMC_OBJLIST_ACCEPOKE_Mat( objList, set_x, set_y );

	// \/\ݒ
	drawFlgSetCheck( lbox, acce_obj, mode, list_num );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̈ړǉ
 *
 *	@param	lbox		{bNXpf[^
 *	@param	acce_obj	ANZTf[^
 *	@param	mode		ANZT[h
 *	@param	list_num	o^郊Xg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_AddAccessorieMove( IMC_LEFT_BOX* lbox, int mode, int list_num, IMC_OBJLIST* acce_obj )
{
	// Xg̐擪ɓo^
	IMC_OBJLIST_Set(acce_obj, lbox->boxData.acce_list[ mode ].dummyTbl + list_num);


	// \/\ݒ
	drawFlgSetCheck( lbox, acce_obj->obj_data, mode, list_num );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWFj
 *
 *	@param	acce_obj	jANZT
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_DeleteAccessorie( IMC_OBJLIST* acce_obj )
{
	// Xgj
	IMC_OBJLIST_Delete( acce_obj );
	
	// ANZTj
	IMC_ACCE_ObjDelete( (IMC_ACCESSORIE_OBJ*)acce_obj->obj_data );

	// Xgj
	IMC_OBJLIST_DeleteObjList( acce_obj );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ邽߂̃Xg̍폜
 *
 *	@param	acce_obj	ړ邽߂ɃXg폜ANZTf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_DeleteAccessorieMove( IMC_OBJLIST* acce_obj )
{
	// Xgj
	IMC_OBJLIST_Delete( acce_obj );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	o^ĂANZTSĂ͂
 *
 *	@param	lbox	{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_DeleteAccessorieAll( IMC_LEFT_BOX* lbox )
{
	int i, j;
	
	// Xgj
	for( i=0; i<IMC_OBJLIST_ACCE_MAX; i++ ){
		for( j=0; j<lbox->boxData.acce_list[ i ].dummyNum; j++ ){
	
			IMC_OBJLIST_DeleteAll( lbox->boxData.acce_list[ i ].dummyTbl + j );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXANZT̕\D揇ݒ
 *
 *	@param	lbox	ubN
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_SetAccessoriePriority( IMC_LEFT_BOX* lbox )
{
	IMC_OBJLIST* work;
	IMC_OBJLIST* dummyTbl;
	BOOL	ret;
	
	int	priority = IMC_LBOX_ACCE_PRIORITY_START;

	dummyTbl = getCurrentDummy( lbox );
	
	work = dummyTbl->next;
	while( work != dummyTbl ){

		if( (work->flag == IMC_OBJLIST_ACCE) ||
			(work->flag == IMC_OBJLIST_BG) ||
			(work->flag == IMC_OBJLIST_SND)){

			IMC_ACCE_ObjDrawPrioritySet( work->obj_data, priority );	
		}

		priority --;
		
		work = work->next;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	JgANZTXgύX
 *
 *	@param	lbox			{bNXf[^
 *	@param	mode			ANZT[h
 *	@param	list_num		ݒ肷JgANZTXg
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZTύX[h
	IMC_OBJLIST_BG,		// BGύX[h
	IMC_OBJLIST_SND,		// TEhύX[h
	IMC_OBJLIST_ACCE_MAX		// [hő吔
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_LBOX_ChangeCurrentAccessorie( IMC_LEFT_BOX* lbox, int mode, int list_num )
{
	// ʏԂ̎ɂύX
	if( lbox->boxData.state == IMC_LBOX_STATE_NORM ){
		
		// pbgύX^XNX^[g
		plttChgTaskStart( lbox,
				lbox->boxData.mode, 
				lbox->boxData.acce_list[ lbox->boxData.mode ].dummyCurrent,
				mode,
				list_num );

			
		// V[hƃJgXgԍݒ
		lbox->boxData.mode		= mode;
		lbox->boxData.acce_list[ mode ].dummyCurrent = list_num;

		// D揇ʂ̐ݒ
		IMC_LBOX_SetAccessoriePriority( lbox );

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 * ŃGtFNgs܂B
 *
 *	@brief	JgANZTXg̑Z
 *
 *	@param	lbox			{bNXf[^
 *	@param	mode			ANZT[h
 *	@param	add_mode		[h
 *
 *	@retval	TRUE			
 *	@retval	FALSE			s
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,			// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_LBOX_FADELIST_MODE	// tF[hpXg	list_num͂OŒ
 */
//-----------------------------------------------------------------------------
BOOL IMC_LBOX_AddCurrentAccessorie( IMC_LEFT_BOX* lbox, int mode, int add_mode )
{
	IMC_OBJLIST* dummy;
	int currentno;
	int work;
	int i;
	int check_list;
	BOOL ret;
	
	// ݂̃Jgio[
	currentno = IMC_LBOX_GetCurrentNo( lbox, mode );

	// Xg܂킵āAǂAANZTĂe[uT@Ɠ̂ɂȂ牽Ȃ
	for( i=1; i<lbox->boxData.acce_list[mode].dummyNum; i++ ){

		if( add_mode == IMC_LBOX_ADD_ONE ){
			check_list = (i + currentno) % lbox->boxData.acce_list[mode].dummyNum;
		}else{
			check_list = currentno - i;
			if( check_list < 0 ){
				check_list += lbox->boxData.acce_list[mode].dummyNum;
			}
		}
		
		// ANZT1łĂpbgI
		dummy = getDummyTbl( lbox, mode, check_list );
		if( dummy->next != dummy ){

			// Xgݒ肵Ĕ
			ret = IMC_LBOX_ChangeCurrentAccessorie( lbox, mode, check_list );
			return ret; 
		}
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	JgANZTXgݒ
 *
 *	@param	lbox			{bNXf[^
 *	@param	mode			ANZT[h
 *	@param	list_num		ݒ肷JgANZTXg
 *
 *	@return	none
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,			// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_OBJLIST_ACCE_MAX	// [hő吔
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_SetCurrentAccessorie( IMC_LEFT_BOX* lbox, int mode, int list_num )
{
	// Jg_~[Xg\ݒ
	drawFlgCurrentDummy( lbox, FALSE );
	
	// V[hƃJgXgԍݒ
	lbox->boxData.mode		= mode;
	lbox->boxData.acce_list[ mode ].dummyCurrent = list_num;

	// Jg_~[Xg\ݒ
	drawFlgCurrentDummy( lbox, TRUE );
	
	IMC_LBOX_SetAccessoriePriority( lbox );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`pl{bNXɓĂ邩`FbN
 *
 *	@param	lbox		{bNXf[^
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_LBOX_TPHit( IMC_LEFT_BOX* lbox )
{
	// 蔻`f[^
	TP_HIT_TBL	tp_hit;
	
	// 蔻pf[^쐬
	tp_hit.rect.top		= IMC_LBOX_AREA_Y_MOVEOK;
	tp_hit.rect.bottom	= IMC_LBOX_AREA_Y_MOVEOK + IMC_LBOX_AREA_HEIGHT_MOVEOK;
	tp_hit.rect.left	= IMC_LBOX_AREA_X_MOVEOK;
	tp_hit.rect.right	= IMC_LBOX_AREA_X_MOVEOK + IMC_LBOX_AREA_WIDTH_MOVEOK;
	return GF_TP_SingleHitCont( &tp_hit );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wW{bNXɓĂ邩`FbN
 *
 *	@param	lbox		{bNXf[^
 *	@param	x			肘W
 *	@param	y			肙W
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_LBOX_TPHitSelf( IMC_LEFT_BOX* lbox, int x, int y )
{
	// 蔻`f[^
	TP_HIT_TBL	tp_hit;
	
	// 蔻pf[^쐬
	tp_hit.rect.top		= IMC_LBOX_AREA_Y_MOVEOK;
	tp_hit.rect.bottom	= IMC_LBOX_AREA_Y_MOVEOK + IMC_LBOX_AREA_HEIGHT_MOVEOK;
	tp_hit.rect.left	= IMC_LBOX_AREA_X_MOVEOK;
	tp_hit.rect.right	= IMC_LBOX_AREA_X_MOVEOK + IMC_LBOX_AREA_WIDTH_MOVEOK;
	return GF_TP_SingleHitSelf( &tp_hit, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTƂ̓蔻s
 *
 *	@param	lbox	{bNX
 *
 *	@return	none
 *
 *	JgANZTXg`FbN܂B
 *
 */
//-----------------------------------------------------------------------------
IMC_OBJLIST* IMC_LBOX_TPHitAccessorie( IMC_LEFT_BOX* lbox )
{
	IMC_OBJLIST* work;
	IMC_OBJLIST* dummyTbl;
	BOOL	ret;
	
	// ̃Jg_~[e[u擾
	dummyTbl = getCurrentDummy( lbox );
	
	work = dummyTbl->next;
	while( work != dummyTbl ){

		ret = FALSE;

		if( (work->flag == IMC_OBJLIST_ACCE) ||
			(work->flag == IMC_OBJLIST_BG) ||
			(work->flag == IMC_OBJLIST_SND)){
			
			ret = IMC_ACCE_ObjTpHit( work->obj_data );
		}

		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTƂ̓蔻ׂs
 *
 *	@param	lbox	{bNX
 *	@param	offset_x	ItZbgW
 *	@param	offset_y	ItZbgW
 *	@param	SWSP_UPchar	LN^\[Xe[u
 *
 *	@return	none
 *
 *	JgANZTXg`FbN܂B
 *
 */
//-----------------------------------------------------------------------------
IMC_OBJLIST* IMC_LBOX_TPHitAccessorieEx( IMC_LEFT_BOX* lbox, int* offset_x, int* offset_y, NNSG2dCharacterData** SWSP_UPchar )
{
	IMC_OBJLIST* work;
	IMC_OBJLIST* dummyTbl;
	BOOL	ret;
	
	// ̃Jg_~[e[u擾
	dummyTbl = getCurrentDummy( lbox );

	work = dummyTbl->next;
	while( work != dummyTbl ){

		ret = FALSE;

		ret = IMC_OBJLIST_ACCEPOKE_HitEx( work, offset_x, offset_y, SWSP_UPchar );

		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BG\
 *
 *	@param	lbox		{bNX
 *	@param	bg_num		{bNXBGio[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_BGSet( IMC_LEFT_BOX* lbox, int bg_num )
{
	IMC_BG_ADD add;
	
	// o^f[^ݒ
	add.bg_ini		= lbox->boxDraw.BG_Ini;
	add.arc_file	= ARC_IMAGECLIP_GRA;
	add.char_arc	= IMC_BG_LEFT_CG_ARC_GET(bg_num);
	add.pltt_arc	= IMC_BG_LEFT_FRAME_CL;
	add.scrn_arc	= IMC_BG_LEFT_SC_ARC_GET(bg_num);
	add.x			= IMC_LBOX_AREA_X;
	add.y			= IMC_LBOX_AREA_HEIGHT;
	add.frame		= GF_BGL_FRAME3_M;
	add.pltt_num	= IMC_LBOX_BG_PLTT_NUM;
	add.pltt_offs	= IMC_LBOX_BG_PLTT_OFFS;
	add.char_offs	= 0;
	add.heap		= HEAPID_IMAGECLIP_DRAW;

	IMC_BG_MakaObj( &lbox->boxDraw.bg, &add );

	lbox->boxData.back_no = bg_num;
}

//----------------------------------------------------------------------------
/**
 * GtFNgt
 *
 *	@brief	{bNXwiύX
 *
 *	@param	lbox		{bNf[^
 *	@param	bg_num		ύXBGio[
 *	@param	fade_way	tF[h
 *	@param	sync		VNōs
 *	@param	end_flg		ImtO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_BGChange( IMC_LEFT_BOX* lbox, int bg_num, int fade_way, int sync, BOOL* end_flg )
{
	IMC_BG_ADD add;
	int fade_x, fade_y;
	
	// o^f[^ݒ
	add.bg_ini		= lbox->boxDraw.BG_Ini;
	add.arc_file	= ARC_IMAGECLIP_GRA;
	add.char_arc	= IMC_BG_LEFT_CG_ARC_GET(bg_num);
	add.pltt_arc	= IMC_BG_LEFT_FRAME_CL;
	add.scrn_arc	= IMC_BG_LEFT_SC_ARC_GET(bg_num);
	add.x			= IMC_LBOX_AREA_X;
	add.y			= IMC_LBOX_AREA_HEIGHT;
	add.frame		= GF_BGL_FRAME3_M;
	add.pltt_num	= IMC_LBOX_BG_PLTT_NUM;
	add.pltt_offs	= IMC_LBOX_BG_PLTT_OFFS;
	add.char_offs	= 0;
	add.heap		= HEAPID_IMAGECLIP_DRAW;

	if( fade_way & IMC_LBOX_FADE_X ){
		fade_x = IMC_LBOX_AREA_WIDTH;
	}else{
		fade_x = 0;
	}

	if( fade_way & IMC_LBOX_FADE_Y ){
		fade_y = IMC_LBOX_AREA_HEIGHT;
	}else{
		fade_y = 0;
	}

	IMC_BG_ScrollReq( &lbox->boxDraw.bg, &add, fade_x, fade_y, sync, end_flg );

	lbox->boxData.back_no = bg_num;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGN[
 *
 *	@param	lbox		{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_BGClean( IMC_LEFT_BOX* lbox )
{
	IMC_BG_DeleteObj( &lbox->boxDraw.bg );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	݂̃[h
 *
 *	@param	lbox	{bNX
 *
 *	@return	ANZT[h
 *
 * mode
	IMC_OBJLIST_ACCE,		// ANZT^Cv
	IMC_OBJLIST_BG,			// BGTlC^Cv
	IMC_OBJLIST_SND,		// TEhTlC^Cv
	IMC_OBJLIST_ACCE_MAX	// [hő吔
 *
 */
//-----------------------------------------------------------------------------
int IMC_LBOX_GetMode( IMC_LEFT_BOX* lbox )
{
	GF_ASSERT( lbox );
	return lbox->boxData.mode;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	݂̃Jg_~[e[uio[擾
 *
 *	@param	lbox	{bNXf[^
 *	@param	mode	ׂ[h
 *	
 *	@return	Jg_~[e[uio[
 *
 *
 */
//-----------------------------------------------------------------------------
int IMC_LBOX_GetCurrentNo( IMC_LEFT_BOX* lbox, int mode  )
{
	IMC_LEFT_LIST_DATA mode_list;
	
	GF_ASSERT( lbox );

	mode_list = lbox->boxData.acce_list[ mode ];
	return mode_list.dummyCurrent;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_~[e[u擾
 *
 *	@param	lbox		{bNXIuWF
 *	@param	mode		ANZT[h
 *
 *	@return	_~[e[u
 *
 *
 */
//-----------------------------------------------------------------------------
int IMC_LBOX_GetDummyTblNum( IMC_LEFT_BOX* lbox, int mode )
{
	IMC_LEFT_LIST_DATA mode_list;
	
	GF_ASSERT( lbox );

	mode_list = lbox->boxData.acce_list[ mode ];
	return mode_list.dummyNum;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTXgSĂ̍W𓮂
 *
 *	@param	lbox		{bNX
 *	@param	mode		[h
 *	@param	list_no		Xgio[
 *	@param	x			W
 *	@param	y			W
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_LBOX_AccessorieListMove( IMC_LEFT_BOX* lbox, int mode, int list_no, int x, int y )
{
	IMC_OBJLIST* dummyTbl;
	
	// modeƃXg擪_~[f[^擾
	dummyTbl = getDummyTbl( lbox, mode, list_no );
	
	IMC_OBJLIST_ACCEPOKE_ListMove( dummyTbl, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bN󂵂Ă悢ԂȂ̂`FbN
 *
 *	@param	lbox	{bNXf[^
 *
 *	@retval	TRUE	OK
 *	@retval FALSE	NG		tF[hł
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_LBOX_ENDCheck( IMC_LEFT_BOX* lbox )
{
	if( lbox->boxData.state == IMC_LBOX_STATE_NORM ){
		return TRUE;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
*		vCx[g֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTXg쐬
 *
 *	@param	lbox	{bNXf[^
 *	@param	init	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void makeAcceList( IMC_LEFT_BOX* lbox, IMC_LEFT_BOX_INIT* init )
{
	// ANZTXg쐬
	listDataMake( &lbox->boxData.acce_list[ IMC_OBJLIST_ACCE ], init->accelist_num );

	// Jgɐݒ
	lbox->boxData.mode	= IMC_OBJLIST_ACCE;
	drawSetList( lbox->boxData.acce_list[ IMC_OBJLIST_ACCE ].dummyTbl, TRUE );

	// BGTlCXg쐬
	listDataMake( &lbox->boxData.acce_list[ IMC_OBJLIST_BG ], init->bglist_num );
	
	// TlCXg쐬
	listDataMake( &lbox->boxData.acce_list[ IMC_OBJLIST_SND ], init->sndlist_num );

	// tF[hpXg
	listDataMake( &lbox->boxData.acce_list[ IMC_LBOX_FADELIST_MODE ], IMC_LBOX_FADELIST_LISTNUM );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNgXg̕\\ݒ
 *
 *	@param	dummy		_~[f[^
 *	@param	flag		\\tO
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void drawSetList( IMC_OBJLIST* dummy, int flag )
{
	IMC_OBJLIST* work;
	
	work = dummy->next;
	while( work != (dummy) ){


		if( (work->flag == IMC_OBJLIST_ACCE) ||
			(work->flag == IMC_OBJLIST_BG) ||
			(work->flag == IMC_OBJLIST_SND)){
			
			IMC_ACCE_ObjListDrawSet( work->obj_data, flag );
		}

		work = work->next;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\\ݒʊ֐
 *
 *	@param	lbox		{bNX
 *	@param	mode		ANZT[h
 *	@param	list		Xgԍ
 *	@param	flag		\\
 *
 *	@return	none
 *	
 *
 */
//-----------------------------------------------------------------------------
static void drawSetListPack( IMC_LEFT_BOX* lbox, int mode, int list, int flag )
{
	IMC_OBJLIST* dummytbl;
	dummytbl = getDummyTbl( lbox, mode, list );

	drawSetList( dummytbl, flag );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Jg_~[Xg̕\\̐ݒ
 *
 *	@param	lbox		{bNXIuWF
 *	@param	flag		\/\tO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void drawFlgCurrentDummy( IMC_LEFT_BOX* lbox, int flag )
{
	IMC_OBJLIST* dummyTbl;
	
	// Jg_~[Xg擾
	dummyTbl = getCurrentDummy( lbox );

	// ꂩ̃Jg`ON
	drawSetList( 
			dummyTbl,
			flag );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_~[Xge[u̍쐬	
 *
 *	@param	list		_~[Xge[u
 *	@param	dummy_num	쐬擪_~[f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void listDataMake( IMC_LEFT_LIST_DATA* list, int dummy_num )
{
	int i;
	
	list->dummyTbl	= sys_AllocMemory( HEAPID_IMAGECLIP_DRAW, sizeof(IMC_OBJLIST) * dummy_num );
	list->dummyNum	= dummy_num;
	list->dummyCurrent	= 0;

	for( i=0; i<list->dummyNum; i++ ){
		list->dummyTbl[ i ].next = list->dummyTbl + i;
		list->dummyTbl[ i ].prev = list->dummyTbl + i;

		drawSetList( 
				list->dummyTbl + i,
				FALSE );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTXgf[^j
 *
 *	@param	list	ANZTXg
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void listDataDest( IMC_LEFT_LIST_DATA* list )
{
	sys_FreeMemoryEz( list->dummyTbl );
	list->dummyTbl	= NULL;

	memset( list, 0, sizeof(IMC_LEFT_LIST_DATA) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	̃Jg_~[Xg擾
 *
 *	@param	lbox	{bNXIuWF
 *
 *	@return	Jg̃_~[Xg
 *
 *
 */
//-----------------------------------------------------------------------------
static IMC_OBJLIST* getCurrentDummy( IMC_LEFT_BOX* lbox )
{
	IMC_LEFT_LIST_DATA mode_list;
		
	mode_list = lbox->boxData.acce_list[ lbox->boxData.mode ];
	return &mode_list.dummyTbl[ mode_list.dummyCurrent ];
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	_~[XgIĎ擾
 *
 *	@param	lbox		{bNXIuWF
 *	@param	mode		[h
 *	@param	tbl_no		e[uԍ
 *
 *	@return	_~[Xg
 *
 *
 */
//-----------------------------------------------------------------------------
static IMC_OBJLIST* getDummyTbl( IMC_LEFT_BOX* lbox, int mode, int tbl_no )
{
	IMC_LEFT_LIST_DATA mode_list;
		
	mode_list = lbox->boxData.acce_list[ mode ];
	return &mode_list.dummyTbl[ tbl_no ];
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Xgɓo^ĂANZT擾
 *
 *	@param	lbox		{bNX
 *	@param	mode		Xg[h
 *	@param	tbl_no		_~[f[^io[
 *
 *	@return	o^ĂIuWFNg
 *
 *
 */
//-----------------------------------------------------------------------------
static int getListSetDataNum( IMC_LEFT_BOX* lbox, int mode, int tbl_no )
{
	IMC_OBJLIST* dummy;
	IMC_OBJLIST* work;
	int count = 0;

	// _~[e[u
	dummy = getDummyTbl( lbox, mode, tbl_no );
	work = dummy->next;

	while( work != dummy ){
		
		count++;
		work = work->next;
	}

	return count;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNgXg̎w萔ڂ̃f[^擾
 *
 *	@param	lbox		{bNX
 *	@param	mode		Xg[h
 *	@param	tbl_no		Xgio[
 *	@param	no			w萔
 *
 *	@retval	NULL		w萔Ȃ
 *	@retval	̑		擾
 *
 *
 */
//-----------------------------------------------------------------------------
static IMC_OBJLIST* getNoListObjData( IMC_LEFT_BOX* lbox, int mode, int tbl_no, int no )
{
	IMC_OBJLIST* dummy;
	IMC_OBJLIST* work;
	int count = 0;

	// _~[e[u
	dummy = getDummyTbl( lbox, mode, tbl_no );
	work = dummy->next;

	while( work != dummy ){
		
		if( count == no ){

			return work;
		}

		count++;
		work = work->next;
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\/\f𔻒肵ĕ\\ݒ肷
 *
 *	@param	lbox		{bNXIuWF
 *	@param	acce_obj	ANZTIuWF
 *	@param	mode		[h
 *	@param	list_num	_~[f[^io[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void drawFlgSetCheck( IMC_LEFT_BOX* lbox, IMC_ACCESSORIE_OBJ* acce_obj, int mode, int list_num )
{
	// ǉ悪Jg̃XgłȂΔ\ɂ
	if( (lbox->boxData.mode != mode) || 
		(lbox->boxData.acce_list[ mode ].dummyCurrent != list_num) ){

		IMC_ACCE_ObjListDrawSet( acce_obj, FALSE );
	}else{

		IMC_ACCE_ObjListDrawSet( acce_obj, TRUE );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TlCW擾
 *
 *	@param	no		ANZTNo
 *	@param	x		XWi[
 *	@param	y		Wi[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void getBgSndThumbMat( int no, int* x, int* y )
{
	int step_y;		// ciڂ
	int step_x;		// iڂ
	
	// Xgio[ɂ
	no %= IMC_LBOX_BG_ONE_LIST_NUM;
	
	// ivZ
	step_y = no / IMC_LBOX_MAT_LINE_NUM;
	step_x = no % IMC_LBOX_MAT_LINE_NUM;

	// ܂
	*y = IMC_LBOX_MAT_SPACE_Y * (step_y + 1);
	*y += IMC_LBOX_THUMB_SIZE_Y * step_y;
	*y += IMC_LBOX_AREA_Y;

	// 
	*x = IMC_LBOX_MAT_SPACE_X * (step_x + 1);
	*x += IMC_LBOX_THUMB_SIZE_X * step_x;
	*x += IMC_LBOX_AREA_X;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgtF[hJn
 *
 *	@param	lbox			{bNX
 *	@param	out_mode		tF[hAEgpbgmode
 *	@param	out_list		tF[hAEgpbgno
 *	@param	in_mode			tF[hCpbgmode
 *	@param	in_list			tF[hCpbgno
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void plttChgTaskStart( IMC_LEFT_BOX* lbox, int out_mode, int out_list, int in_mode, int in_list )
{
	TCB_PTR tcb;
	IMC_LBOX_PLTT_TASK* pltt_tsk;
	
	// ^XN
	tcb = PMDS_taskAdd( plttChgTask, sizeof(IMC_LBOX_PLTT_TASK), 0, HEAPID_IMAGECLIP_DATA );

	// [Nɒlݒ
	pltt_tsk = TCB_GetWork( tcb );

	// f[^ݒ
	pltt_tsk->lbox		= lbox;
	pltt_tsk->out_mode	= out_mode;
	pltt_tsk->out_list	= out_list;
	pltt_tsk->in_mode	= in_mode;
	pltt_tsk->in_list	= in_list;
	pltt_tsk->seq		= IMC_LBOX_PLTT_CHG_INIT;
	pltt_tsk->out_count	= getListSetDataNum( lbox, out_mode, out_list );
	pltt_tsk->in_count	= getListSetDataNum( lbox, in_mode, in_list );
	pltt_tsk->move_obj_num = pltt_tsk->out_count + pltt_tsk->in_count;

	pltt_tsk->move_obj = sys_AllocMemory( HEAPID_IMAGECLIP_DATA, sizeof(IMC_LBOX_PLTT_OBJ_MOVE) * pltt_tsk->move_obj_num );
	GF_ASSERT( pltt_tsk->move_obj );
	memset( pltt_tsk->move_obj, 0, 
			sizeof(IMC_LBOX_PLTT_OBJ_MOVE) * pltt_tsk->move_obj_num );

	// pbgԂtF[hɂ
	lbox->boxData.state = IMC_LBOX_STATE_FADE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgtF[h
 *
 *	@param	tcb		tcb^XN
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void plttChgTask( TCB_PTR tcb, void* work )
{
	IMC_LBOX_PLTT_TASK* tsk_w = work;
	int i;
	int bg_no;
	
	switch( tsk_w->seq ){
	case IMC_LBOX_PLTT_CHG_INIT:
		
		// tF[hC郊Xg̍Wݒ
		IMC_LBOX_AccessorieListMove( tsk_w->lbox, tsk_w->in_mode, tsk_w->in_list, 0, -IMC_LBOX_PLTT_CHG_MOVE_Y );
		
		// tF[hC郊Xg\
		drawSetListPack( tsk_w->lbox, tsk_w->in_mode, tsk_w->in_list, TRUE );

		// BGtF[hAEgJn
		tsk_w->bg_fade = FALSE;
		bg_no = (tsk_w->lbox->boxData.back_no + 1) % IMC_BG_LEFT_MAX;
		IMC_LBOX_BGChange( tsk_w->lbox, bg_no, IMC_LBOX_FADE_Y, IMC_LBOX_PLTT_BG_SYNC, &tsk_w->bg_fade );

		// xɑ߂
		tsk_w->count = movePlttChgGetObjAddNum( tsk_w->out_count, IMC_LBOX_PLTT_CHG_OBJ_E_NUM );

		tsk_w->seq++;
		break;
		
	case IMC_LBOX_PLTT_CHG_OUT_ACCE_S:
		
		// BGƃANZTʊO
		for( i=0; i<tsk_w->count; i++ ){
			
			// o^
			if( (tsk_w->out_count - 1) >= 0 ){
				IMC_OBJLIST* obj;	

				tsk_w->out_count --;
				obj = getNoListObjData( tsk_w->lbox, tsk_w->out_mode, tsk_w->out_list, tsk_w->out_count );
				startPlttChgObj( obj, tsk_w->move_obj, tsk_w->move_obj_num );
			}
		}
		if(tsk_w->out_count == 0){

			// xɑ߂
			tsk_w->count = movePlttChgGetObjAddNum( tsk_w->in_count, IMC_LBOX_PLTT_CHG_OBJ_S_NUM );

			// 
			tsk_w->seq ++;
		}
		break;

	case IMC_LBOX_PLTT_CHG_IN_ACCE_S:
		// VANZTʂ
		for( i=0; i<tsk_w->count; i++ ){
			
			// o^
			if( (tsk_w->in_count - 1) >= 0 ){
				IMC_OBJLIST* obj;	

				tsk_w->in_count --;
				obj = getNoListObjData( tsk_w->lbox, tsk_w->in_mode, tsk_w->in_list, tsk_w->in_count );
				startPlttChgObj( obj, tsk_w->move_obj, tsk_w->move_obj_num );
			}
		}
		if(tsk_w->in_count == 0){
			// 
			tsk_w->seq ++;
			tsk_w->count = 0;
		}
		break;
		
	case IMC_LBOX_PLTT_CHG_WAIT:
		// SĂÎ҂
		tsk_w->count ++;

		// IuWFNg̓
		if( tsk_w->count > IMC_LBOX_PLTT_CHG_COUNT ){
				
			// BGtF[h
			if( tsk_w->bg_fade ){

				tsk_w->seq ++;
			}
		}
		break;

	case IMC_LBOX_PLTT_CHG_END:
		// WĐݒ肵ďI
		// tF[hAEg郊Xg\ɂ
		drawSetListPack( tsk_w->lbox, tsk_w->out_mode, tsk_w->out_list, FALSE );
		
		// tF[hAEgXg̍Wݒ
		IMC_LBOX_AccessorieListMove( tsk_w->lbox, tsk_w->out_mode, tsk_w->out_list, 0, -IMC_LBOX_PLTT_CHG_MOVE_Y );

		// pbgԂʏɂ
		tsk_w->lbox->boxData.state = IMC_LBOX_STATE_NORM;

		// mۂj
		sys_FreeMemoryEz( tsk_w->move_obj );
	
		// ^XNI
		PMDS_taskDel( tcb );
		
		return ;

	default:
		GF_ASSERT(0);
		break;
	}

	// IuWFNg
	movePlttChgObj( tsk_w->move_obj, tsk_w->move_obj_num );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tF[hp^[IuWFNg^XNɐݒ
 *
 *	@param	obj		IuWFf[^
 *	@param	data	f[^e[u
 *	@param	num		e[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void startPlttChgObj( IMC_OBJLIST* obj, IMC_LBOX_PLTT_OBJ_MOVE* data, int num )
{
	IMC_LBOX_PLTT_OBJ_MOVE* obj_move;

	// ̃IuWFe[u擾
	obj_move = getCleanPlttChgObj( data, num );


	obj_move->obj		= obj;
	obj_move->count		= IMC_LBOX_PLTT_CHG_COUNT;
	obj_move->add_y		= IMC_LBOX_PLTT_CHG_ADD;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	N[Ԃ̃e[u擾
 *
 *	@param	data	e[u
 *
 *	@return	ݒ肳ĂȂe[u
 *
 *
 */
//-----------------------------------------------------------------------------
static IMC_LBOX_PLTT_OBJ_MOVE* getCleanPlttChgObj( IMC_LBOX_PLTT_OBJ_MOVE* data, int num )
{
	int i;	// [vp

	for( i=0; i<num; i++ ){

		if( data[i].obj == NULL ){
			return data + i;
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgtF[hXIuWF֐s
 *
 *	@param	data	e[u
 *	@param	num		e[u
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void movePlttChgObj( IMC_LBOX_PLTT_OBJ_MOVE* data, int num )
{
	int i;		// [vp

	for( i=0; i<num; i++ ){
		if( data[i].obj ){

			movePlttChgObjCore( data + i );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgtF[hXIuWF֐
 *
 *	@param	data	e[u
 *
 *	@return none
 *
 */
//-----------------------------------------------------------------------------
static void movePlttChgObjCore( IMC_LBOX_PLTT_OBJ_MOVE* data )
{
	int x, y;
	
	IMC_OBJLIST_ACCEPOKE_MatGet( data->obj, &x, &y );

	y += data->add_y;

	IMC_OBJLIST_ACCEPOKE_Mat( data->obj, x, y );

	data->count --;

	// I`FbN
	if( data->count <= 0 ){

		memset( data, 0, sizeof(IMC_LBOX_PLTT_OBJ_MOVE) );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	xɓANZT擾
 *
 *	@param	obj_num		ANZT
 *	@param	div			VNɕ邩
 *
 *	@return	xɓ
 *
 *
 */
//-----------------------------------------------------------------------------
static int movePlttChgGetObjAddNum( int obj_num, int div )
{
	// ؂lɂ
	obj_num += div - (obj_num % div);

	return obj_num / div;
}
