//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_playsys.c
 *	@brief		C[WNbvvC[
 *	@author		tomoya takahashi 
 *	@data		2005.12.27
 *
 *
 * C[WNbvvbN쐬ĕ\ȊO̕@
 * \C[WNbvvC[
 * 
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <string.h>
#include "system.h"
#include "assert.h"
#include "calctool.h"
#include "calc2d.h"
#include "include/system/lib_pack.h"
#include "include/application/imageClip/imc_drawsys.h"
#include "include/application/imageClip/imc_accessorie.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/application/imageClip/imc_right_box.h"
#include "include/application/imageClip/imc_obj_list.h"
#include "include/application/imageClip/imc_obj_list_func.h"
#include "include/application/imageClip/imc_rbox_player.h"
#include "include/system/arc_util.h"

#define __IMC_PLAYSYS_H_GLOBAL
#include "include/application/imageClip/imc_playsys.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_PLAYSYS_OBJLIST_NUM	( IMC_RBOX_OBJ_CONTEST_MAX )
#define IMC_PLAYSYS_ACCE_NUM	( IMC_RBOX_ACCE_CONTEST_MAX )



//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
typedef struct _IMC_PLAYERSYS{
	// `֌W
	IMC_DRAW_DATA drawSys;

	// IuWFNgXgf[^
	IMC_OBJLIST_TBL	objListTbl;

	// ANZTf[^
	IMC_ACCESSORIE_OBJ_TBL* acce;

	// Eʃf[^
	IMC_RIGHT_BOX rbox;
	IMC_RBOX_PLAYER rbox_player;		// E{bNXvC[

	// |Pf[^
	POKEMON_PARAM* poke_para;

	// q[vID
	int		heap_id;

	// ݒSW
	int x;
	int y;
	int center_ofs_x;	// S܂ł̍W
	int center_ofs_y;	// S܂ł̍W
	u16 rota_num;
	VecFx32 scale;
	GXRgb color;		// S̕`J[

	BOOL BG_use;				// BGgptO

	BOOL draw_flag;			// `ON:TRUE OFF:FALSE
} IMC_PLAYERSYS;


//-------------------------------------
//	E{bNX@f[^
//=====================================
typedef struct {
	const IMC_SAVEDATA_POKEMON* p_poke;
	const IMC_SAVEDATA_ACCESSORIE* p_acce[ IMC_SAVEDATA_CONTEST_ACCE_NUM ];
	int acce_num;
	GF_BGL_INI* p_bg_ini;	// BGVXe	NOBĜƂNULLOK
	int bg_id;				// BGID
							// GF_BGL_FRAME2_M̃Rg[Zbgōs܂B
	int x;				// Ŝ̒S
	int y;				// Ŝ̒S
	int heap_id;		// gpq[vID
} IMC_PLAYERSYS_INIT_LOCAL;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static IMC_PLAYERSYS_PTR initPlayerSys( const IMC_PLAYERSYS_INIT_LOCAL* cp_init );
static IMC_PLAYERSYS_PTR initPlayerSys_NoBG( const IMC_PLAYERSYS_INIT_LOCAL* cp_init );
static void initDrawSys( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init );
static void mainDrawSys( IMC_PLAYERSYS* p_sys );
static void deleteDrawSys( IMC_PLAYERSYS* p_sys );

static void initRightBox( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init );
static void initRightBoxBG( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init );
static void deleteRightBox( IMC_PLAYERSYS* p_sys );
static void deleteRightBoxBG( IMC_PLAYERSYS* p_sys );

static void initWorkParam( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init );

static void setInitParamData( IMC_PLAYERSYS_INIT_LOCAL* p_init, const IMC_PLAYERSYS_INIT* cp_param );
static void setTelevisionSaveData( IMC_PLAYERSYS_INIT_LOCAL* p_init, const IMC_TELEVISION_SAVEDATA* save_data );
static void setContestSaveData( IMC_PLAYERSYS_INIT_LOCAL* p_init, const IMC_CONTEST_SAVEDATA* save_data );

static void imc_draw_MakeLoadSWSP_player( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData, const IMC_PLAYERSYS_INIT_LOCAL* cp_init, int heap );
static void loadAcceDataPlayer( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData, const IMC_PLAYERSYS_INIT_LOCAL* cp_init, int heap );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvC[
 *
 *	@param	cp_init		f[^
 *	@param	save_data	Z[uf[^
 *
 *	@return	ꂽf[^
 *
 *
 */
//-----------------------------------------------------------------------------
IMC_PLAYERSYS_PTR IMC_TelevisionPlayerInit( const IMC_PLAYERSYS_INIT* cp_init, const IMC_TELEVISION_SAVEDATA* save_data )
{
	IMC_PLAYERSYS_INIT_LOCAL init_local;

	// f[^ݒ
	setInitParamData( &init_local, cp_init );

	// Z[uf[^ݒ
	setTelevisionSaveData( &init_local, save_data );
	
	return initPlayerSys( &init_local );
}

IMC_PLAYERSYS_PTR IMC_TelevisionPlayerInit_NoBG( const IMC_PLAYERSYS_INIT* cp_init, const IMC_TELEVISION_SAVEDATA* save_data )
{
	IMC_PLAYERSYS_INIT_LOCAL init_local;

	// f[^ݒ
	setInitParamData( &init_local, cp_init );

	// Z[uf[^ݒ
	setTelevisionSaveData( &init_local, save_data );
	
	return initPlayerSys_NoBG( &init_local );
}

IMC_PLAYERSYS_PTR IMC_ContestPlayerInit( const IMC_PLAYERSYS_INIT* cp_init, const IMC_CONTEST_SAVEDATA* save_data )
{
	IMC_PLAYERSYS_INIT_LOCAL init_local;
	
	// f[^ݒ
	setInitParamData( &init_local, cp_init );

	// Z[uf[^ݒ
	setContestSaveData( &init_local, save_data );
	
	return initPlayerSys( &init_local );
}

IMC_PLAYERSYS_PTR IMC_ContestPlayerInit_NoBG( const IMC_PLAYERSYS_INIT* cp_init, const IMC_CONTEST_SAVEDATA* save_data )
{
	IMC_PLAYERSYS_INIT_LOCAL init_local;
	
	// f[^ݒ
	setInitParamData( &init_local, cp_init );

	// Z[uf[^ݒ
	setContestSaveData( &init_local, save_data );
	
	return initPlayerSys_NoBG( &init_local );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvC[C
 *
 *	@param	p_sys		C[WNbvvC[VXe
 *
 *	@retval	none
 *
 */
//-----------------------------------------------------------------------------
void IMC_PlayerMain( IMC_PLAYERSYS_PTR p_sys )
{
	if( p_sys->BG_use == TRUE ){
		// E{bNXvC[
		IMC_RBOX_PLAYER_Main( &p_sys->rbox_player );
	}

	// `揈
	if( p_sys->draw_flag == TRUE ){
		mainDrawSys( p_sys );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvC[I
 *
 *	@param	p_sys		C[WNbvvC[VXe
 *
 *	@retval	none
 *
 */
//-----------------------------------------------------------------------------
void IMC_PlayerEnd( IMC_PLAYERSYS_PTR p_sys )
{
	// E{bNXj
	if(p_sys->BG_use){
		deleteRightBoxBG( p_sys );
	}
	deleteRightBox( p_sys );

	// ANZTi[f[^j
	IMC_ACCE_ObjTblDelete( p_sys->acce );
	p_sys->acce = NULL;
	
	// IuWFNgXge[uj
	IMC_OBJLIST_TblDelete( &p_sys->objListTbl );
	
	// `VXej
	deleteDrawSys( p_sys );

	// |Pp[^j
	sys_FreeMemoryEz( p_sys->poke_para );

	sys_FreeMemoryEz( p_sys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VBlankԒɌĂԊ֐
 *
 *	@param	p_sys	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_PlayerVblank( IMC_PLAYERSYS_PTR p_sys )
{
	IMC_DRAW_VBlankPlayer( &p_sys->drawSys );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`tOݒ
 *
 *	@param	p_sys	[N
 *	@param	flag	`tO
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetDrawFlag( IMC_PLAYERSYS_PTR p_sys, BOOL flag )
{
	p_sys->draw_flag = flag;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`tO擾
 *
 *	@param	p_sys	[N
 *
 *	@retval	TRUE	`
 *	@retval	FALSE	`
 */
//-----------------------------------------------------------------------------
BOOL IMC_Player_GetDrawFlag( CONST_IMC_PLAYERSYS_PTR p_sys )
{
	return p_sys->draw_flag;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZT`@tOONOFF
 *	
 *	@param	p_sys		VXe[N
 *	@param	flag		tO
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetAcceDrawFlag( IMC_PLAYERSYS_PTR p_sys, BOOL flag )
{
	p_sys->drawSys.SWSP_DrawFlag = flag;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZT`@tO擾
 *
 *	@param	p_sys		VXe[N
 *
 *	@retval	TRUE	`
 *	@retval	FALSE	`
 */
//-----------------------------------------------------------------------------
BOOL IMC_Player_GetAcceDrawFlag( CONST_IMC_PLAYERSYS_PTR p_sys )
{
	return p_sys->drawSys.SWSP_DrawFlag;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Wݒ
 *
 *	@param	p_sys	VXe
 *	@param	x		xW
 *	@param	y		yW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetMatrix( IMC_PLAYERSYS_PTR p_sys, int x, int y )
{
	IMC_RBOX_ListMatSet( &p_sys->rbox, p_sys->x, p_sys->y, x, y );

	//@BGgĂƂBGʂݒ
	if( p_sys->BG_use ){
		GF_BGL_ScrollSet( p_sys->drawSys.BG_Ini, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_SET, IMC_RBOX_AREA_X - x );
		GF_BGL_ScrollSet( p_sys->drawSys.BG_Ini, GF_BGL_FRAME2_M, GF_BGL_SCROLL_Y_SET, IMC_RBOX_AREA_Y - y );
	}
	
	p_sys->x = x;
	p_sys->y = y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	],g厞̒SItZbglݒ
 *
 *	@param	p_sys	[N
 *	@param	x		ItZbg
 *	@param	y		ItZbg
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetRotScaleCenterOfs( IMC_PLAYERSYS_PTR p_sys, int x, int y )
{
	p_sys->center_ofs_x = x;
	p_sys->center_ofs_y = y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	]eݒ
 *
 *	@param	p_sys		[N
 *	@param	rota		]p
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetRota( IMC_PLAYERSYS_PTR p_sys, u16 rota )
{
	p_sys->rota_num = rota;
}

//----------------------------------------------------------------------------
/**
 *	@brief	gklݒ
 *
 *	@param	p_sys	[N
 *	@param	x		g
 *	@param	y		g
 *	@param	z		g
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetScale( IMC_PLAYERSYS_PTR p_sys, fx32 x, fx32 y, fx32 z )
{
	p_sys->scale.x = x;
	p_sys->scale.y = y;
	p_sys->scale.z = z;
}

//-----------------------------------------------------------------------------
/**
 *	@brief	|P𒆐SƂWƒSItZbg̐ݒ
 *
 *	@param	p_sys	[N
 *	@param	x		W	i͍ł͂Ȃ|P̒SWj
 *	@param	y		W	i͍ł͂Ȃ|P̒SWj
 *
 *	@param	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetPokeMatrix( IMC_PLAYERSYS_PTR p_sys, int x, int y )
{
	int pokex, pokey;
	int dis_x, dis_y;
	int pokesizx, pokesizy;
	int all_left, all_top;
	int c_x, c_y;

	// |PTCY
	IMC_POKE_SizeGet( &p_sys->rbox.boxDraw.poke, &pokesizx, &pokesizy );

	//@|PW
	IMC_RBOX_GetPokeMatrix( &p_sys->rbox, &pokex, &pokey );

	// Ŝ̈ړlvZ
	dis_x = x - pokex;
	dis_y = y - pokey;

	// Ŝړ
	all_left = p_sys->x + dis_x;
	all_top = p_sys->y + dis_y;
	IMC_Player_SetMatrix( p_sys, all_left, all_top );

	// ]@g@̒SWݒ
	c_x  = x - all_left; 
	c_y  = y - all_top; 
	IMC_Player_SetRotScaleCenterOfs( p_sys, c_x, c_y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̑ՍWݒ肷
 *
 *	@param	p_sys	[N
 *	@param	x		W	i͍ł͂Ȃ|P̑Wj
 *	@param	y		W	i͍ł͂Ȃ|P̑Wj
 *	@param	height	̃|P̍
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetPokeMatrix_Ground( IMC_PLAYERSYS_PTR p_sys, int x, int y, int height )
{
	int oy;	// YItZbgl
	fx32 scale_y_height;

	// S瑫܂ł̍ɕύX
	height = (SOFT_SPRITE_SIZE_Y/2) - height;
	
	// S̒l̍̊glł̒l߂
	scale_y_height = FX_Mul( height * FX32_ONE, p_sys->scale.y );
	oy = scale_y_height >> FX32_SHIFT;

	IMC_Player_SetPokeMatrix( p_sys, x, y-oy );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`Fw
 *
 *	@param	p_sys	vC[VXe
 *	@param	color	F
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetColor( IMC_PLAYERSYS_PTR p_sys, GXRgb color )
{
	p_sys->color = color;

	// SANZTA|PɐFݒ
	IMC_RBOX_SetObjColor( &p_sys->rbox, color );	
}

//----------------------------------------------------------------------------
/**
 *	@brief	`F@擾
 *
 *	@param	p_sys	vC[VXe
 *
 *	@return	F
 */
//-----------------------------------------------------------------------------
GXRgb IMC_Player_GetColor( CONST_IMC_PLAYERSYS_PTR cp_sys )
{
	return cp_sys->color;
}

//----------------------------------------------------------------------------
/**
 *	@brief	D揇ʂݒ	擪̃ANZT̗D揇
 *
 *	@param	p_sys	[N
 *	@param	pri		D揇
 */
//-----------------------------------------------------------------------------
void IMC_Player_SetPriority( IMC_PLAYERSYS_PTR p_sys, int pri )
{
	IMC_RBOX_SetObjPriorityMC( &p_sys->rbox, pri );
}

void IMC_Player_AddPriority( IMC_PLAYERSYS_PTR p_sys, int pri )
{
	IMC_RBOX_AddObjPriorityMC( &p_sys->rbox, pri );
}



//-----------------------------------------------------------------------------
/**
 *
 *			vCx[g֐
 * 
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvvC[VXe쐬
 *
 *	@param	cp_init		f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static IMC_PLAYERSYS_PTR initPlayerSys( const IMC_PLAYERSYS_INIT_LOCAL* cp_init )
{
	IMC_PLAYERSYS* p_sys;		// C[WNbv[N
	BOOL	check;				// p


	// VXe[N
	p_sys = sys_AllocMemory( cp_init->heap_id, sizeof(IMC_PLAYERSYS) );
	memset( p_sys, 0, sizeof(IMC_PLAYERSYS) );

	// q[vID
	p_sys->heap_id	= cp_init->heap_id;
	p_sys->poke_para = PokemonParam_AllocWork( cp_init->heap_id );
	ImcSaveData_GetUtilPokePara( cp_init->p_poke, p_sys->poke_para );

	// `f[^ݒs܂B
	initDrawSys( p_sys, cp_init );
	// BGʂgp̂ŁA\
	IMC_DRAW_InitSysPlayerBG( &p_sys->drawSys, cp_init->p_bg_ini, cp_init->heap_id );

	// IuWFNgXge[u쐬
	IMC_OBJLIST_TblInit( &p_sys->objListTbl, IMC_PLAYSYS_OBJLIST_NUM, cp_init->heap_id );
	
	// ANZTi[f[^쐬
	p_sys->acce = IMC_ACCE_ObjTblInit( IMC_PLAYSYS_ACCE_NUM, cp_init->heap_id );

	// E{bNXf[^쐬
	initRightBox( p_sys, cp_init );
	initRightBoxBG( p_sys, cp_init );

	// E{bNXvC[ɓo^
	IMC_RBOX_PLAYER_Init( &p_sys->rbox_player, &p_sys->rbox, cp_init->heap_id );

	p_sys->BG_use = TRUE;
	p_sys->draw_flag = TRUE;

	// WȂǂ̏f[^
	initWorkParam( p_sys, cp_init );

	return p_sys;
}

//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvvC[VXe쐬		BGȂVer
 *
 *	@param	cp_init		f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static IMC_PLAYERSYS_PTR initPlayerSys_NoBG( const IMC_PLAYERSYS_INIT_LOCAL* cp_init )
{
	IMC_PLAYERSYS* p_sys;		// C[WNbv[N
	BOOL	check;				// p

	// VXe[N
	p_sys = sys_AllocMemory( cp_init->heap_id, sizeof(IMC_PLAYERSYS) );
	memset( p_sys, 0, sizeof(IMC_PLAYERSYS) );

	// q[vID
	p_sys->heap_id	= cp_init->heap_id;
	p_sys->poke_para = PokemonParam_AllocWork( cp_init->heap_id );
	ImcSaveData_GetUtilPokePara( cp_init->p_poke, p_sys->poke_para );

	// `f[^ݒs܂B
	initDrawSys( p_sys, cp_init );

	// IuWFNgXge[u쐬
	IMC_OBJLIST_TblInit( &p_sys->objListTbl, IMC_PLAYSYS_OBJLIST_NUM, cp_init->heap_id );
	
	// ANZTi[f[^쐬
	p_sys->acce = IMC_ACCE_ObjTblInit( IMC_PLAYSYS_ACCE_NUM, cp_init->heap_id );

	// E{bNXf[^쐬
	initRightBox( p_sys, cp_init );

	p_sys->BG_use = FALSE;
	p_sys->draw_flag = TRUE;


	// WȂǂ̏f[^
	initWorkParam( p_sys, cp_init );

	return p_sys;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXef[^쐬
 *
 *	@param	p_sys			C[WNbvvC[VXe
 *	@param	cp_init			f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initDrawSys( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init )
{
	IMC_DRAW_LOADRES_DATA loadData;	// 摜f[^ǂݍ݃f[^

	// ʃf[^ݒ
//	IMC_DRAW_SetUp();

	// `VXe쐬
	// vC[p֐쐬Ă
	// ڍׁ@Kvȕ`VXe̍쐬
	//	\tgEFAXvCg
	//	ANZTpXvCg`VXe
	//	ANZTppbgItZbge[u
	SWSP_SYSDATA swsp;
	swsp.obj_num	= IMC_SPRITE_OBJ_NUM;
	swsp.char_num	= IMC_SPRITE_CHAR_NUM;
	swsp.pltt_num	= IMC_SPRITE_PLTT_NUM;
	swsp.heap		= cp_init->heap_id;
	IMC_DRAW_InitSysPlayer( &p_sys->drawSys, &swsp, cp_init->heap_id );

	// `f[^쐬
	// vC[p֐쐬
	// ANZTf[^KvȃeNX`Apbg̃e[u
	// 쐬
	imc_draw_MakeLoadSWSP_player( &p_sys->drawSys, &loadData, cp_init, cp_init->heap_id );

	// `f[^Vram]
	IMC_DRAW_LoadResource( &p_sys->drawSys, &loadData );

	// `f[^j
	IMC_DRAW_DestLoadSWSP( &loadData );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXeC֐
 *
 *	@param	p_sys	C[WNbvvC[VXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void mainDrawSys( IMC_PLAYERSYS* p_sys )
{
	IMC_DRAW_DrawSysPlayer( &p_sys->drawSys,
			p_sys->x + p_sys->center_ofs_x,
			p_sys->y + p_sys->center_ofs_y,
			p_sys->rota_num, &p_sys->scale );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXej֐
 *
 *	@param	p_sys	C[WNbvvC[VXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteDrawSys( IMC_PLAYERSYS* p_sys )
{
	// `f[^j
	IMC_DRAW_DeleteResource( &p_sys->drawSys );

	// `VXej
	IMC_DRAW_DeleteSysPlayer( &p_sys->drawSys );
	if(p_sys->BG_use){
		IMC_DRAW_DeleteSysPlayerBG(&p_sys->drawSys);
	}

	// `ʐݒj
//	IMC_DRAW_PutBack();
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^쐬
 *
 *	@param	p_sys		C[WNbvvC[VXe
 *	@param	cp_init		f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initRightBox( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init )
{
	IMC_RIGHT_BOX_INIT	rbox_init;	// E{bNXf[^
	int poke_x, poke_y, poke_pri;


	// E{bNXf[^쐬
	// `f[^
	memset( &rbox_init, 0, sizeof(IMC_RIGHT_BOX_INIT) );
	rbox_init.SWSP_drawSys		= p_sys->drawSys.SWSP_drawSys;
	rbox_init.SWSP_charData		= p_sys->drawSys.SWSP_charData;
	rbox_init.SWSP_plttData		= p_sys->drawSys.SWSP_plttData;
	rbox_init.accePlttOfsTbl	= p_sys->drawSys.accePlttOfsTbl;
	rbox_init.SSM_drawSys		= p_sys->drawSys.SSM_drawSys;
	rbox_init.BG_Ini			= p_sys->drawSys.BG_Ini;

	rbox_init.acce		= p_sys->acce;			// ANZTf[^
	rbox_init.objListTbl= &p_sys->objListTbl;	// IuWFNgXge[u
	rbox_init.acce_count_max = IMC_RBOX_OBJ_CONTEST_MAX;
	IMC_RBOX_InitSys( &p_sys->rbox, &rbox_init );
	
	// |Po^
	{
		SOFT_SPRITE_ARC	arc;
		poke_x = ImcSaveData_GetUtilPokeX( cp_init->p_poke );
		poke_y = ImcSaveData_GetUtilPokeY( cp_init->p_poke );
		poke_pri = ImcSaveData_GetUtilPokePri( cp_init->p_poke );
		IMC_RBOX_AddPokePlayer( &p_sys->rbox, p_sys->poke_para, &arc, poke_x, poke_y, poke_pri, cp_init->heap_id );
	}

	// E{bNXɔzuf[^쐬
	// f[^zus悤ɂ
	{
		int i;
		int x,y;
		int acce_no;
		s8 pri;
		for(i=0;i<cp_init->acce_num; i++){

			acce_no = ImcSaveData_GetUtilAcceNo( cp_init->p_acce[i] );
			x = ImcSaveData_GetUtilAcceMatX( cp_init->p_acce[i] );
			y = ImcSaveData_GetUtilAcceMatY( cp_init->p_acce[i] );
			pri = ImcSaveData_GetUtilAccePri( cp_init->p_acce[i] );
			
			// EANZTzu
			IMC_RBOX_AddAccessorieEasy( &p_sys->rbox, acce_no, 
					x, y, pri );
		}
	}//*/

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^쐬		BGʏ
 *
 *	@param	p_sys		C[WNbvvC[VXe
 *	@param	cp_init		f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initRightBoxBG( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init )
{
	// BG\
	// f[^BG̃f[^NOݒ肷
	IMC_RBOX_BGSet( &p_sys->rbox, cp_init->bg_id, cp_init->heap_id );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^j
 *
 *	@param	p_sys 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteRightBox( IMC_PLAYERSYS* p_sys )
{
	// E{bNXzuf[^j
	IMC_RBOX_DeleteAccessorieAll( &p_sys->rbox );
	
	// E{bNXf[^j
	IMC_RBOX_DeleteSys( &p_sys->rbox );
}

//----------------------------------------------------------------------------
/**
 *	@brief	E{bNXBG
 *
 *	@param	p_sys 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void deleteRightBoxBG( IMC_PLAYERSYS* p_sys )
{
	// BGN[
	IMC_RBOX_BGClean( &p_sys->rbox );
}

//----------------------------------------------------------------------------
/**
 *	@brief	[Nf[^̏ݒ
 *
 *	@param	p_sys	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void initWorkParam( IMC_PLAYERSYS* p_sys, const IMC_PLAYERSYS_INIT_LOCAL* cp_init )
{
	// ݍWݒ
	p_sys->x = IMC_RBOX_END_SX;
	p_sys->y = IMC_RBOX_END_SY;
	p_sys->center_ofs_x = (IMC_RBOX_AREA_WIDTH/2);
	p_sys->center_ofs_y = (IMC_RBOX_AREA_HEIGHT/2);

	// XP[lݒ
	p_sys->scale.x = FX32_ONE;
	p_sys->scale.y = FX32_ONE;
	p_sys->scale.z = FX32_ONE;

	// ]p
	p_sys->rota_num = 0;

	// Wݒ
	IMC_Player_SetMatrix( p_sys, cp_init->x, cp_init->y );

	// F
	p_sys->color = GX_RGB( 31,31,31 );
}


//----------------------------------------------------------------------------
/**
 *	@brief	VXe̒l
 *
 *	@param	p_init		[N
 *	@param	cp_param	f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setInitParamData( IMC_PLAYERSYS_INIT_LOCAL* p_init, const IMC_PLAYERSYS_INIT* cp_param )
{
	p_init->p_bg_ini	= cp_param->p_bg_ini;
	p_init->x			= cp_param->x;
	p_init->y			= cp_param->y;
	p_init->heap_id		= cp_param->heap_id;
}

//----------------------------------------------------------------------------
/**
 *	@brief	erANZTf[^擾֐
 *
 *	@param	p_init		i[
 *	@param	save_data	Z[uf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setTelevisionSaveData( IMC_PLAYERSYS_INIT_LOCAL* p_init, const IMC_TELEVISION_SAVEDATA* save_data )
{
	int i;

	// |P
	p_init->p_poke = ImcSaveData_GetTelevisionPokemon( save_data );
	
	// ANZT
	p_init->acce_num = 0;
	for( i=0; i<IMC_SAVEDATA_TELEVISION_ACCE_NUM; i++ ){
		// ANZTݒ`FbN
		if( ImcSaveData_CheckTelevisionAcceDataSet( save_data, i ) ){
			p_init->p_acce[ p_init->acce_num ] = ImcSaveData_GetTelevisionAcce( save_data, i );
			p_init->acce_num ++;
		}
	}

	// BGID
	p_init->bg_id = ImcSaveData_GetTelevisionBgId( save_data );
}
//----------------------------------------------------------------------------
/**
 *	@brief	ReXgANZTf[^擾֐
 *
 *	@param	p_init		i[
 *	@param	save_data	Z[uf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setContestSaveData( IMC_PLAYERSYS_INIT_LOCAL* p_init, const IMC_CONTEST_SAVEDATA* save_data )
{
	int i;

	// |P
	p_init->p_poke = ImcSaveData_GetContestPokemon( save_data );
	
	// ANZT
	p_init->acce_num = 0;
	for( i=0; i<IMC_SAVEDATA_CONTEST_ACCE_NUM; i++ ){
		// ANZTݒ`FbN
		if( ImcSaveData_CheckContestAcceDataSet( save_data, i ) ){
			p_init->p_acce[ p_init->acce_num ] = ImcSaveData_GetContestAcce( save_data, i );
			p_init->acce_num ++;
		}
	}

	// BGID
	p_init->bg_id = ImcSaveData_GetContestBgId( save_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief	XvCgp̓ǂݍރt@C쐬	C[WNbvvC[p
 *
 *	@param	drawData	`VXef[^
 *	@param	loadData	쐬
 *	@param	pp_acce		ANZTf[^e[u
 *	@param	acce_num	ANZT
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void imc_draw_MakeLoadSWSP_player( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData, const IMC_PLAYERSYS_INIT_LOCAL* cp_init, int heap )
{
	// SWSP̃\[Xo^f[^m
	IMC_DRAW_SWSPResDataAllocMemory( loadData, heap );
	
	// ANZTp\[X
	loadAcceDataPlayer( drawData, loadData, cp_init, heap );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTf[^̍쐬@vC[ȂǗp
 *
 *	@param	drawData		`VXef[^
 *	@param	loadData		ǂݍ݃f[^i[
 *	@param	pp_acce		ANZTf[^e[u
 *	@param	acce_num	ANZT
 *	@param	heap			gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadAcceDataPlayer( IMC_DRAW_DATA* drawData, IMC_DRAW_LOADRES_DATA* loadData, const IMC_PLAYERSYS_INIT_LOCAL* cp_init, int heap )
{
	int i;			// [vp
	int cont_id;	// f[^o^ID
	void* buff;
	int acce_no;

	// ANZTpf[^ǂݍ
	for(i=0; i<cp_init->acce_num; i++ ){
		acce_no = ImcSaveData_GetUtilAcceNo( cp_init->p_acce[i] );

		// ǗID擾
		cont_id = IMC_ACCE_CHAR_CONT_ID( acce_no );
		
		// ̂o^ς݂łȂ`FbN
		if( RESM_CheckID( loadData->SWSP_charRes, cont_id ) == TRUE ){
			
			// LN^f[^擾
			buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
					IMC_ACCE_ARC_NO_GET( acce_no ),
					FALSE, heap, ALLOC_BOTTOM);

			// \[X}l[Wɓo^
			RESM_AddResNormal( loadData->SWSP_charRes, buff, cont_id );		

			// ApbÑf[^o^
			NNS_G2dGetUnpackedCharacterData( buff, &loadData->SWSP_charTbl[ cont_id ].res_file );
			
			// XvCg`VXe|C^ݒ
			loadData->SWSP_charTbl[ cont_id ].s_sys = drawData->SWSP_drawSys;
		}
	}

	// pbgf[^o^
	buff = ArcUtil_Load(ARC_IMAGECLIP_GRA,
			IMC_DRAW_ACCESSORIE_PLTT_ARC, FALSE, heap, ALLOC_BOTTOM);
	
	// \[X}l[Wɓo^
	RESM_AddResNormal( loadData->SWSP_plttRes, buff, IMC_DRAW_ACCESSORIE_PLTT_ID );		
	
	// ApbN
	NNS_G2dGetUnpackedPaletteData( buff,
			&loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].res_file );

	// `VXef[^
	loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].s_sys = drawData->SWSP_drawSys;

	// ǂݍ݂
	loadData->SWSP_plttTbl[ IMC_DRAW_ACCESSORIE_PLTT_ID ].load_num = IMC_DRAW_ACCESSORIE_PLTT_NUM;
	
}




#ifdef PM_DEBUG
#include "include/system/wipe.h"
#include "include/gflib/display.h"
#include "include/gflib/gf_gx.h"
#include "include/application/imageClip/imc_drawsys.h"

//-------------------------------------
//	C[WNbvOf[^
//=====================================
typedef struct {
	// C[WNbvZ[ü
	const IMC_TELEVISION_SAVEDATA* p_imc_one_data;
	GF_BGL_INI*		BG_Ini;
	IMC_PLAYERSYS_PTR p_player;
} IMC_PLAY_WORK;

// VBlank
static void IMC_PlayTelevision_Vblank( void* p_work )
{
	IMC_PLAY_WORK* p_ip = p_work;

	IMC_PlayerVblank( p_ip->p_player );
	GF_BGL_VBlankFunc( p_ip->BG_Ini );
}

// `FbNpvbN
PROC_RESULT IMC_PlayTelevision_ProcInit( PROC* proc, int* seq )
{
	IMC_PLAY_WORK* p_ip;
	IMC_PROC_PLAY_WORK* p_proc_w;
	
	// q[v쐬
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DATA, 0x20000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DRAW, 0x40000 );

	// C[WNbv[N쐬
	p_ip = PROC_AllocWork( proc, sizeof( IMC_PLAY_WORK ), HEAPID_IMAGECLIP_DATA );
	memset( p_ip, 0, sizeof( IMC_PLAY_WORK ) );

	// VuNHuN֐ݒ
	sys_VBlankFuncChange( IMC_PlayTelevision_Vblank, p_ip );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	// Õf[^擾
	p_proc_w = PROC_GetParentWork( proc );

	// `֌W
	IMC_DRAW_SetUp();
	
	p_ip->BG_Ini = GF_BGL_BglIniAlloc( HEAPID_IMAGECLIP_DRAW );

	{
		IMC_PLAYERSYS_INIT init;
		init.p_bg_ini = p_ip->BG_Ini;
		init.x		  = 80;
		init.y		  = 16;
		init.heap_id  = HEAPID_IMAGECLIP_DRAW;
		p_ip->p_player = IMC_TelevisionPlayerInit( &init, p_proc_w->p_imc_one_data );
	}

	return PROC_RES_FINISH;
}

PROC_RESULT IMC_PlayTelevision_ProcMain( PROC* proc, int* seq )
{
	IMC_PLAY_WORK* p_ip = PROC_GetWork( proc );
	
/*	static GXRgb color;

	if( sys.cont & PAD_BUTTON_L ){ OS_Printf( "color %x\n", ++color ); }
	if( sys.cont & PAD_BUTTON_R ){ OS_Printf( "color %x\n", --color ); }
	IMC_Player_SetColor( p_ip->p_player, color );//*/

	{
		//Rc`Jn
		GF_G3X_Reset();

		NNS_G2dSetupSoftwareSpriteCamera();

		IMC_PlayerMain( p_ip->p_player );

		/* WIg_OGW֘ÃXbv */
		GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_Z);
	}



	switch( *seq ){
	case 0:
		(*seq) ++;
		break;

	case 1:
		WIPE_SYS_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_SHUTTERIN_UP,
				WIPE_TYPE_SHUTTERIN_UP,
				WIPE_FADE_BLACK,
				WIPE_DEF_DIV,WIPE_DEF_SYNC,
				HEAPID_IMAGECLIP_DATA );
		(*seq) ++;
		break;
	
	case 2:
		if( WIPE_SYS_EndCheck() ){
			(*seq) ++;
		}
		break;

	case 3:
		if( sys.trg & PAD_BUTTON_A ){
			IMC_Player_SetAcceDrawFlag( p_ip->p_player, FALSE );
		}
		if( sys.trg & PAD_BUTTON_Y ){
			IMC_Player_SetAcceDrawFlag( p_ip->p_player, TRUE );
		}
		if( sys.trg & PAD_BUTTON_B ){
			(*seq)++;
		}
		break;

	case 4:
		WIPE_SYS_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,
				WIPE_FADE_BLACK,
				WIPE_DEF_DIV,WIPE_DEF_SYNC,
				HEAPID_IMAGECLIP_DATA );
		(*seq) ++;
		break;

	case 5:
		if( WIPE_SYS_EndCheck() ){
			return PROC_RES_FINISH;
		}
		break;
	}
	return PROC_RES_CONTINUE;
}

PROC_RESULT IMC_PlayTelevision_ProcEnd( PROC* proc, int* seq )
{
	IMC_PLAY_WORK* p_ip = PROC_GetWork( proc );

	IMC_PlayerEnd( p_ip->p_player );

	// `VXej
	sys_FreeMemoryEz( p_ip->BG_Ini );

	// `ʐݒj
	IMC_DRAW_PutBack();

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	// [Nj
	PROC_FreeWork( proc );

	// q[vj
	sys_DeleteHeap( HEAPID_IMAGECLIP_DATA );
	sys_DeleteHeap( HEAPID_IMAGECLIP_DRAW );

	return PROC_RES_FINISH;
}

#endif

