//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_right_box.c
 *	@brief		E̔
 *	@author		tomoya takahashi
 *	@data		2005.09.22
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/application/imageClip/imc_obj_list_func.h"

#include "imc_calc.h"

#define	__IMC_RIGHT_BOX_H_GLOBAL
#include "include/application/imageClip/imc_right_box.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define IMC_RIGHT_BOX_ACCE_MAX	(10)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void ImcRightSetAcceList( IMC_RIGHT_BOX* p_data, IMC_OBJLIST* objList, BOOL top_bottom, NNSG2dCharacterData** SWSP_UPchar );
static void imcRbox_GetAcceEncSize( IMC_OBJLIST* objlist, int* enc_x, int* enc_y );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXp̈쐬
 *
 *	@param	rbox		E{bNXpf[^
 *	@param	init		E{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_InitSys( IMC_RIGHT_BOX* rbox, IMC_RIGHT_BOX_INIT* init )
{
	// `f[^쐬
	rbox->boxDraw.SWSP_drawSys	= init->SWSP_drawSys;
	rbox->boxDraw.SWSP_charData	= init->SWSP_charData;
	rbox->boxDraw.SWSP_plttData	= init->SWSP_plttData;
	rbox->boxDraw.accePlttOfsTbl= init->accePlttOfsTbl;
	rbox->boxDraw.SSM_drawSys	= init->SSM_drawSys;
	rbox->boxDraw.BG_Ini		= init->BG_Ini;
	rbox->boxDraw.acce			= init->acce;
	rbox->boxDraw.bg_no			= 0;

	// VXef[^
	rbox->boxData.objListTbl = init->objListTbl;

	rbox->boxData.dummy.next = &rbox->boxData.dummy;
	rbox->boxData.dummy.prev = &rbox->boxData.dummy;
	rbox->boxData.dummy_poke.next = &rbox->boxData.dummy_poke;
	rbox->boxData.dummy_poke.prev = &rbox->boxData.dummy_poke;
	rbox->boxData.obj_count = 0;
	rbox->boxData.obj_count_max = init->acce_count_max;


	// |PIuWF쐬
	{
		IMC_OBJLIST* objList;
		objList = IMC_OBJLIST_MakeObjList( rbox->boxData.objListTbl, &rbox->boxDraw.poke, IMC_OBJLIST_POKE );

		// 擪ɃXgo^
		IMC_OBJLIST_Set( objList, &rbox->boxData.dummy_poke );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNp̈j
 *
 *	@param	rbox		jE{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteSys( IMC_RIGHT_BOX* rbox )
{
	// |Pj
	IMC_RBOX_DeletePoke( rbox );

	// Xgj
	IMC_RBOX_DeleteAccessorieAll( rbox );
	
	memset( rbox, 0, sizeof(IMC_RIGHT_BOX) );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pf[^vC[p쐬
 *
 *	@param	rbox			E{bNXf[^
 *	@param	poke_para		쐬|P̃|Pp[^
 *	@param	arc_data		A[JCut@Cf[^i[̈
 *	@param	x				xW
 *	@param	y				yW
 *	@param	pri				\D揇
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_AddPokePlayer( IMC_RIGHT_BOX* rbox, POKEMON_PARAM* poke_para, SOFT_SPRITE_ARC* arc_data, int x, int y, int pri, int heap )
{
	// |Pf[^쐬
	IMC_POKE_Init( &rbox->boxDraw.poke, rbox->boxDraw.SSM_drawSys, poke_para, arc_data, heap );

	// \D揇
	IMC_POKE_DrawPrioritySet( &rbox->boxDraw.poke, pri );

	// W
	IMC_POKE_MatrixSet( &rbox->boxDraw.poke, x, y );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pf[^쐬
 *
 *	@param	rbox			E{bNXf[^
 *	@param	poke_para		쐬|P̃|Pp[^
 *	@param	arc_data		A[JCut@Cf[^i[̈
 *	@param	heap
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_AddPoke( IMC_RIGHT_BOX* rbox, POKEMON_PARAM* poke_para, SOFT_SPRITE_ARC* arc_data, int heap )
{
	// |Pf[^쐬
	IMC_POKE_Init( &rbox->boxDraw.poke, rbox->boxDraw.SSM_drawSys, poke_para, arc_data, heap );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|Pړǉ
 *
 *	@param	rbox	E{bNX
 *	@param	poke	|PIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_MoveAddPoke( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* poke )
{
	// |PナXg̍Ōɓo^
	IMC_OBJLIST_Set(  poke, rbox->boxData.dummy_poke.prev);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ邽߃Xg폜
 *	
 *	@param	poke		|PIuWF
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_MoveDeletePoke( IMC_OBJLIST* poke )
{
	// Xgj
	IMC_OBJLIST_Delete( poke );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PIuWFNgj
 *
 *	@param	rbox	E{bNXf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeletePoke( IMC_RIGHT_BOX* rbox )
{
	// |Pf[^j
	IMC_POKE_Delete( &rbox->boxDraw.poke );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̐VKǉ
 *
 *	@param	rbox				E{bNXpf[^
 *	@param	accessorie_no		ǉANZTio[
 *	@param	x					XW
 *	@param	y					YW
 *	@param	pri					\D揇
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s	io^ő吔ȏo^悤Ƃj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorieEasy( IMC_RIGHT_BOX* rbox, int accessorie_no, int x, int y, int pri )
{
	IMC_ACCE_ADD acce_add;
	IMC_ACCESSORIE_OBJ* acce_obj;
	
	// őo^`FbN
	if( rbox->boxData.obj_count < rbox->boxData.obj_count_max ){

		// ANZTo^AXgɓo^
		// ANZTo^f[^쐬
		acce_add.objTbl		= rbox->boxDraw.acce;
		acce_add.SWSPsys	= rbox->boxDraw.SWSP_drawSys;
		acce_add.SWSPchar	= rbox->boxDraw.SWSP_charData[ accessorie_no ];
		acce_add.SWSPpltt	= rbox->boxDraw.SWSP_plttData[ IMC_DRAW_ACCESSORIE_PLTT_ID ];
		acce_add.m_x		= x;
		acce_add.m_y		= y;
		acce_add.accessorie_no = accessorie_no;
		acce_add.pltt_offs	= rbox->boxDraw.accePlttOfsTbl[ accessorie_no ];

		// o^
		acce_obj = IMC_ACCE_ObjAdd( &acce_add );

		// \D揇ʐݒ
		IMC_ACCE_ObjDrawPrioritySet( acce_obj, pri );

		// XgIuWF쐬
		{
			IMC_OBJLIST* objList;

			objList = IMC_OBJLIST_MakeObjList( rbox->boxData.objListTbl, acce_obj, IMC_OBJLIST_ACCE );
			
			
			// Xg̐擪ɓo^
			IMC_OBJLIST_Set( objList, &rbox->boxData.dummy );
		}

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̈ړǉ
 *
 *	@param	rbox		E{bNXpf[^
 *	@param	acce_obj	ANZTf[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s	io^ő吔ȏo^悤Ƃj
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorieMoveEasy( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj )
{
	if( rbox->boxData.obj_count < rbox->boxData.obj_count_max ){

		// Xg̐擪ɓo^
		IMC_OBJLIST_Set( acce_obj, &rbox->boxData.dummy );

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZT̐VKǉ
 *
 *	@param	rbox				E{bNXpf[^
 *	@param	accessorie_no		ǉANZTio[
 *	@param	x					XW
 *	@param	y					YW
 *
 *	@retval	TRUE	
 *	@retval FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorie( IMC_RIGHT_BOX* rbox, int accessorie_no, int x, int y, NNSG2dCharacterData** SWSP_UPchar )
{
	IMC_ACCE_ADD acce_add;
	IMC_ACCESSORIE_OBJ* acce_obj;
	
	// őo^`FbN
	if( rbox->boxData.obj_count < rbox->boxData.obj_count_max ){

		// ANZTo^AXgɓo^
		// ANZTo^f[^쐬
		acce_add.objTbl		= rbox->boxDraw.acce;
		acce_add.SWSPsys	= rbox->boxDraw.SWSP_drawSys;
		acce_add.SWSPchar	= rbox->boxDraw.SWSP_charData[ accessorie_no ];
		acce_add.SWSPpltt	= rbox->boxDraw.SWSP_plttData[ IMC_DRAW_ACCESSORIE_PLTT_ID ];
		acce_add.m_x		= x;
		acce_add.m_y		= y;
		acce_add.accessorie_no = accessorie_no;
		acce_add.pltt_offs	= rbox->boxDraw.accePlttOfsTbl[ accessorie_no ];

		// o^
		acce_obj = IMC_ACCE_ObjAdd( &acce_add );

		// XgIuWF쐬
		{
			IMC_OBJLIST* objList;

			objList = IMC_OBJLIST_MakeObjList( rbox->boxData.objListTbl, acce_obj, IMC_OBJLIST_ACCE );
			
			
			// Xg̐擪ɓo^
			ImcRightSetAcceList( rbox, objList, TRUE, SWSP_UPchar );
		}

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[ׂ@C[WNbv쐬VXeł͂Ă]
 *	@brief	ANZT̈ړǉ
 *
 *	@param	rbox		E{bNXpf[^
 *	@param	acce_obj	ANZTf[^
 *	@param	SWSP_UPchar			pLN^f[^
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s	io^ő吔ȏo^悤Ƃj
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_AddAccessorieMove( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj, NNSG2dCharacterData** SWSP_UPchar )
{
	if( rbox->boxData.obj_count < rbox->boxData.obj_count_max ){

		// Xg̐擪ɓo^
		ImcRightSetAcceList( rbox, acce_obj, TRUE, SWSP_UPchar );

		//	IuWFNgǉ
		rbox->boxData.obj_count ++;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTIuWFj
 *
 *	@param	rbox	E{bNX
 *	@param	acce_obj	jANZT
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteAccessorie( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj )
{
	// Xgj
	IMC_OBJLIST_Delete( acce_obj );
	
	// ANZTj
	IMC_ACCE_ObjDelete( (IMC_ACCESSORIE_OBJ*)acce_obj->obj_data );

	// Xgj
	IMC_OBJLIST_DeleteObjList( acce_obj );
	
	//	IuWFNg폜
	rbox->boxData.obj_count--;

	// }CiX̒lɂȂ炨
	GF_ASSERT( rbox->boxData.obj_count >= 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ邽߂̃Xg̍폜
 *
 *	@param	rbox	E{bNX
 *	@param	acce_obj	ړ邽߂ɃXg폜ANZTf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteAccessorieMove( IMC_RIGHT_BOX* rbox, IMC_OBJLIST* acce_obj )
{
	// Xgj
	IMC_OBJLIST_Delete( acce_obj );

	//	IuWFNg폜
	rbox->boxData.obj_count--;
	// }CiX̒lɂȂ炨
	GF_ASSERT( rbox->boxData.obj_count >= 0 );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	o^ĂANZTSĂ͂
 *
 *	@param	rbox	E{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_DeleteAccessorieAll( IMC_RIGHT_BOX* rbox )
{
	IMC_OBJLIST_DeleteAll( &rbox->boxData.dummy );
	IMC_OBJLIST_DeleteAll( &rbox->boxData.dummy_poke );

	//	IuWFNg폜
	rbox->boxData.obj_count = 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNX̃XvCgŕ\ĂIuWFNg𓮂
 *
 *	@param	rbox	E{bNX
 *	@param	x		l
 *	@param	y		l
 *	
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_ListMove( IMC_RIGHT_BOX* rbox, int x, int y )
{
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy, x, y );
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy_poke, x, y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̏̃ANZT𓮂
 *
 *	@param	rbox	E{bNX
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_PokeUpListMove( IMC_RIGHT_BOX* rbox, int x, int y )
{
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy_poke, x, y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	E{bNXXg̍Wݒ
 *
 *	@param	rbox		E{bNX
 *	@param	old_x		O͉ɂĂ̂
 *	@param	old_y
 *	@param	x			ꂩ͉ɂ̂
 *	@param	y 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_ListMatSet( IMC_RIGHT_BOX* rbox, int old_x, int old_y, int x, int y )
{
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy, -old_x, -old_y );
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy, x, y );
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy_poke, -old_x, -old_y );
	IMC_OBJLIST_ACCEPOKE_ListMove( &rbox->boxData.dummy_poke, x, y );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNX̃ANZT\vCIeBݒ
 *
 *	@param	rbox		E{bNX 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_SetObjPriority( IMC_RIGHT_BOX* rbox )
{
	IMC_RBOX_SetObjPriorityMC( rbox, IMC_RBOX_ACCE_PRIORITY_START );
}
// ׂ
void IMC_RBOX_SetObjPriorityMC( IMC_RIGHT_BOX* rbox, int priority )
{
	IMC_OBJLIST* work;

	// 擪|P܂
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		if( work->flag == IMC_OBJLIST_ACCE ){
			IMC_ACCE_ObjDrawPrioritySet( work->obj_data, priority );	
		}else{
			
			IMC_POKE_DrawPrioritySet( work->obj_data, priority );	
		}

		priority --;
			
		work = work->next;
	}

	priority -= 8;	// Ԋu@`h~̂

	// |P牺
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){

		if( work->flag == IMC_OBJLIST_ACCE ){
			IMC_ACCE_ObjDrawPrioritySet( work->obj_data, priority );	
		}else{
			
			IMC_POKE_DrawPrioritySet( work->obj_data, priority );	
		}

		priority --;
		work = work->next;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	D揇ʑZ
 *
 *	@param	rbox
 *	@param	pri 
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_AddObjPriorityMC( IMC_RIGHT_BOX* rbox, int priority )
{
	IMC_OBJLIST* work;
	int tmp_pri;

	// 擪|P܂
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		if( work->flag == IMC_OBJLIST_ACCE ){
			tmp_pri = IMC_ACCE_ObjDrawPriorityGet( work->obj_data );
			IMC_ACCE_ObjDrawPrioritySet( work->obj_data, tmp_pri + priority );	
		}else{
			
			tmp_pri = IMC_POKE_DrawPriorityGet( work->obj_data );
			IMC_POKE_DrawPrioritySet( work->obj_data, tmp_pri + priority );	
		}

		work = work->next;
	}

	// |P牺
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){

		if( work->flag == IMC_OBJLIST_ACCE ){
			tmp_pri = IMC_ACCE_ObjDrawPriorityGet( work->obj_data );
			IMC_ACCE_ObjDrawPrioritySet( work->obj_data, tmp_pri + priority );	
		}else{
			
			tmp_pri = IMC_POKE_DrawPriorityGet( work->obj_data );
			IMC_POKE_DrawPrioritySet( work->obj_data, tmp_pri + priority );	
		}

		work = work->next;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	^b`plE{bNXɓĂ邩`FbN
 *
 *	@param	rbox		E{bNXf[^
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_TPHit( IMC_RIGHT_BOX* rbox )
{
	TP_HIT_TBL	tp_hit;

	tp_hit.rect.top		= IMC_RBOX_AREA_Y_MOVEOK;
	tp_hit.rect.bottom	= IMC_RBOX_AREA_Y_MOVEOK + IMC_RBOX_AREA_HEIGHT_MOVEOK;
	tp_hit.rect.left	= IMC_RBOX_AREA_X_MOVEOK;
	tp_hit.rect.right	= IMC_RBOX_AREA_X_MOVEOK + IMC_RBOX_AREA_WIDTH_MOVEOK;

	return GF_TP_SingleHitCont( &tp_hit );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	wWE{bNXɓĂ邩`FbN
 *
 *	@param	rbox		E{bNXf[^
 *	@param	x			肘W
 *	@param	y			肙W
 *
 *	@retval	TRUE		qbg
 *	@retval	FALSE		qbg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL IMC_RBOX_TPHitSelf( IMC_RIGHT_BOX* rbox, int x, int y )
{
	TP_HIT_TBL	tp_hit;

	tp_hit.rect.top		= IMC_RBOX_AREA_Y_MOVEOK;
	tp_hit.rect.bottom	= IMC_RBOX_AREA_Y_MOVEOK + IMC_RBOX_AREA_HEIGHT_MOVEOK;
	tp_hit.rect.left	= IMC_RBOX_AREA_X_MOVEOK;
	tp_hit.rect.right	= IMC_RBOX_AREA_X_MOVEOK + IMC_RBOX_AREA_WIDTH_MOVEOK;

	return GF_TP_SingleHitSelf( &tp_hit, x, y );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IuWFNgƂ̓蔻s
 *
 *	@param	rbox	E{bNX
 *
 *	@retval	NULL	ANZT
 *	@retval	NULL	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
IMC_OBJLIST* IMC_RBOX_TPHitObj( IMC_RIGHT_BOX* rbox )
{
	IMC_OBJLIST* work;
	BOOL	ret;

	// 擪̃ANZT
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		ret = IMC_OBJLIST_ACCEPOKE_Hit( work, IMC_OBJ_LIST_FUNC_TP_NOW, 0 );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}


	// |P̉̃ANZT
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){

		ret = IMC_OBJLIST_ACCEPOKE_Hit( work, IMC_OBJ_LIST_FUNC_TP_NOW, 0 );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}


	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTƂ̓蔻ׂs
 *
 *	@param	rbox		E{bNX
 *	@param	offset_x	ItZbgW
 *	@param	offset_y	ItZbgW
 *	@param	SWSP_UPchar	LN^f[^e[u
 *
 *	@return	none
 *
 * LN^f[^QƂĔFł͂Ȃ`FbN
 *
 */
//-----------------------------------------------------------------------------
IMC_OBJLIST* IMC_RBOX_TPHitObjEx( IMC_RIGHT_BOX* rbox, int* offset_x, int* offset_y, NNSG2dCharacterData** SWSP_UPchar )
{
	IMC_OBJLIST* work;
	BOOL	ret;

	// |P̏̃ANZT
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		ret = IMC_OBJLIST_ACCEPOKE_HitEx( work, offset_x, offset_y, SWSP_UPchar );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}


	// |P̉̃ANZT
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){

		ret = IMC_OBJLIST_ACCEPOKE_HitEx( work, offset_x, offset_y, SWSP_UPchar );
		
		if(ret == TRUE){

			return work;
		}
		
		work = work->next;
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BG\
 *
 *	@param	rbox		E{bNX
 *	@param	bg_num		E{bNXBGio[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_BGSet( IMC_RIGHT_BOX* rbox, int bg_num, int heap )
{
	IMC_BG_ADD add;
	
	// o^f[^ݒ
	add.bg_ini		= rbox->boxDraw.BG_Ini;
	add.arc_file	= ARC_IMAGECLIP_GRA;
	add.char_arc	= IMC_BG_RIGHT_CG_ARC_GET(bg_num);
	add.pltt_arc	= IMC_BG_RIGHT_CL_ARC_GET(bg_num);
	add.scrn_arc	= IMC_BG_RIGHT_SC_ARC_GET(bg_num);
	add.x			= IMC_RBOX_AREA_X;
	add.y			= IMC_RBOX_AREA_Y;
	add.frame		= GF_BGL_FRAME2_M;
	add.pltt_num	= IMC_RBOX_BG_PLTT_NUM;
	add.pltt_offs	= IMC_RBOX_BG_PLTT_OFFS;
	add.char_offs	= 0;
	add.heap		= heap;

	IMC_BG_MakaObj( &rbox->boxDraw.bg, &add );

	rbox->boxDraw.bg_no = bg_num;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGN[
 *
 *	@param	rbox		E{bNX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_BGClean( IMC_RIGHT_BOX* rbox )
{
	IMC_BG_DeleteObj( &rbox->boxDraw.bg );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PW擾
 *
 *	@param	rbox	E{bNX
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_GetPokeMatrix( IMC_RIGHT_BOX* rbox, int* x, int* y )
{
	*x = SoftSpriteParaGet( rbox->boxDraw.poke.sprite, SS_PARA_POS_X );
	*y = SoftSpriteParaGet( rbox->boxDraw.poke.sprite, SS_PARA_POS_Y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ێĂANZT擾
 *
 *	@param	rbox	E{bNX
 *
 *	@return	ANZT
 */
//-----------------------------------------------------------------------------
int IMC_RBOX_GetNowHaveAcceNum( IMC_RIGHT_BOX* rbox )
{
	return rbox->boxData.obj_count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̏ɏĂANZTHłTCY擾
 *
 *	@param	rbox		E{bNX[N
 *	@param	enc_x		HłTCY
 *	@param	enc_y		HłTCY
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_GetPokeUpListEncSize( IMC_RIGHT_BOX* rbox, int* enc_x, int* enc_y )
{
	int enc_x_max;
	int enc_y_max;
	int enc_x_w;
	int enc_y_w;
	IMC_OBJLIST* work;

	work = rbox->boxData.dummy_poke.next;
	enc_x_max = 0;
	enc_y_max = 0;
	while( work != &rbox->boxData.dummy_poke ){
		imcRbox_GetAcceEncSize( work, &enc_x_w, &enc_y_w );

		if(MATH_ABS(enc_x_w) > MATH_ABS(enc_x_max) ){
			enc_x_max = enc_x_w;
		}
		if( MATH_ABS(enc_y_w) > MATH_ABS(enc_y_max) ){
			enc_y_max = enc_y_w;
		}

		work = work->next;
	}

	*enc_x = enc_x_max;
	*enc_y = enc_y_max;
}

//----------------------------------------------------------------------------
/**
 *	@brief	E{bNX@Fݒ
 *
 *	@param	rbox	E{bNX
 *	@param	color	F
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void IMC_RBOX_SetObjColor( IMC_RIGHT_BOX* rbox, GXRgb color )
{
	IMC_OBJLIST* work;

	// |P̏̃ANZT
	work = rbox->boxData.dummy_poke.next;
	while( work != &rbox->boxData.dummy_poke ){

		if( work->flag == IMC_OBJLIST_ACCE ){
			IMC_ACCESSORIE_OBJ* p_obj = work->obj_data;
			SWSP_SetSpriteDiffColor( p_obj->drawObj, color );
		}else{
			IMC_POKE* p_obj = work->obj_data;
			SoftSpriteParaSet( p_obj->sprite, SS_PARA_DIFF_R, (color >> 10) & 0x1f );
			SoftSpriteParaSet( p_obj->sprite, SS_PARA_DIFF_G, (color >> 5) & 0x1f );
			SoftSpriteParaSet( p_obj->sprite, SS_PARA_DIFF_B, (color >> 0) & 0x1f );
		}
		work = work->next;
	}

	// |P̉̃ANZT
	work = rbox->boxData.dummy.next;
	while( work != &rbox->boxData.dummy ){
		IMC_ACCESSORIE_OBJ* p_obj = work->obj_data;
		SWSP_SetSpriteDiffColor( p_obj->drawObj, color );
		work = work->next;
	}
}







//----------------------------------------------------------------------------
/**
 *	@brief	ォɃANZTݒ肷
 *
 *	@param	p_data			{bNXf[^
 *	@param	objList			ANZTf[^
 *	@param	top_bottom		TRUE@擪@BOTTOM@Ō
 *	@param	SWSP_UPchar			pLN^f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ImcRightSetAcceList( IMC_RIGHT_BOX* p_data, IMC_OBJLIST* objList, BOOL top_bottom, NNSG2dCharacterData** SWSP_UPchar  )
{
	int i;
	int x;
	int y;
	int size_x;
	int size_y;
	int in_size_x;
	int in_size_y;
	int top;
	int bottom;
	int left;
	int right;
	int ch_x, ch_y;
	BOOL check;
	NNSG2dCharacterData* char_data;
	
	// W擾
	IMC_OBJLIST_ACCEPOKE_MatGet( objList, &x, &y );

	// TCY擾
	IMC_OBJLIST_ACCEPOKE_SizeGet( objList, &size_x, &size_y );

	// Hł悢TCY擾
	IMC_OBJLIST_ACCEPOKE_InSizeGet( objList, &in_size_x, &in_size_y );

	top = y + in_size_y;
	bottom = y + size_y - in_size_y;
	left = x + in_size_x;
	right = x + size_x - in_size_x;

	
	// LN^f[^擾
	char_data = SWSP_UPchar[ IMC_DRAW_POKE_CHAR_ID ];
	
	// |PGAɈ邩`FbN
	// 16_`FbN
	check = FALSE;
	for( i=0; i<16; i++ ){
		IMC_CALC_HitPoint16Get( top, bottom, left, right, i, &ch_x, &ch_y );
		check  |= IMC_POKE_TPHitExSelf( &p_data->boxDraw.poke, ch_x, ch_y, char_data );
	}

	
	// |P̏Ȃ|P̏ナXg
	if( check ){
		
		if( top_bottom ){
			// 擪ɓo^
			IMC_OBJLIST_Set( objList, &p_data->boxData.dummy_poke );
		}else{
			// Ōɓo^
			IMC_OBJLIST_Set( objList, p_data->boxData.dummy_poke.prev );
		}
	}else{

		if( top_bottom ){
			// 擪ɓo^
			IMC_OBJLIST_Set( objList, &p_data->boxData.dummy );
		}else{
			// Ōɓo^
			IMC_OBJLIST_Set( objList, p_data->boxData.dummy.prev );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTH݃TCY@擾
 *
 *	@param	objlist		ANZTXg
 *	@param	enc_x		H݂TCY
 *	@param	enc_y		H݂TCY
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void imcRbox_GetAcceEncSize( IMC_OBJLIST* objlist, int* enc_x, int* enc_y )
{
	int size_x,size_y;			// IuWFNgTCYXY
	int mat_x, mat_y;			// IuWFNgW
	int in_size_x, in_size_y;	// Hł悢TCYXY
	int top, bottom, left, right;// ㉺E
	int in_top, in_bottom, in_left, in_right;// Hݏ㉺E

	IMC_OBJLIST_ACCEPOKE_SizeGet( objlist, &size_x, &size_y );
	IMC_OBJLIST_ACCEPOKE_MatGet( objlist, &mat_x, &mat_y );
	IMC_OBJLIST_ACCEPOKE_InSizeGet( objlist, &in_size_x, &in_size_y );
	
	top		= mat_y + in_size_y;
	bottom	= mat_y + size_y - in_size_y;
	left	= mat_x + in_size_x;
	right	= mat_x + size_x - in_size_x;


	// E{bNX`Oɂǂ̂炢Hł邩`FbN
	// vXHłTCY@}CiXOK
	in_left		= IMC_RBOX_AREA_X_MOVEOK - left;
	in_right	= right - (IMC_RBOX_AREA_X_MOVEOK + IMC_RBOX_AREA_WIDTH_MOVEOK);
	in_top		= IMC_RBOX_AREA_Y_MOVEOK - top;
	in_bottom	= bottom - (IMC_RBOX_AREA_Y_MOVEOK + IMC_RBOX_AREA_HEIGHT_MOVEOK);

	// HłTCYԂ
	if( in_left > 0 ){
		*enc_x = in_left;
	}else if( in_right > 0 ){
		*enc_x = -in_right;
	}else{
		*enc_x = 0;
	}
	if( in_top > 0 ){
		*enc_y = in_top;
	}else if( in_bottom > 0 ){
		*enc_y = -in_bottom;
	}else{
		*enc_y = 0;
	}
}
