//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imc_sys.c
 *	@brief		C[WNbvCVXe
 *	@author		tomoya takahashi
 *	@data		2005.09.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#include <string.h>
#include "touchpanel_system.h"
#include "include/system/lib_pack.h"
#include "include/system/brightness.h"
#include "include/system/heapdefine.h"
#include "include/system/touch_subwindow.h"
#include "include/gflib/strbuf.h"
#include "include/gflib/msg_print.h"
#include "include/system/fontproc.h"
#include "include/system/msgdata.h"
#include "include/system/arc_util.h"
#include "include/system/window.h"
#include "include/contest/contest.h"
#include "src/contest/comm_command_contest.h"
#include "include/communication/comm_tool.h"

#include "include/application/imageClip/imc_drawsys.h"
#include "include/application/imageClip/imc_accessorie.h"
#include "include/application/imageClip/imc_drawdata_define.h"
#include "include/application/imageClip/imc_right_box.h"
#include "include/application/imageClip/imc_left_box.h"
#include "include/application/imageClip/imc_hand.h"
#include "include/application/imageClip/imc_acce_hand.h"
#include "include/application/imageClip/imc_obj_list.h"
#include "include/application/imageClip/imc_obj_list_func.h"
#include "include/application/imageClip/imc_button.h"
#include "include/system/wipe.h"
#include "include/application/imageClip/imc_subwin.h"
#include "include/application/imageClip/imc_rbox_player.h"
#include "include/application/imageClip/imc_snd_def.h"
#include "include/application/imageClip/imc_item_buff.h"

#include "include/system/pmfprint.h"

#include "include/communication/wm_icon.h"

#include "imc_calc.h"


#define __IMC_SYS_H_GLOBAL
#include "include/application/imageClip/imc_sys.h"


#ifdef PM_DEBUG

#define IMC_DEBUG

#endif


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	CvbN
//	V[PXݒ
//	
//=====================================
enum{
	IMC_SYS_SEQ_START_TIMING_WAIT,
	IMC_SYS_SEQ_FADE_IN,
	IMC_SYS_SEQ_FADE_IN_WAIT,
	IMC_SYS_SEQ_REFERENCE_ON,
	IMC_SYS_SEQ_REFARENCE_WAIT,
	IMC_SYS_SEQ_KET_WAIT,
	IMC_SYS_SEQ_MAIN,			// C[WNbv쐬C
	IMC_SYS_SEQ_END_CHECK_WAIT,
	IMC_SYS_SEQ_END_CHECK,		// I`FbN
	IMC_SYS_SEQ_SAVE_CHECK,		// Z[u`FbN
	IMC_SYS_SEQ_MAIN_WAIT,
	IMC_SYS_SEQ_FADE_OUT,
	IMC_SYS_SEQ_FADE_OUT_WAIT,
};

//-------------------------------------
//	
//	CvbN
//	V[PXݒ
//	ReXg
//	
//=====================================
enum{
	IMC_SYS_CON_SEQ_CON_SND_FADE,
	IMC_SYS_CON_SEQ_CON_SND_FADE_WAIT,
	IMC_SYS_CON_SEQ_CON_TEXT_ON,
	IMC_SYS_CON_SEQ_CON_TEXT_WAIT,
	IMC_SYS_CON_SEQ_CON_TEXT_THEME_ON,
	IMC_SYS_CON_SEQ_CON_TEXT_THEME_WAIT,
	IMC_SYS_CON_SEQ_CON_TEXT_LAST_ON,
	IMC_SYS_CON_SEQ_CON_TEXT_LAST_WAIT,
	IMC_SYS_CON_SEQ_CON_TEXT_LAST_DOUKI,
	IMC_SYS_CON_SEQ_START_TIMING_WAIT,
	IMC_SYS_CON_SEQ_CON_TEXT_END,
	IMC_SYS_CON_SEQ_FADE_IN,
	IMC_SYS_CON_SEQ_FADE_IN_WAIT,
	IMC_SYS_CON_SEQ_MAIN,			// C[WNbv쐬C
	IMC_SYS_CON_SEQ_EX_END_WAIT,	// I҂
	IMC_SYS_CON_SEQ_END_CHECK_WAIT,
	IMC_SYS_CON_SEQ_END_CHECK,		// I`FbN
	IMC_SYS_CON_SEQ_SAVE_CHECK,		// Z[u`FbN
	IMC_SYS_CON_SEQ_MAIN_WAIT,
	IMC_SYS_CON_SEQ_FADE_OUT,
	IMC_SYS_CON_SEQ_FADE_OUT_WAIT,
};

//-------------------------------------
//	
//	s
//	
//=====================================
enum{
	IMC_SYS_ACCE,		// ANZTύX
	IMC_SYS_BG,			// BGύX
	IMC_SYS_SND,		// TEhύX
	IMC_SYS_END_CHECK_REQ,// I`FbNNGXg
	IMC_SYS_END_CHECK,	// I`FbN
	IMC_SYS_SAVE_CHECK_REQ,	// Z[u`FbN
	IMC_SYS_SAVE,		// Z[u`FbN
	IMC_SYS_SAVE_CAN,	// Z[uCANCEL
	IMC_SYS_END_REQ,	// INGXg
	IMC_SYS_END_CANCEL_REQ,	// ILZNGXg
	IMC_SYS_END,		// I
};

//-------------------------------------
//	
//	ImFʂւ̃tF[h
//	
//=====================================
enum
{
	IMC_SEENFADEIN_ACCE_FADEOUT,
	IMC_SEENFADEIN_ACCE_FADEWAIT,
	IMC_SEENFADEIN_BRIGHTNESS_OUT,
	IMC_SEENFADEIN_BRIGHTNESS_WAIT,
	IMC_SEENFADEIN_BUTTON_OLDOUT,
//	IMC_SEENFADEIN_BUTTON_CHG,
	IMC_SEENFADEIN_MOVE_BG,
	IMC_SEENFADEIN_MOVE_BGINIT,
//	IMC_SEENFADEIN_BUTTON_NEWIN,
	IMC_SEENFADEIN_BRIGHTNESS_IN,
	IMC_SEENFADEIN_BRIGHTNESS_INWAIT,
	IMC_SEENFADEIN_END
};
enum
{
	IMC_SEENFADEOUT_BRIGHTNESS_OUT,
	IMC_SEENFADEOUT_BRIGHTNESS_OUTWAIT,
//	IMC_SEENFADEOUT_BUTTON_OLDOUT,
//	IMC_SEENFADEOUT_BUTTON_CHG,
	IMC_SEENFADEOUT_MOVE_BG_SET,
	IMC_SEENFADEOUT_MOVE_BG,
	IMC_SEENFADEOUT_BUTTON_NEWIN,
	IMC_SEENFADEOUT_BRIGHTNESS_IN,
	IMC_SEENFADEOUT_BRIGHTNESS_WAIT,
	IMC_SEENFADEOUT_ACCE_FADEIN,
	IMC_SEENFADEOUT_ACCE_FADEWAIT,
	IMC_SEENFADEOUT_END
};

//-------------------------------------
//	ANZTȂă|PƂĂ邩
//	`FbNVXẽIuWFNg
//=====================================
#define IMC_POKEON_ACCE_CHECK_OBJNUM	( IMC_RBOX_OBJ_CONTEST_MAX )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	C[WNbvf[^\
//	
//=====================================
typedef struct {
	// `֌W
	IMC_DRAW_DATA drawSys;

	// ACeobt@
	IMC_ITEM_BUFF item_buff;

	// IuWFNgXgf[^
	IMC_OBJLIST_TBL	objListTbl;

	// ANZTf[^
	IMC_ACCESSORIE_OBJ_TBL* acce;

	// ʃf[^
	IMC_LEFT_BOX lbox;
	
	// Eʃf[^
	IMC_RIGHT_BOX rbox;
	IMC_RBOX_PLAYER rbox_player;		// E{bNXvC[
	
	// nhf[^
	IMC_HAND hand;

	// t[BG
	IMC_BG	frame_bg;
	
	// {^f[^
	IMC_BUTTON_DATA bttn;				// 쐬
		
	// TuEBhE
	IMC_SUBWIN	subwin;

	int state;		// ̎s

	int effect;		// GtFNgp

	// nCCCG@EBhE
	TOUCH_SW_SYS* p_tsw;
	GF_BGL_BMPWIN* p_tsw_bmp;	// ImFEBhE

	// Z[utO
	BOOL save_flag;

	// ANZTő吔
	int acce_max;

	//@ReXgp
	int rank;			// N
	int mode;			// [h
	int type;			// 
	int theme;			// ā[
	CON_IMC_LOCAL* p_comm_data;	// ʐMf[^	

	const CONFIG* cp_config;	// RtBOf[^
	u32 msg_idx;
	STRBUF* p_glb_str;		// O[oobt@
	WORDSET* p_wordset;		// [hZbg
	
} IMC_SYS_WORK;

//-------------------------------------
//	
//	tF[hp[N
//	
//=====================================
typedef struct {
	IMC_SYS_WORK* sys_w;	// VXe[N
	BOOL*	end;			// ImtO
	int		work;			// [NtO
	int		seq;			// V[PX
} IMC_SYS_FADE_WORK;


//-------------------------------------
//	ANZTȂă|PƂĂ邩
//	`FbNPIuWFNgf[^
//=====================================
typedef struct {
	IMC_OBJLIST* obj;
	u32 pokemon_data;	// |PɂĂȂ:0  |PɂĂ:ȊO
} IMC_POKE_ON_ACCEOBJ;

//-------------------------------------
//	ANZTȂă|PƂĂ邩
//	`FbNVXe
//=====================================
typedef struct {
	IMC_POKE_ON_ACCEOBJ	obj[ IMC_RBOX_OBJ_CONTEST_MAX ];
	int set_num;
} IMC_POKE_ON_ACCESYS;
//-------------------------------------
//	ANZTȂă|PƂĂ邩
//	`FbN萔
//=====================================
enum{
	IMC_POKEON_ACCE_NONE,		// ȂĂȂ
	IMC_POKEON_ACCE_ON,			// ȂĂ
	IMC_POKEON_ACCE_SEARCHEND	// ȂĂ違SEARCHς
};



//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void imageClipVBlankFunc( void* work );

static void initDrawSys( IMC_SYS_WORK* imc_w );
static void mainDrawSys( IMC_SYS_WORK* imc_w );
static void deleteDrawSys( IMC_SYS_WORK* imc_w );

static void initRightBox( IMC_SYS_WORK* imc_w, POKEMON_PARAM* pp, int acce_max );
static void initRightBox_Contest( IMC_SYS_WORK* imc_w, POKEMON_PARAM* pp, int acce_max );
static void deleteRightBox( IMC_SYS_WORK* imc_w );

static void initLeftBox( IMC_SYS_WORK* imc_w );
static void deleteLeftBox( IMC_SYS_WORK* imc_w );
static void setLeftBoxBg( IMC_SYS_WORK* imc_w );

static void setFrameBG( IMC_SYS_WORK* imc_w, int no );
static void delFrameBG( IMC_SYS_WORK* imc_w );

static void initBttn( IMC_SYS_WORK* imc_w );
static void initBttn_Contest( IMC_SYS_WORK* imc_w );
static void deleteBttn( IMC_SYS_WORK* imc_w );
static void mainBttn( IMC_SYS_WORK* imc_w );
static void resetBttn( IMC_SYS_WORK* imc_w );

static void endBttn( IMC_BUTTON* bttn, void* work );
static void retBttn( IMC_BUTTON* bttn, void* work );
static void retbBttn( IMC_BUTTON* bttn, void* work );
static void	acceBttn( IMC_BUTTON* bttn, void* work );
static void	bgBttn( IMC_BUTTON* bttn, void* work );

static void endCkEndBttn( IMC_BUTTON* bttn, void* work );
static void endCkCancelBttn( IMC_BUTTON* bttn, void* work );

static void initSubWin( IMC_SYS_WORK* imc_w, const CONFIG* cp_config );
static void initSubWin_Contest( IMC_SYS_WORK* imc_w, int acce_num, int thema, CON_IMC_LOCAL* p_comm_data, const CONFIG* cp_config );
static void deleteSubWin( IMC_SYS_WORK* imc_w );

static void endSeenFadeIn( IMC_SYS_WORK* imc_w, BOOL* end );
static void endSeenFadeInTask( TCB_PTR tcb, void* work );
static void endSeenFadeOut( IMC_SYS_WORK* imc_w, BOOL* end );
static void endSeenFadeOutTask( TCB_PTR tcb, void* work );
static BOOL endSeenFadeMoveBg( IMC_SYS_FADE_WORK* fade_w, int move_x, int move_y, int move_count_num );

static void dataSave( IMC_TELEVISION_SAVEDATA* save_data, IMC_RIGHT_BOX* rbox, const MYSTATUS* cp_tr );
static void dataSave_Contest( IMC_CONTEST_SAVEDATA* save_data, IMC_RIGHT_BOX* rbox, int rank, const MYSTATUS* cp_tr );

static void initConTextSys( IMC_SYS_WORK* imc_w );
static void deleteConTextSys( IMC_SYS_WORK* imc_w );

static void initTouchSWSys( IMC_SYS_WORK* imc_w );
static void deleteTouchSWSys( IMC_SYS_WORK* imc_w );
static u32 mainTouchSWSys( IMC_SYS_WORK* imc_w );
static void initTouchSaveCheckSWSys( IMC_SYS_WORK* imc_w );
static u32 mainTouchSaveCheckSWSys( IMC_SYS_WORK* imc_w );

static void initTouchSWBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx );
static void setTouchSWBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx );
static void deleteTouchSWBmpWin( IMC_SYS_WORK* imc_w );

static void initContestTextBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx );
static u32 setContestTextBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx );
static void setContestWordSet( IMC_SYS_WORK* imc_w, int buff_id, int no );
static void endContestTextBmpWin( IMC_SYS_WORK* imc_w );
static void deleteContestTextBmpWin( IMC_SYS_WORK* imc_w );

static void initMsgBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx, u8 cx, u8 cy, u8 csx, u8 csy );
static void setMsgBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx );
static u32 setMsgBmpWin_okuri( IMC_SYS_WORK* imc_w, u32 str_idx );
static void endMsgBmpWin_okuri( IMC_SYS_WORK* imc_w );
static void deleteMsgBmpWin( IMC_SYS_WORK* imc_w );

static void setAcceNumSubWin( IMC_SYS_WORK* imc_w );

static int getRightAcceMax_contest( int rank );

static void initPokeOnAcceCheckSys( IMC_POKE_ON_ACCESYS* p_sys );
static void setPokeOnAcceCheckObj( IMC_POKE_ON_ACCESYS* p_sys, IMC_OBJLIST* obj, u32 init_data );
static void mainPokeOnAcceCheckSys( IMC_POKE_ON_ACCESYS* p_sys );
static IMC_OBJLIST* getPokeOnAcceCheckObjList( IMC_POKE_ON_ACCESYS* p_sys, u32 no );
static BOOL getPokeOnAcceCheckObjOnPoke( IMC_POKE_ON_ACCESYS* p_sys, u32 no );
static BOOL checkPokeOnAcceCalc( IMC_POKE_ON_ACCEOBJ* p_obj, IMC_POKE_ON_ACCEOBJ* p_check_obj );

static void setPokeOnAcceCheckObjList( IMC_POKE_ON_ACCESYS* p_sys, IMC_OBJLIST* dummy, u32 init_data );

static void Imc_OyaExEndCheck( IMC_SYS_WORK* imc_w );

//-----------------------------------------------------------------------------
/**
 *					ʏ
 * [JAMP_NORMAL]
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbN
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcInit( PROC* proc, int* seq )
{
	IMC_SYS_WORK*	imc_w;			// C[WNbv[N
	u32				check;			// p
	IMC_PROC_WORK*  p_imc_pr_w;		// O󂯎f[^


	// q[v쐬
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DATA, 0x20000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DRAW, 0x40000 );

	// C[WNbv[N쐬
	imc_w = PROC_AllocWork( proc, sizeof( IMC_SYS_WORK ), HEAPID_IMAGECLIP_DATA );
	memset( imc_w, 0, sizeof( IMC_SYS_WORK ) );

	// VuNHuN֐ݒ
	sys_VBlankFuncChange( imageClipVBlankFunc, imc_w );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~


	// Õf[^擾
	p_imc_pr_w = PROC_GetParentWork( proc );

	// Õf[^ݒ
	imc_w->cp_config = p_imc_pr_w->cp_config;

	// ^b`plI[gTvOJn
	InitTPSystem();
	check = InitTPNoBuff( 4 );
//	GF_ASSERT( check == TP_OK );
	if( check != TP_OK ){
		OS_Printf( "check != TP_OK\n" );
	}
//	while( InitTPNoBuff( 4 ) != TP_OK ){};

	// ACeobt@쐬
	IMC_ITEM_BUFF_Make( p_imc_pr_w->cp_imc_item, &imc_w->item_buff );

	// \ݒ
	initDrawSys( imc_w );

	// IuWFNgXge[u쐬
	IMC_OBJLIST_TblInit( &imc_w->objListTbl, IMC_OBJLIST_MAX, HEAPID_IMAGECLIP_DATA );
	
	// ANZTi[f[^쐬
	imc_w->acce = IMC_ACCE_ObjTblInit( IMC_SYS_ACCESSORIE_MAX, HEAPID_IMAGECLIP_DATA );

	// E{bNXf[^쐬
	initRightBox( imc_w, p_imc_pr_w->p_poke_para, IMC_RBOX_ACCE_TELEVISION_MAX );
	
	// {bNXf[^쐬
	initLeftBox( imc_w );

	// t[BG\
	setFrameBG( imc_w, IMC_BG_FRAME_00 );
	
	// {^f[^쐬
	initBttn( imc_w );

	// TuEBhE
	initSubWin( imc_w, p_imc_pr_w->cp_config );

	// nhf[^
	IMC_ACCE_HAND_Init( &imc_w->hand, &imc_w->rbox, &imc_w->lbox, &imc_w->drawSys, &imc_w->subwin, TRUE );

	// ͂@@EBhEm
	imc_w->p_tsw = TOUCH_SW_AllocWork( HEAPID_IMAGECLIP_DATA );
	imc_w->p_tsw_bmp = GF_BGL_BmpWinAllocGet( HEAPID_IMAGECLIP_DATA, 1 );

	// Ԑݒ
	// 	
	imc_w->state = IMC_SYS_ACCE;

	// TEhf[^[h(C[WNbv)(BGMp)
	Snd_DataSetByScene( SND_SCENE_SUB_IMAGE, 0, 0 );
	
	return PROC_RES_FINISH;
}

#ifdef IMC_DEBUG
extern void IMC_POKE_DEBUG_ChangePoke( IMC_POKE* poke, int heap, IMC_DRAW_DATA* drawData );
#endif

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbNC
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcMain( PROC* proc, int* seq )
{
	IMC_SYS_WORK* imc_w = PROC_GetWork( proc );
	PROC_RESULT	ret = PROC_RES_CONTINUE;
	IMC_PROC_WORK* p_pr_w = PROC_GetParentWork( proc );	// f[^Z[u

	switch( (*seq) ){
	case IMC_SYS_SEQ_START_TIMING_WAIT:
	case IMC_SYS_SEQ_FADE_IN:
		WIPE_SYS_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_SHUTTERIN_UP,
				WIPE_TYPE_SHUTTERIN_UP,
				WIPE_FADE_BLACK,
				WIPE_DEF_DIV,WIPE_DEF_SYNC,
				HEAPID_IMAGECLIP_DATA );
		(*seq)  = IMC_SYS_SEQ_FADE_IN_WAIT;
		break;
		
	case IMC_SYS_SEQ_FADE_IN_WAIT:
		if( WIPE_SYS_EndCheck() ){
			(*seq) ++;
		}
		break;

	case IMC_SYS_SEQ_REFERENCE_ON:
		if( p_pr_w->reference == TRUE ){

			MsgPrintTouchPanelFlagSet(MSG_TP_ON);

			imc_w->msg_idx = IMC_SUBWIN_SetBmpWinWait( &imc_w->subwin, ARC_MSG, NARC_msg_imageclip_dat, imgclip_manual_01 );
			(*seq) ++;
		}else{
			(*seq) = IMC_SYS_SEQ_MAIN;
		}
		break;
		
	case IMC_SYS_SEQ_REFARENCE_WAIT:
		if( GF_MSG_PrintEndCheck( imc_w->msg_idx ) == 0 ){
			IMC_SUBWIN_EndBmpWinWait( &imc_w->subwin );
			(*seq) ++;
		}
		break;

	case IMC_SYS_SEQ_KET_WAIT:
		if( (sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL)) | (sys.tp_trg) ){
			IMC_SUBWIN_SetBmpWin( &imc_w->subwin, ARC_MSG, NARC_msg_imageclip_dat, imgclip_manual_02 );

			MsgPrintTouchPanelFlagSet(MSG_TP_OFF);
			(*seq) ++;
		}
		break;

	//-------------------------------------
	//	
	//	C
	//	
	//=====================================
	case IMC_SYS_SEQ_MAIN:

		if(imc_w->state == IMC_SYS_END_CHECK_REQ){
			// tF[hJn
			endSeenFadeIn( imc_w, &imc_w->effect );
			// tF[hAEg
			(*seq) = IMC_SYS_SEQ_END_CHECK_WAIT;
		}

		// nh
		IMC_HAND_Main( &imc_w->hand );

		// E{bNX̃ANZTݒ
		setAcceNumSubWin( imc_w );

#ifdef IMC_DEBUG
		IMC_POKE_DEBUG_ChangePoke( &imc_w->rbox.boxDraw.poke, HEAPID_IMAGECLIP_DRAW, &imc_w->drawSys );
#endif

		// TuEBhEC
		IMC_SUBWIN_Main( &imc_w->subwin );
		
		// {^
		mainBttn( imc_w );
		break;

	case IMC_SYS_SEQ_END_CHECK_WAIT:	// I`FbNtF[h҂
		if( imc_w->effect ){
			imc_w->effect = FALSE;
			(*seq) = IMC_SYS_SEQ_END_CHECK;
			imc_w->state = IMC_SYS_END_CHECK;

			// E{bNXvC[쐬
			IMC_RBOX_PLAYER_Init( &imc_w->rbox_player, &imc_w->rbox, HEAPID_IMAGECLIP_DRAW );
		}
		break;

	case IMC_SYS_SEQ_END_CHECK:			// I`FbN
		
		// LZ`FbN
		if( imc_w->state == IMC_SYS_END_CANCEL_REQ ){
			// tF[hJn
			endSeenFadeOut( imc_w, &imc_w->effect );
			(*seq) = IMC_SYS_SEQ_MAIN_WAIT;
			break;
		}

		// I`FbN
		if( imc_w->state == IMC_SYS_END_REQ ){
			(*seq) = IMC_SYS_SEQ_SAVE_CHECK;
			imc_w->state = IMC_SYS_SAVE_CHECK_REQ;
			
			initTouchSaveCheckSWSys( imc_w );	// Z[u`FbN{^쐬
			break;
		}
		
		// {^
		imc_w->state = mainTouchSWSys( imc_w );

		// E{bNXvC[
		IMC_RBOX_PLAYER_Main( &imc_w->rbox_player );
		break;

	case IMC_SYS_SEQ_SAVE_CHECK:	// Z[u`FbN
		if( imc_w->state == IMC_SYS_SAVE ){
			imc_w->save_flag = TRUE;
			(*seq) = IMC_SYS_SEQ_FADE_OUT;
			break;
		}
		if( imc_w->state == IMC_SYS_SAVE_CAN ){
			imc_w->save_flag = FALSE;
			(*seq) = IMC_SYS_SEQ_FADE_OUT;
			break;
		}

		// {^
		imc_w->state = mainTouchSaveCheckSWSys( imc_w );

		// E{bNXvC[
		IMC_RBOX_PLAYER_Main( &imc_w->rbox_player );
		break;

	case IMC_SYS_SEQ_MAIN_WAIT:			// CʃtF[h҂
		if( imc_w->effect ){
			imc_w->effect = FALSE;
			(*seq) = IMC_SYS_SEQ_MAIN;
			imc_w->state = IMC_SYS_ACCE;		// ANZTύXł͂߂

			// E{bNXvC[I
			IMC_RBOX_PLAYER_Delete( &imc_w->rbox_player );
		}
		break;
		
	case IMC_SYS_SEQ_FADE_OUT:
		WIPE_SYS_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,
				WIPE_FADE_BLACK,
				WIPE_DEF_DIV,WIPE_DEF_SYNC,
				HEAPID_IMAGECLIP_DATA );
		(*seq) ++;
		break;

	case IMC_SYS_SEQ_FADE_OUT_WAIT:
		if( WIPE_SYS_EndCheck() ){
			(*seq) = 0;
			imc_w->state = IMC_SYS_END;
			ret = PROC_RES_FINISH;

			// E{bNXvC[I
			IMC_RBOX_PLAYER_Delete( &imc_w->rbox_player );
		}
		break;
	}

	///////////////////////////////////////////////
	//
	//	͋ʏ
	//
	//////////////////////////////////////////////
	// `揈
	mainDrawSys( imc_w );
	

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbNI
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcEnd( PROC* proc, int* seq )
{
	IMC_SYS_WORK* imc_w = PROC_GetWork( proc );
	u32	check;	// p
	IMC_PROC_WORK* p_pr_w = PROC_GetParentWork( proc );	// f[^Z[u

	// f[^Z[u
	if( imc_w->save_flag == TRUE ){
		// R[hf[^@XRAZ
		RECORD_Score_Add( p_pr_w->p_record, SCORE_ID_MAKE_CLIP );
		
		dataSave( p_pr_w->p_imc_one_data, &imc_w->rbox, p_pr_w->cp_tr );	
	}

	// Z[uLݒ
	if( p_pr_w->p_save_flg != NULL ){
		if( imc_w->save_flag == TRUE ){
			*p_pr_w->p_save_flg = TRUE;
		}else{
			*p_pr_w->p_save_flg = FALSE;
		}
	}

	// nCCCGEBhEj
	TOUCH_SW_FreeWork( imc_w->p_tsw );	
	GF_BGL_BmpWinFree( imc_w->p_tsw_bmp, 1 );
	
	// TuEBhEj
	deleteSubWin( imc_w );
	
	// nhj
	IMC_ACCE_HAND_Delete( &imc_w->hand );

	// {^j
	deleteBttn( imc_w );
	
	// t[BGj
	delFrameBG( imc_w );
	
	// E{bNXj
	deleteRightBox( imc_w );
	
	// {bNXj
	deleteLeftBox( imc_w );
	
	// ANZTi[f[^j
	IMC_ACCE_ObjTblDelete( imc_w->acce );
	imc_w->acce = NULL;
	
	// IuWFNgXge[uj
	IMC_OBJLIST_TblDelete( &imc_w->objListTbl );
	
	deleteDrawSys( imc_w );
	
	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	// ^b`plTvOI
	check = StopTP();
	GF_ASSERT( check == TP_OK );

	// [Nj
	PROC_FreeWork( proc );

	// q[vj
	sys_DeleteHeap( HEAPID_IMAGECLIP_DATA );
	sys_DeleteHeap( HEAPID_IMAGECLIP_DRAW );
	
	return PROC_RES_FINISH;
}





//-----------------------------------------------------------------------------
/**
 *					ReXgp
 * [JAMP_CONTEST]
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbN
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcContestInit( PROC* proc, int* seq )
{
	IMC_SYS_WORK*	imc_w;			// C[WNbv[N
	u32				check;			// p
	IMC_CONTEST_PROC_WORK*  p_imc_pr_w;		// O󂯎f[^


	// q[v쐬
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DATA, 0x20000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_IMAGECLIP_DRAW, 0x40000 );

	// C[WNbv[N쐬
	imc_w = PROC_AllocWork( proc, sizeof( IMC_SYS_WORK ), HEAPID_IMAGECLIP_DATA );
	memset( imc_w, 0, sizeof( IMC_SYS_WORK ) );

	// VuNHuN֐ݒ
	sys_VBlankFuncChange( imageClipVBlankFunc, imc_w );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~


	// Õf[^擾
	p_imc_pr_w = PROC_GetParentWork( proc );

	// ReXg擾
	imc_w->rank = p_imc_pr_w->rank;
	imc_w->mode = p_imc_pr_w->mode;
	imc_w->type = p_imc_pr_w->type;
	imc_w->theme = p_imc_pr_w->theme;
	imc_w->p_comm_data = p_imc_pr_w->p_comm_data;

	OS_Printf( "ReXge[}@%d N %d \n", p_imc_pr_w->theme, p_imc_pr_w->rank );

	// ^b`plI[gTvOJn
	InitTPSystem();
	check = InitTPNoBuff( 4 );
//	GF_ASSERT( check == TP_OK );
	if( check != TP_OK ){
		OS_Printf( "check != TP_OK\n" );
	}
//	while( InitTPNoBuff( 4 ) != TP_OK ){};


	// ACeobt@쐬
	IMC_ITEM_BUFF_Make( p_imc_pr_w->cp_imc_item, &imc_w->item_buff );

	
	// \ݒ
	initDrawSys( imc_w );

	// ŏAN^[Zbg\
	CLACT_DrawFlagSet( imc_w->drawSys.clactSet, 0 );

	// COMM_ICONݒ
	WirelessIconEasy();	

	// LN^}l[WɃLN^̈\
	CLACT_U_WmIcon_SetReserveAreaCharManager( NNS_G2D_VRAM_TYPE_2DMAIN, GX_OBJVRAMMODE_CHAR_1D_32K );
	CLACT_U_WmIcon_SetReserveAreaPlttManager( NNS_G2D_VRAM_TYPE_2DMAIN );

	// IuWFNgXge[u쐬
	IMC_OBJLIST_TblInit( &imc_w->objListTbl, IMC_OBJLIST_MAX, HEAPID_IMAGECLIP_DATA );
	
	// ANZTi[f[^쐬
	imc_w->acce = IMC_ACCE_ObjTblInit( IMC_SYS_ACCESSORIE_MAX, HEAPID_IMAGECLIP_DATA );

	// Õf[^ݒ
	imc_w->cp_config = p_imc_pr_w->cp_config;


	// E{bNXf[^쐬
	if( imc_w->p_comm_data->sio_flag == 0 ){
		imc_w->acce_max = getRightAcceMax_contest( p_imc_pr_w->rank );	
	}else{
		imc_w->acce_max = CON_IMAGE_ACCE_MAX_SIO;
	}
	initRightBox_Contest( imc_w, p_imc_pr_w->p_poke_para, imc_w->acce_max );
		
	
	// {bNXf[^쐬
	initLeftBox( imc_w );

	// t[BG\
	setFrameBG( imc_w, IMC_BG_FRAME_00 );
	
	// {^f[^쐬
	initBttn_Contest( imc_w );

	// TuEBhE
	initSubWin_Contest( imc_w, imc_w->acce_max, p_imc_pr_w->theme, p_imc_pr_w->p_comm_data, p_imc_pr_w->cp_config );

	// nhf[^
	IMC_ACCE_HAND_Init( &imc_w->hand, &imc_w->rbox, &imc_w->lbox, &imc_w->drawSys, &imc_w->subwin, FALSE );

	// ͂@@EBhEm
	imc_w->p_tsw = TOUCH_SW_AllocWork( HEAPID_IMAGECLIP_DATA );
	imc_w->p_tsw_bmp = GF_BGL_BmpWinAllocGet( HEAPID_IMAGECLIP_DATA, 1 );

	// Ԑݒ
	// 	
	imc_w->state = IMC_SYS_ACCE;

	// bZ[Wݒ
	ConTool_MsgPrintFlagSet( imc_w->p_comm_data->sio_flag );
	
	return PROC_RES_FINISH;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbNC
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcContestMain( PROC* proc, int* seq )
{
	IMC_SYS_WORK* imc_w = PROC_GetWork( proc );
	PROC_RESULT	ret = PROC_RES_CONTINUE;
	int count;

	switch( (*seq) ){
	case IMC_SYS_CON_SEQ_CON_SND_FADE:
		Snd_BgmFadeOut( BGM_VOL_CLIP, BGM_FADE_CLIP_TIME );
		(*seq) ++;
		break;
		
	case IMC_SYS_CON_SEQ_CON_SND_FADE_WAIT:
		if( Snd_FadeCheck() == 0 ){
			(*seq) ++;
		}
		break;
		
	case IMC_SYS_CON_SEQ_CON_TEXT_ON:
		initConTextSys( imc_w );

		// eÑANZT[hZbgɐݒ
		setContestWordSet( imc_w, 0, imc_w->acce_max );
		
		if( imc_w->mode != CONMODE_VISUAL_PRACTICE ){
			// {ԃeLXg
			imc_w->msg_idx = setContestTextBmpWin( imc_w, msg_con_v_du_b_01 );
		}else{
			// KeLXg
			imc_w->msg_idx = setContestTextBmpWin( imc_w, msg_con_v_prac_01 );
		}
		(*seq)++;
		break;
		
	case IMC_SYS_CON_SEQ_CON_TEXT_WAIT:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( imc_w->msg_idx ) == 0 ){
			endContestTextBmpWin( imc_w );
			(*seq)++;
		}
		break;


	case IMC_SYS_CON_SEQ_CON_TEXT_THEME_ON:
		// THEME\
		imc_w->msg_idx = setContestTextBmpWin( imc_w, msg_con_theme_01 + imc_w->theme );
		(*seq)++;
		break;
		
	case IMC_SYS_CON_SEQ_CON_TEXT_THEME_WAIT:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( imc_w->msg_idx ) == 0 ){
			endContestTextBmpWin( imc_w );
			(*seq)++;
		}
		break;

	case IMC_SYS_CON_SEQ_CON_TEXT_LAST_ON:
		// Ō̊JnIIƂt
		if( imc_w->mode != CONMODE_VISUAL_PRACTICE ){
			imc_w->msg_idx = setContestTextBmpWin( imc_w, msg_con_v_after_theme_02 );
		}else{
			imc_w->msg_idx = setContestTextBmpWin( imc_w, msg_con_v_after_theme_01 );
		}
		(*seq)++;
		break;
		
	case IMC_SYS_CON_SEQ_CON_TEXT_LAST_WAIT:
		//bZ[WI҂
		if( GF_MSG_PrintEndCheck( imc_w->msg_idx ) == 0 ){
			endContestTextBmpWin( imc_w );
			(*seq)++;
		}
		break;


	case IMC_SYS_CON_SEQ_CON_TEXT_LAST_DOUKI:
		// R}h]
		if( imc_w->p_comm_data->sio_flag ){
			CommTimingSyncStart( CONSIO_TIMING_CALL_IN_IMCPROC );
		}
		(*seq)++;
		break;

	case IMC_SYS_CON_SEQ_START_TIMING_WAIT:	// ҂
		// ʐMĂƂ
		// ҂
		if( imc_w->p_comm_data->sio_flag ){
			if( CommIsTimingSync( CONSIO_TIMING_CALL_IN_IMCPROC ) ){
				(*seq)++;
			}
		}else{
			(*seq)++;
		}
		break;

		
	case IMC_SYS_CON_SEQ_CON_TEXT_END:
		deleteConTextSys( imc_w );
		// 炷
		Snd_SePlay( IMC_SE_CON_START );
		(*seq)++;
		break;
	
	
	case IMC_SYS_CON_SEQ_FADE_IN:
		WIPE_SYS_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_HOLEIN,
				WIPE_TYPE_TUNNELIN,
				WIPE_FADE_BLACK,
				WIPE_DEF_DIV,WIPE_DEF_SYNC,
				HEAPID_IMAGECLIP_DATA );

//		WirelessIconEasyXY( 0, 176, FALSE );	
		(*seq) ++;
		break;
		
	case IMC_SYS_CON_SEQ_FADE_IN_WAIT:
		if( WIPE_SYS_EndCheck() ){

			// TEhf[^[h(ReXgC[WNbv)(BGM؂ւ)
			//Snd_DataSetByScene( SND_SCENE_SUB_IMAGE, 0, 0 );
			Snd_DataSetByScene( SND_SCENE_CON_IMAGE, SEQ_CO_DRESS, 0 );

			(*seq) ++;
		}
		break;

	//-------------------------------------
	//	
	//	C
	//	
	//=====================================
	case IMC_SYS_CON_SEQ_MAIN:

		// I{^ꂽƂ̏
		if(imc_w->state == IMC_SYS_END_CHECK_REQ){
			// eɏIR[
			CommContestSendImcForceEnd( imc_w->p_comm_data, TRUE );

			// ʐMĂƂ͏ɑ҂Ă̕o
			if( imc_w->p_comm_data->sio_flag ){
				IMC_SUBWIN_SetBmpWin( &imc_w->subwin, ARC_MSG, NARC_msg_imageclip_dat, msg_con_caution_01 );
			}
			
			(*seq)  = IMC_SYS_CON_SEQ_EX_END_WAIT;
			break;
		}

#ifdef IMC_DEBUG
		{
			static BOOL COUNTER_END_FLG = TRUE;
			if( sys.trg & PAD_BUTTON_L ){
				COUNTER_END_FLG ^= 1;
			}
			
			// JE^[OɂȂI
			count = IMC_SUBWIN_GetCounterNowNum( &imc_w->subwin );
			if(0 == count){
				(*seq)  = IMC_SYS_CON_SEQ_END_CHECK_WAIT;
				// 炷
				Snd_SePlay( IMC_SE_CON_FINISH );
			}

			// nh
			IMC_HAND_Main( &imc_w->hand );

			// E{bNX̃ANZTݒ
			setAcceNumSubWin( imc_w );

			// FALSEȂIȂ
			if( COUNTER_END_FLG == TRUE ){
				// TuEBhEC
				IMC_SUBWIN_Main( &imc_w->subwin );
			}
			
			// {^
			mainBttn( imc_w );

		}
#else
		// JE^[OɂȂI
		count = IMC_SUBWIN_GetCounterNowNum( &imc_w->subwin );
		if(0 == count){
			(*seq)  = IMC_SYS_CON_SEQ_END_CHECK_WAIT;
			// 炷
			Snd_SePlay( IMC_SE_CON_FINISH );
		}

		// nh
		IMC_HAND_Main( &imc_w->hand );

		// E{bNX̃ANZTݒ
		setAcceNumSubWin( imc_w );

		// TuEBhEC
		IMC_SUBWIN_Main( &imc_w->subwin );
		
		// {^
		mainBttn( imc_w );
#endif
		break;

	case IMC_SYS_CON_SEQ_EX_END_WAIT:	// IĂ̋I҂
		// JE^[OɂȂI
		count = IMC_SUBWIN_GetCounterNowNum( &imc_w->subwin );
		if(0 == count){
			(*seq)  = IMC_SYS_CON_SEQ_END_CHECK_WAIT;
			// 炷
			Snd_SePlay( IMC_SE_CON_FINISH );
		}

		// E{bNX̃ANZTݒ
		setAcceNumSubWin( imc_w );

		// TuEBhEC
		IMC_SUBWIN_Main( &imc_w->subwin );

		// I`FbN
		Imc_OyaExEndCheck( imc_w );
		
		break;

	case IMC_SYS_CON_SEQ_END_CHECK_WAIT:
		// TuEBhEC
		IMC_SUBWIN_Main( &imc_w->subwin );
		// ƃJE^[̴̪ĂII
		if( IMC_SUBWIN_GetCounterEffectEnd( &imc_w->subwin ) ){
			(*seq) = IMC_SYS_CON_SEQ_FADE_OUT;
		}
		break;
		
	case IMC_SYS_CON_SEQ_FADE_OUT:

		// Î҂
		if( Snd_SePlayCheck( IMC_SE_CON_FINISH ) == TRUE ){
			break;
		}
		
		WIPE_SYS_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_DOOROUT,
				WIPE_TYPE_DOOROUT,
				WIPE_FADE_BLACK,
				WIPE_DEF_DIV,WIPE_DEF_SYNC,
				HEAPID_IMAGECLIP_DATA );

		Snd_SePlay( IMC_SE_CON_DOOR_CLOSE );
		(*seq) ++;
		break;

	case IMC_SYS_CON_SEQ_FADE_OUT_WAIT:
		if( WIPE_SYS_EndCheck() ){
			(*seq) = 0;
			imc_w->state = IMC_SYS_END;
			ret = PROC_RES_FINISH;

			// EBhȄ
			GX_SetVisibleWnd( GX_WNDMASK_NONE );
			
			// E{bNX̃f[^IW܂œĂ
			IMC_RBOX_ListMove( &imc_w->rbox, -(IMC_SEENFADE_MOVE_ADD_X*IMC_SEENFADE_MOVE_COUNT), (IMC_SEENFADE_MOVE_ADD_Y*IMC_SEENFADE_MOVE_COUNT) );
		}
		break;
	}

	///////////////////////////////////////////////
	//
	//	͋ʏ
	//
	//////////////////////////////////////////////
	// `揈
	mainDrawSys( imc_w );
	

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbNI
 *
 *	@param	proc		vbNf[^	
 *	@param	seq			V[PX
 *
 *	@return	
 *
 *	typedef enum {
 *		PROC_RES_CONTINUE = 0,		///<p
 *		PROC_RES_FINISH,			///<I
 *	}PROC_RESULT;
 *
 *
 */
//-----------------------------------------------------------------------------
PROC_RESULT IMC_ProcContestEnd( PROC* proc, int* seq )
{
	IMC_SYS_WORK* imc_w = PROC_GetWork( proc );
	u32	check;	// p
	IMC_CONTEST_PROC_WORK* p_pr_w = PROC_GetParentWork( proc );	// f[^Z[u

	OS_Printf( "ReXge[}@%d N %d \n", imc_w->theme, imc_w->rank );

	// f[^Z[u
	dataSave_Contest( p_pr_w->p_imc_one_data, &imc_w->rbox, imc_w->rank, p_pr_w->cp_tr );	

	// nCCCGEBhEj
	TOUCH_SW_FreeWork( imc_w->p_tsw );	
	GF_BGL_BmpWinFree( imc_w->p_tsw_bmp, 1 );
	
	// TuEBhEj
	deleteSubWin( imc_w );
	
	// nhj
	IMC_ACCE_HAND_Delete( &imc_w->hand );

	// {^j
	deleteBttn( imc_w );
	
	// t[BGj
	delFrameBG( imc_w );
	
	// E{bNXj
	deleteRightBox( imc_w );
	
	// {bNXj
	deleteLeftBox( imc_w );
	
	// ANZTi[f[^j
	IMC_ACCE_ObjTblDelete( imc_w->acce );
	imc_w->acce = NULL;
	
	// IuWFNgXge[uj
	IMC_OBJLIST_TblDelete( &imc_w->objListTbl );
	
	deleteDrawSys( imc_w );
	
	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrStop();	//HBlank荞ݒ~

	// ^b`plTvOI
	check = StopTP();
	GF_ASSERT( check == TP_OK );

	// [Nj
	PROC_FreeWork( proc );

	// q[vj
	sys_DeleteHeap( HEAPID_IMAGECLIP_DATA );
	sys_DeleteHeap( HEAPID_IMAGECLIP_DRAW );

	// bZ[Wݒ
	ConTool_MsgPrintFlagReset();

	WirelessIconEasyEnd();

	
	return PROC_RES_FINISH;
}




//-----------------------------------------------------------------------------
/**
*		vCx[g֐
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXe
 *
 *	@param	imc_w	VXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initDrawSys( IMC_SYS_WORK* imc_w )
{
	IMC_DRAW_LOADRES_DATA loadData;	// 摜f[^ǂݍ݃f[^

	// ʃf[^ݒ
	IMC_DRAW_SetUp();

	// `VXe쐬
	IMC_DRAW_InitSys( &imc_w->drawSys );
	
	// `f[^쐬
	IMC_DRAW_MakeLoadSWSP_samp( &imc_w->drawSys, &loadData );

	// `f[^Vram]
	IMC_DRAW_LoadResource( &imc_w->drawSys, &loadData );

	// `f[^j
	IMC_DRAW_DestLoadSWSP( &loadData );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXeC
 *
 *	@param	imc_w	VXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void mainDrawSys( IMC_SYS_WORK* imc_w )
{
	IMC_DRAW_DrawSys( &imc_w->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`VXej
 *
 *	@param	imc_w	VXe[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteDrawSys( IMC_SYS_WORK* imc_w )
{
	// `f[^j
	IMC_DRAW_DeleteResource( &imc_w->drawSys );

	// `VXej
	IMC_DRAW_DeleteSys( &imc_w->drawSys );

	// `ʐݒj
	IMC_DRAW_PutBack();
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^쐬
 *
 *	@param	imc_w	C[WNbvVXef[^
 *	@param	pp		|Pp[^
 *	@param	acce_max	ANZTo^ő吔
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initRightBox( IMC_SYS_WORK* imc_w, POKEMON_PARAM* pp, int acce_max )
{
	IMC_RIGHT_BOX_INIT	rbox_init;	// E{bNXf[^

	// E{bNXf[^쐬
	// `f[^
	rbox_init.SWSP_drawSys		= imc_w->drawSys.SWSP_drawSys;
	rbox_init.SWSP_charData		= imc_w->drawSys.SWSP_charData;
	rbox_init.SWSP_plttData		= imc_w->drawSys.SWSP_plttData;
	rbox_init.accePlttOfsTbl	= imc_w->drawSys.accePlttOfsTbl;
	rbox_init.SSM_drawSys		= imc_w->drawSys.SSM_drawSys;
	rbox_init.BG_Ini			= imc_w->drawSys.BG_Ini;
	rbox_init.acce_count_max	= acce_max;

	rbox_init.acce		= imc_w->acce;			// ANZTf[^
	rbox_init.objListTbl= &imc_w->objListTbl;	// IuWFNgXge[u
	IMC_RBOX_InitSys( &imc_w->rbox, &rbox_init );
	
	// |Po^
	{
		SOFT_SPRITE_ARC	arc;
		IMC_RBOX_AddPoke( &imc_w->rbox, pp, &arc, HEAPID_IMAGECLIP_DRAW );

		// |PLN^f[^o^
		IMC_POKE_CharSet( &imc_w->drawSys, &arc );
	}
/*
	// E{bNXɔzuf[^쐬
	{
		int i;
		for(i=0;i<IMC_ACCE_MAX; i++){
			int x,y;
			x = IMC_RBOX_AREA_X;
			y = IMC_RBOX_AREA_Y;
			
			IMC_RBOX_AddAccessorie( &imc_w->rbox, i, 
					x + (gf_mtRand() % (IMC_RBOX_AREA_WIDTH / 2)),
					y + (gf_mtRand() % (IMC_RBOX_AREA_HEIGHT / 2)) );
		}
	}//*/
	IMC_RBOX_SetObjPriority( &imc_w->rbox );

	// BG\
	IMC_RBOX_BGSet( &imc_w->rbox, IMC_BG_RIGHT_00, HEAPID_IMAGECLIP_DRAW );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgp@E{bNX
 *
 *	@param	imc_w
 *	@param	pp
 *	@param	acce_max 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void initRightBox_Contest( IMC_SYS_WORK* imc_w, POKEMON_PARAM* pp, int acce_max )
{
	int size_x, size_y;
	int in_size_x, in_size_y;
	
	initRightBox( imc_w, pp, acce_max );

	// |PTCY擾
	IMC_POKE_SizeGet( &imc_w->rbox.boxDraw.poke, &size_x, &size_y );
	IMC_POKE_InSizeGet( &imc_w->rbox.boxDraw.poke, &in_size_x, &in_size_y );

	// ReXgpWݒ
	IMC_POKE_MatrixSet( &imc_w->rbox.boxDraw.poke, IMC_POKE_INIT_X, (IMC_RBOX_AREA_Y + IMC_RBOX_AREA_HEIGHT) - ((size_y/2) - in_size_y) + IMC_POKE_MAT_CONTEST_Y_OFS );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	E{bNXf[^j
 *
 *	@param	imc_w	C[WNbvVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteRightBox( IMC_SYS_WORK* imc_w )
{
	// BGN[
	IMC_RBOX_BGClean( &imc_w->rbox );
	
	// E{bNXzuf[^j
	IMC_RBOX_DeleteAccessorieAll( &imc_w->rbox );
	
	// E{bNXf[^j
	IMC_RBOX_DeleteSys( &imc_w->rbox );
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXf[^쐬
 *
 *	@param	imc_w	C[WNbvVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initLeftBox( IMC_SYS_WORK* imc_w )
{
	IMC_LEFT_BOX_INIT	lbox_init;	// E{bNXf[^

	// {bNXf[^쐬
	// `f[^
	lbox_init.SWSP_drawSys		= imc_w->drawSys.SWSP_drawSys;
	lbox_init.SWSP_charData		= imc_w->drawSys.SWSP_charData;
	lbox_init.SWSP_plttData		= imc_w->drawSys.SWSP_plttData;
	lbox_init.accePlttOfsTbl	= imc_w->drawSys.accePlttOfsTbl;
	lbox_init.BG_Ini			= imc_w->drawSys.BG_Ini;
	lbox_init.p_item_buff		= &imc_w->item_buff;
	lbox_init.acce			= imc_w->acce;			// ANZTf[^
	lbox_init.objListTbl	= &imc_w->objListTbl;	// IuWFNgXge[u
	lbox_init.accelist_num	= IMC_LBOX_ACCE_NEAD_LIST_NUM;	// Xg
	lbox_init.bglist_num	= IMC_LBOX_BG_NEAD_LIST_NUM;	// Xg
	lbox_init.sndlist_num	= IMC_LBOX_SND_NEAD_LIST_NUM;	// Xg
	IMC_LBOX_InitSys( &imc_w->lbox, &lbox_init );

	// Jg擪_~[f[^쐬
	IMC_LBOX_SetCurrentAccessorie( 
			&imc_w->lbox, 
			IMC_OBJLIST_ACCE,
			0 );


	// {bNXɔzuf[^쐬
	{
		int i, j;
		int add_num;

		for(i=0;i<IMC_ACCE_MAX; i++){
			add_num = IMC_ITEM_BUFF_AcceGetNum( &imc_w->item_buff, i );
			for( j=0; j<add_num; j++ ){
				// {bNXANZTzu
				IMC_LBOX_AddAccessorie( &imc_w->lbox, IMC_OBJLIST_ACCE, i );
			}
		}
		// BGTlC쐬
		for( i=0; i<IMC_BG_RIGHT_MAX; i++ ){

			add_num = IMC_ITEM_BUFF_TurnBgNoGet( &imc_w->item_buff, i );
			if( add_num < IMC_BG_RIGHT_MAX ){
				// {bNXANZTzu
				IMC_LBOX_AddAccessorie( &imc_w->lbox, IMC_OBJLIST_BG, add_num );
			}
		}

		// \D揇ʐݒ
		IMC_LBOX_SetAccessoriePriority( &imc_w->lbox );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{bNXf[^쐬
 *
 *	@param	imc_w	C[WNbvVXef[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteLeftBox( IMC_SYS_WORK* imc_w )
{
	// BGN[
	IMC_LBOX_BGClean( &imc_w->lbox );
	
	// E{bNXzuf[^j
	IMC_LBOX_DeleteAccessorieAll( &imc_w->lbox );
	
	// E{bNXf[^j
	IMC_LBOX_DeleteSys( &imc_w->lbox );
}

//----------------------------------------------------------------------------
/**
 *	@brief	{bNXBG̃ZbgAbv
 *
 *	@param	imc_w	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setLeftBoxBg( IMC_SYS_WORK* imc_w )
{
	// \D揇ʐݒ
	G2_SetBG0Priority( 1 );
	G2_SetBG1Priority( 0 );//*/
	G2_SetBG2Priority( 2 );
	G2_SetBG3Priority( 3 );

	// XN[Wݒ
	// Ȃł܂@łHH
	GF_BGL_ScrollSet( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M, GF_BGL_SCROLL_Y_SET, -16 );
	
	// wiio
	IMC_LBOX_BGSet( &imc_w->lbox, 0 );
	IMC_LBOX_BGChange( &imc_w->lbox, 0, IMC_LBOX_FADE_Y, 0, NULL );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	VuN֐
 *
 *	@param	void* work 
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void imageClipVBlankFunc( void* work )
{
	IMC_SYS_WORK* sys = work;

	// `֌WVuN֐
	IMC_DRAW_VBlank( &sys->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	t[BG\
 *
 *	@param	imc_w	C[WNbv[N
 *	@param	no		BGno
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setFrameBG( IMC_SYS_WORK* imc_w, int no )
{
	IMC_BG_ADD add;
	
	// o^f[^ݒ
	add.bg_ini		= imc_w->drawSys.BG_Ini;
	add.arc_file	= ARC_IMAGECLIP_GRA;
	add.char_arc	= IMC_BG_FRAME_CG_ARC_GET(no);
	add.pltt_arc	= IMC_BG_LEFT_FRAME_CL;
	add.scrn_arc	= IMC_BG_FRAME_SC_ARC_GET(no);
	add.x			= 0;
	add.y			= 0;
	add.frame		= GF_BGL_FRAME1_M;
	add.pltt_num	= 1;
	add.pltt_offs	= 2;
	add.char_offs	= 0;
	add.heap		= HEAPID_IMAGECLIP_DRAW;

	IMC_BG_MakaObj( &imc_w->frame_bg, &add );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	t[BG\
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delFrameBG( IMC_SYS_WORK* imc_w )
{
	IMC_BG_DeleteObj( &imc_w->frame_bg );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^f[^쐬
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBttn( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Init( &imc_w->bttn, &imc_w->drawSys );

	// pbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_RET, retBttn, imc_w, IMC_BTTN_PUSH_F );

	// pbgύX߂֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_RETB, retbBttn, imc_w, IMC_BTTN_PUSH_F );
	
	// ANZTpbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_ACE, acceBttn, imc_w, IMC_BTTN_PUSH_F );
	// ANZTpbgύX{^IԂɂ
	
	
	// BGpbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_BG, bgBttn, imc_w, IMC_BTTN_PUSH_F );
	
	// I{^֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_END, endBttn, imc_w, IMC_BTTN_PUSH_F );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^f[^쐬		ReXgp
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBttn_Contest( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Init( &imc_w->bttn, &imc_w->drawSys );

	// pbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_RET, retBttn, imc_w, IMC_BTTN_PUSH_F );

	// pbgύX߂֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_RETB, retbBttn, imc_w, IMC_BTTN_PUSH_F );
	
	// ANZTpbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_ACE, acceBttn, imc_w, IMC_BTTN_PUSH_F );
	// ANZTpbgύX{^IԂɂ
	
	
	// BGpbgύX֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_BG, bgBttn, imc_w, IMC_BTTN_PUSH_F );

	// I{^֐ݒ
	IMC_IMCBTTN_FuncSet( &imc_w->bttn, IMC_BTTN_END, endBttn, imc_w, IMC_BTTN_PUSH_F );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^f[^j
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteBttn( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Delete( &imc_w->bttn, &imc_w->drawSys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	{^C֐
 *
 *	@param	imc_w	C[WNbv[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void mainBttn( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Main( &imc_w->bttn );
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^Aj󋵂̃Zbg
 *
 *	@param	imc_w 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void resetBttn( IMC_SYS_WORK* imc_w )
{
	IMC_IMCBTTN_Reset( &imc_w->bttn );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvI֐
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;

	// Iėǂԉ`FbN
	if( IMC_LBOX_ENDCheck( &imc_w->lbox ) == FALSE ){
		return ;
	}
	
	// Ԑݒ
	// 	INGXg
	imc_w->state = IMC_SYS_END_CHECK_REQ;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgύX
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void retBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int mode;
/*	int list_num;
	int list_max;

	mode		= IMC_LBOX_GetMode( &imc_w->lbox );
	list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, mode );
	list_max	= IMC_LBOX_GetDummyTblNum( &imc_w->lbox, mode );
	
	list_num = (list_num + 1) % list_max;

	// pbg̒gύX
	IMC_LBOX_ChangeCurrentAccessorie( 
			&imc_w->lbox, mode, list_num );//*/
	mode		= IMC_LBOX_GetMode( &imc_w->lbox );
	IMC_LBOX_AddCurrentAccessorie(
			&imc_w->lbox, mode, IMC_LBOX_ADD_ONE );
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbg߂
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void retbBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int mode;
/*	int list_num;
	int list_max;

	mode		= IMC_LBOX_GetMode( &imc_w->lbox );
	list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, mode );
	list_max	= IMC_LBOX_GetDummyTblNum( &imc_w->lbox, mode );
	
	list_num--;
	if( list_num < 0 ){
		list_num += list_max;
	}

	// pbg̒gύX
	IMC_LBOX_ChangeCurrentAccessorie( 
			&imc_w->lbox, mode, list_num );
//*/

	mode		= IMC_LBOX_GetMode( &imc_w->lbox );
	IMC_LBOX_AddCurrentAccessorie(
			&imc_w->lbox, mode, IMC_LBOX_SUB_ONE );

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ANZTpbgɕύX
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void	acceBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int list_num;
	int mode;

	if( imc_w->state != IMC_SYS_ACCE ){
		list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, IMC_OBJLIST_ACCE );
		

		// pbg̒gύX
		IMC_LBOX_SetCurrentAccessorie( 
				&imc_w->lbox, IMC_OBJLIST_ACCE, list_num );

		// Ԑݒ
		imc_w->state = IMC_SYS_ACCE;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGpbgɕύX
 *
 *	@param	bttn	{^\
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void	bgBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;
	int list_num;
	int mode;

	if( imc_w->state != IMC_SYS_BG ){

		list_num	= IMC_LBOX_GetCurrentNo( &imc_w->lbox, IMC_OBJLIST_BG );
		
		// pbg̒gύX
		IMC_LBOX_SetCurrentAccessorie( 
				&imc_w->lbox, IMC_OBJLIST_BG, list_num );

		// Ԑݒ
		imc_w->state = IMC_SYS_BG;

	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuEBhE
 *
 *	@param	imc_w		TuEBhE
 *	@param	cp_config	RtBOf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initSubWin( IMC_SYS_WORK* imc_w, const CONFIG* cp_config )
{
	IMC_SUBWIN_INIT	init;

	memset( &init, 0, sizeof(IMC_SUBWIN_INIT) );
	init.bg_ini		= imc_w->drawSys.BG_Ini;
	init.clactSet	= imc_w->drawSys.clactSet;
	init.p_resMan	= imc_w->drawSys.resMan;
	init.acce_max	= IMC_RBOX_ACCE_TELEVISION_MAX;	
	init.cp_config	= cp_config;

	
	IMC_SUBWIN_Init( &imc_w->subwin, &init, IMC_SUBWIN_DEFAULT_INIT );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpTuEBhE
 *
 *	@param	imc_w		[N
 *	@param	acce_num	ANZTő吔
 *	@param	thema		e[}
 *	@param	p_comm_data	ʐMf[^
 *	@param	cp_config	RtBOf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void initSubWin_Contest( IMC_SYS_WORK* imc_w, int acce_num, int thema, CON_IMC_LOCAL* p_comm_data, const CONFIG* cp_config )
{
	IMC_SUBWIN_INIT	init;
	BOOL oya;
	
	init.bg_ini		= imc_w->drawSys.BG_Ini;
	init.clactSet	= imc_w->drawSys.clactSet;
	init.p_resMan	= imc_w->drawSys.resMan;
	init.acce_max	= acce_num;	
	init.rank_msgid = NARC_msg_imageclip_dat;
	init.rank_strid = imgclip_theme_01 + thema;
	init.count_max	= IMC_COUNT_MAX;
	init.p_comm_data = p_comm_data;
	init.cp_config	= cp_config;

	IMC_SUBWIN_Init( &imc_w->subwin, &init, IMC_SUBWIN_CONTEST_INIT );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	TuEBhEj
 *
 *	@param	imc_w	TuEBhE
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void deleteSubWin( IMC_SYS_WORK* imc_w )
{
	IMC_SUBWIN_Delete( &imc_w->subwin );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	IʂփtF[hCJn
 *
 *	@param	imc_w	VXe[N	
 *	@param	end		ImtO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeIn( IMC_SYS_WORK* imc_w, BOOL* end )
{
	TCB_PTR tcb;
	IMC_SYS_FADE_WORK* fade_w;

	// ^XNo^
	tcb = PMDS_taskAdd( endSeenFadeInTask, sizeof( IMC_SYS_FADE_WORK ), 10, HEAPID_IMAGECLIP_DATA );

	// [NɃf[^ݒ
	fade_w = TCB_GetWork( tcb );
	fade_w->sys_w	= imc_w;
	fade_w->end		= end;
	fade_w->work	= 0;
	fade_w->seq		= 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	IʃtF[h^XN
 *
 *	@param	tcb		^XNIuWF
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeInTask( TCB_PTR tcb, void* work )
{
	IMC_SYS_FADE_WORK* fade_w = work;
	BOOL	check;
	
	switch( fade_w->seq ){
	case IMC_SEENFADEIN_ACCE_FADEOUT:
		check = IMC_LBOX_ChangeCurrentAccessorie( 
				&fade_w->sys_w->lbox,
				IMC_LBOX_FADELIST_MODE,
				0);
		GF_ASSERT( check );	// 

		
		fade_w->seq++;
		break;
		
	case IMC_SEENFADEIN_ACCE_FADEWAIT:
		check = IMC_LBOX_ENDCheck( &fade_w->sys_w->lbox );
		if( check ){

			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEIN_BRIGHTNESS_OUT:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_BLACK,
				BRIGHTNESS_NORMAL,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;


	case IMC_SEENFADEIN_BRIGHTNESS_WAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEIN_BUTTON_OLDOUT:
		IMC_IMCBTTN_Move( &fade_w->sys_w->bttn, 0, IMC_SEENFADE_BTTNMOVE_ADD_Y );
		fade_w->work ++;
		if( fade_w->work >= IMC_SEENFADE_BTTNMOVE_COUNT ){
			fade_w->work = 0;
			fade_w->seq ++;
		}
		break;

	
	case IMC_SEENFADEIN_MOVE_BG:
		if( endSeenFadeMoveBg( fade_w, -IMC_SEENFADE_MOVE_ADD_X, IMC_SEENFADE_MOVE_ADD_Y, IMC_SEENFADE_MOVE_COUNT ) ){
			fade_w->work = 0;
			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEIN_MOVE_BGINIT:
		// BG 1ʂBGύX
		setFrameBG( fade_w->sys_w, IMC_BG_FRAME_01 );
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME1_M, GF_BGL_SCROLL_Y_SET, 0 );

		// nCCCGEBhEZbgAbv
		initTouchSWSys( fade_w->sys_w );
		fade_w->seq++;
		break;

		
	
	case IMC_SEENFADEIN_BRIGHTNESS_IN:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_NORMAL,
				BRIGHTNESS_BLACK,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;


	case IMC_SEENFADEIN_BRIGHTNESS_INWAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;
		
	case IMC_SEENFADEIN_END:
		*fade_w->end = TRUE;
		PMDS_taskDel( tcb );
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv쐬ʃtF[hJn
 *
 *	@param	imc_w	VXe[N
 *	@param	end		ImtO
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeOut( IMC_SYS_WORK* imc_w, BOOL* end )
{
	TCB_PTR tcb;
	IMC_SYS_FADE_WORK* fade_w;

	// ^XNo^
	tcb = PMDS_taskAdd( endSeenFadeOutTask, sizeof( IMC_SYS_FADE_WORK ), 10, HEAPID_IMAGECLIP_DATA );

	// [NɃf[^ݒ
	fade_w = TCB_GetWork( tcb );
	fade_w->sys_w	= imc_w;
	fade_w->end		= end;
	fade_w->work	= 0;
	fade_w->seq		= 0;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbv쐬ʃtF[h^XN
 *
 *	@param	tcb		^XNIuWF
 *	@param	work	[N
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void endSeenFadeOutTask( TCB_PTR tcb, void* work )
{
	IMC_SYS_FADE_WORK* fade_w = work;
	BOOL	check;
	
	switch( fade_w->seq ){

	case IMC_SEENFADEOUT_BRIGHTNESS_OUT:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_BLACK,
				BRIGHTNESS_NORMAL,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;
			
	case IMC_SEENFADEOUT_BRIGHTNESS_OUTWAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;


	case IMC_SEENFADEOUT_MOVE_BG_SET:
		// nCCCGEBhEj
		deleteTouchSWSys( fade_w->sys_w );
		// {bNXEBhEݒ
		setLeftBoxBg( fade_w->sys_w );
		// {^̃AjZbg
		resetBttn( fade_w->sys_w );
		
		setFrameBG( fade_w->sys_w, IMC_BG_FRAME_00 );
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME1_M, GF_BGL_SCROLL_Y_SET, -IMC_SEENFADE_BG_MOVE_Y );
		fade_w->seq++;
		break;


	case IMC_SEENFADEOUT_MOVE_BG:
		if( endSeenFadeMoveBg( fade_w, IMC_SEENFADE_MOVE_ADD_X, -IMC_SEENFADE_MOVE_ADD_Y, IMC_SEENFADE_MOVE_COUNT ) ){
			fade_w->work = 0;
			fade_w->seq++;
		}
		break;


	case IMC_SEENFADEOUT_BUTTON_NEWIN:
		IMC_IMCBTTN_Move( &fade_w->sys_w->bttn, 0, -IMC_SEENFADE_BTTNMOVE_ADD_Y );
		fade_w->work ++;
		if( fade_w->work >= IMC_SEENFADE_BTTNMOVE_COUNT ){
			fade_w->work = 0;
			fade_w->seq ++;
		}
		break;

	case IMC_SEENFADEOUT_BRIGHTNESS_IN:
		ChangeBrightnessRequest(
				IMC_SEENFADE_BRIGHTNESS_FADE_SYNC,
				BRIGHTNESS_NORMAL,
				BRIGHTNESS_BLACK,
//				PLANEMASK_BG1 | PLANEMASK_BG3 | PLANEMASK_OBJ,
				PLANEMASK_BG1 | PLANEMASK_BG3,
				MASK_MAIN_DISPLAY );
		fade_w->seq++;
		break;

	case IMC_SEENFADEOUT_BRIGHTNESS_WAIT:
		check = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
		if( check ){
			fade_w->seq++;
		}
		break;
		
	case IMC_SEENFADEOUT_ACCE_FADEIN:
		check = IMC_LBOX_ChangeCurrentAccessorie( 
				&fade_w->sys_w->lbox,
				IMC_OBJLIST_ACCE,
				0);
		GF_ASSERT( check );	// 

		fade_w->seq++;
		break;
		
	case IMC_SEENFADEOUT_ACCE_FADEWAIT:
		check = IMC_LBOX_ENDCheck( &fade_w->sys_w->lbox );
		if( check ){

			fade_w->seq++;
		}
		break;

	case IMC_SEENFADEOUT_END:
		*fade_w->end = TRUE;
		PMDS_taskDel( tcb );
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbNV[PX@I{^
 *
 *	@param	bttn		{^\
 *	@param	work		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endCkEndBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;

	// Ԑݒ
	// 	INGXg
	imc_w->state = IMC_SYS_END_REQ;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbNV[PX@CANCEL{^
 *
 *	@param	bttn		{^\
 *	@param	work		[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void endCkCancelBttn( IMC_BUTTON* bttn, void* work )
{
	IMC_SYS_WORK* imc_w = work;

	// Ԑݒ
	// 	INGXg
	imc_w->state = IMC_SYS_END_CANCEL_REQ;
}

//----------------------------------------------------------------------------
/**
 *	@brief	f[^Z[u
 *
 *	@param	save_data	Z[uf[^
 *	@param	rbox		E{bNXf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void dataSave( IMC_TELEVISION_SAVEDATA* save_data, IMC_RIGHT_BOX* rbox, const MYSTATUS* cp_tr )
{
	IMC_OBJLIST* p_work;
	int count;
	STRBUF* p_str;
	int sex;

	ImcSaveData_ClaenTelevisionData( save_data );		// ҏW郏[N
	
	// |Pf[^ۑ
	ImcSaveData_SetTelevisionPokeData( save_data, 
			rbox->boxDraw.poke.poke_para,
			&rbox->boxDraw.poke );

	// g[i[f[^ݒ
	if( cp_tr ){
		p_str = MyStatus_CreateNameString( cp_tr, HEAPID_IMAGECLIP_DATA );
		sex = MyStatus_GetMySex( cp_tr );
		ImcSaveData_SetTelevisionTrData( save_data, p_str, sex );
		STRBUF_Delete( p_str );
	}

	// ANZTf[^ۑ
	count = 0;
	p_work = rbox->boxData.dummy_poke.next;
	while( p_work != &rbox->boxData.dummy_poke ){
		// ANZTf[^Ȃۑ	
		if( p_work->flag == IMC_OBJLIST_ACCE ){
			ImcSaveData_SetTelevisionAcceData( save_data, p_work->obj_data, count );
			count ++;
		}
		p_work = p_work->next;
	}
	p_work = rbox->boxData.dummy.next;
	while( p_work != &rbox->boxData.dummy ){
		// ANZTf[^Ȃۑ	
		if( p_work->flag == IMC_OBJLIST_ACCE ){
			ImcSaveData_SetTelevisionAcceData( save_data, p_work->obj_data, count );
			count ++;
		}
		p_work = p_work->next;
	}

	// BGID
	ImcSaveData_SetTelevisionBgId( save_data, rbox->boxDraw.bg_no );	

	// Z[u
	ImcSaveData_SetComplateFlagTelevisionData( save_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgpZ[uf[^ۑ
 *
 *	@param	save_data	ReXgZ[uf[^ۑ
 *	@param	rbox		E{bNXf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void dataSave_Contest( IMC_CONTEST_SAVEDATA* save_data, IMC_RIGHT_BOX* rbox, int rank, const MYSTATUS* cp_tr )
{
	int count;
	int i;
	IMC_POKE_ON_ACCESYS* p_sys;
	IMC_OBJLIST* p_obj;
	STRBUF* p_str;
	int sex;

	// VXe
	p_sys = sys_AllocMemory( HEAPID_IMAGECLIP_DATA, sizeof(IMC_POKE_ON_ACCESYS) );
	initPokeOnAcceCheckSys( p_sys );
	
	// |Pf[^ۑ
	ImcSaveData_SetContestPokeData( save_data, 
			rbox->boxDraw.poke.poke_para,
			&rbox->boxDraw.poke );


	// g[i[f[^ݒ
	if( cp_tr ){
		p_str = MyStatus_CreateNameString( cp_tr, HEAPID_IMAGECLIP_DATA );
		sex = MyStatus_GetMySex( cp_tr );
		ImcSaveData_SetContestTrData( save_data, p_str, sex );
		STRBUF_Delete( p_str );
	}

	// ܂SANZTf[^[Nɐݒ肷
	setPokeOnAcceCheckObjList( p_sys, &rbox->boxData.dummy_poke, IMC_POKEON_ACCE_ON );
	setPokeOnAcceCheckObjList( p_sys, &rbox->boxData.dummy, IMC_POKEON_ACCE_NONE );

	// |PɂĂANZT`FbN
	mainPokeOnAcceCheckSys( p_sys );

	// ANZTf[^ۑ
	count = 0;
	for( i=0; i<IMC_POKEON_ACCE_CHECK_OBJNUM; i++ ){

		if( getPokeOnAcceCheckObjOnPoke( p_sys, i ) == TRUE ){
			p_obj = getPokeOnAcceCheckObjList( p_sys, i );
			ImcSaveData_SetContestAcceData( save_data, p_obj->obj_data, count );
			count ++;
		}
	}

	// BGID
	ImcSaveData_SetContestBgId( save_data, rbox->boxDraw.bg_no );	
	// N̕ۑ
	ImcSaveData_SetContestRank( save_data, rank );

	// Z[u
	ImcSaveData_SetComplateFlagContestData( save_data );


	sys_FreeMemoryEz( p_sys );
}

//----------------------------------------------------------------------------
/**
 *	@brief	V[tF[h@BGƃ|PANZTړ֐
 *
 *	@param	fade_w				tF[h[N
 *	@param	move_x				XύXl			(|PIuWFNgɂ킹)
 *	@param	move_y				YύXl			(|PIuWFNgɂ킹)
 *	@param	move_count_num		ől
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	s
 */
//-----------------------------------------------------------------------------
static BOOL endSeenFadeMoveBg( IMC_SYS_FADE_WORK* fade_w, int move_x, int move_y, int move_count_num )
{
	// 3D̃IuWFNg͕`^C~ỎeŁAf1VNxȂĂ܂̂ŁAPɕύX
	if( fade_w->work < IMC_SEENFADE_MOVE_COUNT ){
		IMC_RBOX_ListMove( &fade_w->sys_w->rbox, move_x, move_y );
	}

	// QDIuWFNg͂Px^C~OŕύX
	if( fade_w->work >= 1 ){
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME2_M, GF_BGL_SCROLL_X_DEC, move_x );
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME1_M, GF_BGL_SCROLL_X_DEC, move_x );
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME2_M, GF_BGL_SCROLL_Y_DEC, move_y );
		GF_BGL_ScrollReq( fade_w->sys_w->drawSys.BG_Ini, GF_BGL_FRAME1_M, GF_BGL_SCROLL_Y_DEC, move_y );
	}
	
	fade_w->work++;
	if( fade_w->work > move_count_num ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXg@Jn
 *
 *	@param	imc_w	[N
 */
//-----------------------------------------------------------------------------
static void initConTextSys( IMC_SYS_WORK* imc_w )
{
	// XN[N[
	GF_BGL_ScrClear( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M );
	GF_BGL_ScrollSet( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, 0 );
	GF_BGL_ScrollSet( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M, GF_BGL_SCROLL_Y_SET, 0 );
	
	// rbg}bvEBhE`
	initContestTextBmpWin( imc_w, 0 );

	// \D揇ʐݒ
	G2_SetBG0Priority( 2 );
	G2_SetBG1Priority( 1 );
	G2_SetBG2Priority( 3 );
	G2_SetBG3Priority( 0 );

	//FRAME3\
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_ON );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );

	// WIPEj
	WIPE_ResetBrightness( WIPE_DISP_MAIN );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXg@I
 *
 *	@param	imc_w	[N
 */
//-----------------------------------------------------------------------------
static void deleteConTextSys( IMC_SYS_WORK* imc_w )
{
	// rbg}bvj
	deleteContestTextBmpWin( imc_w );

	// XN[
	GF_BGL_ScrClear( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M );

	// {bNXOtBbNĐݒ
	setLeftBoxBg( imc_w );

	// WIPEݒ
	WIPE_SetBrightness( WIPE_DISP_MAIN, WIPE_FADE_BLACK );

	// ŏAN^[Zbg\
	CLACT_DrawFlagSet( imc_w->drawSys.clactSet, 1 );

	//Sĕ\
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
}


//----------------------------------------------------------------------------
/**
 *	@brief	Tuʁ@GEBhE@
 *
 *	@param	imc_w	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void initTouchSWSys( IMC_SYS_WORK* imc_w )
{
	TOUCH_SW_PARAM touch_prm;

	// XN[N[
	GF_BGL_ScrClear( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M );
	GF_BGL_ScrollSet( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M, GF_BGL_SCROLL_X_SET, 0 );
	GF_BGL_ScrollSet( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M, GF_BGL_SCROLL_Y_SET, 0 );
	
	// YES NO EBhE{^̕\
	touch_prm.p_bgl		= imc_w->drawSys.BG_Ini;
	touch_prm.bg_frame	= GF_BGL_FRAME3_M;
	touch_prm.char_offs	= IMC_ENDCHECK_YESNO_CHAR_OFFS;
	touch_prm.pltt_offs = IMC_ENDCHECK_YESNO_PLTT_OFFS;
	touch_prm.x			= IMC_ENDCHECK_YESNO_X;
	touch_prm.y			= IMC_ENDCHECK_YESNO_Y;
	TOUCH_SW_Init( imc_w->p_tsw, &touch_prm );

	// rbg}bvEBhE`
	initTouchSWBmpWin( imc_w, imgclip_ok );

	// \D揇ʐݒ
	G2_SetBG0Priority( 2 );
	G2_SetBG1Priority( 1 );
	G2_SetBG2Priority( 3 );
	G2_SetBG3Priority( 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tuʁ@GEBhE@j
 *
 *	@param	imc_w	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void deleteTouchSWSys( IMC_SYS_WORK* imc_w )
{
	TOUCH_SW_Reset( imc_w->p_tsw );

	// rbg}bvj
	deleteTouchSWBmpWin( imc_w );

	// XN[
	GF_BGL_ScrClear( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tuʁ@GEBhE@C
 *
 *	@param	imc_w	[N
 *
 *	@retval	IMC_SYS_END_CHECK			// Ȃ
 *	@retval	IMC_SYS_END_REQ				// ͂
 *	@retval	IMC_SYS_END_CANCEL_REQ		// 
 */
//-----------------------------------------------------------------------------
static u32 mainTouchSWSys( IMC_SYS_WORK* imc_w )
{
	u32 ret;
	ret = TOUCH_SW_Main( imc_w->p_tsw );

	switch( ret ){
	case TOUCH_SW_RET_NORMAL:	// Ȃ
		ret = IMC_SYS_END_CHECK;
		break;
		
	case TOUCH_SW_RET_YES:	// ͂
		ret = IMC_SYS_END_REQ;
		break;
		
	case TOUCH_SW_RET_NO:		// 
		ret = IMC_SYS_END_CANCEL_REQ;
		break;
	}
	
	return ret;
}


//----------------------------------------------------------------------------
/**
 *	@brief	rbg}bvEBhȄ
 *
 *	@param	imc_w 
 *	@param	str_idx		ID
 *	@param	cx			LN^ʒu
 *	@param	cy			LN^ʒu
 *	@param	csx			LN^TCY
 *	@param	csy			LN^TCY
 */
//-----------------------------------------------------------------------------
static void initMsgBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx, u8 cx, u8 cy, u8 csx, u8 csy )
{
	MSGDATA_MANAGER* msg_data;
	STRBUF* str;
	WINTYPE wnd_no = CONFIG_GetWindowType( imc_w->cp_config );
	
	
	// tHgJ[pbg]
	TalkFontPaletteLoad( PALTYPE_MAIN_BG, IMC_ENDCHECK_WND_PAL*32, HEAPID_IMAGECLIP_DRAW );
	
	// rbg}bvEBhE쐬
	GF_BGL_BmpWinAdd( imc_w->drawSys.BG_Ini,
			imc_w->p_tsw_bmp, GF_BGL_FRAME3_M,
			cx, cy,
			csx, csy,
			IMC_ENDCHECK_WND_PAL, IMC_ENDCHECK_WND_CHROFS );
	// N[
	GF_BGL_BmpWinDataFill( imc_w->p_tsw_bmp, 15 );

	// g`
	TalkWinGraphicSet( imc_w->drawSys.BG_Ini, GF_BGL_FRAME3_M, IMC_ENDCHECK_WNDWAKU_CHROFS, IMC_ENDCHECK_WNDWAKU_PAL, wnd_no, HEAPID_IMAGECLIP_DRAW );
	BmpTalkWinWrite( imc_w->p_tsw_bmp, WINDOW_TRANS_ON, IMC_ENDCHECK_WNDWAKU_CHROFS, IMC_ENDCHECK_WNDWAKU_PAL );

	// `
	msg_data = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_imageclip_dat, HEAPID_IMAGECLIP_DATA );
	str = MSGMAN_AllocString( msg_data, str_idx );
	GF_STR_PrintColor( imc_w->p_tsw_bmp, FONT_TALK, str, 0, 0, 0, IMC_ENDCHECK_WND_PRICOLOR, NULL );
	// j
	STRBUF_Delete( str );
	MSGMAN_Delete( msg_data );

	// ]
	GF_BGL_BmpWinOn( imc_w->p_tsw_bmp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	rbg}bvEBhEɕ`
 *
 *	@param	imc_w		[N
 *	@param	str_idx		ID
 */
//-----------------------------------------------------------------------------
static void setMsgBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx )
{
	MSGDATA_MANAGER* msg_data;
	STRBUF* str;
	STRBUF* p_exstr;
	
	// N[
	GF_BGL_BmpWinDataFill( imc_w->p_tsw_bmp, 15 );

	// `
	msg_data = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_imageclip_dat, HEAPID_IMAGECLIP_DATA );
	p_exstr = MSGMAN_AllocString( msg_data, str_idx );
	str = STRBUF_Create( 256, HEAPID_IMAGECLIP_DATA );

	WORDSET_ExpandStr( imc_w->p_wordset, str, p_exstr );
	
	GF_STR_PrintColor( imc_w->p_tsw_bmp, FONT_TALK, str, 0, 0, 0, IMC_ENDCHECK_WND_PRICOLOR, NULL );

	// j
	STRBUF_Delete( str );
	STRBUF_Delete( p_exstr );
	MSGMAN_Delete( msg_data );

	// ]
	GF_BGL_BmpWinOn( imc_w->p_tsw_bmp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	bZ[W`
 *
 *	@param	imc_w		[N
 *	@param	str_idx		ID
 *
 *	@return	bZ[WIDX
 */
//-----------------------------------------------------------------------------
static u32 setMsgBmpWin_okuri( IMC_SYS_WORK* imc_w, u32 str_idx )
{
	u32 msg_index;
	MSGDATA_MANAGER* msg_data;
	u32 speed;
	STRBUF* p_exstr;

	GF_ASSERT( imc_w->p_glb_str == NULL );
	
	// N[
	GF_BGL_BmpWinDataFill( imc_w->p_tsw_bmp, 15 );

	// `
	msg_data = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_imageclip_dat, HEAPID_IMAGECLIP_DATA );
	p_exstr = MSGMAN_AllocString( msg_data, str_idx );
	imc_w->p_glb_str = STRBUF_Create( 256, HEAPID_IMAGECLIP_DATA );

	WORDSET_ExpandStr( imc_w->p_wordset, imc_w->p_glb_str, p_exstr );
	
	if( imc_w->p_comm_data->sio_flag == 0 ){
		speed = CONFIG_GetMsgPrintSpeed( imc_w->cp_config );
	}else{
		speed = CONTEST_SIO_MSG_SPEED;
	}
	
	msg_index = GF_STR_PrintColor( imc_w->p_tsw_bmp, FONT_TALK, imc_w->p_glb_str, 0, 0, speed, IMC_ENDCHECK_WND_PRICOLOR, NULL );

	STRBUF_Delete( p_exstr );
	// j
	MSGMAN_Delete( msg_data );

	// ]
	GF_BGL_BmpWinOn( imc_w->p_tsw_bmp );

	return msg_index;
}

//----------------------------------------------------------------------------
/**
 *	@brief	悤[Nj
 *
 *	@param	imc_w 
 */
//-----------------------------------------------------------------------------
static void endMsgBmpWin_okuri( IMC_SYS_WORK* imc_w )
{
	STRBUF_Delete( imc_w->p_glb_str );
	imc_w->p_glb_str = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	rbg}bvEBhE̔j
 *
 *	@param	imc_w	[N
 */
//-----------------------------------------------------------------------------
static void deleteMsgBmpWin( IMC_SYS_WORK* imc_w )
{
	// ]
	GF_BGL_BmpWinOff( imc_w->p_tsw_bmp );
	GF_BGL_BmpWinDel( imc_w->p_tsw_bmp );
}


//----------------------------------------------------------------------------
/**
 *	@brief	I`FbNrbg}bvEBhE쐬
 *
 *	@param	imc_w 
 *	@param	str_idx		ID
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void initTouchSWBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx )
{
	initMsgBmpWin( imc_w, str_idx, 
			IMC_ENDCHECK_WND_X, IMC_ENDCHECK_WND_Y,
			IMC_ENDCHECK_WND_SIZX, IMC_ENDCHECK_WND_SIZY );
}

//----------------------------------------------------------------------------
/**
 *	@brief	I`FbNrbg}bvEBhEݒ
 *
 *	@param	imc_w 
 *	@param	str_idx		ID
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void setTouchSWBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx )
{
	setMsgBmpWin( imc_w, str_idx );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Iprbg}bvEBhEj
 *
 *	@param	imc_w	
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void deleteTouchSWBmpWin( IMC_SYS_WORK* imc_w )
{
	deleteMsgBmpWin( imc_w );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgeLXg	BMP쐬
 *
 *	@param	imc_w	[N
 *	@param	str_idx bZ[W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void initContestTextBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx )
{
	initMsgBmpWin( imc_w, str_idx, 
			IMC_CONTESTTEXT_WND_X, IMC_CONTESTTEXT_WND_Y,
			IMC_CONTESTTEXT_WND_SIZX, IMC_CONTESTTEXT_WND_SIZY );

	// [hZbg쐬
	imc_w->p_wordset = WORDSET_Create( HEAPID_IMAGECLIP_DATA );	
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgeLXg@
 *
 *	@param	imc_w		[N
 *	@param	str_idx		ID
 *
 *	@return	bZ[WIDX
 */
//-----------------------------------------------------------------------------
static u32 setContestTextBmpWin( IMC_SYS_WORK* imc_w, u32 str_idx )
{
	return setMsgBmpWin_okuri( imc_w, str_idx );
}

//----------------------------------------------------------------------------
/**
 *	@brief	[hZbgɐݒ
 *
 *	@param	imc_w	[N
 *	@param	buff_id	obt@ID
 *	@param	no		
 */
//-----------------------------------------------------------------------------
static void setContestWordSet( IMC_SYS_WORK* imc_w, int buff_id, int no )
{
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/23
	// ̍̃Xy[X
	WORDSET_RegisterNumber( imc_w->p_wordset, buff_id, no, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	// ----------------------------------------------------------------------------
}

//----------------------------------------------------------------------------
/**
 *	@brief	j
 */
//-----------------------------------------------------------------------------
static void endContestTextBmpWin( IMC_SYS_WORK* imc_w )
{
	endMsgBmpWin_okuri( imc_w );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXgeLXgBMPj
 *
 *	@param	imc_w	[N
 */
//-----------------------------------------------------------------------------
static void deleteContestTextBmpWin( IMC_SYS_WORK* imc_w )
{
	deleteMsgBmpWin( imc_w );

	// [hZbgj
	WORDSET_Delete( imc_w->p_wordset );
	imc_w->p_wordset = NULL;
}



//----------------------------------------------------------------------------
/**
 *	@brief	E{bNX̃ANZTo^ݒ
 *
 *	@param	imc_w	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setAcceNumSubWin( IMC_SYS_WORK* imc_w )
{
	int acce_num;

	acce_num = IMC_RBOX_GetNowHaveAcceNum( &imc_w->rbox );
	
	// E{bNX̔zuANZTf[^ݒ
	IMC_SUBWIN_SetAcceIcon( &imc_w->subwin, acce_num );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ReXg̃NɂAANZTő吔擾
 *
 *	@param	rank	N
 *
 *	@return	ANZT
 */
//-----------------------------------------------------------------------------
static int getRightAcceMax_contest( int rank )
{
	int acce_max;
	
	switch( rank ){
	case CONRANK_NORMAL:
		acce_max = CON_IMAGE_ACCE_MAX_NORMAL;
		break;

	case CONRANK_SUPER:
		acce_max = CON_IMAGE_ACCE_MAX_SUPER;
		break;

	case CONRANK_HYPER:
		acce_max = CON_IMAGE_ACCE_MAX_HYPER;
		break;

	case CONRANK_MASTER:
		acce_max = CON_IMAGE_ACCE_MAX_MASTER;
		break;

	default:
		// Ns
		GF_ASSERT(0);
		break;
	}

	return acce_max;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[u邩pCGXm[{^
 *
 *	@param	imc_w	[N
 *
 *	@return	none
 *
 *	I`FbÑnCCCGp܂
 */
//-----------------------------------------------------------------------------
static void initTouchSaveCheckSWSys( IMC_SYS_WORK* imc_w )
{
	TOUCH_SW_PARAM touch_prm;

	// YES NO EBhE{^̕\
	touch_prm.p_bgl		= imc_w->drawSys.BG_Ini;
	touch_prm.bg_frame	= GF_BGL_FRAME3_M;
	touch_prm.char_offs	= IMC_ENDCHECK_YESNO_CHAR_OFFS;
	touch_prm.pltt_offs = IMC_ENDCHECK_YESNO_PLTT_OFFS;
	touch_prm.x			= IMC_ENDCHECK_YESNO_X;
	touch_prm.y			= IMC_ENDCHECK_YESNO_Y;
	TOUCH_SW_Reset( imc_w->p_tsw );
	TOUCH_SW_Init( imc_w->p_tsw, &touch_prm );

	// rbg}bvEBhE`
	setTouchSWBmpWin( imc_w, imgclip_ng );

	// \D揇ʐݒ
	G2_SetBG0Priority( 2 );
	G2_SetBG1Priority( 1 );
	G2_SetBG2Priority( 3 );
	G2_SetBG3Priority( 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[uf[^`FbN YESNO C
 *
 *	@param	imc_w	[N
 *
 *	@retval	
 */
//-----------------------------------------------------------------------------
static u32 mainTouchSaveCheckSWSys( IMC_SYS_WORK* imc_w )
{
	u32 ret;
	ret = TOUCH_SW_Main( imc_w->p_tsw );

	switch( ret ){
	case TOUCH_SW_RET_NORMAL:	// Ȃ
		ret = IMC_SYS_SAVE_CHECK_REQ;
		break;
		
	case TOUCH_SW_RET_YES:	// ͂
		ret = IMC_SYS_SAVE;
		break;
		
	case TOUCH_SW_RET_NO:		// 
		ret = IMC_SYS_SAVE_CAN;
		break;
	}
	
	return ret;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PɃANZT`łȂĂ邩`FbNVXe@	i[NONAj
 *
 *	@param	p_sys	VXe[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void initPokeOnAcceCheckSys( IMC_POKE_ON_ACCESYS* p_sys )
{
	memset( p_sys, 0, sizeof(IMC_POKE_ON_ACCESYS) );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PɃANZT`łȂĂ邩`FbNVXe@IuWFNgXgݒ
 *
 *	@param	p_sys		VXe[N
 *	@param	obj			IuWFNg
 *	@param	init_data	|PɂĂ邩̏l
 *
 *	@return	none
 *
 *	init_data	
 *		ŏ|PɂĂƂ킩Ă̂ɂ1nĂ
 *		IMC_POKEON_ACCE_NONE	|PɂĂȂ
 *		IMC_POKEON_ACCE_ON		|PɂĂ
 */
//-----------------------------------------------------------------------------
static void setPokeOnAcceCheckObj( IMC_POKE_ON_ACCESYS* p_sys, IMC_OBJLIST* obj, u32 init_data )
{
	//@NULL͂
	GF_ASSERT( obj );
	p_sys->obj[ p_sys->set_num ].obj			= obj;
	p_sys->obj[ p_sys->set_num ].pokemon_data	= init_data;
	p_sys->set_num++;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PɃANZT`łȂĂ邩`FbNVXe@`FbN֐
 *
 *	@param	p_sys	VXe[N
 *
 *	@return	none
 *
 *	̊֐s@getPokeOnAcceCheckObjOnPoke
 *	ƃANZT`łȂĂ邩킩
 */
//-----------------------------------------------------------------------------
static void mainPokeOnAcceCheckSys( IMC_POKE_ON_ACCESYS* p_sys )
{
	int i, j;
	BOOL result;

	// |PɂĂANZT
	// 肵ĂÃ͈͓ANZTA
	// ̒lAS肵玩ɂQ
	// [IMC_POKEON_ACCE_ON]̃ANZTx́A
	// ͂Ă
	// JԂ
	i=0;
	while( i<p_sys->set_num ){

		if( p_sys->obj[ i ].pokemon_data == IMC_POKEON_ACCE_ON ){

			// 蔻ȂȂ`FbNΏۂ̃ANZT|PƂȂĂ
			for( j=0; j<p_sys->set_num; j++ ){

				if( p_sys->obj[ j ].pokemon_data == IMC_POKEON_ACCE_NONE ){
					result = checkPokeOnAcceCalc( 
							&p_sys->obj[ i ], &p_sys->obj[ j ] );
					if( result == TRUE ){
						p_sys->obj[ j ].pokemon_data = IMC_POKEON_ACCE_ON;
					}
				}
			}
			// SEARCH
			p_sys->obj[ i ].pokemon_data = IMC_POKEON_ACCE_SEARCHEND;
			// x擪`FbN
			i = 0;
		}else{
			i++;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	io[̃IuWFNgXg擾
 *
 *	@param	p_sys		VXe[N
 *	@param	no			zCfbNX
 *
 *	@return	IuWFNgXg
 */
//-----------------------------------------------------------------------------
static IMC_OBJLIST* getPokeOnAcceCheckObjList( IMC_POKE_ON_ACCESYS* p_sys, u32 no )
{
	GF_ASSERT(no < IMC_POKEON_ACCE_CHECK_OBJNUM);

	return p_sys->obj[ no ].obj;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PɃANZT`łȂĂ邩`FbNVXe@̃ANZTȂĂ邩Ԃ
 *
 *	@param	p_sys		VXe[N
 *	@param	no			zCfbNX
 *	
 *	@retval	TRUE	ȂĂ
 *	@retval	FALSE	ȂĂȂ
 */
//-----------------------------------------------------------------------------
static BOOL getPokeOnAcceCheckObjOnPoke( IMC_POKE_ON_ACCESYS* p_sys, u32 no )
{
	GF_ASSERT(no < IMC_POKEON_ACCE_CHECK_OBJNUM);
	
	if( p_sys->obj[ no ].pokemon_data ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	蔻
 *
 *	@param	p_obj		ƂȂĂ邩`FbNĂIuWFNg
 *	@param	p_check_obj	`FbNIuWFNg
 *
 *	@retval	TRUE	Ă
 *	@retval	FLASE	ĂȂ
 */
//-----------------------------------------------------------------------------
enum{
	IMC_POKEON_ACCE_TOP,
	IMC_POKEON_ACCE_BOTTOM,
	IMC_POKEON_ACCE_LEFT,
	IMC_POKEON_ACCE_RIGHT,
	IMC_POKEON_ACCE_YHALF,
	IMC_POKEON_ACCE_XHALF,
	IMC_POKEON_ACCE_POS_NUM
};
static BOOL checkPokeOnAcceCalc( IMC_POKE_ON_ACCEOBJ* p_obj, IMC_POKE_ON_ACCEOBJ* p_check_obj )
{
	int pos[IMC_POKEON_ACCE_POS_NUM];
	BOOL result;
	int i;
	int x, y;
	
	// 16_`FbN
	// ㉺E@^
	// ^
	IMC_OBJLIST_GetObjCenterMat( p_obj->obj, &pos[IMC_POKEON_ACCE_XHALF], &pos[IMC_POKEON_ACCE_YHALF] );
	IMC_OBJLIST_GetObjRectSubInSize( p_obj->obj,
			&pos[IMC_POKEON_ACCE_TOP], &pos[IMC_POKEON_ACCE_BOTTOM], 
			&pos[IMC_POKEON_ACCE_LEFT], &pos[IMC_POKEON_ACCE_RIGHT] );

	for( i=0; i<16; i++ ){
		IMC_CALC_HitPoint16Get( pos[IMC_POKEON_ACCE_TOP], pos[IMC_POKEON_ACCE_BOTTOM],
				pos[IMC_POKEON_ACCE_LEFT], pos[IMC_POKEON_ACCE_RIGHT], i,
				&x, &y );	
/*		switch( i ){
		case 0:	// 
			x = pos[IMC_POKEON_ACCE_LEFT];
			y = pos[IMC_POKEON_ACCE_TOP];
			break;
		case 1:	// E
			x = pos[IMC_POKEON_ACCE_RIGHT];
			y = pos[IMC_POKEON_ACCE_TOP];
			break;
		case 2:	// 
			x = pos[IMC_POKEON_ACCE_RIGHT];
			y = pos[IMC_POKEON_ACCE_TOP];
			break;
		case 3:	// E
			x = pos[IMC_POKEON_ACCE_RIGHT];
			y = pos[IMC_POKEON_ACCE_TOP];
			break;
		case 4:	// ^
			x = pos[IMC_POKEON_ACCE_LEFT];
			y = pos[IMC_POKEON_ACCE_YHALF];
			break;
		case 5:	// E^
			x = pos[IMC_POKEON_ACCE_RIGHT];
			y = pos[IMC_POKEON_ACCE_YHALF];
			break;
		case 6:	// ^񒆏
			x = pos[IMC_POKEON_ACCE_XHALF];
			y = pos[IMC_POKEON_ACCE_TOP];
			break;
		case 7:	// ^񒆉
			x = pos[IMC_POKEON_ACCE_XHALF];
			y = pos[IMC_POKEON_ACCE_BOTTOM];
			break;
		case 8:	// ^
			x = pos[IMC_POKEON_ACCE_XHALF];
			y = pos[IMC_POKEON_ACCE_YHALF];
			break;
		default:
			GF_ASSERT(0);
			break;
		}//*/

		result = IMC_OBJLIST_ACCEPOKE_Hit( p_check_obj->obj, x, y );
		if( result == TRUE ){	// 甲
			return TRUE;
		}
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	IuWFNgXg̃ANZTS@`FbNpe[uɓ
 *
 *	@param	p_sys		[N
 *	@param	dummy		_~[f[^
 *	@param	init_data	f[^
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void setPokeOnAcceCheckObjList( IMC_POKE_ON_ACCESYS* p_sys, IMC_OBJLIST* dummy, u32 init_data )
{
	IMC_OBJLIST* p_work;

	p_work = dummy->next;	// |P̏̃ANZT
	while( p_work != dummy ){
		// ANZTf[^Ȃۑ	
		if( p_work->flag == IMC_OBJLIST_ACCE ){
			setPokeOnAcceCheckObj( p_sys, p_work, init_data );
		}
		p_work = p_work->next;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	I`FbN
 *
 *	@param	imc_w 
 */
//-----------------------------------------------------------------------------
static void Imc_OyaExEndCheck( IMC_SYS_WORK* imc_w )
{
	int i;
	int count = 0;
	
	// ʐMĂȂƂ͖0ɂ
	if( imc_w->p_comm_data->sio_flag == 0 ){
		IMC_SUBWIN_SetCounterNowNum( &imc_w->subwin, 0 );
		return ;
	}

	// eȂFItO𒲂ׂ
	if( imc_w->p_comm_data->server_no == imc_w->p_comm_data->my_net_id ){
		for( i=0; i<BREEDER_MAX; i++ ){
			if( imc_w->p_comm_data->recieve_force_end[i] == TRUE ){
				count ++;
			}
		}
		
		// SÎŃJEglOɂ
		if( imc_w->p_comm_data->player_num  <= count ){
			IMC_SUBWIN_SetCounterNowNum( &imc_w->subwin, 0 );
		}
	}

}



//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbv蔻|Cg擾֐
 *
 *	@param	top			gbv
 *	@param	bottom		{g
 *	@param	left		tg
 *	@param	right		Cg
 *	@param	no			蔻|Cgio[(O`PT)
 *	@param	p_x			XWi[
 *	@param	p_y			YWi[
 */
//-----------------------------------------------------------------------------
void IMC_CALC_HitPoint16Get( u32 top, u32 bottom, u32 left, u32 right, u32 no, int* p_x, int* p_y )
{
	u32 halfx_0, halfx_1;
	u32 halfy_0, halfy_1;
	
	halfx_0 = left + ((right - left) / 3);
	halfx_1 = left + ((right - left) / 3)*2;

	halfy_0 = top + ((bottom - top) / 3);
	halfy_1 = top + ((bottom - top) / 3)*2;
	
	switch( no ){
	case 0:	// 
		*p_x = left;
		*p_y = top;
		break;

	case 1:	// @ԂO
		*p_x = left;
		*p_y = halfy_0;
		break;

	case 2:	// @ԂP
		*p_x = left;
		*p_y = halfy_1;
		break;

	case 3:	// 
		*p_x = left;
		*p_y = bottom;
		break;

	case 4:	// ԂO@
		*p_x = halfx_0;
		*p_y = top;
		break;

	case 5:	// ԂO@ԂO
		*p_x = halfx_0;
		*p_y = halfy_0;
		break;

	case 6:	// ԂO@ԂP
		*p_x = halfx_0;
		*p_y = halfy_1;
		break;

	case 7:	// ԂO@
		*p_x = halfx_0;
		*p_y = bottom;
		break;

	case 8:	// ԂP@
		*p_x = halfx_1;
		*p_y = top;
		break;

	case 9:	// ԂP@ԂO
		*p_x = halfx_1;
		*p_y = halfy_0;
		break;

	case 10:	// ԂP@ԂP
		*p_x = halfx_1;
		*p_y = halfy_1;
		break;

	case 11:	// ԂP@
		*p_x = halfx_1;
		*p_y = bottom;
		break;

	case 12:	// E@
		*p_x = right;
		*p_y = top;
		break;

	case 13:	// E@ԂO
		*p_x = right;
		*p_y = halfy_0;
		break;

	case 14:	// E@ԂP
		*p_x = right;
		*p_y = halfy_1;
		break;

	case 15:	// E@
		*p_x = right;
		*p_y = bottom;
		break;
	}
}

