//============================================================================================
/**
 * @file	namein.c
 * @bfief	O͉ʏ
 * @author	Akito Mori
 * @date	05.10.05
 */
//============================================================================================
#define USE_PARAM_STR		// NAMEIN_PARAM u16 str[20]KvȊԗLɂ

//#define DEBUG_OAM_POSPRINT	// Lɂƃ^b`pl̓̈mFł


#include "common.h"
#include "system/procsys.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/pm_str.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "system/window.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_namein.h"
#include "msgdata/msg_fightmsg_dp.h"
#include "system/wipe.h"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/lib_pack.h"
#include "system/fontoam.h"
#include "system/msg_ds_icon.h"
#include "gflib/msg_print.h"
#include "gflib/touchpanel.h"
#include "poketool/poke_tool.h"
#include "poketool/monsno.h"
#include "poketool/pokeicon.h"
#include "poketool/boxdata.h"
#include "application/namein.h"
#include "system/bmp_menu.h"
#include "system/snd_tool.h"
#include "gflib/strbuf_family.h"
#include "msgdata/msg_opening_name.h"
#include "namein_snd_def.h"

// LɂLCD㉺tɂă^b`plœ͂ł悤ɂȂ
#define NAMEIN_MAINUSE_TOUCHPANEL

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/03
// CAEgύXɔA|PACR̓]ʒuC
#define POKEICON_VRAM_OFFSET (21*32+31)
// ----------------------------------------------------------------------------
#define POKEICON_PAL_OFFSET	 ( 6 )

// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define NAMEIN_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)


// ͂\ۂ̊Ԋu
#define INPUT_WORD_SPACE (12)		

// pl̊̕Ԋu
#define WORDPANEL_WORD_SPACE (16)		

// ރplnmɂȂ܂Ń^b`LɂȂȂ悤ɂ邽߂̃EFCg
#define TOUCH_START_WAIT	 ( 5 )

#include "namein.naix"			// OtBbNA[JCu`
#include "../../field/poketch/poketch_arc.h"

#ifdef DEBUG_OAM_POSPRINT

static CLACT_WORK_PTR	testclact[4];
static int              testclact_no = 0;

#endif

//============================================================================================
//	萔`
//============================================================================================
enum {
	SEQ_IN = 0,
	SEQ_WAIT,
	SEQ_MAIN,
	SEQ_OUT,
};


typedef struct {
	int x;			// ݈ʒu
	int y;			//
	int oldx;		// 1STEPÖʒu
	int oldy;		//
	int lastxarrow;	// Ō̈ړ

	int on;			// \ONEOFF
	int decide;		// AjH
}NAMEIN_CURSOR;

#define INPUT_SCREEN_MAX	( 5)	
#define INPUT_WORD_W		(13)
#define INPUT_WORD_H		( 6)
#define INPUT_WORD_WH		(INPUT_WORD_W*INPUT_WORD_H)
#define INPUT_WORD_MAX		(32)	//͖

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define NAMEIN_OAM_NUM			( 14 )
#define NAMELINE_OAM_NUM		( 12 )

// J[\CLACT_WORKio[
#define CLACT_CURSOR_NUM		(  8 )

// pl̓]
#define WORDPANEL_TRANS_SIZE	( 32*14*2 )

// pl̈ʒu`
#define WORDPANEL_POS_REGX		(  -11 )
#define WORDPANEL_POS_REGY		(  -80 )
#define HIDDENPANEL_POS_REGX	(  238 )
#define DOWNPANEL_POS_REGY		( -196 )

#define WORDPANEL_IN_SPEED		( 24 )
#define WORDPANEL_OUT_SPEED		( 10 )

// ͍ςݕ̉OBJ
#define NAMELINE_POS_X			( 10*8   )
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/10
// g  y ̉BȂ悤ɁAOBJ2sNZ
#define NAMELINE_POS_Y			(  4*8+7 )
// ----------------------------------------------------------------------------

// p\RE@E|PACROBJʒu
#define NAMEIN_MYICON_X			( 24 )
#define NAMEIN_MYICON_Y			( 16-8 )

// |P̐ʃACR̈ʒu
#define NAMEIN_SEXICON_Y		( NAMELINE_POS_Y - 12)

// O͏ʒu`iȂ̂Ȃ܂́Hj
#define NAME_INFO_POSX			(  7 )
#define NAME_INFO_POSY			(  2 )
#define NAME_INFO_POSW			( 22 )
#define NAME_INFO_POSH			(  2 )
#define NAMEINFO_WIN_SIZE		( NAME_INFO_POSW*NAME_INFO_POSH )


// O͌ʕ\ʒu`
#define NAME_RESULT_POSX		( 10   )
#define NAME_RESULT_POSY		(  3   )
#define NAME_RESULT_POSW		( 9*2  )
#define NAME_RESULT_POSH		(  2   )
#define NAME_RESULT_WIN_SIZE	( NAME_RESULT_POSW*NAME_RESULT_POSH )

// uO[vv\p`
#define GROUP_TEXT_POSX			(  10+9 )
#define GROUP_TEXT_POSY			(  NAME_RESULT_POSY )
#define GROUP_TEXT_POSW			(  7  )
#define GROUP_TEXT_POSH			(  2  )
#define GROUP_TEXT_WIN_SIZE		( GROUP_TEXT_POSW*GROUP_TEXT_POSH )


#define FLD_MESFRAME_PAL     ( 10 )         //  bZ[WEChEpbg
#define FLD_MESFONT_PAL      ( 12 )         //  bZ[WtHgpbg


// bEChEʒu`(tB[h̃Rs[)
#define	TALK_MSG_WIN_PX		(  2 )
#define	TALK_MSG_WIN_PY		( 19 )
#define	TALK_MSG_WIN_SX		( 27 )
#define	TALK_MSG_WIN_SY		(  4 )
#define	TALK_MSG_WIN_PAL	( FLD_MESFONT_PAL )

// BG2̃OtBbNf[^TCYƉbEChELf[^̊Jnʒu
#define NAMEIN_BG2GRAPHIC_NUM	  ( 32*8 )
#define NAMEIN_BG2GRAPHIC_SIZE	  ( NAMEIN_BG2GRAPHIC_NUM*0x20 )
#define NAMEIN_TALKWIN_CGX_OFFSET ( NAMEIN_BG2GRAPHIC_NUM )



// pl̑Jڗp
enum{
	NAMEIN_MODE_REQ  = 0, 
	NAMEIN_MODE_SET,
	NAMEIN_MODE_ANIM,
	NAMEIN_MODE_ANIM_WAIT,
	NAMEIN_MODE,
	NAMEIN_MODE_BOXMSG,
	NAMEIN_MODE_BOXMSG_END,
	NAMEIN_MODE_BOXMSG_END_WAIT,
};

// @\{^`
enum{
	NAMEIN_MODE_HIRA = 0,
	NAMEIN_MODE_KANA,
	NAMEIN_MODE_ALPHA,
	NAMEIN_MODE_KIGOU,
	NAMEIN_MODE_NUMCODE,
};

// ㉺ʎw`
#define BOTH_LCD	( 2 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB

// ^b`pl`ƂɎg
#define PANEL_X		( 28 )
#define PANEL_Y		( 88 )
#define PANEL_H		( 19 )


// BMPWINw
enum{
	BMP_WORDPANEL_BG0=0,
	BMP_WORDPANEL_BG1,
	BMP_TITLE_MES,
	BMP_RESULT_NAME,
	BMP_SUB_BUTTON1,
	BMP_SUB_BUTTON2,
	BMP_SUB_BUTTON3,
	BMP_SUB_STRING,
	BMP_GROUP_STRING,
	BMP_TALK_WIN,
	BMP_NAMEIN_MAX,
};

// @\{^p`
#define FUNCBUTTON_NUM	( 7 ) 		// @\{^̐

// ef[^`

#include "namein.dat"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂Pʂō폜悤ɕύX
#if PM_LANG == LANG_KOREA
#define LOGNUM_MAX		(5)
#endif
// ----------------------------------------------------------------------------

//============================================================================================
//	\̒`
//============================================================================================

struct NAMEIN_WORK{

	int    inputmode;										// ̓[hi0:l,1:|P,2:{bNX
	int    inputinfo;										// ͏ijA|PNOȂ
	int    inputform;										// ߂i|P`j
	int    inputmax;										// ͕ő吔
	int    inputsex;										// |P̎͐ʂ\
	int    endmode;											// 1̎̓|PBOXɓ]|̃bZ[Wł
	CONFIG *config;

	NAMEIN_CURSOR 	Cursor;									// J[\@XEYEߋXE\ON
	u16				CursorPal;
	u16 			wordmap[INPUT_WORD_H][INPUT_WORD_W];	// Ճ}bv
	u16 			nowmap;									// ݂̕}bv
	u16 			inputword[INPUT_WORD_MAX];				// ͂
	u16 			paramstr[INPUT_WORD_MAX];				// (ĂяoɊi[ĂirɎgpjj
	u16				nowinput;								// ݂̃J[\ʒu
	u16				subtouchword[3];						// R̉{^ɔzuĂ镶R[h
	GF_BGL_INI		*bgl;
	BOOL			wipe_end;								// CvIotO

	WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
	MSGDATA_MANAGER *MsgDefaultName;						// ̖O⃁bZ[Wf[^
	MSGDATA_MANAGER *FightMsgManager;						// |Pߊl̎̃bZ[Wf[^퓬Q
	STRBUF			*TitleStr;								// O̓^Cg
	STRBUF			*ChangeWordStr;							// u v
	STRBUF			*BoxMessage;							// u|Ṕɓ]ꂽv
	STRBUF			*GroupString;							// uO[vv

	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[BOTH_LCD][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
	CLACT_WORK_PTR			clActWork[NAMEIN_OAM_NUM];				// ZAN^[[N|C^z
	CLACT_WORK_PTR			NameLineActWork[NAMELINE_OAM_NUM];		// ͌ʕ\̉A_[C
	CLACT_WORK_PTR			NameIconActWork[2];						// ͉ʐACRi@Ep\R^ʁEj
	TCB_PTR					FuncButtonTask[FUNCBUTTON_NUM];

	GF_BGL_BMPWIN 			NameInWin[BMP_NAMEIN_MAX];				// O͗pBMPEChE
	int						msg_index;


	int						seq;									// ݂̕͏ԁiOK/AjjȂ
	int						mode;									// ݍőOʂ̕pl

	int						front;									// OɗĂBG
	VecFx32					panelpos[2];							// ړ2BGʗpW[N(Œ菭ł͎gĂȂj

	int						word;									

	int						old_subbutton;							// Ỏʃ{^
	int						subbutton_mode;
	int						subbutton_work;

	int						funcbutton[FUNCBUTTON_NUM];				// {^ԃtO

	void*					BgCharaBuf;
	NNSG2dCharacterData*	BgCharaDat;

	void*					PokeIconBuf;							// |PACRf[^
	NNSG2dCharacterData*	PokeIconCharaDat;						

	void*					PokeIconPalBuf;
	NNSG2dPaletteData*		PokeIconPalDat;
	
	u8						ObjTransWork[32*4*2];					//

	void					*dsicon_task;							//

	BOOL					TP_decide;

	int						wait;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂Pʂō폜悤ɕύX
#if PM_LANG == LANG_KOREA
	int						log_num;								// NameInProc_Init()  memset() Ő
	STRCODE					hangul_log[LOGNUM_MAX];					// mnO̓̓O
#endif
// ----------------------------------------------------------------------------
#ifdef PM_DEBUG
	int 					frame;									//
	int						framenum[9][2];							//
#endif
};


//============================================================================================
//	vg^Cv錾
//============================================================================================
static PROC_RESULT NameInProc_Init( PROC * proc, int * seq );
static PROC_RESULT NameInProc_Main( PROC * proc, int * seq );
static PROC_RESULT NameInProc_End( PROC * proc, int * seq );

static void VBlankFunc( void * work );
static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void BgExit( GF_BGL_INI * ini, GF_BGL_BMPWIN *win );
static void BgGraphicSet( NAMEIN_WORK * wk );
static void PanelFunc(GF_BGL_INI *bgl, GF_BGL_BMPWIN *win, int *seq, int mode, int *front, VecFx32 panelpos[], CLACT_WORK_PTR *clActWork, void *dakuten_Character);
static void InitWork(NAMEIN_WORK *wk, PROC * proc);
static void FrontBackBG_RegSet(GF_BGL_INI *bgl, int front, VecFx32 panelpos[]);
static void SetPanelFirstPos(VecFx32 panelpos[], int front);
static void InitCellActor(NAMEIN_WORK *wk);
static void SetCellActor(NAMEIN_WORK *wk);
static void char_pltt_manager_init(void);
static void BmpMessageSet(NAMEIN_WORK *wk, PROC* proc);
static void DebugOBJPOSGet(NAMEIN_WORK *wk);
static void ControlCursor(NAMEIN_WORK *wk);
static void CursorColTrans(u16 *CursorCol);
static void TouchFunc(NAMEIN_WORK *wk);
static void NameinWordPanelPrint(GF_BGL_BMPWIN *win, const u16 *str, int x,int y, int space, int sw, GF_PRINTCOLOR color, u8 *datkuten_Character);
static void ChangeSubPanelButtonWord(GF_BGL_BMPWIN *win, const u16 *tbl, u8 *TransWork, STRBUF *ChangeWordStr);
static void MakeWordMap(u16 map[][INPUT_WORD_W], const int no);
static void SubPanelButton_CharaChange(GF_BGL_BMPWIN *win, STRCODE *str,int pos,  u16 *words, u8 *TransWork, STRBUF *ChangeWordStr);
static int  DecideMainButton(NAMEIN_WORK *wk,u16 code, int pad);
static int  ConvertWord(int start, int num, int flag, int target, u16*str, int pos);
static int  RotateConvertWord(int start, int num, u16 *str, int pos);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂́Ả̃o[𓮂悤ɕύX
#if PM_LANG == LANG_KOREA
static void InputResultUnderLineMove(NAMEIN_WORK *wk);
#else
static void InputResultUnderLineMove(CLACT_WORK_PTR *lineact,int pos, int max);
#endif
// ----------------------------------------------------------------------------
static void SetNameInWorkParameter(NAMEIN_WORK *wk, NAMEIN_PARAM *param);
static void WordPanelSetUp(GF_BGL_BMPWIN *win,u16 bgchara, int frame, GF_PRINTCOLOR color, u8 *dakuten_Character);
static void CursorAppearUpDate(NAMEIN_WORK *wk, int arrow);
static void FuncButtonAnimation(int funcbutton[], CLACT_WORK_PTR *ButtonAct, int frame);
static void FuncButtonTaskFunc( TCB_PTR tcb, void *work );
static void QuakeFrameTaskFunc( TCB_PTR tcb, void *work );
static void TransPokeIconCharaPal( NNSG2dCharacterData *chara, NNSG2dPaletteData* pal, int pokeno, int form );
static void Namein_LCDOnOff( int flag);
static void SetBoxMessage( NAMEIN_WORK *wk, PROC * proc );
static void NameinIconAdd(NAMEIN_WORK *wk, CLACT_ADD *add );
static void InputCancelFunc( NAMEIN_WORK *wk, NAMEIN_PARAM *param );
static void PrintTalkInfoStr( GF_BGL_BMPWIN *bmp, int inputmode, STRBUF *Title );
static void CursorAnimationControl( NAMEIN_WORK *wk );
static int  NameInputMainMode( NAMEIN_WORK *wk, int seq );
static int SpaceCheck( STRCODE *str );


static void *GF_STR_PrintCGXOnly(GF_BGL_BMPWIN * win, STRBUF *msg,u8 fnt_index, GF_PRINTCOLOR col);

#ifdef DEBUG_OAM_POSPRINT

static testclact_set( void );

#endif
//============================================================================================
//	O[oϐ
//============================================================================================
// vZX`f[^
const PROC_DATA NameInProcData = {
	NameInProc_Init,
	NameInProc_Main,
	NameInProc_End,
	NO_OVERLAY_ID,
};


static NAMEIN_WORK *debug_namein;
//============================================================================================
//	vZX֐
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT NameInProc_Init( PROC * proc, int * seq )
{
	NAMEIN_WORK * wk;

	switch(*seq){
	case 0:
		sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
		sys_HBlankIntrStop();	//HBlank荞ݒ~

		GF_Disp_GX_VisibleControlInit();
		GF_Disp_GXS_VisibleControlInit();
		GX_SetVisiblePlane( 0 );
		GXS_SetVisiblePlane( 0 );

		sys_CreateHeap( HEAPID_BASE_APP, HEAPID_NAMEIN, 0x20000+0x8000 );

		wk = PROC_AllocWork( proc, sizeof(NAMEIN_WORK), HEAPID_NAMEIN );
		memset( wk, 0, sizeof(NAMEIN_WORK) );
		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_NAMEIN );
		
		// }l[W[
		wk->WordSet          = WORDSET_Create( HEAPID_NAMEIN );
		wk->MsgManager       = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_namein_dat, HEAPID_NAMEIN );
		wk->MsgDefaultName   = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_opening_name_dat, HEAPID_NAMEIN );
		wk->FightMsgManager  = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_fightmsg_dp_dat, HEAPID_NAMEIN );

		sys_KeyRepeatSpeedSet( 4, 8 );

		VramBankSet();
		
		// BGLWX^ݒ
		BgInit( wk->bgl );					

		// PxύXZbg

//		ChangeBrightnessRequest(
//			8, 0, -16, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );

		
		// ۑ
		SetNameInWorkParameter(wk, (NAMEIN_PARAM*)PROC_GetParentWork(proc));

		//BGOtBbNZbg
		BgGraphicSet( wk );

//		InitTPSystem();						// ^b`plVXe
//		InitTPNoBuff(4);
  
		// {^ptHgǂݍ
		FontProc_LoadFont( FONT_BUTTON, HEAPID_NAMEIN );
  	
 
		// VBlank֐Zbg
		sys_VBlankFuncChange( VBlankFunc, NULL );	
  
		// [N
		InitWork(wk,proc);

		// VXetHg풓
		FontProc_LoadBitData(FONT_SYSTEM,HEAPID_NAMEIN);

		// OBJLApbg}l[W[
		char_pltt_manager_init();

		// CellActorVXe
		InitCellActor(wk);
		
		// CellActro\o^
		SetCellActor(wk);

		// BMPWINo^E`
		BmpMessageSet(wk,proc);


		// {^OBJtHg]
		SubPanelButton_CharaChange(&wk->NameInWin[BMP_SUB_BUTTON1],
									wk->inputword,
									wk->nowinput,
									wk->subtouchword,
									wk->ObjTransWork,
									wk->ChangeWordStr);

		// TEhf[^[h(O)(BGMp)
		Snd_DataSetByScene( SND_SCENE_SUB_NAMEIN, 0, 0 );

		WIPE_SYS_Start(WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN, WIPE_TYPE_FADEIN, WIPE_FADE_BLACK, 16, 1, HEAPID_NAMEIN );
		Namein_LCDOnOff( VISIBLE_ON );

#ifdef NAMEIN_MAINUSE_TOUCHPANEL
		{
			//ʔ]	add by tetsu
			sys.disp3DSW = DISP_3D_TO_SUB;
			GF_Disp_DispSelect();
		}
#endif
		(*seq)++;
		break;
	case 1:
		wk = PROC_GetWork( proc );
		if(wk->inputmode==NAMEIN_POKEMON){
			// |PACRf[^VRAMɓ]
			TransPokeIconCharaPal(wk->PokeIconCharaDat, wk->PokeIconPalDat, wk->inputinfo, wk->inputform );
		}
		debug_namein = wk;

		wk->dsicon_task = MSG_DsIconFlashAdd( NULL, MSG_DSI_SUBDISP, TALK_MSG_WIN_PAL, HEAPID_NAMEIN );
		
		(*seq) = 0;
		return PROC_RES_FINISH;
		break;
	}
	return PROC_RES_CONTINUE;
}


//------------------------------------------------------------------
/**
 * |PACR]i|P̖O̎j
 *
 * @param   chara	LN^[t@CAhX
 * @param   pal		pbgt@CAhX
 * @param   pokeno	|P̊JNO
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TransPokeIconCharaPal( NNSG2dCharacterData *chara, NNSG2dPaletteData* pal, int pokeno, int form )
{
	u8 *pokepal;

	// LN^[]
	GX_LoadOBJ(chara->pRawData, POKEICON_VRAM_OFFSET*0x20, 0x20*4*4);

	// pbg]
	pokepal = (u8*)pal->pRawData;
	GX_LoadOBJPltt((void*)(pokepal + PokeIconPalNumGet(pokeno, form, 0)*0x20), 
					POKEICON_PAL_OFFSET*0x20, 0x20);


}


//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------

static PROC_RESULT NameInProc_Main( PROC * proc, int * seq )
{
	NAMEIN_WORK * wk  = PROC_GetWork( proc );

	switch( *seq ){
	case SEQ_IN:
//		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
		if( WIPE_SYS_EndCheck() ){
			*seq     = SEQ_WAIT;
			wk->wait = 0;
		}
		break;

	case SEQ_WAIT:
		wk->wait++;
		// J[\Aj[V
		CursorAnimationControl( wk );
		// @\{^̃Aj
		FuncButtonAnimation(wk->funcbutton, wk->clActWork, wk->mode);
		if(wk->wait > TOUCH_START_WAIT){
			*seq     = SEQ_MAIN;
			wk->wait = 0;
		}
		break;

	case SEQ_MAIN:
		// J[\ړ

		switch(wk->seq){
		case NAMEIN_MODE:

			// ʏ͐
			if(!wk->Cursor.decide){
				// ̓Aj͓Ȃ
				*seq = NameInputMainMode(wk, *seq);
			}

			// J[\Aj[V
			CursorAnimationControl( wk );

			break;
		case NAMEIN_MODE_BOXMSG:

			// |P̓{bNXɊi[ꂽ惁bZ[W
			SetBoxMessage( wk, proc );
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_TALK_WIN], 0x0f0f );
			BmpTalkWinWrite( &wk->NameInWin[BMP_TALK_WIN], WINDOW_TRANS_ON, NAMEIN_TALKWIN_CGX_OFFSET, FLD_MESFRAME_PAL );
			wk->msg_index = GF_STR_PrintSimple( &wk->NameInWin[BMP_TALK_WIN], FONT_TALK, wk->BoxMessage, 0, 0, 1, NULL );
			GF_BGL_BmpWinOn( &wk->NameInWin[BMP_TALK_WIN] );

			wk->seq = NAMEIN_MODE_BOXMSG_END;
			break;
		case NAMEIN_MODE_BOXMSG_END:
			// {bNXsbZ[W\҂
			if(GF_MSG_PrintEndCheck( wk->msg_index )==0){
				Snd_SePlay( NAMEIN_SE_END );
				wk->funcbutton[6]++;
				wk->wait = 0 ;
				wk->seq = NAMEIN_MODE_BOXMSG_END_WAIT;
			}
			break;
		case NAMEIN_MODE_BOXMSG_END_WAIT:
			// {bNXbZ[W\҂
			wk->wait++;
			if(wk->wait>30){
				WIPE_SYS_Start(WIPE_PATTERN_FSAM, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, 16, 1, HEAPID_NAMEIN );
				*seq = SEQ_OUT;
			}
			break;
		}

		// NGXgɕplւ
		PanelFunc(wk->bgl, &wk->NameInWin[BMP_WORDPANEL_BG0], &wk->seq, wk->mode, &wk->front, wk->panelpos, wk->clActWork, wk->BgCharaDat->pRawData);

		// @\{^̃Aj
		FuncButtonAnimation(wk->funcbutton, wk->clActWork, wk->mode);

		CursorColTrans(&wk->CursorPal);

		break;

	case SEQ_OUT:
//		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
		if( WIPE_SYS_EndCheck() ){
			return PROC_RES_FINISH;
		}
		break;
	}
	CLACT_Draw( wk->clactSet );									// ZAN^[풓֐

	return PROC_RES_CONTINUE;
}


//------------------------------------------------------------------
/**
 * @brief   O͒ʏ펞C
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static int NameInputMainMode( NAMEIN_WORK *wk, int seq )
{
			ControlCursor(wk);		//		DebugOBJPOSGet(wk);
			//TouchFunc(wk);
			if( sys.trg & PAD_BUTTON_SELECT){
				// thR[h͂̎̓pl؂ւ͂łȂ
				if(wk->inputmode!=NAMEIN_FRIENDCODE){
					// pl؂ւ
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/10/26
// y[Wؑ֎ɂ͖m̃nOm
#if PM_LANG == LANG_KOREA
					wk->log_num = 0;
					InputResultUnderLineMove(wk);
#endif
// ----------------------------------------------------------------------------
					wk->seq = NAMEIN_MODE_REQ;
					wk->mode++;
					// ----------------------------------------------------------------------------
					// localize_spec_mark(LANG_ALL) imatake 2006/10/03
					// {^3ނɕύX
					if(wk->mode>=FONT_BUTTON_NUM){
						wk->mode=NAMEIN_MODE_HIRA;
					}
					// ----------------------------------------------------------------------------
					wk->funcbutton[wk->mode]++;
					MakeWordMap(wk->wordmap, wk->mode);		// ̓}bvւ
					Snd_SePlay( NAMEIN_SE_CHANGEPANEL );
				}
				wk->funcbutton[wk->mode]++;
				MakeWordMap(wk->wordmap, wk->mode);		// ̓}bvւ
				Snd_SePlay( NAMEIN_SE_CHANGEPANEL );
#ifdef NAMEIN_MAINUSE_TOUCHPANEL
			}else if( sys.trg & PAD_BUTTON_A){
				// 
				seq = DecideMainButton(wk,wk->wordmap[wk->Cursor.y][wk->Cursor.x], 1);

				// ͌J[\\
				wk->Cursor.on = 1;
			}else if( wk->TP_decide == TRUE ){
				seq = DecideMainButton(wk,wk->wordmap[wk->Cursor.y][wk->Cursor.x], 0);

				// ͌J[\nee
				wk->Cursor.on = 0;
#else
			}else if( sys.trg & PAD_BUTTON_A){
#endif
			}else if( sys.trg & PAD_BUTTON_B ){
				// 
				seq = DecideMainButton(wk,NAMEIN_MODORU,1);

			}
			else if( sys.trg & PAD_BUTTON_R){
				seq = DecideMainButton( wk, NAMEIN_KOMOJI, 1 );
			}

	return seq;
}

#define DEFAULT_NAME_MAX		18

// _CEp[ŕς
#if (PM_VERSION==VERSION_DIAMOND)

#define MALE_NAME_START			( msg_opening_name_01 )
#define FEMALE_NAME_START		( msg_opening_name_19 )
#define RIVAL_NAME_NO			( msg_opening_rival_dia_01 )

#else

#define MALE_NAME_START			( msg_opening_name_45 )
#define FEMALE_NAME_START		( msg_opening_name_63 )
#define RIVAL_NAME_NO			( msg_opening_rival_pearl_01 )

#endif

//------------------------------------------------------------------
/**
 * @brief   ͖ŏI鎞ɃLZɂ邩
 *			ftHgl[邩
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InputCancelFunc( NAMEIN_WORK *wk, NAMEIN_PARAM *param )
{
	// ̖O͂̎̓LZ͖
	if(wk->inputmode==NAMEIN_MYNAME){
		STRBUF *DefaultName;
		if(wk->inputinfo==PM_MALE){
			DefaultName = MSGMAN_AllocString( wk->MsgDefaultName, MALE_NAME_START+gf_rand()%DEFAULT_NAME_MAX );
		}else if(wk->inputinfo==PM_FEMALE){
			DefaultName = MSGMAN_AllocString( wk->MsgDefaultName, FEMALE_NAME_START+gf_rand()%DEFAULT_NAME_MAX );
		}
		STRBUF_Copy(param->strbuf, DefaultName);
		STRBUF_Delete(DefaultName);
#ifdef USE_PARAM_STR
		STRBUF_GetStringCode( param->strbuf, param->str, 10 );
#endif

	// Co̎̓LZł͂ȂftHgl[
	}else if(wk->inputmode==NAMEIN_RIVALNAME){
		STRBUF *rivalName;
		rivalName = MSGMAN_AllocString( wk->MsgDefaultName, RIVAL_NAME_NO );
		STRBUF_Copy(param->strbuf, rivalName);
		STRBUF_Delete(rivalName);
#ifdef USE_PARAM_STR
		STRBUF_GetStringCode( param->strbuf, param->str, 10 );
#endif

	}else{
		OS_Printf("͂̓LZ\n");
		
		// LZ
		param->cancel = 1;
	}

}

//------------------------------------------------------------------
/**
 * @brief   ͕񂪑SăXy[XȂLZɂ`FbN
 *
 * @param   str		
 *
 * @retval  int		SăXy[X1,0
 */
//------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/10
// COłœ͂󔒂͔p
#if PM_LANG == LANG_JAPAN
#define DEFAULT_SPC		spc_
#else
#define DEFAULT_SPC		h_spc_
#endif
// ----------------------------------------------------------------------------

static int SpaceCheck( STRCODE *str )
{
	int flag=1;
	int i;
	for(i=0;;i++){
		if(str[i]==EOM_){
			break;
		}
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2007/01/10
		// COłœ͂󔒂͔p
		if(str[i]!=DEFAULT_SPC){
			flag = 0;
		}
		// ----------------------------------------------------------------------------
	}
	
	return flag;
}

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT NameInProc_End( PROC * proc, int * seq )
{
	NAMEIN_WORK  *wk    = PROC_GetWork( proc );
	NAMEIN_PARAM *param = (NAMEIN_PARAM*)PROC_GetParentWork(proc);
	int i;

	// ͕̍ŌEOMĂ
	wk->inputword[wk->nowinput] = EOM_;

	// |PO͂̎̃LẐ߂̏
	if(wk->inputmode==NAMEIN_POKEMON){
		// wk->paramstrɃftHg|P邩H
		STRCODE comparestr[MONS_NAME_SIZE+EOM_SIZE];
		POKEMON_PARAM *pp;

		OS_Printf("paramstr %02x, %02x, %02x, %02x, %02x, %02x,\n",
			wk->paramstr[0],wk->paramstr[1],wk->paramstr[2],wk->paramstr[3],wk->paramstr[4],wk->paramstr[5]
		);

		pp = PokemonParam_AllocWork(HEAPID_NAMEIN);
		PokeParaSet(pp,wk->inputinfo,5,10,10,10,10,10);
//		PokeParaGet(pp,ID_PARA_nickname, comparestr);
		sys_FreeMemoryEz(pp);

	}

	// LZȂH
	if(wk->nowinput==0 || (PM_strcmp( wk->inputword, wk->paramstr)==0) || SpaceCheck(wk->inputword)){

		InputCancelFunc( wk, param );

	}else{
		// ͕[Nɔf
		PM_strcpy(wk->paramstr,wk->inputword);
#ifdef USE_PARAM_STR
		PM_strcpy(param->str,wk->inputword);
#endif

		STRBUF_SetStringCode(param->strbuf,wk->inputword);
	}
	
	STRBUF_Delete(wk->GroupString);

	// @\{^ʒu^XN
	for(i=0;i<FUNCBUTTON_NUM;i++){
		PMDS_taskDel(wk->FuncButtonTask[i]);
	}
	// ZAN^[\[X

	// L]}l[W[j
	CLACT_U_CharManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES]);
	CLACT_U_CharManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES]);

	// pbg]}l[W[j
	CLACT_U_PlttManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES]);
	CLACT_U_PlttManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES]);
		
	// LEpbgEZEZAj̃\[X}l[W[j
	for(i=0;i<CLACT_RESOURCE_NUM;i++){
		CLACT_U_ResManagerDelete(wk->resMan[i]);
	}
	// ZAN^[Zbgj
	CLACT_DestSet(wk->clactSet);

	//OAM_[j
	REND_OAM_Delete();

	// BMPWINpLf[^
	sys_FreeMemory( HEAPID_NAMEIN, wk->BgCharaBuf );

	// |PACR
	if(wk->inputmode==NAMEIN_POKEMON){
		sys_FreeMemory( HEAPID_NAMEIN,wk->PokeIconBuf );
		sys_FreeMemory( HEAPID_NAMEIN,wk->PokeIconPalBuf );	
	}

	//bEChEpobt@
	GF_BGL_BGControlExit(wk->bgl, GF_BGL_FRAME3_S);

	DeleteCharManager();
	DeletePlttManager();

	// BMPEBhEJ
	BgExit(wk->bgl,wk->NameInWin);
	// BGL폜

	// 풓VXetHg
	FontProc_UnloadBitData(FONT_SYSTEM);


	GX_SetVisibleWnd( GX_WNDMASK_NONE );	//n[hEFAEChE

	// {^ptHg
	FontProc_UnloadFont( FONT_BUTTON );

//	StopTP();							// ^b`plI

	//|P]obt@mۂĂ
	if(wk->BoxMessage){
		STRBUF_Delete(wk->BoxMessage);
	}

	// u`̂Ȃ܂́Hv
	STRBUF_Delete(wk->TitleStr);
	//uv
	STRBUF_Delete(wk->ChangeWordStr);

	// bZ[W}l[W[E[hZbg}l[W[
	MSGMAN_Delete( wk->FightMsgManager );
	MSGMAN_Delete( wk->MsgDefaultName );
	MSGMAN_Delete( wk->MsgManager );
	WORDSET_Delete( wk->WordSet );

	PROC_FreeWork( proc );				// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	sys_DeleteHeap( HEAPID_NAMEIN );

#ifdef NAMEIN_MAINUSE_TOUCHPANEL
	{
		//ʔ]	add by tetsu
		sys.disp3DSW = DISP_3D_TO_MAIN;
		GF_Disp_DispSelect();
	}
#endif
	return PROC_RES_FINISH;
}

//==============================================================================
/**
 * O͂ɓnp[^mۂiO͂̌ʂ̂ŁAĂяoHEAPIDKvj
 *
 * @param   HeapId		ĂяoHEAPID
 * @param   mode		O̓[h(NAMEIN_MYNAME,NAMEIN_BOX,NAMEIN_POKEMON)
 * @param   info		NAMEIN_MYNAME̎0=j1=, NAMEIN_POKEMON̎͊JNO
 * @param   wordmax		͕ő吔̎w
 *
 * @retval  NAMEIN_PARAM *		mۂꂽO̓p[^̃|C^
 */
//==============================================================================
NAMEIN_PARAM *NameIn_ParamAllocMake(int HeapId, int mode, int info, int wordmax, CONFIG *config)
{
	NAMEIN_PARAM *param;
	
	
	param = (NAMEIN_PARAM*)sys_AllocMemory(HeapId, sizeof(NAMEIN_PARAM));

	param->mode    = mode;		// ̓[hi̖OA|PA{bNXj
	param->info    = info;		// ijEA|P̊JNO)
	param->wordmax = wordmax;	// ͕ő吔
	param->cancel  = 0;			// LZtO
#ifdef USE_PARAM_STR
	param->str[0]  = EOM_;
#endif

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/07/04
	// STRBUF ̃TCYA̓[hɂ炸őlɌŒ
	param->strbuf = STRBUF_Create( INPUT_WORD_MAX, HeapId );
	// ----------------------------------------------------------------------------


	// |Pߊl̎Ƀ{bNX]ɂ͎gp郁o
	param->get_msg_id  = 0;		// |PߊlbZ[WID
	param->boxdata     = NULL;	// |P{bNXf[^ւ̃|C^
	param->sex		   = 0;
	param->config      = config;
	param->form		   = 0;

	return param;
}

//==============================================================================
/**
 * O̓p[^̉iO͌Ƀ[U[O擾Ă炤j
 *
 * @param   param		
 *
 * @retval  none		
 */
//==============================================================================
void NameIn_ParamDelete(NAMEIN_PARAM *param)
{
	GF_ASSERT((param->strbuf)!=NULL);
	GF_ASSERT((param)!=NULL);
	
	STRBUF_Delete(param->strbuf);
	sys_FreeMemoryEz(param);
}

//--------------------------------------------------------------------------------------------
/**
 * VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VBlankFunc( void * work )
{
	// ZAN^[
	// Vram]}l[W[s
	DoVramTransferManager();

	// _LOAM}l[WVram]
	REND_OAMTrans();	
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );
}

//==============================================================================
/**
 * O疼O͏p[^[炤
 *
 * @param   wk			O̓[Ñ|C^
 * @param   mode		̓[hinamein.henumQ
 * @param   info		͏ijE|PmnȂ
 * @param   wordmax		͕ő吔
 *
 * @retval  none		
 */
//==============================================================================
static void SetNameInWorkParameter(NAMEIN_WORK *wk, NAMEIN_PARAM *param)
{
	wk->inputmode = param->mode;
	wk->inputinfo = param->info;
	wk->inputform = param->form;
	wk->inputmax  = param->wordmax;
	wk->inputsex  = param->sex;
	wk->config    = param->config;
}

//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	// BG SYSTEM
	{	
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	// ʕ0
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );


	}

	// ʕ1
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x1000, 0, GF_BGL_SCRSIZ_512x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	// wi
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	// bEChEBG
//	{	
//		GF_BGL_BGCNT_HEADER TextBgCntDat = {
//			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
//			GX_BG_SCRBASE_0xd800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
//			0, 0, 0, FALSE
//		};
//		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
//		GF_BGL_ScrClear( ini, GF_BGL_FRAME3_M );
//	}




	// BUTTON (CHAR)
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_S );
	}

	// BG (CHAR)
//	{	
//		GF_BGL_BGCNT_HEADER TextBgCntDat = {
//			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
//			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
//			1, 0, 0, FALSE
//		};
//		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
//	}

	Namein_LCDOnOff( VISIBLE_OFF );

	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_NAMEIN );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_NAMEIN );

	// ʂ̃n[hEFAEChE0nm
	GX_SetVisibleWnd( GX_WNDMASK_W0 );
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_OBJ,1);
	G2_SetWndOutsidePlane(   GX_WND_PLANEMASK_BG0 
	                       | GX_WND_PLANEMASK_BG1 
	                       | GX_WND_PLANEMASK_BG2 
	                       | GX_WND_PLANEMASK_BG3 
	                       | GX_WND_PLANEMASK_OBJ,1);
	G2_SetWnd0Position(0, 0, 255, 64);

// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
/* {bNXŉʑsĂ疼OCsƖO͂̏ʂĂ܂oOΏ */
#if S2427_060821_FIX

	// At@uhw
	G2S_BlendNone();

#endif
// ----------------------------------------------------------------------------

}


//------------------------------------------------------------------
/**
 * $brief   O͉ʂ̕\nmEnee
 *
 * @param   flag		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void Namein_LCDOnOff( int flag)
{
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG0, flag);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG1, flag);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG2, flag);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_BG3, 0);
	GF_Disp_GX_VisibleControl( GX_BLEND_PLANEMASK_OBJ, flag);


    GF_Disp_GXS_VisibleControl( GX_BLEND_PLANEMASK_BG0,flag);
    GF_Disp_GXS_VisibleControl( GX_BLEND_PLANEMASK_BG1,0);
    GF_Disp_GXS_VisibleControl( GX_BLEND_PLANEMASK_OBJ,0);
	
}

//------------------------------------------------------------------
/**
 * O̓[N
 *
 * @param   wk		NAMEIN_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitWork(NAMEIN_WORK *wk, PROC * proc)
{
	NAMEIN_PARAM *param = (NAMEIN_PARAM*)PROC_GetParentWork(proc);
	wk->seq = NAMEIN_MODE;

	SetPanelFirstPos(wk->panelpos, 0);

	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+wk->front,       GF_BGL_SCROLL_X_SET, wk->panelpos[wk->front].x );
	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+wk->front,       GF_BGL_SCROLL_Y_SET, wk->panelpos[wk->front].y );
	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+((wk->front)^1), GF_BGL_SCROLL_X_SET, wk->panelpos[((wk->front)^1)].x );
	GF_BGL_ScrollSet( wk->bgl, GF_BGL_FRAME0_M+((wk->front)^1), GF_BGL_SCROLL_Y_SET, wk->panelpos[((wk->front)^1)].y );

#ifdef PM_DEBUG
	{
		int i;
		for(i=0;i<9;i++){
			wk->framenum[i][0] = main_button_info[i][0];
			wk->framenum[i][1] = main_button_info[i][1];
		}
	}
#endif

	wk->paramstr[0] = EOM_;
	// p[^[ŖĂSTRBUF̓WJ
	if(param->strbuf){
		STRBUF_GetStringCode(param->strbuf, wk->paramstr, INPUT_WORD_MAX);
	}

	MI_CpuFill16( wk->inputword, spc_,  INPUT_WORD_MAX*2 );


	// u`̂Ȃ܂́HvWJ
	if(wk->inputmode==NAMEIN_POKEMON){
		POKEMON_PARAM *pp;

		pp = PokemonParam_AllocWork(HEAPID_NAMEIN);
		PokeParaSet(pp,wk->inputinfo,5,10,10,10,10,10);
		WORDSET_RegisterPokeMonsName( wk->WordSet, 0, PPPPointerGet(pp) );
		sys_FreeMemoryEz(pp);
	}

	// IɃbZ[W\si|Pߊlj
	if(param->get_msg_id!=0){
		wk->endmode       = 1;
		OS_Printf("BOXDATA Addr = %08x\n",param->boxdata);
	}

	// u`̂Ȃ܂́Hv擾(|P̖OœWJ)
	wk->TitleStr      = MSGDAT_UTIL_AllocExpandString( wk->WordSet, wk->MsgManager, 
														NameinTitleStrTable[wk->inputmode], HEAPID_NAMEIN );
	
	// 
	wk->ChangeWordStr = MSGDAT_UTIL_AllocExpandString( wk->WordSet, wk->MsgManager, 
														NAMEIN_MSG_CHANGEWORD, HEAPID_NAMEIN );


	// uO[vv
	wk->GroupString   = MSGMAN_AllocString( wk->MsgManager, NAMEIN_MSG_TITLEINFO7 );

	// NAMEIN_PARAM.strɃftHgĂ΃J[\̈ʒu0ł͂ȂȂ
	wk->nowinput       = PM_strlen( wk->paramstr ); 
	wk->Cursor.x       = 0;	// ʒuuv̈ʒu
	wk->Cursor.y       = 1;	
	wk->Cursor.oldx    = -1;
	wk->Cursor.oldy    = -1;
	wk->Cursor.on      = 0;	
	wk->Cursor.decide  = 0;	
	wk->old_subbutton  = RECT_HIT_NONE;							// Ỏʃ{^
	wk->subbutton_mode = 0;
	wk->subbutton_work = 0;
	wk->inputword[wk->inputmax] = EOM_;


	// @\{^ԃ[N
	{
		int i;
		for(i=0;i<FUNCBUTTON_NUM;i++){
			wk->funcbutton[i]	= 0;
		}

		// ̓{^̏ݒ
		switch(wk->inputmode){
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/10/03
		// ͊{Iɑ啶
		case NAMEIN_FRIENDCODE:
			break;
		default:
			wk->funcbutton[NAMEIN_MODE_HIRA]    = 1;
			break;
		// ----------------------------------------------------------------------------
		}
	}
	
}

//------------------------------------------------------------------
/**
 * $brief   |PߊlŃ{bNXɍsbZ[Wo߂̏
 *
 * @param   wk		
 * @param   proc		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetBoxMessage( NAMEIN_WORK *wk, PROC * proc )
{
	STRBUF *name=NULL;

	NAMEIN_PARAM *param = (NAMEIN_PARAM*)PROC_GetParentWork(proc);


	// 퓬烁bZ[WIDĂȂ
	if(param->get_msg_id!=0){
		int setbox,newbox;

		name = STRBUF_Create(200,HEAPID_NAMEIN);

		// ̓{bNXuHHHvɓ]܂
		wk->BoxMessage = NULL;

		setbox = BOXDAT_GetCureentTrayNumber(param->boxdata);
		newbox = BOXDAT_GetEmptyTrayNumber(param->boxdata);
		
		// ]{bNXݒ
		WORDSET_RegisterBoxTrayName( wk->WordSet, 1, param->boxdata, setbox );


		// ݓ]ƁAۂ̓]悪Ⴄꍇ͐V]於擾
		if(setbox!=newbox){
			WORDSET_RegisterBoxTrayName( wk->WordSet, 2, param->boxdata, newbox );
			param->get_msg_id+=2;
		}else{
			WORDSET_RegisterBoxTrayName( wk->WordSet, 2, param->boxdata, setbox );
		}

		// ͕𖼑Oobt@ɔf
		if(wk->nowinput==0 || SpaceCheck(wk->inputword)){
			// O͂ĂȂ̂ŁAftHgl[
			POKEMON_PARAM	*poke = PokemonParam_AllocWork(HEAPID_NAMEIN);
			PokeParaSet( poke, wk->inputinfo,1,0,0,0,0,0);
			WORDSET_RegisterPokeMonsName( wk->WordSet,  0, PPPPointerGet(poke) );
			sys_FreeMemoryEz(poke);
		}else{
			// O͂Ă
			wk->inputword[wk->nowinput] = EOM_;
			STRBUF_SetStringCode( name, wk->inputword );
			WORDSET_RegisterWord( wk->WordSet, 0, name, 0, 0, 0 );
		}
		wk->BoxMessage    = MSGDAT_UTIL_AllocExpandString( wk->WordSet, wk->FightMsgManager, param->get_msg_id, HEAPID_NAMEIN );
		wk->endmode       = 1;

		STRBUF_Delete(name);

	}
	
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgExit( GF_BGL_INI * ini, GF_BGL_BMPWIN *win )
{
	int i;
//	GF_Disp_GX_VisibleControl(
//		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
//		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
//	GF_Disp_GXS_VisibleControl(
//		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	for(i=0;i<BMP_NAMEIN_MAX;i++){
		GF_BGL_BmpWinDel( &win[i] );
	}

//	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
//	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );

	sys_FreeMemory( HEAPID_NAMEIN, ini );
}



//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgGraphicSet( NAMEIN_WORK * wk )
{
	GF_BGL_INI *bgl = wk->bgl;

	// ㉺ʂafpbg]
	ArcUtil_PalSet(    ARC_NAMEIN_GRA,  NARC_namein_name_bg_NCLR, PALTYPE_MAIN_BG, 0, 16*3*2,  HEAPID_NAMEIN);
//	ArcUtil_PalSet(    ARC_NAMEIN_GRA,  NARC_namein_name_bg_NCLR, PALTYPE_SUB_BG,  0, 16*3*2,  HEAPID_NAMEIN);
	ArcUtil_PalSet(    ARC_POKETCH_IMG, NARC_poketch_before_nclr, PALTYPE_SUB_BG, 0, 16*2,  HEAPID_NAMEIN);
	
	// obNhbvpbgONA
	GF_BGL_BackGroundColorSet( GF_BGL_FRAME0_S, 0 );

	// BG2L]
	ArcUtil_BgCharSet( ARC_NAMEIN_GRA, NARC_namein_name_bg_m_lz_NCGR, bgl, GF_BGL_FRAME2_M, 0, NAMEIN_BG2GRAPHIC_SIZE, 1, HEAPID_NAMEIN);

	// BG2XN[]
	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_m_lz_NSCR, bgl, GF_BGL_FRAME2_M, 0, 32*24*2, 1, HEAPID_NAMEIN);


	// BG1L]
	ArcUtil_BgCharSet( ARC_NAMEIN_GRA, NARC_namein_name_bg_m_lz_NCGR, bgl, GF_BGL_FRAME1_M, 0, 32*8*0x20, 1, HEAPID_NAMEIN);
	// BG1XN[]
	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_screen1_lz_NSCR, bgl, GF_BGL_FRAME1_M, 0, WORDPANEL_TRANS_SIZE, 1, HEAPID_NAMEIN);
	// BG0XN[]
	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_screen2_lz_NSCR, bgl, GF_BGL_FRAME0_M, 0, WORDPANEL_TRANS_SIZE, 1, HEAPID_NAMEIN);
	
	// bEChELf[^]
//	TalkWinGraphicSet( wk->bgl, GF_BGL_FRAME3_M, NAMEIN_TALKWIN_CGX_OFFSET, FLD_MESFRAME_PAL, 0, HEAPID_NAMEIN );
	TalkFontPaletteLoad( PALTYPE_MAIN_BG, TALK_MSG_WIN_PAL*32, HEAPID_NAMEIN );

	TalkWinGraphicSet( wk->bgl, GF_BGL_FRAME0_S, NAMEIN_TALKWIN_CGX_OFFSET, 
						FLD_MESFRAME_PAL, CONFIG_GetWindowType(wk->config), HEAPID_NAMEIN );
	TalkFontPaletteLoad( PALTYPE_SUB_BG, TALK_MSG_WIN_PAL*32, HEAPID_NAMEIN );

	// BG0L]
	// BG0XN[]
//	ArcUtil_BgCharSet( ARC_NAMEIN_GRA, NARC_namein_name_bg_s_lz_NCGR, bgl, GF_BGL_FRAME0_S, 0, 32*2*0x20, 1, HEAPID_NAMEIN);
//	ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);

//	ArcUtil_BgCharSet( ARC_POKETCH_IMG, NARC_poketch_before_lz_ncgr, bgl, GF_BGL_FRAME0_S, 0, 0, 1, HEAPID_NAMEIN);
//	ArcUtil_ScrnSet(   ARC_POKETCH_IMG, NARC_poketch_before_lz_nscr, bgl, GF_BGL_FRAME0_S, 0, 0, 1, HEAPID_NAMEIN);


	// BMPWIN]pLp(BgCharaBuf͖O͏IɉKvj
	wk->BgCharaBuf = ArcUtil_CharDataGet( ARC_NAMEIN_GRA, NARC_namein_name_bg_prog_lz_NCGR, 1, &wk->BgCharaDat, HEAPID_NAMEIN );

}


//** CharManager PlttManagerp **//
#define NAMEIN_CHAR_CONT_NUM				(20)
#define NAMEIN_CHAR_VRAMTRANS_MAIN_SIZE		(2048)
#define NAMEIN_CHAR_VRAMTRANS_SUB_SIZE		(2048)
#define NAMEIN_PLTT_CONT_NUM				(20)

//-------------------------------------
//
//	LN^}l[W[
//	pbg}l[W[̏
//
//=====================================
void char_pltt_manager_init(void)
{
	// LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			NAMEIN_CHAR_CONT_NUM,
			NAMEIN_CHAR_VRAMTRANS_MAIN_SIZE,
			NAMEIN_CHAR_VRAMTRANS_SUB_SIZE,
			HEAPID_NAMEIN
		};
		InitCharManager(&cm);
	}
	// pbg}l[W[
	InitPlttManager(NAMEIN_PLTT_CONT_NUM, HEAPID_NAMEIN);

	// ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();
}


//------------------------------------------------------------------
/**
 * [_[ʗpZAN^[
 *
 * @param   wk		[_[\̂̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitCellActor(NAMEIN_WORK *wk)
{
	int i;
	
	
	// OAM}l[W[̏
	NNS_G2dInitOamManagerModule();

	// LOAM}l[W쐬
	// _pOAM}l[W쐬
	// ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			0, 128,		// COAMǗ̈
			0, 32,		// CʃAtBǗ̈
			0, 128,		// TuOAMǗ̈
			0, 32,		// TuʃAtBǗ̈
			HEAPID_NAMEIN);
	
	
	
	// ZAN^[
	wk->clactSet = CLACT_U_SetEasyInit( 40+4, &wk->renddata, HEAPID_NAMEIN );
	
	CLACT_U_SetSubSurfaceMatrix( &wk->renddata, 0, NAMEIN_SUB_ACTOR_DISTANCE );

	
	//\[X}l[W[
	for(i=0;i<CLACT_RESOURCE_NUM;i++){		//\[X}l[W[쐬
		wk->resMan[i] = CLACT_U_ResManagerInit(2, i, HEAPID_NAMEIN);
	}


	//---------ʗp-------------------

	//charaǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_NAMEIN_GRA, NARC_namein_name_obj_m_lz_NCGR, 1, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_NAMEIN);

	//palǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_NCLR, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 9, HEAPID_NAMEIN);

	//cellǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_m_lz_NCER, 1, 0, CLACT_U_CELL_RES,HEAPID_NAMEIN);

	//֐animǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_m_lz_NANR, 1, 0, CLACT_U_CELLANM_RES,HEAPID_NAMEIN);

	// |P̖O͂̏ꍇ̓ACRf[^ǂݍ
	if(wk->inputmode==NAMEIN_POKEMON){
		wk->PokeIconBuf    = ArcUtil_CharDataGet( ARC_POKEICON, 
								PokeIconCgxArcIndexGetByMonsNumber( wk->inputinfo, 0, wk->inputform ), 
								0, 
								&wk->PokeIconCharaDat, HEAPID_NAMEIN );
		DC_FlushRange(wk->PokeIconCharaDat,0x20*4*4);

		wk->PokeIconPalBuf = ArcUtil_PalDataGet( ARC_POKEICON, PokeIconPalArcIndexGet(), &wk->PokeIconPalDat, HEAPID_NAMEIN );
		DC_FlushRange(wk->PokeIconPalDat,0x20*4);	
	}
//	ArcUtil_PalDataGet( u32 fileIdx, u32 dataIdx, NNSG2dPaletteData** palData, u32 heapID );

	//---------ʗp-------------------



	//charaǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_NAMEIN_GRA, NARC_namein_name_obj_s_lz_NCGR, 1, 1, NNS_G2D_VRAM_TYPE_2DSUB, HEAPID_NAMEIN);

	//palǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_NCLR, 0, 1, NNS_G2D_VRAM_TYPE_2DSUB, 3, HEAPID_NAMEIN);

	//cellǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_s_lz_NCER, 1, 1, CLACT_U_CELL_RES,HEAPID_NAMEIN);

	//֐animǂݍ
	wk->resObjTbl[SUB_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_NAMEIN_GRA, NARC_namein_name_obj_s_lz_NANR, 1, 1, CLACT_U_CELLANM_RES,HEAPID_NAMEIN);

	// \[X}l[W[]

	// Chara]
	CLACT_U_CharManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
	CLACT_U_CharManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] );

	// pbg]
	CLACT_U_PlttManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
	CLACT_U_PlttManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] );

}

typedef struct{
	CLACT_WORK_PTR parent;
	CLACT_WORK_PTR child;
	int dx;
	int id;
}FUNC_BUTTON_TASK_WORK;


//------------------------------------------------------------------
/**
 * @\{^plt[Ɠ悤ɂ鏈
 *
 * @param   tcb		
 * @param   work	
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void FuncButtonTaskFunc( TCB_PTR tcb, void *work )
{
	const VecFx32 *pVex;
	VecFx32 cVex;
	FUNC_BUTTON_TASK_WORK *wk = (FUNC_BUTTON_TASK_WORK*)work;

	pVex   = CLACT_GetMatrix(wk->parent);
	cVex.x = pVex->x + wk->dx;
	cVex.y = FX32_ONE*main_button_info[wk->id][1];
	cVex.z = 0;
	CLACT_SetMatrix(wk->child, &cVex);
}



//------------------------------------------------------------------
/**
 * ZAN^[o^
 *
 * @param   wk			NAMEIN_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetCellActor(NAMEIN_WORK *wk)
{
	int i;
	// ZAN^[wb_쐬
	CLACT_U_MakeHeader(&wk->clActHeader_m, 0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 1,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	CLACT_U_MakeHeader(&wk->clActHeader_s, 1, 1, 1, 1, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	{
		//o^i[
		CLACT_ADD add;

		add.ClActSet	= wk->clactSet;
		add.ClActHeader	= &wk->clActHeader_m;

		add.mat.x		= FX32_CONST(32) ;
		add.mat.y		= FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINASUBj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 1;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_NAMEIN;

		//ZAN^[\Jn

		// ʗp
		for(i=0;i<9;i++){
			add.mat.x = FX32_ONE*main_button_info[i][0];
			add.mat.y = FX32_ONE*main_button_info[i][1];
			wk->clActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->clActWork[i],1);
			CLACT_AnmChg( wk->clActWork[i], main_button_info[i][2] );
			CLACT_DrawPriorityChg(wk->clActWork[i], main_button_info[i][3]);	// ꂼ̃AN^[̃vCIeBݒ
			
		}
		CLACT_SetDrawFlag( wk->clActWork[4], 0);
		CLACT_SetDrawFlag( wk->clActWork[8], 0);
		
		// @\{^plo[ɓēo^
		for(i=0;i<7;i++){
			FUNC_BUTTON_TASK_WORK *twk;
			wk->FuncButtonTask[i] = PMDS_taskAdd(FuncButtonTaskFunc, 16, 5, HEAPID_NAMEIN);
			twk         = TCB_GetWork(wk->FuncButtonTask[i]);
			twk->parent = wk->clActWork[FUNCBUTTON_FRAME_ACTNO];
			twk->child  = wk->clActWork[i];
			twk->dx     = FX32_ONE*main_button_info[i][0];
			twk->id     = i;
		}

		//O͌ʃA_[C
		for(i=0;i<wk->inputmax;i++){
			add.mat.x = FX32_ONE*(NAMELINE_POS_X+i*12);
			add.mat.y = FX32_ONE*NAMELINE_POS_Y;
			wk->NameLineActWork[i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->NameLineActWork[i],1);
			CLACT_AnmChg( wk->NameLineActWork[i], 43 );
		}
		// Pڂ̃A_[C㉺ɓ
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂́Ả̃o[𓮂悤ɕύX
#if PM_LANG == LANG_KOREA
		InputResultUnderLineMove(wk);
#else
		InputResultUnderLineMove(wk->NameLineActWork, wk->nowinput, wk->inputmax);
#endif
// ----------------------------------------------------------------------------

		// O̓ACR\o^i[hɂĐ؂ւj
		NameinIconAdd( wk, &add );
		
#ifdef DEBUG_OAM_POSPRINT
		// |CgmFp
		for(i=0;i<4;i++){
			testclact[i] = CLACT_Add(&add);
			CLACT_AnmChg( testclact[i], 56+i );
		}

#endif


#ifndef NAMEIN_MAINUSE_TOUCHPANEL
		// ʗp
		for(i=0;i<2;i++){
			add.ClActHeader	= &wk->clActHeader_s;
			add.mat.x = FX32_ONE*sub_button_info[i][0];
			add.mat.y = FX32_ONE*(sub_button_info[i][1]) + NAMEIN_SUB_ACTOR_DISTANCE;
			add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
			wk->clActWork[10+i] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->clActWork[10+i],1);
			CLACT_AnmChg( wk->clActWork[10+i], sub_button_info[i][2] );
		}
#endif		
	}	
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
	
}

static void NameinIconAdd(NAMEIN_WORK *wk, CLACT_ADD *add )
{
		// ͐pACRi@AʁAp\RA|PȂǁj
		add->mat.x = FX32_ONE*NAMEIN_MYICON_X;
		add->mat.y = FX32_ONE*NAMEIN_MYICON_Y;
		wk->NameIconActWork[0] = CLACT_Add(add);
		CLACT_SetAnmFlag(wk->NameIconActWork[0],1);
		switch(wk->inputmode){
		// l
		case NAMEIN_MYNAME:
			if(wk->inputinfo==PM_MALE){
				CLACT_AnmChg( wk->NameIconActWork[0], 48 );	//j
			}else{
				CLACT_AnmChg( wk->NameIconActWork[0], 49 );	//j
			}
			break;
		// Co
		case NAMEIN_RIVALNAME:
			CLACT_AnmChg( wk->NameIconActWork[0], 51 );	
			break;
		// Δ
		case NAMEIN_STONE:
			CLACT_AnmChg( wk->NameIconActWork[0], 55 );	
			break;
		// _O[v
		case NAMEIN_RANDOMGROUP:
			CLACT_AnmChg( wk->NameIconActWork[0], 54 );	
			break;
		// ƂR[h
		case NAMEIN_FRIENDCODE:
		case NAMEIN_FRIENDNAME:
			CLACT_AnmChg( wk->NameIconActWork[0], 53 );	
			break;
		// p\R
		case NAMEIN_BOX:
//			wk->NameIconActWork[0] = CLACT_Add(add);
			CLACT_AnmChg( wk->NameIconActWork[0], 47 );
			break;
		// |PACR
		case NAMEIN_POKEMON:
			CLACT_AnmChg( wk->NameIconActWork[0], 50 );
			// ʃACR(ʖłȂ΁j
			if(wk->inputsex!=PARA_UNK){
				add->mat.x = FX32_ONE*(NAMELINE_POS_X + wk->inputmax * 13);
				add->mat.y = FX32_ONE*NAMEIN_SEXICON_Y;
				wk->NameIconActWork[1] = CLACT_Add(add);
				if(wk->inputsex==PARA_MALE){
					CLACT_AnmChg( wk->NameIconActWork[1], 45 );	// 
				}else{
					CLACT_AnmChg( wk->NameIconActWork[1], 46 );	// 
				}
			}
			break;
		}

}


typedef struct{
	CLACT_WORK_PTR	frame;
	int				seq;
	int				dx;
	int				dy;
}QUAKE_FRAME_TASK_WORK;

static void QuakeFrameTaskFunc( TCB_PTR tcb, void *work )
{
	QUAKE_FRAME_TASK_WORK *wk = (QUAKE_FRAME_TASK_WORK *)work;
	VecFx32 tmp;
	tmp.y = wk->dy;
	tmp.z = 0;


	switch(wk->seq){
	case 0:
		tmp.x = wk->dx + 4*FX32_ONE;
		CLACT_SetMatrix(wk->frame, &tmp);
		
		break;
	case 2:
		tmp.x = wk->dx - 3*FX32_ONE;
		CLACT_SetMatrix(wk->frame, &tmp);
		break;
	case 4:
		tmp.x = wk->dx + 2*FX32_ONE;
		CLACT_SetMatrix(wk->frame, &tmp);
		break;
	case 6:
		tmp.x = wk->dx;
		CLACT_SetMatrix(wk->frame, &tmp);
		PMDS_taskDel(tcb);
		break;
	}
	wk->seq++;
}

//------------------------------------------------------------------
/**
 * plNGXgւ
 *
 * @param   seq			Jڏ
 * @param   mode		̓[hiȁEJiE`abELj
 * @param   front		OɗĂafʂۑĂ郏[N
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void PanelFunc(GF_BGL_INI *bgl,GF_BGL_BMPWIN *win, int *seq, int mode, int *frontBG, VecFx32 panelpos[], CLACT_WORK_PTR *clActWork,void *dakuten)
{
	int front = *frontBG;
	int back  = front^1;
	int i;
	switch(*seq){

	case NAMEIN_MODE_REQ:
		{
			u16 bgcol = wordpanel_bg_col[mode]|(wordpanel_bg_col[mode]<<4);
			// VĂ镶plʂ]
			ArcUtil_ScrnSet( ARC_NAMEIN_GRA, NARC_namein_name_screen1_lz_NSCR+mode, bgl, GF_BGL_FRAME0_M+front, 0, WORDPANEL_TRANS_SIZE, 1, HEAPID_NAMEIN);
			SetPanelFirstPos(panelpos, front);

			WordPanelSetUp(&win[front],bgcol, mode, GF_PRINTCOLOR_MAKE(0xe,0xf,0/*wordpanel_bg_col[mode]*/),dakuten);

			(*seq)++;
		}
		break;
    	
	case NAMEIN_MODE_SET:
		// QBGʂ̏WZbg
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_X_SET, HIDDENPANEL_POS_REGX );
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_Y_SET, WORDPANEL_POS_REGY   );
		(*seq)++;
		break;
    	
	case NAMEIN_MODE_ANIM:
		// BGʂړB
		// ʒu܂łXgbviVpl̓t[hj
		
		
		panelpos[front].x-=WORDPANEL_IN_SPEED;
		if(panelpos[front].x < WORDPANEL_POS_REGX+10){		// t[h炷
			QUAKE_FRAME_TASK_WORK *qtfw;
			TCB_PTR qt;
			
			qt          = PMDS_taskAdd(QuakeFrameTaskFunc, 16, 0, HEAPID_NAMEIN);
			qtfw        = TCB_GetWork(qt);
			qtfw->frame = clActWork[7];
			qtfw->seq   = 0;
			qtfw->dx    = CLACT_GetMatrix(clActWork[7])->x;
			qtfw->dy    = CLACT_GetMatrix(clActWork[7])->y;

			panelpos[front].x=WORDPANEL_POS_REGX;
			(*seq)++;
		}
		// ʒu܂ŗXgbv
		panelpos[back].y-=WORDPANEL_OUT_SPEED;
		if(panelpos[back].y < DOWNPANEL_POS_REGY){
			panelpos[back].y=DOWNPANEL_POS_REGY;
		}


		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_X_SET, panelpos[front].x );
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+back,  GF_BGL_SCROLL_Y_SET, panelpos[back].y );

		break;
    	
    case NAMEIN_MODE_ANIM_WAIT:
		// ʒu܂ŗXgbv
		panelpos[back].y-=WORDPANEL_OUT_SPEED;
		if(panelpos[back].y < DOWNPANEL_POS_REGY){
			panelpos[back].y=DOWNPANEL_POS_REGY;
		}


		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+front, GF_BGL_SCROLL_X_SET, panelpos[front].x );
		GF_BGL_ScrollSet( bgl, GF_BGL_FRAME0_M+back,  GF_BGL_SCROLL_Y_SET, panelpos[back].y );
		// BGʂړIV[PXI
		if(panelpos[front].x==WORDPANEL_POS_REGX && panelpos[back].y==DOWNPANEL_POS_REGY){
			(*seq)++;
			(*frontBG) ^=1;			//afʂ̏㉺ւ
			FrontBackBG_RegSet(bgl, *frontBG, panelpos);
			Snd_SePlay( SEQ_SE_DP_NAMEIN_01 );
		}
    	break;
	case NAMEIN_MODE:
		break;
    	

	}
}


//------------------------------------------------------------------
/**
 * @brief   bEChEɕ`s
 *
 * @param   bmp		
 * @param   inputmode		
 * @param   Title		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void PrintTalkInfoStr( GF_BGL_BMPWIN *bmp, int inputmode, STRBUF *Title )
{

	BmpTalkWinWrite( bmp, WINDOW_TRANS_ON, NAMEIN_TALKWIN_CGX_OFFSET, FLD_MESFRAME_PAL );

	/* wk->msg_index = */ GF_STR_PrintSimple( bmp, FONT_TALK, Title, 0, 0, MSG_ALLPUT, NULL );
	
	GF_BGL_BmpWinOn( bmp );
}
//------------------------------------------------------------------
/**
 * u`̂Ȃ܂́Hv`悷
 *
 * @param   bmp			`pBMPWIN\
 * @param   inputmode	̓[hiMYNAME,POKEMON,BOX)
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void PrintTitleInfoStr(GF_BGL_BMPWIN *bmp, int inputmode, STRBUF *Title)
{
	int x = 16;

	int length = FontProc_GetPrintStrWidth( FONT_SYSTEM, Title, 0 );

	// ͂O`悷邪AZ͏Eɓ
	if(length>130){
		x = 0;
	}

	GF_BGL_BmpWinDataFill( bmp, 0x0101 );

	GF_STR_PrintColor(	bmp, FONT_SYSTEM, Title, x, 0, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);

	GF_BGL_BmpWinOn( bmp );

}

//------------------------------------------------------------------
/**
 * BMPWINiplɃtHg`j
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BmpMessageSet(NAMEIN_WORK *wk, PROC* proc)
{
	// BG0ʗpipl1pjBMPEChEm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_WORDPANEL_BG0], GF_BGL_FRAME0_M,
						WORDPANEL_WIN_POSX, WORDPANEL_WIN_POSY, WORDPANEL_WIN_W, WORDPANEL_WIN_H, 1,  WORDPANEL0_WIN_OFFSET);

	// BG1ʗpipl2pjBMPEChEm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_WORDPANEL_BG1], GF_BGL_FRAME1_M,
						WORDPANEL_WIN_POSX, WORDPANEL_WIN_POSY, WORDPANEL_WIN_W, WORDPANEL_WIN_H, 1,  WORDPANEL1_WIN_OFFSET);

	//ŏɌĂʂȂ̂ŕpl`Ɠ]s
	// plEo^
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/03
	// ͊{Iɑ啶
	if(wk->inputmode==NAMEIN_FRIENDCODE){
		ArcUtil_ScrnSet( ARC_NAMEIN_GRA, NARC_namein_name_screen1_lz_NSCR+3, wk->bgl, GF_BGL_FRAME1_M, 0, WORDPANEL_TRANS_SIZE, 1, HEAPID_NAMEIN);
		wk->mode = NAMEIN_MODE_NUMCODE;
		MakeWordMap(wk->wordmap,4);			// ̂ݕ}bvWJ
		WordPanelSetUp( &wk->NameInWin[BMP_WORDPANEL_BG1],0x0a0a, 4, 
						GF_PRINTCOLOR_MAKE(0xe,0xf,0/*wordpanel_bg_col[3]*/),wk->BgCharaDat->pRawData);
	}else{
		wk->mode = NAMEIN_MODE_HIRA;
		MakeWordMap(wk->wordmap,0);			// Ђ炪ȕ}bvWJ
		WordPanelSetUp( &wk->NameInWin[BMP_WORDPANEL_BG1],0x0404, 0, 
						GF_PRINTCOLOR_MAKE(0xe,0xf,0/*wordpanel_bg_col[0]*/),wk->BgCharaDat->pRawData);
	}
	// ----------------------------------------------------------------------------




	// ʏ㕔bZ[WpBMPWINm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_TITLE_MES], GF_BGL_FRAME2_M,
						NAME_INFO_POSX, NAME_INFO_POSY, NAME_INFO_POSW, NAME_INFO_POSH, 0,  NAMEINFO_WIN_OFFSET);



	{
		int w =  ( (wk->inputmax*12) /8 )+1;	// 12dotŕKvȃL̎Zo

		// O\pBMPWINm
		GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_RESULT_NAME], GF_BGL_FRAME2_M,
							NAME_RESULT_POSX, NAME_RESULT_POSY, w, NAME_RESULT_POSH, 0,  NAMERESULT_WIN_OFFSET);
		GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );


		// uO[vv
		GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_GROUP_STRING], GF_BGL_FRAME2_M,
						NAME_RESULT_POSX+w-1, GROUP_TEXT_POSY, GROUP_TEXT_POSW, GROUP_TEXT_POSH, 0,  GROUP_TEXT_WIN_OFFSET);
		GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_GROUP_STRING], 0x0101 );
	}

	if(wk->inputmode==NAMEIN_RANDOMGROUP){
		PrintTitleInfoStr(&wk->NameInWin[BMP_GROUP_STRING], wk->inputmode, wk->GroupString );
		GF_BGL_BmpWinOn( &wk->NameInWin[BMP_GROUP_STRING] );
	}


	// BOXapɉbEChËmۂ
	GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_TALK_WIN], GF_BGL_FRAME0_S,
						TALK_MSG_WIN_PX, TALK_MSG_WIN_PY, TALK_MSG_WIN_SX, TALK_MSG_WIN_SY, TALK_MSG_WIN_PAL, BOX_MESAGGE_WIN_OFFSET);
	GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_TALK_WIN], 0x0f0f );
	

	// u`̂Ȃ܂́Hv\
	PrintTalkInfoStr(&wk->NameInWin[BMP_TALK_WIN], wk->inputmode, wk->TitleStr);


	// NAMEIN_PARAMɃftHg񂪓Ă甽f
	{
		NAMEIN_PARAM* param = (NAMEIN_PARAM*)PROC_GetParentWork(proc);

		if(wk->paramstr[0]!= EOM_)
		{
			PM_strcpy(wk->inputword,wk->paramstr);
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, 
									INPUT_WORD_SPACE, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);		
		}
	}
	
	// ʃ{^pBMPm
	{
		int i;
		// ú@΁@ρvȂ
		for(i=0;i<3;i++){
			// ǂOBJVRAMɓ]̂ŁABGʂ͂ǂł
			GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_SUB_BUTTON1+i], GF_BGL_FRAME2_M,	0, 0, 2, 2, 0,  SUB_BUTTON_WORD_OFFSET);
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_SUB_BUTTON1+i], 0 );
		}

		// uv
		// ǂOBJVRAMɓ]̂ŁABGʂ͂ǂł
		GF_BGL_BmpWinAdd(wk->bgl, &wk->NameInWin[BMP_SUB_STRING], GF_BGL_FRAME2_M,	0, 0, 16, 2, 0,  SUB_BUTTON_STRING_OFFSET);
		GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_SUB_STRING], 0 );


	}
}	

//------------------------------------------------------------------
/**
 * Bg0ʂBG1ʂ̃vCIeBRRς̂Ŋ֐
 *
 * @param   front	ǂ̖ʂɗ邩(0 or 1)
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void FrontBackBG_RegSet(GF_BGL_INI *bgl, int front, VecFx32 panelpos[])
{
	GF_BGL_PrioritySet( GF_BGL_FRAME0_M+front, 1 );
	GF_BGL_PrioritySet( GF_BGL_FRAME0_M+front^1, 2 );

}

//------------------------------------------------------------------
/**
 * pl̏Wۑ
 *
 * @param   panelpos[]		pl̈ʒu
 * @param   front				BG0ʂBG1ʂ̂ǂ炪ォ(0BG0)
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetPanelFirstPos(VecFx32 panelpos[], int front)
{
	panelpos[front].x   = HIDDENPANEL_POS_REGX;
    panelpos[front].y   = WORDPANEL_POS_REGY;
    panelpos[front^1].x = WORDPANEL_POS_REGX;
    panelpos[front^1].y = WORDPANEL_POS_REGY;
	
}

#ifdef PM_DEBUG
//------------------------------------------------------------------
/**
 * fobO\pOBJBG𓮂
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugOBJPOSGet(NAMEIN_WORK *wk)
{
		if( sys.cont & PAD_KEY_UP){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][1]--;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
		}
		if( sys.cont & PAD_KEY_DOWN){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][1]++;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
			
		}
		if( sys.cont & PAD_KEY_LEFT){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][0]--;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
			
		}
		if( sys.cont & PAD_KEY_RIGHT){
			VecFx32 tmpVex;
			wk->framenum[wk->frame][0]++;
			tmpVex.x = FX32_ONE*wk->framenum[wk->frame][0];
			tmpVex.y = FX32_ONE*wk->framenum[wk->frame][1];
			CLACT_SetMatrix(wk->clActWork[wk->frame], &tmpVex);
			OS_Printf("frame %d x=%d, y=%d\n",wk->frame, wk->framenum[wk->frame][0],wk->framenum[wk->frame][1]);
		}

}

#endif



#define MOVE_UP 	1
#define MOVE_DOWN 	2
#define MOVE_LEFT 	3
#define MOVE_RIGHT 	4

static const arrowtbl[][2]={{0,0},{0,-1},{0,1},{-1,0},{1,0}};

static int AroundWork(int w, int min, int max)
{
	if(w>=max){
		w = min;
	}
	if(w<min){
		w = max-1;
	}
	return w;
}

//------------------------------------------------------------------
/**
 * J[\ړ
 *
 * @param   wk		NAMEIN_WORK*
 * @param   arrow	ړtO
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void CursorMove(NAMEIN_WORK *wk, int arrow)
{
	int x,y;
	u16 old;
	
	if(arrow==0){
		return;
	}
	
	// cSKIP̗񂾂ƁA[vɓ̂ŗvCiƂȂ̗Ȃǁj
	old  = wk->wordmap[wk->Cursor.y][wk->Cursor.x];
	x    = AroundWork((wk->Cursor.x + arrowtbl[arrow][0]), 0, INPUT_WORD_W);
	y    = AroundWork((wk->Cursor.y + arrowtbl[arrow][1]), 0, INPUT_WORD_H);

	// Ẍړi@\{^EXLbv񏈗݁j
	while(wk->wordmap[y][x]==SKIP_ || (wk->wordmap[y][x]==old && wk->wordmap[y][x]>NAMEIN_BUTTON)){
//		OS_Printf(" %d, %d, \n",wk->wordmap[y][x], old, );

		if(wk->Cursor.oldy==0 && wk->wordmap[y][x]==SKIP_ && arrowtbl[arrow][1]!=0){	// {^̏ɂāA̍sSKIP
			x += wk->Cursor.lastxarrow;													// ꍇ̏iŌ̉ړ
			x = AroundWork(x, 0, INPUT_WORD_W);											// ƂĂĂ̕ɂ炷j
		}else{
			x += arrowtbl[arrow][0];													// ړ悪SKIP_ꍇ
			x = AroundWork(x, 0, INPUT_WORD_W);											// SKIP_ȂȂ܂ňړJԂ
			y += arrowtbl[arrow][1];
			y = AroundWork(y, 0, INPUT_WORD_H);
		}
	}
	
	// ŏIړi[
	wk->Cursor.x = x;	
	wk->Cursor.y = y;
}

//------------------------------------------------------------------
/**
 * J[\ړ
 *
 * @param   wk		NAMEIN_WORK*
 *
 * @retval  none	
 */
#ifdef NAMEIN_MAINUSE_TOUCHPANEL
static BOOL TouchPanelCheck( NAMEIN_WORK *wk );
#endif
//------------------------------------------------------------------
static void ControlCursor(NAMEIN_WORK *wk)
{
	int move  = 0;
	int arrow = 0;

	// L[͂ɑ΂ĈړŜ̈
	if( sys.repeat & PAD_KEY_UP){
		Snd_SePlay(NAMEIN_SE_MOVE);
		CLACT_SetDrawFlag( wk->clActWork[8], 1);
		arrow = MOVE_UP;
		move++;
	}
	if( sys.repeat & PAD_KEY_DOWN){
		Snd_SePlay(NAMEIN_SE_MOVE);
		CLACT_SetDrawFlag( wk->clActWork[8], 1);
		arrow = MOVE_DOWN;
		move++;
	}
	if( sys.repeat & PAD_KEY_LEFT){
		Snd_SePlay(NAMEIN_SE_MOVE);
		CLACT_SetDrawFlag( wk->clActWork[8], 1);
		arrow = MOVE_LEFT;
		move++;
	}
	if( sys.repeat & PAD_KEY_RIGHT){
		Snd_SePlay(NAMEIN_SE_MOVE);
		CLACT_SetDrawFlag( wk->clActWork[8], 1);
		arrow = MOVE_RIGHT;
		move++;
	}
	
	// I{^ʒu
	if( sys.trg & PAD_BUTTON_START){
		Snd_SePlay(NAMEIN_SE_MOVE);
		CLACT_SetDrawFlag( wk->clActWork[8], 1);
		wk->Cursor.x = 12;
		wk->Cursor.y = 0;
		move++;
	}
#ifdef NAMEIN_MAINUSE_TOUCHPANEL
	{
		if( ( wk->TP_decide = TouchPanelCheck( wk ) ) == TRUE ){
			arrow = 0;
			move++;
		}
	}
#endif
	// ړύX
	if(move){
		CursorMove(wk,arrow);				// J[\̈ړ肷
		CursorAppearUpDate(wk,arrow);	// ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
	}

}


//------------------------------------------------------------------
/**
 * ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
 * ̏ł΁A`̃J[\A{^̏łΒ`̃J[\
 * ̍XVs邱ƂŁATuʂ̒̃tHg̍XVs
 *
 * @param   wk			NAMEIN_WORK*
 * @param   arrow		ړ
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorAppearUpDate(NAMEIN_WORK *wk, int arrow)
{
	// J[\̗ɂ邩H
	if(wk->Cursor.y!=0){
		VecFx32 tmpVex;

		// ̗ɂ
		if(wk->Cursor.oldy==0 && wk->Cursor.oldy != wk->Cursor.y){		// OɃt@NV{^̏ɂ
			CLACT_AnmChg( wk->clActWork[8], NAMEIN_CURSOR_ANM_START );	// ʏJ[\ɃAN^[ύX
		}
		tmpVex.x = FX32_ONE*(MAIN_CURSOR_POSX+wk->Cursor.x*16);
		tmpVex.y = FX32_ONE*(MAIN_CURSOR_POSY+(wk->Cursor.y-1)*PANEL_H);
		CLACT_SetMatrix(wk->clActWork[CLACT_CURSOR_NUM], &tmpVex);
	}else{
		VecFx32 tmpVex;

		// {^̗ɂ
		int func_type = wk->wordmap[wk->Cursor.y][wk->Cursor.x]-NAMEIN_HIRA;
		tmpVex.x = FX32_ONE*func_button_pos_tbl[func_type];
		tmpVex.y = FX32_ONE*FUNC_BUTTON_POS_Y;
		CLACT_AnmChg( wk->clActWork[8], func_button_appear[func_type] );// {^ɑΉJ[\ɕύX
		CLACT_SetMatrix(wk->clActWork[CLACT_CURSOR_NUM], &tmpVex);

		
	}
	wk->CursorPal = 180;							// ړJ[\̃pbg͐ԂԂɖ߂
	CLACT_AnmFrameSet( wk->clActWork[8], 0 );		// ړJ[\̃Aj͍ŏ̃t[ɖ߂


	wk->Cursor.oldx       = wk->Cursor.x;
	wk->Cursor.oldy       = wk->Cursor.y;
	if(arrowtbl[arrow][0]!=0){
		wk->Cursor.lastxarrow = arrowtbl[arrow][0];
	}

}

//------------------------------------------------------------------
/**
 * Aj[Vɂ킹ĉʂ̃{^BG̃XN[
 *
 * @param   mode		
 * @param   work		
 * @param   bgl		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SubButtonBGFunc(int *mode, int *work, GF_BGL_INI *bgl)
{

	switch(*work){
	case 1:	case 5:
	// BG0XN[]
		ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s2_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);
		break;
	case 3:	
	// BG0XN[]
		ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s3_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);
		break;
	case 7:	
	// BG0XN[]
		ArcUtil_ScrnSet(   ARC_NAMEIN_GRA, NARC_namein_name_bg_s_lz_NSCR, bgl, GF_BGL_FRAME0_S, 0, 32*24*2, 1, HEAPID_NAMEIN);
		break;
	}


	// uvuv̍ۂɂworkグ
	if(mode!=0){		// 
		if(*work > 9 ){	// 6ȏɂ͂ȂȂ悤
			*work = 0;
			*mode  = 0;
		}
		*work += *mode;
	}
//	OS_Printf("mode = %d, work = %d\n",mode, *work);
}

//------------------------------------------------------------------
/**
 * ^b`plŉ{^ւ
 *
 * @param   wk		NAMEIN_WORK̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TouchFunc(NAMEIN_WORK *wk)
{
#ifndef NAMEIN_MAINUSE_TOUCHPANEL
	int button=-1,i;

	// ͏
	button=GF_TP_RectHitTrg( sub_button_hittbl );
	if(button != RECT_HIT_NONE && wk->subtouchword[button] != spc_){
//		DecideMainButton(wk,wk->subtouchword[button]);
		DecideMainButton(wk,NAMEIN_KOMOJI,1);				// ϊ{^ON
		CLACT_AnmChg( wk->clActWork[10], sub_button_info[0][2] );	// ʂ̕BGɍ킹ď㉺ɓ
		CLACT_AnmChg( wk->clActWork[11], sub_button_info[1][2]+1 );	// ʂ̕BGɍ킹ď㉺ɓ
		wk->subbutton_mode=1;
	}

	// ڂ̏
//	button=GF_TP_RectHitCont( sub_button_hittbl );

	SubButtonBGFunc(&wk->subbutton_mode, &wk->subbutton_work, wk->bgl);
#endif
}


//------------------------------------------------------------------
/**
 * J[\̃pbgύXi_Łj
 *
 * @param   CursorCol	sinɓnp[^i360܂Łj
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorColTrans(u16 *CursorCol)
{
	fx32  sin;
	GXRgb tmp;
	int   r,g,b;

	*CursorCol+=20;
	if(*CursorCol>360){
		*CursorCol = 0;
	}

	sin = Sin360R(*CursorCol);
	g   = 15 +( sin * 10 ) / FX32_ONE;
	tmp = GX_RGB(29,g,0);


	GX_LoadOBJPltt((u16*)&tmp, (16+13)*2, 2);
}



//------------------------------------------------------------------
/**
 * plɋϓȊԊuɕzu
 * v|[VitHgȂ̂ŉmFȂꕶzu
 *
 * uhvuKvu[s]vɑΉ(CODEDAKUTEN_,HANDAKUTEN_,SPACE_j
 * 12hbgzu鎖ɂB
 *
 * @param   win		bmp
 * @param   str		
 * @param   x		JnXij
 * @param   y		JnYij
 * @param   sw		MSG_ALLPUTMSG_NO_PUT
 * @param   color	5bitx3̃J[w
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void NameinWordPanelPrint(GF_BGL_BMPWIN *win, const u16 *str, int x,int y, int space, int sw, GF_PRINTCOLOR color, u8 *dakuten_Character)
{
	int i=0,w,dx;
	u16 word[2];
	STRBUF *strbuf_word;
	
	strbuf_word = STRBUF_Create( 2, HEAPID_NAMEIN );
	// ꕶo
	while(str[i]!=EOM_){
		// ꕶꍇ̏
		if(str[i]==DAKU_ || str[i]==HANDAKU_ || str[i]==SPACE_){
			u16 tmp = str[i] - NAMEIN_CODE;


			//12x12̓ꕶ`
			GF_BGL_BmpWinPrint(	win, (void*)&dakuten_Character[tmp*8*8*4/2],
				0, 0, 12, 12,
				x+i*space, y+2, 12, 12 );

		}else{
		// ʏ핶

			if(str[i]==SKIP_){		//XLbvL͕`悵Ȃ
				i++;
				continue;
			}
			word[0] = str[i];
			word[1] = EOM_;

			//tHg̉擾A12hbgzuƂ̍Zoĕ`
			w=FontProc_GetStrWidth( FONT_SYSTEM, word, 0 );
			dx = x+i*space+((space-w)/2);
			STRBUF_SetStringCode( strbuf_word, word );
			GF_STR_PrintColor(	win, FONT_SYSTEM, strbuf_word, dx, y, sw, color,NULL);

		}
		i++;
	}	
	STRBUF_Delete( strbuf_word );
}


static const u8 StringCharacterOffsetTable[]={
	96,104,80,88
};


static void *GF_STR_PrintCGXOnly(GF_BGL_BMPWIN * win, STRBUF *msg, u8 fnt_index,const   GF_PRINTCOLOR col)
{

	GF_STR_PrintColor(	win, fnt_index, msg, 0, 0, MSG_NO_PUT, col,NULL);

	return win->chrbuf;
}

//------------------------------------------------------------------
/**
 * ʂ̃{^ɏĂ镶LN^[]
 *
 * @param   win		WJBMPWIN\̂̃|C^
 * @param   tbl		u͂΂ρvȂǂ̕ϊe[ũ|C^BNULL
 * @param   code	ῗ̖ɓBtblƂ0
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void ChangeSubPanelButtonWord(GF_BGL_BMPWIN *win, const u16 *tbl, u8 *TransWork, STRBUF *ChangeWordStr)
{
	u16  word[SUB_BUTTON_STRING_MAX+1],i,n;
	void *objcharaadr;
	STRBUF *strbuf_word;

	GF_BGL_BmpWinDataFill( &win[3], 0 );
	
	// uv`
	objcharaadr=GF_STR_PrintCGXOnly(&win[3], ChangeWordStr, FONT_BUTTON, GF_PRINTCOLOR_MAKE(0xd,0x0e,0xf));

	// BMPŕ`悵obt@OBJɓ]Ĕf
	DC_FlushRange(objcharaadr,0x20*4*16);	
	for(i=0;i<4;i++){						
		FONTOAM_BmpCutOamSize( &win[3], 4, 2, 4*i, 0,  (char*)TransWork);
		DC_FlushRange(TransWork,0x20*4*2);	
		GXS_LoadOBJ(TransWork, StringCharacterOffsetTable[i]*0x20, 0x20*4*2);
	}


	// STRBUF쐬
	strbuf_word = STRBUF_Create(SUB_BUTTON_STRING_MAX+1, HEAPID_NAMEIN);
	
	// BMPWINŕLN^쐬AOBJVRAMɓ]鏈RJԂ
	for(i=0;i<3;i++){
		word[0] = tbl[i];
		word[1] = EOM_;
		GF_BGL_BmpWinDataFill( &win[i], 0 );

		// STRBUFɕϊABMPŃLN^[`
		STRBUF_SetStringCode( strbuf_word, word );
		objcharaadr=GF_STR_PrintCGXOnly(&win[i], strbuf_word, FONT_BUTTON, GF_PRINTCOLOR_MAKE(0xd,0x0e,0xf));

		// BMPŕ`悵obt@OBJɓ]Ĕf
		DC_FlushRange(objcharaadr,0x20*4);	
		GXS_LoadOBJ(objcharaadr, obj_word_offset[i]*0x20, 0x20*4);

	}

	STRBUF_Delete(strbuf_word);
}

//------------------------------------------------------------------
/**
 * J[\ړɁAʃ{^̒̕
 *
 * @param   win		GF_BGL_BMPWIN*
 * @param   code	R[h
 * @param   words	NAMEIN_WORK.subtouchword
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SubPanelButton_CharaChange(GF_BGL_BMPWIN *win, STRCODE *str,int pos, u16 *words, u8 *TransWork, STRBUF *ChangeWordStr)
{
	int i,r;
	const u16 *tbl = NULL;
	STRCODE code;

	if(pos==0){
		code = SPACE_;
	}else{
		code = str[pos-1];
	}

	// ꕶE{^̃R[h͑Sċ󔒕Ƃĕ\
	switch(code){
	case DAKU_			:	case HANDAKU_		:	case SPACE_			:	case SKIP_			:
	case NAMEIN_HIRA	:	case NAMEIN_KANA	:	case NAMEIN_ALPHA	:	case NAMEIN_KIGOU	:
	case NAMEIN_KOMOJI	:	case NAMEIN_MODORU	:	case NAMEIN_OWARI	:
		code = spc_;
	break;
	}
	
	for(i=0;i<3;i++){		// U
		words[i] = spc_;
	}
	words[0] = code;		// R[h

	if(code!=spc_){	
		// ϊe[uđEET
		for(i=0;i<sizeof(convert_tbl)/(3*2);i++){
			// ϊO̕
			if(convert_tbl[i][0]==code){
				for(r=0;r<3;r++){
					words[r] =  convert_tbl[i][r];	// e[uRs[
				}
				break;
			}
			// ϊ̏iړ͂ł悤ɂȂ̂Łj
			if(convert_tbl[i][2]==code){
				for(r=0;r<3;r++){
					words[r] =  convert_tbl[i][r];	// e[uRs[
				}
				break;
			}
		}
	}

	// WINBMPŏAOBJVRAMɓ]
	ChangeSubPanelButtonWord(win, words, TransWork, ChangeWordStr);
}



//------------------------------------------------------------------
/**
 * ݓ͕pl}bv쐬
 *
 * @param   map[][INPUT_WORD_W]		ޕ}bv[N
 * @param   no						plԍ(0-3)
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void MakeWordMap(u16 map[][INPUT_WORD_W], const int no)
{
	int i,j;
	
	//ʍŏĩ{^zuݒ
	for(i=0;i<INPUT_WORD_W;i++){
		map[0][i] = str_func_b[no][i];
	}
	
	for(j=0;j<INPUT_WORD_H-1;j++){
		for(i=0;i<INPUT_WORD_W;i++){
			map[1+j][i] = str_nametbl[no][j][i];
		}
	}
}

//------------------------------------------------------------------
/**
 * ͌
 *
 * @param   wk		NAMEIN_WORK*
 * @param   code	R[h({^Eꕶ܂)
 *
 * @retval  int		ʏSEQ_MAINBISEQ_OUT
 */
//------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/03
// nO͂ɑΉ
// localize_spec_mark(LANG_KOREA) imatake 2007/08/01
// nOSTRCODE`ړ

#if PM_LANG == LANG_KOREA

typedef u16 UNICODE;

#define IS_HANGUL(strcode)				((strcode) >= STRCODE_HANGUL_BASE       && (strcode) < (STRCODE_HANGUL_BASE + sizeof(str2uni_table) / sizeof(str2uni_table[0])))
#define IS_HANGUL_CONS(strcode)			((strcode) >= STRCODE_HANGUL_CONS_BASE  && (strcode) < (STRCODE_HANGUL_CONS_BASE  + STRCODE_HANGUL_CONS_NUM))
#define IS_HANGUL_VOWEL(strcode)		((strcode) >= STRCODE_HANGUL_VOWEL_BASE && (strcode) < (STRCODE_HANGUL_VOWEL_BASE + STRCODE_HANGUL_VOWEL_NUM))
#define IS_HANGUL_ELEMENT(strcode)		((strcode) >= STRCODE_HANGUL_CONS_BASE  && (strcode) < (STRCODE_HANGUL_CONS_BASE  + STRCODE_HANGUL_CONS_NUM + STRCODE_HANGUL_VOWEL_NUM))

static const UNICODE str2uni_table[] = {
	// nO
	0xAC00,0xAC01,0xAC04,0xAC07,0xAC08,0xAC09,0xAC0A,0xAC10,0xAC11,0xAC12,0xAC13,0xAC14,0xAC15,0xAC16,0xAC17,0xAC19,
	0xAC1A,0xAC1B,0xAC1C,0xAC1D,0xAC20,0xAC24,0xAC2C,0xAC2D,0xAC2F,0xAC30,0xAC31,0xAC38,0xAC39,0xAC3C,0xAC40,0xAC4B,
	0xAC4D,0xAC54,0xAC58,0xAC5C,0xAC70,0xAC71,0xAC74,0xAC77,0xAC78,0xAC7A,0xAC80,0xAC81,0xAC83,0xAC84,0xAC85,0xAC86,
	0xAC89,0xAC8A,0xAC8B,0xAC8C,0xAC90,0xAC94,0xAC9C,0xAC9D,0xAC9F,0xACA0,0xACA1,0xACA8,0xACA9,0xACAA,0xACAC,0xACAF,
	0xACB0,0xACB8,0xACB9,0xACBB,0xACBC,0xACBD,0xACC1,0xACC4,0xACC8,0xACCC,0xACD5,0xACD7,0xACE0,0xACE1,0xACE4,0xACE7,
	0xACE8,0xACEA,0xACEC,0xACEF,0xACF0,0xACF1,0xACF3,0xACF5,0xACF6,0xACFC,0xACFD,0xAD00,0xAD04,0xAD06,0xAD0C,0xAD0D,
	0xAD0F,0xAD11,0xAD18,0xAD1C,0xAD20,0xAD29,0xAD2C,0xAD2D,0xAD34,0xAD35,0xAD38,0xAD3C,0xAD44,0xAD45,0xAD47,0xAD49,
	0xAD50,0xAD54,0xAD58,0xAD61,0xAD63,0xAD6C,0xAD6D,0xAD70,0xAD73,0xAD74,0xAD75,0xAD76,0xAD7B,0xAD7C,0xAD7D,0xAD7F,
	0xAD81,0xAD82,0xAD88,0xAD89,0xAD8C,0xAD90,0xAD9C,0xAD9D,0xADA4,0xADB7,0xADC0,0xADC1,0xADC4,0xADC8,0xADD0,0xADD1,
	0xADD3,0xADDC,0xADE0,0xADE4,0xADF8,0xADF9,0xADFC,0xADFF,0xAE00,0xAE01,0xAE08,0xAE09,0xAE0B,0xAE0D,0xAE14,0xAE30,
	0xAE31,0xAE34,0xAE37,0xAE38,0xAE3A,0xAE40,0xAE41,0xAE43,0xAE45,0xAE46,0xAE4A,0xAE4C,0xAE4D,0xAE4E,0xAE50,0xAE54,
	0xAE56,0xAE5C,0xAE5D,0xAE5F,0xAE60,0xAE61,0xAE65,0xAE68,0xAE69,0xAE6C,0xAE70,0xAE78,0xAE79,0xAE7B,0xAE7C,0xAE7D,
	0xAE84,0xAE85,0xAE8C,0xAEBC,0xAEBD,0xAEBE,0xAEC0,0xAEC4,0xAECC,0xAECD,0xAECF,0xAED0,0xAED1,0xAED8,0xAED9,0xAEDC,
	0xAEE8,0xAEEB,0xAEED,0xAEF4,0xAEF8,0xAEFC,0xAF07,0xAF08,0xAF0D,0xAF10,0xAF2C,0xAF2D,0xAF30,0xAF32,0xAF34,0xAF3C,
	0xAF3D,0xAF3F,0xAF41,0xAF42,0xAF43,0xAF48,0xAF49,0xAF50,0xAF5C,0xAF5D,0xAF64,0xAF65,0xAF79,0xAF80,0xAF84,0xAF88,
	0xAF90,0xAF91,0xAF95,0xAF9C,0xAFB8,0xAFB9,0xAFBC,0xAFC0,0xAFC7,0xAFC8,0xAFC9,0xAFCB,0xAFCD,0xAFCE,0xAFD4,0xAFDC,
	0xAFE8,0xAFE9,0xAFF0,0xAFF1,0xAFF4,0xAFF8,0xB000,0xB001,0xB004,0xB00C,0xB010,0xB014,0xB01C,0xB01D,0xB028,0xB044,
	0xB045,0xB048,0xB04A,0xB04C,0xB04E,0xB053,0xB054,0xB055,0xB057,0xB059,0xB05D,0xB07C,0xB07D,0xB080,0xB084,0xB08C,
	0xB08D,0xB08F,0xB091,0xB098,0xB099,0xB09A,0xB09C,0xB09F,0xB0A0,0xB0A1,0xB0A2,0xB0A8,0xB0A9,0xB0AB,0xB0AC,0xB0AD,
	0xB0AE,0xB0AF,0xB0B1,0xB0B3,0xB0B4,0xB0B5,0xB0B8,0xB0BC,0xB0C4,0xB0C5,0xB0C7,0xB0C8,0xB0C9,0xB0D0,0xB0D1,0xB0D4,
	0xB0D8,0xB0E0,0xB0E5,0xB108,0xB109,0xB10B,0xB10C,0xB110,0xB112,0xB113,0xB118,0xB119,0xB11B,0xB11C,0xB11D,0xB123,
	0xB124,0xB125,0xB128,0xB12C,0xB134,0xB135,0xB137,0xB138,0xB139,0xB140,0xB141,0xB144,0xB148,0xB150,0xB151,0xB154,
	0xB155,0xB158,0xB15C,0xB160,0xB178,0xB179,0xB17C,0xB180,0xB182,0xB188,0xB189,0xB18B,0xB18D,0xB192,0xB193,0xB194,
	0xB198,0xB19C,0xB1A8,0xB1CC,0xB1D0,0xB1D4,0xB1DC,0xB1DD,0xB1DF,0xB1E8,0xB1E9,0xB1EC,0xB1F0,0xB1F9,0xB1FB,0xB1FD,
	0xB204,0xB205,0xB208,0xB20B,0xB20C,0xB214,0xB215,0xB217,0xB219,0xB220,0xB234,0xB23C,0xB258,0xB25C,0xB260,0xB268,
	0xB269,0xB274,0xB275,0xB27C,0xB284,0xB285,0xB289,0xB290,0xB291,0xB294,0xB298,0xB299,0xB29A,0xB2A0,0xB2A1,0xB2A3,
	0xB2A5,0xB2A6,0xB2AA,0xB2AC,0xB2B0,0xB2B4,0xB2C8,0xB2C9,0xB2CC,0xB2D0,0xB2D2,0xB2D8,0xB2D9,0xB2DB,0xB2DD,0xB2E2,
	0xB2E4,0xB2E5,0xB2E6,0xB2E8,0xB2EB,0xB2EC,0xB2ED,0xB2EE,0xB2EF,0xB2F3,0xB2F4,0xB2F5,0xB2F7,0xB2F8,0xB2F9,0xB2FA,
	0xB2FB,0xB2FF,0xB300,0xB301,0xB304,0xB308,0xB310,0xB311,0xB313,0xB314,0xB315,0xB31C,0xB354,0xB355,0xB356,0xB358,
	0xB35B,0xB35C,0xB35E,0xB35F,0xB364,0xB365,0xB367,0xB369,0xB36B,0xB36E,0xB370,0xB371,0xB374,0xB378,0xB380,0xB381,
	0xB383,0xB384,0xB385,0xB38C,0xB390,0xB394,0xB3A0,0xB3A1,0xB3A8,0xB3AC,0xB3C4,0xB3C5,0xB3C8,0xB3CB,0xB3CC,0xB3CE,
	0xB3D0,0xB3D4,0xB3D5,0xB3D7,0xB3D9,0xB3DB,0xB3DD,0xB3E0,0xB3E4,0xB3E8,0xB3FC,0xB410,0xB418,0xB41C,0xB420,0xB428,
	0xB429,0xB42B,0xB434,0xB450,0xB451,0xB454,0xB458,0xB460,0xB461,0xB463,0xB465,0xB46C,0xB480,0xB488,0xB49D,0xB4A4,
	0xB4A8,0xB4AC,0xB4B5,0xB4B7,0xB4B9,0xB4C0,0xB4C4,0xB4C8,0xB4D0,0xB4D5,0xB4DC,0xB4DD,0xB4E0,0xB4E3,0xB4E4,0xB4E6,
	0xB4EC,0xB4ED,0xB4EF,0xB4F1,0xB4F8,0xB514,0xB515,0xB518,0xB51B,0xB51C,0xB524,0xB525,0xB527,0xB528,0xB529,0xB52A,
	0xB530,0xB531,0xB534,0xB538,0xB540,0xB541,0xB543,0xB544,0xB545,0xB54B,0xB54C,0xB54D,0xB550,0xB554,0xB55C,0xB55D,
	0xB55F,0xB560,0xB561,0xB5A0,0xB5A1,0xB5A4,0xB5A8,0xB5AA,0xB5AB,0xB5B0,0xB5B1,0xB5B3,0xB5B4,0xB5B5,0xB5BB,0xB5BC,
	0xB5BD,0xB5C0,0xB5C4,0xB5CC,0xB5CD,0xB5CF,0xB5D0,0xB5D1,0xB5D8,0xB5EC,0xB610,0xB611,0xB614,0xB618,0xB625,0xB62C,
	0xB634,0xB648,0xB664,0xB668,0xB69C,0xB69D,0xB6A0,0xB6A4,0xB6AB,0xB6AC,0xB6B1,0xB6D4,0xB6F0,0xB6F4,0xB6F8,0xB700,
	0xB701,0xB705,0xB728,0xB729,0xB72C,0xB72F,0xB730,0xB738,0xB739,0xB73B,0xB744,0xB748,0xB74C,0xB754,0xB755,0xB760,
	0xB764,0xB768,0xB770,0xB771,0xB773,0xB775,0xB77C,0xB77D,0xB780,0xB784,0xB78C,0xB78D,0xB78F,0xB790,0xB791,0xB792,
	0xB796,0xB797,0xB798,0xB799,0xB79C,0xB7A0,0xB7A8,0xB7A9,0xB7AB,0xB7AC,0xB7AD,0xB7B4,0xB7B5,0xB7B8,0xB7C7,0xB7C9,
	0xB7EC,0xB7ED,0xB7F0,0xB7F4,0xB7FC,0xB7FD,0xB7FF,0xB800,0xB801,0xB807,0xB808,0xB809,0xB80C,0xB810,0xB818,0xB819,
	0xB81B,0xB81D,0xB824,0xB825,0xB828,0xB82C,0xB834,0xB835,0xB837,0xB838,0xB839,0xB840,0xB844,0xB851,0xB853,0xB85C,
	0xB85D,0xB860,0xB864,0xB86C,0xB86D,0xB86F,0xB871,0xB878,0xB87C,0xB88D,0xB8A8,0xB8B0,0xB8B4,0xB8B8,0xB8C0,0xB8C1,
	0xB8C3,0xB8C5,0xB8CC,0xB8D0,0xB8D4,0xB8DD,0xB8DF,0xB8E1,0xB8E8,0xB8E9,0xB8EC,0xB8F0,0xB8F8,0xB8F9,0xB8FB,0xB8FD,
	0xB904,0xB918,0xB920,0xB93C,0xB93D,0xB940,0xB944,0xB94C,0xB94F,0xB951,0xB958,0xB959,0xB95C,0xB960,0xB968,0xB969,
	0xB96B,0xB96D,0xB974,0xB975,0xB978,0xB97C,0xB984,0xB985,0xB987,0xB989,0xB98A,0xB98D,0xB98E,0xB9AC,0xB9AD,0xB9B0,
	0xB9B4,0xB9BC,0xB9BD,0xB9BF,0xB9C1,0xB9C8,0xB9C9,0xB9CC,0xB9CE,0xB9CF,0xB9D0,0xB9D1,0xB9D2,0xB9D8,0xB9D9,0xB9DB,
	0xB9DD,0xB9DE,0xB9E1,0xB9E3,0xB9E4,0xB9E5,0xB9E8,0xB9EC,0xB9F4,0xB9F5,0xB9F7,0xB9F8,0xB9F9,0xB9FA,0xBA00,0xBA01,
	0xBA08,0xBA15,0xBA38,0xBA39,0xBA3C,0xBA40,0xBA42,0xBA48,0xBA49,0xBA4B,0xBA4D,0xBA4E,0xBA53,0xBA54,0xBA55,0xBA58,
	0xBA5C,0xBA64,0xBA65,0xBA67,0xBA68,0xBA69,0xBA70,0xBA71,0xBA74,0xBA78,0xBA83,0xBA84,0xBA85,0xBA87,0xBA8C,0xBAA8,
	0xBAA9,0xBAAB,0xBAAC,0xBAB0,0xBAB2,0xBAB8,0xBAB9,0xBABB,0xBABD,0xBAC4,0xBAC8,0xBAD8,0xBAD9,0xBAFC,0xBB00,0xBB04,
	0xBB0D,0xBB0F,0xBB11,0xBB18,0xBB1C,0xBB20,0xBB29,0xBB2B,0xBB34,0xBB35,0xBB36,0xBB38,0xBB3B,0xBB3C,0xBB3D,0xBB3E,
	0xBB44,0xBB45,0xBB47,0xBB49,0xBB4D,0xBB4F,0xBB50,0xBB54,0xBB58,0xBB61,0xBB63,0xBB6C,0xBB88,0xBB8C,0xBB90,0xBBA4,
	0xBBA8,0xBBAC,0xBBB4,0xBBB7,0xBBC0,0xBBC4,0xBBC8,0xBBD0,0xBBD3,0xBBF8,0xBBF9,0xBBFC,0xBBFF,0xBC00,0xBC02,0xBC08,
	0xBC09,0xBC0B,0xBC0C,0xBC0D,0xBC0F,0xBC11,0xBC14,0xBC15,0xBC16,0xBC17,0xBC18,0xBC1B,0xBC1C,0xBC1D,0xBC1E,0xBC1F,
	0xBC24,0xBC25,0xBC27,0xBC29,0xBC2D,0xBC30,0xBC31,0xBC34,0xBC38,0xBC40,0xBC41,0xBC43,0xBC44,0xBC45,0xBC49,0xBC4C,
	0xBC4D,0xBC50,0xBC5D,0xBC84,0xBC85,0xBC88,0xBC8B,0xBC8C,0xBC8E,0xBC94,0xBC95,0xBC97,0xBC99,0xBC9A,0xBCA0,0xBCA1,
	0xBCA4,0xBCA7,0xBCA8,0xBCB0,0xBCB1,0xBCB3,0xBCB4,0xBCB5,0xBCBC,0xBCBD,0xBCC0,0xBCC4,0xBCCD,0xBCCF,0xBCD0,0xBCD1,
	0xBCD5,0xBCD8,0xBCDC,0xBCF4,0xBCF5,0xBCF6,0xBCF8,0xBCFC,0xBD04,0xBD05,0xBD07,0xBD09,0xBD10,0xBD14,0xBD24,0xBD2C,
	0xBD40,0xBD48,0xBD49,0xBD4C,0xBD50,0xBD58,0xBD59,0xBD64,0xBD68,0xBD80,0xBD81,0xBD84,0xBD87,0xBD88,0xBD89,0xBD8A,
	0xBD90,0xBD91,0xBD93,0xBD95,0xBD99,0xBD9A,0xBD9C,0xBDA4,0xBDB0,0xBDB8,0xBDD4,0xBDD5,0xBDD8,0xBDDC,0xBDE9,0xBDF0,
	0xBDF4,0xBDF8,0xBE00,0xBE03,0xBE05,0xBE0C,0xBE0D,0xBE10,0xBE14,0xBE1C,0xBE1D,0xBE1F,0xBE44,0xBE45,0xBE48,0xBE4C,
	0xBE4E,0xBE54,0xBE55,0xBE57,0xBE59,0xBE5A,0xBE5B,0xBE60,0xBE61,0xBE64,0xBE68,0xBE6A,0xBE70,0xBE71,0xBE73,0xBE74,
	0xBE75,0xBE7B,0xBE7C,0xBE7D,0xBE80,0xBE84,0xBE8C,0xBE8D,0xBE8F,0xBE90,0xBE91,0xBE98,0xBE99,0xBEA8,0xBED0,0xBED1,
	0xBED4,0xBED7,0xBED8,0xBEE0,0xBEE3,0xBEE4,0xBEE5,0xBEEC,0xBF01,0xBF08,0xBF09,0xBF18,0xBF19,0xBF1B,0xBF1C,0xBF1D,
	0xBF40,0xBF41,0xBF44,0xBF48,0xBF50,0xBF51,0xBF55,0xBF94,0xBFB0,0xBFC5,0xBFCC,0xBFCD,0xBFD0,0xBFD4,0xBFDC,0xBFDF,
	0xBFE1,0xC03C,0xC051,0xC058,0xC05C,0xC060,0xC068,0xC069,0xC090,0xC091,0xC094,0xC098,0xC0A0,0xC0A1,0xC0A3,0xC0A5,
	0xC0AC,0xC0AD,0xC0AF,0xC0B0,0xC0B3,0xC0B4,0xC0B5,0xC0B6,0xC0BC,0xC0BD,0xC0BF,0xC0C0,0xC0C1,0xC0C5,0xC0C8,0xC0C9,
	0xC0CC,0xC0D0,0xC0D8,0xC0D9,0xC0DB,0xC0DC,0xC0DD,0xC0E4,0xC0E5,0xC0E8,0xC0EC,0xC0F4,0xC0F5,0xC0F7,0xC0F9,0xC100,
	0xC104,0xC108,0xC110,0xC115,0xC11C,0xC11D,0xC11E,0xC11F,0xC120,0xC123,0xC124,0xC126,0xC127,0xC12C,0xC12D,0xC12F,
	0xC130,0xC131,0xC136,0xC138,0xC139,0xC13C,0xC140,0xC148,0xC149,0xC14B,0xC14C,0xC14D,0xC154,0xC155,0xC158,0xC15C,
	0xC164,0xC165,0xC167,0xC168,0xC169,0xC170,0xC174,0xC178,0xC185,0xC18C,0xC18D,0xC18E,0xC190,0xC194,0xC196,0xC19C,
	0xC19D,0xC19F,0xC1A1,0xC1A5,0xC1A8,0xC1A9,0xC1AC,0xC1B0,0xC1BD,0xC1C4,0xC1C8,0xC1CC,0xC1D4,0xC1D7,0xC1D8,0xC1E0,
	0xC1E4,0xC1E8,0xC1F0,0xC1F1,0xC1F3,0xC1FC,0xC1FD,0xC200,0xC204,0xC20C,0xC20D,0xC20F,0xC211,0xC218,0xC219,0xC21C,
	0xC21F,0xC220,0xC228,0xC229,0xC22B,0xC22D,0xC22F,0xC231,0xC232,0xC234,0xC248,0xC250,0xC251,0xC254,0xC258,0xC260,
	0xC265,0xC26C,0xC26D,0xC270,0xC274,0xC27C,0xC27D,0xC27F,0xC281,0xC288,0xC289,0xC290,0xC298,0xC29B,0xC29D,0xC2A4,
	0xC2A5,0xC2A8,0xC2AC,0xC2AD,0xC2B4,0xC2B5,0xC2B7,0xC2B9,0xC2DC,0xC2DD,0xC2E0,0xC2E3,0xC2E4,0xC2EB,0xC2EC,0xC2ED,
	0xC2EF,0xC2F1,0xC2F6,0xC2F8,0xC2F9,0xC2FB,0xC2FC,0xC300,0xC308,0xC309,0xC30C,0xC30D,0xC313,0xC314,0xC315,0xC318,
	0xC31C,0xC324,0xC325,0xC328,0xC329,0xC345,0xC368,0xC369,0xC36C,0xC370,0xC372,0xC378,0xC379,0xC37C,0xC37D,0xC384,
	0xC388,0xC38C,0xC3C0,0xC3D8,0xC3D9,0xC3DC,0xC3DF,0xC3E0,0xC3E2,0xC3E8,0xC3E9,0xC3ED,0xC3F4,0xC3F5,0xC3F8,0xC408,
	0xC410,0xC424,0xC42C,0xC430,0xC434,0xC43C,0xC43D,0xC448,0xC464,0xC465,0xC468,0xC46C,0xC474,0xC475,0xC479,0xC480,
	0xC494,0xC49C,0xC4B8,0xC4BC,0xC4E9,0xC4F0,0xC4F1,0xC4F4,0xC4F8,0xC4FA,0xC4FF,0xC500,0xC501,0xC50C,0xC510,0xC514,
	0xC51C,0xC528,0xC529,0xC52C,0xC530,0xC538,0xC539,0xC53B,0xC53D,0xC544,0xC545,0xC548,0xC549,0xC54A,0xC54C,0xC54D,
	0xC54E,0xC553,0xC554,0xC555,0xC557,0xC558,0xC559,0xC55D,0xC55E,0xC560,0xC561,0xC564,0xC568,0xC570,0xC571,0xC573,
	0xC574,0xC575,0xC57C,0xC57D,0xC580,0xC584,0xC587,0xC58C,0xC58D,0xC58F,0xC591,0xC595,0xC597,0xC598,0xC59C,0xC5A0,
	0xC5A9,0xC5B4,0xC5B5,0xC5B8,0xC5B9,0xC5BB,0xC5BC,0xC5BD,0xC5BE,0xC5C4,0xC5C5,0xC5C6,0xC5C7,0xC5C8,0xC5C9,0xC5CA,
	0xC5CC,0xC5CE,0xC5D0,0xC5D1,0xC5D4,0xC5D8,0xC5E0,0xC5E1,0xC5E3,0xC5E5,0xC5EC,0xC5ED,0xC5EE,0xC5F0,0xC5F4,0xC5F6,
	0xC5F7,0xC5FC,0xC5FD,0xC5FE,0xC5FF,0xC600,0xC601,0xC605,0xC606,0xC607,0xC608,0xC60C,0xC610,0xC618,0xC619,0xC61B,
	0xC61C,0xC624,0xC625,0xC628,0xC62C,0xC62D,0xC62E,0xC630,0xC633,0xC634,0xC635,0xC637,0xC639,0xC63B,0xC640,0xC641,
	0xC644,0xC648,0xC650,0xC651,0xC653,0xC654,0xC655,0xC65C,0xC65D,0xC660,0xC66C,0xC66F,0xC671,0xC678,0xC679,0xC67C,
	0xC680,0xC688,0xC689,0xC68B,0xC68D,0xC694,0xC695,0xC698,0xC69C,0xC6A4,0xC6A5,0xC6A7,0xC6A9,0xC6B0,0xC6B1,0xC6B4,
	0xC6B8,0xC6B9,0xC6BA,0xC6C0,0xC6C1,0xC6C3,0xC6C5,0xC6CC,0xC6CD,0xC6D0,0xC6D4,0xC6DC,0xC6DD,0xC6E0,0xC6E1,0xC6E8,
	0xC6E9,0xC6EC,0xC6F0,0xC6F8,0xC6F9,0xC6FD,0xC704,0xC705,0xC708,0xC70C,0xC714,0xC715,0xC717,0xC719,0xC720,0xC721,
	0xC724,0xC728,0xC730,0xC731,0xC733,0xC735,0xC737,0xC73C,0xC73D,0xC740,0xC744,0xC74A,0xC74C,0xC74D,0xC74F,0xC751,
	0xC752,0xC753,0xC754,0xC755,0xC756,0xC757,0xC758,0xC75C,0xC760,0xC768,0xC76B,0xC774,0xC775,0xC778,0xC77C,0xC77D,
	0xC77E,0xC783,0xC784,0xC785,0xC787,0xC788,0xC789,0xC78A,0xC78E,0xC790,0xC791,0xC794,0xC796,0xC797,0xC798,0xC79A,
	0xC7A0,0xC7A1,0xC7A3,0xC7A4,0xC7A5,0xC7A6,0xC7AC,0xC7AD,0xC7B0,0xC7B4,0xC7BC,0xC7BD,0xC7BF,0xC7C0,0xC7C1,0xC7C8,
	0xC7C9,0xC7CC,0xC7CE,0xC7D0,0xC7D8,0xC7DD,0xC7E4,0xC7E8,0xC7EC,0xC800,0xC801,0xC804,0xC808,0xC80A,0xC810,0xC811,
	0xC813,0xC815,0xC816,0xC81C,0xC81D,0xC820,0xC824,0xC82C,0xC82D,0xC82F,0xC831,0xC838,0xC83C,0xC840,0xC848,0xC849,
	0xC84C,0xC84D,0xC854,0xC870,0xC871,0xC874,0xC878,0xC87A,0xC880,0xC881,0xC883,0xC885,0xC886,0xC887,0xC88B,0xC88C,
	0xC88D,0xC894,0xC89D,0xC89F,0xC8A1,0xC8A8,0xC8BC,0xC8BD,0xC8C4,0xC8C8,0xC8CC,0xC8D4,0xC8D5,0xC8D7,0xC8D9,0xC8E0,
	0xC8E1,0xC8E4,0xC8F5,0xC8FC,0xC8FD,0xC900,0xC904,0xC905,0xC906,0xC90C,0xC90D,0xC90F,0xC911,0xC918,0xC92C,0xC934,
	0xC950,0xC951,0xC954,0xC958,0xC960,0xC961,0xC963,0xC96C,0xC970,0xC974,0xC97C,0xC988,0xC989,0xC98C,0xC990,0xC998,
	0xC999,0xC99B,0xC99D,0xC9C0,0xC9C1,0xC9C4,0xC9C7,0xC9C8,0xC9CA,0xC9D0,0xC9D1,0xC9D3,0xC9D5,0xC9D6,0xC9D9,0xC9DA,
	0xC9DC,0xC9DD,0xC9E0,0xC9E2,0xC9E4,0xC9E7,0xC9EC,0xC9ED,0xC9EF,0xC9F0,0xC9F1,0xC9F8,0xC9F9,0xC9FC,0xCA00,0xCA08,
	0xCA09,0xCA0B,0xCA0C,0xCA0D,0xCA14,0xCA18,0xCA29,0xCA4C,0xCA4D,0xCA50,0xCA54,0xCA5C,0xCA5D,0xCA5F,0xCA60,0xCA61,
	0xCA68,0xCA7D,0xCA84,0xCA98,0xCABC,0xCABD,0xCAC0,0xCAC4,0xCACC,0xCACD,0xCACF,0xCAD1,0xCAD3,0xCAD8,0xCAD9,0xCAE0,
	0xCAEC,0xCAF4,0xCB08,0xCB10,0xCB14,0xCB18,0xCB20,0xCB21,0xCB41,0xCB48,0xCB49,0xCB4C,0xCB50,0xCB58,0xCB59,0xCB5D,
	0xCB64,0xCB78,0xCB79,0xCB9C,0xCBB8,0xCBD4,0xCBE4,0xCBE7,0xCBE9,0xCC0C,0xCC0D,0xCC10,0xCC14,0xCC1C,0xCC1D,0xCC21,
	0xCC22,0xCC27,0xCC28,0xCC29,0xCC2C,0xCC2E,0xCC30,0xCC38,0xCC39,0xCC3B,0xCC3C,0xCC3D,0xCC3E,0xCC44,0xCC45,0xCC48,
	0xCC4C,0xCC54,0xCC55,0xCC57,0xCC58,0xCC59,0xCC60,0xCC64,0xCC66,0xCC68,0xCC70,0xCC75,0xCC98,0xCC99,0xCC9C,0xCCA0,
	0xCCA8,0xCCA9,0xCCAB,0xCCAC,0xCCAD,0xCCB4,0xCCB5,0xCCB8,0xCCBC,0xCCC4,0xCCC5,0xCCC7,0xCCC9,0xCCD0,0xCCD4,0xCCE4,
	0xCCEC,0xCCF0,0xCD01,0xCD08,0xCD09,0xCD0C,0xCD10,0xCD18,0xCD19,0xCD1B,0xCD1D,0xCD24,0xCD28,0xCD2C,0xCD39,0xCD5C,
	0xCD60,0xCD64,0xCD6C,0xCD6D,0xCD6F,0xCD71,0xCD78,0xCD88,0xCD94,0xCD95,0xCD98,0xCD9C,0xCDA4,0xCDA5,0xCDA7,0xCDA9,
	0xCDB0,0xCDC4,0xCDCC,0xCDD0,0xCDE8,0xCDEC,0xCDF0,0xCDF8,0xCDF9,0xCDFB,0xCDFD,0xCE04,0xCE08,0xCE0C,0xCE14,0xCE19,
	0xCE20,0xCE21,0xCE24,0xCE28,0xCE30,0xCE31,0xCE33,0xCE35,0xCE58,0xCE59,0xCE5C,0xCE5F,0xCE60,0xCE61,0xCE68,0xCE69,
	0xCE6B,0xCE6D,0xCE74,0xCE75,0xCE78,0xCE7C,0xCE84,0xCE85,0xCE87,0xCE89,0xCE90,0xCE91,0xCE94,0xCE98,0xCEA0,0xCEA1,
	0xCEA3,0xCEA4,0xCEA5,0xCEAC,0xCEAD,0xCEC1,0xCEE4,0xCEE5,0xCEE8,0xCEEB,0xCEEC,0xCEF4,0xCEF5,0xCEF7,0xCEF8,0xCEF9,
	0xCF00,0xCF01,0xCF04,0xCF08,0xCF10,0xCF11,0xCF13,0xCF15,0xCF1C,0xCF20,0xCF24,0xCF2C,0xCF2D,0xCF2F,0xCF30,0xCF31,
	0xCF38,0xCF54,0xCF55,0xCF58,0xCF5C,0xCF64,0xCF65,0xCF67,0xCF69,0xCF70,0xCF71,0xCF74,0xCF78,0xCF80,0xCF85,0xCF8C,
	0xCFA1,0xCFA8,0xCFB0,0xCFC4,0xCFE0,0xCFE1,0xCFE4,0xCFE8,0xCFF0,0xCFF1,0xCFF3,0xCFF5,0xCFFC,0xD000,0xD004,0xD011,
	0xD018,0xD02D,0xD034,0xD035,0xD038,0xD03C,0xD044,0xD045,0xD047,0xD049,0xD050,0xD054,0xD058,0xD060,0xD06C,0xD06D,
	0xD070,0xD074,0xD07C,0xD07D,0xD081,0xD0A4,0xD0A5,0xD0A8,0xD0AC,0xD0B4,0xD0B5,0xD0B7,0xD0B9,0xD0C0,0xD0C1,0xD0C4,
	0xD0C8,0xD0C9,0xD0D0,0xD0D1,0xD0D3,0xD0D4,0xD0D5,0xD0DC,0xD0DD,0xD0E0,0xD0E4,0xD0EC,0xD0ED,0xD0EF,0xD0F0,0xD0F1,
	0xD0F8,0xD10D,0xD130,0xD131,0xD134,0xD138,0xD13A,0xD140,0xD141,0xD143,0xD144,0xD145,0xD14C,0xD14D,0xD150,0xD154,
	0xD15C,0xD15D,0xD15F,0xD161,0xD168,0xD16C,0xD17C,0xD184,0xD188,0xD1A0,0xD1A1,0xD1A4,0xD1A8,0xD1B0,0xD1B1,0xD1B3,
	0xD1B5,0xD1BA,0xD1BC,0xD1C0,0xD1D8,0xD1F4,0xD1F8,0xD207,0xD209,0xD210,0xD22C,0xD22D,0xD230,0xD234,0xD23C,0xD23D,
	0xD23F,0xD241,0xD248,0xD25C,0xD264,0xD280,0xD281,0xD284,0xD288,0xD290,0xD291,0xD295,0xD29C,0xD2A0,0xD2A4,0xD2AC,
	0xD2B1,0xD2B8,0xD2B9,0xD2BC,0xD2BF,0xD2C0,0xD2C2,0xD2C8,0xD2C9,0xD2CB,0xD2D4,0xD2D8,0xD2DC,0xD2E4,0xD2E5,0xD2F0,
	0xD2F1,0xD2F4,0xD2F8,0xD300,0xD301,0xD303,0xD305,0xD30C,0xD30D,0xD30E,0xD310,0xD314,0xD316,0xD31C,0xD31D,0xD31F,
	0xD320,0xD321,0xD325,0xD328,0xD329,0xD32C,0xD330,0xD338,0xD339,0xD33B,0xD33C,0xD33D,0xD344,0xD345,0xD37C,0xD37D,
	0xD380,0xD384,0xD38C,0xD38D,0xD38F,0xD390,0xD391,0xD398,0xD399,0xD39C,0xD3A0,0xD3A8,0xD3A9,0xD3AB,0xD3AD,0xD3B4,
	0xD3B8,0xD3BC,0xD3C4,0xD3C5,0xD3C8,0xD3C9,0xD3D0,0xD3D8,0xD3E1,0xD3E3,0xD3EC,0xD3ED,0xD3F0,0xD3F4,0xD3FC,0xD3FD,
	0xD3FF,0xD401,0xD408,0xD41D,0xD440,0xD444,0xD45C,0xD460,0xD464,0xD46D,0xD46F,0xD478,0xD479,0xD47C,0xD47F,0xD480,
	0xD482,0xD488,0xD489,0xD48B,0xD48D,0xD494,0xD4A9,0xD4CC,0xD4D0,0xD4D4,0xD4DC,0xD4DF,0xD4E8,0xD4EC,0xD4F0,0xD4F8,
	0xD4FB,0xD4FD,0xD504,0xD508,0xD50C,0xD514,0xD515,0xD517,0xD53C,0xD53D,0xD540,0xD544,0xD54C,0xD54D,0xD54F,0xD551,
	0xD558,0xD559,0xD55C,0xD560,0xD565,0xD568,0xD569,0xD56B,0xD56D,0xD574,0xD575,0xD578,0xD57C,0xD584,0xD585,0xD587,
	0xD588,0xD589,0xD590,0xD5A5,0xD5C8,0xD5C9,0xD5CC,0xD5D0,0xD5D2,0xD5D8,0xD5D9,0xD5DB,0xD5DD,0xD5E4,0xD5E5,0xD5E8,
	0xD5EC,0xD5F4,0xD5F5,0xD5F7,0xD5F9,0xD600,0xD601,0xD604,0xD608,0xD610,0xD611,0xD613,0xD614,0xD615,0xD61C,0xD620,
	0xD624,0xD62D,0xD638,0xD639,0xD63C,0xD640,0xD645,0xD648,0xD649,0xD64B,0xD64D,0xD651,0xD654,0xD655,0xD658,0xD65C,
	0xD667,0xD669,0xD670,0xD671,0xD674,0xD683,0xD685,0xD68C,0xD68D,0xD690,0xD694,0xD69D,0xD69F,0xD6A1,0xD6A8,0xD6AC,
	0xD6B0,0xD6B9,0xD6BB,0xD6C4,0xD6C5,0xD6C8,0xD6CC,0xD6D1,0xD6D4,0xD6D7,0xD6D9,0xD6E0,0xD6E4,0xD6E8,0xD6F0,0xD6F5,
	0xD6FC,0xD6FD,0xD700,0xD704,0xD711,0xD718,0xD719,0xD71C,0xD720,0xD728,0xD729,0xD72B,0xD72D,0xD734,0xD735,0xD738,
	0xD73C,0xD744,0xD747,0xD749,0xD750,0xD751,0xD754,0xD756,0xD757,0xD758,0xD759,0xD760,0xD761,0xD763,0xD765,0xD769,
	0xD76C,0xD770,0xD774,0xD77C,0xD77D,0xD781,0xD788,0xD789,0xD78C,0xD790,0xD798,0xD799,0xD79B,0xD79D,0x0000,0x0000,

	// nOqEꉹ
	0x3131,0x3132,0x3134,0x3137,0x3138,0x3139,0x3141,0x3142,0x3143,0x3145,0x3146,0x3147,0x3148,0x3149,0x314A,0x314B,
	0x314C,0x314D,0x314E,0x314F,0x3150,0x3151,0x3152,0x3153,0x3154,0x3155,0x3156,0x3157,0x315B,0x315C,0x3160,0x3161,
	0x3163,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	// ǉnO
	0xB894,0xC330,0xC3BC,0xC4D4,0xCB2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
};

static UNICODE StrcodeToUnicode(STRCODE strcode) {
	if (!IS_HANGUL(strcode)) return 0;

	return str2uni_table[strcode - STRCODE_HANGUL_BASE];
}

static STRCODE UnicodeToStrcode(UNICODE unicode) {
	int i;

	if (unicode == 0) return 0;

	// Ƃł߂ăoCiT[`ɂ
	for (i = 0; i < sizeof(str2uni_table) / sizeof(str2uni_table[0]); ++i) {
		if (str2uni_table[i] == unicode) return i + STRCODE_HANGUL_BASE;
	}

	return 0;
}

#define UNICODE_HANGUL_BASE				(0xAC00)
#define UNICODE_HANGUL_CONS_NUM			(19)
#define UNICODE_HANGUL_VOWEL_NUM		(21)
#define UNICODE_HANGUL_PATCHIM_NUM		(28)

#define GET_PATCHIM_FROM_UNICODE(unicode)		(((unicode) - UNICODE_HANGUL_BASE) % UNICODE_HANGUL_PATCHIM_NUM)
#define GET_VOWEL_FROM_UNICODE(unicode)			(((unicode) - UNICODE_HANGUL_BASE) / UNICODE_HANGUL_PATCHIM_NUM % UNICODE_HANGUL_VOWEL_NUM)

// qƕꉹ
static UNICODE UniteConsAndVowel(STRCODE cons, STRCODE vowel) {
	static const int diff_table[] = {
		0, 1, 2, 3, 4, 5, 6, 7, 8, 12, 13, 17, 18, 20
	};

	UNICODE unicode = UNICODE_HANGUL_BASE;

	GF_ASSERT(IS_HANGUL_CONS (cons));
	GF_ASSERT(IS_HANGUL_VOWEL(vowel));

	unicode += (cons - STRCODE_HANGUL_CONS_BASE) * UNICODE_HANGUL_VOWEL_NUM * UNICODE_HANGUL_PATCHIM_NUM;
	unicode += diff_table[vowel - STRCODE_HANGUL_VOWEL_BASE] * UNICODE_HANGUL_PATCHIM_NUM;

	return unicode;
}

// nOɃpb`
static UNICODE AddPatchim(UNICODE unicode, STRCODE cons) {
	static const int diff_table[] = {
		1, 2, 4, 7, -1, 8, 16, 17, -1, 19, 20, 21, 22, -1, 23, 24, 25, 26, 27
	};

	int diff;

	GF_ASSERT(GET_PATCHIM_FROM_UNICODE(unicode) == 0);
	GF_ASSERT(IS_HANGUL_CONS(cons));

	diff = diff_table[cons - STRCODE_HANGUL_CONS_BASE];

	return diff >= 0 ? unicode + diff : 0;
}

// pb`t̃nOAŌɓ͂ꂽq𓾂
static STRCODE GetLastConsFromUnicode(UNICODE unicode) {
	static const int diff_table[] = {
		-1,  0,  1,  9,  2, 12, 18,  3,  5,  0,  6,  7,  9, 16, 17, 18,
		 6,  7,  9,  9, 10, 11, 12, 14, 15, 16, 17, 18
	};

	int patchim = GET_PATCHIM_FROM_UNICODE(unicode);

	return patchim ? STRCODE_HANGUL_CONS_BASE + diff_table[patchim] : 0;
}

#endif

// ----------------------------------------------------------------------------

static int DecideMainButton(NAMEIN_WORK *wk,u16 code, int pad)
{
	// ꕶE{^̃R[h͑Sċ󔒕Ƃĕ\
	if(code==SPACE_ || code == SKIP_){
		code = spc_;
	}

	// thR[h͂̎̐
	if(wk->inputmode==NAMEIN_FRIENDCODE){
		if(code==NAMEIN_HIRA || code==NAMEIN_KANA || code==NAMEIN_ALPHA || code==NAMEIN_KIGOU ){
			code = spc_;
		}
	}

	switch(code){
	//  
	case DAKU_			:	
		if(ConvertWord(DAKU_WORD_START,DAKU_WORD_NUM,1,DAKU_,wk->inputword,wk->nowinput)){
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, 
									INPUT_WORD_SPACE, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			Snd_SePlay(NAMEIN_SE_DECIDE);
		}
		break;
	// 
	case HANDAKU_		:	
		if(ConvertWord(HANDAKU_WORD_START,HANDAKU_WORD_NUM,2,HANDAKU_,wk->inputword,wk->nowinput)){
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, 
									INPUT_WORD_SPACE, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			Snd_SePlay(NAMEIN_SE_DECIDE);
		}
		break;
	// 
	case NAMEIN_KOMOJI	:
		if(RotateConvertWord(BIGSMALL_WORD_START,HANDAKU_WORD_NUM,wk->inputword,wk->nowinput)){
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, 
									INPUT_WORD_SPACE, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			wk->funcbutton[4]++;
			Snd_SePlay(NAMEIN_SE_DECIDE);
		}
		break;

	// pl؂ւ{^
	case NAMEIN_HIRA	:	case NAMEIN_KANA	:	case NAMEIN_ALPHA	:	case NAMEIN_KIGOU	:
		// pl؂ւ
		if(wk->mode!=code-NAMEIN_HIRA){
			wk->seq  = NAMEIN_MODE_REQ;
			wk->mode = code-NAMEIN_HIRA;
			MakeWordMap(wk->wordmap, wk->mode);		// ̓}bvւ
			wk->funcbutton[code-NAMEIN_HIRA]++;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂Pʂō폜悤ɕύX
// m̃nO͂́Ả̃o[𓮂悤ɕύX
#if PM_LANG == LANG_KOREA
			wk->log_num = 0;
			InputResultUnderLineMove(wk);
#endif
// ----------------------------------------------------------------------------
			Snd_SePlay( NAMEIN_SE_CHANGEPANEL );
			CLACT_SetDrawFlag( wk->clActWork[8], pad);
		}
		break;

	// 1߂
	case NAMEIN_MODORU	:
		if(wk->nowinput!=0){
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂Pʂō폜悤ɕύX
#if PM_LANG == LANG_KOREA
			if (wk->log_num > 1) {
				wk->inputword[wk->nowinput-1] = wk->hangul_log[wk->log_num-2];
				wk->log_num--;
			} else {
				wk->inputword[wk->nowinput-1] = EOM_;
				wk->nowinput--;
				wk->log_num = 0;
			}
#else
			wk->inputword[wk->nowinput-1] = EOM_;
			wk->nowinput--;
#endif
// ----------------------------------------------------------------------------
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			if(wk->nowinput==0){
				// 0ƕvgȂ̂
				GF_BGL_BmpWinOn( &wk->NameInWin[BMP_RESULT_NAME] );
			}else{
				NameinWordPanelPrint(&wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, 
										INPUT_WORD_SPACE, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			}
			SubPanelButton_CharaChange(&wk->NameInWin[BMP_SUB_BUTTON1],
										wk->inputword,
										wk->nowinput,
										wk->subtouchword,
										wk->ObjTransWork,
										wk->ChangeWordStr);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂́Ả̃o[𓮂悤ɕύX
#if PM_LANG == LANG_KOREA
			InputResultUnderLineMove(wk);
#else
			InputResultUnderLineMove(wk->NameLineActWork, wk->nowinput, wk->inputmax);
#endif
// ----------------------------------------------------------------------------
			wk->funcbutton[5]++;
			Snd_SePlay(NAMEIN_SE_BS);
			CLACT_SetDrawFlag( wk->clActWork[8], pad);
		}
		break;
	// O͏I
	case NAMEIN_OWARI	:		
		// irQ[VACRAjI
//		MSG_DsIconFlashReq( wk->dsicon_task, MSG_DSI_REQ_FREE );

		// ̂̕ňS
		MSG_DsIconFlashDelete( wk->dsicon_task );
		CLACT_SetDrawFlag( wk->clActWork[8], pad);

		// ͏I
		if(wk->endmode==0){
			Snd_SePlay( NAMEIN_SE_END );
			wk->funcbutton[6]++;
			WIPE_SYS_Start(WIPE_PATTERN_FSAM, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, 16, 1, HEAPID_NAMEIN );
			return SEQ_OUT;
		}else{
			wk->seq = NAMEIN_MODE_BOXMSG;
		}
	break;

	// ʏ̕
	default:
		if(wk->mode==NAMEIN_MODE_NUMCODE && code==spc_){
			return SEQ_MAIN;
		}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/03
// nO͂ɑΉ
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂Pʂō폜悤ɕύX
// localize_spec_mark(LANG_KOREA) imatake 2007/10/26
// ő啶ꂽ͗LȂ悤ɏC

#if PM_LANG == LANG_KOREA

		GF_ASSERT(wk->log_num <= LOGNUM_MAX);

		if (code == NAMEIN_HANGULFIX) {
			if (wk->log_num > 0) {
				wk->log_num = 0;
				code = wk->inputword[wk->nowinput-1];
				wk->nowinput--;
			} else {
				code = h_spc_;
			}
		} else if (IS_HANGUL_ELEMENT(code)) {
			if (wk->log_num == 0) {
				if (wk->nowinput != wk->inputmax) {
					wk->hangul_log[0] = code;
					wk->log_num++;
				}
			} else {
				STRCODE prev_strcode = wk->hangul_log[wk->log_num-1];
				if (IS_HANGUL_CONS(prev_strcode)) {				// ÕnOq
					if (IS_HANGUL_VOWEL(code)) {
						STRCODE new_strcode = UnicodeToStrcode(UniteConsAndVowel(prev_strcode, code));
						if (new_strcode) {
							wk->hangul_log[wk->log_num++] = new_strcode;
							code = new_strcode;
							wk->nowinput--;
						} else if (wk->nowinput != wk->inputmax) {
							wk->hangul_log[0] = code;
							wk->log_num = 1;
						}
					} else if (wk->nowinput != wk->inputmax) {
						wk->hangul_log[0] = code;
						wk->log_num = 1;
					}
				} else if (IS_HANGUL_VOWEL(prev_strcode)) {		// ÕnOꉹ
					// P̂̕ꉹɂ͉łȂ
					if (wk->nowinput != wk->inputmax) {
						wk->hangul_log[0] = code;
						wk->log_num = 1;
					}
				} else {
					UNICODE prev_unicode = StrcodeToUnicode(prev_strcode);
					u16 patchim = GET_PATCHIM_FROM_UNICODE(prev_unicode);
					if (patchim == 0) {							// pb`Ȃ
						STRCODE new_strcode;
						UNICODE new_unicode = 0;
						if (IS_HANGUL_CONS(code)) {
							// qł΃pb`ǉ
							new_unicode = AddPatchim(prev_unicode, code);
						} else {
							// ꕔ̕ꉹł΍
							switch (GET_VOWEL_FROM_UNICODE(prev_unicode)) {
								case  8:		// 
									switch (code - STRCODE_HANGUL_VOWEL_BASE) {
										case  0: new_unicode = prev_unicode + UNICODE_HANGUL_PATCHIM_NUM * 1; break;	// g
										case  1: new_unicode = prev_unicode + UNICODE_HANGUL_PATCHIM_NUM * 2; break;	// g
										case 13: new_unicode = prev_unicode + UNICODE_HANGUL_PATCHIM_NUM * 3; break;	// 
									}
									break;
								case 13:		// 
									switch (code - STRCODE_HANGUL_VOWEL_BASE) {
										case  4: new_unicode = prev_unicode + UNICODE_HANGUL_PATCHIM_NUM * 1; break;	// 
										case  5: new_unicode = prev_unicode + UNICODE_HANGUL_PATCHIM_NUM * 2; break;	// 
										case 13: new_unicode = prev_unicode + UNICODE_HANGUL_PATCHIM_NUM * 3; break;	// 
									}
									break;
								case 18:		// 
									switch (code - STRCODE_HANGUL_VOWEL_BASE) {
										case 13: new_unicode = prev_unicode + UNICODE_HANGUL_PATCHIM_NUM * 1; break;	// 
									}
									break;
							}
						}
						new_strcode = UnicodeToStrcode(new_unicode);
						if (new_strcode) {
							wk->hangul_log[wk->log_num++] = new_strcode;
							code = new_strcode;
							wk->nowinput--;
						} else if (wk->nowinput != wk->inputmax) {
							wk->hangul_log[0] = code;
							wk->log_num = 1;
						}
					} else {
						if (IS_HANGUL_CONS(code)) {
							// ꕔ̎qł΍
							STRCODE new_strcode;
							UNICODE new_unicode = 0;
							switch (patchim) {
								case  1:		// t
									switch (code - STRCODE_HANGUL_CONS_BASE) {
										case  9: new_unicode = prev_unicode + 2; break;		// l
									}
									break;
								case  4:		// 
									switch (code - STRCODE_HANGUL_CONS_BASE) {
										case 12: new_unicode = prev_unicode + 1; break;		// X
										case 18: new_unicode = prev_unicode + 2; break;		// ]
									}
									break;
								case  8:		// 
									switch (code - STRCODE_HANGUL_CONS_BASE) {
										case  0: new_unicode = prev_unicode + 1; break;		// t
										case  6: new_unicode = prev_unicode + 2; break;		// 
										case  7: new_unicode = prev_unicode + 3; break;		// 
										case  9: new_unicode = prev_unicode + 4; break;		// l
										case 16: new_unicode = prev_unicode + 5; break;		// d
										case 17: new_unicode = prev_unicode + 6; break;		// U
										case 18: new_unicode = prev_unicode + 7; break;		// ]
									}
									break;
								case 17:		// 
									switch (code - STRCODE_HANGUL_CONS_BASE) {
										case  9: new_unicode = prev_unicode + 1; break;		// l
									}
									break;
							}
							new_strcode = UnicodeToStrcode(new_unicode);
							if (new_strcode) {
								wk->hangul_log[wk->log_num++] = new_strcode;
								code = new_strcode;
								wk->nowinput--;
							} else if (wk->nowinput != wk->inputmax) {
								wk->hangul_log[0] = code;
								wk->log_num = 1;
							}
						} else if (wk->nowinput != wk->inputmax) {
							// ꉹAÕpb`؂藣Č
							STRCODE last_cons   = GetLastConsFromUnicode(prev_unicode);
							STRCODE new_strcode = UnicodeToStrcode(UniteConsAndVowel(last_cons, code));
							if (new_strcode) {
								wk->inputword[wk->nowinput-1] = wk->hangul_log[wk->log_num-2];
								wk->hangul_log[0] = last_cons;
								wk->hangul_log[1] = new_strcode;
								wk->log_num = 2;
								code = new_strcode;
							} else {
								wk->hangul_log[0] = code;
								wk->log_num = 1;
							}
						}
					}
				}
			}
		} else {
			if (wk->nowinput != wk->inputmax) wk->log_num = 0;		// t̂Ƃ͓͂󂯕tȂ̂Ŋm肵Ȃ
		}

#endif

// ----------------------------------------------------------------------------

		if(wk->nowinput!=wk->inputmax){				//Max܂ōsĂȂ
			wk->inputword[wk->nowinput] = code;
			GF_BGL_BmpWinDataFill( &wk->NameInWin[BMP_RESULT_NAME], 0x0101 );
			NameinWordPanelPrint( &wk->NameInWin[BMP_RESULT_NAME], wk->inputword, 0,0, 
									INPUT_WORD_SPACE, MSG_ALLPUT, GF_PRINTCOLOR_MAKE(0xe,0xf,1),NULL);
			wk->nowinput++;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂́Ả̃o[𓮂悤ɕύX
#if PM_LANG == LANG_KOREA
			InputResultUnderLineMove(wk);
#else
			InputResultUnderLineMove(wk->NameLineActWork, wk->nowinput, wk->inputmax);
#endif
// ----------------------------------------------------------------------------
			Snd_SePlay(NAMEIN_SE_DECIDE);

				// ɂĐԂۂ̃Ajɐ؂ւ
				CLACT_SetDrawFlag( wk->clActWork[8], 1);
				CLACT_ObjModeSet( wk->clActWork[8], GX_OAM_MODE_XLU );
				G2_SetBlendAlpha( 0,GX_BLEND_PLANEMASK_BG0|GX_BLEND_PLANEMASK_BG1|GX_BLEND_PLANEMASK_BG2,8,8 );
				CLACT_AnmChg( wk->clActWork[8], 60);
				wk->Cursor.decide = 1;
			
			SubPanelButton_CharaChange(&wk->NameInWin[BMP_SUB_BUTTON1],
										wk->inputword,
										wk->nowinput,
										wk->subtouchword,
										wk->ObjTransWork,
										wk->ChangeWordStr);

		}
	}	
	
	return SEQ_MAIN;
}

//------------------------------------------------------------------
/**
 * E_E_łe[uɏւԂ
 * uvȂuvAúvȂu΁ρ́v
 * @param   tbl		
 * @param   pos		
 *
 * @retval  u16		
 */
//------------------------------------------------------------------
static u16 GetConvertWord(const u16 *tbl, int pos)
{

	do{
		pos = AroundWork(++pos,0,3);
//		OS_Printf("pos = %d, code = %d",pos,tbl[pos]);
	}while(tbl[pos]==spc_);
	
//	OS_Printf("last --- pos = %d, code = %d",pos,tbl[pos]);
	return tbl[pos];
}

//------------------------------------------------------------------
/**
 * uv{^
 *
 * @param   start	convert_tblJnʒu
 * @param   num		convert_tblIʒu
 * @param   str		obt@
 * @param   pos		݂̃J[\
 *
 * @retval  int		0Ȃ玸s	1Ȃ琬istr͏Ă)
 */
//------------------------------------------------------------------
static int RotateConvertWord(int start, int num, u16 *str, int pos)
{
	int i,r;
	u16 code,w;
	if(pos==0){
		return 0;
	}

	code = str[pos-1];

	for(i=start;i<num;i++){
		for(r=0;r<3;r++){
			if(convert_tbl[i][r]==code && code!=spc_){
				str[pos-1] = GetConvertWord(convert_tbl[i],r);
				return 1;
			}
		}
	}
	return 0;
}

//------------------------------------------------------------------
/**
 * ͍ςݕϊ
 *
 * @param   start	convert_tbľJnʒu
 * @param   num		convert_tbľIʒu
 * @param   target	convert_tbl̂OڂƔr̂͂PԖڂQԖڂi1or2)
 * @param   flag	DAKU_,HANDAKU_,NAMEIN_KOMOJÎǂꂩ
 * @param   str		͍ςݕ
 * @param   pos		ݓ͑҂̏ꏊ
 *
 * @retval  int		0=ϊ	1=ϊ
 */
//------------------------------------------------------------------
static int ConvertWord(int start, int num, int target, int flag, u16 *str, int pos)
{
	int i;
	u16 code;

	// 1͂ĂȂꍇ͕ϊ͔Ȃ
	if(pos==0 || str[pos-1]==spc_){
		return 0;
	}	

	// ̕ϊ
	code=str[pos-1];
	for(i=start;i<num;i++){
		if(convert_tbl[i][0]==code){
			str[pos-1]=convert_tbl[i][target];
			return 1;
		}
	}

	// ϊς݂̕ɖ߂
	for(i=start;i<num;i++){
		if(convert_tbl[i][target]==code){
			str[pos-1]=convert_tbl[i][0];
			return 1;
		}
	}

	//ꏈu΁ρvuÁvȂ

	switch(flag){
	case DAKU_:
		for(i=0;i<NELEMS(extra_daku_tbl);i++){
			if(extra_daku_tbl[i][0]==code){
				str[pos-1] = extra_daku_tbl[i][1];
				return 1;
			}
		}
		break;
	case HANDAKU_:
		for(i=0;i<NELEMS(extra_handaku_tbl);i++){
			if(extra_handaku_tbl[i][0]==code){
				str[pos-1] = extra_handaku_tbl[i][1];
				return 1;
			}
		}
		break;
	case NAMEIN_KOMOJI:
		if(code==du_){
			str[pos-1] = ttu_;
			return 1;
		}
		if(code==DU_){
			str[pos-1] = TTU_;
			return 1;
		}
		break;
	}	

	// ϊł͂Ȃ
	return 0;
}


//------------------------------------------------------------------
/**
 * ͍ςݕ̉̃A_[C𓮂ws
 *
 * @param   lineact		A_[C̃ZAN^[̃|C^
 * @param   pos			ʒu
 * @param   max			ő吔
 *
 * @retval  none		
 */
//------------------------------------------------------------------
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// m̃nO͂́Ả̃o[𓮂悤ɕύX
#if PM_LANG == LANG_KOREA

static void InputResultUnderLineMove(NAMEIN_WORK *wk) {
	int i;
	int pos;

	if (wk->nowinput > 0 && wk->log_num > 0 && IS_HANGUL(wk->inputword[wk->nowinput-1])) {
		pos = wk->nowinput - 1;
	} else {
		pos = wk->nowinput;
	}

	for(i=0;i<wk->inputmax;i++){
		CLACT_AnmChg( wk->NameLineActWork[i], 43 );		// SăA_[CȂԂɃNA
	}
	if(pos!=wk->inputmax){
		CLACT_AnmChg( wk->NameLineActWork[pos], 44 );	// w̕㉺ɓ
	}
}

#else

static void InputResultUnderLineMove(CLACT_WORK_PTR *lineact,int pos, int max)
{
	int i;
	for(i=0;i<max;i++){
		CLACT_AnmChg( lineact[i], 43 );		// SăA_[CȂԂɃNA
	}
	if(pos!=max){
		CLACT_AnmChg( lineact[pos], 44 );	// w̕㉺ɓ
	}
}

#endif
// ----------------------------------------------------------------------------


#define PLATE_CHARA_OFFSET1	( 12 )
#define PLATE_CHARA_OFFSET2	( 16 )
#define PLATE_H_CHARASIZE	(  8 )	// plBMPݕLc

static const u8 plate_num[]={2,2,3,2,2};
static const u8 plate_table[][3]={
	{8*8,17*8,0,},
	{8*8,17*8,0,},
	{5*8,12*8,18*8,},
	{8*8,17*8,0,},
	{8*8,17*8,0,},

};
static const u8 plate_chara_no[][5]={
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
};

static const u8 plate_chara_pos[5]={
	0,1,2,3,3
};

static const u8 plate_wall_col[]={3,6,0xc,9,9};

//------------------------------------------------------------------
/**
 * pl̕zuEg`Ȃǂs
 *
 * @param   win			GF_BGL_WINBMP*
 * @param   bgchara		pl̔wiL
 * @param   frame		O`R̕plԍ
 * @param   color		GF_PRINTCOLOR
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void WordPanelSetUp(GF_BGL_BMPWIN *win,u16 bgchara, int frame, GF_PRINTCOLOR color, u8* dakuten_Character )
{
	int i,r,h;

	// ꂼ̕pl̔wiFŃNA
	GF_BGL_BmpWinDataFill( win, bgchara );

	// pl̎d؂`
//	for(r=0;r<plate_num[frame];r++){
//		for(i=0;i<PLATE_H_CHARASIZE;i++){
//			GF_BGL_BmpWinPrint(	win, (void*)&dakuten_Character[(plate_chara_no[frame][r]+plate_chara_pos[frame])*8*8/2],
//				0, 0, 8, 8,
//				plate_table[frame][r], 8*i, 8, 8 );
//		}
//	}

	// plɎs͗l`
	for(i=0;i<6;i++){
		GF_BGL_BmpWinFill( win, plate_wall_col[frame], 16+32*i, 0,  16,   PANEL_H );		
		GF_BGL_BmpWinFill( win, plate_wall_col[frame], 16+32*i, 19*2, 16, PANEL_H );		
		GF_BGL_BmpWinFill( win, plate_wall_col[frame], 16+32*i, 19*4, 16, PANEL_H );		
	}
	for(i=0;i<7;i++){
		GF_BGL_BmpWinFill( win, plate_wall_col[frame], 32*i, 19,   16, PANEL_H );		
		GF_BGL_BmpWinFill( win, plate_wall_col[frame], 32*i, 19*3, 16, PANEL_H );		
	}

	// `
	for(i=0;i<5;i++){
		NameinWordPanelPrint(win,str_nametbl[frame][i],0,i*PANEL_H+4,
								WORDPANEL_WORD_SPACE, MSG_NO_PUT,color,dakuten_Character);
	}
	// ]
	GF_BGL_BmpWinOn( win );

}

//------------------------------------------------------------------
/**
 * @\{^iȁEJiEABCE^^ǂ邨j̃Aj
 *
 * @param   funcbutton[]	{^ԃtO
 * @param   ButtonAct		CLACT_WORK_PTR
 * @param   frame			݂̕plԍ
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void FuncButtonAnimation(int funcbutton[], CLACT_WORK_PTR *ButtonAct, int frame)
{
	int i,r;

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/03
	// {^3ނɕύX

	// ABC abc !? {^
	for(i=0;i<FONT_BUTTON_NUM;i++){
		if(funcbutton[i]){
			for(r=0;r<FONT_BUTTON_NUM;r++){
				CLACT_AnmChg( ButtonAct[r], main_button_info[r][2] );
			}
			CLACT_AnmChg( ButtonAct[i], main_button_info[i][2]-3 );
			break;
		}
	}

	// ----------------------------------------------------------------------------

	// {^i Ji ABCɂăZAjႤj
//	if(funcbutton[4]){
//		CLACT_AnmChg( ButtonAct[4], main_button_info[4][2] + frame);	// uLv̏{^݂͑Ȃ
//	}

	// ǂ {^
	for(i=5;i<7;i++){
		if(funcbutton[i]){
			CLACT_AnmChg( ButtonAct[i], main_button_info[i][2]+1);
		}
	}
	
	// AjfꂽNA
	for(i=0;i<7;i++){
		funcbutton[i] = 0;
	}

}


//------------------------------------------------------------------
/**
 * @brief   J[\Aj[V
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorAnimationControl( NAMEIN_WORK *wk )
{
	// J[\AjIԂɂȂĂꍇ͒ʏJ[\ɕω
	if(!CLACT_AnmActiveCheck( wk->clActWork[8] )){
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// nO͂m肵ĂȂJ[\ړȂ悤
#if PM_LANG == LANG_KOREA
		if(wk->nowinput==wk->inputmax && wk->log_num == 0){		// ̓}bNXnO͂m肵ĂuIv{^
#else
		if(wk->nowinput==wk->inputmax){							// ̓}bNX܂łuIv{^
#endif
// ----------------------------------------------------------------------------
			wk->Cursor.x = 12;
			wk->Cursor.y = 0;
			CLACT_AnmChg( wk->clActWork[8], NAMEIN_CURSOR_ANM_START);
			OS_Printf("\n");
		}else{
			CLACT_AnmChg( wk->clActWork[8], NAMEIN_CURSOR_ANM_START);
		}

		// \nmȂJ[\`߂E\neeȂJ[\B
		if(wk->Cursor.on==0){
			CLACT_SetDrawFlag( wk->clActWork[8], 0);
		}else{
			CursorAppearUpDate(wk,0);		// ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
		}
		wk->Cursor.decide = 0;

		// nai
		CLACT_ObjModeSet( wk->clActWork[8], GX_OAM_MODE_NORMAL );
	}

}

#ifdef NAMEIN_MAINUSE_TOUCHPANEL
//------------------------------------------------------------------
/**
 * ^b`pl菈
 *
 * @param   wk
 * @return  
 */
//------------------------------------------------------------------
//f[^ݒ\́ioCif[^j
typedef struct NM_TP_DATA_tag
{
	u8 x;
	u8 y;
	u16 type:2;
	u8	cx:5;
	u8	cy:5;
}NM_TP_DATA;

enum {
	CTYPE_S1 = 0,		// ȂEЂ炪ȁE`abE
	CTYPE_S2 = 1,		// ǂE
	CTYPE_WD = 2,		// 
};


static const NM_TP_DATA TouchPanelDataTable[] = {
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/03
	// {^3ނɕύX
	{ MAIN_BUTTON1_POSX+21,MAIN_BUTTON_POSY-8,CTYPE_S1, 0,0},
	{ MAIN_BUTTON2_POSX+21,MAIN_BUTTON_POSY-8,CTYPE_S1, 2,0},	
	{ MAIN_BUTTON3_POSX+21,MAIN_BUTTON_POSY-8,CTYPE_S1, 4,0},
	{ 0,                   192,               CTYPE_S1, 4,0},	
	{ MAIN_BUTTON6_POSX+21,MAIN_BUTTON_POSY-8,CTYPE_S2, 8,0},
	{ MAIN_BUTTON7_POSX+21,MAIN_BUTTON_POSY-8,CTYPE_S2,11,0},
	// ----------------------------------------------------------------------------

	{PANEL_X+  0, PANEL_Y+ 0,CTYPE_WD, 0,1},{PANEL_X+ 16, PANEL_Y+ 0,CTYPE_WD, 1,1},{PANEL_X+ 32, PANEL_Y+ 0,CTYPE_WD, 2,1},
	{PANEL_X+ 48, PANEL_Y+ 0,CTYPE_WD, 3,1},{PANEL_X+ 64, PANEL_Y+ 0,CTYPE_WD, 4,1},
	{PANEL_X+ 80, PANEL_Y+ 0,CTYPE_WD, 5,1},{PANEL_X+ 96, PANEL_Y+ 0,CTYPE_WD, 6,1},{PANEL_X+112, PANEL_Y+ 0,CTYPE_WD, 7,1},
	{PANEL_X+128, PANEL_Y+ 0,CTYPE_WD, 8,1},{PANEL_X+144, PANEL_Y+ 0,CTYPE_WD, 9,1},
	{PANEL_X+160, PANEL_Y+ 0,CTYPE_WD,10,1},{PANEL_X+176, PANEL_Y+ 0,CTYPE_WD,11,1},{PANEL_X+192, PANEL_Y+ 0,CTYPE_WD,12,1},

	{PANEL_X+  0, PANEL_Y+PANEL_H,CTYPE_WD, 0,2},{PANEL_X+ 16, PANEL_Y+PANEL_H,CTYPE_WD, 1,2},{PANEL_X+ 32, PANEL_Y+PANEL_H,CTYPE_WD, 2,2},
	{PANEL_X+ 48, PANEL_Y+PANEL_H,CTYPE_WD, 3,2},{PANEL_X+ 64, PANEL_Y+PANEL_H,CTYPE_WD, 4,2},
	{PANEL_X+ 80, PANEL_Y+PANEL_H,CTYPE_WD, 5,2},{PANEL_X+ 96, PANEL_Y+PANEL_H,CTYPE_WD, 6,2},{PANEL_X+112, PANEL_Y+PANEL_H,CTYPE_WD, 7,2},
	{PANEL_X+128, PANEL_Y+PANEL_H,CTYPE_WD, 8,2},{PANEL_X+144, PANEL_Y+PANEL_H,CTYPE_WD, 9,2},
	{PANEL_X+160, PANEL_Y+PANEL_H,CTYPE_WD,10,2},{PANEL_X+176, PANEL_Y+PANEL_H,CTYPE_WD,11,2},{PANEL_X+192, PANEL_Y+PANEL_H,CTYPE_WD,12,2},

	{PANEL_X+  0, PANEL_Y+PANEL_H*2,CTYPE_WD, 0,3},{PANEL_X+ 16, PANEL_Y+PANEL_H*2,CTYPE_WD, 1,3},{PANEL_X+ 32, PANEL_Y+PANEL_H*2,CTYPE_WD, 2,3},
	{PANEL_X+ 48, PANEL_Y+PANEL_H*2,CTYPE_WD, 3,3},{PANEL_X+ 64, PANEL_Y+PANEL_H*2,CTYPE_WD, 4,3},
	{PANEL_X+ 80, PANEL_Y+PANEL_H*2,CTYPE_WD, 5,3},{PANEL_X+ 96, PANEL_Y+PANEL_H*2,CTYPE_WD, 6,3},{PANEL_X+112, PANEL_Y+PANEL_H*2,CTYPE_WD, 7,3},
	{PANEL_X+128, PANEL_Y+PANEL_H*2,CTYPE_WD, 8,3},{PANEL_X+144, PANEL_Y+PANEL_H*2,CTYPE_WD, 9,3},
	{PANEL_X+160, PANEL_Y+PANEL_H*2,CTYPE_WD,10,3},{PANEL_X+176, PANEL_Y+PANEL_H*2,CTYPE_WD,11,3},{PANEL_X+192, PANEL_Y+PANEL_H*2,CTYPE_WD,12,3},

	{PANEL_X+  0, PANEL_Y+PANEL_H*3,CTYPE_WD, 0,4},{PANEL_X+ 16, PANEL_Y+PANEL_H*3,CTYPE_WD, 1,4},{PANEL_X+ 32, PANEL_Y+PANEL_H*3,CTYPE_WD, 2,4},
	{PANEL_X+ 48, PANEL_Y+PANEL_H*3,CTYPE_WD, 3,4},{PANEL_X+ 64, PANEL_Y+PANEL_H*3,CTYPE_WD, 4,4},
	{PANEL_X+ 80, PANEL_Y+PANEL_H*3,CTYPE_WD, 5,4},{PANEL_X+ 96, PANEL_Y+PANEL_H*3,CTYPE_WD, 6,4},{PANEL_X+112, PANEL_Y+PANEL_H*3,CTYPE_WD, 7,4},
	{PANEL_X+128, PANEL_Y+PANEL_H*3,CTYPE_WD, 8,4},{PANEL_X+144, PANEL_Y+PANEL_H*3,CTYPE_WD, 9,4},
	{PANEL_X+160, PANEL_Y+PANEL_H*3,CTYPE_WD,10,4},{PANEL_X+176, PANEL_Y+PANEL_H*3,CTYPE_WD,11,4},{PANEL_X+192, PANEL_Y+PANEL_H*3,CTYPE_WD,12,4},

	{PANEL_X+  0, PANEL_Y+PANEL_H*4,CTYPE_WD, 0,5},{PANEL_X+ 16, PANEL_Y+PANEL_H*4,CTYPE_WD, 1,5},{PANEL_X+ 32, PANEL_Y+PANEL_H*4,CTYPE_WD, 2,5},
	{PANEL_X+ 48, PANEL_Y+PANEL_H*4,CTYPE_WD, 3,5},{PANEL_X+ 64, PANEL_Y+PANEL_H*4,CTYPE_WD, 4,5},
	{PANEL_X+ 80, PANEL_Y+PANEL_H*4,CTYPE_WD, 5,5},{PANEL_X+ 96, PANEL_Y+PANEL_H*4,CTYPE_WD, 6,5},{PANEL_X+112, PANEL_Y+PANEL_H*4,CTYPE_WD, 7,5},
	{PANEL_X+128, PANEL_Y+PANEL_H*4,CTYPE_WD, 8,5},{PANEL_X+144, PANEL_Y+PANEL_H*4,CTYPE_WD, 9,5},
	{PANEL_X+160, PANEL_Y+PANEL_H*4,CTYPE_WD,10,5},{PANEL_X+176, PANEL_Y+PANEL_H*4,CTYPE_WD,11,5},{PANEL_X+192, PANEL_Y+PANEL_H*4,CTYPE_WD,12,5},
};

#define TP_DATATBL_MAX ( NELEMS( TouchPanelDataTable ) )

//------------------------------------------------------------------
/**
 * @brief   ՂɑΉ^b`胋[`
 *
 * @param   wk		
 *
 * @retval  BOOL		
 */
//------------------------------------------------------------------
static BOOL TouchPanelCheck( NAMEIN_WORK *wk )
{
	int	i,start=0;
	u8	x,y,start_x,start_y,size_x,size_y;

	// thR[h͕͂̎Ր؂ւ{^𖳌ɂ
	if(wk->inputmode==NAMEIN_FRIENDCODE){
		start = 4;
	}

	if( sys.tp_trg ){

		//荞݂ŒlςȂ悤
		x = sys.tp_x;
		y = sys.tp_y;

		for(i=start;i<TP_DATATBL_MAX;i++){
			start_x = TouchPanelDataTable[i].x;
			start_y = TouchPanelDataTable[i].y;

			// {^擾
			switch( TouchPanelDataTable[i].type ){

			case CTYPE_S1:
				// ----------------------------------------------------------------------------
				// localize_spec_mark(LANG_ALL) imatake 2006/10/03
				// {^3ނɕύX
				size_x = 32-1;
				// ----------------------------------------------------------------------------
				size_y = 22;
				break;
			case CTYPE_S2:
				size_x = 32;
				size_y = 22;
				break;
			case CTYPE_WD:
				size_x = 16;
				size_y = PANEL_H;
				break;
			}
			
			// 蔻
			if((x >= start_x)&&(y >= start_y)&&(x <= (start_x+size_x))&&(y <= (start_y+size_y))){
				wk->Cursor.x = TouchPanelDataTable[i].cx;
				wk->Cursor.y = TouchPanelDataTable[i].cy;
				return TRUE;
			}
		}
	}
	return FALSE;
}

#ifdef DEBUG_OAM_POSPRINT
//------------------------------------------------------------------
/**
 * @brief   WmFpn`l̕\
 *
 * @param   none		
 *
 * @retval  static		
 */
//------------------------------------------------------------------
static testclact_set( void )
{
	VecFx32 tmpVex;
	int start_x,start_y,size_x,size_y;

	switch( TouchPanelDataTable[testclact_no].type ){

	case CTYPE_S1:
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/10/03
		// {^3ނɕύX
		size_x = 32-1;
		// ----------------------------------------------------------------------------
		size_y = 22;
		break;
	case CTYPE_S2:
		size_x = 32;
		size_y = 22;
		break;
	case CTYPE_WD:
		size_x = 16;
		size_y = PANEL_H;
		break;
	}


	tmpVex.x = FX32_ONE*(TouchPanelDataTable[testclact_no].x);
	tmpVex.y = FX32_ONE*(TouchPanelDataTable[testclact_no].y);
	CLACT_SetMatrix(testclact[0], &tmpVex);

	tmpVex.x = FX32_ONE*(TouchPanelDataTable[testclact_no].x+size_x);
	tmpVex.y = FX32_ONE*TouchPanelDataTable[testclact_no].y;
	CLACT_SetMatrix(testclact[1], &tmpVex);

	tmpVex.x = FX32_ONE*TouchPanelDataTable[testclact_no].x;
	tmpVex.y = FX32_ONE*(TouchPanelDataTable[testclact_no].y+size_y);
	CLACT_SetMatrix(testclact[2], &tmpVex);

	tmpVex.x = FX32_ONE*(TouchPanelDataTable[testclact_no].x+size_x);
	tmpVex.y = FX32_ONE*(TouchPanelDataTable[testclact_no].y+size_y);
	CLACT_SetMatrix(testclact[3], &tmpVex);


}
#endif



#endif

