//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		comm_command_nutmixer_func.h
 *	@brief		ʐMR[obN֐
 *	@author		tomoya takahashi
 *	@data		2006.05.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#include "nmix_game.h"
#include "communication/communication.h"
#include "comm_command_nutmixer.h"
#include "nmix_gameseq.h"

#define __COMM_COMMAND_NUTMIXER_FUNC_H_GLOBAL
#include "comm_command_nutmixer_func.h"


//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *		ʐM֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	ʐM̏
 */
//-----------------------------------------------------------------------------
void CommCommandNutMixerInitialize( NMIX_GAMEWORK* pWork, MYSTATUS* p_mystate )
{
	int playno;
	int i;

	// ʐMԃ`FbN
	if( pWork->commpack_flg == NUTMIX_COMM_PACK_COMM ){
		// ʐMl擾
		pWork->comm_count = CommGetConnectNum();
	}else{
		// ʐM
		pWork->comm_count = 1;
	}
	OS_Printf( "comm_count = %d\n", pWork->comm_count );

	// ʐMpbNVXeJn
	pWork->comm_work = NMIX_CommPack_CommandInitialize( 
			NutMixer_CommCommandTclGet(),
			NutMixer_CommCommandTblNumGet(),
			pWork,
			pWork->commpack_flg,
			pWork->heapID );


	memset( pWork->game_comm_pack.playno_netid, NUTMIXER_MEMBER_MAX, sizeof(u8) * NUTMIXER_MEMBER_MAX );
	
	if( pWork->commpack_flg == NUTMIX_COMM_PACK_COMM ){
		// vC[io[[lbgID擾z쐬
		// vC[Xe[^X擾
		playno = 0;
		for( i=0; i<NUTMIXER_MEMBER_MAX; i++ ){

			pWork->game_comm_pack.p_mystate[ i ] = CommInfoGetMyStatus( i );
			if( pWork->game_comm_pack.p_mystate[ i ] != NULL ){
				pWork->game_comm_pack.playno_netid[ playno ] = i;
				playno ++;
			}
		}
	}else{
		pWork->game_comm_pack.playno_netid[ 0 ] = 0;
		pWork->game_comm_pack.p_mystate[ 0 ] = p_mystate;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ʐM̔j
 */
//-----------------------------------------------------------------------------
void CommCommandNutMixerDest( NMIX_GAMEWORK* pWork )
{
	// ʐMpbNVXej
	NMIX_CommPack_CommDelete( pWork->comm_work );
	pWork->comm_work = NULL;
}

//-----------------------------------------------------------------------------
/**
 *		Q[
 *		p
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	Q[Jn		qM
 *
 *	@param	netID		ڑԍ
 *	@param	size		obt@TCY
 *	@param	pBuff		obt@
 *	@param	pWork		VXe[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameSysStart( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;

	OS_Printf( "e->q Q[JnOJn\n" );
	// Q[OJn
	NMIX_SetMainSeq( p_game, NMIX_GAME_MAINSEQ_BEFORE );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Q[@I	qM
 *
 *	@param	netID		ڑԍ
 *	@param	size		obt@TCY
 *	@param	pBuff		obt@
 *	@param	pWork		VXe[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameEnd( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;

	OS_Printf( "e->q Q[I\n" );
	// Q[@I
	NMIX_SetMainSeq( p_game, NMIX_GAME_MAINSEQ_GAMEEND );
}

//-----------------------------------------------------------------------------
/**
 *		f[^Mp
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	eQ[JnO󂯎
 *
 *	@param	netID		ڑID
 *	@param	size		TCY
 *	@param	pBuff		obt@
 *	@param	pWork		[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameBeforeDataKo( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;

	// obt@Ɋi[
	memcpy( &p_game->game_comm_pack.get_ko_before_data, pBuff, size );

	// ef[^ݒ
	p_game->game_comm_pack.get_game_data[ COMM_PARENT_ID ].oya = p_game->game_comm_pack.get_ko_before_data.oya;

	OS_Printf( "e->q@X[vl %d\n GtFNg %d \n", p_game->game_comm_pack.get_game_data[ COMM_PARENT_ID ].oya.alpha_num, p_game->game_comm_pack.get_game_data[ COMM_PARENT_ID ].oya.rota_req_eff);


	OS_Printf( "e[q Q[JnO擾 0[%d] 1[%d] 2[%d] 3[%d] \n", 
			p_game->game_comm_pack.get_ko_before_data.before[0].nut_type,
			p_game->game_comm_pack.get_ko_before_data.before[1].nut_type,
			p_game->game_comm_pack.get_ko_before_data.before[2].nut_type,
			p_game->game_comm_pack.get_ko_before_data.before[3].nut_type );

	// Q[Jn
	NMIX_SetMainSeq( p_game, NMIX_GAME_MAINSEQ_RES_LOAD );
}

//----------------------------------------------------------------------------
/**
 *	@brief	q؂̎f[^擾
 *
 *	@param	netID		ڑԍ
 *	@param	size		obt@TCY
 *	@param	pBuff		obt@
 *	@param	pWork		VXe[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameBeforeData( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;
	int i;
	int in_count;


	// êƂ󂯎	
	// éASĎ󂯎Aqɖ؂̎]
	if( NMIX_CommPack_CommGetCurrentID( p_game->comm_work ) == COMM_PARENT_ID ){
		// obt@Ɋi[
		memcpy( &p_game->game_comm_pack.get_before_data[ netID ], pBuff, size );
		p_game->game_comm_pack.get_before_data_flg[ netID ] = TRUE;

		// qɑf[^ɂǉ
		p_game->game_comm_pack.get_oya_ko_before_data.before[ netID ] = p_game->game_comm_pack.get_before_data[ netID ];

		OS_Printf( "q[e Q[JnO擾 netID[ %d ] nuts_data[ %d ]\n", netID, p_game->game_comm_pack.get_before_data[ netID ] );

		// ʐMS痈`FbN
		in_count = 0;
		for( i=0; i<NUTMIXER_MEMBER_MAX; i++ ){
			if( p_game->game_comm_pack.get_before_data_flg[ i ] == TRUE ){
				in_count ++;
			}
		}

		// S炫AQ[JnO]
		if( in_count >= p_game->comm_count ){
			OS_Printf( "qɃQ[JnO] in_c=%d  comm_c=%d\n", in_count, p_game->comm_count );

			// 1ȅf[^n
			NMIX_DATA_OyaCommDataMake_Init( &p_game->oya_data,
					&p_game->game_comm_pack.get_oya_ko_before_data.oya, p_game->comm_count );	// ʐMf[^ݒ


			// f[^]
			NMIX_CommPack_CommSendData( CNM_MIXER_GAME_BEFOREDATA_KO,
					&p_game->game_comm_pack.get_oya_ko_before_data,
					CommNutMixerGetGameBeforeKoSize(),
					p_game->comm_work );
		}
	}

	
}

//----------------------------------------------------------------------------
/**
 *	@brief	Q[f[^擾			eq
 *
 *	@param	netID		ڑԍ
 *	@param	size		obt@TCY
 *	@param	pBuff		obt@
 *	@param	pWork		VXe[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameData( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;

	// obt@Ɋi[
	memcpy( &p_game->game_comm_pack.get_game_data[ netID ], pBuff, size );
}


//----------------------------------------------------------------------------
/**
 *	@brief	Q[ʃf[^擾
 *
 *	@param	netID		ڑԍ
 *	@param	size		obt@TCY
 *	@param	pBuff		obt@
 *	@param	pWork		VXe[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameResultData( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;

	// obt@Ɋi[
	memcpy( &p_game->game_comm_pack.get_result_data, pBuff, size );

	OS_Printf( "e[q Q[ʏ擾\n" );

	// ʕ\Ɉȍ~
	NMIX_SetMainSeq( p_game, NMIX_GAME_MAINSEQ_RESULT );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|gf[^M
 *
 *	@param	netID		ڑԍ
 *	@param	size		obt@TCY
 *	@param	pBuff		obt@
 *	@param	pWork		VXe[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerPorutoData( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;

	// obt@Ɋi[
	memcpy( p_game->game_comm_pack.p_get_ko_poruto, pBuff, size );
	OS_Printf( "e[q |gf[^擾\n" );
}

//----------------------------------------------------------------------------
/**
 *	@brief	e@Q[Â邩󂯎
 *
 *	@param	netID		ڑID
 *	@param	size		TCY
 *	@param	pBuff		obt@
 *	@param	pWork		[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameNextDataKo( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;

	// obt@Ɋi[
	memcpy( &p_game->game_comm_pack.get_game_next, pBuff, size );

	OS_Printf( "e[q Q[I %d \n", p_game->game_comm_pack.get_game_next );

	
	// Q[S@I
	NMIX_SetMainSeq( p_game, NMIX_GAME_MIANSEQ_RES_RELEASE );
}

//----------------------------------------------------------------------------
/**
 *	@brief	qQ[Â󂯎
 *
 *	@param	netID		ڑID
 *	@param	size		TCY
 *	@param	pBuff		obt@
 *	@param	pWork		[N
 */
//-----------------------------------------------------------------------------
void CommNutMixerGameNextData( int netID, int size, void* pBuff, void* pWork )
{
	NMIX_GAMEWORK* p_game = pWork;
	int i;
	int in_count;
	u8 send;

	// êƂ󂯎	
	// éASĎ󂯎Aqɖ؂̎]
	if( NMIX_CommPack_CommGetCurrentID( p_game->comm_work ) == COMM_PARENT_ID ){
		// obt@Ɋi[
		memcpy( &p_game->game_comm_pack.game_next[ netID ], pBuff, size );
		p_game->game_comm_pack.get_next_data_flg[ netID ] = TRUE;

		OS_Printf( "q[e Q[If[^ netID[ %d ] next_data[ %d ]\n", netID, p_game->game_comm_pack.game_next[ netID ] );

		// ʐMS痈`FbN
		in_count = 0;
		send = 1;	// ŏɑĂ@F1Ȃ1 lł0Ȃ0Ȃ̂
					// Ń`FbNĂ
		for( i=0; i<NUTMIXER_MEMBER_MAX; i++ ){
			if( p_game->game_comm_pack.get_next_data_flg[ i ] == TRUE ){
				send &= p_game->game_comm_pack.game_next[ i ];
				in_count ++;
			}
		}
		// S炫AQ[If[^]
		if( in_count >= p_game->comm_count ){
			OS_Printf( "qɃQ[If[^] in_c=%d  comm_c=%d\n", in_count, p_game->comm_count );

			// f[^]
			NMIX_CommPack_CommSendData( CNM_MIXER_GAME_NEXT_KO,
					&send,
					CommNutMixerGetOneSize(),
					p_game->comm_work );
		}
	}
}


//-----------------------------------------------------------------------------
/**
 *			TCY擾֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	0TCY
 *	@return	TCY
 */
//-----------------------------------------------------------------------------
int CommNutMixerGetZeroSize( void )
{
	return 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	1TCY
 *	@return	TCY
 */
//-----------------------------------------------------------------------------
int CommNutMixerGetOneSize( void )
{
	return 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Q[OʐMf[^q󂯎TCY擾
 *	@return	TCY
 */
//-----------------------------------------------------------------------------
int CommNutMixerGetGameBeforeKoSize( void )
{
	return sizeof(NUTMIX_COMM_BEFORE_KO);
}

//----------------------------------------------------------------------------
/**
 *	@brief	Q[OTCYʐMf[^TCY擾
 *	@return	TCY
 */
//-----------------------------------------------------------------------------
int CommNutMixerGetGameBeforeSize( void )
{
	return sizeof(NUTMIX_GAME_BGFORE);
}

//----------------------------------------------------------------------------
/**
 *	@brief	Q[f[^TCY擾
 *	@return	TCY
 */
//-----------------------------------------------------------------------------
int CommNutMixerGetGameSize( void )
{
	return sizeof(NUTMIX_COMM_DATA);
}

//----------------------------------------------------------------------------
/**
 *	@brief	Q[ʃf[^TCY擾
 *	@return	TCY
 */
//-----------------------------------------------------------------------------
int CommNutMixerGetGameResultSize( void )
{
	return sizeof(NUTMIX_COMM_RESULT);
}


