/**
 *	@file	nmix_game.h
 *	@brief	ibc~LT[@Q[vZXwb_
 *	@author	Miyuki Iwasawa
 *	@date	06.07.08
 *	@data		2006.05.23		tomoya XV
 */

#ifndef __H_NMIX_GAME_H__
#define __H_NMIX_GAME_H__

#include "nutmixer_def.h"
#include "nutmix_comm_pack.h"
#include "nmix_game_comm.h"
#include "nmix_game_demo.h"
#include "nmix_game_data.h"
#include "nmix_stdata.h"

#include "common.h"
#include "system/clact_util.h"
#include "system/swsprite.h"

//-----------------------------------------------------------------------------
/**
 *
 *					萔
 *
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
// GtFNgoĂl
#define NMIX_GAME_WAY_FLAG_RIGHT	( 1 )
#define NMIX_GAME_WAY_FLAG_LEFT	( 2 )


//-------------------------------------
//	؂̎~LT[[N
//=====================================
typedef struct {
	// VXeǗ
	int	heapID;
	BOOL seqend_f;		///<Q[V[PXItO
	int	synchroID;		///<ʐMID
	int	main_seq;		///<Q[CV[PX
	int	sub_seq;		///<Q[TuV[PX
	BOOL main_seq_chg_req;///<ʐMR[obÑV[PXύX肢tO
	int main_seq_req;	///<ʐMR[obÑV[PXύX肢

	int wait;

#ifdef PM_DEBUG
	int comm_err_count;
#endif
	
	// BG
	GF_BGL_INI* bgl;
	int wnd_type;
	int msg_speed;

	// OAM
	NMIXGAME_CLACT_SYS	clact;
	NMIXGAME_CLACT_RES_WORK def_clact_res[ NMIX_GAME_DEF_OAM_RES_NUM ];
	BOOL clact_draw;

	// \tgEFAXvCg
	SWSP_SYS_PTR	swsp_sys;


	// ʊǗf[^
	u32 houkou_draw_flg;	// ؂ւ\
	u32 gyaku_draw_flg;		// t]\
	BOOL kogeru_draw_flg;	// \
	BOOL kobore_draw_flg;	// ڂ\

	// [N
	NMIX_DATA_KO	ko_data;	// ʐMqf[^
	NMIX_DATA_OYA	oya_data;
	u32 game_next;				// Q[𑱂
	s32 last_rota;				// PO̐e痈]p
	u32 last_count_down;		// JEg_Ef[^

	// `惏[N
	NMIX_DEMO_NUTS_IN nuts_in;	// ؂̎
	NMIX_DEMO_SUB_WIN sub_win;	// TuEBhE
	NMIX_DEMO_COUNTDOWN countdown;	// JEg_E
	NMIX_DEMO_COUNTDOWN end_mark;	// IMARK
	NMIX_DEMO_COUNTDOWN pen;		// y
	NMIX_DEMO_NABE_GRA nabe_gra;	// OtBbN
	NMIX_DEMO_OTHER_MARK other_mark;	// ̐l̈ʒu
	NMIX_DEMO_MAIN_WIN main_win;		// CBGǗ
	NMIX_DEMO_SOOP_EFFECT soop_effect;	// X[vGtFNg
	NMIX_DEMO_YAZIRUSI	yazirusi;	// IuWFNg
	NMIX_DEMO_HOSI_KIRAKIRA hosi_kira;	// LL
	NMIX_DEMO_PORUTO_DRAW poruto_draw;	// |g`
	NMIX_DEMO_YESNO_WND	yes_no;		// YESNOEBhE
	

	//ʐM֘Af[^̈
	int				comm_count;	// ʐMo[
	NUTMIX_COMMPACK_WORK* comm_work;// ʐM[N
	int				commpack_flg;	// ʐMpbNtO
									// NUTMIX_COMM_PACK_ONE	( 0 )	// lp
									// NUTMIX_COMM_PACK_COMM	( 1 )	// ʐM

	// ʐMf[^
	NUTMIX_GAME_COMM_PACK game_comm_pack;

	// bZ[Wf[^
	NMIXER_MSG	msgDat;

} NMIX_GAMEWORK;

extern void NMIX_SetMainSeq( NMIX_GAMEWORK* p_work, int seq );
extern void NMIX_SetSubSeq( NMIX_GAMEWORK* p_work, int seq );
extern void NMIX_SetEndReq( NMIX_GAMEWORK* p_work );


#endif	//__H_NMIX_GAME_H__

