//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		nutmix_comm_pack.c
 *	@brief		ʐMPACKAGEVXe
 *	@author		tomoya takahashi
 *	@data		2006.05.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"


#define __NUTMIX_COMM_PACK_H_GLOBAL
#include "nutmix_comm_pack.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define NUTMIX_COMM_PACK_DATABUFF_SIZE	( 38 )	// byte

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	_~[R[obN[N
//=====================================
typedef struct {
	BOOL init;
	int command;
	u8 data[ NUTMIX_COMM_PACK_DATABUFF_SIZE ];
	int size;
} NUTMIX_COMMPACK_DUMMY_WORK;


//-------------------------------------
//	_~[R[obNVXe
//=====================================
typedef struct {
	NUTMIX_COMMPACK_DUMMY_WORK	work[NUTMIX_COMM_PACK_DUMMY_WORK_NUM];	// [N
	const CommPacketTbl* pCommPacketLocal;	// R}he[u
	int					 commtbl_num;		// R}he[u
	void*				 pCallBackWork;		// R[obN[N
	TCB_PTR				 tcb;				// ^XN[N
} NUTMIX_COMMPACK_DUMMY_SYS;


//-------------------------------------
//	Oێ@VXe[N
//	comm_flgpWork̎gpprς
//=====================================
typedef struct _NUTMIX_COMMPACK_WORK{
	int comm_flg;	// ʐMpbNtO
	void* pWork;	// [N
} ;




//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static NUTMIX_COMMPACK_DUMMY_SYS* NutMix_CommPack_DummySys_Init( const CommPacketTbl* pCommPacketLocal,int listNum,void* pWork, int heapID );
static void NutMix_CommPack_DummySys_Main( TCB_PTR tcb, void* p_work );
static void NutMix_CommPack_DummySys_Delete( NUTMIX_COMMPACK_DUMMY_SYS* p_sys );
static BOOL NutMix_CommPack_DummySys_SendData( NUTMIX_COMMPACK_DUMMY_SYS* p_sys, int command, const void* data, int size );




//----------------------------------------------------------------------------
/**
 *	@brief	R}he[uݒ@pbN֐
 *
 *	@param	pCommPacketLocal		R}he[u
 *	@param	listNum					Xg
 *	@param	pWork					R[obN[N
 *	@param	comm_flg				ʐMpbNtO
 *	@param	heapID					q[vID
 *
 *	@retval	R}hpbNVXe[N
 */
//-----------------------------------------------------------------------------
NUTMIX_COMMPACK_WORK* NMIX_CommPack_CommandInitialize( const CommPacketTbl* pCommPacketLocal,int listNum,void* pWork, int comm_flg, int heapID )
{
	NUTMIX_COMMPACK_WORK* p_sys;

	// m
	p_sys = sys_AllocMemory( heapID, sizeof(NUTMIX_COMMPACK_WORK) );
	p_sys->comm_flg = comm_flg;
	p_sys->pWork = NULL;
	
	if( comm_flg == NUTMIX_COMM_PACK_COMM ){
	    CommCommandInitialize( pCommPacketLocal, listNum, pWork );
		OS_Printf( "ʐMӰރZbgAbv\n" );
	}else{
		p_sys->pWork = NutMix_CommPack_DummySys_Init( pCommPacketLocal, listNum, pWork, heapID );
		OS_Printf( "lӰރZbgAbv\n" );
	}

	return p_sys;
}

//----------------------------------------------------------------------------
/**
 *	@brief	R}h]@pbN֐
 *
 *	@param	command				R}h
 *	@param	data				f[^
 *	@param	size				TCY
 *	@param	p_sys				R}hpbNVXe
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s
 */
//-----------------------------------------------------------------------------
BOOL NMIX_CommPack_CommSendData( int command, const void* data, int size, NUTMIX_COMMPACK_WORK* p_sys )
{
	if( p_sys->comm_flg == NUTMIX_COMM_PACK_COMM ){
	    return CommSendData( command, data, size );
	}else{
		return NutMix_CommPack_DummySys_SendData( p_sys->pWork, command, data, size );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	R}he[u	pbNVXej
 *
 *	@param	p_sys	VXe
 */
//-----------------------------------------------------------------------------
void NMIX_CommPack_CommDelete( NUTMIX_COMMPACK_WORK* p_sys )
{
	if( p_sys->comm_flg == NUTMIX_COMM_PACK_ONE ){
		NutMix_CommPack_DummySys_Delete( p_sys->pWork );
	}
	sys_FreeMemoryEz( p_sys );
}


//----------------------------------------------------------------------------
/**
 *	@brief	̐ڑID擾
 *
 *	@param	p_sys	VXe
 *
 *	@return	ڑID
 */
//-----------------------------------------------------------------------------
int NMIX_CommPack_CommGetCurrentID( NUTMIX_COMMPACK_WORK* p_sys )
{
	if( p_sys->comm_flg == NUTMIX_COMM_PACK_COMM ){
	    return CommGetCurrentID();
	}else{
		return NUTMIX_COMM_PACK_DUMMY_NETID;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ʐM\ԂȂ̂ǂԂ R}hɂlSVG[V܂̏
 *
 *	@param	p_sys	VXe
 *	@param	netID	ڑID
 *
 *	@retval	TRUE	ڑĂ
 *	@retval	FALSE	ڑĂȂ
 */
//-----------------------------------------------------------------------------
BOOL NMIX_CommPack_CommIsConnect( NUTMIX_COMMPACK_WORK* p_sys, u16 netID )
{
	if( p_sys->comm_flg == NUTMIX_COMM_PACK_COMM ){
	    return CommIsConnect( netID );
	}else{
		if( netID == NUTMIX_COMM_PACK_DUMMY_NETID ){
			return TRUE;
		}else{
			return FALSE;
		}
	}
}



//-----------------------------------------------------------------------------
/**
 * 
 *		vCx[g֐
 * 
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *	@brief	_~[R[obNVXe
 *	
 *	@param	pCommPacketLocal	R}he[u
 *	@param	listNum				e[u
 *	@param	pWork				[N
 *	@param	heapID				q[vID
 *
 *	@return	쐬VXe[N
 */
//-----------------------------------------------------------------------------
static NUTMIX_COMMPACK_DUMMY_SYS* NutMix_CommPack_DummySys_Init( const CommPacketTbl* pCommPacketLocal,int listNum,void* pWork, int heapID )
{
	NUTMIX_COMMPACK_DUMMY_SYS* p_sys;

	// m
	p_sys = sys_AllocMemory( heapID, sizeof(NUTMIX_COMMPACK_DUMMY_SYS) );
	memset( p_sys, 0, sizeof(NUTMIX_COMMPACK_DUMMY_SYS) );

	p_sys->pCommPacketLocal	= pCommPacketLocal;
	p_sys->commtbl_num		= listNum;
	p_sys->pCallBackWork	= pWork;

	p_sys->tcb = VWaitTCB_Add( NutMix_CommPack_DummySys_Main, p_sys, NUTMIX_COMM_PACK_DUMMY_TCB_PRI );

	return p_sys;
}

//----------------------------------------------------------------------------
/**
 *	@brief	C@
 */
//-----------------------------------------------------------------------------
static void NutMix_CommPack_DummySys_Main( TCB_PTR tcb, void* p_work )
{
	NUTMIX_COMMPACK_DUMMY_SYS* p_sys = p_work;
	int i;

	// R[obN
	for( i=0; i<NUTMIX_COMM_PACK_DUMMY_WORK_NUM; i++ ){

		// f[^邩`FbN
		if( p_sys->work[i].init == TRUE ){
			p_sys->pCommPacketLocal[ p_sys->work[i].command ].callbackFunc( 
					NUTMIX_COMM_PACK_DUMMY_NETID, p_sys->work[i].size, 
					p_sys->work[i].data, p_sys->pCallBackWork );
			// [NNA
			memset( &p_sys->work[i], 0, sizeof(NUTMIX_COMMPACK_DUMMY_WORK) );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	_~[R[obNVXej
 *
 *	@param	p_sys	VXe[N 
 */
//-----------------------------------------------------------------------------
static void NutMix_CommPack_DummySys_Delete( NUTMIX_COMMPACK_DUMMY_SYS* p_sys )
{
	TCB_Delete( p_sys->tcb );
	sys_FreeMemoryEz( p_sys );
}

//----------------------------------------------------------------------------
/**
 *	@brief	R}ho^
 *
 *	@param	p_sys		VXe
 *	@param	command		R}h
 *	@param	data		f[^
 *	@param	size		TCY
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s
 */
//-----------------------------------------------------------------------------
static BOOL NutMix_CommPack_DummySys_SendData( NUTMIX_COMMPACK_DUMMY_SYS* p_sys, int command, const void* data, int size )
{
	int i;
	int check_size;
	NUTMIX_COMMPACK_DUMMY_WORK* p_work;

	// 󂢂Ă郏[N擾
	p_work = NULL;
	for( i=0; i<NUTMIX_COMM_PACK_DUMMY_WORK_NUM; i++ ){
		if( p_sys->work[i].init == FALSE ){
			p_work = &p_sys->work[i];
			break;
		}
	}
	// o^I[o[
	GF_ASSERT( p_work );


	// R}h̋ʕ
	command -= CS_COMMAND_MAX;

	// o^R}h̃TCYƃf[^TCY`FbN
	check_size = p_sys->pCommPacketLocal[ command ].getSizeFunc();
	GF_ASSERT( check_size == size );

	// _~[obt@TCY菬`FbN
	GF_ASSERT( size < NUTMIX_COMM_PACK_DATABUFF_SIZE );

	// f[^ݒ
	p_work->command = command;
	if( size > 0 ){	// TCYRs[
		memcpy( p_work->data, data, size );
	}
	p_work->size	= size;
	p_work->init	= TRUE;
	return TRUE;
}
