//=============================================================================
/**
 * @file	oekaki_local.h
 * @brief	G{[hp\̒`iQƗp)
 *          
 * @author	Akito Mori
 * @date    	2006.02.14
 */
//=============================================================================



#ifndef __OEKAKI_LOCAL_H__
#define __OEKAKI_LOCAL_H__

#include "system/touch_subwindow.h"

// @\{^p`
#define FUNCBUTTON_NUM	( 7 ) 		// @\{^̐
#define START_WORDPANEL ( 0 )		// ŏ̓̕pl̔ԍiOЂ炪ȁj

// ڑlMAX͂Tl
#define OEKAKI_MEMBER_MAX	( 5 )


// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define NAMEIN_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define NAMEIN_OAM_NUM			( 14 )


// bZ[W\WAIT
#define OEKAKI_MESSAGE_END_WAIT	( 60 )


// G{[h̕E
#define OEKAKI_BOARD_W	 	( 30 )
#define OEKAKI_BOARD_H	 	( 15 )
#define OEKAKI_GRAPHI_SIZE  ( OEKAKI_BOARD_W*OEKAKI_BOARD_H*32 )

// {^ZAN^[̃y`n܂ԍ
#define CELL_BRUSH_NO		( 9 )


// uV̑傫
#define SMALL_BRUSH			( 0 )
#define MIDDLE_BRUSH		( 1 )
#define BIG_BRUSH			( 2 )


// G֎~tO
#define OEKAKI_BAN_NONE		( 0 )
#define OEKAKI_BAN_OFF		( 1 )
#define OEKAKI_BAN_ON		( 2 )

// CV[PX̑J
enum {
	SEQ_IN = 0,
	SEQ_MAIN,
	SEQ_LEAVE,
	SEQ_OUT,
};

// TuV[PX̑Jڗp
enum{
	OEKAKI_MODE_INIT  = 0, 

	OEKAKI_MODE_NEWMEMBER,
	OEKAKI_MODE_NEWMEMBER_WAIT,
	OEKAKI_MODE_NEWMEMBER_END,

	OEKAKI_MODE,

	OEKAKI_MODE_END_SELECT,
	OEKAKI_MODE_END_SELECT_WAIT,
	OEKAKI_MODE_END_SELECT_ANSWER_WAIT,
	OEKAKI_MODE_END_SELECT_ANSWER_OK,
	OEKAKI_MODE_END_SELECT_ANSWER_NG,

    OEKAKI_MODE_END_CHILD,
    OEKAKI_MODE_END_CHILD_WAIT,
    OEKAKI_MODE_END_CHILD_WAIT2,

	OEKAKI_MODE_END_SELECT_PARENT,
    OEKAKI_MODE_END_SELECT_PARENT_WAIT,

	OEKAKI_MODE_FORCE_END,
    OEKAKI_MODE_FORCE_END_WAIT,
    OEKAKI_MODE_FORCE_END_SYNCHRONIZE,
	OEKAKI_MODE_FORCE_END_WAIT_NOP,

	OEKAKI_MODE_END_PARENT_ONLY,
	OEKAKI_MODE_END_PARENT_ONLY_WAIT,

	OEKAKI_MODE_LOGOUT_CHILD,
    OEKAKI_MODE_LOGOUT_CHILD_WAIT,
    OEKAKI_MODE_LOGOUT_CHILD_CLOSE,
    
};


enum{
	OEKAKI_SYNCHRONIZE_END=200,
};

// ㉺ʎw`
#define BOTH_LCD	( 2 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB

// BMPWINw
enum{
	BMP_NAME1_S_BG0,
	BMP_NAME2_S_BG0,
	BMP_NAME3_S_BG0,
	BMP_NAME4_S_BG0,
	BMP_NAME5_S_BG0,
	BMP_OEKAKI_MAX,
};





// ^b`pl\
// ̃f[^ʐMőM܂
typedef struct{
	u8 x[4];	// őS񕪂̃^b`W
	u8 y[4];	// 
	u8 color:3;	// I𒆂̃J[
	u8 size:3;	// TvO
	u8 brush:2; // I𒆂̃y
	u8 banFlag;  // ֎~tO(e@̂ݑMj
}TOUCH_INFO;

typedef struct{
	u8   x,y;
	u16  size;
}OLD_TOUCH_INFO;

typedef struct{
	u8  chara[1000];
	u32 _xor;
	u8  no;
	u8  dummy[3];
}OEKAKIG_SPLIT_DATA;

//============================================================================================
//	\̒`
//============================================================================================

struct OEKAKI_WORK{
	GF_BGL_INI		*bgl;
	BOOL			wipe_end;
	OEKAKI_PARAM	*param;

	WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
	STRBUF			*TrainerName[OEKAKI_MEMBER_MAX];		// O
	STRBUF			*EndString;								// u߂v
	STRBUF			*TalkString;							// bbZ[Wp
	int				MsgIndex;								// Iop[N

	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[BOTH_LCD][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
	CLACT_WORK_PTR			MainActWork[NAMEIN_OAM_NUM];				// ZAN^[[N|C^z
	CLACT_WORK_PTR			SubActWork[NAMEIN_OAM_NUM];				// ZAN^[[N|C^z
	CLACT_WORK_PTR			ButtonActWork[12];						// {^AN^[|C^

	GF_BGL_BMPWIN 			TrainerNameWin[BMP_OEKAKI_MAX];			// GʗpBMPEChE
	GF_BGL_BMPWIN			OekakiBoard;
	GF_BGL_BMPWIN			MsgWin;									// bEChE
	GF_BGL_BMPWIN			EndWin;									// ߂
	GF_BGL_BMPWIN			*YesNoWin[2];								// ͂EEChẼ|C^

	int						proc_seq;								// MainProc̃V[PXĎ邽߂ɂ
																	// iTuV[PX͏Ȃj
	int						seq;									// ݂̃TuV[PX
	int						next_seq;								// ̃V[PX͉H
	int						mode;									// ݍőOʂ̕pl
	int						wait;
	int						connectBackup;							// O̐ڑl
	int						shareNum;								// 摜Mς݂̐l
	int						shareBit;								// 摜Mς݂̐l(rbg)
	int						newMemberId;							// ĂlID
	
	u8						ConnectCheck[8][2];
	MYSTATUS				*TrainerStatus[8][2];

	u8						SendBoardGraphic[0x4000];
	u16						CursorPal;
	u8						brush_color;
	u8						brush;

	TOUCH_INFO				MyTouchResult;							// ̃TvOʁi͑M邾
	TOUCH_INFO				AllTouchResult[OEKAKI_MEMBER_MAX];		// ʐMŎ擾TvOʁĩf[^ŕ`悷
	OLD_TOUCH_INFO			OldTouch[OEKAKI_MEMBER_MAX];			// O񂩂̃|Cg

	u8						*lz_buf;								// k摜i[̈
	int						send_num;
	u8						canvas_buf[OEKAKI_GRAPHI_SIZE];
	OEKAKIG_SPLIT_DATA		send_buf;
	OEKAKIG_SPLIT_DATA		split_temp[OEKAKI_MEMBER_MAX];

	s32 					err_num;								// ʐMI݂邽߂̃[N
	u32						ridatu_bit;								// E悤ƂĂqBit
	u16						oya_share_num;			// eĂshareNum炤
	s16						ridatu_wait;			// Ep̃EFCg
	u8						status_end;								// TRUE:IV[PXֈڍs

	// ----eKvȃ[N

	TOUCH_INFO				ParentTouchResult[5];
	TOUCH_SW_SYS			*TouchSubWindowSys;
	int						banFlag;
	int						yesno_flag;								// ݁u͂EvʂĂяo
	int						firstChild;								// ԍŏɂĂƂɎq@痐錾Ă
	int						ireagalJoin;							//GIɗꂽ
	int						bookJoin;								//\tO
	int						joinBit;								//҃rbg
#ifdef PM_DEBUG
	int 					frame;									//
	int						framenum[9][2];							//
#endif
};

//--------------------------------------------------------------
/**
 * @brief   ̍\̂̒gւAKʐM֐e[u
 *          CommRecordCornerEndChildgpĂӏ̑MTCYύX邱ƁII
 *			t@CFcomm_command_record.c, comm_command_oekaki.c, comm_command_field.c
 */
//--------------------------------------------------------------
typedef struct{
	u8 ridatu_id;			///<E҂ID
	u8 oya_share_num;		///<e̎shareNum
	u8 request;				///<߃R[h
	u8 ridatu_kyoka;		///<TRUE:EOKAFALSE:ENG
}COMM_OEKAKI_END_CHILD_WORK;

enum{
	COEC_REQ_RIDATU_CHECK,		///<EmF
	COEC_REQ_RIDATU_EXE,		///<Es
};


extern void OekakiBoardCommSendPokeData(int netID, POKEPARTY *party, int no);
extern void OekakiBoardCommSend(int netID, int command, int pos);
extern void OekakiBoard_MainSeqCheckChange( OEKAKI_WORK *wk, int seq, u8 id );
extern void OekakiBoard_MainSeqForceChange( OEKAKI_WORK *wk, int seq, u8 id  );
extern int OekakiBoard_MyStatusGetNum(void);


#endif
