/**
 *	@file	poru_oam.c
 *	@brief	|gAN^[@OAMRg[
 *	@author	Miyuki Iwasawa
 *	@date	06.03.28
 */

#include "common.h"
#include "system/clact_tool.h"

#define PORUTO_OAM_H_GLOBAL
#include "poru_oam.h"
#include "poruact.naix"

#define PORUOAM_PAL_MAX	(16)

#define RES_CHRID	(NARC_poruact_poru_act_ncgr)
#define RES_CELID	(NARC_poruact_poru_act_ncer)
#define RES_ANMID	(NARC_poruact_poru_act_nanr)
#define RES_PALID	(NARC_poruact_poru_001_nclr)
#define RES_NOCOMP	(0)
#define RES_NOTRANS	(0)
#define RES_HEADID (0xe000)

enum{
 RESTYPE_CHR,
 RESTYPE_PAL,
 RESTYPE_CEL,
 RESTYPE_ANM,
};

#define PORUOAM_CHR_RES_MAX	(1)
#define PORUOAM_PAL_RES_MAX	(1)
#define PORUOAM_CEL_RES_MAX	(1)
#define PORUOAM_ANM_RES_MAX	(1)


//======================================================
//vg^Cv
//======================================================
static void PoruOam_ResManagerInit(PORUOAM_MAN* wk);
static void PoruOam_ResManagerRelease(PORUOAM_MAN* wk);

static void poam_LoadResArc(PORUOAM_MAN* wk);
static s16 poam_GetNullWork(PORUOAM_MAN* wk,u8 flavor);

/**
 *	@brief	|gAN^[@}l[W
 *
 *	@param	heapID	q[vID
 *	@param	actmax	mۂZAN^[̈̌
 *	@param	palmax	|gpɐLOBJpbg̖{
 *	@param	vramType	`ʎw(PORUOAM_DRAW_MAIN/SUB/BOTH)
 *  @param	cgx_transofs	LN^]ItZbgw
 *							(PORUOAM_CGXOFS_AREAw肵ꍇA󂫗̈挟[hɂȂ)	
 */
PORUOAM_MAN* PoruOam_SysInit(int heapID,u16 actmax,u16 palmax,
		u16 vramType,PORUOAM_CGXOFS cgx_transofs)
{
	PORUOAM_MAN* wk;

	wk = sys_AllocMemory(heapID,sizeof(PORUOAM_MAN));
	MI_CpuClear8(wk,sizeof(PORUOAM_MAN));

	//p[^ۑ
	wk->heapID = heapID;

	if(actmax > PORUOAM_PAL_MAX){
		wk->pal_num = PORUOAM_PAL_MAX;
	}else{
		wk->pal_num = palmax;
	}
	wk->act_max = actmax;
	wk->vramType = vramType;
	wk->cgx_transofs = cgx_transofs;
	
	PoruOam_ResManagerInit(wk);
	return wk;
}

/**
 *	@brief	|gAN^[@}l[W
 */
void PoruOam_SysRelease(PORUOAM_MAN* wk)
{
	PoruOam_ResManagerRelease(wk);
	MI_CpuClear8(wk,sizeof(PORUOAM_MAN));
	sys_FreeMemoryEz(wk);
}


/**
 *	@brief	\[X}l[W쐬
 */
static void PoruOam_ResManagerInit(PORUOAM_MAN* wk)
{
	u32 i, j;
	u8	resnum[] = {PORUOAM_CHR_RES_MAX,1,PORUOAM_CEL_RES_MAX,PORUOAM_ANM_RES_MAX};

	wk->cas  = CLACT_U_SetEasyInit(wk->act_max, &wk->renddata,wk->heapID);

	// \[X}l[W[쐬&e[u
	resnum[RESTYPE_PAL] = wk->pal_num;
	for( i=0; i< PORUOAM_RESMAX; i++ ){
		wk->resMan[i] = CLACT_U_ResManagerInit(resnum[i],i, wk->heapID );
		wk->resObjTbl[i] = CLACT_U_ResManagerResObjTblMake(resnum[i],wk->heapID);
		for( j=0; j<wk->resObjTbl[i]->tbl_num; j++ ){
			wk->resObjTbl[i]->tbl[j] = NULL;
		}
	}

	//\[X[h
	poam_LoadResArc(wk);

	//pbg[Nm
	wk->work = sys_AllocMemory(wk->heapID,sizeof(PORUOAM_ACTWORK));
	MI_CpuClear8(wk->work,sizeof(PORUOAM_ACTWORK));
}

/**
 *	@brief	\[X}l[W
 */
static void PoruOam_ResManagerRelease(PORUOAM_MAN* wk)
{
	u32	i;

	//pbg[Nj
	sys_FreeMemoryEz(wk->work);

	CLACT_DestSet( wk->cas );	// Zbgj
	CLACT_U_CharManagerDeletes( wk->resObjTbl[RESTYPE_CHR] );	// Lf[^j
	CLACT_U_PlttManagerDeletes( wk->resObjTbl[RESTYPE_PAL] );	// pbgf[^j

	for( i=0; i<PORUOAM_RESMAX; i++ ){
		// \[XIuWFe[uj
		CLACT_U_ResManagerResObjTblDelete( wk->resObjTbl[i] );
		// \[X}l[Wj
		CLACT_U_ResManagerDelete( wk->resMan[i] );
	}
}

/**
 *	@brief	|gOAM@`惁C
 */
void PoruOam_DrawMain(PORUOAM_MAN* wk)
{
	CLACT_Draw(wk->cas);
}

/**
 *	@brief	|gOAMǉ
 *
 *	@param	flavor	|g̎ID
 *	@param	x		XW
 *	@param	y		YW
 *	@param	z		ZW
 *	@param	bg_pri	BGvCIeB
 *	@param	spri	\tgEFAvCIeB
 *	@param	vram_type	PORUOAM_VRAMTYPE^
 *						PORUOAM_VT_MAIN:C
 *						PORUOAM_VT_SUB:Tu
 *
 *	KPoruOam_Del֐Ŕj邱
 */
PORUTO_OAM* PoruOam_Add(PORUOAM_MAN* wk,PORUTO_FLAVORID flavor,
		u16 x,u16 y,u16 z,u8 bg_pri,u8 spri,PORUOAM_VRAMTYPE vtype)
{
	u8	vram_type;
	s16	idx;
	u32	palid;
	PORUTO_OAM* oam;
	CATS_ACT_PTR cap = NULL;
	CLACT_ADD	 add;
	CLACT_U_RES_OBJ_PTR	obj;

	//[N̋󂫗̈T
	idx = poam_GetNullWork(wk,flavor);
	if(idx < 0){
		//󂫗̈悪Ȃ
		GF_ASSERT(0 && "PoruOam_Add->work was full");
		return NULL;
	}

	//OAM[Nm
	oam = sys_AllocMemory(wk->heapID,sizeof(PORUTO_OAM));
	MI_CpuClear8(oam,sizeof(PORUTO_OAM));
	oam->workID = idx;
	
	if(vtype == PORUOAM_VT_MAIN){
		vram_type = NNS_G2D_VRAM_TYPE_2DMAIN;
	}else{
		vram_type = NNS_G2D_VRAM_TYPE_2DSUB;
	}

	obj = wk->resObjTbl[RESTYPE_PAL]->tbl[idx];
	//pbg\[Xǂݑւ
	CLACT_U_ResManagerResChgArcPltt(wk->resMan[RESTYPE_PAL],
		wk->resObjTbl[RESTYPE_PAL]->tbl[idx],
		ARC_PORUACT_GRA,RES_PALID+flavor,RES_NOCOMP,wk->heapID);
	CLACT_U_PlttManagerReTrans(wk->resObjTbl[RESTYPE_PAL]->tbl[idx]);

	//[Nm
	cap = sys_AllocMemory(wk->heapID, sizeof(TCATS_ACT) );

	//wb_[m
	cap->act_htp = sys_AllocMemory(wk->heapID,sizeof(CLACT_HEADER_TBL));
	cap->act_htp->tbl = sys_AllocMemory(wk->heapID,sizeof(CLACT_HEADER));
	cap->act_hd = cap->act_htp->tbl;

	//wb_[
	CLACT_U_MakeHeader(
		cap->act_hd,
		RES_HEADID,RES_HEADID+idx,
		RES_HEADID,RES_HEADID,
		CLACT_U_HEADER_DATA_NONE,CLACT_U_HEADER_DATA_NONE,
		RES_NOTRANS, bg_pri,
		wk->resMan[RESTYPE_CHR],wk->resMan[RESTYPE_PAL],
		wk->resMan[RESTYPE_CEL],wk->resMan[RESTYPE_ANM],
		NULL,NULL);	

	// OAMo^
	add.ClActSet	= wk->cas;
	add.ClActHeader = cap->act_hd;

	add.mat.x		= FX32_CONST(x);
	add.mat.y		= FX32_CONST(y);
	add.mat.z		= FX32_CONST(z);
	if(vram_type == NNS_G2D_VRAM_TYPE_2DSUB){
		add.mat.y += SUB_SURFACE_Y;
	}
	
	add.sca.x		= FX32_ONE;			// gk
	add.sca.y		= FX32_ONE;
	add.sca.z		= FX32_ONE;
	
	add.rot			= 0;				// ]p
	add.pri			= spri;				// Dx
	add.DrawArea	= vram_type;		// `
	add.heap		= wk->heapID;		// q[vID
	
	cap->act = CLACT_Add(&add);			//o^
	
	if (cap->act != NULL){
		CLACT_AnmChg(cap->act,0);		//Aj[Vw
		palid = CLACT_U_PlttManagerGetPlttNo(
			obj,vram_type);
		CLACT_PaletteNoChg(cap->act,palid);		//pbgw
	}
	else{
		GF_ASSERT(0 &&"poruto oam add failed");
	}
	oam->act = cap;
	return oam;		
}

/**
 *	@brief	o^ςOAM̃|g̎ނύX
 *	
 *	@param	flavor	|g̎ID
 */
void PoruOam_ChangeFlavor(PORUOAM_MAN*wk,PORUTO_OAM* oam,PORUTO_FLAVORID flavor)
{
	CLACT_U_RES_OBJ_PTR	obj;

	obj = wk->resObjTbl[RESTYPE_PAL]->tbl[oam->workID];

	//pbg\[Xǂݑւ
	CLACT_U_ResManagerResChgArcPltt(wk->resMan[RESTYPE_PAL],
		obj,ARC_PORUACT_GRA,RES_PALID+flavor,RES_NOCOMP,wk->heapID);
	CLACT_U_PlttManagerReTrans(obj);
}

/**
 *	@brief	|gOAM폜
 */
void PoruOam_Del(PORUOAM_MAN* wk,PORUTO_OAM* oam)
{
	//AN^[폜
	CATS_ActorPointerDelete_S(oam->act);
	
	//[N
	wk->work[oam->workID].valid = 0;
	wk->work[oam->workID].resNo = 0;
	wk->work[oam->workID].flavor = 0;

	sys_FreeMemoryEz(oam);
}

/**
 *	@brief	\[Xݒ
 */
static void poam_LoadResArc(PORUOAM_MAN* wk)
{
	int i;
	CLACT_U_RES_MANAGER_PTR	res;
	CLACT_U_RES_OBJ_TBL* obj;
	CLACT_U_RES_OBJ_PTR tmp;

	//LN^\[X擾
	obj = wk->resObjTbl[RESTYPE_CHR];
	obj->tbl[0] = CLACT_U_ResManagerResAddArcChar(wk->resMan[RESTYPE_CHR],
		ARC_PORUACT_GRA,RES_CHRID,RES_NOCOMP,RES_HEADID,wk->vramType,wk->heapID);
	
	GF_ASSERT((obj->tbl[0]!=NULL)&&"poam char resload failed");

	switch(wk->cgx_transofs){
	case PORUOAM_CGXOFS_AREA:
		CLACT_U_CharManagerSetAreaCont(obj->tbl[0]);
		break;
	case PORUOAM_CGXOFS_ADJUST:
		CLACT_U_CharManagerSetCharModeAdjustAreaCont(obj->tbl[0]);
		break;
	case PORUOAM_CGXOFS_AUTO:
	default:
		CLACT_U_CharManagerSet(obj->tbl[0]);
		break;
	}

	//Z&ZAj\[X擾
	for(i = 0;i < 2;i++){
		obj = wk->resObjTbl[RESTYPE_CEL+i];
		obj->tbl[0] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[RESTYPE_CEL+i],
			ARC_PORUACT_GRA,RES_CELID+i,RES_NOCOMP,RES_HEADID,RESTYPE_CEL+i,wk->heapID);
	
		GF_ASSERT((obj->tbl[0]!=NULL)&&"poam cell&canm resload failed");
	}

	//pbg\[X擾(No.001őS)
	obj = wk->resObjTbl[RESTYPE_PAL];
	for(i = 0;i < wk->pal_num;i++){
		obj->tbl[i] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[RESTYPE_PAL],
			ARC_PORUACT_GRA,RES_PALID+1,RES_NOCOMP,RES_HEADID+i,wk->vramType,1,wk->heapID);
		
		GF_ASSERT((obj->tbl[i]!=NULL)&&"poam pal resload failed");
//		CLACT_U_PlttManagerSetCleanArea(obj->tbl[i]);
		CLACT_U_PlttManagerSet(obj->tbl[i]);
	}
}

/**
 *	@brief	󂫃[NT
 */
static s16 poam_GetNullWork(PORUOAM_MAN* wk,u8 flavor)
{
	u16 i = 0;

	for(i = 0;i < wk->pal_num;i++){
		if(!wk->work[i].valid){
			wk->work[i].resNo = i;
			wk->work[i].flavor = flavor;
			wk->work[i].valid = 1;
			return i;
		}
	}
	return -1;
}
