//=============================================================================
/**
 * @file	comm_command_record.c
 * @brief	f[^𑗂邽߂̃R}he[uĂ܂
 *          R[hR[i[pł
 * @author	Akito Mori
 * @date    2006.03.27
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "system/procsys.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "system/bmp_menu.h"
#include "application/record_corner.h"
#include "system/snd_tool.h"

typedef struct RECORD_WORK RECORD_WORK;

#include "record_corner_local.h"


#include "comm_command_record.h"

#include "communication/wh.h"



static int _getZero(void);
static int _getOne(void);
static int _getRecordSize(void);
static u8* _getRecordRecvBuf( int netID, void* pWork, int size );
static int _getCRECW(void);


static void RecordCorner_DataSend( RECORD_WORK *wk, int no);
void CommRecord_RecordData( int netID, int size, void* pBuff, void* pWork );
void CommRecordBanFlag( int netID, int size, void* pBuff, void* pWork );


// ΉR[obN֐
static const CommPacketTbl _CommPacketTbl[] = {
    { CommDummyCallBack, _getZero, NULL},// comm_command_field.cœo^ĂR}he[u̖邽߂
    { CommDummyCallBack, _getZero, NULL},// o^
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},	// comm_command_field.cœo^ĂR}he[u̖邽߂
    { CommDummyCallBack, _getZero, NULL}, // o^

	// R[hgpR}h
	{CommRecordCornerYes,   		_getOne},              	// CR_RECORD_YES  		 ͂
	{CommRecordCornerNo,   	   	 	_getOne},             	// CR_RECORD_NO,		 
    {CommRecordCornerStop,			_getOne},             	// CR_RECORD_STOP,		 ҂̂ňUXgbv
    {CommRecordCornerReStart,		_getZero},             	// CR_RECORD_RESTART,	 ҏÎōĉ
    {CommRecordCornerEndChild,		_getCRECW},            	// CR_RECORD_END_CHILD,	 q@E
    {CommRecordCornerEnd,			_getZero},              // CR_RECORD_END,		 I
	{CommRecordCornerChildJoin,		_getZero},				// CR_RECORD_CHILD_JOIN, q@錾
	{CommRecordStart,				_getZero},				// CR_RECORD_START, 	 R[hJneʒB
	{CommRecord_RecordData,			_getRecordSize, _getRecordRecvBuf},// CR_RECORD_DATA, 	 R[hJneʒB
	{CommRecordBanFlag,				_getOne},				// CR_RECORD_BAN		E֎~ʒB

	// ̃R}h𖳎邽߂̕
	{ CommDummyCallBack, _getZero, NULL},
	{ CommDummyCallBack, _getZero, NULL},
	{ CommDummyCallBack, _getZero, NULL},
	{ CommDummyCallBack, _getZero, NULL},
	{ CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
    { CommDummyCallBack, _getZero, NULL},
	{ CommDummyCallBack, _getZero, NULL},
	{ CommDummyCallBack, _getZero, NULL},

};


//==============================================================================
/**
 * G{[hpʐMR}ho^
 *
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommCommandRecordInitialize(void* pWork)
{
	RECORD_WORK *wk = (RECORD_WORK *)pWork;

	int i;
	
	// MR[obNݒ
    int length = sizeof(_CommPacketTbl)/sizeof(CommPacketTbl);
    CommCommandInitialize(_CommPacketTbl, length, pWork);


	// f[^Mobt@ݒ
	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
//		CommSetSpritDataRecvBuff( i, &wk->recv_data[i], sizeof(RECORD_DATA) );
	}
}


//==============================================================================
/**
 * $brief   R[hf[^MR[obN֐
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommRecord_RecordData( int netID, int size, void* pBuff, void* pWork )
{
	RECORD_WORK *wk = (RECORD_WORK *)pWork;

	wk->recv_count++;

	OS_Printf("R[hf[^M id=%d\n",netID);
}

//==============================================================================
/**
 * @brief   EtO
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommRecordBanFlag( int netID, int size, void* pBuff, void* pWork )
{
	RECORD_WORK *wk = (RECORD_WORK *)pWork;
	u8  *flag        = (u8*)pBuff;

	if(netID==0){
		if(wk->banFlag != *flag){
			OS_Printf("e@̗E֎~tO banFlag=%d\n",*flag);
		}
		wk->banFlag = *flag;
	}
	
}


//------------------------------------------------------------------
/**
 * $brief   R[hJn
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
void CommRecordStart(int netID, int size, void* pBuff, void* pWork)
{
	RECORD_WORK *wk = (RECORD_WORK*)pWork;

	wk->recv_count = 0;
	wk->record_execute = TRUE;
	
	// R[hf[^MJn
	RecordCorner_DataSend( wk, CommGetCurrentID());

	// ʏ㕔uR[h񂿂イIv
	RecordCornerTitleChange( wk );

	RecordCorner_MainSeqForceChange( wk, RECORD_MODE_RECORD_SEND_DATA, netID );
	
    CommStateSetErrorCheck(TRUE,TRUE); // ȍ~͐ؒfG[

	// SE
	Snd_SePlay(SEQ_SE_DP_F209);

}


//==============================================================================
/**
 * ʐMʂJn
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommRecordCornerReStart(int netID, int size, void* pBuff, void* pWork)
{
	RECORD_WORK *wk = (RECORD_WORK*)pWork;

	OS_Printf("e@烌R[hWĊJʒm\n");
	RecordCorner_MainSeqForceChange( wk, RECORD_MODE_NEWMEMBER_END, 0 );
	
}
//==============================================================================
/**
 * $brief   q@E
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		q(E)̑M0:EmFB@1:Es
 *						ȇM4rbgFeshareNum(0xf̏ꍇ͗ENG)
 * 									4rbgFE҂ID
 * @param   pWork		RECORD_WORK*
 *
 * @retval  none		
 */
//==============================================================================
void CommRecordCornerEndChild(int netID, int size, void* pBuff, void* pWork)
{
	RECORD_WORK *wk = (RECORD_WORK*)pWork;
	COMM_RECORD_END_CHILD_WORK trans_work;
	COMM_RECORD_END_CHILD_WORK *recieve_work;
	
	recieve_work = pBuff;
	
	if(netID != 0){
		//q@(E)̑M
		//E܂ʒm
		if(CommGetCurrentID()==0){
			// q@(e@󂯎)
			// q@ȂȂSɒʒm
			trans_work = *recieve_work;
			trans_work.ridatu_id = netID;
			trans_work.oya_share_num = wk->shareNum;
			switch(recieve_work->request){
			case CREC_REQ_RIDATU_CHECK:
				if(wk->shareNum != CommGetConnectNum() 
						|| wk->shareNum != RecordCorner_MyStatusGetNum()
						|| wk->shareNum != MATH_CountPopulation(WH_GetBitmap())){
					trans_work.ridatu_kyoka = FALSE;	//ENGI
				}
				else{
					wk->ridatu_bit |= 1 << netID;
					trans_work.ridatu_kyoka = TRUE;
					//EOKȂ̂ŎQ(΂瑤Ő͂͂)
					CommStateSetLimitNum(CommGetConnectNum());
				}
				break;
			case CREC_REQ_RIDATU_EXE:
				break;
			}

			CommSendData( CR_RECORD_END_CHILD, &trans_work, sizeof(COMM_RECORD_END_CHILD_WORK) );
			OS_Printf("q@%d痣E󂯎M\n",netID);
		}
	}
	else{
		//ȇM
		switch(recieve_work->request){
		case CREC_REQ_RIDATU_CHECK:
			//EmFȂ̂ŁAE悤Ƃq@ɂ̂݌ʂ𑗂
			if(recieve_work->ridatu_id == CommGetCurrentID()){
				if(recieve_work->ridatu_kyoka == FALSE){
					RecordCorner_MainSeqForceChange( wk, RECORD_MODE_END_SELECT_ANSWER_NG, recieve_work->ridatu_id );
				}
				else{
					wk->oya_share_num = recieve_work->oya_share_num;
					RecordCorner_MainSeqForceChange( wk, RECORD_MODE_END_SELECT_ANSWER_OK, recieve_work->ridatu_id );
				}
			}
			break;
		case CREC_REQ_RIDATU_EXE:
			OS_Printf("e@q@%d̗Eʒm\n", recieve_work->ridatu_id);
		//	RecordCorner_MainSeqCheckChange( wk, RECORD_MODE_LOGOUT_CHILD, id );
			RecordCorner_MainSeqForceChange( wk, RECORD_MODE_LOGOUT_CHILD, recieve_work->ridatu_id );
			break;
		}
	}
}

//==============================================================================
/**
 * $brief   uq@Ă̂ňUG𑗂~܂Ăˁv
 *			Ɛe@MẴR[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommRecordCornerStop(int netID, int size, void* pBuff, void* pWork)
{

	RECORD_WORK *wk = (RECORD_WORK*)pWork;
	u8 id;

	id = *(u8*)pBuff;
	// CV[PXύX
	RecordCorner_MainSeqCheckChange( wk, RECORD_MODE_NEWMEMBER, id );

	// e@摜f[^MJn
	if(CommGetCurrentID()==0){
		wk->send_num = 0;

		// ŃR[hR[i[pf[^FőMJn(낤)
		// RECORD_GraphicDataSend(wk, wk->send_num);
	}


	OS_Printf("e@́uq@%dɊG𑗂邩~܂Ăˁvʒm\n",id);

}

void CommRecordCornerYes(int netID, int size, void* pBuff, void* pWork)
{
	
}
void CommRecordCornerNo(int netID, int size, void* pBuff, void* pWork)
{
	
}

//==============================================================================
/**
 * $brief   e@߂̂ŋI
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommRecordCornerEnd(int netID, int size, void* pBuff, void* pWork)
{
	RECORD_WORK *wk = (RECORD_WORK*)pWork;
	OS_Printf("e@̏Iʒm̂ł߂\n");

	// e@ȊO͂̃R}hŋイ傤
	if(CommGetCurrentID() != 0){
		RecordCorner_MainSeqForceChange( wk, RECORD_MODE_FORCE_END, 0  );
	}
}

//==============================================================================
/**
 * $brief   RځESځETڂ̎q@uG[vƌ
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommRecordCornerChildJoin(int netID, int size, void* pBuff, void* pWork)
{
	u8 id;
//	GF_ASSERT(CommGetCurrentID()==0 && "q@Ƃ");

	// e@󂯎(Ƃe󂯎Ȃǁj
	if(CommGetCurrentID()==0){
		id  = netID;
		
		// SɁuꂩG𑗂̂Ŏ~܂ĂvƑM
		CommSendData( CR_RECORD_STOP, &id, 1 );
		OS_Printf("q@(%d = %d)̗^Ĝʒm\n",id,netID);
	}
	
}





//------------------------------------------------------------------
/**
 * $brief   OtBbNf[^𕪊M
 *
 * @param   wk		
 * @param   no		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void RecordCorner_DataSend( RECORD_WORK *wk, int no)
{
	// xor擾Ei[
	{
		int i;
		u32 *p,result;
		p = (u32*)wk->send_data.data;
		for(result=0,i=0;i<RECORD_SEND_DATASIZE/4;i++){
			result ^= p[i];
		}
		wk->send_data._xor        = result;
	}

	// ԍ(e@̒lgpj
	wk->send_data.seed = gf_rand();
	
	// MJn
//	CommSendSpritData( &wk->send_data, sizeof(RECORD_DATA) );
	CommSendHugeData(CR_RECORD_DATA, &wk->send_data, sizeof(RECORD_DATA) );
	

	OS_Printf("Mf[^ no=%d, xor = %08x\n",  wk->send_data.seed,  wk->send_data._xor);
}


//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------
// pbgTCYʒm֐Q
//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------


//--------------------------------------------------------------------------------
// 0oCg\֐
//--------------------------------------------------------------------------------
static int _getZero(void)
{
    return 0;
}

//--------------------------------------------------------------------------------
// 1oCg\֐
//--------------------------------------------------------------------------------
static int _getOne(void)
{
    return 1;
}

//--------------------------------------------------------------------------------
// 1oCg\֐
//--------------------------------------------------------------------------------
static int _getCRECW(void)
{
	return sizeof(COMM_RECORD_END_CHILD_WORK);
}


//--------------------------------------------------------------------------------
// R[hf[^̎Mobt@ݒ肷֐
//--------------------------------------------------------------------------------
static u8* _getRecordRecvBuf( int netID, void* pWork, int size )
{
	RECORD_WORK *wk = (RECORD_WORK*)pWork;
	
	return (u8*)&wk->recv_data[netID];
}
