//============================================================================================
/**
 * @file	record_corner.c
 * @bfief	R[hR[i[ʏ
 * @author	Akito Mori
 * @date	06.03.26
 */
//============================================================================================
#define DEBUGPLAY_ONE	( 0 )



#include "common.h"
#include "system/procsys.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/pm_str.h"
#include "system/clact_tool.h"
#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_record.h"
#include "system/wipe.h"
#include "system/fontproc.h"
#include "system/lib_pack.h"
#include "system/fontoam.h"
#include "system/window.h"
#include "gflib/msg_print.h"
#include "gflib/touchpanel.h"
#include "poketool/monsno.h"
#include "system/bmp_menu.h"
#include "application/record_corner.h"
#include "system/snd_tool.h"
#include "gflib/strbuf_family.h"
#include "msgdata/msg_opening_name.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "communication/comm_save.h"
#include "communication/wm_icon.h"
#include "field/fld_bmp.h"
#include "field/fieldobj.h"
#include "field/comm_union_beacon.h"
#include "field/comm_union_view_common.h"
#include "field/union_beacon_tool.h"
#include "field/fieldobj_code.h"

#include "record_corner_local.h"

#include "comm_command_record.h"


#include "msgdata/msg_ev_win.h"

// SEp`
#define RECORD_MOVE_SE		(SEQ_SE_DP_SELECT)
#define RECORD_DECIDE_SE	(SEQ_SE_DP_SELECT)
#define RECORD_BS_SE		(SEQ_SE_DP_SELECT)

#define FIELDOBJ_PAL_START	( 7 )

#define RECORD_1SEC_WAIT	( 45 )

#include "record.naix"			// OtBbNA[JCu`
#include "../wifi_worldtrade/worldtrade.naix"
#include "../../field/poketch/poketch_arc.h"

#include "communication/wh.h"

//============================================================================================
//	萔`
//============================================================================================
enum {
	SEQ_IN = 0,
	SEQ_MAIN,
	SEQ_LEAVE,
	SEQ_OUT,
};

enum{
	LIMIT_MODE_NONE,	///<Ȃ
	LIMIT_MODE_TRUE,	///<
	LIMIT_MODE_ONLY,	///<(l̂)
};



//============================================================================================
//	vg^Cv錾
//============================================================================================

/*** ֐vg^Cv ***/
static void VBlankFunc( void * work );
static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void InitWork( RECORD_WORK *wk );
static void FreeWork( RECORD_WORK *wk );
static void BgExit( GF_BGL_INI * ini );
static void BgGraphicSet( RECORD_WORK * wk );
static void char_pltt_manager_init(void);
static void InitCellActor(RECORD_WORK *wk);
static void SetCellActor(RECORD_WORK *wk);
static void BmpWinInit(RECORD_WORK *wk, PROC* proc);
static void BmpWinDelete( RECORD_WORK *wk );
static void CursorAppearUpDate(RECORD_WORK *wk, int arrow);
static void SetCursor_Pos( CLACT_WORK_PTR act, int x, int y );
static void EndSequenceCommonFunc( RECORD_WORK *wk );
static void CursorColTrans(u16 *CursorCol);
static BOOL NameCheckPrint( GF_BGL_BMPWIN *win, int frame, GF_PRINTCOLOR color, RECORD_WORK *wk );
static int  ConnectCheck( RECORD_WORK *wk );
static BOOL  MyStatusCheck( RECORD_WORK *wk );
static void RecordMessagePrint( RECORD_WORK *wk, int msgno, int all_put );
static int  EndMessageWait( int msg_index );
static void EndMessageWindowOff( RECORD_WORK *wk );
static int  OnlyParentCheck( void );
static int  MyStatusGetNum( void );
static void RecordDataSendRecv( RECORD_WORK *wk );
static void CenteringPrint(GF_BGL_BMPWIN *win, STRBUF *strbuf, int wait);
static void SequenceChange_MesWait( RECORD_WORK *wk, int next );
static void TrainerObjFunc( RECORD_WORK *wk );
static void LoadFieldObjData( RECORD_WORK *wk );
static void FreeFieldObjData( RECORD_WORK *wk );
static void TransFieldObjData( NNSG2dCharacterData *CharaData[2], NNSG2dPaletteData *PalData[2], int id, int view, int sex );
static void TransPal( TCB_PTR tcb, void *work );
static int GetTalkSpeed( RECORD_WORK *wk );
static void ChangeConnectMax( RECORD_WORK *wk, int plus );
static int  RecordCorner_BeaconControl( RECORD_WORK *wk, int plus );
static void PadControl( RECORD_WORK *wk );


// FuncTableV[PXJڂŌĂ΂֐
static int Record_MainInit( RECORD_WORK *wk, int seq );
static int Record_MainNormal( RECORD_WORK *wk, int seq );
static int Record_StartRecordCommand( RECORD_WORK *wk, int seq );
static int Record_RecordSendData( RECORD_WORK *wk, int seq );
static int Record_RecordMixData( RECORD_WORK *wk, int seq );
static int Record_StartSelectWait( RECORD_WORK *wk, int seq );
static int Record_StartSelect( RECORD_WORK *wk, int seq );
static int Record_EndSelectPutString( RECORD_WORK *wk, int seq );
static int Record_EndSelectWait( RECORD_WORK *wk, int seq );
static int Record_EndSelectAnswerWait( RECORD_WORK *wk, int seq );
static int Record_EndSelectAnswerOK( RECORD_WORK *wk, int seq );
static int Record_EndSelectAnswerNG( RECORD_WORK *wk, int seq );
static int Record_EndChild( RECORD_WORK *wk, int seq );
static int Record_EndChildWait( RECORD_WORK *wk, int seq );
static int Record_EndSelectParent( RECORD_WORK *wk, int seq );
static int Record_EndSelectParentWait( RECORD_WORK *wk, int seq );
static int Record_ForceEnd( RECORD_WORK *wk, int seq );
static int Record_ForceEndWait( RECORD_WORK *wk, int seq );
static int Record_ForceEndSynchronize( RECORD_WORK *wk, int seq );
static int Record_EndParentOnly( RECORD_WORK *wk, int seq );
static int Record_EndParentOnlyWait( RECORD_WORK *wk, int seq );
static int Record_MessageWaitSeq( RECORD_WORK *wk, int seq );
static int Record_LogoutChildMes( RECORD_WORK *wk, int seq );
static int Record_LogoutChildClose( RECORD_WORK *wk, int seq );
static int Record_LogoutChildMesWait( RECORD_WORK *wk, int seq );
static int Record_NewMember( RECORD_WORK *wk, int seq );
static int Record_NewMemberEnd( RECORD_WORK *wk, int seq );
static int Record_CommSaveStart( RECORD_WORK *wk, int seq );
static int Record_CommSave( RECORD_WORK *wk, int seq ) ;
static int Record_EndMessageWait( RECORD_WORK *wk, int seq );
static int Record_FroceEndMesWait( RECORD_WORK *wk, int seq );



// R[hR[i[CV[PXp֐z`
static int (*FuncTable[])(RECORD_WORK *wk, int seq)={
	Record_MainInit,				// 	RECORD_MODE_INIT  = 0, 
	Record_NewMember, 		        // 	RECORD_MODE_NEWMEMBER,
	Record_NewMemberEnd,            // 	RECORD_MODE_NEWMEMBER_END,
	Record_MainNormal,              // 	RECORD_MODE,
	Record_EndSelectPutString,      // 	RECORD_MODE_END_SELECT,
	Record_EndSelectWait,			// 	RECORD_MODE_END_SELECT_WAIT,
	Record_EndSelectAnswerWait,		//	RECORD_MODE_END_SELECT_ANSWER_WAIT
	Record_EndSelectAnswerOK,		//	RECORD_MODE_END_SELECT_ANSWER_OK
	Record_EndSelectAnswerNG,		//	RECORD_MODE_END_SELECT_ANSWER_NG
	Record_EndChild,				//  RECORD_MODE_END_CHILD,
	Record_EndChildWait,			//  RECORD_MODE_END_CHILD_WAIT,
	Record_EndSelectParent,			// 	RECORD_MODE_END_SELECT_PARENT,
	Record_EndSelectParentWait,		//  RECORD_MODE_END_SELECT_PARENT_WAIT,
	Record_ForceEnd,				//	RECORD_MODE_FORCE_END,
	Record_FroceEndMesWait,			//  RECORD_MODE_FORCE_END_MES_WAIT,
	Record_ForceEndWait,			//  RECORD_MODE_FORCE_END_WAIT,
	Record_ForceEndSynchronize,		//  RECORD_MODE_FORCE_END_SYNCHRONIZE,
	Record_EndParentOnly,			// 	RECORD_MODE_END_PARENT_ONLY,
	Record_EndParentOnlyWait,		// 	RECORD_MODE_END_PARENT_ONLY_WAIT,
	Record_LogoutChildMes,			// 	RECORD_MODE_LOGOUT_CHILD,
	Record_LogoutChildMesWait,		//  RECORD_MODE_LOGOUT_CHILD_WAIT,
	Record_LogoutChildClose,		//  RECORD_MODE_LOGOUT_CHILD_CLOSE,
	Record_StartSelect,				// 	RECORD_MODE_START_SELECT,
	Record_StartSelectWait,         // 	RECORD_MODE_START_SELECT_WAIT
	Record_StartRecordCommand,		//  RECORD_MODE_START_RECORD_COMMAND
	Record_RecordSendData,			//	RECORD_MODE_RECORD_SEND_DATA R[hf[^M`FbN

	// ւɍ鏈
	// Z[uV[PX肵悤

	Record_RecordMixData,			//	RECORD_MODE_RECORD_MIX_DATA	܂V[PX
	
	Record_CommSaveStart,			//  RECORD_MODE_COMM_SAVE_START
	Record_CommSave,				//  RECORD_MODE_COMM_SAVE
	Record_EndMessageWait,			//  RECORD_MODE_END_MES_WAIT
	

	Record_MessageWaitSeq,			//  RECORD_MODE_MESSAGE_WAIT,
};



//============================================================================================
//	vZX֐
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * vZX֐F
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
PROC_RESULT RecordCornerProc_Init( PROC * proc, int * seq )
{
	RECORD_WORK * wk;

	switch(*seq){
	case 0:
		sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
		sys_HBlankIntrStop();	//HBlank荞ݒ~

		GF_Disp_GX_VisibleControlInit();
		GF_Disp_GXS_VisibleControlInit();
		GX_SetVisiblePlane( 0 );
		GXS_SetVisiblePlane( 0 );

		// R[hR[i[pq[v쐬
		sys_CreateHeap( HEAPID_BASE_APP, HEAPID_RECORD, 0x41000 );

		wk = PROC_AllocWork( proc, sizeof(RECORD_WORK), HEAPID_RECORD );
		memset( wk, 0, sizeof(RECORD_WORK) );
		wk->bgl   = GF_BGL_BglIniAlloc( HEAPID_RECORD );
		wk->param = (RECORD_INPUT_PARAM*)PROC_GetParentWork( proc );
		wk->savedata = wk->param->sv;
		
		// }l[W[
		wk->WordSet    = WORDSET_Create( HEAPID_RECORD );
		wk->MsgManager = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_record_dat, HEAPID_RECORD );

		sys_KeyRepeatSpeedSet( 4, 8 );

		// VRAM oNݒ
		VramBankSet();
		
		// BGLWX^ݒ
		BgInit( wk->bgl );					

		WIPE_ResetBrightness( WIPE_DISP_MAIN );
		WIPE_ResetBrightness( WIPE_DISP_SUB );

		// CvtF[hJn
		WIPE_SYS_Start( WIPE_PATTERN_WMS, WIPE_TYPE_HOLEIN, WIPE_TYPE_HOLEIN, WIPE_FADE_BLACK, 16, 1, HEAPID_RECORD );
		

		//BGOtBbNZbg
		BgGraphicSet( wk );

//		InitTPSystem();						// ^b`plVXe
//		InitTPNoBuff(2);
  
		// VBlank֐Zbg
		sys_VBlankFuncChange( VBlankFunc, wk );	
  

		// [N
		InitWork( wk );

		// OBJLApbg}l[W[
		char_pltt_manager_init();

		// CellActorVXe
		InitCellActor(wk);
		
		// CellActro\o^
		SetCellActor(wk);

		// BMPWINo^E`
		BmpWinInit(wk,proc);

		// TEhf[^[h(O)(BGMp)
		Snd_DataSetByScene( SND_SCENE_SUB_NAMEIN, 0, 0 );

		// ʏo͂㉺ւ
//		GX_SetDispSelect(GX_DISP_SELECT_SUB_MAIN);

		// ʐMR}hXgpɕύX
		CommCommandRecordInitialize( wk );

		// R[hR[i[[hɕύX
		CommStateUnionRecordCornerChange();

        // 3܂Őڑ\ɏ
        CommStateSetLimitNum(3);

		// euR[hʐMWvɃr[R
		if(CommGetCurrentID()==0){
			Union_BeaconChange( UNION_PARENT_MODE_RECORD_FREE );
		}


		WirelessIconEasy();

		MakeSendData(wk->savedata, &wk->send_data);

		wk->trans_tcb = VIntrTCB_Add( TransPal, wk, 5 );


		(*seq)++;
		break;
	case 1:
		wk = PROC_GetWork( proc );
		(*seq) = SEQ_IN;
		return PROC_RES_FINISH;
		break;
	}
	return PROC_RES_CONTINUE;
}

static int debug_pal_no = 0;
static int debug_obj_no = 0;


//--------------------------------------------------------------------------------------------
/**
 * vZX֐FC
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------

PROC_RESULT RecordCornerProc_Main( PROC * proc, int * seq )
{
	RECORD_WORK * wk  = PROC_GetWork( proc );

	if(CommGetCurrentID() == 0 && wk->ridatu_bit != 0){
		wk->ridatu_bit &= WH_GetBitmap();
	}
	
	switch( *seq ){
	case SEQ_IN:
		if( WIPE_SYS_EndCheck() ){
			// Cv҂
			*seq = SEQ_MAIN;

			// q@Őڑ䐔Qȏゾꍇ͂G`Ă
			if(CommGetCurrentID()!=0){
				if(MyStatusGetNum()>2){
					// q@NGXg
					CommSendData(CR_RECORD_CHILD_JOIN, NULL, 0);
				}
			}

		}
		break;

	case SEQ_MAIN:
		// J[\ړ

		// V[PX̓
		if(FuncTable[wk->seq]!=NULL){
			*seq = (*FuncTable[wk->seq])( wk, *seq );
		}
		if(wk->record_execute == FALSE){	//R[h͍̎XVȂ
			NameCheckPrint( wk->TrainerNameWin, 0, GF_PRINTCOLOR_MAKE(1, 3, 0), wk );
		}
		TrainerObjFunc(wk);

		// ωlɉăr[Rς
		if(CommGetCurrentID()==0){
			int temp = RecordCorner_BeaconControl( wk, 1 );
			if(*seq==SEQ_MAIN){
				// IV[PXȂǂɗĂȂΕύX
				*seq = temp;
			}
		}

		break;
	case SEQ_LEAVE:
		if(FuncTable[wk->seq]!=NULL){
			*seq = (*FuncTable[wk->seq])( wk, *seq );
		}
		break;
	case SEQ_OUT:
		if( WIPE_SYS_EndCheck() ){
			return PROC_RES_FINISH;
		}
		break;
	}
	CLACT_Draw( wk->clactSet );									// ZAN^[풓֐

	return PROC_RES_CONTINUE;
}

#define DEFAULT_NAME_MAX		18

// _CEp[ŕς񂾂낤
#define MALE_NAME_START			0
#define FEMALE_NAME_START		18

//--------------------------------------------------------------------------------------------
/**
 * vZX֐FI
 *
 * @param	proc	vZXf[^
 * @param	seq		V[PX
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
PROC_RESULT RecordCornerProc_End( PROC * proc, int * seq )
{
	RECORD_WORK  *wk    = PROC_GetWork( proc );
	int i;

	// pbg]^XNI
	TCB_Delete( wk->trans_tcb );

	// ZAN^[\[X

	// L]}l[W[j
//	CLACT_U_CharManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES]);
//	CLACT_U_CharManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES]);
	CLACT_U_CharManagerDelete(wk->resObjTbl[CHARA_RES][CLACT_U_CHAR_RES]);

	// pbg]}l[W[j
//	CLACT_U_PlttManagerDelete(wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES]);
//	CLACT_U_PlttManagerDelete(wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES]);
	CLACT_U_PlttManagerDelete(wk->resObjTbl[CHARA_RES][CLACT_U_PLTT_RES]);
		
	// LEpbgEZEZAj̃\[X}l[W[j
	for(i=0;i<CLACT_RESOURCE_NUM;i++){
		CLACT_U_ResManagerDelete(wk->resMan[i]);
	}
	// ZAN^[Zbgj
	CLACT_DestSet(wk->clactSet);

	//OAM_[j
	REND_OAM_Delete();

	// \[X
	DeleteCharManager();
	DeletePlttManager();

	// BMPEBhEJ
	BmpWinDelete( wk );

	// BGL폜
	BgExit( wk->bgl );

	// ʐMI
//	CommStateExitUnion();
    CommStateSetLimitNum(2);
	CommStateUnionBconCollectionRestart();
	UnionRoomView_ObjInit( wk->param->union_view );

	// ^b`plVXeI
//	StopTP();							


	// bZ[W}l[W[E[hZbg}l[W[
	MSGMAN_Delete( wk->MsgManager );
	WORDSET_Delete( wk->WordSet );

	// [N
	FreeWork( wk );


	PROC_FreeWork( proc );				// PROC[NJ

	// ւĂ㉺ʏo͂ɖ߂
	GX_SetDispSelect(GX_DISP_SELECT_MAIN_SUB);

	// r[R
	Union_BeaconChange( UNION_PARENT_MODE_FREE );

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	sys_DeleteHeap( HEAPID_RECORD );

	return PROC_RES_FINISH;
}

static const u8 palanimetable[][2]={
	{ 8,2,},
	{ 8,3,},
	{ 8,4,},
	{24,0,},
	{ 0,0xff,},
};



//------------------------------------------------------------------
/**
 * @brief   pbg]^XN
 *
 * @param   tcb		
 * @param   work		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TransPal( TCB_PTR tcb, void *work )
{
	RECORD_WORK     *wk  = (RECORD_WORK *)work;
	VTRANS_PAL_WORK *pal = &wk->palwork;
	
	// pbgAj
	if(pal->sw){
		if(pal->wait>palanimetable[pal->seq][0]){
			u16 *src;
			pal->wait=0;
			pal->seq++;
			if(palanimetable[pal->seq][1]==0xff){
				pal->seq = 0;
			}
			src = (u16*)pal->palbuf->pRawData;
			GX_LoadOBJPltt(&src[16*palanimetable[pal->seq][1]], 0, 32);
//			OS_Printf("pbg] seq = %d \n",pal->seq);
		}else{
			wk->palwork.wait++;
		}
		
		CursorColTrans(&wk->CursorPal);
	}


}
//--------------------------------------------------------------------------------------------
/**
 * VBlank֐
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VBlankFunc( void * work )
{
	// ZAN^[
	// Vram]}l[W[s
	DoVramTransferManager();

	// _LOAM}l[WVram]
	REND_OAMTrans();	
	
	GF_BGL_VBlankFunc( (GF_BGL_INI*)work );
	
	OS_SetIrqCheckFlag( OS_IE_V_BLANK );

}


//--------------------------------------------------------------------------------------------
/**
 * VRAMݒ
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM tbl = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg

		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg

		GX_VRAM_OBJ_128_B,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg

		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg

		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &tbl );
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	// BG SYSTEM
	{	
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	// Cʕ0
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x10000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_S );


	}

	// C1
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_S );
	}

	// Cʔwi
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd800, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
//		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_S );
	}


	// TuʃeLXg
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
	}

	// Tuʔwi
	{	
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}

	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_RECORD );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_RECORD );

}


#define TALK_MESSAGE_BUF_NUM	( 90*2 )
#define TITLE_MESSAGE_BUF_NUM	( 20*2 )

//------------------------------------------------------------------
/**
 * G[N
 *
 * @param   wk		RECORD_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitWork( RECORD_WORK *wk )
{
	int i;

	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		wk->TrainerName[i] = STRBUF_Create( PERSON_NAME_SIZE+EOM_SIZE, HEAPID_RECORD );
		wk->TrainerStatus[i][0] = NULL;
		wk->TrainerStatus[i][1] = NULL;
		wk->TrainerReq[i]       = RECORD_EXIST_NO;

	}
	// obt@쐬
	wk->TalkString  = STRBUF_Create( TALK_MESSAGE_BUF_NUM, HEAPID_RECORD );
	wk->TitleString = STRBUF_Create( TITLE_MESSAGE_BUF_NUM, HEAPID_RECORD );

	wk->seq = RECORD_MODE_INIT;
	
	// R[hڂイI擾
	MSGMAN_GetString(  wk->MsgManager, msg_union_record_title_01, wk->TitleString );

	// tB[hOBJ摜ǂݍ
	LoadFieldObjData( wk );

	wk->ObjPaletteTable = UnionView_PalleteTableAlloc( HEAPID_RECORD );


	// pbgAjp[N
	wk->palwork.sw       = 0;
	wk->palwork.wait     = 0;
	wk->palwork.seq      = 0;
	wk->palwork.paldata  = ArcUtil_PalDataGet( ARC_RECORD_GRA, NARC_record_record_s_obj_nclr, &wk->palwork.palbuf, HEAPID_RECORD );
	wk->connectBackup    = 0;
	wk->YesNoMenuWork    = NULL;
	wk->shareNum		 = 2;
}

//------------------------------------------------------------------
/**
 * $brief   [N
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void FreeWork( RECORD_WORK *wk )
{
	int i;

	// tB[hOBJ摜
	FreeFieldObjData( wk );

	// @B̃pbgAjpf[^
	sys_FreeMemoryEz(wk->palwork.paldata);

	// jIOBJ̃pbgf[^
	sys_FreeMemoryEz(wk->ObjPaletteTable);

	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		STRBUF_Delete( wk->TrainerName[i] );
	}
	STRBUF_Delete( wk->TitleString ); 
	STRBUF_Delete( wk->TalkString ); 

}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgExit( GF_BGL_INI * ini )
{

	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );

	sys_FreeMemoryEz( ini );
}


//--------------------------------------------------------------------------------------------
/**
 * OtBbNf[^Zbg
 *
 * @param	wk		|PXgʂ̃[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgGraphicSet( RECORD_WORK * wk )
{
	GF_BGL_INI *bgl = wk->bgl;

	// ㉺ʂafpbg]
	ArcUtil_PalSet( ARC_RECORD_GRA,  NARC_record_record_s_nclr, PALTYPE_MAIN_BG, 0, 16*16*2, HEAPID_RECORD );
	ArcUtil_PalSet( ARC_POKETCH_IMG, NARC_poketch_before_nclr,  PALTYPE_SUB_BG,  0, 16*2,   HEAPID_RECORD );
	
	// btHgpbg]
	TalkFontPaletteLoad( PALTYPE_MAIN_BG, 13*0x20, HEAPID_RECORD );
	TalkFontPaletteLoad( PALTYPE_SUB_BG,  13*0x20, HEAPID_RECORD );




	// CBG2L]
//	ArcUtil_BgCharSet( ARC_RECORD_GRA, NARC_record_mainbg_lz_ncgr, bgl, GF_BGL_FRAME2_S, 0, 32*8*0x20, 1, HEAPID_RECORD);

	// CBG2XN[]
//	ArcUtil_ScrnSet(   ARC_RECORD_GRA, NARC_record_mainbg_lz_nscr, bgl, GF_BGL_FRAME2_S, 0, 32*24*2, 1, HEAPID_RECORD);



	ArcUtil_BgCharSet( ARC_POKETCH_IMG, NARC_poketch_before_lz_ncgr, bgl, GF_BGL_FRAME2_S, 0, 0, 1, HEAPID_RECORD);
	ArcUtil_ScrnSet(   ARC_POKETCH_IMG, NARC_poketch_before_lz_nscr, bgl, GF_BGL_FRAME2_S, 0, 0, 1, HEAPID_RECORD);

	// TuBG1L]
	ArcUtil_BgCharSet( ARC_RECORD_GRA, NARC_record_subbg_lz_ncgr, bgl, GF_BGL_FRAME1_M, 0, 32*8*0x20, 1, HEAPID_RECORD);

	// TuBG1XN[]
	ArcUtil_ScrnSet(   ARC_RECORD_GRA, NARC_record_subbg_lz_nscr, bgl, GF_BGL_FRAME1_M, 0, 32*24*2, 1, HEAPID_RECORD);

	// TuʉbEChEOtBbN]
	TalkWinGraphicSet(
				bgl, GF_BGL_FRAME0_M, 1, FLD_MESFRAME_PAL,  CONFIG_GetWindowType(wk->param->config), HEAPID_RECORD );

	MenuWinGraphicSet(
				bgl, GF_BGL_FRAME0_M, 1+TALK_WIN_CGX_SIZ, FLD_MENUFRAME_PAL, 0, HEAPID_RECORD );

}


//** CharManager PlttManagerp **//
#define RECORD_CHAR_CONT_NUM				(20)
#define RECORD_CHAR_VRAMTRANS_MAIN_SIZE		(2048)
#define RECORD_CHAR_VRAMTRANS_SUB_SIZE		(2048)
#define RECORD_PLTT_CONT_NUM				(20)

//-------------------------------------
//
//	LN^}l[W[
//	pbg}l[W[̏
//
//=====================================
static void char_pltt_manager_init(void)
{
	// LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			RECORD_CHAR_CONT_NUM,
			RECORD_CHAR_VRAMTRANS_MAIN_SIZE,
			RECORD_CHAR_VRAMTRANS_SUB_SIZE,
			HEAPID_RECORD
		};
		InitCharManager(&cm);
	}
	// pbg}l[W[
	InitPlttManager(RECORD_PLTT_CONT_NUM, HEAPID_RECORD);

	// ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();
}


//------------------------------------------------------------------
/**
 * [_[ʗpZAN^[
 *
 * @param   wk		[_[\̂̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitCellActor(RECORD_WORK *wk)
{
	int i;
	
	
	// OAM}l[W[̏
	NNS_G2dInitOamManagerModule();

	// LOAM}l[W쐬
	// _pOAM}l[W쐬
	// ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			0, 126,		// COAMǗ̈
			0, 32,		// CʃAtBǗ̈
			0, 126,		// TuOAMǗ̈
			0, 32,		// TuʃAtBǗ̈
			HEAPID_RECORD);
	
	
	
	// ZAN^[
	wk->clactSet = CLACT_U_SetEasyInit( 30, &wk->renddata, HEAPID_RECORD );
	
	CLACT_U_SetSubSurfaceMatrix( &wk->renddata, 0, NAMEIN_SUB_ACTOR_DISTANCE );

	
	//\[X}l[W[
	for(i=0;i<CLACT_RESOURCE_NUM;i++){		//\[X}l[W[쐬
		wk->resMan[i] = CLACT_U_ResManagerInit(3, i, HEAPID_RECORD);
	}


	//---------ʗp-------------------
#if 0
	//charaǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_RECORD_GRA, NARC_record_obj_lz_ncgr, 1, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_RECORD);

	//palǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_RECORD_GRA, NARC_record_record_m_nclr, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 7, HEAPID_RECORD);

	//cellǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_RECORD_GRA, NARC_record_obj_lz_ncer, 1, 0, CLACT_U_CELL_RES,HEAPID_RECORD);

	//֐animǂݍ
	wk->resObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_RECORD_GRA, NARC_record_obj_lz_nanr, 1, 0, CLACT_U_CELLANM_RES,HEAPID_RECORD);
#endif

	//---------ʐlOBJǂݍ-------------------

	//charaǂݍ
	wk->resObjTbl[CHARA_RES][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
							ARC_RECORD_GRA, NARC_record_obj_s_lz_ncgr, 1, 2, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_RECORD);

	//palǂݍ
	wk->resObjTbl[CHARA_RES][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
							ARC_RECORD_GRA, NARC_record_record_s_obj_nclr, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN, 15, HEAPID_RECORD);

	//cellǂݍ
	wk->resObjTbl[CHARA_RES][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
							ARC_RECORD_GRA, NARC_record_obj_s_lz_ncer, 1, 2, CLACT_U_CELL_RES,HEAPID_RECORD);

	//֐animǂݍ
	wk->resObjTbl[CHARA_RES][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
							ARC_RECORD_GRA, NARC_record_obj_s_lz_nanr, 1, 2, CLACT_U_CELLANM_RES,HEAPID_RECORD);


	//---------ʗp-------------------



	//charaǂݍ
//	wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(wk->resMan[CLACT_U_CHAR_RES], 
//							ARC_RECORD_GRA, NARC_record_obj_lz_ncgr, 1, 1, NNS_G2D_VRAM_TYPE_2DSUB, HEAPID_RECORD);

	//palǂݍ
//	wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(wk->resMan[CLACT_U_PLTT_RES],
//							ARC_RECORD_GRA, NARC_record_record_m_nclr, 0, 1, NNS_G2D_VRAM_TYPE_2DSUB, 3, HEAPID_RECORD);

	//cellǂݍ
//	wk->resObjTbl[SUB_LCD][CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELL_RES],
//							ARC_RECORD_GRA, NARC_record_obj_lz_ncer, 1, 1, CLACT_U_CELL_RES,HEAPID_RECORD);

	//֐animǂݍ
//	wk->resObjTbl[SUB_LCD][CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(wk->resMan[CLACT_U_CELLANM_RES],
//							ARC_RECORD_GRA, NARC_record_obj_lz_nanr, 1, 1, CLACT_U_CELLANM_RES,HEAPID_RECORD);

	// \[X}l[W[]

	// Chara]
//	CLACT_U_CharManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
//	CLACT_U_CharManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_CHAR_RES] );
	CLACT_U_CharManagerSet( wk->resObjTbl[CHARA_RES][CLACT_U_CHAR_RES] );

	// pbg]
//	CLACT_U_PlttManagerSet( wk->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
//	CLACT_U_PlttManagerSet( wk->resObjTbl[SUB_LCD][CLACT_U_PLTT_RES] );
	CLACT_U_PlttManagerSet( wk->resObjTbl[CHARA_RES][CLACT_U_PLTT_RES] );

}

#define TRAINER_NAME_POS_X		( 24 )
#define TRAINER_NAME_POS_Y		( 32 )
#define TRAINER_NAME_POS_SPAN	( 32 )

#define TRAINER_NAME_WIN_X		(  2 )
#define TRAINER1_NAME_WIN_Y		(  6 )
#define TRAINER2_NAME_WIN_Y		(  7 )

static const u16 obj_pos_tbl[][2]={
	{ 204,  84   },
	{ 204,  61-8 },
	{ 233,  80-8 },
	{ 223, 111-8 },
	{ 184, 111-8 },
	{ 174,  80-8 },
};

//------------------------------------------------------------------
/**
 * ZAN^[o^
 *
 * @param   wk			RECORD_WORK*
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetCellActor(RECORD_WORK *wk)
{
	int i;
#if 0
	// ZAN^[wb_쐬
	CLACT_U_MakeHeader(&wk->clActHeader_m, 0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);
	CLACT_U_MakeHeader(&wk->clActHeader_s, 1, 1, 1, 1, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);
#endif

	CLACT_U_MakeHeader(&wk->clActHeader_friend, 2, 2, 2, 2, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 1,
	wk->resMan[CLACT_U_CHAR_RES],
	wk->resMan[CLACT_U_PLTT_RES],
	wk->resMan[CLACT_U_CELL_RES],
	wk->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);


	{
		//o^i[
		CLACT_ADD add;

		add.ClActSet	= wk->clactSet;
		add.ClActHeader	= &wk->clActHeader_friend;

		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 1;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_RECORD;

		//ZAN^[\Jn

		// ^񒆂̋@B͕\
		add.mat.x = FX32_ONE *   obj_pos_tbl[0][0];
		add.mat.y = FX32_ONE *   obj_pos_tbl[0][1];
		wk->MainActWork[0] = CLACT_Add(&add);
		CLACT_SetAnmFlag(wk->MainActWork[0],1);
//		CLACT_AnmChg( wk->MainActWork[0], 0 );
		CLACT_SetDrawFlag( wk->MainActWork[0], 1 );

		// Cʗp(l̓o^j
		for(i=0;i<5;i++){
			add.mat.x = FX32_ONE *   obj_pos_tbl[i+1][0];
			add.mat.y = FX32_ONE *   obj_pos_tbl[i+1][1];
			wk->MainActWork[i+1] = CLACT_Add(&add);
			CLACT_SetAnmFlag(wk->MainActWork[i+1],1);
			CLACT_AnmChg( wk->MainActWork[i+1], 27+(i-1)*2 );
			CLACT_SetDrawFlag( wk->MainActWork[i+1], 0 );
		}


		//ZAN^[\Jn
		// Tuʗp(̓o^j
		for(i=0;i<5;i++){
			add.mat.x = FX32_ONE *   TRAINER_NAME_POS_X;
			add.mat.y = FX32_ONE * ( TRAINER_NAME_POS_Y + TRAINER_NAME_POS_SPAN*i ) + NAMEIN_SUB_ACTOR_DISTANCE;
//			wk->SubActWork[i] = CLACT_Add(&add);
//			CLACT_SetAnmFlag(wk->SubActWork[i],1);
//			CLACT_AnmChg( wk->SubActWork[i], i );
//			CLACT_DrawPriorityChg(wk->SubActWork[i], 1);	// ꂼ̃AN^[̃vCIeBݒ
//			CLACT_SetDrawFlag( wk->SubActWork[i], 0 );
			
		}
		
	}	
	GF_Disp_GX_VisibleControl(  GX_PLANEMASK_OBJ, VISIBLE_ON );	//COBJʂnm
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );	//TuOBJʂnm
	
}

// {[hBMPiʁj
#define OEKAKI_BOARD_POSX	 ( 1 )
#define OEKAKI_BOARD_POSY	 ( 2 )
#define OEKAKI_BOARD_W	 ( 30 )
#define OEKAKI_BOARD_H	 ( 15 )


// O\BMPiʁj
#define RECORD_NAME_BMP_W	 ( 16 )
#define RECORD_NAME_BMP_H	 ( 11 )
#define RECORD_NAME_BMP_SIZE (RECORD_NAME_BMP_W * RECORD_NAME_BMP_H)


// u߂vBMPiʁj
#define OEKAKI_END_BMP_X	( 26 )
#define OEKAKI_END_BMP_Y	( 20 )
#define OEKAKI_END_BMP_W	( 6  )
#define OEKAKI_END_BMP_H	( 2  )


// bEChE\ʒu`
#define RECORD_TALK_X		(  2 )
#define RECORD_TALK_Y		(  19 )

#define RECORD_TITLE_X		(   3  )
#define RECORD_TITLE_Y		(   1  )
#define RECORD_TITLE_W		(  26  )
#define RECORD_TITLE_H		(   2  )


#define RECORD_MSG_WIN_OFFSET 		(1 + TALK_WIN_CGX_SIZ     + MENU_WIN_CGX_SIZ)
#define RECORD_TITLE_WIN_OFFSET		( RECORD_MSG_WIN_OFFSET   + FLD_MSG_WIN_SX*FLD_MSG_WIN_SY )
#define RECORD_NAME_WIN_OFFSET		( RECORD_TITLE_WIN_OFFSET + RECORD_TITLE_W*RECORD_TITLE_H )
#define RECORD_YESNO_WIN_OFFSET		( RECORD_NAME_WIN_OFFSET  + RECORD_NAME_BMP_SIZE )

//------------------------------------------------------------------
/**
 * BMPWINiplɃtHg`j
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BmpWinInit(RECORD_WORK *wk, PROC* proc)
{
	// ---------- C ------------------

	// BG1BMPi߂jEChEmہE`
	GF_BGL_BmpWinAdd(wk->bgl, &wk->EndWin, GF_BGL_FRAME1_S,
	OEKAKI_END_BMP_X, OEKAKI_END_BMP_Y, OEKAKI_END_BMP_W, OEKAKI_END_BMP_H, 13,  1+OEKAKI_BOARD_W*OEKAKI_BOARD_H );

	GF_BGL_BmpWinDataFill( &wk->EndWin, 0x0000 );

	// ----------- TuʖO\BMPm ------------------
	// BG0BMPibEChEjm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->MsgWin, GF_BGL_FRAME0_M,
		RECORD_TALK_X, RECORD_TALK_Y, FLD_MSG_WIN_SX, FLD_MSG_WIN_SY, 13,  RECORD_MSG_WIN_OFFSET );
	GF_BGL_BmpWinDataFill( &wk->MsgWin, 0x0f0f );

	// BG0BMPi^CgEChEjm
	GF_BGL_BmpWinAdd(wk->bgl, &wk->TitleWin, GF_BGL_FRAME0_M,
		RECORD_TITLE_X, RECORD_TITLE_Y, RECORD_TITLE_W, RECORD_TITLE_H, 15,  RECORD_TITLE_WIN_OFFSET );
	CenteringPrint(&wk->TitleWin, wk->TitleString, MSG_ALLPUT);

	// O\EChE
	{
		int i;
			GF_BGL_BmpWinAdd(wk->bgl, &wk->TrainerNameWin[0], GF_BGL_FRAME0_M,	
				TRAINER_NAME_WIN_X, TRAINER1_NAME_WIN_Y, RECORD_NAME_BMP_W, RECORD_NAME_BMP_H, 15,  RECORD_NAME_WIN_OFFSET);

			GF_BGL_BmpWinDataFill( &wk->TrainerNameWin[0], 0 );

		//ŏɌĂʂȂ̂ŕpl`Ɠ]s
		NameCheckPrint( wk->TrainerNameWin, 0, GF_PRINTCOLOR_MAKE(1, 3, 0), wk );


	}

	OS_Printf("YESNO win offset = %d\n",RECORD_YESNO_WIN_OFFSET);

/*
3713 2D4A 5694 089D 5EBF 7DC0 76EF 0000
0000 0000 0000 7FFF 62FF 6F7B 7F52 7FFF

*/



}	

//------------------------------------------------------------------
/**
 * $brief   Z^Oăvg
 *
 * @param   win		GF_BGL_BMPWIN
 * @param   strbuf	
 *
 * @retval  none
 */
//------------------------------------------------------------------
static void CenteringPrint(GF_BGL_BMPWIN *win, STRBUF *strbuf, int wait)
{
	int length = FontProc_GetPrintStrWidth( FONT_TALK, strbuf, 0 );
	int x      = (RECORD_TITLE_W*8-length)/2;
	
	GF_BGL_BmpWinDataFill( win, 0x0000 );

	GF_STR_PrintColor(	win, FONT_TALK, strbuf, x, 1, wait,	GF_PRINTCOLOR_MAKE(1, 4, 0),NULL);

}


// ͂EBMPiʁj
#define YESNO_WIN_FRAME_CHAR	( 1 + TALK_WIN_CGX_SIZ )
#define YESNO_CHARA_OFFSET		( 1 + TALK_WIN_CGX_SIZ + MENU_WIN_CGX_SIZ + FLD_MSG_WIN_SX*FLD_MSG_WIN_SY )
#define YESNO_WINDOW_X			( 22 )
#define YESNO_WINDOW_Y1			(  7 )
#define YESNO_WINDOW_Y2			( 13 )
#define YESNO_CHARA_W			(  8 )
#define YESNO_CHARA_H			(  4 )


//------------------------------------------------------------------
/**
 * $brief   mۂBMPWIN
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BmpWinDelete( RECORD_WORK *wk )
{
	int i;
	
//	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		GF_BGL_BmpWinDel( &wk->TrainerNameWin[0] );
//	}
	GF_BGL_BmpWinDel( &wk->TitleWin );
	GF_BGL_BmpWinDel( &wk->EndWin );
	GF_BGL_BmpWinDel( &wk->MsgWin );


}





//------------------------------------------------------------------
/**
 * ړ̌ʃJ[\̌`󂪂ǂ̂悤ɕς邩肷
 * ̏ł΁A`̃J[\A{^̏łΒ`̃J[\
 * ̍XVs邱ƂŁATuʂ̒̃tHg̍XVs
 *
 * @param   wk			RECORD_WORK*
 * @param   arrow		ړ
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorAppearUpDate(RECORD_WORK *wk, int arrow)
{
	VecFx32 tmpVex;

//	tmpVex.x = FX32_ONE*(MAIN_CURSOR_POSX+wk->Cursor.x*12);
//	tmpVex.y = FX32_ONE*(MAIN_CURSOR_POSY+(wk->Cursor.y-1)*16);
//	CLACT_SetMatrix(wk->clActWork[CLACT_CURSOR_NUM], &tmpVex);


}




//------------------------------------------------------------------
/**
 * $brief   J[\ʒuύX
 *
 * @param   act		AN^[̃|C^
 * @param   x		
 * @param   y		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetCursor_Pos( CLACT_WORK_PTR act, int x, int y )
{
	VecFx32 mat;

	mat.x = FX32_CONST( x );
	mat.y = FX32_CONST( y );
	mat.z = 0;
	CLACT_SetMatrix( act, &mat);

}





//------------------------------------------------------------------
/**
 * $brief   JñbZ[W
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static int Record_MainInit( RECORD_WORK *wk, int seq )
{
	
    CommStateSetErrorCheck(FALSE,TRUE); // q@̏o肪m肷܂ł̓G[Ȃ
	// e̎A{^ŊJnbZ[WBq@͊Jn҂bZ[W
	if(CommGetCurrentID()==0){

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/27

/* R[hR[i[3lȏ̎AODTb炢̃^C~OŎq@Đelɂ
 uȂo[cvƂbZ[WQdɕ\ăEChE  
  \Ă܂oOΏ */
#if AFTER_MASTER_070424_RECORDCONER_FIX
		// ڑl2l葽ꍇ́uA{^łv\
		if(CommGetConnectNum()>=2){
			RecordMessagePrint(wk, msg_union_record_01_01, 0 );
		}
#else
		RecordMessagePrint(wk, msg_union_record_01_01, 0 );

#endif

// ----------------------------------------------------------------------------

	}else{
		RecordMessagePrint(wk, msg_union_record_01_07, 0 );
	}
	SequenceChange_MesWait(wk, RECORD_MODE);

//	wk->seq = RECORD_MODE;

	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   R[hR[i[ʏ폈
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_MainNormal( RECORD_WORK *wk, int seq )
{
	// S̑֎~łȂ΃L[
	PadControl( wk );

	//TrainerObjFunc(wk);

	
	if(CommGetCurrentID()==0){				// e@̎
		if(OnlyParentCheck()!=1){			// lȂH
			RecordDataSendRecv( wk );
		}
	}else{
			RecordDataSendRecv( wk );
	}

	return seq;
}


//------------------------------------------------------------------
/**
 * @brief   L[͊Ǘ
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static void PadControl( RECORD_WORK *wk )
{
	// R[hJn܂Hiê݁j
	if(sys.trg&PAD_BUTTON_A){
		if(CommGetCurrentID()==0){
			if(MyStatusGetNum()==wk->shareNum && wk->ridatu_bit == 0){
				u8 flag = RECORD_BAN_ON;
				RecordMessagePrint( wk, msg_union_record_01_02, 0 );
				SequenceChange_MesWait(wk,RECORD_MODE_START_SELECT);

				// E֎~ʒB
				CommSendData( CR_RECORD_BAN, &flag, 1 );
				
				// ڑlON
				ChangeConnectMax( wk, 0 );
			}
			else{
				Snd_SePlay(SEQ_SE_DP_CUSTOM06);
			}
		}

	}else if(sys.trg&PAD_BUTTON_B){
		// ߂܂H
		if(CommGetCurrentID()){
			// q@͐e@֎~Ăꍇ͏IłȂ
			if(wk->banFlag==0){
				RecordMessagePrint( wk, msg_union_record_01_03, 0 );
				SequenceChange_MesWait(wk,RECORD_MODE_END_SELECT);
			}
			else{
				Snd_SePlay(SEQ_SE_DP_CUSTOM06);
			}
		}else{
//			if( MyStatusGetNum()==wk->shareNum ){
			if( CommGetConnectNum()==wk->shareNum && wk->ridatu_bit == 0){
				u8 flag = RECORD_BAN_ON;
				// e@͏Ij[
				RecordMessagePrint( wk, msg_union_record_01_03, 0 );
				SequenceChange_MesWait(wk,RECORD_MODE_END_SELECT);
				// E֎~ʒB
				CommSendData( CR_RECORD_BAN, &flag, 1 );

				// ڑlON
				ChangeConnectMax( wk, 0 );
			}
			else{
				Snd_SePlay(SEQ_SE_DP_CUSTOM06);
			}
		}
	}
	else{
		if(wk->beacon_flag == RECORD_BAN_NONE){
			if(CommGetCurrentID() == 0 && CommGetConnectNum()==wk->shareNum){
				u8 flag = RECORD_BAN_NONE;
				// E֎~ʒB
				CommSendData( CR_RECORD_BAN, &flag, 1 );
			}
		}
	}

}

//------------------------------------------------------------------
/**
 * $brief   II̋ʏ֐(ŕ`擙j
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void EndSequenceCommonFunc( RECORD_WORK *wk )
{
	
}


//------------------------------------------------------------------
/**
 * $brief   Vq@̂Őe@摜𑗐M͂߂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static int Record_NewMember( RECORD_WORK *wk, int seq )
{
	// 񂪂͂Ă܂
//	RecordMessagePrint(wk, msg_oekaki_01);
//	wk->seq = RECORD_MODE_NEWMEMBER_WAIT;
	SequenceChange_MesWait(wk, RECORD_MODE_NEWMEMBER_END );

	// 摜]ԂɂȂPx_E
//	G2_SetBlendBrightness(  GX_BLEND_PLANEMASK_BG1|
//							GX_BLEND_PLANEMASK_BG2|
//							GX_BLEND_PLANEMASK_BG3|
//							GX_BLEND_PLANEMASK_OBJ
//								,  -6);

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;

}

//------------------------------------------------------------------
/**
 * $brief   bZ[WI҂Ď̃V[PXɍs֐
 *
 * @param   wk		
 * @param   next		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SequenceChange_MesWait( RECORD_WORK *wk, int next )
{
	wk->seq     = RECORD_MODE_MESSAGE_WAIT;
	wk->nextseq = next;
}

//------------------------------------------------------------------
/**
 * $brief   Vq@p̉摜M҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static int Record_MessageWaitSeq( RECORD_WORK *wk, int seq )
{
	if( EndMessageWait( wk->MsgIndex ) ){
		wk->seq = wk->nextseq;
	}
	EndSequenceCommonFunc( wk );		//II̋ʏ

	return seq;
	
}

//------------------------------------------------------------------
/**
 * $brief   q@MI
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_NewMemberEnd( RECORD_WORK *wk, int seq )
{
	// Px_E
//	G2_BlendNone();

	if(CommGetCurrentID()==0){
		int flag = RECORD_BAN_NONE;
		// E֎~ʒB
		CommSendData( CR_RECORD_BAN, &flag, 1 );
	}

	wk->seq = RECORD_MODE;
	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
	
}


// ͂E
#define	BMP_YESNO_PX	( 23 )
#define	BMP_YESNO_PY	( 13 )
#define	BMP_YESNO_SX	( 7 )
#define	BMP_YESNO_SY	( 4 )
#define	BMP_YESNO_PAL	( 13 )
#define	BMP_YESNO_CGX	( RECORD_YESNO_WIN_OFFSET )


// ͂E
static const BMPWIN_DAT YesNoBmpWin = {
	GF_BGL_FRAME0_M, BMP_YESNO_PX, BMP_YESNO_PY,
	BMP_YESNO_SX, BMP_YESNO_SY, BMP_YESNO_PAL, BMP_YESNO_CGX
};

//------------------------------------------------------------------
/**
 * $brief   R[hR[i[u߂vI
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndSelectPutString( RECORD_WORK *wk, int seq )
{
	// ͂E\
	wk->YesNoMenuWork = BmpYesNoSelectInit(	wk->bgl, &YesNoBmpWin, YESNO_WIN_FRAME_CHAR, FLD_MENUFRAME_PAL, HEAPID_RECORD );

	wk->seq = RECORD_MODE_END_SELECT_WAIT;
	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   u߂܂Hv͂EI҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndSelectWait( RECORD_WORK *wk, int seq )
{
	int result;
	u32 ret;
	
	// q@͐e@瑀֎~Ăꍇ͑łȂ
	if(CommGetCurrentID()){
		if(wk->banFlag){
			if(sys.trg & (PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL | PAD_KEY_UP | PAD_KEY_DOWN)){
				Snd_SePlay(SEQ_SE_DP_CUSTOM06);
			}
			EndSequenceCommonFunc( wk );		//II̋ʏ
			return seq;
		}
	}
	else{	//ȅꍇ
		if(wk->ridatu_bit != 0){			//E悤ƂĂqȂ狖Ȃ
			if(sys.trg & (PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL | PAD_KEY_UP | PAD_KEY_DOWN)){
				Snd_SePlay(SEQ_SE_DP_CUSTOM06);
			}
			EndSequenceCommonFunc( wk );		//II̋ʏ
			return seq;
		}
	}

//	if(wk->shareNum != MyStatusGetNum()){	//vĂȂȂu߂vȂ
	if(MyStatusGetNum() != CommGetConnectNum()){
		//vĂȂȂu߂vȂ(qʂ邱͐eXVȂshareNum͌Ȃ)
		EndSequenceCommonFunc( wk );		//II̋ʏ
		return seq;
	}

	// j[
	ret = BmpYesNoSelectMain( wk->YesNoMenuWork, HEAPID_RECORD );

	if(ret!=BMPMENU_NULL){
		if(ret==BMPMENU_CANCEL){
			if(CommGetCurrentID()==0){
				int flag = RECORD_BAN_NONE;
				// E֎~ʒB
				CommSendData( CR_RECORD_BAN, &flag, 1 );

				// ڑlOFF
				ChangeConnectMax( wk, 1 );
			}
			
			SequenceChange_MesWait( wk, RECORD_MODE_INIT );
		}else{
			if(CommGetCurrentID()==0){		
				SequenceChange_MesWait( wk, RECORD_MODE_END_SELECT_PARENT );
				RecordMessagePrint( wk, msg_union_record_01_13, 0 );		// [_[߂Ɓc
			}else{
				COMM_RECORD_END_CHILD_WORK crec;
				
				MI_CpuClear8(&crec, sizeof(COMM_RECORD_END_CHILD_WORK));
				crec.request = CREC_REQ_RIDATU_CHECK;
				crec.ridatu_id = CommGetCurrentID();
				
				wk->status_end = TRUE;
				wk->ridatu_wait = 0;
				//wk->seq = RECORD_MODE_END_CHILD;
				wk->seq = RECORD_MODE_END_SELECT_ANSWER_WAIT;
				CommSendData( CR_RECORD_END_CHILD, &crec, sizeof(COMM_RECORD_END_CHILD_WORK) );
			}
		}
		wk->YesNoMenuWork = NULL;
	}


	EndSequenceCommonFunc( wk );		//II̋ʏ

	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   u߂܂Hvu͂vAŐe痣E҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndSelectAnswerWait( RECORD_WORK *wk, int seq )
{
	wk->ridatu_wait = 0;
	
	EndSequenceCommonFunc( wk );		//II̋ʏ

	return seq;
	
}

//------------------------------------------------------------------
/**
 * $brief   u߂܂Hvu͂vAŐe痣E҂OK!
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndSelectAnswerOK( RECORD_WORK *wk, int seq )
{
	if((wk->oya_share_num != CommGetConnectNum())
			|| (wk->oya_share_num != MyStatusGetNum())){
		OS_TPrintf("share_nuM = %d, Comm = %d, My = %d, Bit = %d\n", wk->oya_share_num, CommGetConnectNum(), MyStatusGetNum(), WH_GetBitmap());
		wk->ridatu_wait = 0;
		wk->seq = RECORD_MODE_END_SELECT_ANSWER_NG;
		EndSequenceCommonFunc( wk );		//II̋ʏ
		return seq;
	}
	
	wk->ridatu_wait++;
	OS_TPrintf("ridatu_wait = %d\n", wk->ridatu_wait);
	if(wk->ridatu_wait > 30){
		COMM_RECORD_END_CHILD_WORK crec;
		
		MI_CpuClear8(&crec, sizeof(COMM_RECORD_END_CHILD_WORK));
		crec.request = CREC_REQ_RIDATU_EXE;
		crec.ridatu_id = CommGetCurrentID();

		CommSendData( CR_RECORD_END_CHILD, &crec, sizeof(COMM_RECORD_END_CHILD_WORK) );

		wk->ridatu_wait = 0;
		wk->seq = RECORD_MODE_END_CHILD;
	}

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
	
}

//------------------------------------------------------------------
/**
 * $brief   u߂܂Hvu͂vAŐe痣E҂NG!
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndSelectAnswerNG( RECORD_WORK *wk, int seq )
{
	wk->status_end = FALSE;
	SequenceChange_MesWait( wk, RECORD_MODE_INIT );
	
	OS_TPrintf("==========ELZI===========\n");

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
	
}


//------------------------------------------------------------------
/**
 * $brief   ̃o[ŃR[hJn܂H
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_StartSelect( RECORD_WORK *wk, int seq )
{
	// ͂E\
	wk->YesNoMenuWork = BmpYesNoSelectInit(	wk->bgl, &YesNoBmpWin, YESNO_WIN_FRAME_CHAR, FLD_MENUFRAME_PAL, HEAPID_RECORD );

	wk->seq = RECORD_MODE_START_SELECT_WAIT;
	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   uJn܂Hv͂EI҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_StartSelectWait( RECORD_WORK *wk, int seq )
{
	int result;
	u32 ret;

	if(MyStatusGetNum() != wk->shareNum 		//vĂȂȂ狖Ȃ
			|| wk->ridatu_bit != 0){			//E悤ƂĂqȂ狖Ȃ
		if(sys.trg & (PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL | PAD_KEY_UP | PAD_KEY_DOWN)){
			Snd_SePlay(SEQ_SE_DP_CUSTOM06);
		}
		EndSequenceCommonFunc( wk );		//II̋ʏ
		return seq;
	}
		
	ret = BmpYesNoSelectMain( wk->YesNoMenuWork, HEAPID_RECORD );

	if(ret!=BMPMENU_NULL){
		if(ret==BMPMENU_CANCEL){
			int flag = RECORD_BAN_NONE;
			// E֎~ʒB
			CommSendData( CR_RECORD_BAN, &flag, 1 );

			// r[RԕύX
			
			ChangeConnectMax( wk, 1 );
			SequenceChange_MesWait( wk, RECORD_MODE_INIT );


		}else{
			// ΂ɂ̂͐e
			if(CommGetCurrentID()==0){		
//				SequenceChange_MesWait( wk, RECORD_MODE_STAET_RECORD_COMMAND );
//				RecordMessagePrint( wk, msg_union_record_01_11, 1 );		// ܂Ă܂
                // ڑ֎~ɏ
				wk->seq = RECORD_MODE_START_RECORD_COMMAND;
				wk->start_num = MyStatusGetNum();
			}else{
				GF_ASSERT(0);
			}
		}
		wk->YesNoMenuWork = NULL;
	}


	EndSequenceCommonFunc( wk );		//II̋ʏ

	return seq;
}


//------------------------------------------------------------------
/**
 * $brief   e@
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_StartRecordCommand( RECORD_WORK *wk, int seq )
{
	if(wk->record_send == 0){
		if(CommSendData( CR_RECORD_START, NULL, 0 ) == TRUE){
			wk->record_send = TRUE;
		}
	}
	
//	SequenceChange_MesWait( wk, RECORD_MODE_RECORD_SEND_DATA );
//	RecordMessagePrint( wk, msg_union_record_01_11, 1 );		// ܂Ă܂

	return seq;

}

//==============================================================================
/**
 * $brief   ^CgbZ[Wςu񂿂イIv
 *
 * @param   wk		
 *
 * @retval  none		
 */
//==============================================================================
void RecordCornerTitleChange( RECORD_WORK *wk )
{
	// R[hڂイI擾
	MSGMAN_GetString(  wk->MsgManager, msg_union_record_title_02, wk->TitleString );

	CenteringPrint(&wk->TitleWin, wk->TitleString, MSG_ALLPUT);
	
	// @BAj
	CLACT_AnmChg( wk->MainActWork[0], 37 );

	// VBLANKpbgAjJn
	wk->palwork.sw = 1;
}

//------------------------------------------------------------------
/**
 * $brief   f[^MEM҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_RecordSendData( RECORD_WORK *wk, int seq )
{
	int i,result;

	result = 0;
//	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
//		result += CommIsSpritDataRecv(i);
//	}

	if( CommGetCurrentID() == 0 && CommGetConnectNum() != wk->start_num){
		//Jn̐lƌ݂̐lςĂȂʐMG[ɂ
//		OS_TPrintf("lςĂ̂ŋIɒʐMG[ɂ܂@Jn%d, ݁%d\n", wk->start_num, CommGetConnectNum());
//		CommStateSetError();
	}
	
	// MIlƐڑlɂȂI
	if( CommGetConnectNum()==wk->recv_count ){

		// f[^鏈
		wk->seq = RECORD_MODE_RECORD_MIX_DATA;

		for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
			OS_TPrintf("Mf[^ id=%d, seed=%d, xor=%08x\n",i,wk->recv_data[i].seed, wk->recv_data[i]._xor);
		}
	}

	return seq;
}
//------------------------------------------------------------------
/**
 * @brief	܂鏈
 *
 * @param	wk
 * @param	seq
 *
 * @return	int
 */
//------------------------------------------------------------------
static int Record_RecordMixData( RECORD_WORK *wk, int seq )
{
	// f[^鏈
	MixReceiveData(wk->savedata, wk->recv_data);

	wk->seq = RECORD_MODE_COMM_SAVE_START;

	return seq;
}




//------------------------------------------------------------------
/**
 * @brief   R[hIZ[u
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_CommSaveStart( RECORD_WORK *wk, int seq )
{
	void *FnoteWork;

	// \tgZbgs\ɂ
	sys.DontSoftReset = 1;

	// `m[g
	FnoteWork = FNOTE_SioRecordDataMake( HEAPID_RECORD );
	FNOTE_DataSave( wk->param->fnote, FnoteWork, FNOTE_TYPE_SIO );

	// XRAZ
	RECORD_Score_Add( wk->param->record, SCORE_ID_COMM_RECORD_CORNER );

	// ʐMZ[u
	CommSyncronizeSaveInit( &wk->saveseq_work );
	wk->seq = RECORD_MODE_COMM_SAVE;
	OS_Printf("Z[uJn\n");
	return seq;
}


//==============================================================================
/**
 * @brief   R[hʐMZ[uI҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  stati int		
 */
//==============================================================================
static int Record_CommSave( RECORD_WORK *wk, int seq ) 
{
	if( CommGetCurrentID() == 0 && CommGetConnectNum() != wk->start_num){
		//Jn̐lƌ݂̐lςĂȂʐMG[ɂ
//		OS_TPrintf("lςĂ̂ŋIɒʐMG[ɂ܂@Jn%d, ݁%d\n", wk->start_num, CommGetConnectNum());
//		CommStateSetError();
	}

	// ʐMZ[uI҂
	if(CommSyncronizeSave(wk->param->sv, SVBLK_ID_MAX, &wk->saveseq_work)){

		// SEI
		Snd_SeStopBySeqNo( SEQ_SE_DP_F209, 8 );


		// uR[hI܂Iv
		RecordMessagePrint( wk, msg_union_record_01_12, 0 );
		SequenceChange_MesWait( wk, RECORD_MODE_END_MES_WAIT );

		// @B̃Ajɖ߂
		CLACT_AnmChg( wk->MainActWork[0], 0 );

		// VBLANKpbgAjI
		wk->palwork.sw = 0;

		wk->wait = 0;
		OS_Printf("Z[uI\n");

		// \tgZbg\ɂ
		sys.DontSoftReset = 0;

		wk->record_execute = FALSE;
	}

	return seq;
}


//------------------------------------------------------------------
/**
 * @brief   I(bZ[W\Pb܂ďIj
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndMessageWait( RECORD_WORK *wk, int seq )
{
	if(wk->wait++ > 60){
		// IpʐM
//		CommTimingSyncStart(RECORD_SYNCHRONIZE_END);
		wk->seq = RECORD_MODE_FORCE_END_WAIT;
	}
	return seq;
}


// RECORD_MODE_END_CHILD
//------------------------------------------------------------------
/**
 * $brief   q@IbZ[WJn
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int 			
 */
//------------------------------------------------------------------
static int 	Record_EndChild( RECORD_WORK *wk, int seq )
{
	u8 temp;
	
	// R[hR[i[ʂ܂
	RecordMessagePrint( wk, msg_union_record_01_04, 0 );	

	// IʒB
	temp = 0;
//	CommSendData( CR_RECORD_END_CHILD, &temp, 1 );

	SequenceChange_MesWait( wk, RECORD_MODE_END_CHILD_WAIT );

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
}
				

// RECORD_MODE_END_CHILD_WAIT
//------------------------------------------------------------------
/**
 * $brief   q@IbZ[W\I҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int 			
 */
//------------------------------------------------------------------
static int 	Record_EndChildWait( RECORD_WORK *wk, int seq )
{			
	if( ++wk->wait > RECORD_CORNER_MESSAGE_END_WAIT ){
		// CvtF[hJn
		WIPE_SYS_Start( WIPE_PATTERN_WMS, WIPE_TYPE_HOLEOUT, WIPE_TYPE_HOLEOUT, WIPE_FADE_BLACK, 16, 1, HEAPID_RECORD );
		seq = SEQ_OUT;						//IV[PX
	}

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
	
}


//------------------------------------------------------------------
/**
 * $brief   e@IƂ͂xu[_[߂ƁcvƎ₷
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndSelectParent( RECORD_WORK *wk, int seq )
{

	// ͂E\
	wk->YesNoMenuWork = BmpYesNoSelectInit(	wk->bgl, &YesNoBmpWin, YESNO_WIN_FRAME_CHAR, FLD_MENUFRAME_PAL, HEAPID_RECORD );

	wk->seq = RECORD_MODE_END_SELECT_PARENT_WAIT;

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
	
}

//------------------------------------------------------------------
/**
 * $brief   e@̂Qڂ́u͂Ev
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndSelectParentWait( RECORD_WORK *wk, int seq )
{
	int ret;

	if(wk->shareNum != MyStatusGetNum()			//vĂȂȂu߂vȂ
			|| wk->ridatu_bit != 0){			//E悤ƂĂqȂ狖Ȃ
		if(sys.trg & (PAD_BUTTON_DECIDE | PAD_BUTTON_CANCEL | PAD_KEY_UP | PAD_KEY_DOWN)){
			Snd_SePlay(SEQ_SE_DP_CUSTOM06);
		}
		EndSequenceCommonFunc( wk );		//II̋ʏ
		return seq;
	}

	ret = BmpYesNoSelectMain( wk->YesNoMenuWork, HEAPID_RECORD );

	if(ret!=BMPMENU_NULL){
		if(ret==BMPMENU_CANCEL){
			int flag = RECORD_BAN_NONE;
			
			wk->seq = RECORD_MODE_INIT;

			// E֎~ʒB
			CommSendData( CR_RECORD_BAN, &flag, 1 );

			// ڑlOFF
			ChangeConnectMax( wk, 1 );

		}else{
			wk->seq = RECORD_MODE_FORCE_END;
			CommSendData( CR_RECORD_END, NULL, 0 );						//Iʒm
			WORDSET_RegisterPlayerName( wk->WordSet, 0, CommInfoGetMyStatus(0) );	// e@ij̖OWORDSET
		}
		wk->YesNoMenuWork = NULL;
	}

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
	
}

//------------------------------------------------------------------
/**
 * $brief   e@Iƌ̂ŏI
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_ForceEnd( RECORD_WORK *wk, int seq )
{
	if(CommGetCurrentID()==0){
		// ł́@R[hʐMイ@܂
		RecordMessagePrint( wk, msg_union_record_01_04, 0 );
	}else{
		// 邭Ȃo[̂ł񂵂܂
		WORDSET_RegisterPlayerName( wk->WordSet, 0, CommInfoGetMyStatus(0) );	// e@ij̖OWORDSET
		RecordMessagePrint( wk, msg_union_record_01_15, 0 );
	}
	SequenceChange_MesWait(wk,RECORD_MODE_FORCE_END_MES_WAIT);
	wk->wait = 0;

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;

}


//------------------------------------------------------------------
/**
 * @brief   IbZ[WPb҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_FroceEndMesWait( RECORD_WORK *wk, int seq )
{
	wk->wait++;
	if(wk->wait > RECORD_1SEC_WAIT){
		wk->seq = RECORD_MODE_FORCE_END_WAIT;
	}
	
	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   e@Iƌ̂ŏI
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_ForceEndWait( RECORD_WORK *wk, int seq )
{
	// ʐM҂
	CommTimingSyncStart(RECORD_SYNCHRONIZE_END);
	wk->seq = RECORD_MODE_FORCE_END_SYNCHRONIZE;

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;

}

//------------------------------------------------------------------
/**
 * $brief   S̒ʐM҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_ForceEndSynchronize( RECORD_WORK *wk, int seq )
{
	if(CommIsTimingSync(RECORD_SYNCHRONIZE_END)){
	    CommStateSetErrorCheck(FALSE, FALSE); // Iɓ̂Őؒf͂

		OS_Printf("I\n");
		// CvtF[hJn
		WIPE_SYS_Start( WIPE_PATTERN_WMS, WIPE_TYPE_HOLEOUT, WIPE_TYPE_HOLEOUT, WIPE_FADE_BLACK, 16, 1, HEAPID_RECORD);

		seq = SEQ_OUT;						//IV[PX
	}
	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;
	
}


//------------------------------------------------------------------
/**
 * $brief   elɂȂ̂ŏI
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndParentOnly( RECORD_WORK *wk, int seq )
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/27

/* R[hR[i[3lȏ̎AODTb炢̃^C~OŎq@Đelɂ
 uȂo[cvƂbZ[WQdɕ\ăEChE  
  \Ă܂oOΏ */
#if AFTER_MASTER_070424_RECORDCONER_FIX
	// bZ[W\͌ĂяoȂ悤ɂ
	if( EndMessageWait( wk->MsgIndex ) ){
		RecordMessagePrint( wk, msg_union_record_01_08, 0 );	// [_[̂ŉU܂B
	}
#else
		RecordMessagePrint( wk, msg_union_record_01_08, 0 );	// [_[̂ŉU܂B
#endif

// ----------------------------------------------------------------------------

	wk->seq = RECORD_MODE_END_PARENT_ONLY_WAIT;

	EndSequenceCommonFunc( wk );		//II̋ʏ

	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   lɂȂ͂\ďIV[PX
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_EndParentOnlyWait( RECORD_WORK *wk, int seq )
{
	if( EndMessageWait( wk->MsgIndex ) ){
		wk->seq = RECORD_MODE_END_CHILD_WAIT;
	}

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;

}


//------------------------------------------------------------------
/**
 * $brief   񂪂܂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_LogoutChildMes( RECORD_WORK *wk, int seq )
{
	// 񂪂܂
	if( wk->MsgIndex != 0xff && EndMessageWait( wk->MsgIndex ) == 0){
		//\̃bZ[Wꍇ͋~
		GF_STR_PrintForceStop(wk->MsgIndex);
	}
	RecordMessagePrint(wk, msg_union_record_01_14, 1 );
	wk->seq = RECORD_MODE_LOGOUT_CHILD_WAIT;

	// ڑ\lU݂̐ڑlɗƂ
	if(CommGetCurrentID()==0){
		ChangeConnectMax( wk, 0 );
	}


	OS_TPrintf("l`FbNlogout child %d\n", CommGetConnectNum());
	wk->err_num = CommGetConnectNum();
	
	EndSequenceCommonFunc( wk );		//II̋ʏ

	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   q@͏I҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_LogoutChildMesWait( RECORD_WORK *wk, int seq )
{
	// ڑlP邩`FbN
	if(wk->err_num != 0 && CommGetConnectNum() != wk->err_num){
		wk->err_num = 0;
	}

	wk->seq  = RECORD_MODE_LOGOUT_CHILD_CLOSE;
	wk->wait = 0;

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;

}

//------------------------------------------------------------------
/**
 * $brief   \IEFCg
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int 			
 */
//------------------------------------------------------------------
static int 	Record_LogoutChildClose( RECORD_WORK *wk, int seq )
{			

	// ڑlP܂ł͑҂
	if(wk->err_num != 0 && CommGetConnectNum() != wk->err_num){
		wk->err_num = 0;
	}
	
	if( ++wk->wait > RECORD_CORNER_MESSAGE_END_WAIT && wk->err_num == 0){
		wk->seq = RECORD_MODE_INIT;//RECORD_MODE;				//IV[PX

		// E҂ȂȂ̂ŁA{PԂňl͓悤ɂ
		if(CommGetCurrentID()==0){
			ChangeConnectMax( wk, 1 );
		}
	}

	EndSequenceCommonFunc( wk );			//II̋ʏ
	return seq;
	
}

#if 0
//------------------------------------------------------------------
/**
 * $brief   񂪂܂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_LogoutChildMes( RECORD_WORK *wk, int seq )
{
	// 񂪂܂
	wk->seq = RECORD_MODE_LOGOUT_CHILD_WAIT;

	EndSequenceCommonFunc( wk );		//II̋ʏ

	return seq;
}

//------------------------------------------------------------------
/**
 * $brief   q@͏I҂
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int Record_LogoutChildMesWait( RECORD_WORK *wk, int seq )
{
		wk->seq  = RECORD_MODE_LOGOUT_CHILD_CLOSE;
		wk->wait = 0;

	EndSequenceCommonFunc( wk );		//II̋ʏ
	return seq;

}

//------------------------------------------------------------------
/**
 * $brief   \IEFCg
 *
 * @param   wk		
 * @param   seq		
 *
 * @retval  int 			
 */
//------------------------------------------------------------------
static int 	Record_LogoutChildClose( RECORD_WORK *wk, int seq )
{			

	if( ++wk->wait > RECORD_CORNER_MESSAGE_END_WAIT ){
		wk->seq = RECORD_MODE;				//IV[PX
	}

	EndSequenceCommonFunc( wk );			//II̋ʏ
	return seq;
	
}

#endif


//==============================================================================
/**
 * $brief   ǂȏԂłĂIɃCV[PX`FW
 *
 * @param   wk		
 * @param   seq		
 * @param   id		
 *
 * @retval  none		
 */
//==============================================================================
void RecordCorner_MainSeqForceChange( RECORD_WORK *wk, int seq, u8 id  )
{
	switch(seq){
	case RECORD_MODE_NEWMEMBER_END:
		EndMessageWindowOff( wk );
		break;
	case RECORD_MODE_FORCE_END:
		if(wk->YesNoMenuWork!=NULL){
			BmpYesNoWinDel( wk->YesNoMenuWork, HEAPID_RECORD );
			wk->YesNoMenuWork = NULL;
		}
		break;
	case RECORD_MODE_RECORD_SEND_DATA:
		if(EndMessageWait(wk->MsgIndex) == 0){
			//\̃bZ[Wꍇ͋~
			GF_STR_PrintForceStop(wk->MsgIndex);
		}
		RecordMessagePrint( wk, msg_union_record_01_11, 0 );		// u܂Ă܂v\
		if(wk->YesNoMenuWork!=NULL){
			BmpYesNoWinDel( wk->YesNoMenuWork, HEAPID_RECORD );
			wk->YesNoMenuWork = NULL;
		}
		break;
	case RECORD_MODE_LOGOUT_CHILD:
		if(wk->status_end == TRUE){
			return;	//gE
		}
		WORDSET_RegisterPlayerName( wk->WordSet, 0, CommInfoGetMyStatus(id) );	
		if(id==CommGetCurrentID()){
			// Eq@ꍇ́uq@ȂȂvƂ͌Ȃ
			return;
		}
		if(wk->YesNoMenuWork!=NULL){
			BmpYesNoWinDel( wk->YesNoMenuWork, HEAPID_RECORD );
			wk->YesNoMenuWork = NULL;
		}
		if(CommGetCurrentID() == 0){
			wk->ridatu_bit &= 0xffff ^ id;
		}
		break;
	case RECORD_MODE_END_SELECT_ANSWER_OK:
		break;
	case RECORD_MODE_END_SELECT_ANSWER_NG:
		break;
	default:
		GF_ASSERT( "wȊÕV[PX`FW" );
		return;
	}
	wk->seq = seq;

}

//==============================================================================
/**
 * $brief   Ă烁C[vV[PX`FW(ʏԂł邱Ɓj
 *
 * @param   wk		
 * @param   seq		̃CV[PXɃ`FW
 *
 * @retval  none		
 */
//==============================================================================
void RecordCorner_MainSeqCheckChange( RECORD_WORK *wk, int seq, u8 id  )
{
	// ʏԂȂ
	if(wk->seq == RECORD_MODE){
		OS_Printf("q@%d̖Oo^\n",id);
		switch(seq){
		case RECORD_MODE_NEWMEMBER:	
			// w̎q@̖OWORDSETɓo^iEE)
			WORDSET_RegisterPlayerName( wk->WordSet, 0, CommInfoGetMyStatus(id) );	
			ChangeConnectMax( wk, 1 );
			wk->seq      = seq;
			wk->shareNum = CommGetConnectNum();
			wk->ridatu_bit = 0;
			if(CommGetCurrentID()==0){
				int flag = RECORD_BAN_ON;//NONE;
				// E֎~ʒB
				CommSendData( CR_RECORD_BAN, &flag, 1 );
				
			}
			break;
			//  
		case RECORD_MODE_LOGOUT_CHILD:
			WORDSET_RegisterPlayerName( wk->WordSet, 0, CommInfoGetMyStatus(id) );	
			if(id==CommGetCurrentID()){
				// Eq@ꍇ́uq@ȂȂvƂ͌Ȃ
				return;
			}
			if(CommGetCurrentID() == 0){
				wk->ridatu_bit &= 0xffff ^ id;
			}
			wk->seq = seq;
			break;
		default:
			GF_ASSERT( 0&&"wȊÕV[PX`FW" );
			return;
		}


	}
	else if(seq == RECORD_MODE_NEWMEMBER){
		wk->ridatu_bit = 0;
		wk->shareNum = CommGetConnectNum();
	}

}



//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------













//------------------------------------------------------------------
/**
 * @B̃pbgύXi_Łj
 *
 * @param   CursorCol	sinɓnp[^i360܂Łj
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CursorColTrans(u16 *CursorCol)
{
	fx32  sin;
	GXRgb tmp;
	int   r,g,b;

	*CursorCol+=10;
	if(*CursorCol>360){
		*CursorCol = 0;
	}

	sin = Sin360R(*CursorCol);
	g   = 15 +( sin * 10 ) / FX32_ONE;
	tmp = GX_RGB(29,g,0);


	GX_LoadOBJPltt((u16*)&tmp, ( 5    )*2, 2);
	GX_LoadOBJPltt((u16*)&tmp, ( 5+16 )*2, 2);
}

//------------------------------------------------------------------
/**
 * $brief   ݉lڑĂ邩H
 *
 * @param   none		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int OnlyParentCheck( void )
{
	int i,result;
	MYSTATUS *status;

	result = 0;
	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		status = CommInfoGetMyStatus(i);
		if(status!=NULL){
			result++;
		}
	}

	return result;
}

#define NAME_PRINT_HABA	( 18 )
#define ID_STRING_NUM	(2+1+5+1)
//------------------------------------------------------------------
/**
 * $brief   IC󋵂mFďʂɖOID\
 *
 * @param   win		
 * @param   frame		
 * @param   color		
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static BOOL NameCheckPrint( GF_BGL_BMPWIN *win, int frame, GF_PRINTCOLOR color, RECORD_WORK *wk )
{
	int i,id = CommGetCurrentID();
	STRBUF *id_str = NULL;


	// O擾̏󋵂ɕωꍇ͏Ȃ
	if(!MyStatusCheck(wk)){
		return FALSE;
	}


	// ꂼ̕pl̔wiFŃNA
	GF_BGL_BmpWinDataFill(&win[0],0x0000);

	// `
	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		if(wk->TrainerStatus[i][0]!=NULL){
			// g[i[ID̎擾
			u16 tid = MyStatus_GetID_Low( wk->TrainerStatus[i][0] );

			// ̖O擾
			MyStatus_CopyNameString( wk->TrainerStatus[i][0], wk->TrainerName[i] );

			// g[i[ID𖄂ߍ񂾕uID 12345v擾
			WORDSET_RegisterNumber( wk->WordSet, 0, tid, 5, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_HANKAKU );
			id_str = MSGDAT_UTIL_AllocExpandString( wk->WordSet, wk->MsgManager, msg_union_record_name_02, HEAPID_RECORD );
			
			if(id==i){	// ̖O̎͐ԐFŖOID`
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/09/19
// ؍łł͐ԂIW
#if PM_LANG == LANG_KOREA
				GF_STR_PrintColor(	&win[0], FONT_SYSTEM, wk->TrainerName[i], 5, 1+i*NAME_PRINT_HABA, MSG_NO_PUT, 
										GF_PRINTCOLOR_MAKE(5,3,0),NULL);
				GF_STR_PrintColor(	&win[0], FONT_SYSTEM, id_str, 5+13*5, 1+i*NAME_PRINT_HABA, MSG_NO_PUT, GF_PRINTCOLOR_MAKE(5,3,0),NULL);
#else
				GF_STR_PrintColor(	&win[0], FONT_SYSTEM, wk->TrainerName[i], 5, 1+i*NAME_PRINT_HABA, MSG_NO_PUT, 
										GF_PRINTCOLOR_MAKE(2,3,0),NULL);
				GF_STR_PrintColor(	&win[0], FONT_SYSTEM, id_str, 5+13*5, 1+i*NAME_PRINT_HABA, MSG_NO_PUT, GF_PRINTCOLOR_MAKE(2,3,0),NULL);
#endif
// ----------------------------------------------------------------------------
			}else{
				GF_STR_PrintColor(	&win[0], FONT_SYSTEM, wk->TrainerName[i], 5, 1+i*NAME_PRINT_HABA, MSG_NO_PUT, color,NULL);
				GF_STR_PrintColor(	&win[0], FONT_SYSTEM, id_str, 5+13*5, 1+i*NAME_PRINT_HABA, MSG_NO_PUT, color,NULL);
			}
			// ID
			STRBUF_Delete(id_str);
		}
	}
	GF_BGL_BmpWinOn( &win[0] );

	return TRUE;
}




#define PLATE_CHARA_OFFSET1	( 12 )
#define PLATE_CHARA_OFFSET2	( 16 )

static const u8 plate_num[4]={2,2,3,2};
static const u8 plate_table[4][3]={
	{8*8,17*8,0,},
	{8*8,17*8,0,},
	{5*8,12*8,18*8,},
	{8*8,17*8,0,},

};
static const u8 plate_chara_no[][5]={
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
	{PLATE_CHARA_OFFSET1,PLATE_CHARA_OFFSET1,},
};

//------------------------------------------------------------------
/**
 * $brief   ڑmFꂽꍇ͖O擾
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static int ConnectCheck( RECORD_WORK *wk )
{
	int i,result=0;
	MYSTATUS *status;
	STRCODE  *namecode;

	// ڑ`FbN
	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		wk->ConnectCheck[i][0] = wk->ConnectCheck[i][1];

		wk->ConnectCheck[i][0] = CommIsConnect(i);

	}

	// ڑ疼O𔽉f
	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		if(wk->ConnectCheck[i][0]){				// ڑĂ邩H
			// ڑĂ

			status = CommInfoGetMyStatus(i);
			if(status!=NULL){					// MYSTATUS͎擾łĂ邩H
				namecode = (STRCODE*)MyStatus_GetMyName(status);
				STRBUF_SetStringCode( wk->TrainerName[i], namecode );
			}

		}
	}
	return 0;
}


//------------------------------------------------------------------
/**
 * $brief   ^b`pl̑Ms
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void RecordDataSendRecv( RECORD_WORK *wk )
{
	
}


//------------------------------------------------------------------
/**
 * $brief   ݂̃IC擾
 *
 * @param   none		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int MyStatusGetNum( void )
{
	int i,result;
	for(result=0,i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		if(CommInfoGetMyStatus(i)!=NULL){
			result++;
		}
	}
	return result;
}

//--------------------------------------------------------------
/**
 * @brief   ݂̃IC擾(O[o֐)
 *
 * @param   none		
 *
 * @retval  ڑl
 */
//--------------------------------------------------------------
int RecordCorner_MyStatusGetNum(void)
{
	return MyStatusGetNum();
}


//	RECORD_EXIST_NO=0,
//	RECORD_EXIST_APPEAR_REQ,
//	RECORD_EXIST_APPEAR,
//	RECORD_EXIST_BYE_REQ,


//------------------------------------------------------------------
/**
 * $brief   MYSTATUS̎擾󋵂ɕωH
 *
 * @param   wk		
 *
 * @retval  int		1,  ꍇ0
 */
//------------------------------------------------------------------
static BOOL MyStatusCheck( RECORD_WORK *wk )
{
	int i,result=FALSE;
	// ڑ疼O𔽉f
	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		wk->TrainerStatus[i][1] = wk->TrainerStatus[i][0];
		wk->TrainerStatus[i][0] = CommInfoGetMyStatus(i);
	}

	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		if(wk->TrainerStatus[i][1] != wk->TrainerStatus[i][0]){

			// ω
			result = TRUE;

			// oEȂ烊NGXg̔s
			if(wk->TrainerStatus[i][0]==NULL){
				wk->TrainerReq[i] = RECORD_EXIST_BYE_REQ;
			}else{
				wk->TrainerReq[i] = RECORD_EXIST_APPEAR_REQ;
			}
		}
		
	}

	return result;
}


//------------------------------------------------------------------
/**
 * $brief   bEChE\
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void RecordMessagePrint( RECORD_WORK *wk, int msgno, int all_put )
{
	// 擾
	STRBUF *tempbuf;
	
	tempbuf = STRBUF_Create(TALK_MESSAGE_BUF_NUM,HEAPID_RECORD);
	MSGMAN_GetString(  wk->MsgManager, msgno, tempbuf );
	WORDSET_ExpandStr( wk->WordSet, wk->TalkString, tempbuf );
	STRBUF_Delete(tempbuf);

	// bEChEg`
	GF_BGL_BmpWinDataFill( &wk->MsgWin,  0x0f0f );
	BmpTalkWinWrite( &wk->MsgWin, WINDOW_TRANS_ON, 1, FLD_MESFRAME_PAL );

	// `Jn
	if(all_put == 0){
		wk->MsgIndex = GF_STR_PrintSimple( &wk->MsgWin, FONT_TALK, wk->TalkString, 0, 0, GetTalkSpeed(wk), NULL);
	}
	else{
		//ꊇ\̏ꍇMsgIndex0xffɂȂ̂ŒӁI
		GF_STR_PrintSimple( &wk->MsgWin, FONT_TALK, wk->TalkString, 0, 0, MSG_ALLPUT, NULL);
		wk->MsgIndex = 0xff;
	}

}

//------------------------------------------------------------------
/**
 * $brief   b\EChEI҂
 *
 * @param   msg_index		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int EndMessageWait( int msg_index )
{
	if(msg_index == 0xff){
		return 1;
	}
	
	if(GF_MSG_PrintEndCheck( msg_index )==0){
		
		return 1;
	}
	return 0;
}


//------------------------------------------------------------------
/**
 * $brief   
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void EndMessageWindowOff( RECORD_WORK *wk )
{
	BmpTalkWinClear( &wk->MsgWin, WINDOW_TRANS_ON );
}


//------------------------------------------------------------------
/**
 * @brief   g[i[OBJ̕\
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TrainerObjFunc( RECORD_WORK *wk )
{
	int i,seflag=0;
	
	for(i=0;i<RECORD_CORNER_MEMBER_MAX;i++){
		switch(wk->TrainerReq[i]){
		case RECORD_EXIST_NO:
			break;
		case RECORD_EXIST_APPEAR_REQ:
			{
				int view,sex;
				GF_ASSERT(wk->TrainerStatus[i][0]!=NULL);
				
				sex = MyStatus_GetMySex( wk->TrainerStatus[i][0] );
				view  = MyStatus_GetTrainerView( wk->TrainerStatus[i][0] );
				if(CommGetCurrentID()==i){
					// lOBJp̃Aj
					CLACT_AnmChg( wk->MainActWork[i+1], 38+sex*2 );
				}else{
					// tB[hOBJp̃Aj
					TransFieldObjData( wk->FieldObjCharaData, wk->FieldObjPalData,  i, view, sex );
					CLACT_AnmChg( wk->MainActWork[i+1], 27+i*2 );
				}

			}
			CLACT_SetDrawFlag(wk->MainActWork[i+1], 1);
			wk->TrainerReq[i] = RECORD_EXIST_APPEAR;
			seflag = 1;
			break;
		case RECORD_EXIST_APPEAR:
			break;
		case RECORD_EXIST_BYE_REQ:
//			CLACT_SetDrawFlag(wk->MainActWork[i+1], 0);
			if(CommGetCurrentID()==i){
				int sex = MyStatus_GetMySex( wk->TrainerStatus[i][0] );
				CLACT_AnmChg( wk->MainActWork[i+1], 38+sex*2+1 );
			}else{
				CLACT_AnmChg( wk->MainActWork[i+1], 27+i*2+1 );
			}
			wk->TrainerReq[i] = RECORD_EXIST_NO;
			break;
		}
	}
	
	// oSEKvȏꍇ͖炷
	if(seflag){
		Snd_SePlay( SE_GTC_APPEAR );
	}
}


//------------------------------------------------------------------
/**
 * @brief   tB[hOBJ摜ǂݍ݁ijIƎ@j
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void LoadFieldObjData( RECORD_WORK *wk )
{
	// pbgǂݍ
	wk->FieldObjPalBuf[0] = ArcUtil_PalDataGet( ARC_WORLDTRADE_GRA, NARC_worldtrade_hero_nclr, &(wk->FieldObjPalData[0]), HEAPID_RECORD );
	wk->FieldObjPalBuf[1] = ArcUtil_PalDataGet( ARC_RECORD_GRA, NARC_record_union_chara_nclr, &(wk->FieldObjPalData[1]), HEAPID_RECORD );

	// 摜ǂݍ
	wk->FieldObjCharaBuf[0] = ArcUtil_CharDataGet( ARC_WORLDTRADE_GRA, NARC_worldtrade_hero_lz_ncgr, 1, &(wk->FieldObjCharaData[0]), HEAPID_RECORD );
	wk->FieldObjCharaBuf[1] = ArcUtil_CharDataGet( ARC_RECORD_GRA, NARC_record_union_chara_lz_ncgr,  1, &(wk->FieldObjCharaData[1]), HEAPID_RECORD );

}

#define OBJ_TRANS_SIZE	( 3 * 4*4 )
static const u16 obj_offset[]={
	( 13                    )*0x20,
	( 13 + OBJ_TRANS_SIZE*1 )*0x20,
	( 13 + OBJ_TRANS_SIZE*2 )*0x20,
	( 13 + OBJ_TRANS_SIZE*3 )*0x20,
	( 13 + OBJ_TRANS_SIZE*4 )*0x20,
};


static int _obj_no = 0;
static int _pal_no = 0;

//------------------------------------------------------------------
/**
 * @brief   nꂽjIڃR[htB[hOBJ̃L]
 *
 * @param   id		
 * @param   view		
 * @param   sex		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TransFieldObjData( NNSG2dCharacterData *CharaData[2], NNSG2dPaletteData *PalData[2], int id, int view, int sex )
{
	int pos;
	u8 *chara, *pal;
	
	// jIL]

	pos   = UnionView_GetCharaNo( sex, view );

	chara = (u8*)CharaData[1]->pRawData;
	pal   = (u8*)PalData[1]->pRawData;

	GX_LoadOBJ( &chara[OBJ_TRANS_SIZE*pos*0x20], obj_offset[id], OBJ_TRANS_SIZE*0x20 );
	GX_LoadOBJPltt( &pal[pos*32], (id+FIELDOBJ_PAL_START)*32, 32 );

	OS_Printf("ID=%d ̃jIڂ %d ACRԍ %d\n", id, view, pos);

	
	
}

//------------------------------------------------------------------
/**
 * @brief   tB[hOBJ摜
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void FreeFieldObjData( RECORD_WORK *wk )
{

	sys_FreeMemoryEz( wk->FieldObjPalBuf[0]  );
	sys_FreeMemoryEz( wk->FieldObjPalBuf[1]  );
                      
	sys_FreeMemoryEz( wk->FieldObjCharaBuf[0] );
	sys_FreeMemoryEz( wk->FieldObjCharaBuf[1] );
}

//------------------------------------------------------------------
/**
 * @brief   bXs[h擾
 *
 * @param   wk		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int GetTalkSpeed( RECORD_WORK *wk )
{
	return 1;
//	return CONFIG_GetMsgPrintSpeed(wk->param->config);
}

//------------------------------------------------------------------
/**
 * @brief   ڑl̎ڑl{PɂȂ悤ɍĐݒ肷
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void ChangeConnectMax( RECORD_WORK *wk, int plus )
{
	if(CommGetCurrentID()==0){
		if(plus == -1){
			CommStateSetLimitNum(1);
			OS_Printf("ڑlI1lɕύX\n");
		}
		else{
			int num = CommGetConnectNum()+plus;
			if(num>5){
				num = 5;
			}
			CommStateSetLimitNum(num);
			OS_Printf("ڑl %dlɕύX\n",num);
		}
		
		if(plus == -1){
			wk->limit_mode = LIMIT_MODE_ONLY;
		}
		else if(plus == 0){
			wk->limit_mode = LIMIT_MODE_TRUE;
		}
		else{
			wk->limit_mode = LIMIT_MODE_NONE;
		}
	}

}


//------------------------------------------------------------------
/**
 * @brief   Wlƃr[Rݒ肷
 *
 * @param   wk		
 * @param   plus	1ȂWA0Ȃߐ؂肽Ƃ
 *
 * @retval  none
 */
//------------------------------------------------------------------
static int RecordCorner_BeaconControl( RECORD_WORK *wk, int plus )
{
	int num;
	// r[R
	num = MyStatusGetNum();

	if(num>wk->shareNum){
		u8 flag = RECORD_BAN_ON;
		// E֎~ʒB
		CommSendData( CR_RECORD_BAN, &flag, 1 );
		wk->beacon_flag = RECORD_BAN_ON;
	}
	else{
		wk->beacon_flag = RECORD_BAN_NONE;
	}

	// ڑlƃR[h\lv܂ł͑֎~
	if(num==wk->connectBackup){
		return SEQ_MAIN;
	}

	OS_TPrintf("lς\n");

	// ȂAߐ؂łȂȂWs
	switch(num){
	case 1:
		// ЂƂɂȂ̂ŏI
		OS_TPrintf("ONLY!! Comm = %d, My = %d, Bit = %d\n", CommGetConnectNum(), MyStatusGetNum(), WH_GetBitmap());
		if(CommGetConnectNum() > 1 || WH_GetBitmap() > 1){
			return SEQ_MAIN;	//SɈlɂ͂ȂĂȂ̂ł܂Ȃ
		}
		wk->seq = RECORD_MODE_END_PARENT_ONLY;
		ChangeConnectMax( wk, -1 );
		if(wk->YesNoMenuWork!=NULL){
			BmpYesNoWinDel( wk->YesNoMenuWork, HEAPID_RECORD );
			wk->YesNoMenuWork = NULL;
		}
		return SEQ_LEAVE;
		break;
	case 2:	case 3:case 4:
		// ܂
		Union_BeaconChange( UNION_PARENT_MODE_RECORD_FREE );

		// ڑlꍇ͐ڑől炷
		if(num<wk->connectBackup){
			switch(wk->limit_mode){
			case LIMIT_MODE_NONE:
				ChangeConnectMax( wk, plus );
				break;
			case LIMIT_MODE_TRUE:
				ChangeConnectMax(wk, 0);
				break;
			}
			wk->shareNum = CommGetConnectNum();
		}
		break;
	case 5:
		// ςł
		Union_BeaconChange( UNION_PARENT_MODE_RECORDNOW );
		ChangeConnectMax( wk, plus );
		break;
	}

	
	// ڑlۑ
	wk->connectBackup = MyStatusGetNum();

	return SEQ_MAIN;
}