//=============================================================================
/**
 * @file	record_corner_local.h
 * @brief	G{[hp\̒`iQƗp)
 *          
 * @author	Akito Mori
 * @date    	2006.02.14
 */
//=============================================================================


#ifndef __RECORD_CORNER_LOCAL_H__
#define __RECORD_CORNER_LOCAL_H__
// @\{^p`
#define FUNCBUTTON_NUM	( 7 ) 		// @\{^̐
#define START_WORDPANEL ( 0 )		// ŏ̓̕pl̔ԍiOЂ炪ȁj

// ڑlMAX͂Tl
#define RECORD_CORNER_MEMBER_MAX	( 5 )


// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define NAMEIN_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define NAMEIN_OAM_NUM			( 14 )


// bZ[W\WAIT
#define RECORD_CORNER_MESSAGE_END_WAIT	( 60 )


// pl̑Jڗp
enum{
	RECORD_MODE_INIT  = 0, 

	RECORD_MODE_NEWMEMBER,
	RECORD_MODE_NEWMEMBER_END,

	RECORD_MODE,

	RECORD_MODE_END_SELECT,
	RECORD_MODE_END_SELECT_WAIT,
	RECORD_MODE_END_SELECT_ANSWER_WAIT,
	RECORD_MODE_END_SELECT_ANSWER_OK,
	RECORD_MODE_END_SELECT_ANSWER_NG,
	
    RECORD_MODE_END_CHILD,
    RECORD_MODE_END_CHILD_WAIT,

	RECORD_MODE_END_SELECT_PARENT,
    RECORD_MODE_END_SELECT_PARENT_WAIT,

	RECORD_MODE_FORCE_END,
	RECORD_MODE_FORCE_END_MES_WAIT,
    RECORD_MODE_FORCE_END_WAIT,
    RECORD_MODE_FORCE_END_SYNCHRONIZE,

	RECORD_MODE_END_PARENT_ONLY,
	RECORD_MODE_END_PARENT_ONLY_WAIT,

	RECORD_MODE_LOGOUT_CHILD,
    RECORD_MODE_LOGOUT_CHILD_WAIT,
    RECORD_MODE_LOGOUT_CHILD_CLOSE,

	RECORD_MODE_START_SELECT,
	RECORD_MODE_START_SELECT_WAIT,

	RECORD_MODE_START_RECORD_COMMAND,
	RECORD_MODE_RECORD_SEND_DATA,

	RECORD_MODE_RECORD_MIX_DATA,

	RECORD_MODE_COMM_SAVE_START,
    RECORD_MODE_COMM_SAVE,
    RECORD_MODE_END_MES_WAIT,


    RECORD_MODE_MESSAGE_WAIT,
};


enum{
	RECORD_SYNCHRONIZE_END=201,
};

// ㉺ʎw`
#define RES_NUM	( 3 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB
#define CHARA_RES	( 2 )

// BMPWINw
enum{
	BMP_NAME1_S_BG0,
	BMP_NAME2_S_BG0,
	BMP_NAME3_S_BG0,
	BMP_NAME4_S_BG0,
	BMP_NAME5_S_BG0,
	BMP_RECORD_MAX,
};


enum{
	RECORD_EXIST_NO=0,
	RECORD_EXIST_APPEAR_REQ,
	RECORD_EXIST_APPEAR,
	RECORD_EXIST_BYE_REQ,
};

#define RECORD_SEND_DATASIZE	( 3000 )

typedef struct{
	u8  data[RECORD_SEND_DATASIZE];		// R[hf[^
	u32 _xor;							// f[^mFpXOR
	u32 seed;							// e痈̐lɗ𔭐ăf[^ւ
}RECORD_DATA;


typedef struct{
	int sw;
	int seq;
	int wait;
	void *paldata;
	NNSG2dPaletteData *palbuf;
}VTRANS_PAL_WORK;

//============================================================================================
//	\̒`
//============================================================================================

struct RECORD_WORK{
	GF_BGL_INI			*bgl;								// GF_BGL_INI
	BOOL				wipe_end;							// Cv҂
	RECORD_INPUT_PARAM	*param;								// PROCNɖႤp[^
	VTRANS_PAL_WORK		palwork;							// pbgAjp[N
	TCB_PTR				trans_tcb;

	WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
	STRBUF			*TrainerName[RECORD_CORNER_MEMBER_MAX];		// O
	STRBUF			*EndString;								// u߂v
	STRBUF			*TalkString;							// bbZ[Wp
	STRBUF			*TitleString;							// ^CgbZ[Wp
	int				MsgIndex;								// Iop[N

	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[RES_NUM][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_friend;							// ZAN^[wb_[
	CLACT_WORK_PTR			MainActWork[NAMEIN_OAM_NUM];				// ZAN^[[N|C^z
	CLACT_WORK_PTR			SubActWork[NAMEIN_OAM_NUM];				// ZAN^[[N|C^z

	GF_BGL_BMPWIN 			TrainerNameWin[BMP_RECORD_MAX];			// GʗpBMPEChE
	GF_BGL_BMPWIN			MsgWin;									// bEChE
	GF_BGL_BMPWIN			EndWin;									// ߂
	GF_BGL_BMPWIN			TitleWin;								// uR[hR[i[@ڂイイIvȂ
	GF_BGL_BMPWIN			*YesNoWin[2];							// ͂EEChẼ|C^
	BMPMENU_WORK			*YesNoMenuWork;

	void*					FieldObjCharaBuf[2];					// lOBJLt@Cf[^
	NNSG2dCharacterData*	FieldObjCharaData[2];					// lOBJLf[^̎|C^				
	void*					FieldObjPalBuf[2];						// lOBJpbg@Cf[^
	NNSG2dPaletteData*		FieldObjPalData[2];						// lOBJpbgt@Cf[^


	int						seq;									// ݂̕͏ԁiOK/AjjȂ
	int						nextseq;
	int						mode;									// ݍőOʂ̕pl
	int						wait;
	u8						ConnectCheck[8][2];
	MYSTATUS				*TrainerStatus[RECORD_CORNER_MEMBER_MAX][2];
	int						TrainerReq[RECORD_CORNER_MEMBER_MAX];

	int						saveseq_work;							// Z[uV[PXǗp[N

	u16						CursorPal;
	u16						*ObjPaletteTable;
	u8						brush_color;
	u8						brush;

	int						send_num;
	RECORD_DATA				send_data;
	RECORD_DATA				recv_data[RECORD_CORNER_MEMBER_MAX];
	int						recv_count;
	SAVEDATA *				savedata;
	int						banFlag;								// ֎~tO
	u8						record_execute;							// TRUE:R[h
	// ----eKvȃ[N


	volatile int			connectBackup;							// ڑlĎp
	int						shareNum;
	int						beacon_flag;
	u32						ridatu_bit;								// E悤ƂĂqBit
	u8						status_end;								// TRUE:IV[PXֈڍs
	s8						limit_mode;								// ڑ
	u8						start_num;								// R[hJnl
	u8						record_send;							// TRUE:R[hM
	
	// q@Kvȃ[N
	s32 					err_num;								// ʐMI݂邽߂̃[N
	u16						oya_share_num;			// eĂshareNum炤
	s16						ridatu_wait;			// Ep̃EFCg

#ifdef PM_DEBUG
	int 					frame;									//
	int						framenum[9][2];							//
#endif
};


//--------------------------------------------------------------
//	
//--------------------------------------------------------------
//--------------------------------------------------------------
/**
 * @brief   ̍\̂̒gւAKʐM֐e[u
 *          CommRecordCornerEndChildgpĂӏ̑MTCYύX邱ƁII
 *			t@CFcomm_command_record.c, comm_command_oekaki.c, comm_command_field.c
 */
//--------------------------------------------------------------
typedef struct{
	u8 ridatu_id;			///<E҂ID
	u8 oya_share_num;		///<e̎shareNum
	u8 request;				///<߃R[h
	u8 ridatu_kyoka;		///<TRUE:EOKAFALSE:ENG
}COMM_RECORD_END_CHILD_WORK;

enum{
	CREC_REQ_RIDATU_CHECK,		///<EmF
	CREC_REQ_RIDATU_EXE,		///<Es
};



extern void CommCommandRecordInitialize(void* pWork);
extern void RecordCorner_MainSeqCheckChange( RECORD_WORK *wk, int seq, u8 id );
extern void RecordCorner_MainSeqForceChange( RECORD_WORK *wk, int seq, u8 id  );
extern void RecordCornerTitleChange( RECORD_WORK *wk );
extern int RecordCorner_MyStatusGetNum(void);

extern void MakeSendData(SAVEDATA * sv, RECORD_DATA * send_rec);
extern void MixReceiveData(SAVEDATA * sv, const RECORD_DATA * record);

#endif
