//=============================================================================
/**
 * @file	wbtower_local.h
 * @brief	WIFIog^[wb_t@C
 *          
 * @author	Akito Mori
 * @date    	2006.05.16
 */
//=============================================================================


#ifndef __WBTOWER_LOCAL_H__
#define __WBTOWER_LOCAL_H__

#include "communication/wm_icon.h"
#include "system/bmp_list.h"


// Proc_MainV[PX`
enum {
	SEQ_INIT_DPW=0,
	SEQ_INIT,
	SEQ_FADEIN,
	SEQ_MAIN,
	SEQ_FADEOUT,
	SEQ_OUT,
};

// TuvZXԍ
enum{
	WBTOWER_ENTER=0,		// ڑ
};

// TuvZXɓn[hiTuvZXłgႤ邽߁j
enum{
	MODE_DOWNLOAD=0,
	MODE_UPLOAD,
};

// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define WBTOWER_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define NAMEIN_OAM_NUM			( 14 )

#define WBTOWER_MESFRAME_PAL	 ( 10 )
#define WBTOWER_MENUFRAME_PAL    ( 11 )
#define WBTOWER_MESFRAME_CHR	 (  1 )
#define WBTOWER_MENUFRAME_CHR 	 ( WBTOWER_MESFRAME_CHR + TALK_WIN_CGX_SIZ )
#define WBTOWER_TALKFONT_PAL	 ( 13 )

// bEChE\ʒu`
#define TALK_WIN_X		(  2 )
#define TALK_WIN_Y		( 19 )
#define	TALK_WIN_SX		( 27 )
#define	TALK_WIN_SY		(  4 )


// ʏ㕔^CgEChE\ʒu`
#define TITLE_TEXT_X	(  4 )
#define TITLE_TEXT_Y	(  1 )
#define TITLE_TEXT_SX	( 24 )
#define TITLE_TEXT_SY	(  2 )


// ͂EEChEYW
#define	WBTOWER_YESNO_PY2	( 13 )		// bEChEQs̎

// ^Cgobt@
#define TITLE_MESSAGE_BUF_NUM	( 20 * 2 )

// bEChEobt@
#define TALK_MESSAGE_BUF_NUM	( 90*2 )

// NE[ԍ̕
#define NUMBER_BUF_NUM			( 4 )
#define RANK_BUF_NUM			( 3 )

// Nl̏
#define WIFITOWER_RANK_MAX		( 10 )

// Pb҂p̒`
#define WAIT_ONE_SECONDE_NUM	( 30 )

// ㉺ʎw`
#define RES_NUM		( 3 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB
#define CHARA_RES	( 2 )

#define DWC_ERROR_BUF_NUM		(16*8*2)

//============================================================================================
//	\̒`
//============================================================================================



struct WBTOWER_WORK{
	// NɖĂ
	WBTOWER_PARAM *param;								// Ăяop[^
	GF_BGL_INI		*bgl;								// GF_BGL_INI
	
	
	// WIFIog^[VXeɊւ
	int				seq;								// ݂̐Eʂ̏
	int				nextseq;							// ݂̃V[PXIۂ̑Jڐ

	int				sub_process;						// ETuvOio[
	int				sub_nextprocess;					// ETuNEXTio[
	int				sub_process_mode;					// ̉ʂɂ[h͉H

	int				subprocess_seq;						// TuvOV[PXNO
	int				subprocess_nextseq;					// TuvONEXTV[PXNO


	void 			*heapPtr;							// NitroDWCɓnq[v[N̉p|C^
	NNSFndHeapHandle heapHandle;						// heapPtr32oCgACgɍ킹|C^
	DWCInetControl  stConnCtrl;							// DWCڑ[N


	// eʂʂĂۑĂ
	int				Rank;
	int				NowRank;
	int				RoomNum;
	int				NowRoom;
	Dpw_Bt_Room 	roomBtData;							// _E[hf[^i[
	Dpw_Bt_Player	BtPlayer;							// ̃f[^

	u16				TitleCursorPos;						// ^Cgj[̃J[\ʒu
	u16				PartnerPageInfo;					// EEy[Ŵǂ݂Ă邩H
	u16				BoxTrayNo;							// ԃ{bNXĂ邩H
	u16				BoxCursorPos;						// {bNXł̃J[\̈ʒu
	POKEMON_PASO_PARAM	*deposit_ppp;					// UawɂȂ|P̃|C^
	int				SearchResult;						// ̌ʕԂĂ
	int				TouchTrainerPos;					// ʂ̒N^b`


	// `܂̃[NiBMPp̕j
	WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
	MSGDATA_MANAGER *LobbyMsgManager;						// O̓bZ[Wf[^}l[W[
	MSGDATA_MANAGER *SystemMsgManager;						// WifiVXebZ[Wf[^
	STRBUF			*TalkString;							// bbZ[Wp
	STRBUF			*TitleString;							// ^CgbZ[Wp
	STRBUF			*RoomString;							// ԍIp
	STRBUF			*RankString;							// NIp
	STRBUF			*ErrorString;							// NIp
	int				MsgIndex;								// Iop[N


	// `̃[NiOAM)
	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[RES_NUM][CLACT_RESOURCE_NUM]; // \[XIuWFe[u
	CLACT_HEADER			clActHeader_main;						// ZAN^[wb_[
	CLACT_HEADER			clActHeader_sub;						// ZAN^[wb_[
	CLACT_HEADER			clActHeader_friend;						// ZAN^[wb_[
	CLACT_WORK_PTR			ArrowActWork[2];						// ZAN^[[N|C^z

	// BMPWIN`
	GF_BGL_BMPWIN			MsgWin;									// bEChE
	GF_BGL_BMPWIN			RankWin;								// NwpEChE
	GF_BGL_BMPWIN			NumberWin;								// io[wpEChE
	GF_BGL_BMPWIN			TitleWin;								// uR[hR[i[@ڂイイIvȂ
	GF_BGL_BMPWIN			SubWin;									// uR[hR[i[@ڂイイIvȂ
	GF_BGL_BMPWIN			MenuWin[3];								// j[pBMPWIN
	GF_BGL_BMPWIN			InfoWin[11];	


	BMPMENU_WORK			*YesNoMenuWork;
	void*					timeWaitWork;							// bEChEACR[N

	int						ErrorRet;
	int						ErrorCode;
	int						ConnectErrorNo;

	int						wait;

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/10/12
	// T[oւ̃vtB[o^ɑΉ
	Dpw_Common_Profile			Profile;
	Dpw_Common_ProfileResult	ProfileResult;
	// ----------------------------------------------------------------------------
};


//============================================================================================
// SEp`
//============================================================================================
#define WBTOWER_MOVE_SE		(SEQ_SE_DP_SELECT)
#define WBTOWER_DECIDE_SE	(SEQ_SE_DP_SELECT)


//============================================================================================
// extern錾
//============================================================================================
// worldtrade.c
extern void WBTower_MakeCLACT(CLACT_ADD *add, WBTOWER_WORK *wk, CLACT_HEADER *header, int param);
extern BMPMENU_WORK *WBTower_BmpWinYesNoMake( GF_BGL_INI *bgl, int y, int yesno_bmp_cgx );
extern void WBTower_SetNextSeq( WBTOWER_WORK *wk, int to_seq, int next_seq );
extern void WBTower_SetNextProcess( WBTOWER_WORK *wk, int next_process );
extern void WBTower_ActPos( CLACT_WORK_PTR act, int x, int y );
extern  int WBTower_WifiLinkLevel( void );
extern void WBTower_BmpWinPrint( GF_BGL_BMPWIN *win, MSGDATA_MANAGER *msgman, int msgno, u16 dat );
extern void WBTower_SysPrint( GF_BGL_BMPWIN *win, STRBUF *strbuf, int x, int y, int flag, GF_PRINTCOLOR color );
extern void WBTower_TalkPrint( GF_BGL_BMPWIN *win, STRBUF *strbuf, int x, int y, int flag, GF_PRINTCOLOR color );

extern void WBTower_WifiIconAdd( WBTOWER_WORK *wk );
extern void WBTower_SubProcessChange( WBTOWER_WORK *wk, int subprccess, int mode );


// worldtrade_enter.c
extern int WBTower_EnterEnd( WBTOWER_WORK *wk, int seq);
extern int WBTower_EnterMain(WBTOWER_WORK *wk, int seq);
extern int WBTower_EnterInit(WBTOWER_WORK *wk, int seq);


// workdtrade_uploadf.c
extern int WBTower_Upload_Init(WBTOWER_WORK *wk, int seq);
extern int WBTower_Upload_Main(WBTOWER_WORK *wk, int seq);
extern int WBTower_Upload_End(WBTOWER_WORK *wk, int seq);


#endif /* __WBTOWER_LOCAL_H__ */