//=============================================================================
/**
 * @file	wifi_note_local.h
 * @brief	WIFI蒠[J`
 * @author	k.ohno
 * @date    2006.4.5
 */
//=============================================================================


#ifndef __WIFI_NOTE_LOCAL_H__
#define __WIFI_NOTE_LOCAL_H__

#include "savedata/wifilist.h"
#include "communication/communication.h"

#define WIFINOTE_MEMBER_MAX  (WIFILIST_FRIEND_MAX)
#define WIFINOTE_DISP_MEMBER_MAX  (8)

// @\{^p`
#define FUNCBUTTON_NUM	( 7 ) 		// @\{^̐
#define START_WORDPANEL ( 0 )		// ŏ̓̕pl̔ԍiOЂ炪ȁj

// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define NAMEIN_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define _OAM_NUM			( 10 )  // Ŵ̃g[i[{E
#define _LEFT_ARROW       (8)
#define _RIGHT_ARROW       (9)
#define _UNION_CREATURE  (1)
#define _LIST_ARROW  (0)


#define FRIENDCODE_MAXLEN     (12)

// bZ[W\WAIT
#define WIFINOTE_CORNER_MESSAGE_END_WAIT	( 60 )


// pl̑Jڗp
enum{
  WIFINOTE_MODE_INIT  = 0, 
  WIFINOTE_MODE,
  WIFINOTE_MODE_FRIENDLIST_INIT,
  WIFINOTE_MODE_FRIENDLIST,
  WIFINOTE_MODE_PERSONAL_MENU,
  WIFINOTE_MODE_PERSONAL_MENU_WAIT,
  WIFINOTE_MODE_MAIN_MENU,
  WIFINOTE_MODE_CODEINPUT_INIT,
  WIFINOTE_MODE_CODEINPUT_INIT_WAIT,
  WIFINOTE_MODE_CODEINPUT_LOOP,
  WIFINOTE_MODE_CODEINPUT_LOOPNEXT,
  WIFINOTE_MODE_CODEINPUT_LOOP2,
  WIFINOTE_MODE_CODEINPUT_END_WAIT,
  WIFINOTE_MODE_CODEINPUT_YESNO,
  WIFINOTE_MODE_CODEINPUT_YESNO_WAIT,
  WIFINOTE_MODE_FRIENDCODE_DIFFER,
  WIFINOTE_MODE_FRIENDCODE_DIFFER_WAIT,
  WIFINOTE_MODE_END_WAIT,
  WIFINOTE_MODE_MYCODE_DISP_INIT,
  WIFINOTE_MODE_MYCODE_DISP,
  WIFINOTE_MODE_INFO_INIT,
  WIFINOTE_MODE_INFO_DISP,
  WIFINOTE_MODE_INFO_END,
  WIFINOTE_MODE_RENAME_INIT,   // Ȃ܂
  WIFINOTE_MODE_RENAME_OPEN_WINDOW,
  WIFINOTE_MODE_RENAME_WAIT,
  WIFINOTE_MODE_RENAME_ENTRY,
  WIFINOTE_MODE_DELETE_INIT,   // 
  WIFINOTE_MODE_DELETE_YESNO,
  WIFINOTE_MODE_DELETE_CHECK,
  WIFINOTE_MODE_CODE_INIT,
};


enum{
	WIFINOTE_SYNCHRONIZE_END=201,
};

// ㉺ʎw`
#define BOTH_LCD	( 2 )

// BMPWINw
enum{
	BMP_NAME1_S_BG0,
	BMP_NAME2_S_BG0,
	BMP_NAME3_S_BG0,
	BMP_NAME4_S_BG0,
	BMP_NAME5_S_BG0,
	BMP_WIFINOTE_MAX,
};


#define WIFINOTE_SEND_DATASIZE	( 3000 )

typedef struct{
	u8  data[WIFINOTE_SEND_DATASIZE];		// R[hf[^
	u32 _xor;							// f[^mFpXOR
	u32 seed;							// e痈̐lɗ𔭐ăf[^ւ
}WIFINOTE_DATA;

//============================================================================================
//	\̒`
//============================================================================================

struct _WIFINOTE_WORK{
	NAMEIN_PARAM*		nameinParam;
	GF_BGL_INI		*bgl;									// GF_BGL_INI
    SAVEDATA*  pSaveData;
	WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
	BMPLIST_DATA*   menulist;
    u8              index2No[WIFINOTE_MEMBER_MAX];     // wifilistoׂ̔ԍ
    STRBUF			*TrainerName[WIFINOTE_MEMBER_MAX];		// O
    STRBUF*         pExpStrBuf;
	STRBUF			*TalkString;							// bbZ[Wp
	STRBUF			*TitleString;							// ^CgbZ[Wp
	STRBUF			*MenuString[4];							// j[bZ[Wp
    STRBUF*         pTempTrainerName;        // ͓o^̈ꎞobt@
    STRBUF*       pTempFriendCode;        // ͓o^̈ꎞobt@

  SOFT_SPRITE_MANAGER* spriteManager;
  SOFT_SPRITE*			sprite;
  
	int				MsgIndex;								// Iop[N
    BMPMENU_WORK* pYesNoWork;

	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[BOTH_LCD][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
	CLACT_WORK_PTR			MainActWork[_OAM_NUM];				// ZAN^[[N|C^z
//	CLACT_WORK_PTR			SubActWork[_OAM_NUM];				// ZAN^[[N|C^z

	GF_BGL_BMPWIN 			TrainerNameWin[WIFINOTE_DISP_MEMBER_MAX];			// GʗpBMPEChE
	GF_BGL_BMPWIN			MsgWin;									// bEChE
    GF_BGL_BMPWIN           MenuWin[4];
	GF_BGL_BMPWIN			ListWin;									// ߂
	GF_BGL_BMPWIN			TitleWin;								// uR[hR[i[@ڂイイIvȂ
    BMPLIST_WORK* lw;		// BMPj[[N
	u16						*ObjPaletteTable;
	int						seq;									// ݂̕͏ԁiOK/AjjȂ
	int						nextseq;
	int						mode;									// ݍőOʂ̕pl
	int						wait;
    MYSTATUS                *pMyStatus;
	u16						CursorPal;
	u8						brush_color;
	u8						brush;
    u8     mainCur;
    u8     horizontalCur;
    u8     verticalCur;
    u8     subCur;
  u8 friendTrg;
  
  PROC*		subProc;

  int checkFriend[COMM_MACHINE_MAX];
  int indexFriend[COMM_MACHINE_MAX];
  int addFriendNo;

  u16 pos_bak;

};


// SEp`
#define WIFINOTE_MOVE_SE		(SEQ_SE_DP_SELECT)
#define WIFINOTE_DECIDE_SE	(SEQ_SE_DP_SELECT)
#define WIFINOTE_BS_SE		(SEQ_SE_DP_SELECT)


#endif  //__WIFI_NOTE_LOCAL_H__

