//=============================================================================
/**
 * @file	wifi_note_local.h
 * @brief	WIFI蒠[J`
 * @author	k.ohno
 * @date    2006.4.5
 */
//=============================================================================


#ifndef __WIFI_P2PMATCH_LOCAL_H__
#define __WIFI_P2PMATCH_LOCAL_H__

#include "savedata/wifilist.h"

#define WIFIP2PMATCH_MEMBER_MAX  (WIFILIST_FRIEND_MAX)
#define WIFIP2PMATCH_DISP_MEMBER_MAX  (5)

// @\{^p`
#define FUNCBUTTON_NUM	( 7 ) 		// @\{^̐
#define START_WORDPANEL ( 0 )		// ŏ̓̕pl̔ԍiOЂ炪ȁj

// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define NAMEIN_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define _OAM_NUM			( 5 )

#define FRIENDCODE_MAXLEN     (12)

// bZ[W\WAIT
#define WIFIP2PMATCH_CORNER_MESSAGE_END_WAIT	( 60 )


// pl̑Jڗp
enum{
  WIFIP2PMATCH_MODE_INIT  = 0,
  WIFIP2PMATCH_NORMALCONNECT_YESNO,
  WIFIP2PMATCH_NORMALCONNECT_WAIT,
  WIFIP2PMATCH_DIFFER_MACHINE_INIT,
  WIFIP2PMATCH_DIFFER_MACHINE_NEXT,
  WIFIP2PMATCH_DIFFER_MACHINE_ONEMORE,
  WIFIP2PMATCH_FIRST_YESNO,
  WIFIP2PMATCH_POWEROFF_INIT,
  WIFIP2PMATCH_POWEROFF_YESNO,
  WIFIP2PMATCH_POWEROFF_WAIT,
  WIFIP2PMATCH_RETRY_INIT,        //10
  WIFIP2PMATCH_RETRY_YESNO,
  WIFIP2PMATCH_RETRY_WAIT,
  WIFIP2PMATCH_RETRY,
  WIFIP2PMATCH_CONNECTING_INIT,
  WIFIP2PMATCH_CONNECTING,
  WIFIP2PMATCH_FIRST_ENDMSG,
  WIFIP2PMATCH_FIRST_ENDMSG_WAIT,
  WIFIP2PMATCH_FRIENDLIST_INIT,
  WIFIP2PMATCH_MODE_FRIENDLIST,
  WIFIP2PMATCH_VCHATWIN_WAIT,           //20
  WIFIP2PMATCH_MODE_VCT_CONNECT_INIT2,
  WIFIP2PMATCH_MODE_VCT_CONNECT_INIT,
  WIFIP2PMATCH_MODE_VCT_CONNECT_WAIT,
  WIFIP2PMATCH_MODE_VCT_CONNECT,
  WIFIP2PMATCH_MODE_VCT_CONNECTEND_YESNO,
  WIFIP2PMATCH_MODE_VCT_CONNECTEND_WAIT,
  WIFIP2PMATCH_MODE_VCT_DISCONNECT,
  WIFIP2PMATCH_MODE_BATTLE_DISCONNECT,
  WIFIP2PMATCH_MODE_DISCONNECT,
  WIFIP2PMATCH_MODE_BATTLE_CONNECT_INIT,  //30
  WIFIP2PMATCH_MODE_BATTLE_CONNECT_WAIT,
  WIFIP2PMATCH_MODE_BATTLE_CONNECT,
  WIFIP2PMATCH_MODE_MAIN_MENU,
  WIFIP2PMATCH_MODE_END_WAIT,
  WIFIP2PMATCH_MODE_CHECK_AND_END,
  WIFIP2PMATCH_MODE_SELECT_INIT,
  WIFIP2PMATCH_MODE_SELECT_WAIT,
  WIFIP2PMATCH_MODE_SUBBATTLE_WAIT,
  WIFIP2PMATCH_MODE_SELECT_REL_INIT,
  WIFIP2PMATCH_MODE_SELECT_REL_YESNO,       //40
  WIFIP2PMATCH_MODE_SELECT_REL_WAIT,
  WIFIP2PMATCH_MODE_MATCH_INIT,
  WIFIP2PMATCH_MODE_MATCH_WAIT,
  WIFIP2PMATCH_MODE_MATCH_LOOP,
  WIFIP2PMATCH_MODE_BCANCEL_YESNO,
  WIFIP2PMATCH_MODE_BCANCEL_WAIT,
  WIFIP2PMATCH_MODE_CALL_INIT,
  WIFIP2PMATCH_MODE_CALL_YESNO,
  WIFIP2PMATCH_MODE_CALL_SEND,
  WIFIP2PMATCH_MODE_CALL_CHECK,             //50
  WIFIP2PMATCH_MODE_MYSTATUS_WAIT,
  WIFIP2PMATCH_MODE_CALL_WAIT,
  WIFIP2PMATCH_MODE_PERSONAL_INIT,
  WIFIP2PMATCH_MODE_PERSONAL_WAIT,
  WIFIP2PMATCH_MODE_PERSONAL_END,
  WIFIP2PMATCH_MODE_EXIT_YESNO,
  WIFIP2PMATCH_MODE_EXIT_WAIT,
  WIFIP2PMATCH_MODE_EXITING,
  WIFIP2PMATCH_MODE_EXIT_END,
  WIFIP2PMATCH_NEXTBATTLE_YESNO,         //60
  WIFIP2PMATCH_NEXTBATTLE_WAIT,
  WIFIP2PMATCH_MODE_VCHAT_NEGO,
  WIFIP2PMATCH_MODE_VCHAT_NEGO_WAIT,
  WIFIP2PMATCH_RECONECTING_WAIT,
  WIFIP2PMATCH_MODE_BCANCEL_YESNO_VCT,
  WIFIP2PMATCH_MODE_BCANCEL_WAIT_VCT,
};


enum{
	WIFIP2PMATCH_SYNCHRONIZE_END=201,
};

// ㉺ʎw`
#define BOTH_LCD	( 2 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB

// BMPWINw
enum{
	BMP_NAME1_S_BG0,
	BMP_NAME2_S_BG0,
	BMP_NAME3_S_BG0,
	BMP_NAME4_S_BG0,
	BMP_NAME5_S_BG0,
	BMP_WIFIP2PMATCH_MAX,
};


//---------------WIFISTATUSf[^

typedef enum{
  WIFI_STATUS_NONE,   // 
  WIFI_STATUS_VCT,      // VCT
  WIFI_STATUS_SBATTLE50,      // VOΐ풆
  WIFI_STATUS_SBATTLE100,      // VOΐ풆
  WIFI_STATUS_SBATTLE_FREE,      // VOΐ풆
  WIFI_STATUS_DBATTLE50,      // _uΐ풆
  WIFI_STATUS_DBATTLE100,      // _uΐ풆
  WIFI_STATUS_DBATTLE_FREE,      // _uΐ풆
  WIFI_STATUS_TRADE,          // 
  WIFI_STATUS_SBATTLE50_WAIT,   // VOLv50ΐW
  WIFI_STATUS_SBATTLE100_WAIT,   // VOLv100ΐW
  WIFI_STATUS_SBATTLE_FREE_WAIT,   // VOLv100ΐW
  WIFI_STATUS_DBATTLE50_WAIT,   // _uLv50ΐW
  WIFI_STATUS_DBATTLE100_WAIT,   // _uLv100ΐW
  WIFI_STATUS_DBATTLE_FREE_WAIT,   // _uLv100ΐW
  WIFI_STATUS_TRADE_WAIT,    // W
  WIFI_STATUS_LOGIN_WAIT,    // ҋ@@OC͂
  WIFI_STATUS_UNKNOWN,   // Vɍ炱̔ԍȏɂȂ
};

typedef enum{
  _REGULATION_BATTLE_TOWER     // og^[ΐ
};


//g[^189oCgMł邪Ƃ肠ʃvO͔͈͕
#define _POKEMON_NUM   (6)


typedef struct{
  u16 pokemonType[_POKEMON_NUM];
  u16 hasItemType[_POKEMON_NUM];
  u8 version;
  u8 regionCode;
  u8 pokemonZukan;
  u8 status;
  u8 regulation;
  u8 trainer_view;
  u8 sex;
  u8 nation;
  u8 area;
  u8 vchat;
  u8 vchat_org;
} _WIFI_MACH_STATUS;

#define _WIFI_STATUS_MAX_SIZE  (sizeof(_WIFI_MACH_STATUS))

//============================================================================================
//	\̒`
//============================================================================================

typedef struct {
  _WIFI_MACH_STATUS myMatchStatus;   // ̃}b`Oԃf[^
  _WIFI_MACH_STATUS friendMatchStatus[WIFIP2PMATCH_MEMBER_MAX]; // ̃}b`Oԃf[^
} TEST_MATCH_WORK;


struct _WIFIP2PMATCH_WORK{
  WIFI_LIST* pList;
  TEST_MATCH_WORK* pMatch;
  int friendMatchReadCount;
  u8 index2No[WIFIP2PMATCH_MEMBER_MAX];
  int matchStatusBackup[WIFIP2PMATCH_MEMBER_MAX];
  NAMEIN_PARAM*		nameinParam;
  BMPLIST_DATA*   menulist;
  BMPLIST_WORK* lw;		// BMPj[[N
  BMPLIST_DATA*   submenulist;
  BMPLIST_WORK* sublw;		// BMPj[[N
  GF_BGL_INI		*bgl;									// GF_BGL_INI
  SAVEDATA*  pSaveData;
  WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
  MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
  MSGDATA_MANAGER *SysMsgManager;  //
  STRBUF			*TrainerName[WIFIP2PMATCH_MEMBER_MAX];		// O
  STRBUF			*MsgString;								// bZ[W
  STRBUF*         pExpStrBuf;
  STRBUF			*TalkString;							// bbZ[Wp
  STRBUF			*TitleString;							// ^CgbZ[Wp
  STRBUF			*MenuString[4];							// j[bZ[Wp
  STRBUF*         pTemp;        // ͓o^̈ꎞobt@
  
  int				MsgIndex;								// Iop[N
  BMPMENU_WORK* pYesNoWork;
  void* timeWaitWork;
  CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
  CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
  CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
  CLACT_U_RES_OBJ_PTR 	resObjTbl[BOTH_LCD][CLACT_RESOURCE_NUM];// \[XIuWFe[u
  CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
  CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
  CLACT_WORK_PTR			MainActWork[_OAM_NUM];				// ZAN^[[N|C^z
	//CLACT_WORK_PTR			SubActWork[_OAM_NUM];				// ZAN^[[N|C^z

  GF_BGL_BMPWIN			MsgWin;									// bEChE
  //   GF_BGL_BMPWIN           MenuWin[4];
  GF_BGL_BMPWIN			MyInfoWin;									// ߂
  GF_BGL_BMPWIN			TitleWin;								// uR[hR[i[@ڂイイIvȂ
  GF_BGL_BMPWIN			SysMsgWin;								// uR[hR[i[@ڂイイIvȂ
  GF_BGL_BMPWIN			ListWin;									// ߂
  GF_BGL_BMPWIN			SubListWin;									// ߂
  GF_BGL_BMPWIN			MyWin;									// ߂

  int localTime;
  int seq;									// ݂̕͏ԁiOK/AjjȂ
  int       endSeq;
  int						nextseq;
  int initSeq;
  int						mode;									// ݍőOʂ̕pl
  int						timer;
  MYSTATUS                *pMyStatus;
  u8     mainCur;
  u8     subCur;
  BOOL bInitMessage;
  PROC*		subProc;
  int preConnect;
  u16 battleCur;
  u16 singleCur[2];
  u16 bSingle;
  u16 keepStatus;
  u16 keepVChat;
  u16 friendNo;
  BOOL bRetryBattle;
};




#endif  //__WIFI_P2PMATCH_LOCAL_H__

